/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.campaign.CUnit;
import client.gui.SpringLayoutHelper;
import common.House;
import common.Planet;
import common.Unit;
import common.UnitFactory;
import common.util.UnitUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;

public final class RewardPointsDialog
implements ActionListener,
KeyListener {
    private MWClient mwclient = null;
    private static final String okayCommand = "Okay";
    private static final String cancelCommand = "Cancel";
    private static final String unitCommand = "Units";
    private static final String weightCommand = "Weight";
    private static final String rewardCommand = "Reward";
    private static final String factionCommand = "House";
    private static final String repodCommand = "Repod";
    private static final String refreshCommand = "Refresh";
    private static final String techComboCommand = "TechCombo";
    private static final String repairCommand = "Repair";
    private static final String windowName = "Reward Points";
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final JLabel costLabel = new JLabel();
    private final JLabel rewardLabel = new JLabel("Reward Type:", 11);
    private final JLabel factionLabel = new JLabel("House Table:", 11);
    private final JLabel unitLabel = new JLabel("Unit Type:", 11);
    private final JLabel weightLabel = new JLabel("Weight Class:", 11);
    private final JLabel repodLabel = new JLabel("Repod Selection:", 11);
    private final JLabel pUnitsLabel = new JLabel("Unit:", 11);
    private final JLabel refreshLabel = new JLabel("Refresh:", 11);
    private final JLabel techComboLabel = new JLabel("Tech Type:", 11);
    private final JLabel repairLabel = new JLabel("Repair:", 11);
    private JComboBox unitComboBox = new JComboBox();
    private final String[] weightChoices = new String[]{"Light", "Medium", "Heavy", "Assault"};
    private final JComboBox weightComboBox = new JComboBox<String>(this.weightChoices);
    private JComboBox rewardsComboBox = new JComboBox();
    private JComboBox factionComboBox = new JComboBox();
    private JComboBox repodComboBox = new JComboBox();
    private JComboBox pUnitsComboBox = new JComboBox();
    private JComboBox refreshComboBox = new JComboBox();
    private JComboBox repairComboBox = new JComboBox();
    private final String[] techChoices = new String[]{"Green", "Reg", "Vet", "Elite"};
    private final JComboBox techComboBox = new JComboBox<String>(this.techChoices);
    private final JTextField amountText = new JTextField(5);
    private final JLabel amountLabel = new JLabel("RP to use:", 11);
    int cost = 0;
    private JDialog dialog;
    private JOptionPane pane;
    JTabbedPane ConfigPane = new JTabbedPane(1);

    public RewardPointsDialog(MWClient c) {
        this.mwclient = c;
        TreeSet<String> names = new TreeSet<String>();
        names.add("Common");
        Iterator<House> factions = this.mwclient.getData().getAllHouses().iterator();
        while (factions.hasNext()) {
            names.add(factions.next().getName());
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowRareUnitsForRewards"))) {
            names.add("Rare");
        }
        this.factionComboBox = new JComboBox<Object>(names.toArray());
        names = new TreeSet();
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowTechsForRewards"))) {
            names.add("Techs");
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowInfluenceForRewards"))) {
            names.add(this.mwclient.getserverConfigs("FluLongName"));
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowUnitsForRewards"))) {
            names.add(unitCommand);
            Vector<String> unitList = new Vector<String>(5);
            unitList.add("Mek");
            if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseVehicle"))) {
                unitList.add("Vehicle");
            }
            if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseInfantry"))) {
                unitList.add("Infantry");
            }
            if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseProtoMek"))) {
                unitList.add("ProtoMek");
            }
            if (Boolean.parseBoolean(this.mwclient.getserverConfigs("UseBattleArmor"))) {
                unitList.add("BattleArmor");
            }
            this.unitComboBox = new JComboBox<Object>(unitList.toArray());
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("GlobalRepodAllowed"))) {
            names.add(repodCommand);
            TreeSet<String> repodOptions = new TreeSet<String>();
            if (Boolean.parseBoolean(this.mwclient.getserverConfigs("RandomRepodOnly"))) {
                repodOptions.add("Random");
            } else {
                if (Boolean.parseBoolean(this.mwclient.getserverConfigs("RandomRepodAllowed"))) {
                    repodOptions.add("Random");
                }
                repodOptions.add("Select");
            }
            this.repodComboBox = new JComboBox<Object>(repodOptions.toArray());
            repodOptions.clear();
            for (CUnit unit : c.getPlayer().getHangar()) {
                if (!unit.isOmni()) continue;
                repodOptions.add("#" + unit.getId() + " " + unit.getModelName());
            }
            this.pUnitsComboBox = new JComboBox<Object>(repodOptions.toArray());
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowRepairsForRewards"))) {
            names.add(repairCommand);
            TreeSet<String> damagedUnits = new TreeSet<String>();
            for (CUnit unit : this.mwclient.getPlayer().getHangar()) {
                if (!UnitUtils.hasArmorDamage(unit.getEntity()) && !UnitUtils.hasCriticalDamage(unit.getEntity())) continue;
                damagedUnits.add("#" + unit.getId() + " " + unit.getModelName());
            }
            this.repairComboBox = new JComboBox<Object>(damagedUnits.toArray());
        }
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowFactoryRefreshForRewards"))) {
            TreeSet<String> factories = new TreeSet<String>();
            House faction = this.mwclient.getData().getHouseByName(this.mwclient.getPlayer().getHouse());
            Iterator<Planet> planets = this.mwclient.getData().getAllPlanets().iterator();
            names.add(refreshCommand);
            while (planets.hasNext()) {
                Planet planet = planets.next();
                if (!planet.isOwner(faction.getId())) continue;
                for (UnitFactory factory : planet.getUnitFactories()) {
                    if (factory.getTicksUntilRefresh() <= 0) continue;
                    factories.add(planet.getName() + ": " + factory.getName() + "(" + factory.getTicksUntilRefresh() + ")");
                }
            }
            this.refreshComboBox = new JComboBox<Object>(factories.toArray());
        }
        this.rewardsComboBox = new JComboBox<Object>(names.toArray());
        this.cost = 0;
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.factionComboBox.setActionCommand(factionCommand);
        this.rewardsComboBox.setActionCommand(rewardCommand);
        this.weightComboBox.setActionCommand(weightCommand);
        this.unitComboBox.setActionCommand(unitCommand);
        this.repodComboBox.setActionCommand(repodCommand);
        this.refreshComboBox.setActionCommand(refreshCommand);
        this.techComboBox.setActionCommand(techComboCommand);
        this.repairComboBox.setActionCommand(repairCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okayButton.setToolTipText("Save Options");
        this.cancelButton.setToolTipText("Exit without saving changes");
        this.factionComboBox.addActionListener(this);
        this.rewardsComboBox.addActionListener(this);
        this.weightComboBox.addActionListener(this);
        this.unitComboBox.addActionListener(this);
        this.repodComboBox.addActionListener(this);
        this.pUnitsComboBox.addActionListener(this);
        this.refreshComboBox.addActionListener(this);
        this.techComboBox.addActionListener(this);
        this.repairComboBox.addActionListener(this);
        this.amountText.addKeyListener(this);
        JPanel rewardPanel = new JPanel();
        rewardPanel.setLayout(new BoxLayout(rewardPanel, 1));
        JPanel comboPanel = new JPanel(new SpringLayout());
        JPanel costPanel = new JPanel();
        comboPanel.add(this.rewardLabel);
        this.rewardsComboBox.setToolTipText("Select your Reward Type");
        comboPanel.add(this.rewardsComboBox);
        comboPanel.add(this.factionLabel);
        this.factionComboBox.setToolTipText("Select the faction build table you wish to use");
        comboPanel.add(this.factionComboBox);
        comboPanel.add(this.unitLabel);
        this.unitComboBox.setToolTipText("Select the Unit Type");
        comboPanel.add(this.unitComboBox);
        comboPanel.add(this.weightLabel);
        this.weightComboBox.setToolTipText("Unit Weight Class");
        comboPanel.add(this.weightComboBox);
        comboPanel.add(this.pUnitsLabel);
        this.pUnitsComboBox.setToolTipText("Unit");
        comboPanel.add(this.pUnitsComboBox);
        comboPanel.add(this.repodLabel);
        this.repodComboBox.setToolTipText("Repod Selection Type");
        comboPanel.add(this.repodComboBox);
        comboPanel.add(this.refreshLabel);
        this.refreshComboBox.setToolTipText("Refresh Factory");
        comboPanel.add(this.refreshComboBox);
        if (this.mwclient.isUsingAdvanceRepairs()) {
            comboPanel.add(this.techComboLabel);
            this.techComboBox.setToolTipText("Tech Selection Type");
            this.techComboBox.setSelectedIndex(0);
            comboPanel.add(this.techComboBox);
        }
        comboPanel.add(this.repairLabel);
        this.repairComboBox.setToolTipText("Repair Unit with RPs");
        comboPanel.add(this.repairComboBox);
        comboPanel.add(this.amountLabel);
        comboPanel.add(this.amountText);
        SpringLayoutHelper.setupSpringGrid(comboPanel, 2);
        rewardPanel.add(comboPanel);
        costPanel.add(this.costLabel);
        rewardPanel.add(costPanel);
        this.costLabel.setText("Result: no expenditure");
        try {
            this.factionComboBox.setSelectedItem(this.mwclient.getPlayer().getHouse());
        }
        catch (Exception ex) {
            this.factionComboBox.setSelectedIndex(0);
        }
        this.techComboBox.setSelectedIndex(0);
        if (Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowUnitsForRewards"))) {
            this.rewardsComboBox.setSelectedItem(unitCommand);
            this.weightComboBox.setSelectedIndex(0);
            this.unitComboBox.setSelectedIndex(0);
        } else {
            this.rewardsComboBox.setSelectedIndex(0);
        }
        JPanel mainPanel = new JPanel();
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(rewardPanel, -1, -1, null, options, null);
        this.dialog = this.pane.createDialog(mainPanel, windowName);
        this.dialog.getRootPane().setDefaultButton(this.cancelButton);
        this.dialog.setLocation(Math.max(this.mwclient.getMainFrame().getLocation().x, this.mwclient.getMainFrame().getLocation().x + (this.mwclient.getMainFrame().getWidth() / 2 - this.dialog.getWidth() / 2)), Math.max(this.mwclient.getMainFrame().getLocation().y + this.mwclient.getMainFrame().getHeight() / 2 - this.dialog.getHeight() / 2, this.mwclient.getMainFrame().getLocation().y));
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
        if (this.pane.getValue() != this.okayButton) {
            this.dialog.dispose();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        String selection = (String)this.rewardsComboBox.getSelectedItem();
        this.cost = Integer.parseInt(this.amountText.getText());
        if (!selection.equals(unitCommand)) {
            if (selection.equals("Techs")) {
                if (!this.mwclient.isUsingAdvanceRepairs()) {
                    int total = this.cost * Integer.parseInt(this.mwclient.getserverConfigs("TechsForARewardPoint"));
                    this.costLabel.setText("Result: Hire " + total + " Techs");
                }
            } else if (selection.equals(repodCommand)) {
                this.cost = Integer.parseInt(this.mwclient.getserverConfigs("GlobalRepodWithRPCost"));
                if (((String)this.repodComboBox.getSelectedItem()).equals("Random")) {
                    this.cost /= 2;
                }
                this.costLabel.setText("RP Required: " + this.cost + " RP");
            } else if (selection.equals(refreshCommand)) {
                this.cost = Integer.parseInt(this.mwclient.getserverConfigs("RewardPointToRefreshFactory"));
                this.costLabel.setText("RP Required: " + this.cost + " RP");
                this.dialog.repaint();
            } else {
                int total = this.cost * Integer.parseInt(this.mwclient.getserverConfigs("InfluenceForARewardPoint"));
                this.costLabel.setText("Result: Gain " + this.mwclient.moneyOrFluMessage(false, true, total));
            }
        }
    }

    public void keyPressed(KeyEvent e) {
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            String selection = (String)this.rewardsComboBox.getSelectedItem();
            if (selection.equals(unitCommand)) {
                String type = (String)this.unitComboBox.getSelectedItem();
                String weight = (String)this.weightComboBox.getSelectedItem();
                String faction = (String)this.factionComboBox.getSelectedItem();
                this.mwclient.sendChat("/c userewardpoints#2#" + type + "#" + weight + "#" + faction);
            } else if (selection.equals("Techs")) {
                if (this.mwclient.isUsingAdvanceRepairs()) {
                    this.mwclient.sendChat("/c userewardpoints#0#" + this.techComboBox.getSelectedIndex());
                } else {
                    this.mwclient.sendChat("/c userewardpoints#0#" + this.amountText.getText());
                }
            } else if (selection.equals(repodCommand)) {
                if (this.pUnitsComboBox.getComponentCount() < 1) {
                    this.dialog.dispose();
                }
                String options = "#GLOBAL";
                if (((String)this.repodComboBox.getSelectedItem()).equals("Random")) {
                    options = options + "#RANDOM";
                }
                StringTokenizer unitid = new StringTokenizer((String)this.pUnitsComboBox.getSelectedItem(), " ");
                this.mwclient.sendChat("/c repod" + unitid.nextToken() + options);
            } else if (selection.equals(refreshCommand)) {
                if (this.refreshComboBox.getComponentCount() < 1) {
                    this.dialog.dispose();
                }
                String factoryInfo = (String)this.refreshComboBox.getSelectedItem();
                String planet = factoryInfo.substring(0, factoryInfo.indexOf(":")).trim();
                String factory = factoryInfo.substring(planet.length() + 2, factoryInfo.indexOf("(")).trim();
                this.mwclient.sendChat("/c refreshFactory#" + planet + "#" + factory);
            } else if (selection.equals(repairCommand)) {
                String selectionName = (String)this.repairComboBox.getSelectedItem();
                this.mwclient.sendChat("/c userewardpoints#3#" + selectionName.trim().substring(0, selectionName.indexOf(" ")));
            } else {
                this.mwclient.sendChat("/c userewardpoints#1#" + this.amountText.getText());
            }
            this.dialog.dispose();
        } else if (command.equals(cancelCommand)) {
            this.pane.setValue(this.cancelButton);
            this.dialog.dispose();
        } else if (command.equals(rewardCommand)) {
            String selection = (String)this.rewardsComboBox.getSelectedItem();
            if (selection.equals(unitCommand)) {
                this.makeVisible(true, false, false);
                this.unitComboBox.setSelectedIndex(0);
                this.weightComboBox.setSelectedIndex(0);
                try {
                    this.factionComboBox.setSelectedItem(this.mwclient.getPlayer().getHouse());
                }
                catch (Exception ex) {
                    this.factionComboBox.setSelectedIndex(0);
                }
                this.cost = this.getUnitRPCost();
                this.costLabel.setText("RP Required: " + this.cost + " RP");
            } else if (selection.equals("Techs")) {
                this.makeVisible(false, false, false);
                if (this.mwclient.isUsingAdvanceRepairs()) {
                    int type = this.techComboBox.getSelectedIndex();
                    int total = Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsFor" + UnitUtils.techDescription(type)));
                    this.costLabel.setText("Hire 1 " + UnitUtils.techDescription(type) + " tech for " + total + "rp");
                    this.techComboBox.setVisible(true);
                    this.techComboLabel.setVisible(true);
                    this.amountText.setVisible(false);
                    this.amountLabel.setVisible(false);
                } else {
                    this.amountText.setText("0");
                    this.cost = Integer.parseInt(this.amountText.getText());
                    int total = this.cost * Integer.parseInt(this.mwclient.getserverConfigs("TechsForARewardPoint"));
                    this.costLabel.setText("Result: Hire " + total + " Techs");
                    this.costLabel.repaint();
                }
            } else if (selection.equals(repodCommand)) {
                if (this.pUnitsComboBox.getItemCount() >= 1) {
                    this.pUnitsComboBox.setSelectedIndex(0);
                }
                this.cost = Integer.parseInt(this.mwclient.getserverConfigs("GlobalRepodWithRPCost"));
                if (((String)this.repodComboBox.getSelectedItem()).equals("Random")) {
                    this.cost /= 2;
                }
                this.costLabel.setText("RP Required: " + this.cost + " RP");
                this.makeVisible(false, true, false);
            } else if (selection.equals(refreshCommand)) {
                if (this.refreshComboBox.getItemCount() >= 1) {
                    this.refreshComboBox.setSelectedIndex(0);
                }
                this.cost = Integer.parseInt(this.mwclient.getserverConfigs("RewardPointToRefreshFactory"));
                this.costLabel.setText("RP Required: " + this.cost + " RP");
                this.makeVisible(false, false, true);
            } else if (selection.equals(repairCommand)) {
                this.makeVisible(false, false, false);
                if (this.repairComboBox.getItemCount() > 0) {
                    this.repairComboBox.setSelectedIndex(0);
                }
                this.costLabel.setText("Repair Cost: " + this.mwclient.getserverConfigs("RewardPointsForRepair"));
                this.repairComboBox.setVisible(true);
                this.repairLabel.setVisible(true);
                this.amountText.setVisible(false);
                this.amountLabel.setVisible(false);
            } else {
                this.amountText.setText("0");
                this.cost = Integer.parseInt(this.amountText.getText());
                int total = this.cost * Integer.parseInt(this.mwclient.getserverConfigs("InfluenceForARewardPoint"));
                this.costLabel.setText("Result: Gain " + this.mwclient.moneyOrFluMessage(false, true, total));
                this.makeVisible(false, false, false);
            }
        } else if (command.equals(repodCommand)) {
            this.cost = Integer.parseInt(this.mwclient.getserverConfigs("GlobalRepodWithRPCost"));
            if (((String)this.repodComboBox.getSelectedItem()).equals("Random")) {
                this.cost /= 2;
            }
            this.costLabel.setText("RP Required: " + this.cost + " RP");
        } else if (command.equals(weightCommand) || command.equals(unitCommand) || command.equals(factionCommand)) {
            this.cost = this.getUnitRPCost();
            this.costLabel.setText("RP Required: " + this.cost + " RP");
        } else if (command.equals(techComboCommand)) {
            this.makeVisible(false, false, false);
            int type = this.techComboBox.getSelectedIndex();
            int total = Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsFor" + UnitUtils.techDescription(type)));
            this.costLabel.setText("Hire 1 " + UnitUtils.techDescription(type) + " tech for " + total + "rp");
            this.techComboBox.setVisible(true);
            this.techComboLabel.setVisible(true);
            this.amountText.setVisible(false);
            this.amountLabel.setVisible(false);
        } else if (command.equals(repairCommand)) {
            this.makeVisible(false, false, false);
            this.costLabel.setText("Repair Cost: " + this.mwclient.getserverConfigs("RewardPointsForRepair"));
            this.repairComboBox.setVisible(true);
            this.repairLabel.setVisible(true);
            this.amountText.setVisible(false);
            this.amountLabel.setVisible(false);
        }
    }

    private void makeVisible(boolean visible, boolean repod, boolean refresh) {
        this.unitComboBox.setVisible(visible);
        this.weightComboBox.setVisible(visible);
        this.factionComboBox.setVisible(visible);
        this.unitLabel.setVisible(visible);
        this.weightLabel.setVisible(visible);
        this.factionLabel.setVisible(visible);
        this.repodComboBox.setVisible(repod);
        this.repodLabel.setVisible(repod);
        this.pUnitsComboBox.setVisible(repod);
        this.pUnitsLabel.setVisible(repod);
        this.refreshComboBox.setVisible(refresh);
        this.refreshLabel.setVisible(refresh);
        if (repod || refresh) {
            this.amountLabel.setVisible(false);
            this.amountText.setVisible(false);
        } else {
            this.amountLabel.setVisible(!visible);
            this.amountText.setVisible(!visible);
        }
        this.techComboBox.setVisible(false);
        this.techComboLabel.setVisible(false);
        this.repairComboBox.setVisible(false);
        this.repairLabel.setVisible(false);
    }

    private int getUnitRPCost() {
        if (!Boolean.parseBoolean(this.mwclient.getserverConfigs("AllowUnitsForRewards"))) {
            return 0;
        }
        int type = Unit.getTypeIDForName((String)this.unitComboBox.getSelectedItem());
        int weight = Unit.getWeightIDForName((String)this.weightComboBox.getSelectedItem());
        String House2 = (String)this.factionComboBox.getSelectedItem();
        int cost = 0;
        cost = type == 0 ? Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForAMek")) : (type == 1 ? Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForAVeh")) : (type == 2 ? Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForInf")) : (type == 3 ? Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForProto")) : Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForBA")))));
        if (weight == 0) {
            cost += Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForALight"));
        } else if (weight == 1) {
            cost += Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForAMed"));
        } else if (weight == 2) {
            cost += Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForAHeavy"));
        } else if (weight == 3) {
            cost += Integer.parseInt(this.mwclient.getserverConfigs("RewardPointsForAnAssault"));
        }
        if (House2.equals("Rare")) {
            cost = (int)((double)cost * Double.parseDouble(this.mwclient.getserverConfigs("RewardPointMultiplierForRare")));
        } else if (!House2.equals("Common") && !House2.equals(this.mwclient.getPlayer().getHouse())) {
            cost = (int)((double)cost * Double.parseDouble(this.mwclient.getserverConfigs("RewardPointNonHouseMultiplier")));
        }
        return cost;
    }
}

