/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentMode;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Protomech;
import megamek.common.Tank;

class SystemPanel
extends JPanel
implements ListSelectionListener {
    private static Object SYSTEM = new Object();
    public JLabel locLabel;
    public JLabel slotLabel;
    public JList slotList;
    public JList locList;
    private Vector equipment = new Vector(16);
    public JLabel modeLabel;
    public JComboBox modeList;
    Entity en;

    public SystemPanel() {
        this.locLabel = new JLabel("Location", 0);
        this.slotLabel = new JLabel("Slot", 0);
        this.locList = new JList();
        this.locList.setVisibleRowCount(8);
        this.locList.addListSelectionListener(this);
        this.slotList = new JList();
        this.slotList.setVisibleRowCount(12);
        this.slotList.addListSelectionListener(this);
        this.modeLabel = new JLabel("Mode", 2);
        this.modeLabel.setEnabled(false);
        this.modeList = new JComboBox();
        this.modeList.setEnabled(false);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.setLayout(gridbag);
        c.fill = 1;
        c.insets = new Insets(1, 1, 1, 1);
        c.weightx = 0.5;
        c.weighty = 0.0;
        c.gridwidth = 1;
        this.add((Component)this.locLabel, c);
        c.weightx = 1.0;
        c.gridwidth = 0;
        this.add((Component)this.slotLabel, c);
        c.weightx = 0.5;
        c.weighty = 1.0;
        c.gridwidth = 1;
        c.gridheight = 0;
        this.add((Component)new JScrollPane(this.locList), c);
        c.gridwidth = 0;
        c.gridheight = 2;
        c.gridx = 1;
        c.weightx = 1.0;
        c.weighty = 1.0;
        this.add((Component)new JScrollPane(this.slotList), c);
        JPanel p = new JPanel(new GridBagLayout());
        c.gridx = 1;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.gridheight = 1;
        c.gridwidth = 0;
        this.add((Component)p, c);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.weightx = 0.0;
        c.weighty = 1.0;
        p.add((Component)this.modeLabel, c);
        c.gridx = 1;
        c.weightx = 1.0;
        p.add(this.modeList);
    }

    public Mounted getSelectedEquipment() {
        int n = this.slotList.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        Object o = this.equipment.elementAt(n);
        if (o == SYSTEM) {
            return null;
        }
        return (Mounted)o;
    }

    public void displayMech(Entity ent) {
        this.en = ent;
        this.locList.removeAll();
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < this.en.locations(); ++i) {
            if (this.en.getNumberOfCriticals(i) <= 0) continue;
            data.add(this.en.getLocationName(i));
        }
        this.locList.setListData(data.toArray());
        this.locList.setSelectedIndex(0);
        this.displaySlots();
    }

    public void displaySlots() {
        StringBuilder sb;
        int loc = this.locList.getSelectedIndex();
        this.slotList.removeAll();
        this.equipment = new Vector(16);
        ArrayList<String> data = new ArrayList<String>();
        for (int i = 0; i < this.en.getNumberOfCriticals(loc); ++i) {
            CriticalSlot cs = this.en.getCritical(loc, i);
            sb = new StringBuilder(32);
            if (cs == null) {
                sb.append("---");
                this.equipment.addElement(SYSTEM);
            } else {
                switch (cs.getType()) {
                    case 0: {
                        sb.append(cs.isDestroyed() ? "*" : "");
                        if (this.en instanceof Protomech) {
                            sb.append(Protomech.systemNames[cs.getIndex()]);
                        } else {
                            sb.append(Mech.systemNames[cs.getIndex()]);
                        }
                        this.equipment.addElement(SYSTEM);
                        break;
                    }
                    case 1: {
                        Mounted m = this.en.getEquipment(cs.getIndex());
                        sb.append(cs.isDestroyed() ? "*" : "").append(m.getDesc());
                        if (m.getType().hasModes()) {
                            sb.append(" (").append(m.curMode().getDisplayableName()).append(")");
                        }
                        this.equipment.addElement(m);
                    }
                }
            }
            data.add(sb.toString());
        }
        if (this.en instanceof Tank && this.en.hasTargComp()) {
            for (Mounted m : this.en.getEquipment()) {
                if (!(m.getType() instanceof MiscType) || !m.getType().hasFlag(2048L)) continue;
                sb = new StringBuilder(32);
                sb.append(m.isDestroyed() ? "*" : "").append(m.isBreached() ? "x" : "").append(m.getDesc());
                if (m.getType().hasModes()) {
                    sb.append(" (").append(m.curMode().getDisplayableName()).append(")");
                }
                data.add(sb.toString());
            }
        }
        this.slotList.setListData(data.toArray());
    }

    public void valueChanged(ListSelectionEvent ev) {
        if (ev.getSource() == this.locList) {
            this.displaySlots();
        } else if (ev.getSource() == this.slotList) {
            Mounted m = this.getSelectedEquipment();
            if (m != null && m.getType().hasModes()) {
                this.modeLabel.setEnabled(true);
                this.modeList.setEnabled(true);
                this.modeList.removeAllItems();
                Enumeration e = m.getType().getModes();
                while (e.hasMoreElements()) {
                    EquipmentMode em = (EquipmentMode)e.nextElement();
                    this.modeList.addItem(em.getDisplayableName());
                }
            } else {
                this.modeLabel.setEnabled(false);
                this.modeList.setEnabled(false);
            }
        }
    }
}

