/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import client.campaign.CUnit;
import client.gui.SpringLayoutHelper;
import client.gui.TableSorter;
import client.gui.dialog.MechDetailDisplay;
import client.util.CUnitComparator;
import common.House;
import common.campaign.pilot.Pilot;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SpringLayout;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import megamek.common.Entity;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;

public class TableViewerDialog
extends JFrame
implements ItemListener {
    JComboBox weightClassCombo;
    JComboBox factionCombo;
    JComboBox unitTypeCombo;
    JLabel factionLabel = new JLabel("Faction: ", 4);
    JLabel typeLabel = new JLabel("Type: ", 4);
    JLabel weightLabel = new JLabel("Class: ", 4);
    JLabel percentageLabel = new JLabel("Total Percentage: ", 0);
    Object[] factionArray;
    String[] unitTypeArray = new String[]{"Mek", "Vehicle", "BattleArmor", "Infantry", "ProtoMek"};
    String[] weightClassArray = new String[]{"Light", "Medium", "Heavy", "Assault"};
    int factionSort = 0;
    int unitSort = 0;
    int weightSort = 0;
    JTable generalTable = new JTable();
    JScrollPane generalScrollPane = new JScrollPane();
    JButton closeButton = new JButton("Close");
    TableViewerModel tvModel;
    TreeMap currentUnits;
    Object[] sortedUnits = new Object[0];
    MWClient mwclient;

    public TableViewerDialog(MWClient client) {
        super("Table Browser");
        String previousItem;
        this.mwclient = client;
        this.currentUnits = new TreeMap();
        this.generalScrollPane = new JScrollPane();
        TreeSet<String> factionNames = new TreeSet<String>();
        Iterator<House> i = this.mwclient.getData().getAllHouses().iterator();
        while (i.hasNext()) {
            factionNames.add(i.next().getName());
        }
        this.factionArray = factionNames.toArray();
        this.weightClassCombo = new JComboBox<String>(this.weightClassArray);
        this.factionCombo = new JComboBox<Object>(this.factionArray);
        this.unitTypeCombo = new JComboBox<String>(this.unitTypeArray);
        Dimension comboDim = new Dimension();
        comboDim.setSize(this.factionCombo.getMinimumSize().getWidth() * 1.5, this.factionLabel.getMinimumSize().getHeight() + 2.0);
        this.factionCombo.setAlignmentX(0.5f);
        this.factionCombo.setMaximumSize(comboDim);
        this.weightClassCombo.setAlignmentX(0.5f);
        this.weightClassCombo.setMaximumSize(comboDim);
        this.unitTypeCombo.setAlignmentX(0.5f);
        this.unitTypeCombo.setMaximumSize(comboDim);
        JPanel comboPanel = new JPanel(new SpringLayout());
        comboPanel.add(this.factionLabel);
        comboPanel.add(this.factionCombo);
        comboPanel.add(this.typeLabel);
        comboPanel.add(this.unitTypeCombo);
        comboPanel.add(this.weightLabel);
        comboPanel.add(this.weightClassCombo);
        SpringLayoutHelper.setupSpringGrid(comboPanel, 3, 2);
        try {
            previousItem = this.mwclient.getConfigParam("TABLEVIEWERFACTION");
            this.factionCombo.setSelectedItem(previousItem);
        }
        catch (Exception e) {
            this.factionCombo.setSelectedItem(this.mwclient.getPlayer().getHouse());
        }
        try {
            previousItem = this.mwclient.getConfigParam("TABLEVIEWERTYPE");
            this.unitTypeCombo.setSelectedItem(previousItem);
        }
        catch (Exception e) {
            this.factionCombo.setSelectedIndex(-1);
        }
        try {
            previousItem = this.mwclient.getConfigParam("TALEVIEWERWEIGHT");
            this.weightClassCombo.setSelectedItem(previousItem);
        }
        catch (Exception e) {
            this.factionCombo.setSelectedIndex(-1);
        }
        this.factionCombo.addItemListener(this);
        this.unitTypeCombo.addItemListener(this);
        this.weightClassCombo.addItemListener(this);
        this.closeButton.setAlignmentX(0.5f);
        this.closeButton.setAlignmentY(0.5f);
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TableViewerDialog.this.dispose();
            }
        });
        this.tvModel = new TableViewerModel(this.mwclient, this.currentUnits, this.sortedUnits);
        TableSorter sorter = new TableSorter(this.tvModel, client, 1);
        this.generalTable.setModel(sorter);
        this.generalTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    TableUnit u = TableViewerDialog.this.getUnitAtRow(TableViewerDialog.this.generalTable.getSelectedRow());
                    if (u == null) {
                        return;
                    }
                    Entity theEntity = u.getEntity();
                    theEntity.loadAllWeapons();
                    JFrame InfoWindow = new JFrame();
                    MechDetailDisplay MechDetailInfo = new MechDetailDisplay();
                    InfoWindow.getContentPane().add(MechDetailInfo);
                    InfoWindow.setSize(220, 400);
                    InfoWindow.setResizable(false);
                    MechDetailInfo.displayEntity(theEntity, theEntity.calculateBattleValue(), TableViewerDialog.this.mwclient.getConfig().getImage("CAMO"));
                    InfoWindow.setTitle(u.getModelName());
                    InfoWindow.setLocationRelativeTo(null);
                    InfoWindow.setVisible(true);
                }
            }
        });
        for (int j = 0; j < this.tvModel.getColumnCount(); ++j) {
            this.generalTable.getColumnModel().getColumn(j).setCellRenderer(this.tvModel.getRenderer());
        }
        sorter.addMouseListenerToHeaderInTable(this.generalTable);
        this.generalTable.setSelectionMode(0);
        this.generalTable.setDoubleBuffered(true);
        this.generalScrollPane.setToolTipText("Click on column header to sort.");
        this.generalScrollPane.setViewportView(this.generalTable);
        this.generalScrollPane.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0), BorderFactory.createLineBorder(Color.BLACK, 1)));
        JPanel boxPanel = new JPanel();
        boxPanel.setLayout(new BoxLayout(boxPanel, 1));
        this.percentageLabel.setAlignmentX(0.5f);
        this.percentageLabel.setAlignmentY(0.5f);
        this.percentageLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
        boxPanel.add(comboPanel);
        boxPanel.add(this.generalScrollPane);
        boxPanel.add(this.percentageLabel);
        boxPanel.add(this.closeButton);
        boxPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        this.getContentPane().add(boxPanel);
        this.loadTables();
        this.refresh();
        this.setVisible(true);
    }

    public void refresh() {
        this.tvModel.refreshModel();
        this.generalTable.setPreferredSize(new Dimension(this.generalTable.getWidth(), this.generalTable.getRowHeight() * this.generalTable.getRowCount()));
        this.generalTable.revalidate();
    }

    public void setVisible(boolean show) {
        this.pack();
        this.setLocationRelativeTo(null);
        this.setSize(720, 575);
        this.setResizable(false);
        super.setVisible(show);
    }

    public TableUnit getUnitAtRow(int row) {
        String filename = (String)this.generalTable.getModel().getValueAt(row, 4);
        if (filename != null) {
            return (TableUnit)this.currentUnits.get(filename);
        }
        return null;
    }

    public void itemStateChanged(ItemEvent i) {
        JComboBox source = (JComboBox)i.getSource();
        if (source == this.unitTypeCombo && this.unitSort == this.unitTypeCombo.getSelectedIndex()) {
            return;
        }
        if (source == this.weightClassCombo && this.weightSort == this.weightClassCombo.getSelectedIndex()) {
            return;
        }
        if (source == this.factionCombo && this.factionSort == this.factionCombo.getSelectedIndex()) {
            return;
        }
        this.loadTables();
        this.unitSort = this.unitTypeCombo.getSelectedIndex();
        this.weightSort = this.weightClassCombo.getSelectedIndex();
        this.factionSort = this.factionCombo.getSelectedIndex();
        this.mwclient.getConfig().setParam("TABLEVIEWERFACTION", (String)this.factionCombo.getSelectedItem());
        this.mwclient.getConfig().setParam("TABLEVIEWERTYPE", (String)this.unitTypeCombo.getSelectedItem());
        this.mwclient.getConfig().setParam("TALEVIEWERWEIGHT", (String)this.weightClassCombo.getSelectedItem());
        this.mwclient.getConfig().saveConfig();
        this.mwclient.setConfig();
        this.refresh();
    }

    public boolean hasValidExtension(String l) {
        String lc = l.toLowerCase();
        return lc.endsWith(".blk") || lc.endsWith(".mtf") || lc.endsWith(".hmp") || lc.endsWith(".xml") || lc.endsWith(".hmv") || lc.endsWith(".mep");
    }

    public InputStream getEntryInputStream(ZipFile zf, ZipEntry ze) {
        InputStream is = null;
        try {
            is = zf.getInputStream(ze);
            return is;
        }
        catch (IOException io) {
            return null;
        }
    }

    public int getTotalWeightForTable(ZipFile zf, ZipEntry ze) {
        int totalweight = 0;
        InputStream is = this.getEntryInputStream(zf, ze);
        BufferedReader dis = new BufferedReader(new InputStreamReader(is));
        try {
            while (dis.ready()) {
                String l = dis.readLine();
                if (l == null || l.trim().length() == 0) continue;
                l = l.trim();
                if ((l = l.replaceAll("\\s+", " ")).indexOf(" ") == 0) {
                    l = l.substring(1, l.length());
                }
                StringTokenizer ST = new StringTokenizer(l);
                totalweight += Integer.parseInt((String)ST.nextElement());
            }
            is.close();
            dis.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        return totalweight;
    }

    public void doTableLayer(TreeMap curr, TreeMap next, String add, ZipFile zip, boolean commonOverride) {
        for (String currTableName : curr.keySet()) {
            ZipEntry tableEntry = null;
            tableEntry = commonOverride ? zip.getEntry("Common" + add) : zip.getEntry(currTableName + add);
            if (tableEntry == null) {
                tableEntry = commonOverride ? zip.getEntry(("Common" + add).toLowerCase()) : zip.getEntry((currTableName + add).toLowerCase());
            }
            if (tableEntry == null) continue;
            int totaltableweight = this.getTotalWeightForTable(zip, tableEntry);
            InputStream is = this.getEntryInputStream(zip, tableEntry);
            BufferedReader dis = new BufferedReader(new InputStreamReader(is));
            double tablemultiplier = (Double)curr.get(currTableName);
            try {
                while (dis.ready()) {
                    String l = dis.readLine();
                    if (l == null || l.trim().length() == 0) continue;
                    l = l.trim();
                    if ((l = l.replaceAll("\\s+", " ")).indexOf(" ") == 0) {
                        l = l.substring(1, l.length());
                    }
                    StringTokenizer ST = new StringTokenizer(l);
                    double weight = Double.parseDouble((String)ST.nextElement());
                    if (this.hasValidExtension(l) && weight != 0.0) {
                        String Filename = "";
                        while (ST.hasMoreElements()) {
                            Filename = Filename + ST.nextToken();
                            if (!ST.hasMoreElements()) continue;
                            Filename = Filename + " ";
                        }
                        double frequency = weight / (double)totaltableweight * tablemultiplier;
                        TableUnit tu = new TableUnit(Filename, frequency);
                        TableUnit eu = (TableUnit)this.currentUnits.get(Filename);
                        if (eu != null) {
                            eu.addFrequencyFrom(tu);
                        } else {
                            this.currentUnits.put(Filename, tu);
                        }
                        eu = (TableUnit)this.currentUnits.get(Filename);
                        if (eu.getTables().get(currTableName) == null) {
                            eu.getTables().put(currTableName, new Double(frequency));
                            continue;
                        }
                        Double currFreq = (Double)eu.getTables().get(currTableName);
                        Double newFreq = new Double(currFreq + frequency);
                        eu.getTables().remove(currTableName);
                        eu.getTables().put(currTableName, newFreq);
                        continue;
                    }
                    if (weight == 0.0) continue;
                    String crossTableName = "";
                    while (ST.hasMoreElements()) {
                        crossTableName = crossTableName + ST.nextToken();
                        if (!ST.hasMoreElements()) continue;
                        crossTableName = crossTableName + " ";
                    }
                    if (next == null) continue;
                    if (next.containsKey("crossTableName")) {
                        Double d = (Double)next.get(crossTableName);
                        double newTableWeight = d + weight / (double)totaltableweight * tablemultiplier;
                        next.remove(crossTableName);
                        next.put(crossTableName, new Double(newTableWeight));
                        continue;
                    }
                    next.put(crossTableName, new Double(weight / (double)totaltableweight * tablemultiplier));
                }
                is.close();
                dis.close();
            }
            catch (Exception e) {
                return;
            }
        }
    }

    public void loadTables() {
        String factionString = "";
        String addOnString = "";
        factionString = factionString + (String)this.factionCombo.getSelectedItem();
        addOnString = addOnString + "_" + (String)this.weightClassCombo.getSelectedItem();
        String type = (String)this.unitTypeCombo.getSelectedItem();
        if (!type.equals("Mek")) {
            addOnString = addOnString + type;
        }
        addOnString = addOnString + ".txt";
        ZipFile tableZip = null;
        try {
            tableZip = new ZipFile("./data/buildtables.zip");
        }
        catch (IOException io) {
            MWClient.mwClientLog.clientErrLog("Could not find build tables.");
            MWClient.mwClientLog.clientErrLog(io);
            return;
        }
        this.currentUnits.clear();
        boolean overrideWithCommon = false;
        ZipEntry tableEntry = tableZip.getEntry(factionString + addOnString);
        if (tableEntry == null) {
            tableEntry = tableZip.getEntry((factionString + addOnString).toLowerCase());
        }
        if (tableEntry == null) {
            overrideWithCommon = true;
            tableEntry = tableZip.getEntry("Common" + addOnString);
        }
        if (tableEntry == null) {
            tableEntry = tableZip.getEntry(("Common" + addOnString).toLowerCase());
        }
        if (tableEntry == null) {
            return;
        }
        TreeMap crossMap1 = new TreeMap();
        TreeMap crossMap2 = new TreeMap();
        TreeMap crossMap3 = new TreeMap();
        TreeMap<String, Double> temp = new TreeMap<String, Double>();
        temp.put(factionString, new Double(100.0));
        this.doTableLayer(temp, crossMap1, addOnString, tableZip, overrideWithCommon);
        this.doTableLayer(crossMap1, crossMap2, addOnString, tableZip, false);
        this.doTableLayer(crossMap2, crossMap3, addOnString, tableZip, false);
        this.doTableLayer(crossMap3, null, addOnString, tableZip, false);
        double totalPercent = 0.0;
        for (TableUnit currUnit : this.currentUnits.values()) {
            totalPercent += currUnit.getFrequency();
        }
        DecimalFormat myFormatter = new DecimalFormat("###.#####");
        this.percentageLabel.setText("Total Percentage: " + myFormatter.format(totalPercent) + "%");
    }

    static class TableUnit
    extends CUnit {
        double frequency;
        String realFilename;
        TreeMap tables;

        public TableUnit(String fn, double f) {
            this.setUnitFilename(fn.trim());
            this.setPilot(new Pilot("Autopilot", 4, 5));
            try {
                String modfn = fn.trim();
                modfn = modfn.substring(0, modfn.length() - 4);
                MechSummary ms = MechSummaryCache.getInstance().getMech(modfn);
                this.UnitEntity = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
            }
            catch (Exception e) {
                this.createEntityFromFileNameWithCache(fn.trim());
            }
            this.realFilename = fn;
            this.frequency = f;
            this.tables = new TreeMap();
        }

        public double getFrequency() {
            return this.frequency;
        }

        public void addFrequencyFrom(TableUnit u) {
            this.frequency += u.getFrequency();
        }

        public String getRealFilename() {
            return this.realFilename;
        }

        public TreeMap getTables() {
            return this.tables;
        }

        private void createEntityFromFileNameWithCache(String fn) {
            MechSummary[] mechs = MechSummaryCache.getInstance().getAllMechs();
            for (int pos = 0; pos < mechs.length; ++pos) {
                if (!mechs[pos].getSourceFile().getName().equalsIgnoreCase(fn)) continue;
                try {
                    this.UnitEntity = new MechFileParser(mechs[pos].getSourceFile(), mechs[pos].getEntryName()).getEntity();
                    return;
                }
                catch (Exception ex) {
                    this.createEntityFromFilename(fn);
                    return;
                }
            }
            this.createEntityFromFilename(fn);
        }

        private void createEntityFromFilename(String fn) {
            this.UnitEntity = null;
            try {
                this.UnitEntity = new MechFileParser(new File("./data/mechfiles/Meks.zip"), fn).getEntity();
            }
            catch (Exception e) {
                try {
                    this.UnitEntity = new MechFileParser(new File("./data/mechfiles/Vehicles.zip"), fn).getEntity();
                }
                catch (Exception ex) {
                    try {
                        this.UnitEntity = new MechFileParser(new File("./data/mechfiles/Infantry.zip"), fn).getEntity();
                    }
                    catch (Exception exc) {
                        try {
                            MWClient.mwClientLog.clientErrLog("Error loading unit: " + fn + ". Try replacing with OMG.");
                            MechSummary ms = MechSummaryCache.getInstance().getMech("Error OMG-UR-FD");
                            this.UnitEntity = new MechFileParser(ms.getSourceFile(), ms.getEntryName()).getEntity();
                        }
                        catch (Exception exepe) {
                            MWClient.mwClientLog.clientErrLog("Error unit failed to load. Exiting.");
                            System.exit(1);
                        }
                    }
                }
            }
            this.setType(TableUnit.getEntityType(this.UnitEntity));
            this.getC3Type(this.UnitEntity);
        }
    }

    static class TableViewerModel
    extends AbstractTableModel {
        public static final int UNIT = 0;
        public static final int WEIGHT = 1;
        public static final int BATTLEVALUE = 2;
        public static final int FREQUENCY = 3;
        public static final int FILENAME = 4;
        TreeMap currentUnits;
        Object[] sortedUnits;
        int currentSortMode = 3;
        String[] columnNames = new String[]{"Unit", "Weight", "BV", "Frequency"};
        MWClient mwclient;

        public TableViewerModel(MWClient c, TreeMap current, Object[] sorted) {
            this.mwclient = c;
            this.currentUnits = current;
            this.sortedUnits = sorted;
        }

        public int getColumnCount() {
            return this.columnNames.length;
        }

        public int getRowCount() {
            return this.sortedUnits.length;
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public void setSortMode(int sortMode) {
            this.currentSortMode = sortMode;
        }

        public TableViewerRenderer getRenderer() {
            return new TableViewerRenderer();
        }

        public void refreshModel() {
            this.sortedUnits = this.sortUnits(this.currentSortMode);
            this.fireTableDataChanged();
        }

        public Object getValueAt(int row, int col) {
            if (row < 0 || row >= this.sortedUnits.length) {
                return "";
            }
            TableUnit currU = (TableUnit)this.sortedUnits[row];
            switch (col) {
                case 0: {
                    if (currU.getType() == 0 && !currU.getEntity().isOmni()) {
                        return "<html><body>" + currU.getEntity().getChassis() + ", " + currU.getModelName();
                    }
                    return "<html><body>" + currU.getModelName();
                }
                case 1: {
                    return new Integer((int)currU.getEntity().getWeight());
                }
                case 2: {
                    return new Integer(currU.getEntity().calculateBattleValue());
                }
                case 3: {
                    DecimalFormat myFormatter = new DecimalFormat("#00.00");
                    return myFormatter.format(currU.getFrequency()) + "%";
                }
                case 4: {
                    return currU.getRealFilename();
                }
            }
            return "";
        }

        public Object[] sortUnits(int sortMode) {
            CUnitComparator comparator = null;
            switch (sortMode) {
                case 0: {
                    this.sortedUnits = this.currentUnits.values().toArray();
                    comparator = new CUnitComparator(0);
                    Arrays.sort(this.sortedUnits, comparator);
                    return this.sortedUnits;
                }
                case 1: {
                    this.sortedUnits = this.currentUnits.values().toArray();
                    comparator = new CUnitComparator(9);
                    Arrays.sort(this.sortedUnits, comparator);
                    return this.sortedUnits;
                }
                case 2: {
                    this.sortedUnits = this.currentUnits.values().toArray();
                    comparator = new CUnitComparator(1);
                    Arrays.sort(this.sortedUnits, comparator);
                    return this.sortedUnits;
                }
                case 3: {
                    this.sortedUnits = this.currentUnits.values().toArray();
                    Arrays.sort(this.sortedUnits, new Comparator(){

                        public int compare(Object o1, Object o2) {
                            TableUnit t1 = (TableUnit)o1;
                            TableUnit t2 = (TableUnit)o2;
                            Double d1 = new Double(t1.getFrequency());
                            Double d2 = new Double(t2.getFrequency());
                            return d1.compareTo(d2);
                        }
                    });
                    return this.sortedUnits;
                }
            }
            return new Object[0];
        }

        private class TableViewerRenderer
        extends DefaultTableCellRenderer {
            private TableViewerRenderer() {
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component d = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                JLabel c = new JLabel();
                c.setOpaque(true);
                if (row >= TableViewerModel.this.currentUnits.size() || row < 0) {
                    return c;
                }
                if (table.getModel().getValueAt(row, column) != null) {
                    c.setText(table.getModel().getValueAt(row, column).toString());
                }
                c.setToolTipText("");
                TableUnit currU = (TableUnit)TableViewerModel.this.currentUnits.get(table.getModel().getValueAt(row, 4));
                StringBuilder description = new StringBuilder();
                if (currU.getType() == 0 && !currU.getEntity().isOmni()) {
                    description.append("<html><body><u>" + currU.getEntity().getChassis() + ", " + currU.getModelName() + "</u><br>");
                } else {
                    description.append("<html><body><u>" + currU.getModelName() + "</u><br>");
                }
                description.append("Sources:");
                Iterator i = currU.getTables().keySet().iterator();
                DecimalFormat formatter = new DecimalFormat("##0.0##");
                while (i.hasNext()) {
                    String tableName = (String)i.next();
                    Double freq = (Double)currU.getTables().get(tableName);
                    description.append("<br>- " + tableName + ": " + formatter.format(freq) + "%");
                }
                c.setToolTipText(description.toString());
                if (isSelected) {
                    c.setForeground(d.getForeground());
                    c.setBackground(d.getBackground());
                    return c;
                }
                c.setBackground(Color.white);
                return c;
            }
        }
    }
}

