/*
 * Decompiled with CFR 0.152.
 */
package client.protocol;

import client.MWClient;
import client.protocol.ConnectionHandlerLocal;
import client.protocol.IConnectionHandler;
import client.protocol.IConnectionListener;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.Inflater;

class ReaderThread
extends Thread {
    private boolean keepGoing = true;
    private InputStream _sis;
    private IConnectionListener _listener;
    private IConnectionHandler _connectionHandler;
    private byte[] compressedBytes = null;
    private byte[] rawBytes = null;
    private Inflater inflater = new Inflater();
    private byte[] rlBuffer = new byte[65536];
    private static final int NL = 10;

    ReaderThread(IConnectionHandler handler, Socket s) {
        super("ConnectionHandler$ReaderThread");
        try {
            this._sis = s.getInputStream();
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
        }
        this._connectionHandler = handler;
    }

    public void setListener(IConnectionListener listener) {
        this._listener = listener;
    }

    private String readLine() throws IOException {
        try {
            int i;
            int n = 0;
            while ((i = this._sis.read()) != 10) {
                this.rlBuffer[n++] = (byte)i;
            }
            byte[] a = new byte[n];
            System.arraycopy(this.rlBuffer, 0, a, 0, n);
            return new String(a, "UTF8");
        }
        catch (Exception e) {
            throw new IOException();
        }
    }

    private String[] decompose(String input) {
        StringTokenizer st = new StringTokenizer(input, "\t");
        Vector<String> v = new Vector<String>(5);
        while (st.hasMoreTokens()) {
            v.addElement(st.nextToken());
        }
        Object[] args = new String[v.size()];
        v.copyInto(args);
        return args;
    }

    private void inflate(String command) throws Exception {
        String[] args = this.decompose(command);
        int size = Integer.parseInt(args[1]);
        int fullSize = 29999;
        if (args.length > 2) {
            fullSize = Integer.parseInt(args[2]);
        }
        this.compressedBytes = new byte[size];
        this.rawBytes = new byte[fullSize];
        for (int totalRead = 0; totalRead < size; totalRead += this._sis.read(this.compressedBytes, totalRead, size - totalRead)) {
            ConnectionHandlerLocal.DEBUG("< Read " + totalRead + " of " + size);
        }
        this.inflater.reset();
        this.inflater.setInput(this.compressedBytes, 0, size);
        int textLength = this.inflater.inflate(this.rawBytes);
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(this.rawBytes, 0, textLength), "UTF8"));
        while ((command = br.readLine()) != null) {
            ConnectionHandlerLocal.DEBUG("< inflated: " + command);
            this._listener.incomingMessage(command);
        }
    }

    public void run() {
        block8: {
            try {
                while (this.keepGoing) {
                    String newLine = this.readLine();
                    if (newLine == null) {
                        this.pleaseStop();
                        continue;
                    }
                    if (this._listener != null) {
                        String[] args;
                        if (newLine.startsWith("/deflated") && (args = this.decompose(newLine)).length > 0) {
                            try {
                                this.inflate(newLine);
                            }
                            catch (Exception ex) {
                                MWClient.mwClientLog.clientErrLog(ex);
                            }
                            continue;
                        }
                        ConnectionHandlerLocal.DEBUG("< " + newLine);
                        this._listener.incomingMessage(newLine);
                        continue;
                    }
                    MWClient.mwClientLog.clientErrLog("Null listener: " + newLine);
                }
                MWClient.mwClientLog.clientErrLog("ReaderThread: stopping gracefully.");
            }
            catch (IOException e) {
                if (!this.keepGoing) break block8;
                this.pleaseStop();
                MWClient.mwClientLog.clientErrLog("ReaderThread Error");
                MWClient.mwClientLog.clientErrLog(e);
                this._connectionHandler.shutdown(true);
            }
        }
    }

    void pleaseStop() {
        this.keepGoing = false;
    }
}

