/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CampaignData;
import common.persistence.MMNetSerializable;
import common.persistence.TreeReader;
import common.persistence.TreeWriter;
import common.util.BinReader;
import common.util.BinWriter;
import java.io.IOException;
import java.io.Serializable;

public class UnitFactory
implements Serializable,
MMNetSerializable {
    private String name;
    private String size;
    private String founder;
    private int ticksUntilRefresh;
    private int refreshSpeed = 100;
    public static final int BUILDALL = 0;
    public static final int BUILDMEK = 1;
    public static final int BUILDVEHICLES = 2;
    public static final int BUILDMEKnVEHICLES = 3;
    public static final int BUILDINFANTRY = 4;
    public static final int BUILDMEKNInFANTRY = 5;
    public static final int BUILDVEHICLESnINFANTRY = 6;
    public static final int BUILDMEKnINFANTRYnVEHICLES = 7;
    public static final int BUILDPROTOMECHS = 8;
    public static final int BUILDMEKnPROTOMECHS = 9;
    public static final int BUILDVEHICLESnPROTOMECH = 10;
    public static final int BUILDMEKnVEHICLESnPROTOMECH = 11;
    public static final int BUILDINFANTRYnPROTOMECH = 12;
    public static final int BUILDMEKnINFANTRYnPROTOMECH = 13;
    public static final int BUILDVEHICLESnINFANTRYnPROTOMECH = 14;
    public static final int BUILDMEKnVEHICLESnINFANTRYnPROTOMECH = 15;
    public static final int BUILDBATTLEARMOR = 16;
    public static final int BUILDMEKnBATTLEARMOR = 17;
    public static final int BUILDVEHICLESnBATTLEARMOR = 18;
    public static final int BUILDMEKnVEHICLEsnBATTLEARMOR = 19;
    public static final int BUILDINFANTRYnBATTLEARMOR = 20;
    public static final int BUILDMEKnINFANTRYnBATTLEARMOR = 21;
    public static final int BUILDVEHICLESnINFANTRYnBATTLEARMOR = 22;
    public static final int BUILDMEKnVEHICLESnINFANTRYnBATTLEARMOR = 23;
    public static final int BUILDPROTOMECHSnBATTLEARMOR = 24;
    public static final int BUILDMEKnPROTOMECHSnBATTLEARMOR = 25;
    public static final int BUILDVEHICLESnPROTOMECHnBATTLEARMOR = 26;
    public static final int BUILDMEKnVEHICLESnPROTOMECHnBATTLEARMOR = 27;
    public static final int BUILDINFANTRYnPROTOMECHnBATTLEARMOR = 28;
    public static final int BUILDMEKnINFANTRYnPROTOMECHnBATTLEARMOR = 29;
    public static final int BUILDVEHICLESnINFANTRYnPROTOMECHnBATTLEARMOR = 30;
    public static final int BUILDMEKnVEHICLESnINFANTRYnPROTOMECHnBATTLEARMOR = 31;
    public static final int BUILDVTOL = 32;
    private int type;
    private boolean factoryLocked = false;
    private int factoryID = 0;

    public String getFounder() {
        return this.founder;
    }

    public void setFounder(String faction) {
        this.founder = faction;
    }

    public int getID() {
        return this.factoryID;
    }

    public void setID(int id) {
        this.factoryID = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getRefreshSpeed() {
        return this.refreshSpeed;
    }

    public void setRefreshSpeed(int refreshSpeed) {
        this.refreshSpeed = refreshSpeed;
    }

    public String getSize() {
        return this.size;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public int getTicksUntilRefresh() {
        if (this.isLocked()) {
            return Integer.MAX_VALUE;
        }
        if (this.ticksUntilRefresh < 0) {
            return 0;
        }
        return this.ticksUntilRefresh;
    }

    public void setTicksUntilRefresh(int ticksUntilRefresh) {
        this.ticksUntilRefresh = ticksUntilRefresh;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public boolean canProduce(int type_id) {
        int test = this.getType();
        if (test == 0) {
            return true;
        }
        if (test - 16 >= 0) {
            test -= 16;
            if (type_id == 4) {
                return true;
            }
        }
        if (test - 8 >= 0) {
            test -= 8;
            if (type_id == 3) {
                return true;
            }
        }
        if (test - 4 >= 0) {
            test -= 4;
            if (type_id == 2) {
                return true;
            }
        }
        if (test - 2 >= 0) {
            test -= 2;
            if (type_id == 1) {
                return true;
            }
        }
        return test - 1 >= 0 && type_id == 0;
    }

    public void binOut(BinWriter out) {
        out.println(this.name, "name");
        out.println(this.size, "size");
        out.println(this.founder, "faction");
        out.println(this.ticksUntilRefresh, "ticksUntilRefresh");
        out.println(this.refreshSpeed, "refreshSpeed");
        out.println(this.type, "type");
        out.println(this.factoryLocked, "factorylock");
    }

    public void binIn(BinReader in) throws IOException {
        this.name = in.readLine("name");
        this.size = in.readLine("size");
        this.founder = in.readLine("faction");
        this.ticksUntilRefresh = in.readInt("ticksUntilRefresh");
        this.refreshSpeed = in.readInt("refreshSpeed");
        this.type = in.readInt("type");
        this.factoryLocked = in.readBoolean("factorylock");
    }

    public String getTypeString() {
        String result = "";
        if (this.canProduce(0)) {
            result = result + "M";
        }
        if (this.canProduce(1)) {
            result = result + "V";
        }
        if (this.canProduce(2)) {
            result = result + "I";
        }
        if (this.canProduce(3)) {
            result = result + "P";
        }
        if (this.canProduce(4)) {
            result = result + "B";
        }
        return result;
    }

    public String getFullTypeString() {
        String result = "";
        if (this.canProduce(0)) {
            result = "Mek ";
        }
        if (this.canProduce(1)) {
            result = result + "Vehicle ";
        }
        if (this.canProduce(2)) {
            result = result + "Infantry ";
        }
        if (this.canProduce(3)) {
            result = result + "ProtoMek ";
        }
        if (this.canProduce(4)) {
            result = result + "BattleArmor ";
        }
        return result;
    }

    public String getStatus() {
        String result = this.getName() + "(" + this.getSize();
        if (this.getType() != 0) {
            result = result + " " + this.typeString();
        }
        result = result + ") built by " + this.getFounder() + ".<br>";
        result = this.getTicksUntilRefresh() == 0 ? result + "Factory is ready to produce a unit.<br>" : result + "Factory will be ready to produce a unit in " + this.getTicksUntilRefresh() + " miniticks.<br>";
        return result;
    }

    public String typeString() {
        String result = "";
        if (this.canProduce(0)) {
            result = result + "Mek ";
        }
        if (this.canProduce(1)) {
            result = result + "Vehicle ";
        }
        if (this.canProduce(2)) {
            result = result + "Infantry ";
        }
        if (this.canProduce(3)) {
            result = result + "ProtoMek ";
        }
        if (this.canProduce(4)) {
            result = result + "BattleArmor ";
        }
        return result;
    }

    public void binOut(TreeWriter out) {
        out.write(this.getName(), "name");
        out.write(this.getSize(), "size");
        out.write(this.getFounder(), "founder");
        out.write(this.getTicksUntilRefresh(), "ticksuntilrefresh");
        out.write(this.getRefreshSpeed(), "refreshspeed");
        out.write(this.getType(), "type");
        out.write(this.isLocked(), "factorylock");
    }

    public void binIn(TreeReader in, CampaignData data) {
    }

    public int getWeightclass() {
        if (this.getSize().equalsIgnoreCase("Light")) {
            return 0;
        }
        if (this.getSize().equalsIgnoreCase("Medium")) {
            return 1;
        }
        if (this.getSize().equalsIgnoreCase("Heavy")) {
            return 2;
        }
        if (this.getSize().equalsIgnoreCase("Assault")) {
            return 3;
        }
        return 0;
    }

    public int getBestTypeProducable() {
        if (this.canProduce(0)) {
            return 0;
        }
        if (this.canProduce(1)) {
            return 1;
        }
        if (this.canProduce(4)) {
            return 4;
        }
        if (this.canProduce(3)) {
            return 3;
        }
        if (this.canProduce(2)) {
            return 2;
        }
        return 0;
    }

    public boolean isLocked() {
        return this.factoryLocked;
    }

    public void setLock(boolean lock) {
        this.factoryLocked = lock;
    }
}

