/*
 * Decompiled with CFR 0.152.
 */
package common.campaign.pilot.skills;

import common.campaign.pilot.skills.PilotSkill;
import java.util.Iterator;
import java.util.LinkedList;

public class PilotSkills {
    private LinkedList skills = new LinkedList();

    public boolean has(PilotSkill p) {
        if (p == null) {
            return false;
        }
        return this.skills.contains(p);
    }

    public boolean has(int id) {
        Iterator it = this.getSkillIterator();
        while (it.hasNext()) {
            if (((PilotSkill)it.next()).getId() != id) continue;
            return true;
        }
        return false;
    }

    public void add(PilotSkill p) {
        if (p != null && !this.has(p)) {
            this.skills.add(p);
        }
    }

    public void remove(PilotSkill p) {
        if (p != null) {
            this.skills.remove(p);
        }
    }

    public int size() {
        return this.skills.size();
    }

    public Iterator getSkillIterator() {
        return this.skills.iterator();
    }

    public PilotSkill getPilotSkill(int skillid) {
        Iterator skills = this.getSkillIterator();
        while (skills.hasNext()) {
            PilotSkill pSkill = (PilotSkill)skills.next();
            if (pSkill.getId() != skillid) continue;
            return pSkill;
        }
        return null;
    }

    public String getDescription() {
        Iterator i = this.getSkillIterator();
        String result = "";
        if (i.hasNext()) {
            result = " Skills: ";
        }
        while (i.hasNext()) {
            PilotSkill skill = (PilotSkill)i.next();
            result = result + skill.getName();
            if (skill.getLevel() > 1) {
                result = result + " " + skill.getLevel();
            }
            if (!i.hasNext()) continue;
            result = result + ", ";
        }
        return result;
    }
}

