/*
 * Decompiled with CFR 0.152.
 */
package admin;

import admin.dialog.AmmoCostDialog;
import admin.dialog.BanTargetingDialog;
import admin.dialog.BannedAmmoDialog;
import admin.dialog.CommandNameDialog;
import admin.dialog.ComponentDisplayDialog;
import admin.dialog.FactionConfigurationDialog;
import admin.dialog.PlanetEditorDialog;
import admin.dialog.ServerConfigurationDialog;
import client.MWClient;
import client.gui.dialog.HouseNameDialog;
import client.gui.dialog.PlanetNameDialog;
import client.gui.dialog.TraitDialog;
import client.gui.dialog.UnitViewerDialog;
import common.Planet;
import common.PlanetEnvironment;
import common.UnitFactory;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import megamek.client.ui.AWT.UnitLoadingDialog;
import megamek.common.TechConstants;

public class AdminMenu
extends JMenu {
    private static final long serialVersionUID = -4734543796361026030L;
    JMenu jMenuAdminSubSave = new JMenu();
    JMenu jMenuAdminSubSet = new JMenu();
    JMenu jMenuAdminSubCreate = new JMenu();
    JMenu jMenuAdminSubDestroy = new JMenu();
    JMenu jMenuAdminBlackMarketSettings = new JMenu("Black Market Settings");
    JMenu jMenuAdminOperations = new JMenu("Operations");
    JMenuItem jMenuAdminServerConfig = new JMenuItem();
    JMenuItem jMenuAdminFactionConfig = new JMenuItem();
    JMenuItem jMenuAdminTerminateAll = new JMenuItem();
    JMenuItem jMenuAdminCreatePlanet = new JMenuItem();
    JMenuItem jMenuAdminDestroyPlanet = new JMenuItem();
    JMenuItem jMenuAdminCreateFactory = new JMenuItem();
    JMenuItem jMenuAdminDestroyFactory = new JMenuItem();
    JMenuItem jMenuAdminCreateTerrain = new JMenuItem();
    JMenuItem jMenuAdminDestroyTerrain = new JMenuItem();
    JMenuItem jMenuAdminChangePlanetOwner = new JMenuItem();
    JMenuItem jMenuAdminHouseAmmoBan = new JMenuItem();
    JMenuItem jMenuAdminSetHouseFluFile = new JMenuItem();
    JMenuItem jMenuAdminSetHouseTechLevel = new JMenuItem();
    JMenuItem jMenuAdminSetFactionTraits = new JMenuItem();
    JMenuItem jMenuAdminSaveTheUniverse = new JMenuItem();
    JMenuItem jMenuAdminSaveBlackMaketSettings = new JMenuItem();
    JMenuItem jMenuAdminSavePlanetsToXML = new JMenuItem();
    JMenuItem jMenuAdminSaveServerConfigs = new JMenuItem();
    JMenuItem jMenuAdminSaveCommandLevels = new JMenuItem();
    JMenuItem jMenuAdminGrantComponents = new JMenuItem();
    JMenuItem jMenuAdminExchangePlanetOwnership = new JMenuItem();
    JMenuItem jMenuAdminLockFactory = new JMenuItem();
    JMenuItem jMenuAdminSetPlanetMapSize = new JMenuItem();
    JMenuItem jMenuAdminSetPlanetBoardSize = new JMenuItem();
    JMenuItem jMenuAdminSetPlanetTemperature = new JMenuItem();
    JMenuItem jMenuAdminSetPlanetGravity = new JMenuItem();
    JMenuItem jMenuAdminSetPlanetVacuum = new JMenuItem();
    JMenuItem jMenuAdminSetPlanetHomeWorld = new JMenuItem();
    JMenuItem jMenuAdminSetPlanetOriginalOwner = new JMenuItem();
    JMenuItem jMenuAdminSetServerAmmoBan = new JMenuItem();
    JMenuItem jMenuAdminSetBanTargeting = new JMenuItem();
    JMenuItem jMenuAdminSetCommandLevel = new JMenuItem();
    JMenuItem jMenuAdminSetMegaMekGameOptions = new JMenuItem();
    JMenuItem jMenuAdminSetAmmoCost = new JMenuItem();
    JMenuItem jMenuAdminRetrieveOperationFile = new JMenuItem();
    JMenuItem jMenuAdminSetOperationFile = new JMenuItem();
    JMenuItem jMenuAdminSetNewOperationFile = new JMenuItem();
    JMenuItem jMenuAdminSendAllOperationFiles = new JMenuItem();
    JMenuItem jMenuAdminUpdateOperations = new JMenuItem();
    JMenuItem jMenuAdminRemoveOMG = new JMenuItem();
    JMenuItem jMenuAdminOmniVariantMod = new JMenuItem();
    JMenuItem jMenuAdminCommandLists = new JMenuItem();
    JMenuItem jMenuAdminComponentMiscList = new JMenuItem();
    JMenuItem jMenuAdminComponentWeaponList = new JMenuItem();
    JMenuItem jMenuAdminComponentAmmoList = new JMenuItem();
    JMenuItem jMenuAdminSetHouseBasePilotSkill = new JMenuItem();
    MWClient mwclient;
    private int userLevel = 0;

    public AdminMenu() {
        super("Server Configs");
    }

    public void createMenu(MWClient client) {
        this.mwclient = client;
        this.userLevel = this.mwclient.getUser(this.mwclient.getUsername()).getUserlevel();
        this.jMenuAdminSubSave.setText("Save");
        this.jMenuAdminSubSet.setText("Set");
        this.jMenuAdminSubCreate.setText("Create");
        this.jMenuAdminSubDestroy.setText("Destroy");
        this.jMenuAdminCreatePlanet.setText("Create Planet");
        this.jMenuAdminCreatePlanet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminCreatePlanet_actionPerformed(e);
            }
        });
        this.jMenuAdminDestroyPlanet.setText("Destroy Planet");
        this.jMenuAdminDestroyPlanet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminDestroyPlanet_actionPerformed(e);
            }
        });
        this.jMenuAdminCreateFactory.setText("Create Factory");
        this.jMenuAdminCreateFactory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminCreateFactory_actionPerformed(e);
            }
        });
        this.jMenuAdminDestroyFactory.setText("Destroy Factory");
        this.jMenuAdminDestroyFactory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminDestroyFactory_actionPerformed(e);
            }
        });
        this.jMenuAdminCreateTerrain.setText("Create Terrain");
        this.jMenuAdminCreateTerrain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminCreateTerrain_actionPerformed(e);
            }
        });
        this.jMenuAdminDestroyTerrain.setText("Destroy Terrain");
        this.jMenuAdminDestroyTerrain.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminDestroyTerrain_actionPerformed(e);
            }
        });
        this.jMenuAdminHouseAmmoBan.setText("Set Banned Ammo");
        this.jMenuAdminHouseAmmoBan.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminHouseAmmoBan_actionPerformed(e);
            }
        });
        this.jMenuAdminChangePlanetOwner.setText("Change Planet Owner");
        this.jMenuAdminChangePlanetOwner.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminChangePlanetOwner_actionPerformed(e);
            }
        });
        this.jMenuAdminServerConfig.setText("Server Configuration");
        this.jMenuAdminServerConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.mwclient.getServerConfigData();
                new ServerConfigurationDialog(AdminMenu.this.mwclient);
            }
        });
        this.jMenuAdminFactionConfig.setText("Faction Configuration");
        this.jMenuAdminFactionConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                HouseNameDialog factionDialog = new HouseNameDialog(AdminMenu.this.mwclient, "Faction", false, false);
                factionDialog.setVisible(true);
                String faction = factionDialog.getHouseName();
                factionDialog.dispose();
                if (faction == null || faction.length() == 0) {
                    return;
                }
                AdminMenu.this.mwclient.setWaiting(true);
                AdminMenu.this.mwclient.sendChat("/c GetFactionConfigs#-1#" + faction);
                try {
                    while (AdminMenu.this.mwclient.isWaiting()) {
                        Thread.sleep(10L);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                new FactionConfigurationDialog(AdminMenu.this.mwclient, faction);
            }
        });
        this.jMenuAdminTerminateAll.setText("Terminate All Games");
        this.jMenuAdminTerminateAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminTerminateAll_actionPerformed(e);
            }
        });
        this.jMenuAdminSetFactionTraits.setText("Faction Traits");
        this.jMenuAdminSetFactionTraits.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new TraitDialog(AdminMenu.this.mwclient, false);
            }
        });
        this.jMenuAdminSetHouseFluFile.setText("Set House Flu File");
        this.jMenuAdminSetHouseFluFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetHouseFluFile_actionPerformed(e);
            }
        });
        this.jMenuAdminSetHouseTechLevel.setText("Set House Tech Level");
        this.jMenuAdminSetHouseTechLevel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetHouseTechLevel_actionPerformed(e);
            }
        });
        this.jMenuAdminSaveTheUniverse.setText("Save The Universe");
        this.jMenuAdminSaveTheUniverse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSaveTheUniverse_actionPerformed(e);
            }
        });
        this.jMenuAdminSaveBlackMaketSettings.setText("Save Black Market Settings");
        this.jMenuAdminSaveBlackMaketSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSaveBlackMaketSettings_actionPerformed(e);
            }
        });
        this.jMenuAdminSavePlanetsToXML.setText("Save Planets to XML");
        this.jMenuAdminSavePlanetsToXML.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSavePlanetsToXML_actionPerformed(e);
            }
        });
        this.jMenuAdminRemoveOMG.setText("List and Remove OMG Units");
        this.jMenuAdminRemoveOMG.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.mwclient.sendChat("/c adminlistandremoveomg");
            }
        });
        this.jMenuAdminGrantComponents.setText("Grant Components");
        this.jMenuAdminGrantComponents.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminGrantComponents_actionPerformed(e);
            }
        });
        this.jMenuAdminExchangePlanetOwnership.setText("Exchange Planet Ownership");
        this.jMenuAdminExchangePlanetOwnership.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminExchangePlanetOwnership_actionPerformed(e);
            }
        });
        this.jMenuAdminLockFactory.setText("Lock Factory");
        this.jMenuAdminLockFactory.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminLockFactory_actionPerformed(e);
            }
        });
        this.jMenuAdminSaveServerConfigs.setText("Save Server Configuration");
        this.jMenuAdminSaveServerConfigs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.mwclient.sendChat("/c AdminSaveServerConfigs");
                AdminMenu.this.mwclient.reloadData();
            }
        });
        this.jMenuAdminSaveCommandLevels.setText("Save Command Levels");
        this.jMenuAdminSaveCommandLevels.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.mwclient.sendChat("/c AdminSaveCommandLevels");
            }
        });
        this.jMenuAdminSetPlanetMapSize.setText("Set Planet Map Size");
        this.jMenuAdminSetPlanetMapSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetPlanetMapSize_actionPerformed(e);
            }
        });
        this.jMenuAdminSetPlanetBoardSize.setText("Set Planet Board Size");
        this.jMenuAdminSetPlanetBoardSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetPlanetBoardSize_actionPerformed(e);
            }
        });
        this.jMenuAdminSetPlanetTemperature.setText("Set Planet Temperature");
        this.jMenuAdminSetPlanetTemperature.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetPlanetTemperature_actionPerformed(e);
            }
        });
        this.jMenuAdminSetPlanetGravity.setText("Set Planet Gravity");
        this.jMenuAdminSetPlanetGravity.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetPlanetGravity_actionPerformed(e);
            }
        });
        this.jMenuAdminSetPlanetVacuum.setText("Set Planet Vacuum");
        this.jMenuAdminSetPlanetVacuum.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.mwclient.sendChat("/c AdminSetPlanetVacuum");
                AdminMenu.this.mwclient.reloadData();
            }
        });
        this.jMenuAdminSetPlanetHomeWorld.setText("Set Planet Home World");
        this.jMenuAdminSetPlanetHomeWorld.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetPlanetHomeWorld_actionPerformed(e);
            }
        });
        this.jMenuAdminSetPlanetOriginalOwner.setText("Set Planet Original Owner");
        this.jMenuAdminSetPlanetOriginalOwner.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetPlanetOriginalOwner_actionPerformed(e);
            }
        });
        this.jMenuAdminSetServerAmmoBan.setText("Set Server Ammo Ban");
        this.jMenuAdminSetServerAmmoBan.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminServerAmmoBan_actionPerformed(e);
            }
        });
        this.jMenuAdminSetBanTargeting.setText("Set Ban Targeting Systems");
        this.jMenuAdminSetBanTargeting.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetBanTargeting_actionPerformed(e);
            }
        });
        this.jMenuAdminRetrieveOperationFile.setText("Retrieve Operation File");
        this.jMenuAdminRetrieveOperationFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminRetrieveOperationFile_actionPerformed(e);
            }
        });
        this.jMenuAdminSetOperationFile.setText("Set Operation File");
        this.jMenuAdminSetOperationFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetOperationFile_actionPerformed(e);
            }
        });
        this.jMenuAdminSetNewOperationFile.setText("Set New Operation File");
        this.jMenuAdminSetNewOperationFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetNewOperationFile_actionPerformed(e);
            }
        });
        this.jMenuAdminSendAllOperationFiles.setText("Send All Local Op Files");
        this.jMenuAdminSendAllOperationFiles.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSendAllOperationFiles_actionPerformed(e);
            }
        });
        this.jMenuAdminUpdateOperations.setText("Update Operations");
        this.jMenuAdminUpdateOperations.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminUpdateOperations_actionPerformed(e);
            }
        });
        this.jMenuAdminSetAmmoCost.setText("Set Ammo Cost");
        this.jMenuAdminSetAmmoCost.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminAmmoCost_actionPerformed(e);
            }
        });
        this.jMenuAdminOmniVariantMod.setText("Set Omni Variant Mod");
        this.jMenuAdminOmniVariantMod.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminOmniVariantMod_actionPerformed(e);
            }
        });
        this.jMenuAdminSetCommandLevel.setText("Set Command Level");
        this.jMenuAdminSetCommandLevel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetCommandLevel_actionPerformed(e);
            }
        });
        this.jMenuAdminSetHouseBasePilotSkill.setText("Set House Base Pilot Skills");
        this.jMenuAdminSetHouseBasePilotSkill.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminSetHouseBasePilotSkills_actionPerformed(e);
            }
        });
        this.jMenuAdminCommandLists.setText("List Commands");
        this.jMenuAdminCommandLists.setMnemonic('L');
        this.jMenuAdminCommandLists.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.jMenuAdminCommandLists_actionPerformed(e);
            }
        });
        this.jMenuAdminComponentWeaponList.setText("List Weapon Components");
        this.jMenuAdminComponentWeaponList.setMnemonic('W');
        this.jMenuAdminComponentWeaponList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                e.setSource(0);
                AdminMenu.this.jMenuAdminComponentList_actionPerformed(e);
            }
        });
        this.jMenuAdminComponentAmmoList.setText("List Ammo Components");
        this.jMenuAdminComponentAmmoList.setMnemonic('A');
        this.jMenuAdminComponentAmmoList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                e.setSource(2);
                AdminMenu.this.jMenuAdminComponentList_actionPerformed(e);
            }
        });
        this.jMenuAdminComponentMiscList.setText("List Misc Components");
        this.jMenuAdminComponentMiscList.setMnemonic('M');
        this.jMenuAdminComponentMiscList.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                e.setSource(1);
                AdminMenu.this.jMenuAdminComponentList_actionPerformed(e);
            }
        });
        this.jMenuAdminSetMegaMekGameOptions.setText("Set MegaMek Game Options");
        this.jMenuAdminSetMegaMekGameOptions.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AdminMenu.this.mwclient.loadMegaMekClient();
            }
        });
        this.removeAll();
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminChangeServerConfig")) {
            this.add(this.jMenuAdminServerConfig);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminChangeFactionConfig")) {
            this.add(this.jMenuAdminFactionConfig);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminTerminateAll")) {
            this.add(this.jMenuAdminTerminateAll);
        }
        if (this.getItemCount() > 0) {
            this.addSeparator();
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminCreatePlanet")) {
            this.jMenuAdminSubCreate.add(this.jMenuAdminCreatePlanet);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminCreateFactory")) {
            this.jMenuAdminSubCreate.add(this.jMenuAdminCreateFactory);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminCreateTerrain")) {
            this.jMenuAdminSubCreate.add(this.jMenuAdminCreateTerrain);
        }
        if (this.jMenuAdminSubCreate.getItemCount() > 0) {
            this.add(this.jMenuAdminSubCreate);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminDestroyPlanet")) {
            this.jMenuAdminSubDestroy.add(this.jMenuAdminDestroyPlanet);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminDestroyFactory")) {
            this.jMenuAdminSubDestroy.add(this.jMenuAdminDestroyFactory);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminDestroyTerrain")) {
            this.jMenuAdminSubDestroy.add(this.jMenuAdminDestroyTerrain);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminListAndRemoveOMG")) {
            this.jMenuAdminSubDestroy.add(this.jMenuAdminRemoveOMG);
        }
        if (this.jMenuAdminSubDestroy.getItemCount() > 0) {
            this.add(this.jMenuAdminSubDestroy);
        }
        JMenu jMenuAdminSubSetHouse = new JMenu();
        JMenu jMenuAdminSubSetPlanet = new JMenu();
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminChangePlanetOwner")) {
            jMenuAdminSubSetHouse.add(this.jMenuAdminChangePlanetOwner);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetHouseFluFile")) {
            jMenuAdminSubSetHouse.add(this.jMenuAdminSetHouseFluFile);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSsetHouseTechLevel")) {
            jMenuAdminSubSetHouse.add(this.jMenuAdminSetHouseTechLevel);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminGrantComponents")) {
            jMenuAdminSubSetHouse.add(this.jMenuAdminGrantComponents);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminExchangePlanetOwnership")) {
            jMenuAdminSubSetHouse.add(this.jMenuAdminExchangePlanetOwnership);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetHouseAmmoBan")) {
            jMenuAdminSubSetHouse.add(this.jMenuAdminHouseAmmoBan);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AddTrait")) {
            jMenuAdminSubSetHouse.add(this.jMenuAdminSetFactionTraits);
        }
        jMenuAdminSubSetHouse.setText("Factions");
        if (jMenuAdminSubSetHouse.getItemCount() > 0) {
            this.jMenuAdminSubSet.add(jMenuAdminSubSetHouse);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminLockFactory")) {
            jMenuAdminSubSetPlanet.add(this.jMenuAdminLockFactory);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetPlanetMapSize")) {
            jMenuAdminSubSetPlanet.add(this.jMenuAdminSetPlanetMapSize);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetPlanetBoardSize")) {
            jMenuAdminSubSetPlanet.add(this.jMenuAdminSetPlanetBoardSize);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetPlanetTemperature")) {
            jMenuAdminSubSetPlanet.add(this.jMenuAdminSetPlanetTemperature);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetPlanetGravity")) {
            jMenuAdminSubSetPlanet.add(this.jMenuAdminSetPlanetGravity);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetPlanetVacuum")) {
            jMenuAdminSubSetPlanet.add(this.jMenuAdminSetPlanetVacuum);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetHomeWorld")) {
            jMenuAdminSubSetPlanet.add(this.jMenuAdminSetPlanetHomeWorld);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetPlanetOriginalOwner")) {
            jMenuAdminSubSetPlanet.add(this.jMenuAdminSetPlanetOriginalOwner);
        }
        jMenuAdminSubSetPlanet.setText("Planets");
        if (jMenuAdminSubSetPlanet.getItemCount() > 0) {
            this.jMenuAdminSubSet.add(jMenuAdminSubSetPlanet);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetServerAmmoBan")) {
            this.jMenuAdminSubSet.add(this.jMenuAdminSetServerAmmoBan);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetBanTargeting")) {
            this.jMenuAdminSubSet.add(this.jMenuAdminSetBanTargeting);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetCommandLevel")) {
            this.jMenuAdminSubSet.add(this.jMenuAdminSetCommandLevel);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AddOmniVariantMod")) {
            this.jMenuAdminSubSet.add(this.jMenuAdminOmniVariantMod);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetAmmoCost")) {
            this.jMenuAdminSubSet.add(this.jMenuAdminSetAmmoCost);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("SetHouseBasePilotSkills")) {
            this.jMenuAdminSubSet.add(this.jMenuAdminSetHouseBasePilotSkill);
        }
        if (this.userLevel >= 200) {
            this.jMenuAdminSubSet.addSeparator();
            this.jMenuAdminSubSet.add(this.jMenuAdminSetMegaMekGameOptions);
        }
        if (this.jMenuAdminSubSet.getItemCount() > 0) {
            this.add(this.jMenuAdminSubSet);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("RetrieveOperation")) {
            this.jMenuAdminOperations.add(this.jMenuAdminRetrieveOperationFile);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("SetOperation")) {
            this.jMenuAdminOperations.add(this.jMenuAdminSetOperationFile);
            this.jMenuAdminOperations.add(this.jMenuAdminSetNewOperationFile);
            this.jMenuAdminOperations.add(this.jMenuAdminSendAllOperationFiles);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("UpdateOperations")) {
            this.jMenuAdminOperations.add(this.jMenuAdminUpdateOperations);
        }
        if (this.jMenuAdminOperations.getItemCount() > 0) {
            this.add(this.jMenuAdminOperations);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSave")) {
            this.jMenuAdminSubSave.add(this.jMenuAdminSaveTheUniverse);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSavePlanetsToXML")) {
            this.jMenuAdminSubSave.add(this.jMenuAdminSavePlanetsToXML);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSaveServerConfigs")) {
            this.jMenuAdminSubSave.add(this.jMenuAdminSaveServerConfigs);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSaveCommandLevels")) {
            this.jMenuAdminSubSave.add(this.jMenuAdminSaveCommandLevels);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSaveBlackMarketConfigs")) {
            this.jMenuAdminSubSave.add(this.jMenuAdminSaveBlackMaketSettings);
        }
        if (this.jMenuAdminSubSave.getItemCount() > 0) {
            this.add(this.jMenuAdminSubSave);
            this.addSeparator();
        }
        if (this.userLevel >= 101) {
            this.add(this.jMenuAdminCommandLists);
        }
        if (this.userLevel >= this.mwclient.getData().getAccessLevel("AdminSetBlackMarketSetting")) {
            this.jMenuAdminBlackMarketSettings.add(this.jMenuAdminComponentWeaponList);
            this.jMenuAdminBlackMarketSettings.add(this.jMenuAdminComponentAmmoList);
            this.jMenuAdminBlackMarketSettings.add(this.jMenuAdminComponentMiscList);
            this.add(this.jMenuAdminBlackMarketSettings);
        }
    }

    public void jMenuAdminCreatePlanet_actionPerformed(ActionEvent e) {
        String planetName = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Planet Name?");
        if (planetName == null || planetName.length() == 0) {
            return;
        }
        String xcord = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Planet x coord");
        if (xcord == null || xcord.length() == 0) {
            return;
        }
        String ycord = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Planet y coord?");
        if (ycord == null || ycord.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c admincreateplanet#" + planetName + "#" + xcord + "#" + ycord + "#");
        this.mwclient.reloadData();
        new PlanetEditorDialog(this.mwclient, planetName);
    }

    public void jMenuAdminDestroyPlanet_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet", null);
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c admindestroyplanet#" + planetNamestr);
        this.mwclient.reloadData();
    }

    public void jMenuAdminCreateFactory_actionPerformed(ActionEvent e) {
        int i;
        Object[] factoryTypes = new Object[]{"All", "Mek", "Vehicles", "Mek & Vehicles", "Infantry", "Mek & Infantry", "Vehicles & Infantry", "Mek & Infantry & Vehicles", "ProtoMeks", "Mek & ProtoMeks", "Vehicles & ProtoMek", "Mek & Vehicles & ProtoMek", "Infantry & ProtoMek", "Mek & Infantry & ProtoMek", "Vehicles & Infantry & ProtoMek", "Mek & Vehicles & Infantry & ProtoMek", "BattleArmor", "Mek & BattleArmor", "Vehicles & BattleArmor", "Mek & Vehicles & BattleArmor", "Infantry & BattleArmor", "Mek & Infantry & BattleArmor", "Vehicles & Infantry & BattleArmor", "Mek & Vehicles & Infantry & BattleArmor", "ProtoMeks & BattleArmor", "Mek & ProtoMeks & BattleArmor", "Vehicles & ProtoMek & BattleArmor", "Mek & Vehicles & ProtoMek & BattleArmor", "Infantry & ProtoMek & BattleArmor", "Mek & Infantry & ProtoMek & BattleArmor", "Vehicles & Infantry & ProtoMek & BattleArmor"};
        Object[] factorySize = new Object[]{"Light", "Medium", "Heavy", "Assault"};
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet", null);
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        String factoryName = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Factory Name");
        if (factoryName == null || factoryName.length() == 0) {
            return;
        }
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Faction", false, false);
        factionDialog.setVisible(true);
        String factionName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (factionName == null || factionName.length() == 0) {
            return;
        }
        String factoryTypestr = (String)JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Select factory production", "Factory Production", 1, null, factoryTypes, factoryTypes[0]);
        if (factoryTypestr == null || factoryTypestr.length() == 0) {
            return;
        }
        for (i = 0; i < factoryTypes.length && !factoryTypestr.equals(factoryTypes[i]); ++i) {
        }
        int factoryTypeint = i;
        String factorySizestr = (String)JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Select a factory size", "FactorySize", 1, null, factorySize, factorySize[0]);
        if (factorySizestr == null || factorySizestr.length() == 0) {
            return;
        }
        StringBuilder sendCommand = new StringBuilder();
        sendCommand.append(planetNamestr.trim() + "#" + factoryName.trim() + "#" + factorySizestr.trim() + "#" + factionName.trim() + "#" + factoryTypeint);
        this.mwclient.sendChat("/c admincreatefactory#" + sendCommand.toString());
        this.mwclient.reloadData();
    }

    public void jMenuAdminDestroyFactory_actionPerformed(ActionEvent e) {
        TreeSet<String> names = new TreeSet<String>();
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet", null);
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        Planet planet = this.mwclient.getData().getPlanetByName(planetNamestr);
        names.clear();
        Iterator<UnitFactory> UF = planet.getUnitFactories().iterator();
        while (UF.hasNext()) {
            names.add(UF.next().getName());
        }
        JComboBox<Object> combo = new JComboBox<Object>(names.toArray());
        combo.setEditable(true);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(null, "Select factory to destroy.");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        String factoryName = (String)combo.getSelectedItem();
        if (factoryName == null || factoryName.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c admindestroyfactory#" + planetNamestr + "#" + factoryName);
        this.mwclient.reloadData();
    }

    public void jMenuAdminCreateTerrain_actionPerformed(ActionEvent e) {
        TreeSet<String> names = new TreeSet<String>();
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet", null);
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        Iterator<PlanetEnvironment> it = this.mwclient.getData().getAllTerrains().iterator();
        while (it.hasNext()) {
            names.add(it.next().getName());
        }
        JComboBox<Object> combo = new JComboBox<Object>(names.toArray());
        combo.setEditable(false);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(null, "Select a Terrain Type.");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        String terrainType = (String)combo.getSelectedItem();
        int value = (Integer)jop.getValue();
        if (value == 2) {
            return;
        }
        if (terrainType == null || terrainType.length() == 0) {
            return;
        }
        String terrainChance = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Terrain Chance", new Integer(100));
        if (terrainChance == null || terrainChance.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c admincreateterrain#" + planetNamestr + "#" + terrainType + "#" + terrainChance);
        this.mwclient.reloadData();
    }

    public void jMenuAdminDestroyTerrain_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet", null);
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        String terrainType = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Select the Terrain position: start with 0 for the top most terrain in the information box");
        if (terrainType == null || terrainType.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c admindestroyterrain#" + planetNamestr + "#" + terrainType);
        this.mwclient.reloadData();
    }

    public void jMenuAdminChangePlanetOwner_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet", null);
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "New Owner", false, false);
        factionDialog.setVisible(true);
        String newOwner = factionDialog.getHouseName();
        factionDialog.dispose();
        if (newOwner == null || newOwner.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c adminchangeplanetowner#" + planetNamestr + "#" + newOwner);
        this.mwclient.reloadData();
    }

    public void jMenuAdminTerminateAll_actionPerformed(ActionEvent e) {
        int confirm = JOptionPane.showConfirmDialog(this.mwclient.getMainFrame(), "Are you sure you want to terminate all waiting/running games?");
        if (confirm != 0) {
            return;
        }
        this.mwclient.sendChat("/c adminterminateall");
    }

    public void jMenuAdminSetHouseFluFile_actionPerformed(ActionEvent e) {
        String factionName = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"House Name:");
        if (factionName == null || factionName.length() == 0) {
            return;
        }
        String fluFilePrefix = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)(this.mwclient.moneyOrFluMessage(false, true, -1) + " File Prefix:"));
        if (fluFilePrefix == null || fluFilePrefix.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c adminsethouseflufile#" + factionName + "#" + fluFilePrefix);
    }

    public void jMenuAdminGrantComponents_actionPerformed(ActionEvent e) {
        Object[] Types = new Object[]{"Mek", "Vehicles", "Infantry", "ProtoMek", "BattleArmor"};
        Object[] Size = new Object[]{"Light", "Medium", "Heavy", "Assault"};
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Faction", false, false);
        factionDialog.setVisible(true);
        String factionName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (factionName == null || factionName.length() == 0) {
            return;
        }
        String Typestr = (String)JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Select component type", "Component Type", 1, null, Types, Types[0]);
        if (Typestr == null || Typestr.length() == 0) {
            return;
        }
        String Sizestr = (String)JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Select a component size", "Component Size", 1, null, Size, Size[0]);
        if (Sizestr == null || Sizestr.length() == 0) {
            return;
        }
        String components = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Amount of Components to add(negative number to subtract)");
        if (components == null || components.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c admingrantcomponents#" + factionName + "#" + Typestr + "#" + Sizestr + "#" + components);
    }

    public void jMenuAdminExchangePlanetOwnership_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Planet", null);
        planetDialog.setVisible(true);
        String planetName = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetName == null || planetName.length() == 0) {
            return;
        }
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Gaining Faction", false, false);
        factionDialog.setVisible(true);
        String winningHouseName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (winningHouseName == null || winningHouseName.length() == 0) {
            return;
        }
        factionDialog = new HouseNameDialog(this.mwclient, "Losing Faction", false, false);
        factionDialog.setVisible(true);
        String losingHouseName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (losingHouseName == null || losingHouseName.length() == 0) {
            return;
        }
        String amount = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Amount");
        if (amount == null || amount.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c adminexchangeplanetownership#" + planetName + "#" + winningHouseName + "#" + losingHouseName + "#" + amount);
    }

    public void jMenuAdminSetHousePriceMod_actionPerformed(ActionEvent e) {
        Object[] unitTypes = new Object[]{"Mek", "Vehicles", "Infantry", "ProtoMek", "BattleArmor"};
        Object[] unitClass = new Object[]{"Light", "Medium", "Heavy", "Assault"};
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Faction", false, false);
        factionDialog.setVisible(true);
        String factionName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (factionName == null || factionName.length() == 0) {
            return;
        }
        String unitTypestr = (String)JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Select Unit Type", "Unit Type", 1, null, unitTypes, unitTypes[0]);
        if (unitTypestr == null || unitTypestr.length() == 0) {
            return;
        }
        String unitClassstr = (String)JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Select Unit Class", "Unit Class", 1, null, unitClass, unitClass[0]);
        if (unitClassstr == null || unitClassstr.length() == 0) {
            return;
        }
        String priceMod = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Price Modifier:");
        if (priceMod == null || priceMod.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c adminsethousepricemod#" + factionName + "#" + unitTypestr + "#" + unitClassstr + "#" + priceMod);
    }

    public void jMenuAdminSetHouseFluMod_actionPerformed(ActionEvent e) {
        Object[] unitTypes = new Object[]{"Mek", "Vehicles", "Infantry", "ProtoMek", "BattleArmor"};
        Object[] unitClass = new Object[]{"Light", "Medium", "Heavy", "Assault"};
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Faction", false, false);
        factionDialog.setVisible(true);
        String factionName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (factionName == null || factionName.length() == 0) {
            return;
        }
        String unitTypestr = (String)JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Select Unit Type", "Unit Type", 1, null, unitTypes, unitTypes[0]);
        if (unitTypestr == null || unitTypestr.length() == 0) {
            return;
        }
        String unitClassstr = (String)JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Select Unit Class", "Unit Class", 1, null, unitClass, unitClass[0]);
        if (unitClassstr == null || unitClassstr.length() == 0) {
            return;
        }
        String fluMod = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Price Modifier:");
        if (fluMod == null || fluMod.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c adminsethouseflumod#" + factionName + "#" + unitTypestr + "#" + unitClassstr + "#" + fluMod);
    }

    public void jMenuAdminSetHouseTechLevel_actionPerformed(ActionEvent e) {
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Faction", false, false);
        factionDialog.setVisible(true);
        String factionName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (factionName == null || factionName.length() == 0) {
            return;
        }
        JComboBox<String> techCombo = new JComboBox<String>(TechConstants.T_NAMES);
        techCombo.setEditable(false);
        JOptionPane jop = new JOptionPane(techCombo, 3, 2);
        JDialog dlg = jop.createDialog(null, "Select Tech Level");
        techCombo.grabFocus();
        techCombo.getEditor().selectAll();
        dlg.setVisible(true);
        if ((Integer)jop.getValue() == 2) {
            return;
        }
        this.mwclient.sendChat("/c adminsethousetechlevel#" + factionName + "#" + techCombo.getSelectedIndex());
    }

    public void jMenuAdminSaveTheUniverse_actionPerformed(ActionEvent e) {
        this.mwclient.sendChat("/c adminsave");
    }

    public void jMenuAdminSaveBlackMaketSettings_actionPerformed(ActionEvent e) {
        this.mwclient.sendChat("/c adminsaveblackmarketconfigs");
    }

    public void jMenuAdminSavePlanetsToXML_actionPerformed(ActionEvent e) {
        this.mwclient.sendChat("/c adminsaveplanetstoxml");
    }

    public void jMenuAdminOmniVariantMod_actionPerformed(ActionEvent e) {
        UnitLoadingDialog unitLoadingDialog = new UnitLoadingDialog(this.mwclient.getMainFrame());
        UnitViewerDialog unitSelector = new UnitViewerDialog(this.mwclient.getMainFrame(), unitLoadingDialog, this.mwclient, 1);
        unitSelector.setName("Unit Selector");
        new Thread(unitSelector).start();
    }

    public void jMenuAdminServerAmmoBan_actionPerformed(ActionEvent e) {
        new BannedAmmoDialog(this.mwclient, null);
    }

    public void jMenuAdminSetBanTargeting_actionPerformed(ActionEvent e) {
        new BanTargetingDialog(this.mwclient);
    }

    public void jMenuAdminRetrieveOperationFile_actionPerformed(ActionEvent e) {
        JComboBox<Object> opCombo = new JComboBox<Object>(this.mwclient.getAllOps().keySet().toArray());
        opCombo.setEditable(false);
        JOptionPane jop = new JOptionPane(opCombo, 3, 2);
        JDialog dlg = jop.createDialog(null, "Select Op.");
        opCombo.grabFocus();
        opCombo.getEditor().selectAll();
        dlg.setVisible(true);
        if ((Integer)jop.getValue() == 2) {
            return;
        }
        String opName = (String)opCombo.getSelectedItem();
        this.mwclient.sendChat("/c RETRIEVEOPERATION#short#" + opName);
    }

    public void jMenuAdminSetOperationFile_actionPerformed(ActionEvent e) {
        JComboBox<Object> opCombo = new JComboBox<Object>(this.mwclient.getAllOps().keySet().toArray());
        opCombo.setEditable(false);
        JOptionPane jop = new JOptionPane(opCombo, 3, 2);
        JDialog dlg = jop.createDialog(null, "Select Op.");
        opCombo.grabFocus();
        opCombo.getEditor().selectAll();
        dlg.setVisible(true);
        if ((Integer)jop.getValue() == 2) {
            return;
        }
        String opName = (String)opCombo.getSelectedItem();
        File opFile = new File("./data/operations/short/" + opName + ".txt");
        if (!opFile.exists()) {
            return;
        }
        StringBuilder opData = new StringBuilder();
        try {
            FileInputStream fis = new FileInputStream(opFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            opData.append(opName + "#");
            while (dis.ready()) {
                opData.append(dis.readLine().replaceAll("#", "(pound)") + "#");
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog("Unable to read " + opFile);
            return;
        }
        this.mwclient.sendChat("/c setoperation#short#" + opData.toString());
    }

    public void jMenuAdminSendAllOperationFiles_actionPerformed(ActionEvent e) {
        int result = JOptionPane.showConfirmDialog(null, "Upload All local OpFiles?", "Upload Ops", 0);
        if (result == 1) {
            return;
        }
        File opFiles = new File("./data/operations/short/");
        if (!opFiles.exists()) {
            return;
        }
        StringBuilder opData = new StringBuilder();
        for (File opFile : opFiles.listFiles()) {
            try {
                FileInputStream fis = new FileInputStream(opFile);
                BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
                opData.append(opFile.getName().substring(0, opFile.getName().lastIndexOf(".txt")) + "#");
                while (dis.ready()) {
                    opData.append(dis.readLine().replaceAll("#", "(pound)") + "#");
                }
                dis.close();
                fis.close();
            }
            catch (Exception ex) {
                MWClient.mwClientLog.clientErrLog("Unable to read " + opFile);
                return;
            }
            this.mwclient.sendChat("/c setoperation#short#" + opData.toString());
            opData.setLength(0);
            opData.trimToSize();
        }
    }

    public void jMenuAdminSetNewOperationFile_actionPerformed(ActionEvent e) {
        String opName = JOptionPane.showInputDialog(this.mwclient.getMainFrame().getContentPane(), (Object)"New Op Name?");
        if (opName == null || opName.trim().length() < 1) {
            return;
        }
        File opFile = new File("./data/operations/short/" + opName + ".txt");
        if (!opFile.exists()) {
            return;
        }
        StringBuilder opData = new StringBuilder();
        try {
            FileInputStream fis = new FileInputStream(opFile);
            BufferedReader dis = new BufferedReader(new InputStreamReader(fis));
            opData.append(opName + "#");
            while (dis.ready()) {
                opData.append(dis.readLine().replaceAll("#", "(pound)") + "#");
            }
            dis.close();
            fis.close();
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog("Unable to read " + opFile);
            return;
        }
        this.mwclient.sendChat("/c setoperation#short#" + opData.toString());
    }

    public void jMenuAdminUpdateOperations_actionPerformed(ActionEvent e) {
        this.mwclient.sendChat("/c updateoperations");
    }

    public void jMenuAdminAmmoCost_actionPerformed(ActionEvent e) {
        new AmmoCostDialog(this.mwclient);
    }

    public void jMenuAdminHouseAmmoBan_actionPerformed(ActionEvent e) {
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Select Faction", false, false);
        factionDialog.setVisible(true);
        String factionName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (factionName == null || factionName.length() == 0) {
            return;
        }
        new BannedAmmoDialog(this.mwclient, this.mwclient.getData().getHouseByName(factionName));
    }

    public void jMenuAdminSetHouseBasePilotSkills_actionPerformed(ActionEvent e) {
        int i;
        HouseNameDialog factionDialog = new HouseNameDialog(this.mwclient, "Select Faction", false, false);
        factionDialog.setVisible(true);
        String factionName = factionDialog.getHouseName();
        factionDialog.dispose();
        if (factionName == null || factionName.length() == 0) {
            return;
        }
        Object[] unitTypes = new Object[]{"Mek", "Vehicles", "Infantry", "ProtoMeks", "BattleArmor"};
        String unitTypestr = (String)JOptionPane.showInputDialog(this.mwclient.getMainFrame(), "Select Unit Type", "Unit Type", 1, null, unitTypes, unitTypes[0]);
        if (unitTypestr == null || unitTypestr.length() == 0) {
            return;
        }
        for (i = 0; i < unitTypes.length && !unitTypestr.equals(unitTypes[i]); ++i) {
        }
        int unitTypeint = i;
        String gunnery = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Base Gunnery");
        if (gunnery == null || gunnery.length() == 0) {
            return;
        }
        String piloting = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Base Piloting");
        if (piloting == null || piloting.length() == 0) {
            return;
        }
        StringBuffer sendCommand = new StringBuffer();
        sendCommand.append(factionName);
        sendCommand.append("#");
        sendCommand.append(unitTypeint);
        sendCommand.append("#");
        sendCommand.append(gunnery);
        sendCommand.append("#");
        sendCommand.append(piloting);
        this.mwclient.sendChat("/c sethousebasepilotskills#" + sendCommand.toString());
    }

    public void jMenuAdminSetCommandLevel_actionPerformed(ActionEvent e) {
        CommandNameDialog commandDialog = new CommandNameDialog(this.mwclient, "Select a Command");
        commandDialog.setVisible(true);
        String commandNamestr = commandDialog.getCommandName();
        commandDialog.dispose();
        if (commandNamestr == null || commandNamestr.equalsIgnoreCase("null")) {
            return;
        }
        String level = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Level");
        if (level == null || level.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c adminsetCommandLevel#" + commandNamestr + "#" + level);
    }

    public void jMenuAdminLockFactory_actionPerformed(ActionEvent e) {
        TreeSet<String> names = new TreeSet<String>();
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet", null);
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        Planet planet = this.mwclient.getData().getPlanetByName(planetNamestr);
        Iterator<UnitFactory> UF = planet.getUnitFactories().iterator();
        while (UF.hasNext()) {
            names.add(UF.next().getName());
        }
        JComboBox<Object> combo = new JComboBox<Object>(names.toArray());
        combo.setEditable(true);
        JOptionPane jop = new JOptionPane(combo, 3, 2);
        JDialog dlg = jop.createDialog(null, "Select factory to toggle the lock on.");
        combo.grabFocus();
        combo.getEditor().selectAll();
        dlg.setVisible(true);
        String factoryName = (String)combo.getSelectedItem();
        if (factoryName == null || factoryName.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c adminlockfactory#" + planetNamestr + "#" + factoryName);
        this.mwclient.reloadData();
    }

    public void jMenuAdminSetPlanetMapSize_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet", null);
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        String xSize = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"X size");
        if (xSize == null || xSize.length() == 0) {
            return;
        }
        String ySize = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Y Size");
        if (ySize == null || ySize.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c adminsetplanetmapsize#" + planetNamestr + "#" + xSize + "#" + ySize);
        this.mwclient.reloadData();
    }

    public void jMenuAdminSetPlanetHomeWorld_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet", null);
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        int result = JOptionPane.showConfirmDialog(null, "Set as HomeWorld?", "Set HomeWorld", 1);
        if (result == 2) {
            return;
        }
        boolean homeworld = false;
        if (result == 0) {
            homeworld = true;
        }
        this.mwclient.sendChat("/c adminsethomeworld#" + planetNamestr + "#" + homeworld);
        this.mwclient.reloadData();
    }

    public void jMenuAdminSetPlanetBoardSize_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet", null);
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        String xSize = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"X size");
        if (xSize == null || xSize.length() == 0) {
            return;
        }
        String ySize = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Y Size");
        if (ySize == null || ySize.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c adminsetplanetboardsize#" + planetNamestr + "#" + xSize + "#" + ySize);
        this.mwclient.reloadData();
    }

    public void jMenuAdminSetPlanetOriginalOwner_actionPerformed(ActionEvent ex) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet", null);
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        HouseNameDialog hnd = new HouseNameDialog(this.mwclient, "Select Original Owner", false, false);
        hnd.setVisible(true);
        String owner = hnd.getHouseName();
        hnd.dispose();
        if (owner == null || owner.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c adminsetplanetoriginalowner#" + planetNamestr + "#" + owner);
        this.mwclient.reloadData();
    }

    public void jMenuAdminSetPlanetTemperature_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet", null);
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        String lowTemp = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Low Temp");
        if (lowTemp == null || lowTemp.length() == 0) {
            return;
        }
        String hiTemp = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Hi Temp");
        if (hiTemp == null || hiTemp.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c adminsetplanettemperature#" + planetNamestr + "#" + lowTemp + "#" + hiTemp);
        this.mwclient.reloadData();
    }

    public void jMenuAdminSetPlanetGravity_actionPerformed(ActionEvent e) {
        PlanetNameDialog planetDialog = new PlanetNameDialog(this.mwclient, "Select a Planet", null);
        planetDialog.setVisible(true);
        String planetNamestr = planetDialog.getPlanetName();
        planetDialog.dispose();
        if (planetNamestr == null || planetNamestr.length() == 0) {
            return;
        }
        String grav = JOptionPane.showInputDialog(this.mwclient.getMainFrame(), (Object)"Gravity");
        if (grav == null || grav.length() == 0) {
            return;
        }
        this.mwclient.sendChat("/c adminsetplanetgravity#" + planetNamestr + "#" + grav);
        this.mwclient.reloadData();
    }

    public void jMenuAdminCommandLists_actionPerformed(ActionEvent e) {
        CommandNameDialog commandDialog = new CommandNameDialog(this.mwclient, "Select a Command");
        commandDialog.setVisible(true);
        String commandNamestr = commandDialog.getCommandName();
        commandDialog.dispose();
        if (commandNamestr != null) {
            String input = "/" + commandNamestr;
            this.mwclient.getMainFrame().getMainPanel().getCommPanel().setInput(input);
            this.mwclient.getMainFrame().getMainPanel().getCommPanel().focusInputField();
        }
    }

    public void jMenuAdminComponentList_actionPerformed(ActionEvent e) {
        int type = (Integer)e.getSource();
        new ComponentDisplayDialog(this.mwclient, type);
    }
}

