/*
 * Decompiled with CFR 0.152.
 */
package admin.dialog;

import client.MWClient;
import client.gui.SpringLayoutHelper;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeSet;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class OpFlagSelectionDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = -1024120117465498506L;
    private final TreeSet<String> names;
    private JList matchingCommandList;
    private JScrollPane scrollPane;
    private JTextField nameField;
    private final JButton okayButton = new JButton("OK");
    private final JButton cancelButton = new JButton("Cancel");
    private final String okayCommand = "Okay";
    private MWClient client = null;
    private Object[] commandName = null;

    public OpFlagSelectionDialog(MWClient mwclient, String boxText) {
        super(new JFrame(), boxText, true);
        this.client = mwclient;
        this.loadOpFlags();
        this.names = new TreeSet();
        for (String key : mwclient.getData().getPlanetOpFlags().values()) {
            this.names.add(key);
        }
        final Object[] allCommandNames = this.names.toArray();
        this.matchingCommandList = new JList<Object>(allCommandNames);
        this.matchingCommandList.setVisibleRowCount(10);
        this.matchingCommandList.setSelectionMode(2);
        this.nameField = new JTextField();
        this.nameField.addCaretListener(new CaretListener(){

            public void caretUpdate(CaretEvent e) {
                new Thread(){

                    public void run() {
                        String text = OpFlagSelectionDialog.this.nameField.getText();
                        if (text == null || text.equals("")) {
                            OpFlagSelectionDialog.this.matchingCommandList.setListData(allCommandNames);
                            return;
                        }
                        ArrayList<String> possibleCommands = new ArrayList<String>();
                        text = text.toLowerCase();
                        for (String curCommand : OpFlagSelectionDialog.this.names) {
                            if (curCommand.toLowerCase().indexOf(text) == -1) continue;
                            possibleCommands.add(curCommand.substring(0, 1) + curCommand.substring(1).toLowerCase());
                        }
                        OpFlagSelectionDialog.this.matchingCommandList.setListData(possibleCommands.toArray());
                        boolean shouldContinue = true;
                        int element = 0;
                        Iterator it = possibleCommands.iterator();
                        while (it.hasNext() && shouldContinue) {
                            String name = (String)it.next();
                            if (name.toLowerCase().startsWith(text)) {
                                OpFlagSelectionDialog.this.matchingCommandList.setSelectedIndex(element);
                                shouldContinue = false;
                            }
                            ++element;
                        }
                        if (shouldContinue) {
                            OpFlagSelectionDialog.this.matchingCommandList.setSelectedIndex(0);
                        }
                    }
                }.start();
            }
        });
        this.scrollPane = new JScrollPane(this.matchingCommandList);
        this.scrollPane.setAlignmentX(0.0f);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.okayButton.setActionCommand("Okay");
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        JPanel springPanel = new JPanel(new SpringLayout());
        springPanel.add(this.nameField);
        springPanel.add(this.scrollPane);
        SpringLayoutHelper.setupSpringGrid(springPanel, 2, 1);
        JPanel buttonFlow = new JPanel();
        buttonFlow.add(this.okayButton);
        buttonFlow.add(this.cancelButton);
        JPanel generalLayout = new JPanel();
        generalLayout.setLayout(new BoxLayout(generalLayout, 1));
        generalLayout.add(springPanel);
        generalLayout.add(buttonFlow);
        this.getContentPane().add(generalLayout);
        this.pack();
        this.checkMinimumSize();
        this.setResizable(true);
        this.getRootPane().setDefaultButton(this.okayButton);
        this.setLocationRelativeTo(null);
    }

    public void actionPerformed(ActionEvent event) {
        String command = event.getActionCommand();
        if (command.equals("Okay")) {
            String selectedCommand = (String)this.matchingCommandList.getSelectedValue();
            if (selectedCommand == null) {
                selectedCommand = this.nameField.getText();
            }
            if (selectedCommand == null || selectedCommand.equals("")) {
                return;
            }
            if (this.matchingCommandList.getModel().getSize() >= 1) {
                this.setCommandName(this.matchingCommandList.getSelectedValues());
            } else {
                JOptionPane.showMessageDialog(null, "Unknown Terrain");
            }
        }
        this.dispose();
    }

    private void checkMinimumSize() {
        Dimension curDim = this.getSize();
        int height = 0;
        int width = 0;
        boolean shouldRedraw = false;
        if (curDim.getWidth() < 300.0) {
            width = 300;
            shouldRedraw = true;
        } else {
            width = (int)curDim.getWidth();
        }
        if (curDim.getHeight() < 150.0) {
            height = 150;
            shouldRedraw = true;
        } else {
            height = (int)curDim.getHeight();
        }
        if (shouldRedraw) {
            this.setSize(new Dimension(width, height));
        }
    }

    private void setCommandName(Object[] terrains) {
        this.commandName = terrains;
    }

    public Object[] getCommandName() {
        return this.commandName;
    }

    private void loadOpFlags() {
        this.client.getData().getPlanetOpFlags().clear();
        this.client.sendChat("/c getserveropflags");
        for (int count = 0; this.client.getData().getPlanetOpFlags().isEmpty() && count < 1000; ++count) {
            try {
                Thread.sleep(125L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

