/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.CampaignData;
import common.persistence.MMNetSerializable;
import common.persistence.TreeReader;
import common.persistence.TreeWriter;
import common.util.BinReader;
import common.util.BinWriter;
import common.util.HTML;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class House
implements MMNetSerializable {
    public static final int RED_VALUE = 0;
    public static final int GREEN_VALUE = 1;
    public static final int BLUE_VALUE = 2;
    private String name = "none";
    private String logo = "";
    private String factionFluFile = "Common";
    private Integer id;
    private Vector<Integer> baseGunner = new Vector(5);
    private Vector<Integer> basePilot = new Vector(5);
    private Vector<String> basePilotSkills = new Vector(5);
    private int[][] factionUnitPriceMod = new int[5][4];
    private int[][] factionUnitFluMod = new int[5][4];
    private int[][] factionUnitComponentMod = new int[5][4];
    private String factionColor = "#000000";
    private String abbreviation = "";
    private String factionPlayerColors = "#000000";
    private boolean conquerable = true;
    private Hashtable<String, String> BannedAmmo = new Hashtable();
    private int techLevel = -2;
    private boolean allowDefectionsFrom = true;
    private boolean allowDefectionsTo = true;

    public int getBaseGunner() {
        return this.baseGunner.elementAt(0);
    }

    public Vector<Integer> getBaseGunnerVect() {
        return this.baseGunner;
    }

    public int getBaseGunner(int type) {
        return this.baseGunner.elementAt(type);
    }

    public Vector<String> getBasePilotSkillVect() {
        return this.basePilotSkills;
    }

    public String getBasePilotSkill(int type) {
        return this.basePilotSkills.elementAt(type);
    }

    public void setBaseGunner(int baseGunner) {
        this.baseGunner.set(0, baseGunner);
    }

    public void setBasePilotSkill(String basePilotSkill, int type) {
        this.basePilotSkills.set(type, basePilotSkill);
    }

    public void setBaseGunner(int baseGunner, int type) {
        this.baseGunner.set(type, baseGunner);
    }

    public int getBasePilot() {
        return this.basePilot.elementAt(0);
    }

    public int getBasePilot(int type) {
        return this.basePilot.elementAt(type);
    }

    public Vector<Integer> getBasePilotVect() {
        return this.basePilot;
    }

    public void setBasePilot(int basePilot) {
        this.basePilot.set(0, basePilot);
    }

    public void setBasePilot(int basePilot, int type) {
        this.basePilot.set(type, basePilot);
    }

    public String getAbbreviation() {
        return this.abbreviation;
    }

    public void setAbbreviation(String myAbbreviation) {
        this.abbreviation = myAbbreviation;
    }

    public boolean isConquerable() {
        return this.conquerable;
    }

    public void setConquerable(boolean conquerable) {
        this.conquerable = conquerable;
    }

    public String getHouseColor() {
        return this.factionColor;
    }

    public void setHouseColor(String factionColor) {
        this.factionColor = factionColor;
    }

    public String getLogo() {
        return this.logo;
    }

    public void setLogo(String logo) {
        this.logo = logo;
    }

    public String getHouseFluFile() {
        return this.factionFluFile;
    }

    public void setHouseFluFile(String factionFlu) {
        this.factionFluFile = factionFlu;
    }

    public String getName() {
        return this.name;
    }

    public String getNameAsLink() {
        return "<a href=\"MEKWARS/c faction#" + this.name + "\">" + this.name + "</a>";
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getId() {
        if (this.id == null) {
            return -1;
        }
        return this.id;
    }

    public House(int id) {
        this.id = id;
        for (int pos = 0; pos < 5; ++pos) {
            this.baseGunner.add(4);
            this.basePilot.add(5);
            this.basePilotSkills.add(" ");
        }
    }

    public House() {
        for (int pos = 0; pos < 5; ++pos) {
            this.baseGunner.add(4);
            this.basePilot.add(5);
            this.basePilotSkills.add(" ");
        }
    }

    public void binOut(BinWriter out) throws IOException {
        int weight;
        int type;
        out.println(this.id, "id");
        out.println(this.name, "name");
        out.println(this.logo, "logo");
        out.println(this.getBaseGunner(), "baseGunner");
        out.println(this.getBasePilot(), "basePilot");
        out.println(this.factionColor, "factionColor");
        out.println(this.factionPlayerColors, "factionPlayerColor");
        out.println(this.abbreviation, "abbreviation");
        out.println(this.conquerable, "conquerable");
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                out.println(this.getHouseUnitComponentMod(type, weight), "componentMod" + type + weight);
            }
        }
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                out.println(this.getHouseUnitPriceMod(type, weight), "priceMod" + type + weight);
            }
        }
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                out.println(this.getHouseUnitFluMod(type, weight), "fluMod" + type + weight);
            }
        }
        out.println(this.getBannedAmmo().size(), "factionbannedammosize");
        Enumeration<String> banned = this.getBannedAmmo().keys();
        while (banned.hasMoreElements()) {
            String munition = banned.nextElement();
            out.println(munition, "munition");
        }
        for (int pos = 0; pos < 5; ++pos) {
            out.println(this.basePilotSkills.elementAt(pos), "factionBasePilotSkill");
        }
        out.println(this.getTechLevel(), "techLevel");
        out.println(this.getHouseDefectionFrom(), "defectFrom");
        out.println(this.getHouseDefectionTo(), "defectTo");
    }

    public House(BinReader in) throws IOException {
        int weight;
        int type;
        for (int pos = 0; pos < 5; ++pos) {
            this.baseGunner.add(4);
            this.basePilot.add(5);
            this.basePilotSkills.add(" ");
        }
        this.id = new Integer(in.readInt("id"));
        this.name = HTML.br2cr(in.readLine("name"));
        this.logo = HTML.br2cr(in.readLine("logo"));
        this.setBaseGunner(in.readInt("baseGunner"));
        this.setBasePilot(in.readInt("basePilot"));
        this.factionColor = in.readLine("factionColor");
        this.factionPlayerColors = in.readLine("factionPlayerColor");
        this.abbreviation = in.readLine("abbreviation");
        this.conquerable = in.readBoolean("conquerable");
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                this.setHouseUnitComponentMod(type, weight, in.readInt("componentMod" + type + weight));
            }
        }
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                this.setHouseUnitPriceMod(type, weight, in.readInt("priceMod" + type + weight));
            }
        }
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                this.setHouseUnitFluMod(type, weight, in.readInt("fluMod" + type + weight));
            }
        }
        for (int size = in.readInt("factionbannedammosize"); size > 0; --size) {
            this.BannedAmmo.put(in.readLine("munition"), "Banned");
        }
        for (int pos = 0; pos < 5; ++pos) {
            this.basePilotSkills.set(pos, in.readLine("factionBasePilotSkill"));
        }
        this.setTechLevel(in.readInt("techLevel"));
        this.setHouseDefectionFrom(in.readBoolean("defectFrom"));
        this.setHouseDefectionTo(in.readBoolean("defectTo"));
    }

    public void setId(int id) {
        this.id = id;
    }

    @Override
    public void binOut(TreeWriter out) {
        int weight;
        int type;
        out.write(this.id, "id");
        out.write(this.name, "name");
        out.write(this.logo, "logo");
        out.write(this.baseGunner, "baseGunner");
        out.write(this.basePilot, "basePilot");
        out.write(this.factionColor, "factionColor");
        out.write(this.factionPlayerColors, "factionPlayerColor");
        out.write(this.abbreviation, "abbreviation");
        out.write(this.conquerable, "conquerable");
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                out.write(this.getHouseUnitComponentMod(type, weight), "componentMod" + type + weight);
            }
        }
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                out.write(this.getHouseUnitPriceMod(type, weight), "priceMod" + type + weight);
            }
        }
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                out.write(this.getHouseUnitFluMod(type, weight), "fluMod" + type + weight);
            }
        }
        out.write(this.getBannedAmmo().size(), "factionbannedammosize");
        Enumeration<String> banned = this.getBannedAmmo().keys();
        while (banned.hasMoreElements()) {
            out.write(banned.nextElement(), "munition");
        }
        for (int pos = 0; pos < 5; ++pos) {
            out.write(this.basePilotSkills.elementAt(pos), "factionBasePilotSkill");
        }
    }

    @Override
    public void binIn(TreeReader in, CampaignData dataProvider) throws IOException {
        int weight;
        int type;
        for (int pos = 0; pos < 5; ++pos) {
            this.baseGunner.add(4);
            this.basePilot.add(5);
            this.basePilotSkills.add(" ");
        }
        this.id = new Integer(in.readInt("id"));
        this.name = HTML.br2cr(in.readString("name"));
        this.logo = HTML.br2cr(in.readString("logo"));
        this.setBaseGunner(in.readInt("baseGunner"));
        this.setBasePilot(in.readInt("basePilot"));
        this.factionColor = in.readString("factionColor");
        this.factionPlayerColors = in.readString("factionPlayerColor");
        this.abbreviation = in.readString("abbreviation");
        this.conquerable = in.readBoolean("conquerable");
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                this.setHouseUnitComponentMod(type, weight, in.readInt("componentMod" + type + weight));
            }
        }
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                this.setHouseUnitPriceMod(type, weight, in.readInt("priceMod" + type + weight));
            }
        }
        for (type = 0; type < 5; ++type) {
            for (weight = 0; weight < 4; ++weight) {
                this.setHouseUnitFluMod(type, weight, in.readInt("fluMod" + type + weight));
            }
        }
        for (int size = in.readInt("factionbannedammosize"); size > 0; --size) {
            this.BannedAmmo.put(in.readString("munition"), "Banned");
        }
        for (int pos = 0; pos < 5; ++pos) {
            this.basePilotSkills.set(pos, in.readString("factionBasePilotSkill"));
        }
    }

    public int getHouseUnitPriceMod(int type, int weight) {
        return this.factionUnitPriceMod[type][weight];
    }

    public void setHouseUnitPriceMod(int type, int weight, int mod) {
        this.factionUnitPriceMod[type][weight] = mod;
    }

    public int getHouseUnitFluMod(int type, int weight) {
        return this.factionUnitFluMod[type][weight];
    }

    public void setHouseUnitFluMod(int type, int weight, int mod) {
        this.factionUnitFluMod[type][weight] = mod;
    }

    public int getHouseUnitComponentMod(int type, int weight) {
        return this.factionUnitComponentMod[type][weight];
    }

    public void setHouseUnitComponentMod(int type, int weight, int mod) {
        this.factionUnitComponentMod[type][weight] = mod;
    }

    public void setHousePlayerColors(String factionPlayerColor) {
        this.factionPlayerColors = factionPlayerColor.startsWith("#") ? factionPlayerColor : "#" + factionPlayerColor;
    }

    public String getHousePlayerColor() {
        return this.factionPlayerColors;
    }

    public Hashtable<String, String> getBannedAmmo() {
        return this.BannedAmmo;
    }

    public void setTechLevel(int level) {
        this.techLevel = this.techLevel < 0 ? 7 : level;
    }

    public int getTechLevel() {
        return this.techLevel;
    }

    public boolean getHouseDefectionFrom() {
        return this.allowDefectionsFrom;
    }

    public void setHouseDefectionFrom(boolean defection) {
        this.allowDefectionsFrom = defection;
    }

    public boolean getHouseDefectionTo() {
        return this.allowDefectionsTo;
    }

    public void setHouseDefectionTo(boolean defection) {
        this.allowDefectionsTo = defection;
    }
}

