/*
 * Decompiled with CFR 0.152.
 */
package common;

import common.Army;
import common.campaign.pilot.Pilot;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Tank;

public class Unit {
    public static final int LIGHT = 0;
    public static final int MEDIUM = 1;
    public static final int HEAVY = 2;
    public static final int ASSAULT = 3;
    public static final int MEK = 0;
    public static final int VEHICLE = 1;
    public static final int INFANTRY = 2;
    public static final int PROTOMEK = 3;
    public static final int BATTLEARMOR = 4;
    public static final int QUAD = 5;
    public static final int MEKWARRIOR = 6;
    public static final int MAXBUILD = 5;
    public static final int C3_NONE = 0;
    public static final int C3_SLAVE = 1;
    public static final int C3_MASTER = 2;
    public static final int C3_IMPROVED = 3;
    public static final int C3_MMASTER = 4;
    public static final int STATUS_OK = 1;
    public static final int STATUS_UNMAINTAINED = 2;
    public static final int STATUS_FORSALE = 3;
    public static final int TOTALTYPES = 5;
    protected Integer id;
    private Pilot pilot;
    private int type;
    private int weightclass;
    private int status = 1;
    private String producer;
    private String UnitFilename;
    private int posId;
    private String Modelname;
    private int maintainanceLevel = 100;
    private int unitC3Level = 0;
    public int[] test = new int[4];
    public int simpleRepairCost = 0;
    private int currentRepairCost = 0;
    private int lifeTimeRepairCost = 0;

    public static String getWeightClassDesc(int weightclass) {
        if (weightclass == 0) {
            return "Light";
        }
        if (weightclass == 1) {
            return "Medium";
        }
        if (weightclass == 2) {
            return "Heavy";
        }
        if (weightclass == 3) {
            return "Assault";
        }
        return "Unknown";
    }

    public static int getWeightIDForName(String name) {
        if (name.equalsIgnoreCase("LIGHT")) {
            return 0;
        }
        if (name.equalsIgnoreCase("MEDIUM")) {
            return 1;
        }
        if (name.equalsIgnoreCase("HEAVY")) {
            return 2;
        }
        if (name.equalsIgnoreCase("ASSAULT")) {
            return 3;
        }
        return 0;
    }

    public static int getEntityWeight(Entity ent) {
        int weight = ent.getWeightClass();
        if (weight == 0) {
            return 0;
        }
        if (weight == 1) {
            return 1;
        }
        if (weight == 2) {
            return 2;
        }
        if (weight == 3) {
            return 3;
        }
        return 0;
    }

    public static int getEntityType(Entity ent) {
        if (ent instanceof Mech || ent instanceof QuadMech) {
            return 0;
        }
        if (ent instanceof Tank) {
            return 1;
        }
        if (ent instanceof BattleArmor) {
            return 4;
        }
        if (ent instanceof Protomech) {
            return 3;
        }
        return 2;
    }

    public static String getDescriptionForID(int type) {
        if (type == 0) {
            return "Mek";
        }
        if (type == 1) {
            return "Vehicle";
        }
        if (type == 2) {
            return "Infantry";
        }
        if (type == 4) {
            return "BattleArmor";
        }
        if (type == 3) {
            return "ProtoMek";
        }
        return "Unknown";
    }

    public static String getTypeClassDesc(int type_id) {
        if (type_id == 0) {
            return "Mek";
        }
        if (type_id == 1) {
            return "Vehicle";
        }
        if (type_id == 2) {
            return "Infantry";
        }
        if (type_id == 4) {
            return "BattleArmor";
        }
        if (type_id == 3) {
            return "ProtoMek";
        }
        return "unknown";
    }

    public static int getTypeIDForName(String name) {
        if (name.toLowerCase().startsWith("v")) {
            return 1;
        }
        if (name.toLowerCase().startsWith("i")) {
            return 2;
        }
        if (name.toLowerCase().startsWith("p")) {
            return 3;
        }
        if (name.toLowerCase().startsWith("b")) {
            return 4;
        }
        return 0;
    }

    public String checkModelName() {
        return this.Modelname;
    }

    public void setModelname(String modelname) {
        this.Modelname = modelname;
    }

    public Pilot getPilot() {
        return this.pilot;
    }

    public void setPilot(Pilot p) {
        this.pilot = p;
    }

    public int getPosId() {
        return this.posId;
    }

    public void setPosId(int pid) {
        this.posId = pid;
    }

    public String getProducer() {
        return this.producer;
    }

    public void setProducer(String s) {
        this.producer = s;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int i) {
        this.type = i;
    }

    public String getUnitFilename() {
        return this.UnitFilename.trim();
    }

    public void setUnitFilename(String s) {
        this.UnitFilename = s;
    }

    public int getWeightclass() {
        return this.weightclass;
    }

    public void setWeightclass(int i) {
        this.weightclass = i;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int i) {
        this.status = i;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int i) {
        this.id = new Integer(i);
    }

    public int getMaintainanceLevel() {
        return this.maintainanceLevel;
    }

    public void setMaintainanceLevel(int i) {
        if (i < 0) {
            i = 0;
        }
        if (i > 100) {
            i = 100;
        }
        this.maintainanceLevel = i;
    }

    public void addToMaintainanceLevel(int i) {
        this.setMaintainanceLevel(this.maintainanceLevel + i);
    }

    public int linkToC3Network(Army army, Unit master) {
        if (army == null || master == null) {
            return -1;
        }
        if (army.getUnit(this.getId()) == null) {
            return -1;
        }
        if (this.getC3Level() == 0) {
            return -1;
        }
        if (this.getC3Level() == 1) {
            if (master.getC3Level() != 2 && master.getC3Level() != 4) {
                return -1;
            }
            if (master.hasBeenC3LinkedTo(army) && !master.hasC3SlavesLinkedTo(army)) {
                return -1;
            }
            if (!master.checkC3mNetworkHasOpen(army, this.getC3Level())) {
                return -1;
            }
            army.getC3Network().put(new Integer(this.getId()), new Integer(master.getId()));
            return master.getId();
        }
        if (this.getC3Level() == 2 || this.getC3Level() == 4) {
            if (master.getC3Level() != 2 && master.getC3Level() != 4) {
                return -1;
            }
            if (this.hasBeenC3LinkedTo(army) && !this.hasC3SlavesLinkedTo(army)) {
                return -1;
            }
            if (master.getC3Level() != 4 && master.hasBeenC3LinkedTo(army) && master.hasC3SlavesLinkedTo(army)) {
                return -1;
            }
            if (!master.checkC3mNetworkHasOpen(army, this.getC3Level())) {
                return -1;
            }
            army.getC3Network().put(new Integer(this.getId()), new Integer(master.getId()));
            return master.getId();
        }
        if (this.getC3Level() == 3) {
            if (master.getC3Level() != 3) {
                return -1;
            }
            if (this.hasBeenC3LinkedTo(army)) {
                return -1;
            }
            if (!master.checkC3iNetworkHasOpen(army)) {
                return -1;
            }
            army.getC3Network().put(new Integer(this.getId()), new Integer(master.getId()));
            return master.getId();
        }
        return -1;
    }

    public boolean hasBeenC3LinkedTo(Army army) {
        if (army.getUnit(this.getId()) == null) {
            return false;
        }
        for (Integer c3U : army.getC3Network().values()) {
            if (c3U.intValue() != this.getId()) continue;
            return true;
        }
        return false;
    }

    public boolean hasC3SlavesLinkedTo(Army army) {
        if (army.getUnit(this.getId()) == null) {
            return false;
        }
        for (Integer c3Slave : army.getC3Network().keySet()) {
            Integer c3Master = army.getC3Network().get(c3Slave);
            if (c3Master.intValue() != this.getId() || army.getUnit(c3Slave).getC3Level() == 1) continue;
            return false;
        }
        return true;
    }

    public boolean checkC3mNetworkHasOpen(Army army, int c3Type) {
        int MAX_UNITS = 4;
        int unitCount = 1;
        if (army == null) {
            return false;
        }
        if (army.getUnit(this.getId()) == null) {
            return false;
        }
        if (army.getC3Network().get(new Integer(this.getId())) != null) {
            return false;
        }
        if (this.getC3Level() == 4) {
            int slaveCount = 0;
            int masterCount = 0;
            int maxMasters = 2;
            int maxSlaves = 3;
            for (Integer c3Slave : army.getC3Network().keySet()) {
                Integer c3Master = army.getC3Network().get(c3Slave);
                if (c3Master.intValue() != this.getId()) continue;
                Unit tempUnit = army.getUnit(c3Slave);
                if (tempUnit.getC3Level() == 1) {
                    ++slaveCount;
                    continue;
                }
                ++masterCount;
            }
            if (c3Type != 1 && masterCount >= maxMasters) {
                return false;
            }
            return c3Type != 1 || slaveCount < maxSlaves;
        }
        for (Integer c3Unit : army.getC3Network().values()) {
            if (c3Unit.intValue() != this.getId()) continue;
            ++unitCount;
        }
        return unitCount < MAX_UNITS;
    }

    public boolean checkC3iNetworkHasOpen(Army army) {
        int MAX_UNITS = 6;
        int unitCount = 1;
        if (army == null) {
            return false;
        }
        if (army.getUnit(this.getId()) == null) {
            return false;
        }
        if (army.getC3Network().get(new Integer(this.getId())) != null) {
            return false;
        }
        for (Integer c3U : army.getC3Network().values()) {
            if (c3U.intValue() != this.getId()) continue;
            ++unitCount;
        }
        return unitCount < MAX_UNITS;
    }

    public void getC3Type(Entity unit) {
        unit.setShutDown(false);
        if (unit.hasC3S()) {
            this.setC3Level(1);
        } else if (unit.hasC3MM()) {
            this.setC3Level(4);
        } else if (unit.hasC3M()) {
            this.setC3Level(2);
        } else if (unit.hasC3i()) {
            this.setC3Level(3);
        } else {
            this.setC3Level(0);
        }
    }

    public int getC3Level() {
        return this.unitC3Level;
    }

    public void setC3Level(int level) {
        this.unitC3Level = level;
    }

    public AmmoType getEntityAmmo(int weaponType, String ammoName) {
        Vector<AmmoType> v_Ammo = AmmoType.getMunitionsFor(weaponType);
        AmmoType at = null;
        for (int count = 0; count < v_Ammo.size(); ++count) {
            at = v_Ammo.elementAt(count);
            if (!at.getInternalName().equalsIgnoreCase(ammoName)) continue;
            return at;
        }
        return null;
    }

    public boolean hasVacantPilot() {
        return this.getPilot() == null || this.getPilot().getName().equalsIgnoreCase("Vacant");
    }

    public void setRepairCosts(int current, int life) {
        this.currentRepairCost = current;
        this.lifeTimeRepairCost = life;
    }

    public void addRepairCost(int cost) {
        if (cost < 0) {
            this.currentRepairCost = 0;
        } else {
            this.currentRepairCost += cost;
            this.lifeTimeRepairCost += cost;
        }
    }

    public int getCurrentRepairCost() {
        return this.currentRepairCost;
    }

    public int getLifeTimeRepairCost() {
        return this.lifeTimeRepairCost;
    }
}

