/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import megamek.client.bot.MoveOption;
import megamek.client.bot.Strategy;
import megamek.client.bot.TestBot;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.GunEmplacement;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.WeaponType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CEntity {
    static final double[][] TANK_ARMOR = new double[][]{{0.0, 1.0, 0.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0}, {0.0, 0.0, 0.0, 1.0, 0.0}, {0.0, 0.0, 1.0, 0.0, 0.0}};
    static final double[][] TANK_WT_ARMOR = new double[][]{{0.0, 0.8611111111111112, 0.0, 0.0, 0.0, 0.1388888888888889}, {0.0, 0.0, 0.0, 0.0, 0.8611111111111112, 0.1388888888888889}, {0.0, 0.0, 0.0, 0.8611111111111112, 0.0, 0.1388888888888889}, {0.0, 0.0, 0.8611111111111112, 0.0, 0.0, 0.1388888888888889}};
    static final double[][] INFANTRY_ARMOR = new double[][]{{1.0}, {1.0}, {1.0}, {1.0}};
    static final double[][] ISBA_ARMOR = new double[][]{{0.25, 0.25, 0.25, 0.25}, {0.25, 0.25, 0.25, 0.25}, {0.25, 0.25, 0.25, 0.25}, {0.25, 0.25, 0.25, 0.25}};
    static final double[][] CLBA_ARMOR = new double[][]{{0.2, 0.2, 0.2, 0.2, 0.2}, {0.2, 0.2, 0.2, 0.2, 0.2}, {0.2, 0.2, 0.2, 0.2, 0.2}, {0.2, 0.2, 0.2, 0.2, 0.2}};
    static final double[][] PROTOMECH_ARMOR = new double[][]{{0.03225806451612903, 0.5161290322580645, 0.0967741935483871, 0.0967741935483871, 0.25806451612903225}, {0.03225806451612903, 0.5161290322580645, 0.0967741935483871, 0.0967741935483871, 0.25806451612903225}, {0.03225806451612903, 0.5161290322580645, 0.0967741935483871, 0.0967741935483871, 0.25806451612903225}, {0.03225806451612903, 0.5161290322580645, 0.0967741935483871, 0.0967741935483871, 0.25806451612903225}};
    static final double[][] PROTOMECH_MG_ARMOR = new double[][]{{0.03125, 0.5, 0.09375, 0.09375, 0.25, 0.03125}, {0.03225806451612903, 0.5, 0.09375, 0.09375, 0.25, 0.03125}, {0.03225806451612903, 0.5, 0.09375, 0.09375, 0.25, 0.03125}, {0.03225806451612903, 0.5, 0.09375, 0.09375, 0.25, 0.03125}};
    static final double[][] MECH_ARMOR = new double[][]{{0.027777777777777776, 0.19444444444444445, 0.16666666666666666, 0.16666666666666666, 0.1111111111111111, 0.1111111111111111, 0.1111111111111111, 0.1111111111111111}, {0.027777777777777776, 0.19444444444444445, 0.16666666666666666, 0.16666666666666666, 0.1111111111111111, 0.1111111111111111, 0.1111111111111111, 0.1111111111111111}, {0.027777777777777776, 0.16666666666666666, 0.1111111111111111, 0.19444444444444445, 0.05555555555555555, 0.16666666666666666, 0.05555555555555555, 0.2222222222222222}, {0.027777777777777776, 0.16666666666666666, 0.19444444444444445, 0.1111111111111111, 0.16666666666666666, 0.05555555555555555, 0.2222222222222222, 0.05555555555555555}};
    static final double[][] GUN_EMPLACEMENT_ARMOR = new double[][]{{0.25, 0.0, 0.0, 0.0}, {0.25, 0.0, 0.0, 0.0}, {0.25, 0.0, 0.0, 0.0}, {0.25, 0.0, 0.0, 0.0}};
    static final double[][] GUN_EMPLACEMENT_TURRET_ARMOR = new double[][]{{0.3333333333333333, 0.0, 0.0, 0.0, 0.1388888888888889}, {0.3333333333333333, 0.0, 0.0, 0.0, 0.1388888888888889}, {0.3333333333333333, 0.0, 0.0, 0.0, 0.1388888888888889}, {0.3333333333333333, 0.0, 0.0, 0.0, 0.1388888888888889}};
    public static final int MAX_RANGE = 36;
    public static final int MIN_BRACKET = 6;
    public static final int OVERHEAT_NONE = 0;
    public static final int OVERHEAT_LOW = 1;
    public static final int OVERHEAT_HIGH = 2;
    public static final int RANGE_SHORT = 0;
    public static final int RANGE_MEDIUM = 1;
    public static final int RANGE_LONG = 2;
    public static final int RANGE_ALL = 3;
    public static final int FIRST_ARC = 0;
    public static final int LAST_PRIMARY_ARC = 3;
    public static final int LAST_ARC = 4;
    public static final int TT = 4;
    public static final int LEFT_LEG = 0;
    public static final int RIGHT_LEG = 1;
    Entity entity;
    MoveOption current;
    MoveOption last;
    private MoveOption.Table moves;
    MoveOption.Table pass = new MoveOption.Table();
    public int runMP;
    public int jumpMP;
    public boolean masc_threat = false;
    boolean isPhysicalTarget = false;
    int overheat = 0;
    int range = 3;
    int long_range = 0;
    double[] range_damages = new double[4];
    int rd_bracket = 0;
    double base_psr_odds = 1.0;
    boolean hasTakenDamage = false;
    public Strategy strategy = new Strategy();
    double[] armor_health = new double[]{0.0, 0.0, 0.0, 0.0};
    double[] armor_percent = new double[]{0.0, 0.0, 0.0, 0.0};
    double avg_armor = 0.0;
    double avg_iarmor = 0.0;
    double[] expected_damage = new double[]{0.0, 0.0, 0.0, 0.0};
    double[] possible_damage = new double[]{0.0, 0.0, 0.0, 0.0};
    double[] leg_health = new double[]{0.0, 0.0};
    double overall_armor_percent = 0.0;
    double[][] damages = new double[6][37];
    int bv;
    int enemy_num;
    private TestBot tb;
    boolean engaged = false;
    boolean moved = false;
    boolean justMoved = false;
    boolean tsm_offset = false;
    int[] minRangeMods = new int[7];

    public CEntity(Entity entity, TestBot testBot) {
        this.entity = entity;
        this.tb = testBot;
        this.reset();
    }

    public Entity getEntity() {
        return this.entity;
    }

    public boolean canMove() {
        return !(!this.entity.isSelectableThisTurn() || this.entity.isProne() && this.base_psr_odds < 0.2 || this.entity.isImmobile());
    }

    public boolean justMoved() {
        return !this.moved && !this.entity.isSelectableThisTurn() || this.justMoved;
    }

    public void reset() {
        this.entity = this.tb.game.getEntity(this.entity.getId());
        for (int i = 0; i <= 4; ++i) {
            Arrays.fill(this.damages[i], 0.0);
        }
        this.characterize();
        this.resetPossibleDamage();
        this.moves = null;
        this.hasTakenDamage = false;
        Arrays.fill(this.expected_damage, 0.0);
        this.engaged = false;
        this.moved = false;
        this.isPhysicalTarget = false;
    }

    public void refresh() {
        this.entity = this.tb.game.getEntity(this.entity.getId());
        if (this.justMoved()) {
            for (int i = 0; i <= 4; ++i) {
                Arrays.fill(this.damages[i], 0.0);
            }
            this.characterize();
            this.resetPossibleDamage();
        }
    }

    public void resetPossibleDamage() {
        Arrays.fill(this.possible_damage, 0.0);
    }

    public void characterize() {
        int n;
        int n2;
        int n3;
        Object object;
        this.entity = this.tb.game.getEntity(this.entity.getId());
        this.current = new MoveOption(this.tb.game, this);
        this.bv = this.entity.calculateBattleValue();
        this.runMP = this.entity.getRunMP();
        this.jumpMP = this.entity.getJumpMP();
        this.overall_armor_percent = this.entity.getArmorRemainingPercent();
        this.base_psr_odds = Compute.oddsAbove(this.entity.getBasePilotingRoll().getValue()) / 100.0;
        if (this.entity instanceof Mech && ((Mech)this.tb.game.getEntity(this.entity.getId())).hasTSM()) {
            this.tsm_offset = true;
        }
        double d = 0.9;
        if (this.entity.heat > 7) {
            d = 0.8;
        }
        if (this.entity.heat > 12) {
            d = 0.5;
        }
        if (this.tsm_offset) {
            if (this.entity.heat == 9) {
                d = 1.0;
            }
            if (this.entity.heat < 12 && this.entity.heat > 9) {
                d = 0.8;
            }
        }
        if (this.entity.heat > 16) {
            d = 0.35;
        }
        int n4 = this.entity.getHeatCapacity();
        int n5 = 0;
        int n6 = 0;
        for (Mounted mounted : this.entity.getWeaponList()) {
            int n7 = this.entity.getWeaponArc(this.entity.getEquipmentNum(mounted));
            object = (WeaponType)mounted.getType();
            if (mounted.isDestroyed() || mounted.isJammed() || ((EquipmentType)object).getName() == "Stop Swarm Attack" || (!(this.entity instanceof Infantry) ? mounted.getLinked() == null & ((WeaponType)object).getAmmoType() != -1 : !((EquipmentType)object).hasFlag(2048L) & ((WeaponType)object).getAmmoType() != -1 && mounted.getLinked() == null && ((WeaponType)object).getAmmoType() != -2 & ((WeaponType)object).getAmmoType() != -3)) continue;
            ++n6;
            n5 += ((WeaponType)object).getHeat();
            n3 = ((WeaponType)object).getMinimumRange();
            n2 = ((WeaponType)object).getExtremeRange();
            int n8 = this.entity.getCrew().getGunnery();
            for (int i = 0; i <= n2 && i <= 36; ++i) {
                double d2 = CEntity.getExpectedDamage(this.entity, mounted, i, n8);
                if (i <= n3 & i <= 6) {
                    int n9 = i;
                    this.minRangeMods[n9] = this.minRangeMods[n9] + (1 + n3 - i);
                }
                this.addDamage(n7, this.entity.isSecondaryArcWeapon(this.entity.getEquipmentNum(mounted)), i, d2 * (((WeaponType)object).getHeat() > 0 ? d : 1.0));
            }
            this.long_range = Math.max(this.long_range, Math.min(n2, 36));
        }
        if (this.entity instanceof Mech) {
            this.addDamage(2, true, 1, (this.tsm_offset ? 1.0 : 0.5) * (double)this.entity.getWeight() / 10.0 * Compute.oddsAbove(this.entity.getCrew().getPiloting()) / 100.0);
            this.addDamage(3, true, 1, (this.tsm_offset ? 1.0 : 0.5) * (double)this.entity.getWeight() / 10.0 * Compute.oddsAbove(this.entity.getCrew().getPiloting()) / 100.0);
        }
        for (n = 1; n < this.minRangeMods.length; ++n) {
            if (n6 <= 0) continue;
            this.minRangeMods[n] = (int)Math.round((double)this.minRangeMods[n] / (double)n6);
        }
        this.computeRange(1);
        n = 0;
        if (this.entity instanceof Mech) {
            n = n5 - n4;
            if (this.entity instanceof Mech && this.entity.isStealthActive()) {
                n += 10;
            }
            if (this.entity.infernos.isStillBurning()) {
                n += 6;
            }
            if (this.entity instanceof Mech) {
                n += this.entity.getEngineCritHeat();
            }
            if (this.entity.getPosition() != null && this.tb.game.getBoard().getHex(this.entity.getPosition()) != null && this.tb.game.getBoard().getHex(this.entity.getPosition()).terrainLevel(7) == 2) {
                n += 5;
            }
            n += this.tb.game.getTemperatureDifference();
        }
        if (n <= 4) {
            this.overheat = 0;
        }
        if (n > 3) {
            this.overheat = 1;
        }
        if (n > 9 & !this.tsm_offset) {
            this.overheat = 2;
        }
        if (n > 12 & this.tsm_offset) {
            this.overheat = 2;
        }
        if (this.entity instanceof Mech && ((Mech)this.entity).hasMASC()) {
            this.masc_threat = ((Mech)this.entity).getMASCTarget() > 5 + Compute.randomInt(6);
        }
        double d3 = 1.0;
        object = MECH_ARMOR;
        if (this.entity instanceof Tank) {
            object = ((Tank)this.entity).hasNoTurret() ? (Object)TANK_ARMOR : (Object)TANK_WT_ARMOR;
        }
        if (this.entity instanceof Infantry) {
            object = !(this.entity instanceof BattleArmor) ? (Object)INFANTRY_ARMOR : (this.entity.isClan() ? (Object)CLBA_ARMOR : (Object)ISBA_ARMOR);
        }
        if (this.entity instanceof Protomech) {
            object = ((Protomech)this.entity).hasMainGun() ? (Object)PROTOMECH_MG_ARMOR : (Object)PROTOMECH_ARMOR;
        }
        if (this.entity instanceof GunEmplacement) {
            object = ((GunEmplacement)this.entity).hasTurret() ? GUN_EMPLACEMENT_TURRET_ARMOR : GUN_EMPLACEMENT_ARMOR;
        }
        for (n3 = 0; n3 <= 3; ++n3) {
            this.armor_health[n3] = 0.0;
            for (n2 = 0; n2 < ((Object)object[n3]).length; ++n2) {
                int n10 = n3;
                this.armor_health[n10] = this.armor_health[n10] + object[n3][n2] * (double)this.getArmorValue(n2, n3 == 1);
            }
            if (this.entity instanceof Protomech) {
                int n11 = n3;
                this.armor_health[n11] = this.armor_health[n11] * 1.22;
            }
            d3 = Math.max(this.armor_health[n3], d3);
            this.armor_percent[n3] = this.armor_health[n3] / d3;
        }
        this.avg_armor = (this.armor_health[0] + this.armor_health[1] + this.armor_health[2] + this.armor_health[3]) / 4.0;
        this.avg_iarmor = (double)this.entity.getTotalInternal() / 7.0;
        if (this.entity instanceof Infantry) {
            double d4 = this.avg_iarmor = this.entity instanceof BattleArmor ? (double)((BattleArmor)this.entity).getShootingStrength() : 1.0;
        }
        if (this.entity instanceof Tank) {
            this.avg_iarmor = (double)this.entity.getTotalInternal() / (((Tank)this.entity).hasNoTurret() ? 4.0 : 5.0);
        }
        if (this.entity instanceof Protomech) {
            this.avg_iarmor = (double)this.entity.getTotalInternal() / (((Protomech)this.entity).hasMainGun() ? 5.0 : 6.0);
        }
        if (this.entity instanceof GunEmplacement) {
            this.avg_iarmor = 1.0;
        }
    }

    private void addDamage(int n, boolean bl, int n2, double d) {
        if (n == 0 | n == 7) {
            for (int i = 0; i <= 4; ++i) {
                double[] dArray = this.damages[i];
                int n3 = n2;
                dArray[n3] = dArray[n3] + d;
            }
        } else if (bl) {
            if (n == 1) {
                double[] dArray = this.damages[1];
                int n4 = n2;
                dArray[n4] = dArray[n4] + d;
                double[] dArray2 = this.damages[2];
                int n5 = n2;
                dArray2[n5] = dArray2[n5] + d;
                double[] dArray3 = this.damages[3];
                int n6 = n2;
                dArray3[n6] = dArray3[n6] + d;
            }
            if (n == 2 | n == 5) {
                double[] dArray = this.damages[1];
                int n7 = n2;
                dArray[n7] = dArray[n7] + d;
                double[] dArray4 = this.damages[2];
                int n8 = n2;
                dArray4[n8] = dArray4[n8] + d;
                double[] dArray5 = this.damages[4];
                int n9 = n2;
                dArray5[n9] = dArray5[n9] + (this.entity.canFlipArms() ? d : 0.5 * d);
            }
            if (n == 3 | n == 6) {
                double[] dArray = this.damages[1];
                int n10 = n2;
                dArray[n10] = dArray[n10] + d;
                double[] dArray6 = this.damages[3];
                int n11 = n2;
                dArray6[n11] = dArray6[n11] + d;
                double[] dArray7 = this.damages[4];
                int n12 = n2;
                dArray7[n12] = dArray7[n12] + (this.entity.canFlipArms() ? d : 0.5 * d);
            }
            if (n == 4) {
                double[] dArray = this.damages[4];
                int n13 = n2;
                dArray[n13] = dArray[n13] + d;
                double[] dArray8 = this.damages[2];
                int n14 = n2;
                dArray8[n14] = dArray8[n14] + d;
                double[] dArray9 = this.damages[3];
                int n15 = n2;
                dArray9[n15] = dArray9[n15] + d;
            }
        } else {
            if (n == 1) {
                double[] dArray = this.damages[1];
                int n16 = n2;
                dArray[n16] = dArray[n16] + d;
            }
            if (n == 2 | n == 5) {
                double[] dArray = this.damages[1];
                int n17 = n2;
                dArray[n17] = dArray[n17] + d;
                double[] dArray10 = this.damages[2];
                int n18 = n2;
                dArray10[n18] = dArray10[n18] + d;
            }
            if (n == 3 | n == 6) {
                double[] dArray = this.damages[1];
                int n19 = n2;
                dArray[n19] = dArray[n19] + d;
                double[] dArray11 = this.damages[3];
                int n20 = n2;
                dArray11[n20] = dArray11[n20] + d;
            }
            if (n == 4) {
                double[] dArray = this.damages[4];
                int n21 = n2;
                dArray[n21] = dArray[n21] + d;
            }
        }
    }

    public void computeRange(int n) {
        int n2;
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        Arrays.fill(this.range_damages, 0.0);
        this.rd_bracket = this.long_range / 4;
        int n3 = n2 = this.entity instanceof Infantry ? 0 : 1;
        while (n2 < this.long_range) {
            if (n2 <= this.rd_bracket) {
                dArray[0] = dArray[0] + this.damages[n][n2];
                this.range_damages[0] = this.range_damages[0] + this.damages[n][n2];
            }
            if (n2 > this.rd_bracket & n2 <= 2 * this.rd_bracket) {
                dArray[1] = dArray[1] + this.getModifiedDamage(n, n2, -2);
                this.range_damages[1] = this.range_damages[1] + this.damages[n][n2];
            }
            if (n2 > 2 * this.rd_bracket & n2 <= 3 * this.rd_bracket) {
                dArray[2] = dArray[2] + this.getModifiedDamage(n, n2, -4);
                this.range_damages[2] = this.range_damages[2] + this.damages[n][n2];
            }
            this.range_damages[3] = this.range_damages[3] + this.damages[n][n2];
            ++n2;
        }
        if (this.rd_bracket > 0) {
            this.range_damages[0] = this.range_damages[0] / (double)this.rd_bracket;
            dArray[0] = dArray[0] / (double)this.rd_bracket;
            this.range_damages[1] = this.range_damages[1] / (double)this.rd_bracket;
            dArray[1] = dArray[1] / (double)this.rd_bracket;
            this.range_damages[2] = this.range_damages[2] / (double)this.rd_bracket;
            dArray[2] = dArray[2] / (double)this.rd_bracket;
            this.range_damages[3] = this.range_damages[3] / (double)(this.rd_bracket * 3);
        } else {
            this.range_damages[0] = this.damages[n][0];
            dArray[0] = this.damages[n][0];
            this.range_damages[1] = this.damages[n][0];
            dArray[1] = this.damages[n][0];
            this.range_damages[2] = this.damages[n][0];
            dArray[2] = this.damages[n][0];
            this.range_damages[3] = this.damages[n][0];
        }
        n2 = 3;
        this.range = 0;
        while (this.range <= 2) {
            if (dArray[this.range] > dArray[n2]) {
                n2 = this.range;
            }
            ++this.range;
        }
        this.range = n2;
    }

    protected int getArmorValue(int n, boolean bl) {
        int n2 = this.entity.getArmor(n, bl);
        if (this.entity instanceof Infantry & !(this.entity instanceof BattleArmor)) {
            n2 = ((Infantry)this.entity).getShootingStrength();
        }
        if (this.entity instanceof BattleArmor) {
            n2 = ((BattleArmor)this.entity).getArmor(n, false);
        }
        if (n2 <= 0) {
            n2 = 0;
        }
        return n2;
    }

    public double getThreatUtility(double d, int n) {
        double d2 = d;
        double d3 = d;
        if (this.armor_percent[n] < 0.75) {
            d2 *= 1.1;
        } else if (this.armor_percent[n] < 0.5) {
            d2 *= 1.3;
        } else if (this.armor_percent[n] < 0.25) {
            d2 *= 1.5;
        }
        d2 *= this.strategy.target;
        if (d3 + this.expected_damage[n] > this.armor_health[n]) {
            if ((d3 + this.expected_damage[0] + this.expected_damage[1] + this.expected_damage[2] + this.expected_damage[3] > 3.0 * (this.avg_armor + this.avg_iarmor) || this.entity.isProne() && this.base_psr_odds < 0.1 && !this.entity.isImmobile()) && this.entity.isEnemyOf(this.tb.getEntitiesOwned().get(0))) {
                return Math.sqrt(d3) * this.strategy.target;
            }
            d3 *= 1.5;
        } else if (this.expected_damage[n] > 0.0) {
            d3 *= 1.3;
        } else if (this.hasTakenDamage) {
            d3 *= 1.1;
        }
        return Math.max(d2, d3);
    }

    public Integer getKey() {
        return new Integer(this.entity.getId());
    }

    public MoveOption.Table getAllMoves() {
        if (this.moves == null) {
            this.moves = this.calculateMoveOptions(this.current);
        }
        return this.moves;
    }

    protected MoveOption.Table calculateMoveOptions(MoveOption moveOption) {
        Object object;
        ArrayList<MoveOption> arrayList = new ArrayList<MoveOption>();
        MoveOption.Table table = new MoveOption.Table();
        if (this.entity.getJumpMPWithTerrain() > 0) {
            arrayList.add(((MoveOption)moveOption.clone()).addStep(7));
        }
        arrayList.add(moveOption);
        table.put(moveOption);
        while (arrayList.size() > 0) {
            object = (MoveOption)arrayList.remove(0);
            for (MoveOption moveOption2 : ((MovePath)object).getNextMoves(true, true)) {
                int n;
                if (moveOption2.changeToPhysical() && moveOption2.isMoveLegal()) {
                    table.put(moveOption2);
                    continue;
                }
                if (!moveOption2.isMoveLegal() || table.get(moveOption2) != null && !(moveOption2.getDistUtility() < table.get(moveOption2).getDistUtility())) continue;
                table.put(moveOption2);
                if (moveOption2.isJumping()) {
                    MoveOption moveOption3 = (MoveOption)moveOption2.clone();
                    MoveOption moveOption4 = (MoveOption)moveOption2.clone();
                    for (int i = 0; i < 2; ++i) {
                        moveOption3.addStep(3);
                        moveOption4.addStep(4);
                        table.put((MoveOption)moveOption3.clone());
                        table.put((MoveOption)moveOption4.clone());
                    }
                    moveOption4.addStep(4);
                    table.put(moveOption4);
                }
                if ((n = Collections.binarySearch(arrayList, moveOption2, MoveOption.DISTANCE_COMPARATOR)) < 0) {
                    n = -n - 1;
                }
                arrayList.add(n, moveOption2);
            }
        }
        object = table.values().iterator();
        while (object.hasNext()) {
            MoveOption moveOption5 = (MoveOption)object.next();
            moveOption5.clipToPossible();
            if (!moveOption5.isMoveLegal()) {
                object.remove();
            }
            if (this.entity.heat <= 4) continue;
            moveOption5.movement_threat += (double)(this.bv / 1000 * moveOption5.getMovementheatBuildup());
            if (this.entity.heat > 7) {
                moveOption5.movement_threat += (double)(this.bv / 500 * moveOption5.getMovementheatBuildup());
            }
            if (this.tsm_offset) {
                if (this.entity.heat == 9) {
                    moveOption5.movement_threat -= (double)(this.bv / 100 * moveOption5.getMovementheatBuildup());
                }
                if (this.entity.heat < 12 && this.entity.heat > 9) {
                    moveOption5.movement_threat -= (double)(this.bv / 500 * moveOption5.getMovementheatBuildup());
                }
            }
            if (this.entity.heat <= 12) continue;
            moveOption5.movement_threat += (double)(this.bv / 100 * moveOption5.getMovementheatBuildup());
        }
        return table;
    }

    public ArrayList<MoveOption> findMoves(Coords coords) {
        ArrayList<MoveOption> arrayList = new ArrayList<MoveOption>();
        for (int i = 0; i < 6; ++i) {
            for (int j = 1; j < 2; ++j) {
                MovePath.Key key = new MovePath.Key(coords, i, j);
                MoveOption moveOption = null;
                moveOption = (MoveOption)this.getAllMoves().get(key);
                if (moveOption == null) continue;
                arrayList.add(moveOption);
            }
        }
        return arrayList;
    }

    public double getModifiedDamage(int n, int n2, int n3) {
        if (n2 > 36) {
            return 0.0;
        }
        double d = this.damages[n][n2];
        int n4 = this.entity.getCrew().getGunnery();
        int n5 = 0;
        double d2 = (double)this.long_range / 4.0;
        if (n2 <= 6) {
            n5 += this.minRangeMods[n2];
        }
        if ((double)n2 > d2) {
            n5 += 2;
        }
        if ((double)n2 > 2.0 * d2) {
            n5 += 2;
        }
        if ((double)n2 > 3.0 * d2) {
            n5 += 4;
        }
        if (n4 + n5 + n3 > this.tb.ignore | n4 + n5 + n3 > 12) {
            return 0.0;
        }
        if (n4 + n5 + n3 == this.tb.ignore) {
            d *= 0.5;
        }
        double d3 = Compute.oddsAbove(n4 + n5) / 100.0;
        double d4 = Compute.oddsAbove(n5 + n3 + n4) / 100.0;
        return d4 * d / d3;
    }

    public static double getExpectedDamage(Entity entity, Mounted mounted, int n, int n2) {
        double d;
        int n3 = n2;
        double[] dArray = new double[]{0.0, 1.0, 1.58, 2.0, 2.63, 3.17, 4.0, 4.49, 4.98, 5.47, 6.31, 7.23, 8.14, 8.59, 9.04, 9.5, 10.1, 10.8, 11.42, 12.1, 12.7};
        boolean bl = false;
        Infantry infantry = new Infantry();
        BattleArmor battleArmor = new BattleArmor();
        if (entity instanceof BattleArmor) {
            battleArmor = (BattleArmor)entity;
        }
        if (entity instanceof Infantry && !(entity instanceof BattleArmor)) {
            infantry = (Infantry)entity;
        }
        if (!(entity instanceof Infantry) & n == 0) {
            return 0.0;
        }
        double d2 = 0.0;
        WeaponType weaponType = (WeaponType)mounted.getType();
        if (weaponType.getName() == "Stop Swarm Attack") {
            return 0.0;
        }
        if (n <= weaponType.getMinimumRange()) {
            n3 = n3 + 1 + (weaponType.getMinimumRange() - n);
        } else {
            if (n > weaponType.getShortRange()) {
                n3 += 2;
            }
            if (n > weaponType.getMediumRange()) {
                n3 += 2;
            }
            if (n > weaponType.getLongRange()) {
                n3 += 4;
            }
            if (n > weaponType.getExtremeRange()) {
                return 0.0;
            }
        }
        n3 += weaponType.getToHitModifier();
        if (weaponType.getDamage() == -2 & weaponType.getAmmoType() != 39 & weaponType.getAmmoType() != 40 & weaponType.getAmmoType() != 41 & weaponType.getAmmoType() != 42) {
            bl = true;
        }
        if (weaponType.getAmmoType() == 19 || weaponType.getAmmoType() == 33) {
            bl = true;
            --n3;
        }
        if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34 || weaponType.getAmmoType() == 23) {
            bl = true;
        }
        if (entity instanceof BattleArmor && weaponType.getInternalName() != "SwarmMek" & weaponType.getInternalName() != "LegAttack" & !weaponType.hasFlag(2048L)) {
            bl = true;
        }
        if (bl) {
            Mounted mounted2;
            d = 0.0;
            if (!(entity instanceof BattleArmor) && mounted.getLinked() == null) {
                return 0.0;
            }
            AmmoType ammoType = null;
            if (mounted.getLinked() != null) {
                ammoType = (AmmoType)mounted.getLinked().getType();
                d2 = ammoType.getDamagePerShot();
                if (weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 9) {
                    d2 = 2.0;
                }
                if (weaponType.getAmmoType() == 29) {
                    d2 = 2.4;
                }
                if (weaponType.getAmmoType() == 32 || weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 12) {
                    d2 = 1.0;
                }
            }
            d = weaponType.getRackSize() != 40 && weaponType.getRackSize() != 30 ? dArray[weaponType.getRackSize()] : 2.0 * dArray[weaponType.getRackSize() / 2];
            if (weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 32) {
                d = weaponType.getRackSize();
            }
            if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34) {
                d = dArray[2];
            }
            if (weaponType.getAmmoType() == 23) {
                d = dArray[4];
            }
            if (weaponType.getAmmoType() == 19 || weaponType.getAmmoType() == 33) {
                d = dArray[weaponType.getDamage()];
            }
            if (!(weaponType.getAmmoType() != 7 && weaponType.getAmmoType() != 9 || (mounted2 = mounted.getLinkedBy()) == null || !(mounted2.getType() instanceof MiscType) || mounted2.isDestroyed() || mounted2.isMissing() || mounted2.isBreached() || !mounted2.getType().hasFlag(512L))) {
                d *= (double)1.2f;
            }
            if (entity instanceof BattleArmor) {
                d = dArray[battleArmor.getShootingStrength()];
                if (weaponType.getDamage() == -2) {
                    d *= dArray[weaponType.getRackSize()];
                }
                if (weaponType.getDamage() != -2) {
                    d2 = weaponType.getDamage() != -3 ? (double)weaponType.getDamage() : (double)weaponType.getRackSize();
                }
                if (weaponType.hasFlag(8192L)) {
                    d *= 2.0;
                }
                if (weaponType.hasFlag(16384L)) {
                    d *= dArray[weaponType.getRackSize()];
                }
            }
            d2 *= d;
            if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34 || weaponType.getAmmoType() == 23) {
                d2 = d * (double)weaponType.getDamage();
            }
        } else {
            d2 = weaponType.getDamage();
            if (weaponType.getAmmoType() == 22) {
                d2 = 25.0;
                if (n > 6) {
                    d2 = 20.0;
                }
                if (n > 13) {
                    d2 = 10.0;
                }
            }
            if ((weaponType.getAmmoType() == 39 || weaponType.getAmmoType() == 40 || weaponType.getAmmoType() == 41 || weaponType.getAmmoType() == 42) && n <= weaponType.getMinimumRange()) {
                d2 *= 0.5;
            }
            if (entity instanceof Infantry) {
                if (weaponType.hasFlag(2048L)) {
                    d2 = 0.6f * (float)infantry.getDamage(infantry.getShootingStrength());
                    if (entity instanceof BattleArmor) {
                        d2 = infantry.getDamage(battleArmor.getShootingStrength());
                    }
                }
                if (weaponType.getInternalName() == "LegAttack") {
                    n3 = !(entity instanceof BattleArmor) ? 4 + 2 * (infantry.getOInternal(0) - infantry.getShootingStrength()) / 5 : 8 - battleArmor.getShootingStrength();
                    d2 = 10.0;
                }
                if (weaponType.getInternalName() == "SwarmMek") {
                    if (!(entity instanceof BattleArmor)) {
                        n3 = 7 + 2 * (infantry.getOInternal(0) - infantry.getShootingStrength()) / 5;
                        d2 = 1.5 * (double)infantry.getDamage(infantry.getShootingStrength());
                    } else {
                        n3 = 11 - battleArmor.getShootingStrength();
                        d2 = 5.0 * (double)battleArmor.getShootingStrength();
                    }
                }
            }
        }
        d = Compute.oddsAbove(n3) / 100.0;
        return d2 *= d;
    }

    public static int getFiringAngle(Coords coords, int n, Coords coords2) {
        int n2 = coords.degree(coords2) - n % 6 * 60;
        if (n2 < 0) {
            n2 += 360;
        } else if (n2 >= 360) {
            n2 -= 360;
        }
        return n2;
    }

    public static int getThreatHitArc(Coords coords, int n, Coords coords2) {
        int n2 = CEntity.getFiringAngle(coords, n, coords2);
        if (n2 >= 300 || n2 <= 60) {
            return 0;
        }
        if (n2 >= 60 && n2 <= 120) {
            return 3;
        }
        if (n2 >= 240 && n2 <= 300) {
            return 2;
        }
        return 1;
    }

    public static int firingArcToHitArc(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 1;
            }
            case 5: {
                return 2;
            }
            case 6: {
                return 3;
            }
        }
        return 0;
    }

    public boolean equals(Object object) {
        if (object instanceof Entity || object instanceof CEntity) {
            return object.hashCode() == this.hashCode();
        }
        return false;
    }

    public int hashCode() {
        return this.entity.getId();
    }

    public TestBot getTb() {
        return this.tb;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Table
    extends HashMap<Integer, CEntity> {
        private TestBot tb;

        public Table(TestBot testBot) {
            this.tb = testBot;
        }

        public void put(CEntity cEntity) {
            this.put(cEntity.getKey(), cEntity);
        }

        public CEntity get(Entity entity) {
            CEntity cEntity = null;
            cEntity = (CEntity)super.get(new Integer(entity.getId()));
            if (cEntity == null) {
                cEntity = new CEntity(entity, this.tb);
                this.put(cEntity);
            }
            return cEntity;
        }

        public CEntity get(int n) {
            return (CEntity)this.get(new Integer(n));
        }
    }
}

