/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.bot.ui.AWT;

import java.awt.Dimension;
import java.awt.Frame;
import java.io.File;
import megamek.client.bot.BotClient;
import megamek.client.bot.Messages;
import megamek.client.ui.AWT.CommonHelpDialog;
import megamek.client.ui.AWT.ConfirmDialog;
import megamek.client.ui.AWT.GUIPreferences;
import megamek.common.event.GameBoardChangeEvent;
import megamek.common.event.GameBoardNewEvent;
import megamek.common.event.GameEndEvent;
import megamek.common.event.GameEntityChangeEvent;
import megamek.common.event.GameEntityNewEvent;
import megamek.common.event.GameEntityNewOffboardEvent;
import megamek.common.event.GameEntityRemoveEvent;
import megamek.common.event.GameListener;
import megamek.common.event.GameMapQueryEvent;
import megamek.common.event.GameNewActionEvent;
import megamek.common.event.GamePhaseChangeEvent;
import megamek.common.event.GamePlayerChangeEvent;
import megamek.common.event.GamePlayerChatEvent;
import megamek.common.event.GamePlayerConnectedEvent;
import megamek.common.event.GamePlayerDisconnectedEvent;
import megamek.common.event.GameReportEvent;
import megamek.common.event.GameSettingsChangeEvent;
import megamek.common.event.GameTurnChangeEvent;

public class BotGUI
implements GameListener {
    private BotClient bot;
    private Frame frame = new Frame();
    private static boolean WarningShown;

    public BotGUI(BotClient botClient) {
        this.bot = botClient;
    }

    public void gamePhaseChange(GamePhaseChangeEvent gamePhaseChangeEvent) {
        if (this.bot.game.getPhase() == 1 || this.bot.game.getPhase() == 21) {
            this.notifyOfBot();
        }
    }

    public void notifyOfBot() {
        if (GUIPreferences.getInstance().getNagForBotReadme() && !WarningShown) {
            WarningShown = true;
            String string = Messages.getString("BotGUI.notifyOfBot.title");
            String string2 = Messages.getString("BotGUI.notifyOfBot.message");
            Dimension dimension = this.frame.getToolkit().getScreenSize();
            this.frame.pack();
            this.frame.setLocation(dimension.width / 2 - this.frame.getSize().width / 2, dimension.height / 2 - this.frame.getSize().height / 2);
            ConfirmDialog confirmDialog = new ConfirmDialog(this.frame, string, string2, true);
            confirmDialog.setVisible(true);
            if (!confirmDialog.getShowAgain()) {
                GUIPreferences.getInstance().setNagForBotReadme(false);
            }
            if (confirmDialog.getAnswer()) {
                File file = new File("docs/ai-readme.txt");
                new CommonHelpDialog(this.frame, file).setVisible(true);
            }
        }
    }

    public void gamePlayerConnected(GamePlayerConnectedEvent gamePlayerConnectedEvent) {
    }

    public void gamePlayerDisconnected(GamePlayerDisconnectedEvent gamePlayerDisconnectedEvent) {
    }

    public void gamePlayerChange(GamePlayerChangeEvent gamePlayerChangeEvent) {
    }

    public void gamePlayerChat(GamePlayerChatEvent gamePlayerChatEvent) {
    }

    public void gameTurnChange(GameTurnChangeEvent gameTurnChangeEvent) {
    }

    public void gameReport(GameReportEvent gameReportEvent) {
    }

    public void gameEnd(GameEndEvent gameEndEvent) {
    }

    public void gameBoardNew(GameBoardNewEvent gameBoardNewEvent) {
    }

    public void gameBoardChanged(GameBoardChangeEvent gameBoardChangeEvent) {
    }

    public void gameSettingsChange(GameSettingsChangeEvent gameSettingsChangeEvent) {
    }

    public void gameMapQuery(GameMapQueryEvent gameMapQueryEvent) {
    }

    public void gameEntityNew(GameEntityNewEvent gameEntityNewEvent) {
    }

    public void gameEntityNewOffboard(GameEntityNewOffboardEvent gameEntityNewOffboardEvent) {
    }

    public void gameEntityChange(GameEntityChangeEvent gameEntityChangeEvent) {
    }

    public void gameNewAction(GameNewActionEvent gameNewActionEvent) {
    }

    public void gameEntityRemove(GameEntityRemoveEvent gameEntityRemoveEvent) {
    }
}

