/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.AWT;

import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.FilteredImageSource;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import megamek.client.ui.AWT.HexTileset;
import megamek.client.ui.AWT.MechTileset;
import megamek.client.ui.AWT.util.ImageFileFactory;
import megamek.client.ui.AWT.util.PlayerColors;
import megamek.client.ui.AWT.util.RotateFilter;
import megamek.client.ui.AWT.widget.BackGroundDrawer;
import megamek.client.ui.AWT.widget.BufferedPanel;
import megamek.common.Entity;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.preference.IPreferenceChangeListener;
import megamek.common.preference.PreferenceChangeEvent;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.DirectoryItems;

public class TilesetManager
implements IPreferenceChangeListener {
    private Component comp;
    private MediaTracker tracker;
    private boolean started = false;
    private boolean loaded = false;
    private DirectoryItems camos;
    private MechTileset mechTileset = new MechTileset("data/images/units/");
    private MechTileset wreckTileset = new MechTileset("data/images/units/wrecks/");
    private ArrayList<EntityImage> mechImageList = new ArrayList();
    private HashMap<Integer, EntityImage> mechImages = new HashMap();
    private HexTileset hexTileset = new HexTileset();
    private Image minefieldSign;
    private Image nightFog;
    private Image artilleryAutohit;
    private Image artilleryAdjusted;
    private Image artilleryIncoming;
    private HashMap<Integer, Image> ecmShades = new HashMap();
    private static final String NIGHT_IMAGE_FILE = "data/images/hexes/transparent/night.png";
    private static final String ARTILLERY_AUTOHIT_IMAGE_FILE = "data/images/hexes/artyauto.gif";
    private static final String ARTILLERY_ADJUSTED_IMAGE_FILE = "data/images/hexes/artyadj.gif";
    private static final String ARTILLERY_INCOMING_IMAGE_FILE = "data/images/hexes/artyinc.gif";
    public static final int ARTILLERY_AUTOHIT = 0;
    public static final int ARTILLERY_ADJUSTED = 1;
    public static final int ARTILLERY_INCOMING = 2;

    public TilesetManager(Component component) throws IOException {
        this.comp = component;
        this.tracker = new MediaTracker(component);
        try {
            this.camos = new DirectoryItems(new File("data/images/camo"), "", ImageFileFactory.getInstance());
        }
        catch (Exception exception) {
            this.camos = null;
        }
        this.mechTileset.loadFromFile("mechset.txt");
        this.wreckTileset.loadFromFile("wreckset.txt");
        this.hexTileset.loadFromFile(PreferenceManager.getClientPreferences().getMapTileset());
        PreferenceManager.getClientPreferences().addPreferenceChangeListener(this);
    }

    public void preferenceChange(PreferenceChangeEvent preferenceChangeEvent) {
        if (preferenceChangeEvent.getName().equals("MapTileset")) {
            HexTileset hexTileset = new HexTileset();
            try {
                hexTileset.loadFromFile((String)preferenceChangeEvent.getNewValue());
                this.hexTileset = hexTileset;
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    public Image iconFor(Entity entity) {
        EntityImage entityImage = this.mechImages.get(new Integer(entity.getId()));
        if (entityImage == null) {
            System.out.println("Loading image for " + entity.getShortNameRaw() + " on the fly.");
            this.loadImage(entity);
            entityImage = this.mechImages.get(new Integer(entity.getId()));
            if (entityImage == null) {
                System.out.println("Unable to load image for entity: " + entity.getShortNameRaw());
            }
        }
        return entityImage.getIcon();
    }

    public Image wreckMarkerFor(Entity entity) {
        EntityImage entityImage = this.mechImages.get(new Integer(entity.getId()));
        if (entityImage == null) {
            System.out.println("Loading image for " + entity.getShortNameRaw() + " on the fly.");
            this.loadImage(entity);
            entityImage = this.mechImages.get(new Integer(entity.getId()));
            if (entityImage == null) {
                System.out.println("Unable to load image for entity: " + entity.getShortNameRaw());
                return null;
            }
        }
        return entityImage.getWreckFacing(entity.getFacing());
    }

    public Image imageFor(Entity entity) {
        if (entity instanceof Mech || entity instanceof Protomech) {
            return this.imageFor(entity, entity.getSecondaryFacing());
        }
        return this.imageFor(entity, entity.getFacing());
    }

    public Image imageFor(Entity entity, int n) {
        EntityImage entityImage = this.mechImages.get(new Integer(entity.getId()));
        if (entityImage == null) {
            System.out.println("Loading image for " + entity.getShortNameRaw() + " on the fly.");
            this.loadImage(entity);
            entityImage = this.mechImages.get(new Integer(entity.getId()));
            if (entityImage == null) {
                System.out.println("Unable to load image for entity: " + entity.getShortNameRaw());
            }
        }
        return entityImage.getFacing(n);
    }

    public Image baseFor(IHex iHex) {
        return this.hexTileset.getBase(iHex, this.comp);
    }

    public List supersFor(IHex iHex) {
        return this.hexTileset.getSupers(iHex, this.comp);
    }

    public Image getMinefieldSign() {
        return this.minefieldSign;
    }

    public Image getNightFog() {
        return this.nightFog;
    }

    public Image getEcmShade(int n) {
        Image image = this.ecmShades.get(new Integer(n));
        if (image == null) {
            Image image2 = this.nightFog;
            int[] nArray = new int[6048];
            PixelGrabber pixelGrabber = new PixelGrabber(image2, 0, 0, 84, 72, nArray, 0, 84);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("EntityImage.applyColor(): Failed to grab pixels for mech image." + interruptedException.getMessage());
                return image;
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                System.err.println("EntityImage.applyColor(): Failed to grab pixels for mech image. ImageObserver aborted.");
                return image;
            }
            for (int i = 0; i < 6048; ++i) {
                int n2 = nArray[i];
                int n3 = n2 >> 24 & 0xFF;
                if (n3 == 0) continue;
                int n4 = n & 0xFFFFFF;
                nArray[i] = n3 << 24 | n4;
            }
            image = this.comp.createImage(new MemoryImageSource(84, 72, nArray, 0, 84));
            this.ecmShades.put(new Integer(n), image);
        }
        return image;
    }

    public Image getArtilleryTarget(int n) {
        switch (n) {
            case 0: {
                return this.artilleryAutohit;
            }
            case 1: {
                return this.artilleryAdjusted;
            }
        }
        return this.artilleryIncoming;
    }

    public boolean isStarted() {
        return this.started;
    }

    public synchronized boolean isLoaded() {
        if (!this.loaded) {
            this.loaded = this.tracker.checkAll(true);
        }
        return this.started && this.loaded;
    }

    public void loadNeededImages(IGame iGame) {
        this.loaded = false;
        IBoard iBoard = iGame.getBoard();
        for (int i = 0; i < iBoard.getHeight(); ++i) {
            for (int j = 0; j < iBoard.getWidth(); ++j) {
                IHex iHex = iBoard.getHex(j, i);
                this.loadHexImage(iHex);
            }
        }
        Enumeration<Entity> enumeration = iGame.getEntities();
        while (enumeration.hasMoreElements()) {
            this.loadImage(enumeration.nextElement());
        }
        this.minefieldSign = this.comp.getToolkit().getImage("data/images/hexes/minefieldsign.gif");
        this.nightFog = this.comp.getToolkit().getImage(NIGHT_IMAGE_FILE);
        this.artilleryAutohit = this.comp.getToolkit().getImage(ARTILLERY_AUTOHIT_IMAGE_FILE);
        this.artilleryAdjusted = this.comp.getToolkit().getImage(ARTILLERY_ADJUSTED_IMAGE_FILE);
        this.artilleryIncoming = this.comp.getToolkit().getImage(ARTILLERY_INCOMING_IMAGE_FILE);
        this.started = true;
    }

    private synchronized void loadHexImage(IHex iHex) {
        this.hexTileset.assignMatch(iHex, this.comp);
        this.hexTileset.trackHexImages(iHex, this.tracker);
    }

    public void clearHex(IHex iHex) {
        this.hexTileset.clearHex(iHex);
    }

    public synchronized void waitForHex(IHex iHex) {
        this.loadHexImage(iHex);
        try {
            this.tracker.waitForID(1);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    public synchronized void loadAllHexes() {
        this.hexTileset.loadAllImages(this.comp, this.tracker);
    }

    public void loadPreviewImage(Entity entity, Image image, int n, BufferedPanel bufferedPanel) {
        Image image2 = this.mechTileset.imageFor(entity, this.comp);
        EntityImage entityImage = new EntityImage(image2, n, image, bufferedPanel);
        Image image3 = entityImage.loadPreviewImage();
        BackGroundDrawer backGroundDrawer = new BackGroundDrawer(image3);
        bufferedPanel.removeBgDrawers();
        bufferedPanel.addBgDrawer(backGroundDrawer);
        MediaTracker mediaTracker = new MediaTracker(this.comp);
        mediaTracker.addImage(image3, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Image getPlayerCamo(Player player) {
        if (null == player.getCamoCategory() || "-- No Camo --".equals(player.getCamoCategory())) {
            return null;
        }
        Image image = null;
        try {
            String string = player.getCamoCategory();
            if ("-- General --".equals(string)) {
                string = "";
            }
            image = (Image)this.camos.getItem(string, player.getCamoFileName());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return image;
    }

    public synchronized void loadImage(Entity entity) {
        Image image = this.mechTileset.imageFor(entity, this.comp);
        Image image2 = null;
        if (!(entity instanceof Infantry) && !(entity instanceof Protomech)) {
            image2 = this.wreckTileset.imageFor(entity, this.comp);
        }
        Player player = entity.getOwner();
        int n = PlayerColors.getColorRGB(player.getColorIndex());
        Image image3 = this.getPlayerCamo(player);
        EntityImage entityImage = null;
        for (EntityImage entityImage2 : this.mechImageList) {
            if (entityImage2.getBase() != image || entityImage2.tint != n) continue;
            entityImage = entityImage2;
            break;
        }
        if (entityImage == null) {
            entityImage = new EntityImage(image, image2, n, image3, this.comp);
            this.mechImageList.add(entityImage);
            entityImage.loadFacings();
            for (int i = 0; i < 6; ++i) {
                this.tracker.addImage(entityImage.getFacing(i), 1);
            }
        }
        this.mechImages.put(new Integer(entity.getId()), entityImage);
    }

    public synchronized void reset() {
        this.loaded = false;
        this.started = false;
        this.tracker = new MediaTracker(this.comp);
        this.hexTileset.reset();
    }

    private class EntityImage {
        private Image base;
        private Image wreck;
        private Image icon;
        private int tint;
        private Image camo;
        private Image[] facings = new Image[6];
        private Image[] wreckFacings = new Image[6];
        private Component comp;
        private static final int IMG_WIDTH = 84;
        private static final int IMG_HEIGHT = 72;
        private static final int IMG_SIZE = 6048;

        public EntityImage(Image image, int n, Image image2, Component component) {
            this(image, null, n, image2, component);
        }

        public EntityImage(Image image, Image image2, int n, Image image3, Component component) {
            this.base = image;
            this.tint = n;
            this.camo = image3;
            this.comp = component;
            this.wreck = image2;
        }

        public void loadFacings() {
            FilteredImageSource filteredImageSource;
            int n;
            this.base = this.applyColor(this.base);
            this.icon = this.base.getScaledInstance(56, 48, 4);
            for (n = 0; n < 6; ++n) {
                filteredImageSource = new FilteredImageSource(this.base.getSource(), new RotateFilter(1.0471975511965976 * (double)(6 - n)));
                this.facings[n] = this.comp.createImage(filteredImageSource);
            }
            if (this.wreck != null) {
                this.wreck = this.applyColor(this.wreck);
                for (n = 0; n < 6; ++n) {
                    filteredImageSource = new FilteredImageSource(this.wreck.getSource(), new RotateFilter(1.0471975511965976 * (double)(6 - n)));
                    this.wreckFacings[n] = this.comp.createImage(filteredImageSource);
                }
            }
        }

        public Image loadPreviewImage() {
            this.base = this.applyColor(this.base);
            return this.base;
        }

        public Image getFacing(int n) {
            return this.facings[n];
        }

        public Image getWreckFacing(int n) {
            return this.wreckFacings[n];
        }

        public Image getBase() {
            return this.base;
        }

        public Image getIcon() {
            return this.icon;
        }

        private Image applyColor(Image image) {
            boolean bl = this.camo != null;
            Image image2 = image;
            int[] nArray = new int[6048];
            int[] nArray2 = new int[6048];
            PixelGrabber pixelGrabber = new PixelGrabber(image2, 0, 0, 84, 72, nArray, 0, 84);
            try {
                pixelGrabber.grabPixels();
            }
            catch (InterruptedException interruptedException) {
                System.err.println("EntityImage.applyColor(): Failed to grab pixels for mech image." + interruptedException.getMessage());
                return image;
            }
            if ((pixelGrabber.getStatus() & 0x80) != 0) {
                System.err.println("EntityImage.applyColor(): Failed to grab pixels for mech image. ImageObserver aborted.");
                return image;
            }
            if (bl) {
                PixelGrabber pixelGrabber2 = new PixelGrabber(this.camo, 0, 0, 84, 72, nArray2, 0, 84);
                try {
                    pixelGrabber2.grabPixels();
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("EntityImage.applyColor(): Failed to grab pixels for camo image." + interruptedException.getMessage());
                    return image;
                }
                if ((pixelGrabber2.getStatus() & 0x80) != 0) {
                    System.err.println("EntityImage.applyColor(): Failed to grab pixels for mech image. ImageObserver aborted.");
                    return image;
                }
            }
            for (int i = 0; i < 6048; ++i) {
                int n = nArray[i];
                int n2 = n >> 24 & 0xFF;
                if (n2 == 0) continue;
                int n3 = bl ? nArray2[i] : this.tint;
                float f = (float)(n3 >> 16 & 0xFF) / 255.0f;
                float f2 = (float)(n3 >> 8 & 0xFF) / 255.0f;
                float f3 = (float)(n3 & 0xFF) / 255.0f;
                float f4 = nArray[i] & 0xFF;
                int n4 = Math.round(f * f4);
                int n5 = Math.round(f2 * f4);
                int n6 = Math.round(f3 * f4);
                nArray[i] = n2 << 24 | n4 << 16 | n5 << 8 | n6;
            }
            image = this.comp.createImage(new MemoryImageSource(84, 72, nArray, 0, 84));
            return image;
        }
    }
}

