/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.ItemSelectable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.util.ImageFileFactory;
import megamek.client.ui.swing.util.PlayerColors;
import megamek.common.Player;
import megamek.common.util.DirectoryItems;

public class CamoChoiceDialog
extends JDialog
implements ActionListener,
ItemListener,
ItemSelectable,
ListSelectionListener {
    private JFrame frame;
    private DirectoryItems camos;
    private JComboBox categories;
    private JList items;
    private JButton keep;
    private JButton select;
    private String prevCat;
    private String prevItem;
    private Vector<ItemListener> listeners = new Vector();

    private void close() {
        this.setCategory(this.prevCat);
        this.setItemName(this.prevItem);
        this.setVisible(false);
    }

    private void fillList(String string) {
        ((DefaultListModel)this.items.getModel()).removeAllElements();
        if ("-- No Camo --".equals(string)) {
            for (String string2 : Player.colorNames) {
                ((DefaultListModel)this.items.getModel()).addElement(string2);
            }
        } else {
            Enumeration<String> enumeration = "-- General --".equals(string) ? this.camos.getItemNames("") : this.camos.getItemNames(string);
            while (enumeration.hasMoreElements()) {
                ((DefaultListModel)this.items.getModel()).addElement(enumeration.nextElement());
            }
        }
        if (this.prevCat.equals(string)) {
            this.setItemName(this.prevItem);
        } else {
            this.setItemName((String)this.items.getModel().getElementAt(0));
        }
    }

    private void setPrevSelection(String string, String string2) {
        if ("-- No Camo --".equals(string)) {
            this.keep.setIcon(null);
            for (int i = 0; i < Player.colorNames.length; ++i) {
                if (!Player.colorNames[i].equals(string2)) continue;
                this.keep.setBackground(PlayerColors.getColor(i));
                this.prevCat = string;
                this.prevItem = string2;
                break;
            }
        } else {
            try {
                String string3 = string;
                if ("-- General --".equals(string3)) {
                    string3 = "";
                }
                Image image = (Image)this.camos.getItem(string3, string2);
                this.keep.setBackground(this.categories.getBackground());
                this.keep.setIcon(new ImageIcon(image));
                this.prevCat = string;
                this.prevItem = string2;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                JOptionPane.showMessageDialog(this.frame, exception.getMessage(), Messages.getString("CamoChoiceDialog.error_getting_camo"), 0);
            }
        }
    }

    public CamoChoiceDialog(JFrame jFrame) {
        super(jFrame, Messages.getString("CamoChoiceDialog.select_camo_pattern"), true);
        this.frame = jFrame;
        try {
            this.camos = new DirectoryItems(new File("data/images/camo"), "", ImageFileFactory.getInstance());
        }
        catch (Exception exception) {
            this.camos = null;
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                CamoChoiceDialog.this.close();
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        this.getContentPane().add((Component)jPanel, "North");
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 10;
        this.categories = new JComboBox();
        jPanel.add((Component)this.categories, gridBagConstraints);
        this.categories.addItem("-- No Camo --");
        if (this.camos != null) {
            if (this.camos.getItemNames("").hasMoreElements()) {
                this.categories.addItem("-- General --");
            }
            Enumeration<String> enumeration = this.camos.getCategoryNames();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                if ("".equals(string)) continue;
                this.categories.addItem(string);
            }
        }
        this.categories.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                CamoChoiceDialog.this.fillList((String)itemEvent.getItem());
                CamoChoiceDialog.this.updateButton();
            }
        });
        this.items = new JList(new DefaultListModel());
        this.items.setPreferredSize(new Dimension(150, 200));
        this.getContentPane().add((Component)new JScrollPane(this.items), "Center");
        this.items.addListSelectionListener(this);
        this.items.setSelectionMode(0);
        jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.getContentPane().add((Component)jPanel, "East");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weighty = 1.0;
        jPanel.add((Component)new JLabel(), gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(Messages.getString("CamoChoiceDialog.keep_old_camo")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.keep = new JButton();
        this.keep.setText(Messages.getString("CamoChoiceDialog.no_camo"));
        this.keep.setPreferredSize(new Dimension(84, 72));
        this.keep.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CamoChoiceDialog.this.close();
            }
        });
        this.keep.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    CamoChoiceDialog.this.close();
                }
            }
        });
        jPanel.add((Component)this.keep, gridBagConstraints);
        ++gridBagConstraints.gridy;
        jPanel.add((Component)new JLabel(Messages.getString("CamoChoiceDialog.select_new_camo")), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.select = new JButton();
        this.select.setText(Messages.getString("CamoChoiceDialog.no_camo"));
        this.select.setPreferredSize(new Dimension(84, 72));
        this.select.addActionListener(this);
        jPanel.add((Component)this.select, gridBagConstraints);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.getKeyCode() == 10) {
                    CamoChoiceDialog.this.actionPerformed(new ActionEvent(CamoChoiceDialog.this.select, keyEvent.getID(), CamoChoiceDialog.this.select.getActionCommand()));
                }
            }
        };
        this.items.addKeyListener(keyAdapter);
        this.select.addKeyListener(keyAdapter);
        this.setPrevSelection("-- No Camo --", Player.colorNames[0]);
        this.fillList("-- No Camo --");
        this.pack();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.categories.getSelectedItem();
        String string2 = (String)this.items.getSelectedValue();
        if (!string.equals(this.prevCat) || !string2.equals(this.prevItem)) {
            this.setPrevSelection(string, string2);
            if (!this.listeners.isEmpty()) {
                Image image = null;
                Image[] imageArray = (Image[])this.getSelectedObjects();
                if (imageArray != null) {
                    image = imageArray[0];
                }
                ItemEvent itemEvent = new ItemEvent(this, actionEvent.getID(), image, 701);
                Enumeration<ItemListener> enumeration = this.listeners.elements();
                while (enumeration.hasMoreElements()) {
                    enumeration.nextElement().itemStateChanged(itemEvent);
                }
            }
        }
        this.close();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.updateButton();
    }

    private void updateButton() {
        String string = (String)this.categories.getSelectedItem();
        if ("-- No Camo --".equals(string)) {
            int n = this.items.getSelectedIndex();
            if (n == -1) {
                for (int i = 0; i < Player.colorNames.length; ++i) {
                    if (!Player.colorNames[i].equals(this.prevItem)) continue;
                    n = i;
                    break;
                }
            }
            if (n == -1) {
                return;
            }
            this.select.setIcon(null);
            this.select.setBackground(PlayerColors.getColor(n));
            return;
        }
        if ("-- General --".equals(string)) {
            string = "";
        }
        try {
            this.select.setBackground(this.categories.getBackground());
            String string2 = (String)this.items.getSelectedValue();
            if (string2 != null) {
                Image image = (Image)this.camos.getItem(string, string2);
                if (image != null) {
                    this.select.setIcon(new ImageIcon(image));
                } else {
                    this.select.setIcon(null);
                }
            } else {
                this.select.setIcon(null);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, exception.getMessage(), Messages.getString("CamoChoiceDialog.error_getting_camo"), 0);
        }
    }

    public Object[] getSelectedObjects() {
        Object[] objectArray;
        this.setPrevSelection((String)this.categories.getSelectedItem(), (String)this.items.getSelectedValue());
        if ("-- No Camo --".equals(this.prevCat)) {
            return null;
        }
        Image image = null;
        try {
            objectArray = this.prevCat;
            if ("-- General --".equals(objectArray)) {
                objectArray = "";
            }
            image = (Image)this.camos.getItem((String)objectArray, this.prevItem);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JOptionPane.showMessageDialog(this.frame, exception.getMessage(), Messages.getString("CamoChoiceDialog.error_getting_camo"), 0);
        }
        if (image == null) {
            return null;
        }
        objectArray = new Image[]{image};
        return objectArray;
    }

    public void addItemListener(ItemListener itemListener) {
        if (!this.listeners.contains(itemListener)) {
            this.listeners.addElement(itemListener);
        }
    }

    public void removeItemListener(ItemListener itemListener) {
        this.listeners.removeElement(itemListener);
    }

    public String getCategory() {
        return this.prevCat;
    }

    public String getItemName() {
        return this.prevItem;
    }

    public void setCategory(String string) {
        String string2 = (String)this.categories.getSelectedItem();
        if (!string2.equals(string)) {
            for (int i = 0; i < this.categories.getItemCount(); ++i) {
                if (!this.categories.getItemAt(i).equals(string)) continue;
                this.categories.setSelectedIndex(i);
                this.fillList(string);
                break;
            }
        }
    }

    public void setItemName(String string) {
        String string2;
        if (string != null && !string.equals(string2 = (String)this.items.getSelectedValue())) {
            this.items.setSelectedValue(string, true);
        }
    }

    public void setVisible(boolean bl) {
        this.setPrevSelection((String)this.categories.getSelectedItem(), (String)this.items.getSelectedValue());
        this.updateButton();
        super.setVisible(bl);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.updateButton();
    }
}

