/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing.util;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import megamek.common.util.ItemFile;
import megamek.common.util.ItemFileFactory;

public class ImageFileFactory
implements ItemFileFactory {
    private static final String JPG = "JPG";
    private static final String JPEG = "JPEG";
    private static final String GIF = "GIF";
    private static final String PNG = "PNG";
    private static ImageFileFactory singleton = null;

    private ImageFileFactory() {
    }

    public static ImageFileFactory getInstance() {
        if (null == singleton) {
            singleton = new ImageFileFactory();
        }
        return singleton;
    }

    public ItemFile getItemFile(File file) throws IllegalArgumentException {
        if (null == file) {
            throw new IllegalArgumentException("A null image file was passed.");
        }
        final File file2 = file;
        return new ItemFile(){
            private File file;
            private Image image;
            {
                this.file = file2;
                this.image = null;
            }

            public Object getItem() throws Exception {
                if (null == this.image) {
                    String string = this.file.getAbsolutePath();
                    this.image = Toolkit.getDefaultToolkit().getImage(string);
                }
                return this.image.getScaledInstance(84, 72, 2);
            }
        };
    }

    public ItemFile getItemFile(ZipEntry zipEntry, ZipFile zipFile) throws IllegalArgumentException {
        if (null == zipEntry) {
            throw new IllegalArgumentException("A null ZIP entry was passed.");
        }
        if (null == zipFile) {
            throw new IllegalArgumentException("A null ZIP file was passed.");
        }
        final ZipEntry zipEntry2 = zipEntry;
        final ZipFile zipFile2 = zipFile;
        return new ItemFile(){
            private ZipEntry item;
            private ZipFile zipFile;
            private Image image;
            {
                this.item = zipEntry2;
                this.zipFile = zipFile2;
                this.image = null;
            }

            public Object getItem() throws Exception {
                if (null == this.image) {
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(this.zipFile.getInputStream(this.item), (int)this.item.getSize());
                    byte[] byArray = new byte[(int)this.item.getSize()];
                    ((InputStream)bufferedInputStream).read(byArray);
                    int n = (int)this.item.getSize() - 10;
                    while (this.item.getSize() > (long)n && 0 == byArray[n]) {
                        ++n;
                    }
                    if (this.item.getSize() <= (long)n) {
                        throw new IOException("Error reading " + this.item.getName() + "\nYou may want to unzip " + this.zipFile.getName());
                    }
                    this.image = Toolkit.getDefaultToolkit().createImage(byArray);
                }
                return this.image.getScaledInstance(84, 72, 2);
            }
        };
    }

    public boolean accept(File file, String string) {
        String string2 = string.toUpperCase();
        return string2.endsWith(JPG) || string2.endsWith(JPEG) || string2.endsWith(GIF) || string2.endsWith(PNG);
    }

    public boolean accept(ZipFile zipFile, String string) {
        String string2 = string.toUpperCase();
        return string2.endsWith(JPG) || string2.endsWith(JPEG) || string2.endsWith(GIF) || string2.endsWith(PNG);
    }
}

