/*
 * Decompiled with CFR 0.152.
 */
package megamek.client.ui.swing.widget;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JComponent;
import megamek.client.ui.swing.GUIPreferences;
import megamek.client.ui.swing.Messages;
import megamek.client.ui.swing.widget.BackGroundDrawer;
import megamek.client.ui.swing.widget.DisplayMapSet;
import megamek.client.ui.swing.widget.PMAreasGroup;
import megamek.client.ui.swing.widget.PMSimpleLabel;
import megamek.client.ui.swing.widget.PMUtil;
import megamek.common.Entity;
import megamek.common.GunEmplacement;
import megamek.common.Mech;
import megamek.common.Tank;
import megamek.common.options.IOption;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneralInfoMapSet
implements DisplayMapSet {
    private static final String IMAGE_DIR = "data/images/widgets";
    private static String STAR3 = "***";
    private JComponent comp;
    private PMAreasGroup content = new PMAreasGroup();
    private PMSimpleLabel mechTypeL0;
    private PMSimpleLabel mechTypeL1;
    private PMSimpleLabel statusL;
    private PMSimpleLabel playerL;
    private PMSimpleLabel teamL;
    private PMSimpleLabel weightL;
    private PMSimpleLabel bvL;
    private PMSimpleLabel pilotL;
    private PMSimpleLabel mpL0;
    private PMSimpleLabel mpL1;
    private PMSimpleLabel mpL2;
    private PMSimpleLabel mpL3;
    private PMSimpleLabel curMoveL;
    private PMSimpleLabel heatL;
    private PMSimpleLabel movementTypeL;
    private PMSimpleLabel ejectL;
    private PMSimpleLabel elevationL;
    private PMSimpleLabel buildingTypeL;
    private PMSimpleLabel buildingHeightL;
    private PMSimpleLabel statusR;
    private PMSimpleLabel playerR;
    private PMSimpleLabel teamR;
    private PMSimpleLabel weightR;
    private PMSimpleLabel bvR;
    private PMSimpleLabel pilotR;
    private PMSimpleLabel mpR0;
    private PMSimpleLabel mpR1;
    private PMSimpleLabel mpR2;
    private PMSimpleLabel mpR3;
    private PMSimpleLabel curMoveR;
    private PMSimpleLabel heatR;
    private PMSimpleLabel movementTypeR;
    private PMSimpleLabel ejectR;
    private PMSimpleLabel elevationR;
    private PMSimpleLabel buildingTypeR;
    private PMSimpleLabel buildingHeightR;
    private PMSimpleLabel[] advantagesR;
    private Vector<BackGroundDrawer> bgDrawers = new Vector();
    private static final Font FONT_VALUE = new Font("SansSerif", 0, GUIPreferences.getInstance().getInt("AdvancedMechDisplayLargeFontSize"));
    private static final Font FONT_TITLE = new Font("SansSerif", 2, GUIPreferences.getInstance().getInt("AdvancedMechDisplayLargeFontSize"));
    private int yCoord = 1;

    public GeneralInfoMapSet(JComponent jComponent) {
        this.comp = jComponent;
        this.setAreas();
        this.setBackGround();
    }

    private int getYCoord() {
        return this.yCoord * 15 - 5;
    }

    private int getNewYCoord() {
        ++this.yCoord;
        return this.getYCoord();
    }

    private void setAreas() {
        FontMetrics fontMetrics = this.comp.getFontMetrics(FONT_TITLE);
        this.mechTypeL0 = this.createLabel(Messages.getString("GeneralInfoMapSet.LocOstLCT"), fontMetrics, 0, this.getYCoord());
        this.mechTypeL0.setColor(Color.yellow);
        this.content.addArea(this.mechTypeL0);
        this.mechTypeL1 = this.createLabel(STAR3, fontMetrics, 0, this.getNewYCoord());
        this.mechTypeL1.setColor(Color.yellow);
        this.content.addArea(this.mechTypeL1);
        fontMetrics = this.comp.getFontMetrics(FONT_VALUE);
        this.playerL = this.createLabel(Messages.getString("GeneralInfoMapSet.playerL"), fontMetrics, 0, this.getNewYCoord());
        this.content.addArea(this.playerL);
        this.playerR = this.createLabel(Messages.getString("GeneralInfoMapSet.playerR"), fontMetrics, this.playerL.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.playerR);
        this.teamL = this.createLabel(Messages.getString("GeneralInfoMapSet.teamL"), fontMetrics, 0, this.getNewYCoord());
        this.content.addArea(this.teamL);
        this.teamR = this.createLabel(Messages.getString("GeneralInfoMapSet.teamR"), fontMetrics, this.teamL.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.teamR);
        this.statusL = this.createLabel(Messages.getString("GeneralInfoMapSet.statusL"), fontMetrics, 0, this.getNewYCoord());
        this.content.addArea(this.statusL);
        this.statusR = this.createLabel(STAR3, fontMetrics, this.statusL.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.statusR);
        this.weightL = this.createLabel(Messages.getString("GeneralInfoMapSet.weightL"), fontMetrics, 0, this.getNewYCoord());
        this.content.addArea(this.weightL);
        this.weightR = this.createLabel(STAR3, fontMetrics, this.weightL.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.weightR);
        this.bvL = this.createLabel(Messages.getString("GeneralInfoMapSet.bvL"), fontMetrics, 0, this.getNewYCoord());
        this.content.addArea(this.bvL);
        this.bvR = this.createLabel(STAR3, fontMetrics, this.bvL.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.bvR);
        this.mpL0 = this.createLabel(Messages.getString("GeneralInfoMapSet.mpL0"), fontMetrics, 0, this.getNewYCoord());
        this.content.addArea(this.mpL0);
        this.mpR0 = this.createLabel("", fontMetrics, this.mpL0.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.mpR0);
        this.mpL1 = this.createLabel(Messages.getString("GeneralInfoMapSet.mpL1"), fontMetrics, 0, this.getNewYCoord());
        this.mpL1.moveTo(this.mpL0.getSize().width - this.mpL1.getSize().width, this.getYCoord());
        this.content.addArea(this.mpL1);
        this.mpR1 = this.createLabel(STAR3, fontMetrics, this.mpL0.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.mpR1);
        this.mpL2 = this.createLabel(Messages.getString("GeneralInfoMapSet.mpL2"), fontMetrics, 0, this.getNewYCoord());
        this.mpL2.moveTo(this.mpL0.getSize().width - this.mpL2.getSize().width, this.getYCoord());
        this.content.addArea(this.mpL2);
        this.mpR2 = this.createLabel(STAR3, fontMetrics, this.mpL0.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.mpR2);
        this.mpL3 = this.createLabel(Messages.getString("GeneralInfoMapSet.mpL3"), fontMetrics, 0, this.getNewYCoord());
        this.mpL3.moveTo(this.mpL0.getSize().width - this.mpL3.getSize().width, this.getYCoord());
        this.content.addArea(this.mpL3);
        this.mpR3 = this.createLabel(STAR3, fontMetrics, this.mpL0.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.mpR3);
        this.curMoveL = this.createLabel(Messages.getString("GeneralInfoMapSet.curMoveL"), fontMetrics, 0, this.getNewYCoord());
        this.content.addArea(this.curMoveL);
        this.curMoveR = this.createLabel(STAR3, fontMetrics, this.curMoveL.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.curMoveR);
        this.heatL = this.createLabel(Messages.getString("GeneralInfoMapSet.heatL"), fontMetrics, 0, this.getNewYCoord());
        this.content.addArea(this.heatL);
        this.heatR = this.createLabel(STAR3, fontMetrics, this.heatL.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.heatR);
        this.movementTypeL = this.createLabel(Messages.getString("GeneralInfoMapSet.movementTypeL"), fontMetrics, 0, this.getNewYCoord());
        this.content.addArea(this.movementTypeL);
        this.movementTypeR = this.createLabel(STAR3, fontMetrics, this.movementTypeL.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.movementTypeR);
        this.pilotL = this.createLabel(Messages.getString("GeneralInfoMapSet.pilotL"), fontMetrics, 0, this.getNewYCoord());
        this.content.addArea(this.pilotL);
        this.pilotR = this.createLabel(STAR3, fontMetrics, this.pilotL.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.pilotR);
        this.ejectL = this.createLabel(Messages.getString("GeneralInfoMapSet.ejectL"), fontMetrics, 0, this.getNewYCoord());
        this.content.addArea(this.ejectL);
        this.ejectR = this.createLabel(STAR3, fontMetrics, this.ejectL.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.ejectR);
        this.elevationL = this.createLabel(Messages.getString("GeneralInfoMapSet.elevationL"), fontMetrics, 0, this.getNewYCoord());
        this.content.addArea(this.elevationL);
        this.elevationR = this.createLabel(STAR3, fontMetrics, this.ejectL.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.elevationR);
        this.buildingTypeL = this.createLabel(Messages.getString("GeneralInfoMapSet.buildingTypeL"), fontMetrics, 0, this.getNewYCoord());
        this.content.addArea(this.buildingTypeL);
        this.buildingTypeR = this.createLabel(STAR3, fontMetrics, this.buildingTypeL.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.buildingTypeR);
        this.buildingHeightL = this.createLabel(Messages.getString("GeneralInfoMapSet.buildingHeightL"), fontMetrics, 0, this.getNewYCoord());
        this.content.addArea(this.buildingHeightL);
        this.buildingHeightR = this.createLabel(STAR3, fontMetrics, this.buildingHeightL.getSize().width + 10, this.getYCoord());
        this.content.addArea(this.buildingHeightR);
        this.advantagesR = new PMSimpleLabel[24];
        for (int i = 0; i < this.advantagesR.length; ++i) {
            this.advantagesR[i] = this.createLabel(Integer.toString(i), fontMetrics, this.pilotL.getSize().width + 10, this.getNewYCoord());
            this.content.addArea(this.advantagesR[i]);
        }
    }

    @Override
    public void setEntity(Entity entity) {
        Object object;
        int n;
        String string = entity.getShortName();
        this.mechTypeL1.setVisible(false);
        if (string.length() > GUIPreferences.getInstance().getInt("AdvancedMechDisplayWrapLength")) {
            this.mechTypeL1.setColor(Color.yellow);
            n = string.lastIndexOf(" ", GUIPreferences.getInstance().getInt("AdvancedMechDisplayWrapLength"));
            this.mechTypeL0.setString(string.substring(0, n));
            this.mechTypeL1.setString(string.substring(n).trim());
            this.mechTypeL1.setVisible(true);
        } else {
            this.mechTypeL0.setString(string);
            this.mechTypeL1.setString("");
        }
        if (!entity.isDesignValid()) {
            this.mechTypeL1.setColor(Color.red);
            this.mechTypeL1.setString(Messages.getString("GeneralInfoMapSet.invalidDesign"));
            this.mechTypeL1.setVisible(true);
        }
        this.statusR.setString(entity.isProne() ? Messages.getString("GeneralInfoMapSet.prone") : Messages.getString("GeneralInfoMapSet.normal"));
        this.playerR.setString(entity.getOwner().getName());
        if (entity.getOwner().getTeam() == 0) {
            this.teamL.setVisible(false);
            this.teamR.setVisible(false);
        } else {
            this.teamL.setVisible(true);
            this.teamR.setString(Messages.getString("GeneralInfoMapSet.Team") + entity.getOwner().getTeam());
            this.teamR.setVisible(true);
        }
        this.weightR.setString(Integer.toString((int)entity.getWeight()));
        this.pilotR.setString(entity.crew.getDesc() + " (" + entity.crew.getGunnery() + "/" + entity.crew.getPiloting() + ")");
        this.ejectR.setString(Messages.getString("GeneralInfoMapSet.NA"));
        if (entity instanceof Mech) {
            if (((Mech)entity).isAutoEject()) {
                this.ejectR.setString(Messages.getString("GeneralInfoMapSet.Operational"));
            } else {
                this.ejectR.setString(Messages.getString("GeneralInfoMapSet.Disabled"));
            }
        }
        this.elevationR.setString(Messages.getString("GeneralInfoMapSet.NA"));
        this.elevationR.setString(Integer.toString(entity.getElevation()));
        for (n = 0; n < this.advantagesR.length; ++n) {
            this.advantagesR[n].setString("");
        }
        if (entity.crew.countAdvantages() > 0) {
            n = 0;
            Enumeration enumeration = entity.crew.getAdvantages();
            while (enumeration.hasMoreElements()) {
                object = (IOption)enumeration.nextElement();
                if (!object.booleanValue()) continue;
                this.advantagesR[n++].setString(object.getDisplayableNameWithValue());
            }
        }
        if (entity.mpUsed > 0) {
            this.mpR0.setString("(" + entity.mpUsed + " used)");
        } else {
            this.mpR0.setString("");
        }
        this.mpR1.setString(Integer.toString(entity.getWalkMP()));
        this.mpR2.setString(entity.getRunMPasString());
        if (entity.hasUMU()) {
            this.mpR3.setString(Integer.toString(entity.getActiveUMUCount()));
        } else {
            this.mpR3.setString(Integer.toString(entity.getJumpMPWithTerrain()));
        }
        this.curMoveR.setString(entity.getMovementString(entity.moved) + (entity.moved == 0 ? "" : " " + entity.delta_distance));
        n = entity.getHeatCapacity();
        int n2 = entity.getHeatCapacityWithWater();
        object = Integer.toString(n);
        if (n < n2) {
            object = n + " [" + n2 + "]";
        }
        this.heatR.setString(Integer.toString(entity.heat) + " (" + (String)object + " " + Messages.getString("GeneralInfoMapSet.capacity") + ")");
        if (entity instanceof Mech) {
            this.heatL.setVisible(true);
            this.heatR.setVisible(true);
        } else {
            this.heatL.setVisible(false);
            this.heatR.setVisible(false);
        }
        if (entity instanceof Tank) {
            this.movementTypeL.setVisible(true);
            this.movementTypeR.setString(entity.getMovementModeAsString());
            this.movementTypeR.setVisible(true);
        } else {
            this.movementTypeL.setVisible(false);
            this.movementTypeR.setVisible(false);
        }
        if (entity instanceof GunEmplacement) {
            this.weightL.setVisible(false);
            this.weightR.setVisible(false);
            this.mpL0.setVisible(false);
            this.mpR0.setVisible(false);
            this.mpL1.setVisible(false);
            this.mpR1.setVisible(false);
            this.mpL2.setVisible(false);
            this.mpR2.setVisible(false);
            this.mpL3.setVisible(false);
            this.mpR3.setVisible(false);
            this.curMoveL.setVisible(false);
            this.curMoveR.setVisible(false);
            this.buildingTypeL.setVisible(true);
            this.buildingTypeR.setVisible(true);
            this.buildingHeightL.setVisible(true);
            GunEmplacement gunEmplacement = (GunEmplacement)entity;
            switch (gunEmplacement.getConstructionType()) {
                case 1: {
                    this.buildingTypeR.setString(Messages.getString("GeneralInfoMapSet.buildingTypeRLight"));
                    break;
                }
                case 2: {
                    this.buildingTypeR.setString(Messages.getString("GeneralInfoMapSet.buildingTypeRMedium"));
                    break;
                }
                case 3: {
                    this.buildingTypeR.setString(Messages.getString("GeneralInfoMapSet.buildingTypeRHeavy"));
                    break;
                }
                case 4: {
                    this.buildingTypeR.setString(Messages.getString("GeneralInfoMapSet.buildingTypeRHardened"));
                    break;
                }
                case 5: {
                    this.buildingTypeR.setString(Messages.getString(""));
                    break;
                }
                default: {
                    this.buildingTypeR.setString(Messages.getString("GeneralInfoMapSet.buildingTypeRUnknown"));
                }
            }
            this.buildingHeightR.setString(Integer.toString(gunEmplacement.getHeight()));
        } else {
            this.weightL.setVisible(true);
            this.weightR.setVisible(true);
            this.mpL0.setVisible(true);
            this.mpR0.setVisible(true);
            this.mpL1.setVisible(true);
            this.mpR1.setVisible(true);
            this.mpL2.setVisible(true);
            this.mpR2.setVisible(true);
            this.mpL3.setVisible(true);
            this.mpR3.setVisible(true);
            this.curMoveL.setVisible(true);
            this.curMoveR.setVisible(true);
            this.buildingTypeL.setVisible(false);
            this.buildingTypeR.setVisible(false);
            this.buildingHeightL.setVisible(false);
            this.buildingHeightR.setVisible(false);
        }
        this.bvR.setString(Integer.toString(entity.calculateBattleValue()));
    }

    @Override
    public PMAreasGroup getContentGroup() {
        return this.content;
    }

    @Override
    public Vector<BackGroundDrawer> getBackgroundDrawers() {
        return this.bgDrawers;
    }

    private void setBackGround() {
        Image image = this.comp.getToolkit().getImage("data/images/widgets/tile.gif");
        PMUtil.setImage(image, this.comp);
        int n = 8;
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 20;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 68;
        image = this.comp.getToolkit().getImage("data/images/widgets/h_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 258;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1026;
        image = this.comp.getToolkit().getImage("data/images/widgets/v_line.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 273;
        image = this.comp.getToolkit().getImage("data/images/widgets/tl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 321;
        image = this.comp.getToolkit().getImage("data/images/widgets/bl_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1041;
        image = this.comp.getToolkit().getImage("data/images/widgets/tr_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
        n = 1089;
        image = this.comp.getToolkit().getImage("data/images/widgets/br_corner.gif");
        PMUtil.setImage(image, this.comp);
        this.bgDrawers.addElement(new BackGroundDrawer(image, n));
    }

    private PMSimpleLabel createLabel(String string, FontMetrics fontMetrics, int n, int n2) {
        PMSimpleLabel pMSimpleLabel = new PMSimpleLabel(string, fontMetrics, Color.white);
        pMSimpleLabel.moveTo(n, n2);
        return pMSimpleLabel;
    }
}

