/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Vector;
import megamek.common.Compute;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.Infantry;
import megamek.common.LocationFullException;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.Tank;
import megamek.common.TargetRoll;
import megamek.common.WeaponType;

public class BattleArmor
extends Infantry
implements Serializable {
    private static final int[] IS_NUM_OF_SLOTS = new int[]{7, 2, 2, 2, 2, 2, 2};
    private static final String[] IS_LOCATION_ABBRS = new String[]{"Squad", "Trooper 1", "Trooper 2", "Trooper 3", "Trooper 4", "Trooper 5", "Trooper 6"};
    private static final String[] IS_LOCATION_NAMES = new String[]{"Squad", "Trooper 1", "Trooper 2", "Trooper 3", "Trooper 4", "Trooper 5", "Trooper 6"};
    private static final int[] CLAN_NUM_OF_SLOTS = new int[]{10, 2, 2, 2, 2, 2, 2};
    private static final String[] CLAN_LOCATION_ABBRS = new String[]{"Point", "Trooper 1", "Trooper 2", "Trooper 3", "Trooper 4", "Trooper 5", "Trooper 6"};
    private static final String[] CLAN_LOCATION_NAMES = new String[]{"Point", "Trooper 1", "Trooper 2", "Trooper 3", "Trooper 4", "Trooper 5", "Trooper 6"};
    public static final int MANIPULATOR_NONE = 0;
    public static final int MANIPULATOR_ARMORED_GLOVE = 1;
    public static final int MANIPULATOR_BASIC = 2;
    public static final int MANIPULATOR_BASIC_MINE_CLEARANCE = 3;
    public static final int MANIPULATOR_BATTLE = 4;
    public static final int MANIPULATOR_BATTLE_MAGNET = 5;
    public static final int MANIPULATOR_BATTLE_VIBRO = 6;
    public static final int MANIPULATOR_HEAVY_BATTLE = 7;
    public static final int MANIPULATOR_HEAVY_BATTLE_VIBRO = 8;
    public static final int MANIPULATOR_SALVAGE_ARM = 9;
    public static final int MANIPULATOR_CARGO_LIFTER = 10;
    public static final int MANIPULATOR_INDUSTRIAL_DRILL = 11;
    public static final String[] MANIPULATOR_TYPE_STRINGS = new String[]{"None", "Armored Glove", "Basic Manipulator", "Basic Manipulator (Mine Clearance)", "Battle Claw", "Battle Claw (Magnets)", "Battle Claw (Vibro-Claws)", "Heavy Battle Claw", "Heavy Battle Claw (Vibro-Claws)", "Salvage Arm", "Cargo Lifter", "Industrial Drill"};
    private int troopersShooting = 0;
    private int myBV = 0;
    private int myCost = -1;
    private int weightClass = -1;
    private int chassisType = -1;
    private boolean isInitialized = false;
    private boolean isStealthy = false;
    private boolean isMimetic = false;
    private boolean isSimpleCamo = false;
    private int shortStealthMod = 0;
    private int mediumStealthMod = 0;
    private int longStealthMod = 0;
    private String stealthName = null;
    private int vibroClawDamage = -1;
    public static final String IS_DISPOSABLE_SRM2_AMMO = "BA-SRM2 (one shot) Ammo";
    public static final String IS_DISPOSABLE_NARC_AMMO = "BA-Compact Narc Ammo";
    public static final String BOARDING_CLAW = "BA-Boarding Claw";
    public static final String ASSAULT_CLAW = "BA-Assault Claws";
    public static final String FIRE_PROTECTION = "BA-Fire Resistant Armor";
    public static final String MAGNETIC_CLAMP = "BA-Magnetic Clamp";
    public static final String MINE_LAUNCHER = "BAMineLauncher";
    public static final String STEALTH = "Basic Stealth";
    public static final String ADVANCED_STEALTH = "Standard Stealth";
    public static final String EXPERT_STEALTH = "Improved Stealth";
    public static final String MIMETIC_CAMO = "Mimetic Armor";
    public static final String SIMPLE_CAMO = "Simple Camo";
    public static final String SINGLE_HEX_ECM = "Single-Hex ECM";
    public static final String LONGINUS_SQUAD = "Longinus";
    public static final String PURIFIER_SQUAD = "Purifier";
    public static final int BA_MAX_MEN = 6;
    public static final int LOC_SQUAD = 0;
    public static final int LOC_IS_1 = 1;
    public static final int LOC_IS_2 = 2;
    public static final int LOC_IS_3 = 3;
    public static final int LOC_IS_4 = 4;
    public static final int LOC_IS_5 = 5;
    public static final int LOC_IS_6 = 6;
    public static final int LOC_CLAN_1 = 1;
    public static final int LOC_CLAN_2 = 2;
    public static final int LOC_CLAN_3 = 3;
    public static final int LOC_CLAN_4 = 4;
    public static final int LOC_CLAN_5 = 5;
    public static final int LOC_CLAN_6 = 6;

    public String[] getLocationAbbrs() {
        if (!this.isInitialized || this.isClan()) {
            return CLAN_LOCATION_ABBRS;
        }
        return IS_LOCATION_ABBRS;
    }

    public String[] getLocationNames() {
        if (!this.isInitialized || this.isClan()) {
            return CLAN_LOCATION_NAMES;
        }
        return IS_LOCATION_NAMES;
    }

    public int locations() {
        int n = Math.round(this.getWeight());
        if (n == 0) {
            if (!this.isInitialized) {
                n = 7;
            } else if (this.isClan()) {
                n = 6;
            }
            n = 5;
        } else {
            ++n;
        }
        return n;
    }

    public BattleArmor() {
        this.setTechLevel(2);
        this.isInitialized = true;
    }

    public int getOriginalJumpMP() {
        return this.jumpMP;
    }

    public int getWalkMP() {
        int n = this.applyGravityEffectsOnMP(this.getOriginalWalkMP());
        if (this.game != null) {
            int n2 = this.game.getTemperatureDifference();
            return Math.max(n - n2, 0);
        }
        return n;
    }

    public int getRunMP(boolean bl) {
        int n = this.applyGravityEffectsOnMP(this.getOriginalRunMP());
        if (this.game != null) {
            int n2 = this.game.getTemperatureDifference();
            return Math.max(n - n2, 0);
        }
        return n;
    }

    public int getJumpMP() {
        if (this.isBurdened()) {
            return 0;
        }
        return super.getJumpMP();
    }

    public String getMovementString(int n) {
        switch (n) {
            case 0: {
                return "None";
            }
            case 1: 
            case 2: {
                return "Walked";
            }
            case 4: 
            case 5: {
                return "Flew";
            }
            case 3: {
                return "Jumped";
            }
        }
        return "Unknown!";
    }

    public String getMovementAbbr(int n) {
        switch (n) {
            case 0: {
                return "N";
            }
            case 1: {
                return "W";
            }
            case 2: {
                return "R";
            }
            case 3: {
                return "J";
            }
            case 4: 
            case 5: {
                return "F";
            }
        }
        return "?";
    }

    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        return this.rollHitLocation(n, n2);
    }

    public HitData rollHitLocation(int n, int n2) {
        if (this.isDoomed()) {
            return new HitData(1);
        }
        int n3 = Compute.d6();
        if (this.game.getOptions().booleanOption("ba_criticals") && n3 == 6) {
            return new HitData(Compute.d6(), false, 1);
        }
        while (n3 >= this.locations() || -1 == this.getInternal(n3) || -3 == this.getInternal(n3) || -2 == this.getInternal(n3) && !this.isDoomed()) {
            n3 = Compute.d6();
        }
        return new HitData(n3);
    }

    public HitData getTrooperAtLocation(HitData hitData, Entity entity) {
        if (entity instanceof Mech) {
            int n = 99;
            switch (hitData.getLocation()) {
                case 2: {
                    if (hitData.isRear()) {
                        n = 3;
                        break;
                    }
                    n = 1;
                    break;
                }
                case 3: {
                    if (hitData.isRear()) {
                        n = 4;
                        break;
                    }
                    n = 2;
                    break;
                }
                case 1: {
                    n = hitData.isRear() ? 5 : 6;
                }
            }
            if (n < this.locations()) {
                return new HitData(n);
            }
        } else if (entity instanceof Tank) {
            int n = 99;
            switch (hitData.getLocation()) {
                case 2: {
                    if (this.getInternal(1) > 0 && this.getInternal(2) > 0) {
                        n = Compute.randomInt(2) + 1;
                        break;
                    }
                    if (this.getInternal(1) > 0) {
                        n = 1;
                        break;
                    }
                    n = 2;
                    break;
                }
                case 3: {
                    if (this.getInternal(3) > 0 && this.getInternal(4) > 0) {
                        n = Compute.randomInt(2) + 3;
                        break;
                    }
                    if (this.getInternal(3) > 0) {
                        n = 3;
                        break;
                    }
                    n = 4;
                    break;
                }
                case 4: {
                    n = this.getInternal(5) > 0 && this.getInternal(6) > 0 ? Compute.randomInt(2) + 5 : (this.getInternal(5) > 0 ? 5 : 6);
                }
            }
            if (n < this.locations()) {
                return new HitData(n);
            }
        }
        return this.rollHitLocation(0, 0);
    }

    public HitData getTransferLocation(HitData hitData) {
        for (int i = 1; i < this.locations(); ++i) {
            if (0 >= this.getInternal(i)) continue;
            return new HitData(-1);
        }
        return new HitData(-2);
    }

    protected boolean isPlatoon() {
        return false;
    }

    public int getArmor(int n, boolean bl) {
        if (0 != n) {
            return super.getArmor(n, bl);
        }
        return -1;
    }

    public int getOArmor(int n, boolean bl) {
        if (0 != n) {
            return super.getOArmor(n, bl);
        }
        return -1;
    }

    public int getInternal(int n) {
        if (0 != n) {
            return super.getInternal(n);
        }
        return -1;
    }

    public int getOInternal(int n) {
        if (0 != n) {
            return super.getOInternal(n);
        }
        return -1;
    }

    public void autoSetInternal() {
        this.initializeInternal(-1, 0);
        for (int i = 1; i < this.locations(); ++i) {
            this.initializeInternal(1, i);
        }
        this.troopersShooting = this.locations() - 1;
    }

    protected void addEquipment(Mounted mounted, int n, boolean bl) throws LocationFullException {
        super.addEquipment(mounted, n, bl);
        this.addCritical(n, new CriticalSlot(1, this.getEquipmentNum(mounted), true));
        String string = mounted.getType().getInternalName();
        if (STEALTH.equals(string)) {
            this.isStealthy = true;
            this.shortStealthMod = 0;
            this.mediumStealthMod = 1;
            this.longStealthMod = 2;
            this.stealthName = "basic stealth";
        } else if (ADVANCED_STEALTH.equals(string)) {
            this.isStealthy = true;
            this.shortStealthMod = 1;
            this.mediumStealthMod = 1;
            this.longStealthMod = 2;
            this.stealthName = "standard stealth";
        } else if (EXPERT_STEALTH.equals(string)) {
            this.isStealthy = true;
            this.shortStealthMod = 1;
            this.mediumStealthMod = 2;
            this.longStealthMod = 3;
            this.stealthName = "improved stealth";
        } else if (MIMETIC_CAMO.equals(string)) {
            this.isMimetic = true;
        } else if (SIMPLE_CAMO.equals(string)) {
            this.isSimpleCamo = true;
        }
    }

    protected int[] getNoOfSlots() {
        if (!this.isInitialized || this.isClan()) {
            return CLAN_NUM_OF_SLOTS;
        }
        return IS_NUM_OF_SLOTS;
    }

    public boolean hasHittableCriticals(int n) {
        if (0 == n) {
            return false;
        }
        return super.hasHittableCriticals(n);
    }

    public int calculateBattleValue() {
        double d = this.myBV;
        double d2 = this.crew.getBVSkillMultiplier();
        int n = (int)Math.round(d *= this.getInternalRemainingPercent());
        int n2 = (int)Math.round((double)n * d2);
        return n2;
    }

    public void newRound(int n) {
        super.newRound(n);
        for (Mounted mounted : this.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!MINE_LAUNCHER.equals(equipmentType.getInternalName())) continue;
            mounted.setMode("Single");
        }
    }

    public void applyDamage() {
        super.applyDamage();
        this.troopersShooting = this.getTotalInternal();
    }

    public int getShootingStrength() {
        return this.troopersShooting;
    }

    public void setBattleValue(int n) {
        this.myBV = n;
    }

    public void setCost(int n) {
        this.myCost = n;
    }

    public boolean isBurdened() {
        if (!this.isClan()) {
            for (Mounted mounted : this.getAmmo()) {
                EquipmentType equipmentType = mounted.getType();
                if (mounted.getShotsLeft() <= 0 || !equipmentType.hasFlag(16L)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isStealthActive() {
        return this.isStealthy || this.isMimetic || this.isSimpleCamo;
    }

    public TargetRoll getStealthModifier(int n, Entity entity) {
        int n2;
        TargetRoll targetRoll;
        block34: {
            block32: {
                block37: {
                    block36: {
                        block35: {
                            block33: {
                                targetRoll = null;
                                if (this.armorType == -1) break block32;
                                if (this.armorType != 3 || entity instanceof Infantry) break block33;
                                switch (n) {
                                    case 0: 
                                    case 1: {
                                        break block34;
                                    }
                                    case 2: {
                                        targetRoll = new TargetRoll(1, "Basic Stealth Armor");
                                        break block34;
                                    }
                                    case 3: 
                                    case 4: {
                                        targetRoll = new TargetRoll(2, "Basic Stealth Armor");
                                        break block34;
                                    }
                                    default: {
                                        throw new IllegalArgumentException("Unknown range constant: " + n);
                                    }
                                }
                            }
                            if (this.armorType != 4 || entity instanceof Infantry) break block35;
                            switch (n) {
                                case 0: 
                                case 1: {
                                    break block34;
                                }
                                case 2: {
                                    targetRoll = new TargetRoll(1, "Prototype Stealth Armor");
                                    break block34;
                                }
                                case 3: 
                                case 4: {
                                    targetRoll = new TargetRoll(2, "Prototype Stealth Armor");
                                    break block34;
                                }
                                default: {
                                    throw new IllegalArgumentException("Unknown range constant: " + n);
                                }
                            }
                        }
                        if (this.armorType != 5 || entity instanceof Infantry) break block36;
                        switch (n) {
                            case 0: 
                            case 1: {
                                targetRoll = new TargetRoll(1, "Standard Stealth Armor");
                                break block34;
                            }
                            case 2: {
                                targetRoll = new TargetRoll(1, "Standard Stealth Armor");
                                break block34;
                            }
                            case 3: 
                            case 4: {
                                targetRoll = new TargetRoll(2, "Standard Stealth Armor");
                                break block34;
                            }
                            default: {
                                throw new IllegalArgumentException("Unknown range constant: " + n);
                            }
                        }
                    }
                    if (this.armorType != 6 || entity instanceof Infantry) break block37;
                    switch (n) {
                        case 0: 
                        case 1: {
                            targetRoll = new TargetRoll(1, "Improved Stealth Armor");
                            break block34;
                        }
                        case 2: {
                            targetRoll = new TargetRoll(2, "Improved Stealth Armor");
                            break block34;
                        }
                        case 3: 
                        case 4: {
                            targetRoll = new TargetRoll(3, "Improved Stealth Armor");
                            break block34;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown range constant: " + n);
                        }
                    }
                }
                if (this.armorType == 8) {
                    n2 = 3 - this.delta_distance;
                    n2 = Math.max(0, n2);
                    targetRoll = new TargetRoll(n2, "mimetic armor");
                }
                break block34;
            }
            if (this.isMimetic) {
                n2 = 3 - this.delta_distance;
                n2 = Math.max(0, n2);
                targetRoll = new TargetRoll(n2, "mimetic armor");
            }
            if (this.isStealthy && !(entity instanceof Infantry)) {
                switch (n) {
                    case 0: 
                    case 1: {
                        targetRoll = new TargetRoll(this.shortStealthMod, this.stealthName);
                        break;
                    }
                    case 2: {
                        targetRoll = new TargetRoll(this.mediumStealthMod, this.stealthName);
                        break;
                    }
                    case 3: 
                    case 4: {
                        targetRoll = new TargetRoll(this.longStealthMod, this.stealthName);
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown range constant: " + n);
                    }
                }
            }
        }
        if (this.isSimpleCamo && this.delta_distance < 2) {
            n2 = Math.max(2 - this.delta_distance, 0);
            if (targetRoll == null) {
                targetRoll = new TargetRoll(n2, "camoflage");
            } else {
                targetRoll.append(new TargetRoll(n2, "camoflage"));
            }
        }
        if (targetRoll == null) {
            targetRoll = new TargetRoll(0, "stealth not active");
        }
        return targetRoll;
    }

    public int getVibroClawDamage() {
        if (this.vibroClawDamage < 0) {
            this.vibroClawDamage = 0;
            for (Mounted mounted : this.getWeaponList()) {
                if (!mounted.getType().hasFlag(0x2000000L)) continue;
                this.vibroClawDamage = ((WeaponType)mounted.getType()).getRackSize();
                break;
            }
        }
        return this.vibroClawDamage;
    }

    public double getCost() {
        if (this.myCost > 0) {
            return this.myCost;
        }
        if (this.chassis.equals("Clan Elemental")) {
            return 3500000.0;
        }
        if (this.chassis.equals("Clan Gnome")) {
            return 5250000.0;
        }
        if (this.chassis.equals("Clan Salamander")) {
            return 3325000.0;
        }
        if (this.chassis.equals("Clan Sylph")) {
            return 3325000.0;
        }
        if (this.chassis.equals("Clan Undine")) {
            return 3500000.0;
        }
        if (this.chassis.equals("IS Standard")) {
            return 2400000.0;
        }
        if (this.chassis.equals("Achileus")) {
            return 1920000.0;
        }
        if (this.chassis.equals("Cavalier")) {
            return 2400000.0;
        }
        if (this.chassis.equals("Fa Shih")) {
            return 2250000.0;
        }
        if (this.chassis.equals("Fenrir")) {
            return 2250000.0;
        }
        if (this.chassis.equals("Gray Death Light Scout")) {
            return 1650000.0;
        }
        if (this.chassis.equals("Gray Death Standard")) {
            return 2400000.0;
        }
        if (this.chassis.equals("Infiltrator")) {
            if (this.model.equals("Mk I")) {
                return 1800000.0;
            }
            return 2400000.0;
        }
        if (this.chassis.equals("Kage")) {
            return 1850000.0;
        }
        if (this.chassis.equals("Kanazuchi")) {
            return 3300000.0;
        }
        if (this.chassis.equals(LONGINUS_SQUAD)) {
            return 2550000.0;
        }
        if (this.chassis.equals(PURIFIER_SQUAD)) {
            return 2400000.0;
        }
        if (this.chassis.equals("Raiden")) {
            return 2400000.0;
        }
        if (this.chassis.equals("Sloth")) {
            return 1800000.0;
        }
        return 0.0;
    }

    public boolean hasEiCockpit() {
        return true;
    }

    public void setWeightClass(int n) {
        this.weightClass = n;
    }

    public int getWeightClass() {
        return this.weightClass;
    }

    public void setChassisType(int n) {
        this.chassisType = n;
    }

    public int getChassisType() {
        return this.chassisType;
    }

    public boolean canAssaultDrop() {
        return true;
    }

    public boolean isNuclearHardened() {
        return true;
    }

    public boolean isTrooperActive(int n) {
        return this.getInternal(n) > 0;
    }

    public int getNumberActiverTroopers() {
        int n = 0;
        for (int i = 1; i < this.locations(); ++i) {
            if (!this.isTrooperActive(i)) continue;
            ++n;
        }
        return n;
    }

    public int getRandomTrooper() {
        int n;
        Vector<Integer> vector = new Vector<Integer>();
        for (n = 1; n < this.locations(); ++n) {
            if (!this.isTrooperActive(n)) continue;
            vector.add(n);
        }
        n = Compute.randomInt(vector.size());
        return (Integer)vector.elementAt(n);
    }

    public boolean loadWeapon(Mounted mounted, Mounted mounted2) {
        if (mounted.getLocation() != mounted2.getLocation()) {
            return false;
        }
        return super.loadWeapon(mounted, mounted2);
    }

    public boolean loadWeaponWithSameAmmo(Mounted mounted, Mounted mounted2) {
        if (mounted.getLocation() != mounted2.getLocation()) {
            return false;
        }
        return super.loadWeaponWithSameAmmo(mounted, mounted2);
    }

    public final String getBLK() {
        String string = "\r\n";
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<BlockVersion>");
        stringBuffer.append(string);
        stringBuffer.append("1");
        stringBuffer.append(string);
        stringBuffer.append("</BlockVersion>");
        stringBuffer.append(string);
        stringBuffer.append("<UnitType>");
        stringBuffer.append(string);
        stringBuffer.append("BattleArmor");
        stringBuffer.append(string);
        stringBuffer.append("</UnitType>");
        stringBuffer.append(string);
        stringBuffer.append("<name>");
        stringBuffer.append(string);
        stringBuffer.append(this.getChassis());
        stringBuffer.append(string);
        stringBuffer.append("</name>");
        stringBuffer.append(string);
        stringBuffer.append("<model>");
        stringBuffer.append(string);
        stringBuffer.append(this.getModel());
        stringBuffer.append(string);
        stringBuffer.append("</model>");
        stringBuffer.append(string);
        stringBuffer.append("<year>");
        stringBuffer.append(string);
        stringBuffer.append(this.getYear());
        stringBuffer.append(string);
        stringBuffer.append("</year>");
        stringBuffer.append(string);
        stringBuffer.append("<type>");
        stringBuffer.append(string);
        switch (this.getTechLevel()) {
            case 0: {
                stringBuffer.append("IS Level 1");
                break;
            }
            case 1: {
                stringBuffer.append("IS Level 2");
                break;
            }
            case 5: {
                stringBuffer.append("IS Level 3");
                break;
            }
            case 2: {
                stringBuffer.append("Clan Level 2");
                break;
            }
            case 6: {
                stringBuffer.append("Clan Level 3");
            }
        }
        stringBuffer.append(string);
        stringBuffer.append("</type>");
        stringBuffer.append(string);
        stringBuffer.append("<tonnage>");
        stringBuffer.append(string);
        stringBuffer.append(this.getWeight());
        stringBuffer.append(string);
        stringBuffer.append("</tonnage>");
        stringBuffer.append(string);
        stringBuffer.append("<bv>");
        stringBuffer.append(string);
        stringBuffer.append(this.calculateBattleValue());
        stringBuffer.append(string);
        stringBuffer.append("</bv>");
        stringBuffer.append(string);
        stringBuffer.append("<motion_type>");
        stringBuffer.append(string);
        switch (this.getMovementMode()) {
            case 12: {
                stringBuffer.append("jump");
                break;
            }
            case 10: {
                stringBuffer.append("leg");
                break;
            }
            case 6: {
                stringBuffer.append("vtol");
                break;
            }
            case 18: {
                stringBuffer.append("submarine");
            }
        }
        stringBuffer.append(string);
        stringBuffer.append("</motion_type>");
        stringBuffer.append(string);
        stringBuffer.append("<cruiseMP>");
        stringBuffer.append(string);
        stringBuffer.append(this.getOriginalRunMP());
        stringBuffer.append(string);
        stringBuffer.append("</cruiseMP>");
        stringBuffer.append(string);
        stringBuffer.append("<jumpMP>");
        stringBuffer.append(string);
        stringBuffer.append(this.getOriginalJumpMP());
        stringBuffer.append(string);
        stringBuffer.append("</jumpMP>");
        stringBuffer.append(string);
        stringBuffer.append("<armor>");
        stringBuffer.append(string);
        stringBuffer.append(this.getOArmor(1));
        stringBuffer.append(string);
        stringBuffer.append("</armor>");
        stringBuffer.append(string);
        for (int i = 0; i < this.locations(); ++i) {
            boolean bl = false;
            for (Mounted mounted : this.getEquipment()) {
                if (mounted.getLocation() != i) continue;
                if (!bl) {
                    bl = true;
                    stringBuffer.append("<");
                    stringBuffer.append(this.getLocationName(i));
                    stringBuffer.append(" equipment>");
                    stringBuffer.append(string);
                }
                stringBuffer.append(mounted.getType().getInternalName());
                stringBuffer.append(string);
            }
            if (!bl) continue;
            stringBuffer.append("</");
            stringBuffer.append(this.getLocationName(i));
            stringBuffer.append(" equipment>");
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }
}

