/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.Serializable;
import java.util.Enumeration;
import megamek.common.Entity;
import megamek.common.GunEmplacement;
import megamek.common.IGame;
import megamek.common.Infantry;
import megamek.common.Mech;
import megamek.common.Protomech;
import megamek.common.Tank;

public class GameTurn
implements Serializable {
    private int playerId;
    public static final int CLASS_INFANTRY = 1;
    public static final int CLASS_PROTOMECH = 2;
    public static final int CLASS_TANK = 4;
    public static final int CLASS_MECH = 8;
    public static final int CLASS_GUN_EMPLACEMENT = 16;

    public GameTurn(int n) {
        this.playerId = n;
    }

    public int getPlayerNum() {
        return this.playerId;
    }

    public void setPlayerNum(int n) {
        this.playerId = n;
    }

    public boolean isValidEntity(Entity entity, IGame iGame) {
        return !(entity == null || entity.getOwnerId() != this.playerId || !entity.isSelectableThisTurn() || iGame.getPhase() == 8 && (entity instanceof Infantry && iGame.getOptions().booleanOption("inf_move_later") || entity instanceof Protomech && iGame.getOptions().booleanOption("protos_move_later")) && iGame.checkForValidNonInfantryAndOrProtomechs(this.playerId));
    }

    public boolean isValid(int n, Entity entity, IGame iGame) {
        return n == this.playerId && this.isValidEntity(entity, iGame);
    }

    public boolean isValid(int n, IGame iGame) {
        return n == this.playerId;
    }

    public String toString() {
        return this.getClass().getName() + " [" + this.playerId + "]";
    }

    public static int getClassCode(Entity entity) {
        int n = 0;
        if (entity instanceof Infantry) {
            n = 1;
        } else if (entity instanceof Protomech) {
            n = 2;
        } else if (entity instanceof Tank) {
            n = 4;
        } else if (entity instanceof Mech) {
            n = 8;
        } else if (entity instanceof GunEmplacement) {
            n = 16;
        }
        return n;
    }

    public static class UnitNumberTurn
    extends GameTurn {
        private final char unitNumber;

        public UnitNumberTurn(int n, char c) {
            super(n);
            this.unitNumber = c;
        }

        public boolean isValidEntity(Entity entity, IGame iGame) {
            return super.isValidEntity(entity, iGame) && this.unitNumber == entity.getUnitNumber();
        }
    }

    public static class UnloadStrandedTurn
    extends GameTurn {
        private int[] entityIds = null;

        public UnloadStrandedTurn(int[] nArray) {
            super(-1);
            if (null == nArray) {
                throw new IllegalArgumentException("the passed array of ids is null");
            }
            if (0 == nArray.length) {
                throw new IllegalArgumentException("the passed array of ids is empty");
            }
            this.entityIds = new int[nArray.length];
            System.arraycopy(nArray, 0, this.entityIds, 0, nArray.length);
        }

        public UnloadStrandedTurn(Enumeration enumeration) {
            super(-1);
            if (null == enumeration) {
                throw new IllegalArgumentException("the passed enumeration of entities is null");
            }
            if (!enumeration.hasMoreElements()) {
                throw new IllegalArgumentException("the passed enumeration of entities is empty");
            }
            Entity entity = (Entity)enumeration.nextElement();
            if (enumeration.hasMoreElements()) {
                int[] nArray = new int[entity.game.getNoOfEntities()];
                int n = 0;
                nArray[n++] = entity.getId();
                while (enumeration.hasMoreElements()) {
                    nArray[n++] = ((Entity)enumeration.nextElement()).getId();
                }
                this.entityIds = new int[n];
                System.arraycopy(nArray, 0, this.entityIds, 0, n);
            } else {
                this.entityIds = new int[1];
                this.entityIds[0] = entity.getId();
            }
        }

        public boolean isValidEntity(Entity entity, IGame iGame) {
            boolean bl = false;
            if (null != entity) {
                int n = entity.getId();
                for (int i = 0; i < this.entityIds.length && !bl; ++i) {
                    if (n != this.entityIds[i]) continue;
                    bl = true;
                }
            }
            return bl;
        }

        public boolean isValid(int n, Entity entity, IGame iGame) {
            return null != entity && entity.getOwnerId() == n && this.isValidEntity(entity, iGame);
        }

        public boolean isValid(int n, IGame iGame) {
            boolean bl = false;
            for (int i = 0; i < this.entityIds.length && !bl; ++i) {
                if (iGame.getEntity(this.entityIds[i]) == null || n != iGame.getEntity(this.entityIds[i]).getOwnerId()) continue;
                bl = true;
            }
            return bl;
        }

        public String toString() {
            return this.getClass().getName() + ", entity IDs: [" + this.entityIds + "]";
        }

        public int[] getEntityIds() {
            return this.entityIds;
        }
    }

    public static class EntityClassTurn
    extends GameTurn {
        private final int mask;

        public EntityClassTurn(int n, int n2) {
            super(n);
            this.mask = n2;
        }

        public boolean isValidEntity(Entity entity, IGame iGame) {
            return (GameTurn.getClassCode(entity) & this.mask) != 0 && super.isValidEntity(entity, iGame);
        }

        public boolean isValidClass(int n) {
            return (n & this.mask) != 0;
        }
    }

    public static class CounterGrappleTurn
    extends SpecificEntityTurn {
        public CounterGrappleTurn(int n, int n2) {
            super(n, n2);
        }

        public boolean isValidEntity(Entity entity, IGame iGame) {
            boolean bl = entity.done;
            entity.done = false;
            boolean bl2 = super.isValidEntity(entity, iGame);
            entity.done = bl;
            return bl2;
        }
    }

    public static class TriggerAPPodTurn
    extends SpecificEntityTurn {
        public TriggerAPPodTurn(int n, int n2) {
            super(n, n2);
        }

        public boolean isValidEntity(Entity entity, IGame iGame) {
            boolean bl = entity.done;
            entity.done = false;
            boolean bl2 = super.isValidEntity(entity, iGame);
            entity.done = bl;
            return bl2;
        }
    }

    public static class SpecificEntityTurn
    extends GameTurn {
        private int entityId;

        public SpecificEntityTurn(int n, int n2) {
            super(n);
            this.entityId = n2;
        }

        public int getEntityNum() {
            return this.entityId;
        }

        public void setEntityNum(int n) {
            this.entityId = n;
        }

        public boolean isValidEntity(Entity entity, IGame iGame) {
            return super.isValidEntity(entity, iGame) && entity.getId() == this.entityId;
        }
    }
}

