/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.util.Comparator;
import megamek.common.MechSummary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MechSummaryComparator
implements Comparator<MechSummary> {
    public static final int T_CHASSIS = 0;
    public static final int T_MODEL = 1;
    public static final int T_WEIGHT = 2;
    public static final int T_BV = 3;
    public static final int T_YEAR = 4;
    public static final int T_COST = 5;
    private int m_nType;

    public MechSummaryComparator(int n) {
        this.m_nType = n;
    }

    @Override
    public int compare(MechSummary mechSummary, MechSummary mechSummary2) {
        switch (this.m_nType) {
            case 0: {
                return mechSummary.getChassis().compareTo(mechSummary2.getChassis());
            }
            case 1: {
                return mechSummary.getModel().compareTo(mechSummary2.getModel());
            }
            case 2: {
                return this.numCompare(mechSummary.getTons(), mechSummary2.getTons());
            }
            case 3: {
                return this.numCompare(mechSummary.getBV(), mechSummary2.getBV());
            }
            case 4: {
                return this.numCompare(mechSummary.getYear(), mechSummary2.getYear());
            }
            case 5: {
                return this.numCompare(mechSummary.getCost(), mechSummary2.getCost());
            }
        }
        return 0;
    }

    private int numCompare(int n, int n2) {
        if (n == n2) {
            return 0;
        }
        if (n > n2) {
            return -1;
        }
        return 1;
    }
}

