/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.PrintWriter;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.Compute;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.HitData;
import megamek.common.LocationFullException;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.PilotingRollData;
import megamek.common.Player;
import megamek.common.Report;
import megamek.common.Team;
import megamek.common.WeaponType;
import megamek.common.preference.PreferenceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Protomech
extends Entity
implements Serializable {
    public static final int NUM_PMECH_LOCATIONS = 6;
    public static final String[] LOCATION_NAMES = new String[]{"Head", "Torso", "Right Arm", "Left Arm", "Legs", "Main Gun"};
    public static final String[] LOCATION_ABBRS = new String[]{"HD", "T", "RA", "LA", "L", "MG"};
    private boolean bHasMainGun;
    private boolean bHasRArmGun;
    private boolean bHasLArmGun;
    private boolean bHasTorsoAGun;
    private boolean bHasTorsoBGun;
    private int TorsoAGunNum;
    private int TorsoBGunNum;
    private int[] PilotDamageTaken = new int[]{0, 0, 0, 0, 0, 0};
    private boolean m_bHasNoMainGun = false;
    public static final int LOC_HEAD = 0;
    public static final int LOC_TORSO = 1;
    public static final int LOC_RARM = 2;
    public static final int LOC_LARM = 3;
    public static final int LOC_LEG = 4;
    public static final int LOC_MAINGUN = 5;
    public static final int LOC_NMISS = 6;
    public static final int SYSTEM_ARMCRIT = 0;
    public static final int SYSTEM_LEGCRIT = 1;
    public static final int SYSTEM_HEADCRIT = 2;
    public static final int SYSTEM_TORSOCRIT = 3;
    public static final int SYSTEM_TORSO_WEAPON_A = 4;
    public static final int SYSTEM_TORSO_WEAPON_B = 5;
    private static final int[] NUM_OF_SLOTS = new int[]{2, 3, 2, 2, 3, 0};
    public static final int[] POSSIBLE_PILOT_DAMAGE = new int[]{1, 3, 1, 1, 1, 0};
    public static final String[] systemNames = new String[]{"Arm", "Leg", "Head", "Torso"};

    public Protomech() {
        this.setCritical(0, 0, new CriticalSlot(0, 2));
        this.setCritical(0, 1, new CriticalSlot(0, 2));
        this.setCritical(2, 0, new CriticalSlot(0, 0));
        this.setCritical(2, 1, new CriticalSlot(0, 0));
        this.setCritical(3, 0, new CriticalSlot(0, 0));
        this.setCritical(3, 1, new CriticalSlot(0, 0));
        this.setCritical(1, 0, new CriticalSlot(0, 3));
        this.setCritical(1, 1, new CriticalSlot(0, 3));
        this.setCritical(1, 2, new CriticalSlot(0, 3));
        this.setCritical(4, 0, new CriticalSlot(0, 1));
        this.setCritical(4, 1, new CriticalSlot(0, 1));
        this.setCritical(4, 2, new CriticalSlot(0, 1));
        this.bHasMainGun = false;
        this.bHasRArmGun = false;
        this.bHasLArmGun = false;
        this.bHasTorsoAGun = false;
        this.bHasTorsoBGun = false;
        this.m_bHasNoMainGun = true;
    }

    @Override
    protected int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    public int getPilotDamageTaken(int n) {
        return this.PilotDamageTaken[n];
    }

    public Mounted getTorsoWeapon(boolean bl) {
        Mounted mounted = null;
        if (bl && this.bHasTorsoAGun) {
            mounted = this.getEquipment(this.TorsoAGunNum);
        } else if (!bl && this.bHasTorsoBGun) {
            mounted = this.getEquipment(this.TorsoBGunNum);
        }
        return mounted;
    }

    public void setPilotDamageTaken(int n, int n2) {
        this.PilotDamageTaken[n] = n2;
    }

    @Override
    public PilotingRollData getBasePilotingRoll() {
        return new PilotingRollData(this.getId(), -2147483647, "Protomeks never take PSRs.");
    }

    public boolean shaded(int n, int n2) {
        switch (n) {
            case 0: 
            case 2: 
            case 3: {
                return 2 == n2;
            }
            case 1: {
                return 0 < n2;
            }
            case 5: 
            case 6: {
                return false;
            }
            case 4: {
                return 3 == n2;
            }
        }
        return false;
    }

    @Override
    public int getWalkMP(boolean bl) {
        int n = this.getOriginalWalkMP();
        int n2 = this.getCritsHit(4);
        int n3 = bl ? this.applyGravityEffectsOnMP(n) : n;
        if (n3 < n) {
            n = n3;
        }
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                --n;
                break;
            }
            case 2: {
                n /= 2;
                break;
            }
            case 3: {
                n = 0;
            }
        }
        if (this.game != null) {
            int n4 = this.game.getTemperatureDifference();
            return Math.max(n - n4, 0);
        }
        return n;
    }

    public int getCritsHit(int n) {
        int n2 = 0;
        int n3 = this.getNumberOfCriticals(n);
        for (int i = 0; i < n3; ++i) {
            CriticalSlot criticalSlot = this.getCritical(n, i);
            if (!criticalSlot.isDamaged() && !criticalSlot.isBreached()) continue;
            ++n2;
        }
        return n2;
    }

    public static int getInnerLocation(int n) {
        return 1;
    }

    @Override
    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        return pilotingRollData;
    }

    @Override
    public int getNumberOfCriticals(int n) {
        switch (n) {
            case 5: {
                return 0;
            }
            case 0: 
            case 2: 
            case 3: {
                return 2;
            }
            case 1: 
            case 4: {
                return 3;
            }
        }
        return 0;
    }

    @Override
    public void newRound(int n) {
        this.setSecondaryFacing(this.getFacing());
        super.newRound(n);
    }

    @Override
    public int getJumpMP() {
        int n = this.jumpMP;
        int n2 = this.getCritsHit(1);
        switch (n2) {
            case 0: {
                break;
            }
            case 1: {
                if (n <= 0) break;
                --n;
                break;
            }
            case 2: {
                n /= 2;
            }
        }
        if (this.applyGravityEffectsOnMP(n) > n) {
            return n;
        }
        return this.applyGravityEffectsOnMP(n);
    }

    @Override
    public int getJumpMPWithTerrain() {
        if (this.getPosition() == null) {
            return this.getJumpMP();
        }
        int n = this.game.getBoard().getHex(this.getPosition()).terrainLevel(4);
        if (n <= 0 || this.getElevation() >= 0) {
            return this.getJumpMP();
        }
        return 0;
    }

    @Override
    public int getHeatCapacityWithWater() {
        return this.getHeatCapacity();
    }

    @Override
    public int getHeatCapacity() {
        return 999;
    }

    @Override
    public String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    @Override
    public String getMovementString(int n) {
        switch (n) {
            case 0: {
                return "None";
            }
            case 1: {
                return "Walked";
            }
            case 2: {
                return "Ran";
            }
            case 3: {
                return "Jumped";
            }
        }
        return "Unknown!";
    }

    @Override
    public String getMovementAbbr(int n) {
        switch (n) {
            case 0: {
                return "N";
            }
            case 1: {
                return "W";
            }
            case 2: {
                return "R";
            }
            case 3: {
                return "J";
            }
        }
        return "?";
    }

    @Override
    public boolean canChangeSecondaryFacing() {
        return this.getCritsHit(4) <= 2;
    }

    @Override
    public int getEngineCritHeat() {
        return 0;
    }

    @Override
    public boolean isValidSecondaryFacing(int n) {
        int n2 = n - this.getFacing();
        if (this.canChangeSecondaryFacing()) {
            return n2 == 0 || n2 == 1 || n2 == -1 || n2 == -5;
        }
        return n2 == 0;
    }

    @Override
    public int clipSecondaryFacing(int n) {
        if (this.isValidSecondaryFacing(n)) {
            return n;
        }
        int n2 = (n + (6 - this.getFacing())) % 6;
        return n2 >= 3 ? (this.getFacing() + 5) % 6 : (this.getFacing() + 1) % 6;
    }

    @Override
    public boolean hasRearArmor(int n) {
        return false;
    }

    @Override
    public int getRunMPwithoutMASC(boolean bl) {
        return this.getRunMP(bl);
    }

    @Override
    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        if (mounted.isRearMounted()) {
            return 4;
        }
        switch (mounted.getLocation()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 2;
            }
            case 5: {
                return 7;
            }
        }
        return 0;
    }

    @Override
    public boolean isSecondaryArcWeapon(int n) {
        return true;
    }

    @Override
    public HitData rollHitLocation(int n, int n2) {
        return this.rollHitLocation(n, n2, -1, 0);
    }

    @Override
    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        int n5 = -1;
        if (n3 != -1 && n4 == 1 && 5 < (n5 = Compute.d6(2)) && n5 < 9) {
            return new HitData(n3, n2 == 1, true);
        }
        n5 = Compute.d6(2);
        try {
            PrintWriter printWriter = PreferenceManager.getClientPreferences().getMekHitLocLog();
            if (printWriter != null) {
                printWriter.print(n);
                printWriter.print("\t");
                printWriter.print(n2);
                printWriter.print("\t");
                printWriter.println(n5);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        switch (n5) {
            case 2: {
                return new HitData(5);
            }
            case 3: 
            case 11: {
                return new HitData(6);
            }
            case 4: {
                return new HitData(2);
            }
            case 5: 
            case 9: {
                return new HitData(4);
            }
            case 6: 
            case 7: 
            case 8: {
                return new HitData(1);
            }
            case 10: {
                return new HitData(2);
            }
            case 12: {
                return new HitData(0);
            }
        }
        return null;
    }

    @Override
    public boolean canTransferCriticals(int n) {
        return false;
    }

    @Override
    public HitData getTransferLocation(HitData hitData) {
        switch (hitData.getLocation()) {
            case 6: {
                return new HitData(-1);
            }
            case 0: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return new HitData(1, hitData.isRear());
            }
        }
        return new HitData(-2);
    }

    @Override
    public int getDependentLocation(int n) {
        return -1;
    }

    public void setInternal(int n, int n2, int n3, int n4, int n5) {
        this.initializeInternal(n, 0);
        this.initializeInternal(n2, 1);
        this.initializeInternal(n3, 2);
        this.initializeInternal(n3, 3);
        this.initializeInternal(n4, 4);
        this.initializeInternal(n5, 5);
    }

    @Override
    public void autoSetInternal() {
        int n = this.hasMainGun() ? 1 : -1;
        switch ((int)this.weight) {
            case 2: {
                this.setInternal(1, 2, 1, 2, n);
                break;
            }
            case 3: {
                this.setInternal(1, 3, 1, 2, n);
                break;
            }
            case 4: {
                this.setInternal(1, 4, 1, 3, n);
                break;
            }
            case 5: {
                this.setInternal(1, 5, 1, 3, n);
                break;
            }
            case 6: {
                this.setInternal(2, 6, 2, 4, n);
                break;
            }
            case 7: {
                this.setInternal(2, 7, 2, 4, n);
                break;
            }
            case 8: {
                this.setInternal(2, 8, 2, 5, n);
                break;
            }
            case 9: {
                this.setInternal(2, 9, 2, 5, n);
            }
        }
    }

    @Override
    public Mounted addEquipment(EquipmentType equipmentType, int n) throws LocationFullException {
        return this.addEquipment(equipmentType, n, false, -1);
    }

    @Override
    public Mounted addEquipment(EquipmentType equipmentType, int n, boolean bl) throws LocationFullException {
        Mounted mounted = new Mounted(this, equipmentType);
        this.addEquipment(mounted, n, bl, -1);
        return mounted;
    }

    public Mounted addEquipment(EquipmentType equipmentType, int n, boolean bl, int n2) throws LocationFullException {
        Mounted mounted = new Mounted(this, equipmentType);
        this.addEquipment(mounted, n, bl, n2);
        return mounted;
    }

    protected void addEquipment(Mounted mounted, int n, boolean bl, int n2) throws LocationFullException {
        if (mounted.getType() instanceof AmmoType && -1 != n2) {
            mounted.setShotsLeft(n2);
            super.addEquipment(mounted, n, bl);
            return;
        }
        if (mounted.getType() instanceof WeaponType) {
            switch (n) {
                case 0: 
                case 4: 
                case 6: {
                    throw new LocationFullException("Weapon " + mounted.getName() + " can't be mounted in " + this.getLocationAbbr(n));
                }
                case 5: {
                    if (this.bHasMainGun) {
                        throw new LocationFullException("Already has Main Gun");
                    }
                    this.bHasMainGun = true;
                    mounted.setLocation(n, bl);
                    this.equipmentList.add(mounted);
                    this.weaponList.add(mounted);
                    break;
                }
                case 3: {
                    if (this.bHasLArmGun) {
                        throw new LocationFullException("Already has LArm Gun");
                    }
                    this.bHasLArmGun = true;
                    mounted.setLocation(n, bl);
                    this.equipmentList.add(mounted);
                    this.weaponList.add(mounted);
                    break;
                }
                case 2: {
                    if (this.bHasRArmGun) {
                        throw new LocationFullException("Already has RArm Gun");
                    }
                    this.bHasRArmGun = true;
                    mounted.setLocation(n, bl);
                    this.equipmentList.add(mounted);
                    this.weaponList.add(mounted);
                    break;
                }
                case 1: {
                    if (this.bHasTorsoAGun) {
                        if (this.bHasTorsoBGun) {
                            throw new LocationFullException("Already has both torso guns");
                        }
                        this.bHasTorsoBGun = true;
                        mounted.setLocation(n, bl);
                        this.equipmentList.add(mounted);
                        this.weaponList.add(mounted);
                        this.TorsoBGunNum = this.getEquipmentNum(mounted);
                        break;
                    }
                    this.bHasTorsoAGun = true;
                    mounted.setLocation(n, bl);
                    this.equipmentList.add(mounted);
                    this.weaponList.add(mounted);
                    this.TorsoAGunNum = this.getEquipmentNum(mounted);
                }
            }
        } else {
            super.addEquipment(mounted, n, bl);
        }
    }

    @Override
    public int calculateBattleValue() {
        Object object;
        Object object2;
        double d = 0.0;
        double d2 = 0.0;
        d += (double)this.getTotalArmor() * 2.5;
        d += (double)this.getTotalInternal() * 1.5;
        double d3 = 0.0;
        for (Mounted object32 : this.getEquipment()) {
            EquipmentType d4 = object32.getType();
            if (object32.isDestroyed() || !(d4 instanceof WeaponType && d4.hasFlag(0x1000000L) || d4 instanceof AmmoType && ((AmmoType)d4).getAmmoType() == 14) && (!(d4 instanceof MiscType) || !d4.hasFlag(1024L) && !d4.hasFlag(8192L))) continue;
            d3 += d4.getBV(this);
        }
        d += d3;
        int n = Compute.getTargetMovementModifier(this.getOriginalRunMP(), false, false).getValue();
        if (n > 7) {
            n = 7;
        }
        double[] dArray = new double[]{1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7, 1.8};
        d *= dArray[n];
        double d4 = 0.0;
        boolean bl = this.hasTargComp();
        HashMap<Object, Double> hashMap = new HashMap<Object, Double>();
        for (Mounted mounted : this.getWeaponList()) {
            WeaponType d7 = (WeaponType)mounted.getType();
            double d5 = d7.getBV(this);
            if (mounted.isDestroyed() || d7.hasFlag(0x1000000L)) continue;
            if (mounted.getLinkedBy() != null && ((Mounted)(object2 = mounted.getLinkedBy())).getType() instanceof MiscType && ((Mounted)object2).getType().hasFlag(512L)) {
                d5 *= 1.2;
            }
            if (d7.hasFlag(1L) && bl) {
                d5 *= 1.25;
            }
            d4 += d5;
            if (d7.hasFlag(262144L) || d7.hasFlag(32768L) || d7.hasFlag(2048L) || d7.getAmmoType() == -1) continue;
            object2 = d7.getAmmoType() + ":" + d7.getRackSize();
            if (!hashMap.containsKey(object2)) {
                hashMap.put(object2, d7.getBV(this));
                continue;
            }
            hashMap.put(object2, d7.getBV(this) + (Double)hashMap.get(object2));
        }
        double d6 = 0.0;
        double d7 = 0.0;
        HashMap<String, Double> hashMap2 = new HashMap<String, Double>();
        object2 = new ArrayList();
        for (Mounted mounted : this.getAmmo()) {
            String string;
            AmmoType ammoType = (AmmoType)mounted.getType();
            if (mounted.getShotsLeft() == 0 || ammoType.getAmmoType() == 14 || mounted.getLocation() == -1) continue;
            if (ammoType.getMunitionType() == 16384L) {
                Player player = this.getOwner();
                if (player.hasTAG()) {
                    d7 += ammoType.getBV(this);
                } else if (player.getTeam() != 0 && this.game != null) {
                    object = this.game.getTeams();
                    while (object.hasMoreElements()) {
                        Team team = (Team)object.nextElement();
                        if (team.getId() != player.getTeam()) continue;
                        if (!team.hasTAG(this.game)) break;
                        d7 += ammoType.getBV(this);
                        break;
                    }
                }
            }
            if (!((ArrayList)object2).contains(string = ammoType.getAmmoType() + ":" + ammoType.getRackSize())) {
                ((ArrayList)object2).add(string);
            }
            if (!hashMap2.containsKey(string)) {
                hashMap2.put(string, ammoType.getBV(this));
                continue;
            }
            hashMap2.put(string, ammoType.getBV(this) + (Double)hashMap2.get(string));
        }
        Iterator<Mounted> d8 = ((ArrayList)object2).iterator();
        while (d8.hasNext()) {
            String string = (String)((Object)d8.next());
            if ((Double)hashMap2.get(string) > (Double)hashMap.get(string)) {
                d6 += ((Double)hashMap.get(string)).doubleValue();
                continue;
            }
            d6 += ((Double)hashMap2.get(string)).doubleValue();
        }
        d4 += d6;
        double d9 = 0.0;
        for (Mounted mounted : this.getMisc()) {
            object = (MiscType)mounted.getType();
            if (mounted.isDestroyed() || ((EquipmentType)object).hasFlag(1024L) || ((EquipmentType)object).hasFlag(0x2000000L) || ((EquipmentType)object).hasFlag(8192L) || ((EquipmentType)object).hasFlag(0x800000000L) || ((EquipmentType)object).hasFlag(2048L)) continue;
            d9 += ((MiscType)object).getBV(this);
        }
        double d10 = Math.pow(1.0 + ((double)this.getOriginalRunMP() + (double)Math.round((double)this.jumpMP / 2.0) - 5.0) / 10.0, 1.2);
        d10 = (double)Math.round(d10 * 100.0) / 100.0;
        d2 = (d4 += d9) * d10;
        double d11 = 0.0;
        int n2 = (int)Math.round(d + d2 + (d11 += d7));
        double d12 = this.crew.getBVSkillMultiplier();
        int n3 = (int)Math.round((double)n2 * d12);
        return n3;
    }

    @Override
    public Vector<Report> victoryReport() {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(7025);
        report.type = 0;
        report.addDesc(this);
        vector.addElement(report);
        report = new Report(7030);
        report.type = 0;
        report.newlines = 0;
        vector.addElement(report);
        vector.addAll(this.crew.getDescVector(true));
        report = new Report(7070, 0);
        report.add(this.getKillNumber());
        vector.addElement(report);
        if (this.isDestroyed()) {
            Entity entity = this.game.getEntity(this.killerId);
            if (entity == null) {
                entity = this.game.getOutOfGameEntity(this.killerId);
            }
            if (entity != null) {
                report = new Report(7072, 0);
                report.addDesc(entity);
            } else {
                report = new Report(7073, 0);
            }
            vector.addElement(report);
        }
        report.newlines = 2;
        return vector;
    }

    @Override
    public int getMaxElevationChange() {
        return 1;
    }

    @Override
    public int getArmor(int n, boolean bl) {
        if (n == 6) {
            return -1;
        }
        return super.getArmor(n, bl);
    }

    @Override
    public int getInternal(int n) {
        if (n == 6) {
            return -1;
        }
        return super.getInternal(n);
    }

    @Override
    protected String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    @Override
    public String getLocationAbbr(int n) {
        if (n == 6) {
            return "a near miss";
        }
        return super.getLocationAbbr(n);
    }

    public boolean hasMainGun() {
        return !this.m_bHasNoMainGun;
    }

    public void setHasMainGun(boolean bl) {
        this.m_bHasNoMainGun = !bl;
    }

    @Override
    public int locations() {
        if (this.m_bHasNoMainGun) {
            return 5;
        }
        return 6;
    }

    @Override
    public void setCrew(Pilot pilot) {
        super.setCrew(pilot);
        this.getCrew().setPiloting(5);
    }

    @Override
    public boolean canCharge() {
        return false;
    }

    @Override
    public boolean canDFA() {
        return false;
    }

    @Override
    public double getCost() {
        double d = 0.0;
        d += 500000.0;
        d += 75000.0;
        d += (double)(2000.0f * this.weight);
        d += (double)(2000.0f * this.weight);
        d += (double)(400.0f * this.weight);
        d += (double)(360.0f * this.weight);
        d += (double)(540.0f * this.weight);
        if (this.getEngine() != null) {
            d += (double)(5000.0f * this.weight * (float)this.getEngine().getRating() / 75.0f);
        }
        d += (double)(this.weight * (float)this.getJumpMP() * (float)this.getJumpMP() * 200.0f);
        d += (double)(this.getTotalArmor() * 625);
        return d *= 1.0 + (double)this.weight / 100.0;
    }

    @Override
    public boolean doomedInVacuum() {
        return false;
    }

    @Override
    public boolean hasActiveEiCockpit() {
        return super.hasActiveEiCockpit() && this.getCritsHit(0) == 0;
    }

    @Override
    public boolean canAssaultDrop() {
        return true;
    }

    @Override
    public boolean isNuclearHardened() {
        return true;
    }
}

