/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.PrintWriter;
import megamek.common.Compute;
import megamek.common.CriticalSlot;
import megamek.common.HitData;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.PilotingRollData;
import megamek.common.preference.PreferenceManager;

public class QuadMech
extends Mech {
    public static final String[] LOCATION_NAMES = new String[]{"Head", "Center Torso", "Right Torso", "Left Torso", "Front Right Leg", "Front Left Leg", "Rear Right Leg", "Rear Left Leg"};
    public static final String[] LOCATION_ABBRS = new String[]{"HD", "CT", "RT", "LT", "FRL", "FLL", "RRL", "RLL"};
    private static final int[] NUM_OF_SLOTS = new int[]{6, 12, 12, 12, 6, 6, 6, 6};

    public QuadMech(String string, String string2) {
        this(QuadMech.getGyroTypeForString(string), QuadMech.getCockpitTypeForString(string2));
    }

    public QuadMech() {
        this(0, 0);
    }

    public QuadMech(int n, int n2) {
        super(n, n2);
        this.movementMode = 2;
        this.setCritical(4, 0, new CriticalSlot(0, 11));
        this.setCritical(4, 1, new CriticalSlot(0, 12));
        this.setCritical(4, 2, new CriticalSlot(0, 13));
        this.setCritical(4, 3, new CriticalSlot(0, 14));
        this.setCritical(5, 0, new CriticalSlot(0, 11));
        this.setCritical(5, 1, new CriticalSlot(0, 12));
        this.setCritical(5, 2, new CriticalSlot(0, 13));
        this.setCritical(5, 3, new CriticalSlot(0, 14));
    }

    public boolean cannotStandUp() {
        int n = 0;
        if (this.isLocationBad(5)) {
            ++n;
        }
        if (this.isLocationBad(4)) {
            ++n;
        }
        if (this.isLocationBad(7)) {
            ++n;
        }
        if (this.isLocationBad(6)) {
            ++n;
        }
        return n >= 3;
    }

    public int getWalkMP() {
        return this.getWalkMP(true);
    }

    public int getWalkMP(boolean bl) {
        int n;
        int n2 = this.getOriginalWalkMP();
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        for (n = 0; n < this.locations(); ++n) {
            if (!this.locationIsLeg(n)) continue;
            if (!this.isLocationBad(n)) {
                if (this.legHasHipCrit(n)) {
                    ++n4;
                    if (this.game == null || !this.game.getOptions().booleanOption("maxtech_leg_damage")) continue;
                }
                n5 += this.countLegActuatorCrits(n);
                continue;
            }
            ++n3;
        }
        if (n3 > 0) {
            n2 = n3 == 1 ? --n2 : (n3 == 2 ? 1 : 0);
        }
        if (n2 > 0) {
            if (n4 > 0) {
                if (this.game != null && this.game.getOptions().booleanOption("maxtech_leg_damage")) {
                    n2 -= 2 * n4;
                } else {
                    for (n = 0; n < n4; ++n) {
                        n2 = (int)Math.ceil((double)n2 / 2.0);
                    }
                }
            }
            n2 -= n5;
        }
        n2 -= this.heat / 5;
        if (this.heat >= 9 && this.hasTSM()) {
            n2 += 2;
        }
        if (bl) {
            n2 = this.applyGravityEffectsOnMP(n2);
        }
        n2 = Math.max(0, n2);
        return n2;
    }

    public int getRunMP(boolean bl) {
        if (this.countBadLegs() <= 1) {
            return super.getRunMP(bl);
        }
        return this.getWalkMP(bl);
    }

    public int getRunMPwithoutMASC(boolean bl) {
        if (this.countBadLegs() <= 1) {
            return super.getRunMPwithoutMASC(bl);
        }
        return this.getWalkMP(bl);
    }

    public boolean canChangeSecondaryFacing() {
        return false;
    }

    public boolean locationIsLeg(int n) {
        return n == 6 || n == 7 || n == 4 || n == 5;
    }

    public int getWeaponArc(int n) {
        Mounted mounted = this.getEquipment(n);
        if (mounted.isRearMounted()) {
            return 4;
        }
        switch (mounted.getLocation()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return 1;
            }
        }
        return 0;
    }

    public void setInternal(int n, int n2, int n3, int n4, int n5) {
        this.initializeInternal(n, 0);
        this.initializeInternal(n2, 1);
        this.initializeInternal(n3, 2);
        this.initializeInternal(n3, 3);
        this.initializeInternal(n5, 4);
        this.initializeInternal(n5, 5);
        this.initializeInternal(n5, 6);
        this.initializeInternal(n5, 7);
    }

    public boolean needsRollToStand() {
        return this.countBadLegs() != 0;
    }

    public PilotingRollData addEntityBonuses(PilotingRollData pilotingRollData) {
        int[] nArray = new int[4];
        int n = 0;
        nArray = new int[]{6, 7, 4, 5};
        n = this.countBadLegs();
        if (n == 0) {
            pilotingRollData.addModifier(-2, "Quad bonus");
        }
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            if (this.isLocationBad(n2)) {
                if (n <= 1) continue;
                pilotingRollData.addModifier(5, this.getLocationName(n2) + " destroyed");
                continue;
            }
            if (this.getBadCriticals(0, 11, n2) > 0) {
                pilotingRollData.addModifier(2, this.getLocationName(n2) + " Hip Actuator destroyed");
                if (!this.game.getOptions().booleanOption("maxtech_leg_damage")) continue;
            }
            if (this.getBadCriticals(0, 12, n2) > 0) {
                pilotingRollData.addModifier(1, this.getLocationName(n2) + " Upper Leg Actuator destroyed");
            }
            if (this.getBadCriticals(0, 13, n2) > 0) {
                pilotingRollData.addModifier(1, this.getLocationName(n2) + " Lower Leg Actuator destroyed");
            }
            if (this.getBadCriticals(0, 14, n2) <= 0) continue;
            pilotingRollData.addModifier(1, this.getLocationName(n2) + " Foot Actuator destroyed");
        }
        return super.addEntityBonuses(pilotingRollData);
    }

    protected int[] getNoOfSlots() {
        return NUM_OF_SLOTS;
    }

    protected String[] getLocationNames() {
        return LOCATION_NAMES;
    }

    protected String[] getLocationAbbrs() {
        return LOCATION_ABBRS;
    }

    public static int restrictScore(int n) {
        switch (n) {
            case 2: 
            case 3: {
                return 1;
            }
            case 1: {
                return 2;
            }
        }
        return 3;
    }

    protected double getArmActuatorCost() {
        return 0.0;
    }

    protected double getLegActuatorCost() {
        return this.weight * 150.0f * 4.0f + this.weight * 80.0f * 4.0f + this.weight * 120.0f * 4.0f;
    }

    public HitData rollHitLocation(int n, int n2, int n3, int n4) {
        Object object;
        int n5 = -1;
        if (n3 != -1 && n4 == 2) {
            return new HitData(n3, n2 == 1, true);
        }
        if (n3 != -1 && n4 == 1 && 5 < (n5 = Compute.d6(2)) && n5 < 9) {
            return new HitData(n3, n2 == 1, true);
        }
        if (this.game.getOptions().booleanOption("quad_hit_location") && (n == 0 || n == 6)) {
            n5 = Compute.d6(2);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (n2 == 0) {
                switch (n5) {
                    case 2: {
                        return this.tac(n, n2, 1, false);
                    }
                    case 3: {
                        return new HitData(6);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        return new HitData(2);
                    }
                    case 7: {
                        return new HitData(1);
                    }
                    case 8: {
                        return new HitData(3);
                    }
                    case 9: 
                    case 10: {
                        return new HitData(5);
                    }
                    case 11: {
                        return new HitData(7);
                    }
                    case 12: {
                        return new HitData(0);
                    }
                }
            } else if (n2 == 1) {
                switch (n5) {
                    case 2: {
                        return this.tac(n, n2, 1, true);
                    }
                    case 3: {
                        return new HitData(4, true);
                    }
                    case 4: 
                    case 5: {
                        return new HitData(6, true);
                    }
                    case 6: {
                        return new HitData(2, true);
                    }
                    case 7: {
                        return new HitData(1, true);
                    }
                    case 8: {
                        return new HitData(3, true);
                    }
                    case 9: 
                    case 10: {
                        return new HitData(7, true);
                    }
                    case 11: {
                        return new HitData(5, true);
                    }
                    case 12: {
                        return new HitData(0, true);
                    }
                }
            }
        }
        if (n == 1) {
            n5 = Compute.d6();
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            if (n2 == 0) {
                switch (n5) {
                    case 1: {
                        return new HitData(5);
                    }
                    case 2: {
                        return new HitData(3);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: {
                        return new HitData(2);
                    }
                    case 5: {
                        return new HitData(4);
                    }
                    case 6: {
                        return new HitData(0);
                    }
                }
            } else if (n2 == 1) {
                switch (n5) {
                    case 1: {
                        return new HitData(7, true);
                    }
                    case 2: {
                        return new HitData(3, true);
                    }
                    case 3: {
                        return new HitData(1, true);
                    }
                    case 4: {
                        return new HitData(2, true);
                    }
                    case 5: {
                        return new HitData(6, true);
                    }
                    case 6: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0, true));
                            return object;
                        }
                        return new HitData(0, true);
                    }
                }
            } else if (n2 == 2) {
                switch (n5) {
                    case 1: 
                    case 2: {
                        return new HitData(3);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: {
                        return new HitData(5);
                    }
                    case 5: {
                        return new HitData(7);
                    }
                    case 6: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0, true));
                            return object;
                        }
                        return new HitData(0);
                    }
                }
            } else if (n2 == 3) {
                switch (n5) {
                    case 1: 
                    case 2: {
                        return new HitData(2);
                    }
                    case 3: {
                        return new HitData(1);
                    }
                    case 4: {
                        return new HitData(4);
                    }
                    case 5: {
                        return new HitData(6);
                    }
                    case 6: {
                        if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                            this.crew.decreaseEdge();
                            object = this.rollHitLocation(n, n2, n3, n4);
                            ((HitData)object).setUndoneLocation(new HitData(0, true));
                            return object;
                        }
                        return new HitData(0);
                    }
                }
            }
        } else if (n == 2) {
            boolean bl;
            n5 = Compute.d6(1);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            boolean bl2 = bl = n5 <= 3;
            if (n2 == 0) {
                if (bl) {
                    return new HitData(5);
                }
                return new HitData(4);
            }
            if (n2 == 1) {
                if (bl) {
                    return new HitData(7);
                }
                return new HitData(6);
            }
            if (n2 == 2) {
                if (bl) {
                    return new HitData(7);
                }
                return new HitData(5);
            }
            if (n2 == 3) {
                if (bl) {
                    return new HitData(4);
                }
                return new HitData(6);
            }
        } else if (n == 3) {
            n5 = Compute.d6(2);
            try {
                object = PreferenceManager.getClientPreferences().getMekHitLocLog();
                if (object != null) {
                    ((PrintWriter)object).print(n);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).print(n2);
                    ((PrintWriter)object).print("\t");
                    ((PrintWriter)object).println(n5);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            switch (n5) {
                case 2: {
                    if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                        this.crew.decreaseEdge();
                        object = this.rollHitLocation(n, n2, n3, n4);
                        ((HitData)object).setUndoneLocation(new HitData(0, false, 1));
                        return object;
                    }
                    return new HitData(0, false, 1);
                }
                case 3: {
                    return new HitData(2, false, 1);
                }
                case 4: {
                    return new HitData(1, true, 1);
                }
                case 5: {
                    return new HitData(2, true, 1);
                }
                case 6: {
                    return new HitData(2, false, 1);
                }
                case 7: {
                    return new HitData(1, false, 1);
                }
                case 8: {
                    return new HitData(3, false, 1);
                }
                case 9: {
                    return new HitData(3, true, 1);
                }
                case 10: {
                    return new HitData(1, true, 1);
                }
                case 11: {
                    return new HitData(3, false, 1);
                }
                case 12: {
                    if (this.crew.hasEdgeRemaining() && this.crew.getOptions().booleanOption("edge_when_headhit")) {
                        this.crew.decreaseEdge();
                        object = this.rollHitLocation(n, n2, n3, n4);
                        ((HitData)object).setUndoneLocation(new HitData(0, false, 1));
                        return object;
                    }
                    return new HitData(0, false, 1);
                }
            }
        }
        return super.rollHitLocation(n, n2, n3, n4);
    }

    public boolean removePartialCoverHits(int n, int n2, int n3) {
        if ((n2 & 0xC) == 12 && (n == 1 || n == 0)) {
            return true;
        }
        if (n3 == 0) {
            if ((n2 & 2) != 0 && (n == 5 || n == 7)) {
                return true;
            }
            if ((n2 & 1) != 0 && (n == 4 || n == 6)) {
                return true;
            }
            if ((n2 & 8) != 0 && n == 3) {
                return true;
            }
            if ((n2 & 4) != 0 && n == 2) {
                return true;
            }
        } else {
            if ((n2 & 1) != 0 && (n == 5 || n == 7)) {
                return true;
            }
            if ((n2 & 2) != 0 && (n == 4 || n == 6)) {
                return true;
            }
            if ((n2 & 4) != 0 && n == 3) {
                return true;
            }
            if ((n2 & 8) != 0 && n == 2) {
                return true;
            }
        }
        return false;
    }

    public boolean canGoHullDown() {
        return this.game.getOptions().booleanOption("hull_down");
    }
}

