/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import java.io.File;
import java.text.NumberFormat;
import java.util.Enumeration;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import megamek.common.EquipmentMode;
import megamek.common.EquipmentType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WeaponType
extends EquipmentType {
    public static final int DAMAGE_MISSILE = -2;
    public static final int DAMAGE_VARIABLE = -3;
    public static final int DAMAGE_SPECIAL = -4;
    public static final int DAMAGE_ARTILLERY = -5;
    public static final int WEAPON_NA = Integer.MIN_VALUE;
    public static final long F_DIRECT_FIRE = 1L;
    public static final long F_FLAMER = 2L;
    public static final long F_LASER = 4L;
    public static final long F_PPC = 8L;
    public static final long F_AUTO_TARGET = 16L;
    public static final long F_NO_FIRES = 32L;
    public static final long F_PROTOMECH = 64L;
    public static final long F_SOLO_ATTACK = 128L;
    public static final long F_SPLITABLE = 256L;
    public static final long F_MG = 512L;
    public static final long F_INFERNO = 1024L;
    public static final long F_INFANTRY = 2048L;
    public static final long F_BATTLEARMOR = 4096L;
    public static final long F_DOUBLE_HITS = 8192L;
    public static final long F_MISSILE_HITS = 16384L;
    public static final long F_ONESHOT = 32768L;
    public static final long F_ARTILLERY = 65536L;
    public static final long F_BALLISTIC = 131072L;
    public static final long F_ENERGY = 262144L;
    public static final long F_MISSILE = 524288L;
    public static final long F_PLASMA = 0x100000L;
    public static final long F_INCENDIARY_NEEDLES = 0x200000L;
    public static final long F_PROTOTYPE = 0x400000L;
    public static final long F_HEATASDICE = 0x800000L;
    public static final long F_AMS = 0x1000000L;
    public static final long F_BOOST_SWARM = 0x2000000L;
    public static final long F_INFANTRY_ONLY = 0x4000000L;
    public static final long F_TAG = 0x8000000L;
    public static final long F_C3M = 0x10000000L;
    public static final long F_PLASMA_MFUK = 0x20000000L;
    public static final long F_EXTINGUISHER = 0x40000000L;
    public static final long F_SINGLE_TARGET = 0x80000000L;
    public static final long F_PULSE = 0x100000000L;
    public static final long F_BURST_FIRE = 0x200000000L;
    public static final long F_MGA = 0x400000000L;
    public static final long F_NO_AIM = 0x800000000L;
    protected int heat;
    protected int damage;
    private int rackSize;
    private int ammoType;
    private int minimumRange;
    private int shortRange;
    private int mediumRange;
    private int longRange;
    private int extremeRange;
    private int waterShortRange;
    private int waterMediumRange;
    private int waterLongRange;
    private int waterExtremeRange;

    public void setDamage(int n) {
        this.damage = n;
    }

    public void setName(String string) {
        this.name = string;
        this.setInternalName(string);
    }

    public void setMinimumRange(int n) {
        this.minimumRange = n;
    }

    public void setRanges(int n, int n2, int n3, int n4) {
        this.shortRange = n;
        this.mediumRange = n2;
        this.longRange = n3;
        this.extremeRange = n4;
    }

    public void setWaterRanges(int n, int n2, int n3, int n4) {
        this.waterShortRange = n;
        this.waterMediumRange = n2;
        this.waterLongRange = n3;
        this.waterExtremeRange = n4;
    }

    public void setAmmoType(int n) {
        this.ammoType = n;
    }

    public void setRackSize(int n) {
        this.rackSize = n;
    }

    public int getHeat() {
        return this.heat;
    }

    public int getFireTN() {
        if (this.hasFlag(32L)) {
            return Integer.MAX_VALUE;
        }
        if (this.hasFlag(2L)) {
            return 4;
        }
        if (this.hasFlag(0x100000L)) {
            return 5;
        }
        if (this.hasFlag(0x20000000L)) {
            return 5;
        }
        if (this.hasFlag(0x200000L)) {
            return 6;
        }
        if (this.hasFlag(8L) || this.hasFlag(4L)) {
            return 7;
        }
        return 9;
    }

    public int getDamage() {
        return this.damage;
    }

    public int getRackSize() {
        return this.rackSize;
    }

    public int getAmmoType() {
        return this.ammoType;
    }

    public int[] getRanges() {
        return new int[]{this.minimumRange, this.shortRange, this.mediumRange, this.longRange, this.extremeRange};
    }

    public int getMinimumRange() {
        return this.minimumRange;
    }

    public int getShortRange() {
        return this.shortRange;
    }

    public int getMediumRange() {
        return this.mediumRange;
    }

    public int getLongRange() {
        return this.longRange;
    }

    public int getExtremeRange() {
        return this.extremeRange;
    }

    public int[] getWRanges() {
        return new int[]{this.minimumRange, this.waterShortRange, this.waterMediumRange, this.waterLongRange, this.waterExtremeRange};
    }

    public int getWShortRange() {
        return this.waterShortRange;
    }

    public int getWMediumRange() {
        return this.waterMediumRange;
    }

    public int getWLongRange() {
        return this.waterLongRange;
    }

    public int getWExtremeRange() {
        return this.waterExtremeRange;
    }

    public static void initializeTypes() {
        EquipmentType.addType(WeaponType.createFlamer());
        EquipmentType.addType(WeaponType.createVehicleFlamer());
        EquipmentType.addType(WeaponType.createSmallLaser());
        EquipmentType.addType(WeaponType.createMediumLaser());
        EquipmentType.addType(WeaponType.createLargeLaser());
        EquipmentType.addType(WeaponType.createPPC());
        EquipmentType.addType(WeaponType.createAC2());
        EquipmentType.addType(WeaponType.createAC5());
        EquipmentType.addType(WeaponType.createAC10());
        EquipmentType.addType(WeaponType.createAC20());
        EquipmentType.addType(WeaponType.createMG());
        EquipmentType.addType(WeaponType.createLRM5());
        EquipmentType.addType(WeaponType.createLRM10());
        EquipmentType.addType(WeaponType.createLRM15());
        EquipmentType.addType(WeaponType.createLRM20());
        EquipmentType.addType(WeaponType.createSRM2());
        EquipmentType.addType(WeaponType.createSRM4());
        EquipmentType.addType(WeaponType.createSRM6());
        EquipmentType.addType(WeaponType.createLRT5());
        EquipmentType.addType(WeaponType.createLRT10());
        EquipmentType.addType(WeaponType.createLRT15());
        EquipmentType.addType(WeaponType.createLRT20());
        EquipmentType.addType(WeaponType.createSRT2());
        EquipmentType.addType(WeaponType.createSRT4());
        EquipmentType.addType(WeaponType.createSRT6());
        EquipmentType.addType(WeaponType.createInfRifle());
        EquipmentType.addType(WeaponType.createInfMG());
        EquipmentType.addType(WeaponType.createInfSRM());
        EquipmentType.addType(WeaponType.createInfLRM());
        EquipmentType.addType(WeaponType.createInfLaser());
        EquipmentType.addType(WeaponType.createInfFlamer());
        EquipmentType.addType(WeaponType.createInfInfernoSRM());
        EquipmentType.addType(WeaponType.createISERPPC());
        EquipmentType.addType(WeaponType.createISERLargeLaser());
        EquipmentType.addType(WeaponType.createISERMediumLaser());
        EquipmentType.addType(WeaponType.createISERSmallLaser());
        EquipmentType.addType(WeaponType.createISLargePulseLaser());
        EquipmentType.addType(WeaponType.createISMediumPulseLaser());
        EquipmentType.addType(WeaponType.createISSmallPulseLaser());
        EquipmentType.addType(WeaponType.createISLBXAC2());
        EquipmentType.addType(WeaponType.createISLBXAC5());
        EquipmentType.addType(WeaponType.createISLBXAC10());
        EquipmentType.addType(WeaponType.createISLBXAC20());
        EquipmentType.addType(WeaponType.createISGaussRifle());
        EquipmentType.addType(WeaponType.createISLightGaussRifle());
        EquipmentType.addType(WeaponType.createISHeavyGaussRifle());
        EquipmentType.addType(WeaponType.createISUltraAC2());
        EquipmentType.addType(WeaponType.createISUltraAC5());
        EquipmentType.addType(WeaponType.createISUltraAC10());
        EquipmentType.addType(WeaponType.createISUltraAC20());
        EquipmentType.addType(WeaponType.createISRAC2());
        EquipmentType.addType(WeaponType.createISRAC5());
        EquipmentType.addType(WeaponType.createISStreakSRM2());
        EquipmentType.addType(WeaponType.createISSRM2OS());
        EquipmentType.addType(WeaponType.createISSRT2OS());
        EquipmentType.addType(WeaponType.createISStreakSRM2OS());
        EquipmentType.addType(WeaponType.createISStreakSRM4());
        EquipmentType.addType(WeaponType.createISSRM4OS());
        EquipmentType.addType(WeaponType.createISSRT4OS());
        EquipmentType.addType(WeaponType.createISStreakSRM4OS());
        EquipmentType.addType(WeaponType.createISStreakSRM6());
        EquipmentType.addType(WeaponType.createISSRM6OS());
        EquipmentType.addType(WeaponType.createISSRT6OS());
        EquipmentType.addType(WeaponType.createISStreakSRM6OS());
        EquipmentType.addType(WeaponType.createISMRM10());
        EquipmentType.addType(WeaponType.createISMRM20());
        EquipmentType.addType(WeaponType.createISMRM30());
        EquipmentType.addType(WeaponType.createISMRM40());
        EquipmentType.addType(WeaponType.createISMRM10OS());
        EquipmentType.addType(WeaponType.createISMRM20OS());
        EquipmentType.addType(WeaponType.createISMRM30OS());
        EquipmentType.addType(WeaponType.createISMRM40OS());
        EquipmentType.addType(WeaponType.createISLRM5OS());
        EquipmentType.addType(WeaponType.createISLRM10OS());
        EquipmentType.addType(WeaponType.createISLRM15OS());
        EquipmentType.addType(WeaponType.createISLRM20OS());
        EquipmentType.addType(WeaponType.createISLRT5OS());
        EquipmentType.addType(WeaponType.createISLRT10OS());
        EquipmentType.addType(WeaponType.createISLRT15OS());
        EquipmentType.addType(WeaponType.createISLRT20OS());
        EquipmentType.addType(WeaponType.createISAMS());
        EquipmentType.addType(WeaponType.createISNarc());
        EquipmentType.addType(WeaponType.createISNarcOS());
        EquipmentType.addType(WeaponType.createISImprovedNarc());
        EquipmentType.addType(WeaponType.createISImprovedNarcOS());
        EquipmentType.addType(WeaponType.createISRL10());
        EquipmentType.addType(WeaponType.createISRL15());
        EquipmentType.addType(WeaponType.createISRL20());
        EquipmentType.addType(WeaponType.createISArrowIVSystem());
        EquipmentType.addType(WeaponType.createISLongTom());
        EquipmentType.addType(WeaponType.createISSniper());
        EquipmentType.addType(WeaponType.createISThumper());
        EquipmentType.addType(WeaponType.createISTAG());
        EquipmentType.addType(WeaponType.createISLightTAG());
        EquipmentType.addType(WeaponType.createCLTAG());
        EquipmentType.addType(WeaponType.createCLLightTAG());
        EquipmentType.addType(WeaponType.createISMML3());
        EquipmentType.addType(WeaponType.createISMML5());
        EquipmentType.addType(WeaponType.createISMML7());
        EquipmentType.addType(WeaponType.createISMML9());
        EquipmentType.addType(WeaponType.createISPlasmaRifle());
        EquipmentType.addType(WeaponType.createISLargeXPulseLaser());
        EquipmentType.addType(WeaponType.createISMediumXPulseLaser());
        EquipmentType.addType(WeaponType.createISSmallXPulseLaser());
        EquipmentType.addType(WeaponType.createISLaserAMS());
        EquipmentType.addType(WeaponType.createISLaserAMSTHB());
        EquipmentType.addType(WeaponType.createISGaussRiflePrototype());
        EquipmentType.addType(WeaponType.createISLBXAC10Prototype());
        EquipmentType.addType(WeaponType.createISUltraAC5Prototype());
        EquipmentType.addType(WeaponType.createISERLargeLaserPrototype());
        EquipmentType.addType(WeaponType.createISMediumPulseLaserPrototype());
        EquipmentType.addType(WeaponType.createISTHBLBXAC2());
        EquipmentType.addType(WeaponType.createISTHBLBXAC5());
        EquipmentType.addType(WeaponType.createISTHBLBXAC20());
        EquipmentType.addType(WeaponType.createISTHBUltraAC2());
        EquipmentType.addType(WeaponType.createISTHBUltraAC10());
        EquipmentType.addType(WeaponType.createISTHBUltraAC20());
        EquipmentType.addType(WeaponType.createISLAC2());
        EquipmentType.addType(WeaponType.createISLAC5());
        EquipmentType.addType(WeaponType.createISHeavyFlamer());
        EquipmentType.addType(WeaponType.createISExtendedLRM5());
        EquipmentType.addType(WeaponType.createISExtendedLRM10());
        EquipmentType.addType(WeaponType.createISExtendedLRM15());
        EquipmentType.addType(WeaponType.createISExtendedLRM20());
        EquipmentType.addType(WeaponType.createISThunderbolt5());
        EquipmentType.addType(WeaponType.createISThunderbolt10());
        EquipmentType.addType(WeaponType.createISThunderbolt15());
        EquipmentType.addType(WeaponType.createISThunderbolt20());
        EquipmentType.addType(WeaponType.createISHERPPC());
        EquipmentType.addType(WeaponType.createISSNPPC());
        EquipmentType.addType(WeaponType.createISRailGun());
        EquipmentType.addType(WeaponType.createISMagshotGR());
        EquipmentType.addType(WeaponType.createFireExtinguisher());
        EquipmentType.addType(WeaponType.createISSBGaussRifle());
        EquipmentType.addType(WeaponType.createISLightPPC());
        EquipmentType.addType(WeaponType.createISHeavyPPC());
        EquipmentType.addType(WeaponType.createISRAC10());
        EquipmentType.addType(WeaponType.createISRAC20());
        EquipmentType.addType(WeaponType.createISLAC10());
        EquipmentType.addType(WeaponType.createISLAC20());
        EquipmentType.addType(WeaponType.createISStreakMRM10());
        EquipmentType.addType(WeaponType.createISStreakMRM20());
        EquipmentType.addType(WeaponType.createISStreakMRM30());
        EquipmentType.addType(WeaponType.createISStreakMRM40());
        EquipmentType.addType(WeaponType.createISHawkSRM2());
        EquipmentType.addType(WeaponType.createISHawkSRM4());
        EquipmentType.addType(WeaponType.createISHawkSRM6());
        EquipmentType.addType(WeaponType.createISPXLRM5());
        EquipmentType.addType(WeaponType.createISPXLRM10());
        EquipmentType.addType(WeaponType.createISPXLRM15());
        EquipmentType.addType(WeaponType.createISPXLRM20());
        EquipmentType.addType(WeaponType.createISMPod());
        EquipmentType.addType(WeaponType.createISLightMG());
        EquipmentType.addType(WeaponType.createISHeavyMG());
        EquipmentType.addType(WeaponType.createISMGA());
        EquipmentType.addType(WeaponType.createISLMGA());
        EquipmentType.addType(WeaponType.createISHMGA());
        EquipmentType.addType(WeaponType.createCLERPPC());
        EquipmentType.addType(WeaponType.createCLERLargeLaser());
        EquipmentType.addType(WeaponType.createCLERMediumLaser());
        EquipmentType.addType(WeaponType.createCLERSmallLaser());
        EquipmentType.addType(WeaponType.createCLERMicroLaser());
        EquipmentType.addType(WeaponType.createCLFlamer());
        EquipmentType.addType(WeaponType.createCLVehicleFlamer());
        EquipmentType.addType(WeaponType.createCLHeavyLargeLaser());
        EquipmentType.addType(WeaponType.createCLHeavyMediumLaser());
        EquipmentType.addType(WeaponType.createCLHeavySmallLaser());
        EquipmentType.addType(WeaponType.createCLLargePulseLaser());
        EquipmentType.addType(WeaponType.createCLMediumPulseLaser());
        EquipmentType.addType(WeaponType.createCLSmallPulseLaser());
        EquipmentType.addType(WeaponType.createCLMicroPulseLaser());
        EquipmentType.addType(WeaponType.createCLLBXAC2());
        EquipmentType.addType(WeaponType.createCLLBXAC5());
        EquipmentType.addType(WeaponType.createCLLBXAC10());
        EquipmentType.addType(WeaponType.createCLLBXAC20());
        EquipmentType.addType(WeaponType.createCLMG());
        EquipmentType.addType(WeaponType.createCLMGA());
        EquipmentType.addType(WeaponType.createCLLightMG());
        EquipmentType.addType(WeaponType.createCLLMGA());
        EquipmentType.addType(WeaponType.createCLHeavyMG());
        EquipmentType.addType(WeaponType.createCLHMGA());
        EquipmentType.addType(WeaponType.createCLLRM5());
        EquipmentType.addType(WeaponType.createCLLRM10());
        EquipmentType.addType(WeaponType.createCLLRM15());
        EquipmentType.addType(WeaponType.createCLLRM20());
        EquipmentType.addType(WeaponType.createCLLRM5OS());
        EquipmentType.addType(WeaponType.createCLLRM10OS());
        EquipmentType.addType(WeaponType.createCLLRM15OS());
        EquipmentType.addType(WeaponType.createCLLRM20OS());
        EquipmentType.addType(WeaponType.createCLSRM2());
        EquipmentType.addType(WeaponType.createCLSRM4());
        EquipmentType.addType(WeaponType.createCLSRM6());
        EquipmentType.addType(WeaponType.createCLSRM2OS());
        EquipmentType.addType(WeaponType.createCLSRM4OS());
        EquipmentType.addType(WeaponType.createCLSRM6OS());
        EquipmentType.addType(WeaponType.createCLLRT5());
        EquipmentType.addType(WeaponType.createCLLRT10());
        EquipmentType.addType(WeaponType.createCLLRT15());
        EquipmentType.addType(WeaponType.createCLLRT20());
        EquipmentType.addType(WeaponType.createCLLRT5OS());
        EquipmentType.addType(WeaponType.createCLLRT10OS());
        EquipmentType.addType(WeaponType.createCLLRT15OS());
        EquipmentType.addType(WeaponType.createCLLRT20OS());
        EquipmentType.addType(WeaponType.createCLSRT2());
        EquipmentType.addType(WeaponType.createCLSRT4());
        EquipmentType.addType(WeaponType.createCLSRT6());
        EquipmentType.addType(WeaponType.createCLSRT2OS());
        EquipmentType.addType(WeaponType.createCLSRT4OS());
        EquipmentType.addType(WeaponType.createCLSRT6OS());
        EquipmentType.addType(WeaponType.createCLGaussRifle());
        EquipmentType.addType(WeaponType.createCLUltraAC2());
        EquipmentType.addType(WeaponType.createCLUltraAC5());
        EquipmentType.addType(WeaponType.createCLUltraAC10());
        EquipmentType.addType(WeaponType.createCLUltraAC20());
        EquipmentType.addType(WeaponType.createCLStreakSRM2());
        EquipmentType.addType(WeaponType.createCLStreakSRM4());
        EquipmentType.addType(WeaponType.createCLStreakSRM6());
        EquipmentType.addType(WeaponType.createCLStreakSRM2OS());
        EquipmentType.addType(WeaponType.createCLStreakSRM4OS());
        EquipmentType.addType(WeaponType.createCLStreakSRM6OS());
        EquipmentType.addType(WeaponType.createCLATM3());
        EquipmentType.addType(WeaponType.createCLATM6());
        EquipmentType.addType(WeaponType.createCLATM9());
        EquipmentType.addType(WeaponType.createCLATM12());
        EquipmentType.addType(WeaponType.createCLAMS());
        EquipmentType.addType(WeaponType.createCLNarc());
        EquipmentType.addType(WeaponType.createCLNarcOS());
        EquipmentType.addType(WeaponType.createCLArrowIVSystem());
        EquipmentType.addType(WeaponType.createCLLongTom());
        EquipmentType.addType(WeaponType.createCLSniper());
        EquipmentType.addType(WeaponType.createCLThumper());
        EquipmentType.addType(WeaponType.createCLHAG20());
        EquipmentType.addType(WeaponType.createCLHAG30());
        EquipmentType.addType(WeaponType.createCLHAG40());
        EquipmentType.addType(WeaponType.createCLPlasmaCannon());
        EquipmentType.addType(WeaponType.createCLAPGaussRifle());
        EquipmentType.addType(WeaponType.createCLERLargePulseLaser());
        EquipmentType.addType(WeaponType.createCLERMediumPulseLaser());
        EquipmentType.addType(WeaponType.createCLERSmallPulseLaser());
        EquipmentType.addType(WeaponType.createCLRAC2());
        EquipmentType.addType(WeaponType.createCLRAC5());
        EquipmentType.addType(WeaponType.createCLRAC10());
        EquipmentType.addType(WeaponType.createCLRAC20());
        EquipmentType.addType(WeaponType.createCLStreakLRM5());
        EquipmentType.addType(WeaponType.createCLStreakLRM10());
        EquipmentType.addType(WeaponType.createCLStreakLRM15());
        EquipmentType.addType(WeaponType.createCLStreakLRM20());
        EquipmentType.addType(WeaponType.createCLStreakLRM5OS());
        EquipmentType.addType(WeaponType.createCLStreakLRM10OS());
        EquipmentType.addType(WeaponType.createCLStreakLRM15OS());
        EquipmentType.addType(WeaponType.createCLStreakLRM20OS());
        EquipmentType.addType(WeaponType.createCLLaserAMS());
        EquipmentType.addType(WeaponType.createCLPlasmaRifle());
        EquipmentType.addType(WeaponType.createCLMagshotGR());
        EquipmentType.addType(WeaponType.createCLMPod());
        EquipmentType.addType(WeaponType.createCLPROLRM1());
        EquipmentType.addType(WeaponType.createCLPROLRM2());
        EquipmentType.addType(WeaponType.createCLPROLRM3());
        EquipmentType.addType(WeaponType.createCLPROLRM4());
        EquipmentType.addType(WeaponType.createCLPROLRM6());
        EquipmentType.addType(WeaponType.createCLPROLRM7());
        EquipmentType.addType(WeaponType.createCLPROLRM8());
        EquipmentType.addType(WeaponType.createCLPROLRM9());
        EquipmentType.addType(WeaponType.createCLPROLRM11());
        EquipmentType.addType(WeaponType.createCLPROLRM12());
        EquipmentType.addType(WeaponType.createCLPROLRM13());
        EquipmentType.addType(WeaponType.createCLPROLRM14());
        EquipmentType.addType(WeaponType.createCLPROLRM16());
        EquipmentType.addType(WeaponType.createCLPROLRM17());
        EquipmentType.addType(WeaponType.createCLPROLRM18());
        EquipmentType.addType(WeaponType.createCLPROLRM19());
        EquipmentType.addType(WeaponType.createCLPROLRT1());
        EquipmentType.addType(WeaponType.createCLPROLRT2());
        EquipmentType.addType(WeaponType.createCLPROLRT3());
        EquipmentType.addType(WeaponType.createCLPROLRT4());
        EquipmentType.addType(WeaponType.createCLPROLRT6());
        EquipmentType.addType(WeaponType.createCLPROLRT7());
        EquipmentType.addType(WeaponType.createCLPROLRT8());
        EquipmentType.addType(WeaponType.createCLPROLRT9());
        EquipmentType.addType(WeaponType.createCLPROLRT11());
        EquipmentType.addType(WeaponType.createCLPROLRT12());
        EquipmentType.addType(WeaponType.createCLPROLRT13());
        EquipmentType.addType(WeaponType.createCLPROLRT14());
        EquipmentType.addType(WeaponType.createCLPROLRT16());
        EquipmentType.addType(WeaponType.createCLPROLRT17());
        EquipmentType.addType(WeaponType.createCLPROLRT18());
        EquipmentType.addType(WeaponType.createCLPROLRT19());
        EquipmentType.addType(WeaponType.createCLPROSRM1());
        EquipmentType.addType(WeaponType.createCLPROSRT1());
        EquipmentType.addType(WeaponType.createCLPROStreakSRM1());
        EquipmentType.addType(WeaponType.createCLPROSRM3());
        EquipmentType.addType(WeaponType.createCLPROStreakSRM3());
        EquipmentType.addType(WeaponType.createCLPROSRT3());
        EquipmentType.addType(WeaponType.createCLPROSRM5());
        EquipmentType.addType(WeaponType.createCLPROStreakSRM5());
        EquipmentType.addType(WeaponType.createCLPROSRT5());
        EquipmentType.addType(WeaponType.createLegAttack());
        EquipmentType.addType(WeaponType.createSwarmMek());
        EquipmentType.addType(WeaponType.createStopSwarm());
        EquipmentType.addType(WeaponType.createBAMG());
        EquipmentType.addType(WeaponType.createBASingleMG());
        EquipmentType.addType(WeaponType.createBASingleFlamer());
        EquipmentType.addType(WeaponType.createBAFlamer());
        EquipmentType.addType(WeaponType.createBASmallLaser());
        EquipmentType.addType(WeaponType.createBACLERSmallLaser());
        EquipmentType.addType(WeaponType.createBATwinFlamers());
        EquipmentType.addType(WeaponType.createBAInfernoSRM());
        EquipmentType.addType(WeaponType.createBACLMicroPulseLaser());
        EquipmentType.addType(WeaponType.createBAMicroBomb());
        EquipmentType.addType(WeaponType.createBACLERMicroLaser());
        EquipmentType.addType(WeaponType.createCLTorpedoLRM5());
        EquipmentType.addType(WeaponType.createBAISMediumPulseLaser());
        EquipmentType.addType(WeaponType.createTwinSmallPulseLaser());
        EquipmentType.addType(WeaponType.createTripleSmallLaser());
        EquipmentType.addType(WeaponType.createTripleMG());
        EquipmentType.addType(WeaponType.createBAAutoGL());
        EquipmentType.addType(WeaponType.createBAMagshotGR());
        EquipmentType.addType(WeaponType.createBAISMediumLaser());
        EquipmentType.addType(WeaponType.createBAISERSmallLaser());
        EquipmentType.addType(WeaponType.createBACompactNARC());
        EquipmentType.addType(WeaponType.createSlothSmallLaser());
        EquipmentType.addType(WeaponType.createBAMineLauncher());
        EquipmentType.addType(WeaponType.createBABearhunterAC());
        EquipmentType.addType(WeaponType.createBATwinBearhunterAC());
        EquipmentType.addType(WeaponType.createBACLMediumPulseLaser());
        EquipmentType.addType(WeaponType.createBAIncendiaryNeedler());
        EquipmentType.addType(WeaponType.createBALightRecRifle());
        EquipmentType.addType(WeaponType.createBAKingDavidLightGaussRifle());
        EquipmentType.addType(WeaponType.createBAMediumRecRifle());
        EquipmentType.addType(WeaponType.createBAPlasmaRifle());
        EquipmentType.addType(WeaponType.createBASingleSmallPulseLaser());
        EquipmentType.addType(WeaponType.createBASRM1());
        EquipmentType.addType(WeaponType.createBASRM2());
        EquipmentType.addType(WeaponType.createBASRM3());
        EquipmentType.addType(WeaponType.createBASRM4());
        EquipmentType.addType(WeaponType.createBASRM5());
        EquipmentType.addType(WeaponType.createBASRM6());
        EquipmentType.addType(WeaponType.createBASupportPPC());
        EquipmentType.addType(WeaponType.createBAVibroClaws1());
        EquipmentType.addType(WeaponType.createBAVibroClaws2());
        EquipmentType.addType(WeaponType.createBAHeavyMG());
        EquipmentType.addType(WeaponType.createBALightMG());
        EquipmentType.addType(WeaponType.createBACLHeavyMediumLaser());
        EquipmentType.addType(WeaponType.createBAHeavyRecRifle());
        EquipmentType.addType(WeaponType.createBACLHeavySmallLaser());
        EquipmentType.addType(WeaponType.createBACLERMediumLaser());
        EquipmentType.addType(WeaponType.createBAISERMediumLaser());
        EquipmentType.addType(WeaponType.createBACLSmallPulseLaser());
        EquipmentType.addType(WeaponType.createBAISLightMortar());
        EquipmentType.addType(WeaponType.createBAISHeavyMortar());
        EquipmentType.addType(WeaponType.createBAMicroGrenade());
        EquipmentType.addType(WeaponType.createBAGrandMaulerGauss());
        EquipmentType.addType(WeaponType.createBATsunamiGaussRifle());
        EquipmentType.addType(WeaponType.createBAAdvancedSRM1());
        EquipmentType.addType(WeaponType.createBAAdvancedSRM2());
        EquipmentType.addType(WeaponType.createBAAdvancedSRM3());
        EquipmentType.addType(WeaponType.createBAAdvancedSRM4());
        EquipmentType.addType(WeaponType.createBAAdvancedSRM5());
        EquipmentType.addType(WeaponType.createBAAdvancedSRM6());
        EquipmentType.addType(WeaponType.createBARL1());
        EquipmentType.addType(WeaponType.createBARL2());
        EquipmentType.addType(WeaponType.createBARL3());
        EquipmentType.addType(WeaponType.createBARL4());
        EquipmentType.addType(WeaponType.createBARL5());
        EquipmentType.addType(WeaponType.createISMRM1());
        EquipmentType.addType(WeaponType.createISMRM2());
        EquipmentType.addType(WeaponType.createISMRM3());
        EquipmentType.addType(WeaponType.createISMRM4());
        EquipmentType.addType(WeaponType.createISMRM5());
        EquipmentType.addType(WeaponType.createLRM1());
        EquipmentType.addType(WeaponType.createLRM2());
        EquipmentType.addType(WeaponType.createLRM3());
        EquipmentType.addType(WeaponType.createLRM4());
        EquipmentType.addType(WeaponType.createBADavidGaussRifle());
        EquipmentType.addType(WeaponType.createC3M());
    }

    private static void writeWeaponsToXML(Enumeration enumeration, String string) {
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            NumberFormat numberFormat = NumberFormat.getInstance();
            numberFormat.setMaximumFractionDigits(2);
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("weapons");
            document.appendChild(element);
            while (enumeration.hasMoreElements()) {
                object4 = (EquipmentType)enumeration.nextElement();
                object3 = (WeaponType)object4;
                if (!(object3 instanceof WeaponType)) continue;
                Element element2 = document.createElement("weapon");
                Element element3 = document.createElement("name");
                element3.appendChild(document.createTextNode(((WeaponType)object3).name));
                element2.appendChild(element3);
                if (((WeaponType)object3).internalName != null && ((WeaponType)object3).internalName.length() > 0) {
                    element3 = document.createElement("internalName");
                    element3.appendChild(document.createTextNode(((WeaponType)object3).internalName));
                    element2.appendChild(element3);
                }
                if ((object2 = ((EquipmentType)object3).getNames()).hasMoreElements()) {
                    element3 = document.createElement("lookupnames");
                    while (object2.hasMoreElements()) {
                        object = (String)object2.nextElement();
                        if (((String)object).equals(((WeaponType)object3).name) || ((String)object).equals(((WeaponType)object3).internalName)) continue;
                        Element element4 = document.createElement("lookupname");
                        element4.appendChild(document.createTextNode((String)object));
                        element3.appendChild(element4);
                    }
                    element2.appendChild(element3);
                }
                element3 = document.createElement("tonnage");
                element3.appendChild(document.createTextNode(numberFormat.format(((WeaponType)object3).tonnage)));
                element2.appendChild(element3);
                element3 = document.createElement("criticals");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).criticals)));
                element2.appendChild(element3);
                element3 = document.createElement("explosive");
                element3.appendChild(document.createTextNode(Boolean.toString(((WeaponType)object3).explosive)));
                element2.appendChild(element3);
                element3 = document.createElement("hittable");
                element3.appendChild(document.createTextNode(Boolean.toString(((WeaponType)object3).hittable)));
                element2.appendChild(element3);
                element3 = document.createElement("spreadable");
                element3.appendChild(document.createTextNode(Boolean.toString(((WeaponType)object3).spreadable)));
                element2.appendChild(element3);
                element3 = document.createElement("toHitModifier");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).toHitModifier)));
                element2.appendChild(element3);
                element3 = document.createElement("techLevel");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).techLevel)));
                element2.appendChild(element3);
                element3 = document.createElement("flags");
                element3.appendChild(document.createTextNode(Long.toString(((WeaponType)object3).flags)));
                element2.appendChild(element3);
                element3 = document.createElement("subType");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).subType)));
                element2.appendChild(element3);
                element3 = document.createElement("bv");
                element3.appendChild(document.createTextNode(numberFormat.format(((WeaponType)object3).bv)));
                element2.appendChild(element3);
                element3 = document.createElement("cost");
                element3.appendChild(document.createTextNode(numberFormat.format(((WeaponType)object3).cost)));
                element2.appendChild(element3);
                if (((EquipmentType)object3).hasModes()) {
                    element3 = document.createElement("modes");
                    object2 = ((EquipmentType)object3).getModes();
                    while (object2.hasMoreElements()) {
                        object = document.createElement("mode");
                        object.appendChild(document.createTextNode(((EquipmentMode)object2.nextElement()).toString()));
                    }
                    element2.appendChild(element3);
                }
                element3 = document.createElement("instantModeSwitch");
                element3.appendChild(document.createTextNode(Boolean.toString(((WeaponType)object3).instantModeSwitch)));
                element2.appendChild(element3);
                element3 = document.createElement("heat");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).heat)));
                element2.appendChild(element3);
                element3 = document.createElement("damage");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).damage)));
                element2.appendChild(element3);
                element3 = document.createElement("rackSize");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).rackSize)));
                element2.appendChild(element3);
                element3 = document.createElement("ammoType");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).ammoType)));
                element2.appendChild(element3);
                element3 = document.createElement("minimumRange");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).minimumRange)));
                element2.appendChild(element3);
                element3 = document.createElement("shortRange");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).shortRange)));
                element2.appendChild(element3);
                element3 = document.createElement("mediumRange");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).mediumRange)));
                element2.appendChild(element3);
                element3 = document.createElement("longRange");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).longRange)));
                element2.appendChild(element3);
                element3 = document.createElement("extremeRange");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).extremeRange)));
                element2.appendChild(element3);
                element3 = document.createElement("waterShortRange");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).waterShortRange)));
                element2.appendChild(element3);
                element3 = document.createElement("waterMediumRange");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).waterMediumRange)));
                element2.appendChild(element3);
                element3 = document.createElement("waterLongRange");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).waterLongRange)));
                element2.appendChild(element3);
                element3 = document.createElement("waterExtremeRange");
                element3.appendChild(document.createTextNode(Integer.toString(((WeaponType)object3).waterExtremeRange)));
                element2.appendChild(element3);
                element.appendChild(element2);
            }
            object4 = new DOMSource(document);
            object3 = new File(string);
            object2 = new StreamResult((File)object3);
            object = TransformerFactory.newInstance().newTransformer();
            ((Transformer)object).transform((Source)object4, (Result)object2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void initializeTypesFromXML(String string) {
        try {
            WeaponType weaponType = new WeaponType();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static WeaponType createFlamer() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Flamer";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Flamer");
        weaponType.addLookupName("ISFlamer");
        weaponType.heat = 3;
        weaponType.damage = 2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x200040002L;
        weaponType.bv = 6.0;
        weaponType.cost = 7500.0;
        String[] stringArray = new String[]{"Damage", "Heat"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    private static WeaponType createVehicleFlamer() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Vehicle Flamer";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Vehicle Flamer");
        weaponType.addLookupName("ISVehicleFlamer");
        weaponType.heat = 3;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 2;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x20002L;
        weaponType.bv = 5.0;
        weaponType.cost = 7500.0;
        String[] stringArray = new String[]{"Damage", "Heat", "Cool"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    private static WeaponType createLargeLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Large Laser";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Large Laser");
        weaponType.addLookupName("ISLargeLaser");
        weaponType.heat = 8;
        weaponType.damage = 8;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 6;
        weaponType.waterLongRange = 9;
        weaponType.waterExtremeRange = 12;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 0x80040005L;
        weaponType.bv = 123.0;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createMediumLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Medium Laser";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Medium Laser");
        weaponType.addLookupName("ISMediumLaser");
        weaponType.heat = 3;
        weaponType.damage = 5;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.waterShortRange = 2;
        weaponType.waterMediumRange = 4;
        weaponType.waterLongRange = 6;
        weaponType.waterExtremeRange = 8;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80040005L;
        weaponType.bv = 46.0;
        weaponType.cost = 40000.0;
        return weaponType;
    }

    private static WeaponType createSmallLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Small Laser";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Small Laser");
        weaponType.addLookupName("ISSmallLaser");
        weaponType.heat = 1;
        weaponType.damage = 3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 2;
        weaponType.waterExtremeRange = 3;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80040025L;
        weaponType.bv = 9.0;
        weaponType.cost = 11250.0;
        return weaponType;
    }

    private static WeaponType createPPC() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Particle Cannon";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS PPC");
        weaponType.addLookupName("ISPPC");
        weaponType.heat = 10;
        weaponType.damage = 10;
        weaponType.ammoType = -1;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.waterShortRange = 4;
        weaponType.waterMediumRange = 7;
        weaponType.waterLongRange = 10;
        weaponType.waterExtremeRange = 14;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 0x80040009L;
        weaponType.bv = 176.0;
        weaponType.setModes(new String[]{"Field Inhibitor ON", "Field Inhibitor OFF"});
        weaponType.cost = 200000.0;
        return weaponType;
    }

    private static WeaponType createMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Machine Gun";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Machine Gun");
        weaponType.addLookupName("ISMachine Gun");
        weaponType.heat = 0;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 3;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.bv = 5.0;
        weaponType.flags |= 0x200020200L;
        weaponType.cost = 5000.0;
        return weaponType;
    }

    private static WeaponType createISLightMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Light Machine Gun";
        weaponType.setInternalName("ISLightMG");
        weaponType.addLookupName("IS Light Machine Gun");
        weaponType.heat = 0;
        weaponType.damage = 1;
        weaponType.rackSize = 1;
        weaponType.ammoType = 5;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.bv = 5.0;
        weaponType.flags |= 0x200020200L;
        weaponType.cost = 5000.0;
        return weaponType;
    }

    private static WeaponType createISHeavyMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Heavy Machine Gun";
        weaponType.setInternalName("ISHeavyMG");
        weaponType.addLookupName("IS Heavy Machine Gun");
        weaponType.heat = 0;
        weaponType.damage = 3;
        weaponType.rackSize = 3;
        weaponType.ammoType = 4;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 2;
        weaponType.extremeRange = 2;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.bv = 6.0;
        weaponType.flags |= 0x200020200L;
        weaponType.cost = 7500.0;
        return weaponType;
    }

    private static WeaponType createISMGA() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "IS Machine Gun Array";
        weaponType.setInternalName("ISMGA");
        weaponType.heat = 0;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 3;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.bv = 0.0;
        weaponType.flags |= 0x600020000L;
        weaponType.cost = 5000.0;
        String[] stringArray = new String[]{"Linked", "Off"};
        weaponType.setModes(stringArray);
        weaponType.instantModeSwitch = false;
        return weaponType;
    }

    private static WeaponType createISLMGA() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "IS Light Machine Gun Array";
        weaponType.setInternalName("ISLMGA");
        weaponType.heat = 0;
        weaponType.damage = 1;
        weaponType.rackSize = 1;
        weaponType.ammoType = 5;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.bv = 0.0;
        weaponType.flags |= 0x600020000L;
        weaponType.cost = 5000.0;
        String[] stringArray = new String[]{"Linked", "Off"};
        weaponType.setModes(stringArray);
        weaponType.instantModeSwitch = false;
        return weaponType;
    }

    private static WeaponType createISHMGA() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "IS Heavy Machine Gun Array";
        weaponType.setInternalName("ISHMGA");
        weaponType.heat = 0;
        weaponType.damage = 3;
        weaponType.rackSize = 3;
        weaponType.ammoType = 4;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 2;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.bv = 0.0;
        weaponType.flags |= 0x600020000L;
        weaponType.cost = 5000.0;
        String[] stringArray = new String[]{"Linked", "Off"};
        weaponType.setModes(stringArray);
        weaponType.instantModeSwitch = false;
        return weaponType;
    }

    private static WeaponType createAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Auto Cannon/2";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Auto Cannon/2");
        weaponType.addLookupName("ISAC2");
        weaponType.addLookupName("IS Autocannon/2");
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 1;
        weaponType.minimumRange = 4;
        weaponType.shortRange = 8;
        weaponType.mediumRange = 16;
        weaponType.longRange = 24;
        weaponType.extremeRange = 32;
        weaponType.tonnage = 6.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 37.0;
        String[] stringArray = new String[]{"", "Rapid"};
        weaponType.setModes(stringArray);
        weaponType.cost = 75000.0;
        weaponType.explosive = true;
        return weaponType;
    }

    private static WeaponType createAC5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Auto Cannon/5";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Auto Cannon/5");
        weaponType.addLookupName("ISAC5");
        weaponType.addLookupName("IS Autocannon/5");
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 1;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.tonnage = 8.0f;
        weaponType.criticals = 4;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 70.0;
        String[] stringArray = new String[]{"", "Rapid"};
        weaponType.setModes(stringArray);
        weaponType.cost = 125000.0;
        weaponType.explosive = true;
        return weaponType;
    }

    private static WeaponType createAC10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Auto Cannon/10";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Auto Cannon/10");
        weaponType.addLookupName("ISAC10");
        weaponType.addLookupName("IS Autocannon/10");
        weaponType.heat = 3;
        weaponType.damage = 10;
        weaponType.rackSize = 10;
        weaponType.ammoType = 1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        weaponType.tonnage = 12.0f;
        weaponType.criticals = 7;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 123.0;
        String[] stringArray = new String[]{"", "Rapid"};
        weaponType.setModes(stringArray);
        weaponType.cost = 200000.0;
        weaponType.explosive = true;
        return weaponType;
    }

    private static WeaponType createAC20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Auto Cannon/20";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Auto Cannon/20");
        weaponType.addLookupName("ISAC20");
        weaponType.addLookupName("IS Autocannon/20");
        weaponType.heat = 7;
        weaponType.damage = 20;
        weaponType.rackSize = 20;
        weaponType.ammoType = 1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 14.0f;
        weaponType.criticals = 10;
        weaponType.flags |= 0x20101L;
        weaponType.bv = 178.0;
        String[] stringArray = new String[]{"", "Rapid"};
        weaponType.setModes(stringArray);
        weaponType.cost = 300000.0;
        weaponType.explosive = true;
        return weaponType;
    }

    private static WeaponType createLRM5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRM 5";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS LRM-5");
        weaponType.addLookupName("ISLRM5");
        weaponType.addLookupName("IS LRM 5");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.bv = 45.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 30000.0;
        return weaponType;
    }

    private static WeaponType createLRM10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRM 10";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS LRM-10");
        weaponType.addLookupName("ISLRM10");
        weaponType.addLookupName("IS LRM 10");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 10;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 2;
        weaponType.bv = 90.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createLRM15() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRM 15";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS LRM-15");
        weaponType.addLookupName("ISLRM15");
        weaponType.addLookupName("IS LRM 15");
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.rackSize = 15;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.bv = 136.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 175000.0;
        return weaponType;
    }

    private static WeaponType createLRM20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRM 20";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS LRM-20");
        weaponType.addLookupName("ISLRM20");
        weaponType.addLookupName("IS LRM 20");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.rackSize = 20;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 5;
        weaponType.bv = 181.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 250000.0;
        return weaponType;
    }

    private static WeaponType createLRT5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRT 5";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS LRT-5");
        weaponType.addLookupName("ISLRTorpedo5");
        weaponType.addLookupName("IS LRT 5");
        weaponType.addLookupName("ISLRT5");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 8;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.bv = 45.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 30000.0;
        return weaponType;
    }

    private static WeaponType createLRT10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRT 10";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS LRT-10");
        weaponType.addLookupName("ISLRTorpedo10");
        weaponType.addLookupName("IS LRT 10");
        weaponType.addLookupName("ISLRT10");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 10;
        weaponType.ammoType = 8;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 2;
        weaponType.bv = 90.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createLRT15() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRT 15";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS LRT-15");
        weaponType.addLookupName("ISLRTorpedo15");
        weaponType.addLookupName("IS LRT 15");
        weaponType.addLookupName("ISLRT15");
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.rackSize = 15;
        weaponType.ammoType = 8;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.bv = 136.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 175000.0;
        return weaponType;
    }

    private static WeaponType createLRT20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRT 20";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS LRT-20");
        weaponType.addLookupName("ISLRTorpedo20");
        weaponType.addLookupName("IS LRT 20");
        weaponType.addLookupName("ISLRT20");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.rackSize = 20;
        weaponType.ammoType = 8;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 5;
        weaponType.bv = 181.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 250000.0;
        return weaponType;
    }

    private static WeaponType createISLRM5OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRM 5 (OS)";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS OS LRM-5");
        weaponType.addLookupName("ISLRM5 (OS)");
        weaponType.addLookupName("IS LRM 5 (OS)");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 2.5f;
        weaponType.criticals = 1;
        weaponType.bv = 9.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 30000.0;
        return weaponType;
    }

    private static WeaponType createISLRM10OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRM 10 (OS)";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS OS LRM-10");
        weaponType.addLookupName("ISLRM10 (OS)");
        weaponType.addLookupName("IS LRM 10 (OS)");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 10;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 5.5f;
        weaponType.criticals = 2;
        weaponType.bv = 18.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createISLRM15OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRM 15 (OS)";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS OS LRM-15");
        weaponType.addLookupName("ISLRM15 (OS)");
        weaponType.addLookupName("IS LRM 15 (OS)");
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.rackSize = 15;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 7.5f;
        weaponType.criticals = 3;
        weaponType.bv = 27.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 175000.0;
        return weaponType;
    }

    private static WeaponType createISLRM20OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRM 20 (OS)";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS OS LRM-20");
        weaponType.addLookupName("ISLRM20 (OS)");
        weaponType.addLookupName("IS LRM 20 (OS)");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.rackSize = 20;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 10.5f;
        weaponType.criticals = 5;
        weaponType.bv = 36.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 250000.0;
        return weaponType;
    }

    private static WeaponType createISLRT5OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRT 5 (OS)";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS OS LRT-5");
        weaponType.addLookupName("ISLRTorpedo5 (OS)");
        weaponType.addLookupName("IS LRTorpedo 5 (OS)");
        weaponType.addLookupName("ISLRT5 (OS)");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 8;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 2.5f;
        weaponType.criticals = 1;
        weaponType.bv = 9.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 30000.0;
        return weaponType;
    }

    private static WeaponType createISLRT10OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRT 10 (OS)";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS OS LRTorpedo-10");
        weaponType.addLookupName("ISLRTorpedo10 (OS)");
        weaponType.addLookupName("IS LRTorpedo 10 (OS)");
        weaponType.addLookupName("ISLRT10 (OS)");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 10;
        weaponType.ammoType = 8;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 5.5f;
        weaponType.criticals = 2;
        weaponType.bv = 18.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createISLRT15OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRT 15 (OS)";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS OS LRTorpedo-15");
        weaponType.addLookupName("ISLRTorpedo15 (OS)");
        weaponType.addLookupName("IS LRTorpedo 15 (OS)");
        weaponType.addLookupName("ISLRT15 (OS)");
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.rackSize = 15;
        weaponType.ammoType = 8;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 7.5f;
        weaponType.criticals = 3;
        weaponType.bv = 27.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 175000.0;
        return weaponType;
    }

    private static WeaponType createISLRT20OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRT 20 (OS)";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS OS LRTorpedo-20");
        weaponType.addLookupName("ISLRTorpedo20 (OS)");
        weaponType.addLookupName("IS LRTorpedo 20 (OS)");
        weaponType.addLookupName("ISLRT20 (OS)");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.rackSize = 20;
        weaponType.ammoType = 8;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 10.5f;
        weaponType.criticals = 5;
        weaponType.bv = 36.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 250000.0;
        return weaponType;
    }

    private static WeaponType createISRL10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "RL 10";
        weaponType.setInternalName("RL10");
        weaponType.addLookupName("ISRocketLauncher10");
        weaponType.addLookupName("IS RLauncher-10");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 11;
        weaponType.longRange = 18;
        weaponType.extremeRange = 22;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.bv = 18.0;
        weaponType.ammoType = 30;
        weaponType.flags |= 0x88000L;
        weaponType.toHitModifier = 1;
        weaponType.cost = 15000.0;
        return weaponType;
    }

    private static WeaponType createISRL15() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "RL 15";
        weaponType.setInternalName("RL15");
        weaponType.addLookupName("ISRocketLauncher15");
        weaponType.addLookupName("IS RLauncher-15");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 15;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 9;
        weaponType.longRange = 15;
        weaponType.extremeRange = 18;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 2;
        weaponType.bv = 23.0;
        weaponType.flags |= 0x88000L;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = 30;
        weaponType.cost = 30000.0;
        return weaponType;
    }

    private static WeaponType createISRL20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "RL 20";
        weaponType.setInternalName("RL20");
        weaponType.addLookupName("ISRocketLauncher20");
        weaponType.addLookupName("IS RLauncher-20");
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.rackSize = 20;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 7;
        weaponType.longRange = 12;
        weaponType.extremeRange = 14;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 3;
        weaponType.bv = 24.0;
        weaponType.ammoType = 30;
        weaponType.flags |= 0x88000L;
        weaponType.toHitModifier = 1;
        weaponType.cost = 45000.0;
        return weaponType;
    }

    private static WeaponType createSRM2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "SRM 2";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS SRM-2");
        weaponType.addLookupName("ISSRM2");
        weaponType.addLookupName("IS SRM 2");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80020L;
        weaponType.bv = 21.0;
        weaponType.cost = 10000.0;
        return weaponType;
    }

    private static WeaponType createSRM4() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "SRM 4";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS SRM-4");
        weaponType.addLookupName("ISSRM4");
        weaponType.addLookupName("IS SRM 4");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.bv = 39.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 60000.0;
        return weaponType;
    }

    private static WeaponType createSRM6() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "SRM 6";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS SRM-6");
        weaponType.addLookupName("ISSRM6");
        weaponType.addLookupName("IS SRM 6");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 2;
        weaponType.bv = 59.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 80000.0;
        return weaponType;
    }

    private static WeaponType createSRT2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "SRT 2";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS SRT-2");
        weaponType.addLookupName("ISSRT2");
        weaponType.addLookupName("IS SRT 2");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 6;
        weaponType.waterLongRange = 9;
        weaponType.waterExtremeRange = 12;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80020L;
        weaponType.bv = 21.0;
        weaponType.cost = 10000.0;
        return weaponType;
    }

    private static WeaponType createSRT4() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "SRT 4";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS SRT-4");
        weaponType.addLookupName("ISSRT4");
        weaponType.addLookupName("IS SRT 4");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 6;
        weaponType.waterLongRange = 9;
        weaponType.waterExtremeRange = 12;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.bv = 39.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 60000.0;
        return weaponType;
    }

    private static WeaponType createSRT6() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "SRT 6";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS SRT-6");
        weaponType.addLookupName("ISSRT6");
        weaponType.addLookupName("IS SRT 6");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 6;
        weaponType.waterLongRange = 9;
        weaponType.waterExtremeRange = 12;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 2;
        weaponType.bv = 59.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 80000.0;
        return weaponType;
    }

    private static WeaponType createISERPPC() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "ER PPC";
        weaponType.setInternalName("ISERPPC");
        weaponType.addLookupName("IS ER PPC");
        weaponType.heat = 15;
        weaponType.damage = 10;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 23;
        weaponType.extremeRange = 28;
        weaponType.waterShortRange = 4;
        weaponType.waterMediumRange = 10;
        weaponType.waterLongRange = 16;
        weaponType.waterExtremeRange = 20;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 0x80040009L;
        weaponType.bv = 228.0;
        weaponType.cost = 300000.0;
        weaponType.setModes(new String[]{"Field Inhibitor ON", "Field Inhibitor OFF"});
        return weaponType;
    }

    private static WeaponType createISERLargeLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "ER Large Laser";
        weaponType.setInternalName("ISERLargeLaser");
        weaponType.addLookupName("IS ER Large Laser");
        weaponType.heat = 12;
        weaponType.damage = 8;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 19;
        weaponType.extremeRange = 28;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 9;
        weaponType.waterLongRange = 12;
        weaponType.waterExtremeRange = 18;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 0x80040005L;
        weaponType.bv = 163.0;
        weaponType.cost = 200000.0;
        return weaponType;
    }

    private static WeaponType createISERMediumLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "ER Medium Laser";
        weaponType.setInternalName("ISERMediumLaser");
        weaponType.addLookupName("IS ER Medium Laser");
        weaponType.heat = 5;
        weaponType.damage = 5;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 5;
        weaponType.waterLongRange = 8;
        weaponType.waterExtremeRange = 10;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80040005L;
        weaponType.bv = 62.0;
        weaponType.cost = 80000.0;
        return weaponType;
    }

    private static WeaponType createISERSmallLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "ER Small Laser";
        weaponType.setInternalName("ISERSmallLaser");
        weaponType.addLookupName("IS ER Small Laser");
        weaponType.heat = 2;
        weaponType.damage = 3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 5;
        weaponType.extremeRange = 8;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 3;
        weaponType.waterExtremeRange = 4;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80040025L;
        weaponType.bv = 17.0;
        weaponType.cost = 11250.0;
        return weaponType;
    }

    private static WeaponType createISLargePulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Large Pulse Laser";
        weaponType.setInternalName("ISLargePulseLaser");
        weaponType.addLookupName("IS Pulse Large Laser");
        weaponType.addLookupName("IS Large Pulse Laser");
        weaponType.heat = 10;
        weaponType.damage = 9;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 7;
        weaponType.longRange = 10;
        weaponType.extremeRange = 14;
        weaponType.waterShortRange = 2;
        weaponType.waterMediumRange = 5;
        weaponType.waterLongRange = 7;
        weaponType.waterExtremeRange = 10;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 0x100040005L;
        weaponType.bv = 119.0;
        weaponType.cost = 175000.0;
        return weaponType;
    }

    private static WeaponType createISMediumPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Medium Pulse Laser";
        weaponType.setInternalName("ISMediumPulseLaser");
        weaponType.addLookupName("IS Pulse Med Laser");
        weaponType.addLookupName("IS Medium Pulse Laser");
        weaponType.heat = 4;
        weaponType.damage = 6;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.waterShortRange = 2;
        weaponType.waterMediumRange = 3;
        weaponType.waterLongRange = 4;
        weaponType.waterExtremeRange = 6;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x100040005L;
        weaponType.bv = 48.0;
        weaponType.cost = 60000.0;
        return weaponType;
    }

    private static WeaponType createISSmallPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Small Pulse Laser";
        weaponType.setInternalName("ISSmallPulseLaser");
        weaponType.addLookupName("IS Pulse Small Laser");
        weaponType.addLookupName("IS Small Pulse Laser");
        weaponType.heat = 2;
        weaponType.damage = 3;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 2;
        weaponType.waterExtremeRange = 4;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x300040005L;
        weaponType.bv = 12.0;
        weaponType.cost = 16000.0;
        return weaponType;
    }

    private static WeaponType createISLargeXPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Large X-Pulse Laser";
        weaponType.setInternalName("ISLargeXPulseLaser");
        weaponType.addLookupName("IS X-Pulse Large Laser");
        weaponType.addLookupName("IS Large X-Pulse Laser");
        weaponType.heat = 14;
        weaponType.damage = 9;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        weaponType.waterShortRange = 2;
        weaponType.waterMediumRange = 5;
        weaponType.waterLongRange = 7;
        weaponType.waterExtremeRange = 10;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 0x100040005L;
        weaponType.bv = 178.0;
        weaponType.cost = 275000.0;
        return weaponType;
    }

    private static WeaponType createISMediumXPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Medium X-Pulse Laser";
        weaponType.setInternalName("ISMediumXPulseLaser");
        weaponType.addLookupName("IS X-Pulse Med Laser");
        weaponType.addLookupName("IS Medium X-Pulse Laser");
        weaponType.heat = 6;
        weaponType.damage = 6;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.waterShortRange = 2;
        weaponType.waterMediumRange = 3;
        weaponType.waterLongRange = 4;
        weaponType.waterExtremeRange = 6;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x100040005L;
        weaponType.bv = 71.0;
        weaponType.cost = 110000.0;
        return weaponType;
    }

    private static WeaponType createISSmallXPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Small X-Pulse Laser";
        weaponType.setInternalName("ISSmallXPulseLaser");
        weaponType.addLookupName("IS X-Pulse Small Laser");
        weaponType.addLookupName("IS Small X-Pulse Laser");
        weaponType.heat = 3;
        weaponType.damage = 3;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 5;
        weaponType.extremeRange = 8;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 2;
        weaponType.waterExtremeRange = 4;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x300040005L;
        weaponType.bv = 21.0;
        weaponType.cost = 31000.0;
        return weaponType;
    }

    private static WeaponType createISLBXAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "LB 2-X AC";
        weaponType.setInternalName("ISLBXAC2");
        weaponType.addLookupName("IS LB 2-X AC");
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 19;
        weaponType.minimumRange = 4;
        weaponType.shortRange = 9;
        weaponType.mediumRange = 18;
        weaponType.longRange = 27;
        weaponType.extremeRange = 36;
        weaponType.tonnage = 6.0f;
        weaponType.criticals = 4;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 42.0;
        weaponType.cost = 150000.0;
        return weaponType;
    }

    private static WeaponType createISLBXAC5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "LB 5-X AC";
        weaponType.setInternalName("ISLBXAC5");
        weaponType.addLookupName("IS LB 5-X AC");
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 19;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 8.0f;
        weaponType.criticals = 5;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 83.0;
        weaponType.cost = 250000.0;
        return weaponType;
    }

    private static WeaponType createISLBXAC10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "LB 10-X AC";
        weaponType.setInternalName("ISLBXAC10");
        weaponType.addLookupName("IS LB 10-X AC");
        weaponType.heat = 2;
        weaponType.damage = 10;
        weaponType.rackSize = 10;
        weaponType.ammoType = 19;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.tonnage = 11.0f;
        weaponType.criticals = 6;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 148.0;
        weaponType.cost = 400000.0;
        return weaponType;
    }

    private static WeaponType createISLBXAC20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "LB 20-X AC";
        weaponType.setInternalName("ISLBXAC20");
        weaponType.addLookupName("IS LB 20-X AC");
        weaponType.heat = 6;
        weaponType.damage = 20;
        weaponType.rackSize = 20;
        weaponType.ammoType = 19;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 14.0f;
        weaponType.criticals = 11;
        weaponType.flags |= 0x20101L;
        weaponType.bv = 237.0;
        weaponType.cost = 600000.0;
        return weaponType;
    }

    private static WeaponType createISTHBLBXAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "LB 2-X AC (THB)";
        weaponType.setInternalName("ISTHBLBXAC2");
        weaponType.addLookupName("IS LB 2-X AC (THB)");
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 33;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 10;
        weaponType.mediumRange = 18;
        weaponType.longRange = 27;
        weaponType.extremeRange = 36;
        weaponType.tonnage = 6.0f;
        weaponType.criticals = 4;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 40.0;
        weaponType.cost = 200000.0;
        return weaponType;
    }

    private static WeaponType createISTHBLBXAC5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "LB 5-X AC (THB)";
        weaponType.setInternalName("ISTHBLBXAC5");
        weaponType.addLookupName("IS LB 5-X AC (THB)");
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 33;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 8;
        weaponType.mediumRange = 15;
        weaponType.longRange = 22;
        weaponType.extremeRange = 30;
        weaponType.tonnage = 8.0f;
        weaponType.criticals = 6;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 85.0;
        weaponType.cost = 300000.0;
        return weaponType;
    }

    private static WeaponType createISTHBLBXAC20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "LB 20-X AC (THB)";
        weaponType.setInternalName("ISTHBLBXAC20");
        weaponType.addLookupName("IS LB 20-X AC (THB)");
        weaponType.heat = 6;
        weaponType.damage = 20;
        weaponType.rackSize = 20;
        weaponType.ammoType = 33;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 7;
        weaponType.longRange = 12;
        weaponType.extremeRange = 14;
        weaponType.tonnage = 14.0f;
        weaponType.criticals = 10;
        weaponType.flags |= 0x20101L;
        weaponType.bv = 204.0;
        weaponType.cost = 700000.0;
        return weaponType;
    }

    private static WeaponType createISGaussRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Gauss Rifle";
        weaponType.setInternalName("ISGaussRifle");
        weaponType.addLookupName("IS Gauss Rifle");
        weaponType.heat = 1;
        weaponType.damage = 15;
        weaponType.ammoType = 6;
        weaponType.minimumRange = 2;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 15;
        weaponType.longRange = 22;
        weaponType.extremeRange = 30;
        weaponType.tonnage = 15.0f;
        weaponType.criticals = 7;
        weaponType.flags |= 0x80020021L;
        weaponType.explosive = true;
        weaponType.bv = 320.0;
        weaponType.cost = 300000.0;
        return weaponType;
    }

    private static WeaponType createISLightGaussRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Light Gauss Rifle";
        weaponType.setInternalName("ISLightGaussRifle");
        weaponType.addLookupName("IS Light Gauss Rifle");
        weaponType.heat = 1;
        weaponType.damage = 8;
        weaponType.ammoType = 21;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 8;
        weaponType.mediumRange = 17;
        weaponType.longRange = 25;
        weaponType.extremeRange = 34;
        weaponType.tonnage = 12.0f;
        weaponType.criticals = 5;
        weaponType.flags |= 0x80020021L;
        weaponType.explosive = true;
        weaponType.bv = 159.0;
        weaponType.cost = 275000.0;
        return weaponType;
    }

    private static WeaponType createISHeavyGaussRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Heavy Gauss Rifle";
        weaponType.setInternalName("ISHeavyGaussRifle");
        weaponType.addLookupName("IS Heavy Gauss Rifle");
        weaponType.heat = 2;
        weaponType.damage = -3;
        weaponType.ammoType = 22;
        weaponType.minimumRange = 4;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 13;
        weaponType.longRange = 20;
        weaponType.extremeRange = 26;
        weaponType.tonnage = 18.0f;
        weaponType.criticals = 11;
        weaponType.flags |= 0x80020121L;
        weaponType.explosive = true;
        weaponType.bv = 346.0;
        weaponType.cost = 500000.0;
        return weaponType;
    }

    private static WeaponType createISUltraAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Ultra AC/2";
        weaponType.setInternalName("ISUltraAC2");
        weaponType.addLookupName("IS Ultra AC/2");
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 20;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 8;
        weaponType.mediumRange = 17;
        weaponType.longRange = 25;
        weaponType.extremeRange = 34;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 56.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        weaponType.cost = 120000.0;
        return weaponType;
    }

    private static WeaponType createISUltraAC5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Ultra AC/5";
        weaponType.setInternalName("ISUltraAC5");
        weaponType.addLookupName("IS Ultra AC/5");
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 20;
        weaponType.minimumRange = 2;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 13;
        weaponType.longRange = 20;
        weaponType.extremeRange = 26;
        weaponType.tonnage = 9.0f;
        weaponType.criticals = 5;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 112.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        weaponType.cost = 200000.0;
        return weaponType;
    }

    private static WeaponType createISUltraAC10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Ultra AC/10";
        weaponType.setInternalName("ISUltraAC10");
        weaponType.addLookupName("IS Ultra AC/10");
        weaponType.heat = 4;
        weaponType.damage = 10;
        weaponType.rackSize = 10;
        weaponType.ammoType = 20;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.tonnage = 13.0f;
        weaponType.criticals = 7;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 210.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        weaponType.cost = 320000.0;
        return weaponType;
    }

    private static WeaponType createISUltraAC20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Ultra AC/20";
        weaponType.setInternalName("ISUltraAC20");
        weaponType.addLookupName("IS Ultra AC/20");
        weaponType.heat = 8;
        weaponType.damage = 20;
        weaponType.rackSize = 20;
        weaponType.ammoType = 20;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 7;
        weaponType.longRange = 10;
        weaponType.extremeRange = 14;
        weaponType.tonnage = 15.0f;
        weaponType.criticals = 10;
        weaponType.flags |= 0x20101L;
        weaponType.bv = 281.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        weaponType.cost = 480000.0;
        return weaponType;
    }

    private static WeaponType createISTHBUltraAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Ultra AC/2 (THB)";
        weaponType.setInternalName("ISUltraAC2 (THB)");
        weaponType.addLookupName("IS Ultra AC/2 (THB)");
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 34;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 9;
        weaponType.mediumRange = 20;
        weaponType.longRange = 32;
        weaponType.extremeRange = 40;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 67.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        weaponType.cost = 150000.0;
        return weaponType;
    }

    private static WeaponType createISTHBUltraAC10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Ultra AC/10 (THB)";
        weaponType.setInternalName("ISUltraAC10 (THB)");
        weaponType.addLookupName("IS Ultra AC/10 (THB)");
        weaponType.heat = 4;
        weaponType.damage = 10;
        weaponType.rackSize = 10;
        weaponType.ammoType = 34;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 13.0f;
        weaponType.criticals = 7;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 245.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        weaponType.cost = 400000.0;
        return weaponType;
    }

    private static WeaponType createISTHBUltraAC20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Ultra AC/20 (THB)";
        weaponType.setInternalName("ISUltraAC20 (THB)");
        weaponType.addLookupName("IS Ultra AC/20 (THB)");
        weaponType.heat = 10;
        weaponType.damage = 20;
        weaponType.rackSize = 20;
        weaponType.ammoType = 34;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 15.0f;
        weaponType.criticals = 11;
        weaponType.flags |= 0x20101L;
        weaponType.bv = 335.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        weaponType.cost = 600000.0;
        return weaponType;
    }

    private static WeaponType createISRAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Rotary AC/2";
        weaponType.setInternalName("ISRotaryAC2");
        weaponType.addLookupName("IS Rotary AC/2");
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 23;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.tonnage = 8.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 118.0;
        String[] stringArray = new String[]{"Single", "2-shot", "3-shot", "4-shot", "5-shot", "6-shot"};
        weaponType.setModes(stringArray);
        weaponType.explosive = true;
        weaponType.cost = 175000.0;
        return weaponType;
    }

    private static WeaponType createISRAC5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Rotary AC/5";
        weaponType.setInternalName("ISRotaryAC5");
        weaponType.addLookupName("IS Rotary AC/5");
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 23;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 6;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 247.0;
        String[] stringArray = new String[]{"Single", "2-shot", "3-shot", "4-shot", "5-shot", "6-shot"};
        weaponType.setModes(stringArray);
        weaponType.explosive = true;
        weaponType.cost = 275000.0;
        return weaponType;
    }

    private static WeaponType createISStreakSRM2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Streak SRM 2";
        weaponType.setInternalName("ISStreakSRM2");
        weaponType.addLookupName("IS Streak SRM-2");
        weaponType.addLookupName("IS Streak SRM 2");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 11;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80020L;
        weaponType.bv = 30.0;
        weaponType.cost = 15000.0;
        return weaponType;
    }

    private static WeaponType createISSRM2OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "SRM 2 (OS)";
        weaponType.setInternalName("ISSRM2OS");
        weaponType.addLookupName("ISSRM2 (OS)");
        weaponType.addLookupName("IS SRM 2 (OS)");
        weaponType.addLookupName("OS SRM-2");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x88020L;
        weaponType.bv = 4.0;
        weaponType.cost = 10000.0;
        return weaponType;
    }

    private static WeaponType createISSRT2OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "SRT 2 (OS)";
        weaponType.setInternalName("ISSRT2OS");
        weaponType.addLookupName("ISSRTorpedo2 (OS)");
        weaponType.addLookupName("IS SRT 2 (OS)");
        weaponType.addLookupName("OS SRT-2");
        weaponType.addLookupName("ISSRT2 (OS)");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 6;
        weaponType.waterLongRange = 9;
        weaponType.waterExtremeRange = 12;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x88020L;
        weaponType.bv = 4.0;
        weaponType.cost = 10000.0;
        return weaponType;
    }

    private static WeaponType createISStreakSRM2OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Streak SRM 2 (OS)";
        weaponType.setInternalName("ISStreakSRM2OS");
        weaponType.addLookupName("ISStreakSRM2 (OS)");
        weaponType.addLookupName("IS Streak SRM 2 (OS)");
        weaponType.addLookupName("OS Streak SRM-2");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 11;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x88020L;
        weaponType.bv = 6.0;
        weaponType.cost = 15000.0;
        return weaponType;
    }

    private static WeaponType createISStreakSRM4() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Streak SRM 4";
        weaponType.setInternalName("ISStreakSRM4");
        weaponType.addLookupName("IS Streak SRM-4");
        weaponType.addLookupName("IS Streak SRM 4");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 11;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80000L;
        weaponType.bv = 59.0;
        weaponType.cost = 90000.0;
        return weaponType;
    }

    private static WeaponType createISSRM4OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "SRM 4 (OS)";
        weaponType.setInternalName("ISSRM4OS");
        weaponType.addLookupName("ISSRM4 (OS)");
        weaponType.addLookupName("IS SRM 4 (OS)");
        weaponType.addLookupName("OS SRM-4");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 2.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x88000L;
        weaponType.bv = 8.0;
        weaponType.cost = 60000.0;
        return weaponType;
    }

    private static WeaponType createISSRT4OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "SRT 4 (OS)";
        weaponType.setInternalName("ISSRT4OS");
        weaponType.addLookupName("ISSRTorpedo4 (OS)");
        weaponType.addLookupName("IS SRTorpedo 4 (OS)");
        weaponType.addLookupName("OS SRTorpedo-4");
        weaponType.addLookupName("ISSRT4 (OS)");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 6;
        weaponType.waterLongRange = 9;
        weaponType.waterExtremeRange = 12;
        weaponType.tonnage = 2.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x88000L;
        weaponType.bv = 8.0;
        weaponType.cost = 60000.0;
        return weaponType;
    }

    private static WeaponType createISStreakSRM4OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Streak SRM 4 (OS)";
        weaponType.setInternalName("ISStreakSRM4OS");
        weaponType.addLookupName("ISStreakSRM4 (OS)");
        weaponType.addLookupName("IS Streak SRM 4 (OS)");
        weaponType.addLookupName("OS Streak SRM-4");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 11;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 3.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x88000L;
        weaponType.bv = 12.0;
        weaponType.cost = 90000.0;
        return weaponType;
    }

    private static WeaponType createISStreakSRM6() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Streak SRM 6";
        weaponType.setInternalName("ISStreakSRM6");
        weaponType.addLookupName("IS Streak SRM-6");
        weaponType.addLookupName("IS Streak SRM 6");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 11;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 4.5f;
        weaponType.criticals = 2;
        weaponType.bv = 89.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 120000.0;
        return weaponType;
    }

    private static WeaponType createISSRM6OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "SRM 6 (OS)";
        weaponType.setInternalName("ISSRM6OS");
        weaponType.addLookupName("ISSRM6 (OS)");
        weaponType.addLookupName("IS SRM 6 (OS)");
        weaponType.addLookupName("OS SRM-6");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 3.5f;
        weaponType.criticals = 2;
        weaponType.bv = 12.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 80000.0;
        return weaponType;
    }

    private static WeaponType createISSRT6OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "SRT 6 (OS)";
        weaponType.setInternalName("ISSRTorpedo6OS");
        weaponType.addLookupName("ISSRTorpedo6 (OS)");
        weaponType.addLookupName("IS SRTorpedo 6 (OS)");
        weaponType.addLookupName("OS SRTorpedo-6");
        weaponType.addLookupName("ISSRT6 (OS)");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 6;
        weaponType.waterLongRange = 9;
        weaponType.waterExtremeRange = 12;
        weaponType.tonnage = 3.5f;
        weaponType.criticals = 2;
        weaponType.bv = 12.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 80000.0;
        return weaponType;
    }

    private static WeaponType createISStreakSRM6OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Streak SRM 6 (OS)";
        weaponType.setInternalName("ISStreakSRM6OS");
        weaponType.addLookupName("ISStreakSRM6 (OS)");
        weaponType.addLookupName("IS Streak SRM 6 (OS)");
        weaponType.addLookupName("OS Streak SRM-6");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 11;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 2;
        weaponType.bv = 18.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 120000.0;
        return weaponType;
    }

    private static WeaponType createISMRM10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MRM 10";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("MRM-10");
        weaponType.addLookupName("ISMRM10");
        weaponType.addLookupName("IS MRM 10");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 10;
        weaponType.ammoType = 12;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 2;
        weaponType.bv = 56.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 50000.0;
        return weaponType;
    }

    private static WeaponType createISMRM20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MRM 20";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("MRM-20");
        weaponType.addLookupName("ISMRM20");
        weaponType.addLookupName("IS MRM 20");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 20;
        weaponType.ammoType = 12;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.bv = 112.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 125000.0;
        return weaponType;
    }

    private static WeaponType createISMRM30() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MRM 30";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("MRM-30");
        weaponType.addLookupName("ISMRM30");
        weaponType.addLookupName("IS MRM 30");
        weaponType.heat = 10;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 30;
        weaponType.ammoType = 12;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 5;
        weaponType.bv = 168.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 225000.0;
        return weaponType;
    }

    private static WeaponType createISMRM40() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MRM 40";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("MRM-40");
        weaponType.addLookupName("ISMRM40");
        weaponType.addLookupName("IS MRM 40");
        weaponType.heat = 12;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 40;
        weaponType.ammoType = 12;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 12.0f;
        weaponType.criticals = 7;
        weaponType.bv = 224.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 350000.0;
        return weaponType;
    }

    private static WeaponType createISMRM10OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MRM 10 (OS)";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("OS MRM-10");
        weaponType.addLookupName("ISMRM10 (OS)");
        weaponType.addLookupName("IS MRM 10 (OS)");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 10;
        weaponType.ammoType = 12;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 3.5f;
        weaponType.criticals = 2;
        weaponType.bv = 11.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 50000.0;
        return weaponType;
    }

    private static WeaponType createISMRM20OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MRM 20 (OS)";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("OS MRM-20");
        weaponType.addLookupName("ISMRM20 (OS)");
        weaponType.addLookupName("IS MRM 20 (OS)");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 20;
        weaponType.ammoType = 12;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 7.5f;
        weaponType.criticals = 3;
        weaponType.bv = 22.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 125000.0;
        return weaponType;
    }

    private static WeaponType createISMRM30OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MRM 30 (OS)";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("OS MRM-30");
        weaponType.addLookupName("ISMRM30 (OS)");
        weaponType.addLookupName("IS MRM 30 (OS)");
        weaponType.heat = 10;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 30;
        weaponType.ammoType = 12;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 10.5f;
        weaponType.criticals = 5;
        weaponType.bv = 34.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 225000.0;
        return weaponType;
    }

    private static WeaponType createISMRM40OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MRM 40 (OS)";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("OS MRM-40");
        weaponType.addLookupName("ISMRM40 (OS)");
        weaponType.addLookupName("IS MRM 40 (OS)");
        weaponType.heat = 12;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 40;
        weaponType.ammoType = 12;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 12.5f;
        weaponType.criticals = 7;
        weaponType.bv = 49.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 250000.0;
        return weaponType;
    }

    private static WeaponType createISAMS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "AMS";
        weaponType.setInternalName("ISAntiMissileSystem");
        weaponType.addLookupName("IS Anti-Missile System");
        weaponType.addLookupName("IS AMS");
        weaponType.addLookupName("IS Anti-Missile Syst");
        weaponType.heat = 1;
        weaponType.rackSize = 2;
        weaponType.damage = 1;
        weaponType.ammoType = 14;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.bv = 32.0;
        weaponType.flags |= 0x1000010L;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createISLaserAMS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Laser AMS";
        weaponType.setInternalName("ISLaserAntiMissileSystem");
        weaponType.addLookupName("IS Laser Anti-Missile System");
        weaponType.addLookupName("IS Laser AMS");
        weaponType.heat = 2;
        weaponType.rackSize = 2;
        weaponType.damage = 2;
        weaponType.ammoType = -1;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 2;
        weaponType.bv = 105.0;
        weaponType.flags |= 0x1840010L;
        weaponType.cost = 225000.0;
        return weaponType;
    }

    private static WeaponType createISLaserAMSTHB() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Laser AMS (THB)";
        weaponType.setInternalName("ISLaserAntiMissileSystemTHB");
        weaponType.addLookupName("IS Laser Anti-Missile System (THB)");
        weaponType.addLookupName("IS Laser AMS (THB)");
        weaponType.heat = 3;
        weaponType.rackSize = 2;
        weaponType.damage = 2;
        weaponType.ammoType = -1;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 2;
        weaponType.bv = 105.0;
        weaponType.flags |= 0x1840010L;
        weaponType.cost = 300000.0;
        return weaponType;
    }

    private static WeaponType createISNarc() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Narc";
        weaponType.setInternalName("ISNarcBeacon");
        weaponType.addLookupName("IS Narc Beacon");
        weaponType.addLookupName("IS Narc Missile Beacon");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 13;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 2;
        weaponType.bv = 30.0;
        weaponType.flags |= 0x80020L;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createISNarcOS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Narc (OS)";
        weaponType.setInternalName("ISNarcBeacon (OS)");
        weaponType.addLookupName("IS OS Narc Beacon");
        weaponType.addLookupName("IS Narc Missile Beacon (OS)");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 13;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 3.5f;
        weaponType.criticals = 2;
        weaponType.bv = 6.0;
        weaponType.flags |= 0x88020L;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createISImprovedNarc() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "iNarc";
        weaponType.setInternalName("ISImprovedNarc");
        weaponType.addLookupName("IS iNarc Beacon");
        weaponType.addLookupName("IS iNarc Missile Beacon");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 31;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 9;
        weaponType.longRange = 15;
        weaponType.extremeRange = 18;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 3;
        weaponType.bv = 75.0;
        weaponType.flags |= 0x80020L;
        weaponType.cost = 250000.0;
        return weaponType;
    }

    private static WeaponType createISImprovedNarcOS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "iNarc (OS)";
        weaponType.setInternalName("ISImprovedNarc (OS)");
        weaponType.addLookupName("IS OS iNarc Beacon");
        weaponType.addLookupName("IS iNarc Missile Beacon (OS)");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 31;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 9;
        weaponType.longRange = 15;
        weaponType.extremeRange = 18;
        weaponType.tonnage = 5.5f;
        weaponType.criticals = 2;
        weaponType.bv = 15.0;
        weaponType.flags |= 0x88020L;
        weaponType.cost = 250000.0;
        return weaponType;
    }

    private static WeaponType createCLERPPC() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "ER PPC";
        weaponType.setInternalName("CLERPPC");
        weaponType.addLookupName("Clan ER PPC");
        weaponType.heat = 15;
        weaponType.damage = 15;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 23;
        weaponType.extremeRange = 28;
        weaponType.waterShortRange = 4;
        weaponType.waterMediumRange = 10;
        weaponType.waterLongRange = 16;
        weaponType.waterExtremeRange = 20;
        weaponType.tonnage = 6.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 0x80040009L;
        weaponType.bv = 412.0;
        weaponType.cost = 300000.0;
        weaponType.setModes(new String[]{"Field Inhibitor ON", "Field Inhibitor OFF"});
        return weaponType;
    }

    private static WeaponType createCLERLargeLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "ER Large Laser";
        weaponType.setInternalName("CLERLargeLaser");
        weaponType.addLookupName("Clan ER Large Laser");
        weaponType.heat = 12;
        weaponType.damage = 10;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 8;
        weaponType.mediumRange = 15;
        weaponType.longRange = 25;
        weaponType.extremeRange = 30;
        weaponType.waterShortRange = 5;
        weaponType.waterMediumRange = 10;
        weaponType.waterLongRange = 16;
        weaponType.waterExtremeRange = 20;
        weaponType.tonnage = 4.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80040005L;
        weaponType.bv = 248.0;
        weaponType.cost = 200000.0;
        return weaponType;
    }

    private static WeaponType createCLERMediumLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "ER Medium Laser";
        weaponType.setInternalName("CLERMediumLaser");
        weaponType.addLookupName("Clan ER Medium Laser");
        weaponType.heat = 5;
        weaponType.damage = 7;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 7;
        weaponType.waterLongRange = 10;
        weaponType.waterExtremeRange = 14;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80040005L;
        weaponType.bv = 108.0;
        weaponType.cost = 80000.0;
        return weaponType;
    }

    private static WeaponType createCLERSmallLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "ER Small Laser";
        weaponType.setInternalName("CLERSmallLaser");
        weaponType.addLookupName("Clan ER Small Laser");
        weaponType.heat = 2;
        weaponType.damage = 5;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 4;
        weaponType.waterExtremeRange = 4;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80040025L;
        weaponType.bv = 31.0;
        weaponType.cost = 11250.0;
        return weaponType;
    }

    private static WeaponType createCLERMicroLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "ER Micro Laser";
        weaponType.setInternalName("CLERMicroLaser");
        weaponType.addLookupName("Clan ER Micro Laser");
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 4;
        weaponType.extremeRange = 4;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 2;
        weaponType.waterExtremeRange = 4;
        weaponType.tonnage = 0.25f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80040025L;
        weaponType.bv = 7.0;
        weaponType.cost = 10000.0;
        return weaponType;
    }

    private static WeaponType createCLFlamer() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Flamer";
        weaponType.setInternalName("CLFlamer");
        weaponType.addLookupName("Clan Flamer");
        weaponType.heat = 3;
        weaponType.damage = 2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x200040002L;
        weaponType.bv = 6.0;
        String[] stringArray = new String[]{"Damage", "Heat"};
        weaponType.setModes(stringArray);
        weaponType.cost = 7500.0;
        return weaponType;
    }

    private static WeaponType createCLVehicleFlamer() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Vehicle Flamer";
        weaponType.setInternalName("CLVehicleFlamer");
        weaponType.addLookupName("Clan Vehicle Flamer");
        weaponType.heat = 3;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 2;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x200020002L;
        weaponType.bv = 5.0;
        String[] stringArray = new String[]{"Damage", "Heat", "Cool"};
        weaponType.setModes(stringArray);
        weaponType.cost = 7500.0;
        return weaponType;
    }

    private static WeaponType createCLHeavyLargeLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Heavy Large Laser";
        weaponType.setInternalName("CLHeavyLargeLaser");
        weaponType.addLookupName("Clan Large Heavy Laser");
        weaponType.heat = 18;
        weaponType.damage = 16;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 6;
        weaponType.waterLongRange = 9;
        weaponType.waterExtremeRange = 12;
        weaponType.tonnage = 4.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 0x80040005L;
        weaponType.bv = 244.0;
        weaponType.cost = 250000.0;
        return weaponType;
    }

    private static WeaponType createCLHeavyMediumLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Heavy Medium Laser";
        weaponType.setInternalName("CLHeavyMediumLaser");
        weaponType.addLookupName("Clan Medium Heavy Laser");
        weaponType.heat = 7;
        weaponType.damage = 10;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.waterShortRange = 2;
        weaponType.waterMediumRange = 4;
        weaponType.waterLongRange = 6;
        weaponType.waterExtremeRange = 8;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 0x80040005L;
        weaponType.bv = 76.0;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createCLHeavySmallLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Heavy Small Laser";
        weaponType.setInternalName("CLHeavySmallLaser");
        weaponType.addLookupName("Clan Small Heavy Laser");
        weaponType.heat = 3;
        weaponType.damage = 6;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 2;
        weaponType.waterExtremeRange = 4;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80040005L;
        weaponType.bv = 15.0;
        weaponType.cost = 20000.0;
        return weaponType;
    }

    private static WeaponType createCLMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Machine Gun";
        weaponType.setInternalName("CLMG");
        weaponType.addLookupName("Clan Machine Gun");
        weaponType.heat = 0;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 3;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.25f;
        weaponType.criticals = 1;
        weaponType.bv = 5.0;
        weaponType.flags |= 0x200020200L;
        weaponType.cost = 5000.0;
        return weaponType;
    }

    private static WeaponType createCLLightMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Light Machine Gun";
        weaponType.setInternalName("CLLightMG");
        weaponType.addLookupName("Clan Light Machine Gun");
        weaponType.heat = 0;
        weaponType.damage = 1;
        weaponType.rackSize = 1;
        weaponType.ammoType = 5;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 0.25f;
        weaponType.criticals = 1;
        weaponType.bv = 5.0;
        weaponType.flags |= 0x200020200L;
        weaponType.cost = 5000.0;
        return weaponType;
    }

    private static WeaponType createCLHeavyMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Heavy Machine Gun";
        weaponType.setInternalName("CLHeavyMG");
        weaponType.addLookupName("Clan Heavy Machine Gun");
        weaponType.heat = 0;
        weaponType.damage = 3;
        weaponType.rackSize = 3;
        weaponType.ammoType = 4;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 2;
        weaponType.extremeRange = 2;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.bv = 6.0;
        weaponType.flags |= 0x200020200L;
        weaponType.cost = 7500.0;
        return weaponType;
    }

    private static WeaponType createCLLRT5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 5";
        weaponType.setInternalName("CLLRTorpedo5");
        weaponType.addLookupName("Clan LRTorpedo-5");
        weaponType.addLookupName("Clan LRTorpedo 5");
        weaponType.addLookupName("CLLRT5");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.bv = 55.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 30000.0;
        return weaponType;
    }

    private static WeaponType createCLLRT10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 10";
        weaponType.setInternalName("CLLRTorpedo10");
        weaponType.addLookupName("Clan LRTorpedo-10");
        weaponType.addLookupName("Clan LRTorpedo 10");
        weaponType.addLookupName("CLLRT10");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 10;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 2.5f;
        weaponType.criticals = 1;
        weaponType.bv = 109.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createCLLRT15() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 15";
        weaponType.setInternalName("CLLRTorpedo15");
        weaponType.addLookupName("Clan LRTorpedo-15");
        weaponType.addLookupName("Clan LRTorpedo 15");
        weaponType.addLookupName("CLLRT15");
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.rackSize = 15;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 3.5f;
        weaponType.criticals = 2;
        weaponType.bv = 164.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 175000.0;
        return weaponType;
    }

    private static WeaponType createCLLRT20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 20";
        weaponType.setInternalName("CLLRTorpedo20");
        weaponType.addLookupName("Clan LRTorpedo-20");
        weaponType.addLookupName("Clan LRTorpedo 20");
        weaponType.addLookupName("CLLRT20");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.rackSize = 20;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 4;
        weaponType.bv = 220.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 250000.0;
        return weaponType;
    }

    private static WeaponType createCLLRT5OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 5 (OS)";
        weaponType.setInternalName("CLLRTorpedo5 (OS)");
        weaponType.addLookupName("Clan OS LRTorpedo-5");
        weaponType.addLookupName("Clan LRTorpedo 5 (OS)");
        weaponType.addLookupName("CLLRT5 (OS)");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 1;
        weaponType.bv = 11.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 30000.0;
        return weaponType;
    }

    private static WeaponType createCLLRT10OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 10 (OS)";
        weaponType.setInternalName("CLLRTorpedo10 (OS)");
        weaponType.addLookupName("Clan OS LRTorpedo-10");
        weaponType.addLookupName("Clan LTorpedoM 10 (OS)");
        weaponType.addLookupName("CLLRT10 (OS)");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 10;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 1;
        weaponType.bv = 22.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createCLLRT15OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 15 (OS)";
        weaponType.setInternalName("CLLRTorpedo15 (OS)");
        weaponType.addLookupName("Clan OS LRTorpedo-15");
        weaponType.addLookupName("Clan LRTorpedo 15 (OS)");
        weaponType.addLookupName("CLLRT15 (OS)");
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.rackSize = 15;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 4.0f;
        weaponType.criticals = 2;
        weaponType.bv = 33.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 175000.0;
        return weaponType;
    }

    private static WeaponType createCLLRT20OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 20 (OS)";
        weaponType.setInternalName("CLLRTorpedo20 (OS)");
        weaponType.addLookupName("Clan OS LRTorpedo-20");
        weaponType.addLookupName("Clan LRTorpedo 20 (OS)");
        weaponType.addLookupName("CLLRT20 (OS)");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.rackSize = 20;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 5.5f;
        weaponType.criticals = 4;
        weaponType.bv = 44.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 200000.0;
        return weaponType;
    }

    private static WeaponType createCLSRT2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRT 2";
        weaponType.setInternalName("CLSRTorpedo2");
        weaponType.addLookupName("Clan SRTorpedo-2");
        weaponType.addLookupName("Clan SRTorpedo 2");
        weaponType.addLookupName("CLSRT2");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 6;
        weaponType.waterLongRange = 9;
        weaponType.waterExtremeRange = 12;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80020L;
        weaponType.bv = 21.0;
        weaponType.cost = 10000.0;
        return weaponType;
    }

    private static WeaponType createCLSRT4() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRT 4";
        weaponType.setInternalName("CLSRTorpedo4");
        weaponType.addLookupName("Clan SRTorpedo-4");
        weaponType.addLookupName("Clan SRTorpedo 4");
        weaponType.addLookupName("CLSRT4");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 6;
        weaponType.waterLongRange = 9;
        weaponType.waterExtremeRange = 12;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.bv = 39.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 60000.0;
        return weaponType;
    }

    private static WeaponType createCLSRT6() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRT 6";
        weaponType.setInternalName("CLSRTorpedo6");
        weaponType.addLookupName("Clan SRTorpedo-6");
        weaponType.addLookupName("Clan SRTorpedo 6");
        weaponType.addLookupName("CLSRT6");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 6;
        weaponType.waterLongRange = 9;
        weaponType.waterExtremeRange = 12;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 1;
        weaponType.bv = 59.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 80000.0;
        return weaponType;
    }

    private static WeaponType createCLSRT2OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRT 2 (OS)";
        weaponType.setInternalName("CLSRTorpedo2 (OS)");
        weaponType.addLookupName("Clan OS SRTorpedo-2");
        weaponType.addLookupName("Clan SRTorpedo 2 (OS)");
        weaponType.addLookupName("CLSRT2 (OS)");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 6;
        weaponType.waterLongRange = 9;
        weaponType.waterExtremeRange = 12;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x88020L;
        weaponType.bv = 4.0;
        weaponType.cost = 10000.0;
        return weaponType;
    }

    private static WeaponType createCLSRT4OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRT 4 (OS)";
        weaponType.setInternalName("CLSRTorpedo4 (OS)");
        weaponType.addLookupName("Clan OS SRTorpedo-4");
        weaponType.addLookupName("Clan SRTorpedo 4 (OS)");
        weaponType.addLookupName("CLSRT4 (OS)");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 6;
        weaponType.waterLongRange = 9;
        weaponType.waterExtremeRange = 12;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 1;
        weaponType.bv = 8.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 60000.0;
        return weaponType;
    }

    private static WeaponType createCLSRT6OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRT 6 (OS)";
        weaponType.setInternalName("CLSRTorpedo6 (OS)");
        weaponType.addLookupName("Clan OS SRTorpedo-6");
        weaponType.addLookupName("Clan SRTorpedo 6 (OS)");
        weaponType.addLookupName("CLSRT6 (OS)");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 6;
        weaponType.waterLongRange = 9;
        weaponType.waterExtremeRange = 12;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.bv = 12.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 80000.0;
        return weaponType;
    }

    private static WeaponType createCLLRM5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 5";
        weaponType.setInternalName("CLLRM5");
        weaponType.addLookupName("Clan LRM-5");
        weaponType.addLookupName("Clan LRM 5");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.bv = 55.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 30000.0;
        return weaponType;
    }

    private static WeaponType createCLLRM10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 10";
        weaponType.setInternalName("CLLRM10");
        weaponType.addLookupName("Clan LRM-10");
        weaponType.addLookupName("Clan LRM 10");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 10;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 2.5f;
        weaponType.criticals = 1;
        weaponType.bv = 109.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createCLLRM15() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 15";
        weaponType.setInternalName("CLLRM15");
        weaponType.addLookupName("Clan LRM-15");
        weaponType.addLookupName("Clan LRM 15");
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.rackSize = 15;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 3.5f;
        weaponType.criticals = 2;
        weaponType.bv = 164.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 175000.0;
        return weaponType;
    }

    private static WeaponType createCLLRM20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 20";
        weaponType.setInternalName("CLLRM20");
        weaponType.addLookupName("Clan LRM-20");
        weaponType.addLookupName("Clan LRM 20");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.rackSize = 20;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 4;
        weaponType.bv = 220.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 250000.0;
        return weaponType;
    }

    private static WeaponType createCLLRM5OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 5 (OS)";
        weaponType.setInternalName("CLLRM5 (OS)");
        weaponType.addLookupName("Clan OS LRM-5");
        weaponType.addLookupName("Clan LRM 5 (OS)");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 1;
        weaponType.bv = 11.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 30000.0;
        return weaponType;
    }

    private static WeaponType createCLLRM10OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 10 (OS)";
        weaponType.setInternalName("CLLRM10 (OS)");
        weaponType.addLookupName("Clan OS LRM-10");
        weaponType.addLookupName("Clan LRM 10 (OS)");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 10;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 1;
        weaponType.bv = 22.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createCLLRM15OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 15 (OS)";
        weaponType.setInternalName("CLLRM15 (OS)");
        weaponType.addLookupName("Clan OS LRM-15");
        weaponType.addLookupName("Clan LRM 15 (OS)");
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.rackSize = 15;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 4.0f;
        weaponType.criticals = 2;
        weaponType.bv = 33.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 175000.0;
        return weaponType;
    }

    private static WeaponType createCLLRM20OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 20 (OS)";
        weaponType.setInternalName("CLLRM20 (OS)");
        weaponType.addLookupName("Clan OS LRM-20");
        weaponType.addLookupName("Clan LRM 20 (OS)");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.rackSize = 20;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 5.5f;
        weaponType.criticals = 4;
        weaponType.bv = 44.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x88000L;
        weaponType.cost = 250000.0;
        return weaponType;
    }

    private static WeaponType createCLSRM2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRM 2";
        weaponType.setInternalName("CLSRM2");
        weaponType.addLookupName("Clan SRM-2");
        weaponType.addLookupName("Clan SRM 2");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80020L;
        weaponType.bv = 21.0;
        weaponType.cost = 10000.0;
        return weaponType;
    }

    private static WeaponType createCLSRM4() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRM 4";
        weaponType.setInternalName("CLSRM4");
        weaponType.addLookupName("Clan SRM-4");
        weaponType.addLookupName("Clan SRM 4");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.bv = 39.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 60000.0;
        return weaponType;
    }

    private static WeaponType createCLSRM6() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRM 6";
        weaponType.setInternalName("CLSRM6");
        weaponType.addLookupName("Clan SRM-6");
        weaponType.addLookupName("Clan SRM 6");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 1;
        weaponType.bv = 59.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 80000.0;
        return weaponType;
    }

    private static WeaponType createCLSRM2OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRM 2 (OS)";
        weaponType.setInternalName("CLSRM2 (OS)");
        weaponType.addLookupName("Clan OS SRM-2");
        weaponType.addLookupName("Clan SRM 2 (OS)");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x88020L;
        weaponType.bv = 4.0;
        weaponType.cost = 10000.0;
        return weaponType;
    }

    private static WeaponType createCLSRM4OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRM 4 (OS)";
        weaponType.setInternalName("CLSRM4 (OS)");
        weaponType.addLookupName("Clan OS SRM-4");
        weaponType.addLookupName("Clan SRM 4 (OS)");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 1;
        weaponType.bv = 8.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 60000.0;
        return weaponType;
    }

    private static WeaponType createCLSRM6OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRM 6 (OS)";
        weaponType.setInternalName("CLSRM6 (OS)");
        weaponType.addLookupName("Clan OS SRM-6");
        weaponType.addLookupName("Clan SRM 6 (OS)");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.bv = 12.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 80000.0;
        return weaponType;
    }

    private static WeaponType createCLLargePulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Large Pulse Laser";
        weaponType.setInternalName("CLLargePulseLaser");
        weaponType.addLookupName("Clan Pulse Large Laser");
        weaponType.addLookupName("Clan Large Pulse Laser");
        weaponType.heat = 10;
        weaponType.damage = 10;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 14;
        weaponType.longRange = 20;
        weaponType.extremeRange = 28;
        weaponType.waterShortRange = 4;
        weaponType.waterMediumRange = 10;
        weaponType.waterLongRange = 14;
        weaponType.waterExtremeRange = 20;
        weaponType.tonnage = 6.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 0x100040005L;
        weaponType.bv = 265.0;
        weaponType.cost = 175000.0;
        return weaponType;
    }

    private static WeaponType createCLMediumPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Medium Pulse Laser";
        weaponType.setInternalName("CLMediumPulseLaser");
        weaponType.addLookupName("Clan Pulse Med Laser");
        weaponType.addLookupName("Clan Medium Pulse Laser");
        weaponType.heat = 4;
        weaponType.damage = 7;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 5;
        weaponType.waterLongRange = 8;
        weaponType.waterExtremeRange = 10;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x100040005L;
        weaponType.bv = 111.0;
        weaponType.cost = 60000.0;
        return weaponType;
    }

    private static WeaponType createCLSmallPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Small Pulse Laser";
        weaponType.setInternalName("CLSmallPulseLaser");
        weaponType.addLookupName("Clan Pulse Small Laser");
        weaponType.addLookupName("Clan Small Pulse Laser");
        weaponType.heat = 2;
        weaponType.damage = 3;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 4;
        weaponType.waterExtremeRange = 4;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x300040005L;
        weaponType.bv = 24.0;
        weaponType.cost = 16000.0;
        return weaponType;
    }

    private static WeaponType createCLERLargePulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "ER Large Pulse Laser";
        weaponType.setInternalName("CLERLargePulseLaser");
        weaponType.addLookupName("Clan ER Pulse Large Laser");
        weaponType.addLookupName("Clan ER Large Pulse Laser");
        weaponType.heat = 13;
        weaponType.damage = 10;
        weaponType.toHitModifier = -1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 15;
        weaponType.longRange = 23;
        weaponType.extremeRange = 30;
        weaponType.waterShortRange = 4;
        weaponType.waterMediumRange = 10;
        weaponType.waterLongRange = 14;
        weaponType.waterExtremeRange = 20;
        weaponType.tonnage = 6.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 0x100040005L;
        weaponType.bv = 246.0;
        weaponType.cost = 400000.0;
        return weaponType;
    }

    private static WeaponType createCLERMediumPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "ER Medium Pulse Laser";
        weaponType.setInternalName("CLERMediumPulseLaser");
        weaponType.addLookupName("Clan ER Pulse Med Laser");
        weaponType.addLookupName("Clan ER Medium Pulse Laser");
        weaponType.heat = 6;
        weaponType.damage = 7;
        weaponType.toHitModifier = -1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 9;
        weaponType.longRange = 14;
        weaponType.extremeRange = 18;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 5;
        weaponType.waterLongRange = 8;
        weaponType.waterExtremeRange = 10;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 0x100040005L;
        weaponType.bv = 116.0;
        weaponType.cost = 150000.0;
        return weaponType;
    }

    private static WeaponType createCLERSmallPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "ER Small Pulse Laser";
        weaponType.setInternalName("CLERSmallPulseLaser");
        weaponType.addLookupName("Clan ER Pulse Small Laser");
        weaponType.addLookupName("Clan ER Small Pulse Laser");
        weaponType.heat = 3;
        weaponType.damage = 5;
        weaponType.toHitModifier = -1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 4;
        weaponType.waterExtremeRange = 4;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x300040005L;
        weaponType.bv = 36.0;
        weaponType.cost = 30000.0;
        return weaponType;
    }

    private static WeaponType createCLMicroPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Micro Pulse Laser";
        weaponType.setInternalName("CLMicroPulseLaser");
        weaponType.addLookupName("Clan Micro Pulse Laser");
        weaponType.heat = 1;
        weaponType.damage = 3;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 2;
        weaponType.waterExtremeRange = 4;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x300040025L;
        weaponType.bv = 12.0;
        weaponType.cost = 12500.0;
        return weaponType;
    }

    private static WeaponType createCLLBXAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LB 2-X AC";
        weaponType.setInternalName("CLLBXAC2");
        weaponType.addLookupName("Clan LB 2-X AC");
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 19;
        weaponType.minimumRange = 4;
        weaponType.shortRange = 10;
        weaponType.mediumRange = 20;
        weaponType.longRange = 30;
        weaponType.extremeRange = 40;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 47.0;
        weaponType.cost = 150000.0;
        return weaponType;
    }

    private static WeaponType createCLLBXAC5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LB 5-X AC";
        weaponType.setInternalName("CLLBXAC5");
        weaponType.addLookupName("Clan LB 5-X AC");
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 19;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 8;
        weaponType.mediumRange = 15;
        weaponType.longRange = 24;
        weaponType.extremeRange = 30;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 4;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 93.0;
        weaponType.cost = 250000.0;
        return weaponType;
    }

    private static WeaponType createCLLBXAC10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LB 10-X AC";
        weaponType.setInternalName("CLLBXAC10");
        weaponType.addLookupName("Clan LB 10-X AC");
        weaponType.heat = 2;
        weaponType.damage = 10;
        weaponType.rackSize = 10;
        weaponType.ammoType = 19;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 5;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 148.0;
        weaponType.cost = 400000.0;
        return weaponType;
    }

    private static WeaponType createCLLBXAC20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LB 20-X AC";
        weaponType.setInternalName("CLLBXAC20");
        weaponType.addLookupName("Clan LB 20-X AC");
        weaponType.heat = 6;
        weaponType.damage = 20;
        weaponType.rackSize = 20;
        weaponType.ammoType = 19;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 12.0f;
        weaponType.criticals = 9;
        weaponType.flags |= 0x20101L;
        weaponType.bv = 237.0;
        weaponType.cost = 600000.0;
        return weaponType;
    }

    private static WeaponType createCLGaussRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Gauss Rifle";
        weaponType.setInternalName("CLGaussRifle");
        weaponType.addLookupName("Clan Gauss Rifle");
        weaponType.heat = 1;
        weaponType.damage = 15;
        weaponType.ammoType = 6;
        weaponType.minimumRange = 2;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 15;
        weaponType.longRange = 22;
        weaponType.extremeRange = 30;
        weaponType.tonnage = 12.0f;
        weaponType.criticals = 6;
        weaponType.flags |= 0x80020021L;
        weaponType.explosive = true;
        weaponType.bv = 320.0;
        weaponType.cost = 300000.0;
        return weaponType;
    }

    private static WeaponType createCLUltraAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Ultra AC/2";
        weaponType.setInternalName("CLUltraAC2");
        weaponType.addLookupName("Clan Ultra AC/2");
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 20;
        weaponType.minimumRange = 2;
        weaponType.shortRange = 9;
        weaponType.mediumRange = 18;
        weaponType.longRange = 27;
        weaponType.extremeRange = 36;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 62.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        weaponType.cost = 120000.0;
        return weaponType;
    }

    private static WeaponType createCLUltraAC5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Ultra AC/5";
        weaponType.setInternalName("CLUltraAC5");
        weaponType.addLookupName("Clan Ultra AC/5");
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 20;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 122.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        weaponType.cost = 200000.0;
        return weaponType;
    }

    private static WeaponType createCLUltraAC10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Ultra AC/10";
        weaponType.setInternalName("CLUltraAC10");
        weaponType.addLookupName("Clan Ultra AC/10");
        weaponType.heat = 3;
        weaponType.damage = 10;
        weaponType.rackSize = 10;
        weaponType.ammoType = 20;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 4;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 210.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        weaponType.cost = 320000.0;
        return weaponType;
    }

    private static WeaponType createCLUltraAC20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Ultra AC/20";
        weaponType.setInternalName("CLUltraAC20");
        weaponType.addLookupName("Clan Ultra AC/20");
        weaponType.heat = 7;
        weaponType.damage = 20;
        weaponType.rackSize = 20;
        weaponType.ammoType = 20;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 12.0f;
        weaponType.criticals = 8;
        weaponType.flags |= 0x20101L;
        weaponType.bv = 335.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        weaponType.cost = 480000.0;
        return weaponType;
    }

    private static WeaponType createCLRAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "Rotary AC/2";
        weaponType.setInternalName("CLRotaryAC2");
        weaponType.addLookupName("Clan Rotary AC/2");
        weaponType.addLookupName("Clan Rotary Assault Cannon/2");
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 23;
        weaponType.minimumRange = 2;
        weaponType.shortRange = 9;
        weaponType.mediumRange = 18;
        weaponType.longRange = 27;
        weaponType.extremeRange = 36;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 4;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 185.0;
        String[] stringArray = new String[]{"Single", "2-shot", "3-shot", "4-shot", "5-shot", "6-shot"};
        weaponType.setModes(stringArray);
        weaponType.cost = 240000.0;
        return weaponType;
    }

    private static WeaponType createCLRAC5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "Rotary AC/5";
        weaponType.setInternalName("CLRotaryAC5");
        weaponType.addLookupName("Clan Rotary AC/5");
        weaponType.addLookupName("Clan Rotary Assault Cannon/5");
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 23;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 5;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 360.0;
        String[] stringArray = new String[]{"Single", "2-shot", "3-shot", "4-shot", "5-shot", "6-shot"};
        weaponType.setModes(stringArray);
        weaponType.cost = 400000.0;
        return weaponType;
    }

    private static WeaponType createCLRAC10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "Rotary AC/10";
        weaponType.setInternalName("CLRotaryAC10");
        weaponType.addLookupName("Clan Rotary AC/10");
        weaponType.addLookupName("Clan Rotary Assault Cannon/10");
        weaponType.heat = 3;
        weaponType.damage = 10;
        weaponType.rackSize = 10;
        weaponType.ammoType = 23;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.tonnage = 14.0f;
        weaponType.criticals = 7;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 617.0;
        String[] stringArray = new String[]{"Single", "2-shot", "3-shot", "4-shot", "5-shot", "6-shot"};
        weaponType.setModes(stringArray);
        weaponType.cost = 640000.0;
        return weaponType;
    }

    private static WeaponType createCLRAC20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "Rotary AC/20";
        weaponType.setInternalName("CLRotaryAC20");
        weaponType.addLookupName("Clan Rotary AC/20");
        weaponType.addLookupName("Clan Rotary Assault Cannon/20");
        weaponType.heat = 7;
        weaponType.damage = 20;
        weaponType.rackSize = 20;
        weaponType.ammoType = 23;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 16.0f;
        weaponType.criticals = 10;
        weaponType.flags |= 0x20101L;
        weaponType.bv = 823.0;
        String[] stringArray = new String[]{"Single", "2-shot", "3-shot", "4-shot", "5-shot", "6-shot"};
        weaponType.setModes(stringArray);
        weaponType.cost = 960000.0;
        return weaponType;
    }

    private static WeaponType createCLStreakSRM2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Streak SRM 2";
        weaponType.setInternalName("CLStreakSRM2");
        weaponType.addLookupName("Clan Streak SRM-2");
        weaponType.addLookupName("Clan Streak SRM 2");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 11;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80020L;
        weaponType.bv = 40.0;
        weaponType.cost = 15000.0;
        return weaponType;
    }

    private static WeaponType createCLStreakSRM4() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Streak SRM 4";
        weaponType.setInternalName("CLStreakSRM4");
        weaponType.addLookupName("Clan Streak SRM-4");
        weaponType.addLookupName("Clan Streak SRM 4");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 11;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.bv = 79.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 90000.0;
        return weaponType;
    }

    private static WeaponType createCLStreakSRM6() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Streak SRM 6";
        weaponType.setInternalName("CLStreakSRM6");
        weaponType.addLookupName("Clan Streak SRM-6");
        weaponType.addLookupName("Clan Streak SRM 6");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 11;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 2;
        weaponType.bv = 118.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 120000.0;
        return weaponType;
    }

    private static WeaponType createCLStreakSRM2OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Streak SRM 2 (OS)";
        weaponType.setInternalName("CLStreakSRM2 (OS)");
        weaponType.addLookupName("Clan OS Streak SRM-2");
        weaponType.addLookupName("Clan Streak SRM 2 (OS)");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 11;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x88020L;
        weaponType.bv = 8.0;
        weaponType.cost = 15000.0;
        return weaponType;
    }

    private static WeaponType createCLStreakSRM4OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Streak SRM 4 (OS)";
        weaponType.setInternalName("CLStreakSRM4 (OS)");
        weaponType.addLookupName("Clan OS Streak SRM-4");
        weaponType.addLookupName("Clan Streak SRM 4 (OS)");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 11;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 2.5f;
        weaponType.criticals = 1;
        weaponType.bv = 16.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 90000.0;
        return weaponType;
    }

    private static WeaponType createCLStreakSRM6OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Streak SRM 6 (OS)";
        weaponType.setInternalName("CLStreakSRM6 (OS)");
        weaponType.addLookupName("Clan OS Streak SRM-6");
        weaponType.addLookupName("Clan Streak SRM 6 (OS)");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 11;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 3.5f;
        weaponType.criticals = 2;
        weaponType.bv = 24.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 120000.0;
        return weaponType;
    }

    private static WeaponType createISMML3() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MML 3";
        weaponType.setInternalName("ISMML3");
        weaponType.addLookupName("IS MML-3");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 3;
        weaponType.ammoType = 50;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 2;
        weaponType.bv = 29.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 50000.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createISMML5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MML 5";
        weaponType.setInternalName("ISMML5");
        weaponType.addLookupName("IS MML-5");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 50;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 3;
        weaponType.bv = 45.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 90000.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createISMML7() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MML 7";
        weaponType.setInternalName("ISMML7");
        weaponType.addLookupName("IS MML-7");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 7;
        weaponType.ammoType = 50;
        weaponType.tonnage = 4.5f;
        weaponType.criticals = 4;
        weaponType.bv = 67.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 160000.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createISMML9() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MML 9";
        weaponType.setInternalName("ISMML9");
        weaponType.addLookupName("IS MML-9");
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.rackSize = 9;
        weaponType.ammoType = 50;
        weaponType.tonnage = 6.0f;
        weaponType.criticals = 5;
        weaponType.bv = 86.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 225000.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLATM3() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "ATM 3";
        weaponType.setInternalName("CLATM3");
        weaponType.addLookupName("Clan ATM-3");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 3;
        weaponType.ammoType = 29;
        weaponType.minimumRange = 4;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 2;
        weaponType.bv = 53.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 50000.0;
        return weaponType;
    }

    private static WeaponType createCLATM6() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "ATM 6";
        weaponType.setInternalName("CLATM6");
        weaponType.addLookupName("Clan ATM-6");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 29;
        weaponType.minimumRange = 4;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        weaponType.tonnage = 3.5f;
        weaponType.criticals = 3;
        weaponType.bv = 105.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 125000.0;
        return weaponType;
    }

    private static WeaponType createCLATM9() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "ATM 9";
        weaponType.setInternalName("CLATM9");
        weaponType.addLookupName("Clan ATM-9");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.rackSize = 9;
        weaponType.ammoType = 29;
        weaponType.minimumRange = 4;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 4;
        weaponType.bv = 147.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 225000.0;
        return weaponType;
    }

    private static WeaponType createCLATM12() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "ATM 12";
        weaponType.setInternalName("CLATM12");
        weaponType.addLookupName("Clan ATM-12");
        weaponType.heat = 8;
        weaponType.damage = -2;
        weaponType.rackSize = 12;
        weaponType.ammoType = 29;
        weaponType.minimumRange = 4;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 5;
        weaponType.bv = 212.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 350000.0;
        return weaponType;
    }

    private static WeaponType createCLStreakLRM5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "Streak LRM 5";
        weaponType.setInternalName("CLStreakLRM5");
        weaponType.addLookupName("Clan Streak LRM-5");
        weaponType.addLookupName("Clan Streak LRM 5");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 32;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.bv = 87.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 75000.0;
        return weaponType;
    }

    private static WeaponType createCLStreakLRM10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "Streak LRM 10";
        weaponType.setInternalName("CLStreakLRM10");
        weaponType.addLookupName("Clan Streak LRM-10");
        weaponType.addLookupName("Clan Streak LRM 10");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 10;
        weaponType.ammoType = 32;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 2;
        weaponType.bv = 173.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 225000.0;
        return weaponType;
    }

    private static WeaponType createCLStreakLRM15() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "Streak LRM 15";
        weaponType.setInternalName("CLStreakLRM15");
        weaponType.addLookupName("Clan Streak LRM-15");
        weaponType.addLookupName("Clan Streak LRM 15");
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.rackSize = 15;
        weaponType.ammoType = 32;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.bv = 260.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 400000.0;
        return weaponType;
    }

    private static WeaponType createCLStreakLRM20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "Streak LRM 20";
        weaponType.setInternalName("CLStreakLRM20");
        weaponType.addLookupName("Clan Streak LRM-20");
        weaponType.addLookupName("Clan Streak LRM 20");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.rackSize = 20;
        weaponType.ammoType = 32;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 5;
        weaponType.bv = 346.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 600000.0;
        return weaponType;
    }

    private static WeaponType createCLStreakLRM5OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "Streak LRM 5 (OS)";
        weaponType.setInternalName("CLOSStreakLRM5");
        weaponType.addLookupName("Clan Streak LRM-5 (OS)");
        weaponType.addLookupName("Clan Streak LRM 5 (OS)");
        weaponType.addLookupName("CLStreakLRM5 (OS)");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 32;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 2.5f;
        weaponType.criticals = 1;
        weaponType.bv = 87.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 75000.0;
        return weaponType;
    }

    private static WeaponType createCLStreakLRM10OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "Streak LRM 10 (OS)";
        weaponType.setInternalName("CLOSStreakLRM10");
        weaponType.addLookupName("Clan Streak LRM-10 (OS)");
        weaponType.addLookupName("Clan Streak LRM 10 (OS)");
        weaponType.addLookupName("CLStreakLRM10 (OS)");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 10;
        weaponType.ammoType = 32;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 5.5f;
        weaponType.criticals = 2;
        weaponType.bv = 173.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 225000.0;
        return weaponType;
    }

    private static WeaponType createCLStreakLRM15OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "Streak LRM 15 (OS)";
        weaponType.setInternalName("CLOSStreakLRM15");
        weaponType.addLookupName("Clan Streak LRM-15 (OS)");
        weaponType.addLookupName("Clan Streak LRM 15 (OS)");
        weaponType.addLookupName("CLStreakLRM15 (OS)");
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.rackSize = 15;
        weaponType.ammoType = 32;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 7.5f;
        weaponType.criticals = 3;
        weaponType.bv = 260.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 400000.0;
        return weaponType;
    }

    private static WeaponType createCLStreakLRM20OS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "Streak LRM 20 (OS)";
        weaponType.setInternalName("CLOSStreakLRM20");
        weaponType.addLookupName("Clan Streak LRM-20 (OS)");
        weaponType.addLookupName("Clan Streak LRM 20 (OS)");
        weaponType.addLookupName("CLStreakLRM20 (OS)");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.rackSize = 20;
        weaponType.ammoType = 32;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 10.5f;
        weaponType.criticals = 5;
        weaponType.bv = 346.0;
        weaponType.flags |= 0x88000L;
        weaponType.cost = 600000.0;
        return weaponType;
    }

    private static WeaponType createInfRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Inf. Ballistic Rifle";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("InfantryRifle");
        weaponType.addLookupName("Infantry Rifle");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.ammoType = 1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x20821L;
        weaponType.bv = 4.0;
        return weaponType;
    }

    private static WeaponType createInfMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Infantry MG";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("InfantryMG");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.ammoType = 3;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x20821L;
        weaponType.bv = 4.0;
        return weaponType;
    }

    private static WeaponType createInfSRM() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Infantry SRM";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("InfantrySRM");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80821L;
        weaponType.bv = 4.0;
        return weaponType;
    }

    private static WeaponType createInfInfernoSRM() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Infantry Inferno SRM";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("InfantryInfernoSRM");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80C01L;
        weaponType.bv = 4.0;
        return weaponType;
    }

    private static WeaponType createInfLRM() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Infantry LRM";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("InfantryLRM");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.ammoType = 7;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80821L;
        weaponType.bv = 4.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createInfLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Inf. Energy Rifle";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("InfantryLaser");
        weaponType.addLookupName("Infantry Laser");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.waterShortRange = 2;
        weaponType.waterMediumRange = 4;
        weaponType.waterLongRange = 6;
        weaponType.waterExtremeRange = 8;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x40825L;
        weaponType.bv = 4.0;
        return weaponType;
    }

    private static WeaponType createInfFlamer() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "Infantry Flamer";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("InfantryFlamer");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x40803L;
        String[] stringArray = new String[]{"Damage", "Heat"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    private static WeaponType createCLAMS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "AMS";
        weaponType.setInternalName("CLAntiMissileSystem");
        weaponType.addLookupName("Clan Anti-Missile Sys");
        weaponType.addLookupName("Clan AMS");
        weaponType.addLookupName("Clan Anti-Missile Syst");
        weaponType.heat = 1;
        weaponType.rackSize = 2;
        weaponType.damage = 2;
        weaponType.ammoType = 14;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.bv = 32.0;
        weaponType.flags |= 0x1000010L;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createCLLaserAMS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "Laser AMS";
        weaponType.setInternalName("CLLaserAntiMissileSystem");
        weaponType.addLookupName("Clan Laser Anti-Missile Sys");
        weaponType.addLookupName("Clan Laser AMS");
        weaponType.heat = 2;
        weaponType.rackSize = 2;
        weaponType.damage = 2;
        weaponType.ammoType = 14;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 2;
        weaponType.bv = 105.0;
        weaponType.flags |= 0x1840010L;
        weaponType.cost = 225000.0;
        return weaponType;
    }

    private static WeaponType createCLNarc() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Narc";
        weaponType.setInternalName("CLNarcBeacon");
        weaponType.addLookupName("Clan Narc Beacon");
        weaponType.addLookupName("Clan Narc Missile Beacon");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 13;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.bv = 30.0;
        weaponType.flags |= 0x80020L;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createCLNarcOS() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Narc (OS)";
        weaponType.setInternalName("CLNarcBeacon (OS)");
        weaponType.addLookupName("Clan OS Narc Beacon");
        weaponType.addLookupName("Clan Narc Missile Beacon (OS)");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 13;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 2.5f;
        weaponType.criticals = 1;
        weaponType.bv = 6.0;
        weaponType.flags |= 0x88020L;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createLegAttack() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Leg Attack";
        weaponType.setInternalName("LegAttack");
        weaponType.heat = 0;
        weaponType.damage = -4;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 0.0;
        weaponType.flags |= 0xA0L;
        weaponType.cost = 0.0;
        return weaponType;
    }

    private static WeaponType createSwarmMek() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Swarm Mek";
        weaponType.setInternalName("SwarmMek");
        weaponType.heat = 0;
        weaponType.damage = -4;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 0.0;
        weaponType.flags |= 0xA0L;
        weaponType.cost = 0.0;
        return weaponType;
    }

    private static WeaponType createStopSwarm() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Stop Swarm Attack";
        weaponType.setInternalName("StopSwarm");
        weaponType.heat = 0;
        weaponType.damage = -4;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 0.0;
        weaponType.flags |= 0xA0L;
        weaponType.cost = 0.0;
        return weaponType;
    }

    private static WeaponType createBAMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.name = "Machine Gun";
        weaponType.setInternalName("BAMachineGun");
        weaponType.addLookupName("BA-Machine Gun");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 2;
        weaponType.ammoType = -2;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 5.0;
        weaponType.flags |= 0x21001L;
        return weaponType;
    }

    private static WeaponType createBASingleMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Machine Gun";
        weaponType.setInternalName("BASingleMachineGun");
        weaponType.addLookupName("BA-Single Machine Gun");
        weaponType.heat = 0;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = -2;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 5.0;
        weaponType.flags |= 0x20001L;
        return weaponType;
    }

    private static WeaponType createBASingleFlamer() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Flamer";
        weaponType.setInternalName("ISBASingleFlamer");
        weaponType.addLookupName("IS BA-Single Flamer");
        weaponType.heat = 3;
        weaponType.damage = 2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x40003L;
        weaponType.bv = 6.0;
        return weaponType;
    }

    private static WeaponType createBAFlamer() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Flamer";
        weaponType.setInternalName("BAFlamer");
        weaponType.addLookupName("BA-Flamer");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 6.0;
        weaponType.flags |= 0x41003L;
        return weaponType;
    }

    private static WeaponType createBASmallLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Small Laser";
        weaponType.setInternalName("BASmallLaser");
        weaponType.addLookupName("BA-Small Laser");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 9.0;
        weaponType.flags |= 0x80041025L;
        return weaponType;
    }

    private static WeaponType createBACLERSmallLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "ER Small Laser";
        weaponType.setInternalName("BACLERSmallLaser");
        weaponType.addLookupName("BA-Clan ER Small Laser");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 5;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 3;
        weaponType.waterExtremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80041025L;
        weaponType.bv = 31.0;
        return weaponType;
    }

    private static WeaponType createBAAdvancedSRM2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Advanced SRM 2";
        weaponType.setInternalName("CLAdvancedSRM2");
        weaponType.addLookupName("BA-Advanced SRM-2");
        weaponType.addLookupName("Clan Advanced SRM-2");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 24;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80020L;
        weaponType.bv = 30.0;
        return weaponType;
    }

    private static WeaponType createBATwinFlamers() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Twin Flamers";
        weaponType.setInternalName("BATwinFlamers");
        weaponType.addLookupName("BA-Twin Flamers");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 12.0;
        weaponType.flags |= 0x43003L;
        String[] stringArray = new String[]{"Damage", "Heat"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    private static WeaponType createBAInfernoSRM() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Inferno SRM";
        weaponType.setInternalName("BAInfernoSRM");
        weaponType.addLookupName("BA-Inferno SRM");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 1;
        weaponType.ammoType = 25;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 0.0;
        weaponType.flags |= 0x81400L;
        return weaponType;
    }

    private static WeaponType createBACLMicroPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Micro Pulse Laser";
        weaponType.setInternalName("BACLMicroPulseLaser");
        weaponType.addLookupName("BA-Clan Micro Pulse Laser");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 3;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 2;
        weaponType.waterExtremeRange = 2;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x41024L;
        weaponType.bv = 12.0;
        return weaponType;
    }

    private static WeaponType createBAMicroBomb() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Micro Bomb";
        weaponType.setInternalName("BAMicroBomb");
        weaponType.addLookupName("BA-Micro Bomb");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 2;
        weaponType.ammoType = 26;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 0.0;
        weaponType.flags |= 0x1020L;
        return weaponType;
    }

    private static WeaponType createBACLERMicroLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "ER Micro Laser";
        weaponType.setInternalName("BACLERMicroLaser");
        weaponType.addLookupName("BA-Clan ER Micro Laser");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 4;
        weaponType.extremeRange = 4;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 2;
        weaponType.waterExtremeRange = 2;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80041025L;
        weaponType.bv = 7.0;
        return weaponType;
    }

    private static WeaponType createCLTorpedoLRM5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Torpedo/LRM 5";
        weaponType.setInternalName("CLTorpedoLRM5");
        weaponType.addLookupName("Clan Torpedo/LRM-5");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 27;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 55.0;
        return weaponType;
    }

    private static WeaponType createBAISMediumPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Medium Pulse Laser";
        weaponType.setInternalName("BAISMediumPulseLaser");
        weaponType.addLookupName("BA-IS Medium Pulse Laser");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 6;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.waterShortRange = 2;
        weaponType.waterMediumRange = 3;
        weaponType.waterLongRange = 4;
        weaponType.waterExtremeRange = 6;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80041004L;
        weaponType.bv = 48.0;
        return weaponType;
    }

    private static WeaponType createTwinSmallPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Twin Small Pulse Lasers";
        weaponType.setInternalName("TwinSmallPulseLaser");
        weaponType.addLookupName("Twin Small Pulse Lasers");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 2;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -3;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x100044025L;
        weaponType.bv = 24.0;
        return weaponType;
    }

    private static WeaponType createTripleSmallLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Triple Small Lasers";
        weaponType.setInternalName("TripleSmallLaser");
        weaponType.addLookupName("Triple Small Lasers");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 3;
        weaponType.ammoType = -3;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x44025L;
        weaponType.bv = 27.0;
        return weaponType;
    }

    private static WeaponType createTripleMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Triple Machine Guns";
        weaponType.setInternalName("TripleMachineGun");
        weaponType.addLookupName("Triple Machine Guns");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 3;
        weaponType.ammoType = -2;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x24001L;
        weaponType.bv = 15.0;
        return weaponType;
    }

    private static WeaponType createBAAutoGL() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Auto Grenade Launcher";
        weaponType.setInternalName("BAAutoGL");
        weaponType.addLookupName("BA-Auto GL");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 1;
        weaponType.ammoType = -2;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 1.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x21001L;
        return weaponType;
    }

    private static WeaponType createBAMagshotGR() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Magshot Gauss Rifle";
        weaponType.setInternalName("BAMagshotGR");
        weaponType.addLookupName("BA-Magshot GR");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 0.0;
        weaponType.flags |= 0x80021021L;
        return weaponType;
    }

    private static WeaponType createISMagshotGR() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Magshot";
        weaponType.setInternalName("ISMagshotGR");
        weaponType.addLookupName("ISMagshotGR");
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.ammoType = 44;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.5f;
        weaponType.explosive = true;
        weaponType.criticals = 2;
        weaponType.bv = 15.0;
        weaponType.cost = 8500.0;
        weaponType.flags |= 0x200020021L;
        return weaponType;
    }

    private static WeaponType createCLMagshotGR() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "Magshot";
        weaponType.setInternalName("CLMagshotGR");
        weaponType.addLookupName("Clan Magshot Gauss Rifle");
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 44;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.5f;
        weaponType.explosive = true;
        weaponType.criticals = 2;
        weaponType.bv = 15.0;
        weaponType.cost = 8500.0;
        weaponType.flags |= 0x200020021L;
        return weaponType;
    }

    private static WeaponType createCLAPGaussRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "AP Gauss Rifle";
        weaponType.setInternalName("CLAPGaussRifle");
        weaponType.addLookupName("Clan AP Gauss Rifle");
        weaponType.addLookupName("Clan Anti-Personnel Gauss Rifle");
        weaponType.heat = 1;
        weaponType.damage = 3;
        weaponType.rackSize = 3;
        weaponType.ammoType = 44;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.5f;
        weaponType.explosive = true;
        weaponType.criticals = 1;
        weaponType.bv = 21.0;
        weaponType.cost = 8500.0;
        weaponType.flags |= 0x200020021L;
        return weaponType;
    }

    private static WeaponType createBAISMediumLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Medium Laser";
        weaponType.setInternalName("BAISMediumLaser");
        weaponType.addLookupName("BA-IS Medium Laser");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 5;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.waterShortRange = 2;
        weaponType.waterMediumRange = 4;
        weaponType.waterLongRange = 6;
        weaponType.waterExtremeRange = 8;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80041005L;
        weaponType.bv = 46.0;
        return weaponType;
    }

    private static WeaponType createBAISERSmallLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "ER Small Laser";
        weaponType.setInternalName("BAISERSmallLaser");
        weaponType.addLookupName("BA-IS ER Small Laser");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 5;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80041025L;
        weaponType.bv = 17.0;
        return weaponType;
    }

    private static WeaponType createBACompactNARC() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Compact Narc";
        weaponType.setInternalName("BACompactNarc");
        weaponType.addLookupName("BA-Compact Narc");
        weaponType.heat = 0;
        weaponType.rackSize = 4;
        weaponType.ammoType = 13;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 5;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 16.0;
        weaponType.flags |= 0x81020L;
        return weaponType;
    }

    private static WeaponType createSlothSmallLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Twin Small Lasers";
        weaponType.setInternalName("SlothSmallLaser");
        weaponType.addLookupName("Sloth Small Laser");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 2;
        weaponType.ammoType = -3;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80044025L;
        weaponType.bv = 18.0;
        return weaponType;
    }

    private static WeaponType createBAMineLauncher() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Mine Launcher";
        weaponType.setInternalName("BAMineLauncher");
        weaponType.addLookupName("BA-Mine Launcher");
        weaponType.heat = 0;
        weaponType.damage = -4;
        weaponType.rackSize = 1;
        weaponType.ammoType = 28;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 0.0;
        String[] stringArray = new String[]{"Single", "2-shot", "3-shot", "4-shot"};
        weaponType.setModes(stringArray);
        weaponType.flags |= 0x1081L;
        return weaponType;
    }

    private static WeaponType createCLPROLRT1() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 1";
        weaponType.setInternalName("CLLRTorpedo1");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 0.2f;
        weaponType.criticals = 0;
        weaponType.bv = 17.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRT2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 2";
        weaponType.setInternalName("CLLRTorpedo2");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 0.4f;
        weaponType.criticals = 0;
        weaponType.bv = 25.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRT3() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 3";
        weaponType.setInternalName("CLLRTorpedo3");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 3;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 0.6f;
        weaponType.criticals = 0;
        weaponType.bv = 35.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRT4() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 4";
        weaponType.setInternalName("CLLRTorpedo4");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 0.8f;
        weaponType.criticals = 0;
        weaponType.bv = 46.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRT6() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 6";
        weaponType.setInternalName("CLLRTorpedo6");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 1.2f;
        weaponType.criticals = 0;
        weaponType.bv = 69.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRT7() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 7";
        weaponType.setInternalName("CLLRTorpedo7");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 7;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 1.4f;
        weaponType.criticals = 0;
        weaponType.bv = 92.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRT8() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 8";
        weaponType.setInternalName("CLLRTorpedo8");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 8;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 1.6f;
        weaponType.criticals = 0;
        weaponType.bv = 93.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRT9() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 9";
        weaponType.setInternalName("CLLRTorpedo9");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 9;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 1.8f;
        weaponType.criticals = 0;
        weaponType.bv = 95.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRT11() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 11";
        weaponType.setInternalName("CLLRTorpedo11");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 11;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 2.2f;
        weaponType.criticals = 0;
        weaponType.bv = 139.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRT12() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 12";
        weaponType.setInternalName("CLLRTorpedo12");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 12;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 2.4f;
        weaponType.criticals = 0;
        weaponType.bv = 141.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRT13() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 13";
        weaponType.setInternalName("CLLRTorpedo13");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 13;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 2.6f;
        weaponType.criticals = 0;
        weaponType.bv = 161.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRT14() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 14";
        weaponType.setInternalName("CLLRTorpedo14");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 14;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 2.8f;
        weaponType.criticals = 0;
        weaponType.bv = 163.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRT16() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 16";
        weaponType.setInternalName("CLLRTorpedo16");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 16;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 3.2f;
        weaponType.criticals = 0;
        weaponType.bv = 214.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRT17() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 17";
        weaponType.setInternalName("CLLRTorpedo17");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 17;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 3.4f;
        weaponType.criticals = 0;
        weaponType.bv = 215.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRT18() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 18";
        weaponType.setInternalName("CLLRTorpedo18");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 18;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 3.6f;
        weaponType.criticals = 0;
        weaponType.bv = 217.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRT19() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRT 19";
        weaponType.setInternalName("CLLRTorpedo19");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 19;
        weaponType.ammoType = 8;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.waterShortRange = 7;
        weaponType.waterMediumRange = 14;
        weaponType.waterLongRange = 21;
        weaponType.waterExtremeRange = 28;
        weaponType.tonnage = 3.8f;
        weaponType.criticals = 0;
        weaponType.bv = 218.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROSRM1() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRM 1";
        weaponType.setInternalName("CLSRM1");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.25f;
        weaponType.criticals = 0;
        weaponType.bv = 15.0;
        weaponType.flags |= 0x80040L;
        return weaponType;
    }

    private static WeaponType createCLPROSRM3() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRM 3";
        weaponType.setInternalName("CLSRM3");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 3;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.75f;
        weaponType.criticals = 0;
        weaponType.bv = 30.0;
        weaponType.flags |= 0x80040L;
        return weaponType;
    }

    private static WeaponType createCLPROSRM5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRM 5";
        weaponType.setInternalName("CLSRM5");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 1.25f;
        weaponType.criticals = 0;
        weaponType.bv = 58.0;
        weaponType.flags |= 0x80040L;
        return weaponType;
    }

    private static WeaponType createCLPROStreakSRM1() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Streak SRM 1";
        weaponType.setInternalName("CLStreakSRM1");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 11;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 0;
        weaponType.bv = 20.0;
        weaponType.flags |= 0x80040L;
        return weaponType;
    }

    private static WeaponType createCLPROStreakSRM3() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Streak SRM 3";
        weaponType.setInternalName("CLStreakSRM3");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 3;
        weaponType.ammoType = 11;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 1.5f;
        weaponType.criticals = 0;
        weaponType.bv = 59.0;
        weaponType.flags |= 0x80040L;
        return weaponType;
    }

    private static WeaponType createCLPROStreakSRM5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Streak SRM 5";
        weaponType.setInternalName("CLStreakSRM5");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 11;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 2.5f;
        weaponType.criticals = 0;
        weaponType.bv = 99.0;
        weaponType.flags |= 0x80040L;
        return weaponType;
    }

    private static WeaponType createCLPROLRM1() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 1";
        weaponType.setInternalName("CLLRM1");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 0.2f;
        weaponType.criticals = 0;
        weaponType.bv = 17.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRM2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 2";
        weaponType.setInternalName("CLLRM2");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 0.4f;
        weaponType.criticals = 0;
        weaponType.bv = 25.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRM3() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 3";
        weaponType.setInternalName("CLLRM3");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 3;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 0.6f;
        weaponType.criticals = 0;
        weaponType.bv = 35.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRM4() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 4";
        weaponType.setInternalName("CLLRM4");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 0.8f;
        weaponType.criticals = 0;
        weaponType.bv = 46.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRM6() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 6";
        weaponType.setInternalName("CLLRM6");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 1.2f;
        weaponType.criticals = 0;
        weaponType.bv = 69.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRM7() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 7";
        weaponType.setInternalName("CLLRM7");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 7;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 1.4f;
        weaponType.criticals = 0;
        weaponType.bv = 92.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRM8() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 8";
        weaponType.setInternalName("CLLRM8");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 8;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 1.6f;
        weaponType.criticals = 0;
        weaponType.bv = 93.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRM9() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 9";
        weaponType.setInternalName("CLLRM9");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 9;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 1.8f;
        weaponType.criticals = 0;
        weaponType.bv = 95.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRM11() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 11";
        weaponType.setInternalName("CLLRM11");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 11;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 2.2f;
        weaponType.criticals = 0;
        weaponType.bv = 139.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRM12() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 12";
        weaponType.setInternalName("CLLRM12");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 12;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 2.4f;
        weaponType.criticals = 0;
        weaponType.bv = 141.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRM13() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 13";
        weaponType.setInternalName("CLLRM13");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 13;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 2.6f;
        weaponType.criticals = 0;
        weaponType.bv = 161.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRM14() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 14";
        weaponType.setInternalName("CLLRM14");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 14;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 2.8f;
        weaponType.criticals = 0;
        weaponType.bv = 163.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRM16() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 16";
        weaponType.setInternalName("CLLRM16");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 16;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 3.2f;
        weaponType.criticals = 0;
        weaponType.bv = 214.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRM17() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 17";
        weaponType.setInternalName("CLLRM17");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 17;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 3.4f;
        weaponType.criticals = 0;
        weaponType.bv = 215.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRM18() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 18";
        weaponType.setInternalName("CLLRM18");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 18;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 3.6f;
        weaponType.criticals = 0;
        weaponType.bv = 217.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROLRM19() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "LRM 19";
        weaponType.setInternalName("CLLRM19");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 19;
        weaponType.ammoType = 7;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 3.8f;
        weaponType.criticals = 0;
        weaponType.bv = 218.0;
        weaponType.flags |= 0x80040L;
        weaponType.setModes(new String[]{"", "Indirect"});
        return weaponType;
    }

    private static WeaponType createCLPROSRT1() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRT 1";
        weaponType.setInternalName("CLSRTorpedo1");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.25f;
        weaponType.criticals = 0;
        weaponType.bv = 15.0;
        weaponType.flags |= 0x80040L;
        return weaponType;
    }

    private static WeaponType createCLPROSRT3() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRT 3";
        weaponType.setInternalName("CLSRTorpedo3");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 3;
        weaponType.ammoType = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.75f;
        weaponType.criticals = 0;
        weaponType.bv = 30.0;
        weaponType.flags |= 0x80040L;
        return weaponType;
    }

    private static WeaponType createCLPROSRT5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "SRT 5";
        weaponType.setInternalName("CLSRTorpedo5");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 10;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 1.25f;
        weaponType.criticals = 0;
        weaponType.bv = 58.0;
        weaponType.flags |= 0x80040L;
        return weaponType;
    }

    private static WeaponType createISArrowIVSystem() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Arrow IV";
        weaponType.setInternalName("ISArrowIV");
        weaponType.addLookupName("ISArrowIVSystem");
        weaponType.addLookupName("IS Arrow IV System");
        weaponType.addLookupName("IS Arrow IV Missile System");
        weaponType.heat = 10;
        weaponType.damage = -5;
        weaponType.rackSize = 20;
        weaponType.ammoType = 15;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 5;
        weaponType.extremeRange = 5;
        weaponType.tonnage = 15.0f;
        weaponType.criticals = 15;
        weaponType.bv = 171.0;
        weaponType.flags |= 0x10100L;
        weaponType.cost = 450000.0;
        return weaponType;
    }

    private static WeaponType createCLArrowIVSystem() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Arrow IV";
        weaponType.setInternalName("CLArrowIV");
        weaponType.addLookupName("CLArrowIVSystem");
        weaponType.addLookupName("Clan Arrow IV System");
        weaponType.addLookupName("Clan Arrow IV Missile System");
        weaponType.heat = 10;
        weaponType.damage = -5;
        weaponType.rackSize = 20;
        weaponType.ammoType = 15;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 6;
        weaponType.extremeRange = 6;
        weaponType.tonnage = 12.0f;
        weaponType.criticals = 12;
        weaponType.bv = 171.0;
        weaponType.flags |= 0x10100L;
        weaponType.cost = 450000.0;
        return weaponType;
    }

    private static WeaponType createISLongTom() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Long Tom";
        weaponType.setInternalName("ISLongTom");
        weaponType.addLookupName("ISLongTomArtillery");
        weaponType.addLookupName("IS Long Tom");
        weaponType.heat = 20;
        weaponType.damage = -5;
        weaponType.rackSize = 20;
        weaponType.ammoType = 16;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 20;
        weaponType.extremeRange = 20;
        weaponType.tonnage = 30.0f;
        weaponType.criticals = 30;
        weaponType.bv = 171.0;
        weaponType.flags |= 0x10000L;
        weaponType.cost = 450000.0;
        return weaponType;
    }

    private static WeaponType createCLLongTom() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Long Tom";
        weaponType.setInternalName("CLLongTom");
        weaponType.addLookupName("CLLongTomArtillery");
        weaponType.addLookupName("Clan Long Tom");
        weaponType.heat = 20;
        weaponType.damage = -5;
        weaponType.rackSize = 20;
        weaponType.ammoType = 16;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 20;
        weaponType.extremeRange = 20;
        weaponType.tonnage = 30.0f;
        weaponType.criticals = 30;
        weaponType.bv = 171.0;
        weaponType.flags |= 0x10000L;
        weaponType.cost = 450000.0;
        return weaponType;
    }

    private static WeaponType createISSniper() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Sniper";
        weaponType.setInternalName("ISSniper");
        weaponType.addLookupName("ISSniperArtillery");
        weaponType.addLookupName("IS Sniper");
        weaponType.heat = 10;
        weaponType.damage = -5;
        weaponType.rackSize = 10;
        weaponType.ammoType = 17;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 12;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 20.0f;
        weaponType.criticals = 20;
        weaponType.bv = 86.0;
        weaponType.flags |= 0x10100L;
        weaponType.cost = 300000.0;
        return weaponType;
    }

    private static WeaponType createCLSniper() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Sniper";
        weaponType.setInternalName("CLSniper");
        weaponType.addLookupName("CLSniperArtillery");
        weaponType.addLookupName("Clan Sniper");
        weaponType.heat = 10;
        weaponType.damage = -5;
        weaponType.rackSize = 10;
        weaponType.ammoType = 17;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 12;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 20.0f;
        weaponType.criticals = 20;
        weaponType.bv = 86.0;
        weaponType.flags |= 0x10100L;
        weaponType.cost = 300000.0;
        return weaponType;
    }

    private static WeaponType createISThumper() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Thumper";
        weaponType.setInternalName("ISThumper");
        weaponType.addLookupName("ISThumperArtillery");
        weaponType.addLookupName("IS Thumper");
        weaponType.heat = 5;
        weaponType.damage = -5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 18;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 14;
        weaponType.extremeRange = 14;
        weaponType.tonnage = 15.0f;
        weaponType.criticals = 15;
        weaponType.bv = 40.0;
        weaponType.flags |= 0x10100L;
        weaponType.cost = 187500.0;
        return weaponType;
    }

    private static WeaponType createCLThumper() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Thumper";
        weaponType.setInternalName("CLThumper");
        weaponType.addLookupName("CLThumperArtillery");
        weaponType.addLookupName("Clan Thumper");
        weaponType.heat = 5;
        weaponType.damage = -5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 18;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 14;
        weaponType.extremeRange = 14;
        weaponType.tonnage = 15.0f;
        weaponType.criticals = 15;
        weaponType.bv = 40.0;
        weaponType.flags |= 0x10100L;
        weaponType.cost = 187500.0;
        return weaponType;
    }

    private static WeaponType createBAAdvancedSRM5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Advanced SRM 5";
        weaponType.setInternalName("AdvancedSRM5");
        weaponType.addLookupName("BA-Advanced SRM-5");
        weaponType.addLookupName("Clan Advanced SRM-5");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 24;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80020L;
        weaponType.bv = 75.0;
        return weaponType;
    }

    private static WeaponType createBABearhunterAC() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Bearhunter AC";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-Bearhunter Superheavy AC");
        weaponType.heat = 0;
        weaponType.toHitModifier = 1;
        weaponType.damage = -3;
        weaponType.rackSize = 3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 1;
        weaponType.longRange = 2;
        weaponType.extremeRange = 2;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 4.0;
        weaponType.flags |= 0x21021L;
        return weaponType;
    }

    private static WeaponType createBATwinBearhunterAC() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Twin Bearhunter ACs";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-Twin Bearhunter Superheavy ACs");
        weaponType.heat = 0;
        weaponType.toHitModifier = 1;
        weaponType.damage = -3;
        weaponType.rackSize = 3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 1;
        weaponType.longRange = 2;
        weaponType.extremeRange = 2;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 8.0;
        weaponType.flags |= 0x23021L;
        return weaponType;
    }

    private static WeaponType createBACLMediumPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Medium Pulse Laser";
        weaponType.setInternalName("BACLMediumPulseLaser");
        weaponType.addLookupName("BA-CL Medium Pulse Laser");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 7;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 5;
        weaponType.waterLongRange = 8;
        weaponType.waterExtremeRange = 10;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x41004L;
        weaponType.bv = 111.0;
        return weaponType;
    }

    private static WeaponType createBAIncendiaryNeedler() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Firedrake Needler";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-Firedrake Incendiary Needler");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x201001L;
        weaponType.bv = 2.0;
        return weaponType;
    }

    private static WeaponType createBALightRecRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Light Recoilless";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-Light Recoilless Rifle");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 12.0;
        weaponType.flags |= 0x21021L;
        return weaponType;
    }

    private static WeaponType createBAKingDavidLightGaussRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "King David Light Gauss Rifle";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-King David Light Gauss Rifle");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 7.0;
        weaponType.flags |= 0x80021021L;
        return weaponType;
    }

    private static WeaponType createBAMediumRecRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Medium Recoilless";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-Medium Recoilless Rifle");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 19.0;
        weaponType.flags |= 0x21021L;
        return weaponType;
    }

    private static WeaponType createBAPlasmaRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Plasma Rifle";
        weaponType.setInternalName("BAPlasmaRifle");
        weaponType.addLookupName("BA-Plasma Rifle");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x141001L;
        weaponType.bv = 12.0;
        return weaponType;
    }

    private static WeaponType createBASingleSmallPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Small Pulse Laser";
        weaponType.setInternalName("BASingleSmallPulseLaser");
        weaponType.addLookupName("BA-Single Small Pulse Laser");
        weaponType.heat = 0;
        weaponType.damage = 3;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 2;
        weaponType.waterExtremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 12.0;
        weaponType.flags |= 0x40004L;
        return weaponType;
    }

    private static WeaponType createBASRM1() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "SRM 1";
        weaponType.setInternalName("BA-SRM1");
        weaponType.addLookupName("BASRM1");
        weaponType.addLookupName("BASRM-1");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80000L;
        weaponType.bv = 15.0;
        return weaponType;
    }

    private static WeaponType createBASRM2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "SRM 2";
        weaponType.setInternalName("BA-SRM2");
        weaponType.addLookupName("BASRM2");
        weaponType.addLookupName("BASRM-2");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80000L;
        weaponType.bv = 21.0;
        return weaponType;
    }

    private static WeaponType createBASRM3() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "SRM 3";
        weaponType.setInternalName("BA-SRM3");
        weaponType.addLookupName("BASRM3");
        weaponType.addLookupName("BASRM-3");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 3;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80000L;
        weaponType.bv = 30.0;
        return weaponType;
    }

    private static WeaponType createBASRM4() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "SRM 4";
        weaponType.setInternalName("BA-SRM4");
        weaponType.addLookupName("BASRM4");
        weaponType.addLookupName("BASRM-4");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80000L;
        weaponType.bv = 39.0;
        return weaponType;
    }

    private static WeaponType createBASRM5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "SRM 5";
        weaponType.setInternalName("BA-SRM5");
        weaponType.addLookupName("BASRM5");
        weaponType.addLookupName("BASRM-5");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80000L;
        weaponType.bv = 47.0;
        return weaponType;
    }

    private static WeaponType createBASRM6() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "SRM 6";
        weaponType.setInternalName("BA-SRM6");
        weaponType.addLookupName("BASRM6");
        weaponType.addLookupName("BASRM-6");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 9;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80000L;
        weaponType.bv = 59.0;
        return weaponType;
    }

    private static WeaponType createBASupportPPC() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Support PPC";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-Support PPC");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 5;
        weaponType.longRange = 7;
        weaponType.extremeRange = 10;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 14.0;
        weaponType.flags |= 0x80041009L;
        weaponType.setModes(new String[]{"Field Inhibitor ON", "Field Inhibitor OFF"});
        return weaponType;
    }

    private static WeaponType createBAVibroClaws1() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Single Vibroclaw";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-Vibro Claws (1)");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 0.0;
        weaponType.flags |= 0x6021021L;
        return weaponType;
    }

    private static WeaponType createBAVibroClaws2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Vibroclaws";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-Vibro Claws (2)");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 0;
        weaponType.mediumRange = 0;
        weaponType.longRange = 0;
        weaponType.extremeRange = 0;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 0.0;
        weaponType.flags |= 0x6021021L;
        return weaponType;
    }

    private static WeaponType createISLBXAC10Prototype() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "LB 10-X AC Prototype";
        weaponType.setInternalName("ISLBXAC10Prototype");
        weaponType.addLookupName("IS LB 10-X AC Prototype");
        weaponType.heat = 2;
        weaponType.damage = 10;
        weaponType.rackSize = 10;
        weaponType.ammoType = 19;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.tonnage = 11.0f;
        weaponType.criticals = 7;
        weaponType.flags |= 0x420001L;
        weaponType.bv = 148.0;
        weaponType.cost = 400000.0;
        return weaponType;
    }

    private static WeaponType createISGaussRiflePrototype() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Gauss Rifle Prototype";
        weaponType.setInternalName("ISGaussRiflePrototype");
        weaponType.addLookupName("IS Gauss Rifle Prototype");
        weaponType.heat = 1;
        weaponType.damage = 15;
        weaponType.ammoType = 6;
        weaponType.minimumRange = 2;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 15;
        weaponType.longRange = 22;
        weaponType.extremeRange = 30;
        weaponType.tonnage = 15.0f;
        weaponType.criticals = 8;
        weaponType.flags |= 0x80420021L;
        weaponType.explosive = true;
        weaponType.bv = 320.0;
        weaponType.cost = 300000.0;
        return weaponType;
    }

    private static WeaponType createISERLargeLaserPrototype() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "ER Large Laser Prototype";
        weaponType.setInternalName("ISERLargeLaserPrototype");
        weaponType.addLookupName("IS ER Large Laser Prototype");
        weaponType.heat = 12;
        weaponType.damage = 8;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 19;
        weaponType.extremeRange = 28;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 9;
        weaponType.waterLongRange = 12;
        weaponType.waterExtremeRange = 18;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 2;
        weaponType.toHitModifier = 1;
        weaponType.flags |= 0x80440005L;
        weaponType.bv = 163.0;
        weaponType.cost = 200000.0;
        return weaponType;
    }

    private static WeaponType createISMediumPulseLaserPrototype() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Medium Pulse Laser Prototype";
        weaponType.setInternalName("ISMediumPulseLaserPrototype");
        weaponType.addLookupName("IS Pulse Med Laser Prototype");
        weaponType.addLookupName("IS Medium Pulse Laser Prototype");
        weaponType.heat = 4;
        weaponType.damage = 6;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.waterShortRange = 2;
        weaponType.waterMediumRange = 3;
        weaponType.waterLongRange = 4;
        weaponType.waterExtremeRange = 6;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x100440005L;
        weaponType.bv = 48.0;
        weaponType.cost = 60000.0;
        return weaponType;
    }

    private static WeaponType createISUltraAC5Prototype() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Ultra AC/5 Prototype";
        weaponType.setInternalName("ISUltraAC5Prototype");
        weaponType.addLookupName("IS Ultra AC/5 Prototype");
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 20;
        weaponType.minimumRange = 2;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 13;
        weaponType.longRange = 20;
        weaponType.extremeRange = 26;
        weaponType.tonnage = 9.0f;
        weaponType.criticals = 6;
        weaponType.flags |= 0x420001L;
        weaponType.bv = 112.0;
        String[] stringArray = new String[]{"Single", "Ultra"};
        weaponType.setModes(stringArray);
        weaponType.cost = 200000.0;
        return weaponType;
    }

    private static WeaponType createISTAG() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "IS TAG";
        weaponType.setInternalName("ISTAG");
        weaponType.addLookupName("IS TAG");
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.hittable = true;
        weaponType.spreadable = false;
        weaponType.flags |= 0x8000020L;
        weaponType.heat = 0;
        weaponType.damage = 0;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        weaponType.bv = 0.0;
        weaponType.cost = 50000.0;
        String[] stringArray = new String[]{"1-shot", "2-shot", "3-shot", "4-shot"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    private static WeaponType createISLightTAG() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "IS Light TAG";
        weaponType.setInternalName("ISLightTAG");
        weaponType.addLookupName("Light TAG");
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.hittable = true;
        weaponType.spreadable = false;
        weaponType.flags |= 0x8000020L;
        weaponType.heat = 0;
        weaponType.damage = 0;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.bv = 0.0;
        weaponType.cost = 40000.0;
        String[] stringArray = new String[]{"1-shot", "2-shot", "3-shot", "4-shot"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    private static WeaponType createCLTAG() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Clan TAG";
        weaponType.setInternalName("CLTAG");
        weaponType.addLookupName("Clan TAG");
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.hittable = true;
        weaponType.spreadable = false;
        weaponType.flags |= 0x8000020L;
        weaponType.heat = 0;
        weaponType.damage = 0;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        weaponType.bv = 0.0;
        weaponType.cost = 50000.0;
        String[] stringArray = new String[]{"1-shot", "2-shot", "3-shot", "4-shot"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    private static WeaponType createCLLightTAG() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Clan Light TAG";
        weaponType.setInternalName("CLLightTAG");
        weaponType.addLookupName("Clan Light TAG");
        weaponType.tonnage = 0.5f;
        weaponType.criticals = 1;
        weaponType.hittable = true;
        weaponType.spreadable = false;
        weaponType.flags |= 0x8000020L;
        weaponType.heat = 0;
        weaponType.damage = 0;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.bv = 0.0;
        weaponType.cost = 40000.0;
        String[] stringArray = new String[]{"1-shot", "2-shot", "3-shot", "4-shot"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    private static WeaponType createC3M() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "C3 Master with TAG";
        weaponType.setInternalName("ISC3MasterUnit");
        weaponType.addLookupName("IS C3 Computer");
        weaponType.addLookupName("ISC3MasterComputer");
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 5;
        weaponType.hittable = true;
        weaponType.spreadable = false;
        weaponType.cost = 1500000.0;
        weaponType.bv = 0.0;
        weaponType.flags |= 0x18000020L;
        weaponType.heat = 0;
        weaponType.damage = 0;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        String[] stringArray = new String[]{"1-shot", "2-shot", "3-shot", "4-shot"};
        weaponType.setModes(stringArray);
        return weaponType;
    }

    private static WeaponType createBAHeavyRecRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Heavy Recoilless";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-Heavy Recoilless Rifle");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 5;
        weaponType.longRange = 7;
        weaponType.extremeRange = 10;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 22.0;
        weaponType.flags |= 0x21021L;
        return weaponType;
    }

    private static WeaponType createBAHeavyMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Semi-Portable Autocannon";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-HeavyMG");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 2;
        weaponType.extremeRange = 2;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 6.0;
        weaponType.flags |= 0x21021L;
        return weaponType;
    }

    private static WeaponType createBALightMG() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Semi-Portable Machine Gun";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-LightMG");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 5.0;
        weaponType.flags |= 0x21021L;
        return weaponType;
    }

    private static WeaponType createBACLHeavyMediumLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Ultra Heavy Support Laser";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-CLHeavyMediumLaser");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 10;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.waterShortRange = 2;
        weaponType.waterMediumRange = 4;
        weaponType.waterLongRange = 6;
        weaponType.waterExtremeRange = 8;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80041005L;
        weaponType.bv = 76.0;
        return weaponType;
    }

    private static WeaponType createBACLHeavySmallLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Semi-Portable Heavy Laser";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-CLHeavySmallLaser");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 6;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 2;
        weaponType.waterExtremeRange = 2;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80041005L;
        weaponType.bv = 15.0;
        return weaponType;
    }

    private static WeaponType createBACLERMediumLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "ER Heavy Support Laser";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-CLERMediumLaser");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 7;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 7;
        weaponType.waterLongRange = 10;
        weaponType.waterExtremeRange = 14;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 108.0;
        weaponType.flags |= 0x80041005L;
        return weaponType;
    }

    private static WeaponType createBAISERMediumLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "ER Heavy Support Laser";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-ISERMediumLaser");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 5;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.waterShortRange = 3;
        weaponType.waterMediumRange = 5;
        weaponType.waterLongRange = 8;
        weaponType.waterExtremeRange = 10;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 62.0;
        weaponType.flags |= 0x80041005L;
        return weaponType;
    }

    private static WeaponType createBACLSmallPulseLaser() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Support Pulse Laser";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-CLSmallPulseLaser");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 3;
        weaponType.toHitModifier = -2;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.waterShortRange = 1;
        weaponType.waterMediumRange = 2;
        weaponType.waterLongRange = 4;
        weaponType.waterExtremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x41004L;
        weaponType.bv = 24.0;
        return weaponType;
    }

    private static WeaponType createBAGrandMaulerGauss() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Grand Mauler Gauss Cannon";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-ISGrandMauler");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 5;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 6.0;
        weaponType.flags |= 0x80021021L;
        return weaponType;
    }

    private static WeaponType createBATsunamiGaussRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Tsunami Heavy Gauss Rifle";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-ISTsunamiHeavyGaussRifle");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 5;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 6.0;
        weaponType.flags |= 0x80021021L;
        return weaponType;
    }

    private static WeaponType createBAMicroGrenade() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Micro Grenade Launcher";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-ISMicroGrenadeLauncher");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 2;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 0.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x21000L;
        return weaponType;
    }

    private static WeaponType createBAISHeavyMortar() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Heavy Mortar";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-ISHeavyMortar");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = 2;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 17.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x21000L;
        return weaponType;
    }

    private static WeaponType createBAISLightMortar() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Light Mortar";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-ISLightMortar");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 3;
        weaponType.ammoType = -1;
        weaponType.minimumRange = 1;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 9.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x21000L;
        return weaponType;
    }

    private static WeaponType createBAAdvancedSRM1() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Advanced SRM 1";
        weaponType.setInternalName("CLAdvancedSRM1");
        weaponType.addLookupName("BA-Advanced SRM-1");
        weaponType.addLookupName("Clan Advanced SRM-1");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 24;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80020L;
        weaponType.bv = 15.0;
        return weaponType;
    }

    private static WeaponType createBAAdvancedSRM3() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Advanced SRM 3";
        weaponType.setInternalName("CLAdvancedSRM3");
        weaponType.addLookupName("BA-Advanced SRM-3");
        weaponType.addLookupName("Clan Advanced SRM-3");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 3;
        weaponType.ammoType = 24;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80000L;
        weaponType.bv = 45.0;
        return weaponType;
    }

    private static WeaponType createBAAdvancedSRM4() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Advanced SRM 4";
        weaponType.setInternalName("CLAdvancedSRM4");
        weaponType.addLookupName("BA-Advanced SRM-4");
        weaponType.addLookupName("Clan Advanced SRM-4");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 24;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80000L;
        weaponType.bv = 60.0;
        return weaponType;
    }

    private static WeaponType createBAAdvancedSRM6() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Advanced SRM 6";
        weaponType.setInternalName("CLAdvancedSRM6");
        weaponType.addLookupName("BA-Advanced SRM-6");
        weaponType.addLookupName("Clan Advanced SRM-6");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 24;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80000L;
        weaponType.bv = 90.0;
        return weaponType;
    }

    private static WeaponType createBARL1() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "RL 1";
        weaponType.setInternalName("RL1");
        weaponType.addLookupName("LAW Launcher");
        weaponType.addLookupName("ISLAW");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = 30;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 7;
        weaponType.longRange = 12;
        weaponType.extremeRange = 14;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x88000L;
        weaponType.bv = 2.0;
        return weaponType;
    }

    private static WeaponType createBARL2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "RL 2";
        weaponType.setInternalName("RL2");
        weaponType.addLookupName("LAW 2 Launcher");
        weaponType.addLookupName("ISLAW2");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = 30;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 7;
        weaponType.longRange = 12;
        weaponType.extremeRange = 14;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x88000L;
        weaponType.bv = 3.0;
        return weaponType;
    }

    private static WeaponType createBARL3() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "RL 3";
        weaponType.setInternalName("RL3");
        weaponType.addLookupName("LAW 3 Launcher");
        weaponType.addLookupName("ISLAW3");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 3;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = 30;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 7;
        weaponType.longRange = 12;
        weaponType.extremeRange = 14;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x88000L;
        weaponType.bv = 4.0;
        return weaponType;
    }

    private static WeaponType createBARL4() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "RL 4";
        weaponType.setInternalName("RL4");
        weaponType.addLookupName("LAW 4 Launcher");
        weaponType.addLookupName("ISLAW4");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = 30;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 7;
        weaponType.longRange = 12;
        weaponType.extremeRange = 14;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x88000L;
        weaponType.bv = 5.0;
        return weaponType;
    }

    private static WeaponType createBARL5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "RL 5";
        weaponType.setInternalName("RL5");
        weaponType.addLookupName("LAW 5 Launcher");
        weaponType.addLookupName("ISLAW5");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = 30;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 7;
        weaponType.longRange = 12;
        weaponType.extremeRange = 14;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x88000L;
        weaponType.bv = 6.0;
        return weaponType;
    }

    private static WeaponType createISMRM1() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MRM 1";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("ISMRM1");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = 12;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80000L;
        weaponType.bv = 9.0;
        return weaponType;
    }

    private static WeaponType createISMRM2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MRM 2";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("ISMRM2");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = 12;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80000L;
        weaponType.bv = 13.0;
        return weaponType;
    }

    private static WeaponType createISMRM3() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MRM 3";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("ISMRM3");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 3;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = 12;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80000L;
        weaponType.bv = 18.0;
        return weaponType;
    }

    private static WeaponType createISMRM4() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MRM 4";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("ISMRM4");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = 12;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80000L;
        weaponType.bv = 23.0;
        return weaponType;
    }

    private static WeaponType createISMRM5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "MRM 5";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("ISMRM5");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.toHitModifier = 1;
        weaponType.ammoType = 12;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x80000L;
        weaponType.bv = 28.0;
        return weaponType;
    }

    private static WeaponType createLRM1() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRM 1";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS LRM-1");
        weaponType.addLookupName("ISLRM1");
        weaponType.addLookupName("IS LRM 1");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 14.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        return weaponType;
    }

    private static WeaponType createLRM2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRM 2";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS LRM-2");
        weaponType.addLookupName("ISLRM2");
        weaponType.addLookupName("IS LRM 2");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 20.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        return weaponType;
    }

    private static WeaponType createLRM3() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRM 3";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS LRM-3");
        weaponType.addLookupName("ISLRM3");
        weaponType.addLookupName("IS LRM 3");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 3;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 29.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        return weaponType;
    }

    private static WeaponType createLRM4() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 0;
        weaponType.name = "LRM 4";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS LRM-4");
        weaponType.addLookupName("ISLRM4");
        weaponType.addLookupName("IS LRM 4");
        weaponType.heat = 0;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 7;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 38.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        return weaponType;
    }

    private static WeaponType createBADavidGaussRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "David Light Gauss Rifle";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("BA-ISDavidLightGauss");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 5;
        weaponType.longRange = 8;
        weaponType.extremeRange = 10;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.bv = 7.0;
        weaponType.flags |= 0x80021021L;
        return weaponType;
    }

    private static WeaponType createISLAC2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Light Auto Cannon/2";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Light AutoCannon/2");
        weaponType.addLookupName("ISLAC2");
        weaponType.addLookupName("IS Light Autocannon/2");
        weaponType.addLookupName("Light AC/2");
        weaponType.heat = 1;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 35;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.tonnage = 4.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 30.0;
        String[] stringArray = new String[]{"", "Rapid"};
        weaponType.setModes(stringArray);
        weaponType.cost = 100000.0;
        weaponType.explosive = true;
        return weaponType;
    }

    private static WeaponType createISLAC5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Light Auto Cannon/5";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Light Auto Cannon/5");
        weaponType.addLookupName("ISLAC5");
        weaponType.addLookupName("IS Light Autocannon/5");
        weaponType.addLookupName("Light AC/5");
        weaponType.heat = 1;
        weaponType.damage = 5;
        weaponType.rackSize = 5;
        weaponType.ammoType = 35;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 62.0;
        String[] stringArray = new String[]{"", "Rapid"};
        weaponType.setModes(stringArray);
        weaponType.cost = 150000.0;
        weaponType.explosive = true;
        return weaponType;
    }

    private static WeaponType createISHeavyFlamer() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Heavy Flamer";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Heavy Flamer");
        weaponType.addLookupName("ISHeavyFlamer");
        weaponType.heat = 5;
        weaponType.damage = 4;
        weaponType.rackSize = 2;
        weaponType.ammoType = 36;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x200020002L;
        weaponType.bv = 20.0;
        String[] stringArray = new String[]{"Damage", "Heat", "Cool"};
        weaponType.setModes(stringArray);
        weaponType.cost = 20000.0;
        return weaponType;
    }

    private static WeaponType createCLPlasmaRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "Plasma Rifle";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("Clan Plasma Rifle");
        weaponType.addLookupName("CL Plasma Rifle");
        weaponType.addLookupName("CLPlasmaRifle");
        weaponType.addLookupName("MFUKCLPlasmaRifle");
        weaponType.heat = 15;
        weaponType.damage = 10;
        weaponType.rackSize = 1;
        weaponType.ammoType = -1;
        weaponType.minimumRange = 2;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 14;
        weaponType.longRange = 22;
        weaponType.extremeRange = 28;
        weaponType.waterShortRange = 4;
        weaponType.waterMediumRange = 10;
        weaponType.waterLongRange = 15;
        weaponType.waterExtremeRange = 20;
        weaponType.tonnage = 6.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 0x220040001L;
        weaponType.bv = 195.0;
        weaponType.cost = 300000.0;
        return weaponType;
    }

    private static WeaponType createISExtendedLRM5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "ExtendedLRM 5";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS ExtendedLRM-5");
        weaponType.addLookupName("ISExtendedLRM5");
        weaponType.addLookupName("IS ExtendedLRM 5");
        weaponType.addLookupName("ELRM-5 (THB)");
        weaponType.addLookupName("ELRM 5");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 5;
        weaponType.ammoType = 38;
        weaponType.minimumRange = 10;
        weaponType.shortRange = 12;
        weaponType.mediumRange = 22;
        weaponType.longRange = 38;
        weaponType.extremeRange = 44;
        weaponType.tonnage = 6.0f;
        weaponType.criticals = 1;
        weaponType.bv = 59.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 110000.0;
        return weaponType;
    }

    private static WeaponType createISExtendedLRM10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "ExtendedLRM 10";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS ExtendedLRM-10");
        weaponType.addLookupName("ISExtendedLRM10");
        weaponType.addLookupName("IS ExtendedLRM 10");
        weaponType.addLookupName("ELRM-10 (THB)");
        weaponType.addLookupName("ELRM 10");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.rackSize = 10;
        weaponType.ammoType = 38;
        weaponType.minimumRange = 10;
        weaponType.shortRange = 12;
        weaponType.mediumRange = 22;
        weaponType.longRange = 38;
        weaponType.extremeRange = 44;
        weaponType.tonnage = 8.0f;
        weaponType.criticals = 4;
        weaponType.bv = 117.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 225000.0;
        return weaponType;
    }

    private static WeaponType createISExtendedLRM15() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "ExtendedLRM 15";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS ExtendedLRM-15");
        weaponType.addLookupName("ISExtendedLRM15");
        weaponType.addLookupName("IS ExtendedLRM 15");
        weaponType.addLookupName("ELRM-15 (THB)");
        weaponType.addLookupName("ELRM 15");
        weaponType.heat = 8;
        weaponType.damage = -2;
        weaponType.rackSize = 15;
        weaponType.ammoType = 38;
        weaponType.minimumRange = 10;
        weaponType.shortRange = 12;
        weaponType.mediumRange = 22;
        weaponType.longRange = 38;
        weaponType.extremeRange = 44;
        weaponType.tonnage = 12.0f;
        weaponType.criticals = 6;
        weaponType.bv = 177.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 350000.0;
        return weaponType;
    }

    private static WeaponType createISExtendedLRM20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "ExtendedLRM 20";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS ExtendedLRM-20");
        weaponType.addLookupName("ISExtendedLRM20");
        weaponType.addLookupName("IS ExtendedLRM 20");
        weaponType.addLookupName("ELRM-20 (THB)");
        weaponType.addLookupName("ELRM 20");
        weaponType.heat = 10;
        weaponType.damage = -2;
        weaponType.rackSize = 20;
        weaponType.ammoType = 38;
        weaponType.minimumRange = 10;
        weaponType.shortRange = 12;
        weaponType.mediumRange = 22;
        weaponType.longRange = 38;
        weaponType.extremeRange = 44;
        weaponType.tonnage = 18.0f;
        weaponType.criticals = 8;
        weaponType.bv = 236.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 450000.0;
        return weaponType;
    }

    private static WeaponType createISThunderbolt5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Thunderbolt 5";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Thunderbolt-5");
        weaponType.addLookupName("ISThunderbolt5");
        weaponType.addLookupName("IS Thunderbolt 5");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 39;
        weaponType.minimumRange = 5;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 1;
        weaponType.bv = 64.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 50000.0;
        return weaponType;
    }

    private static WeaponType createISThunderbolt10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Thunderbolt 10";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Thunderbolt-10");
        weaponType.addLookupName("ISThunderbolt10");
        weaponType.addLookupName("ISTBolt10");
        weaponType.addLookupName("IS Thunderbolt 10");
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 40;
        weaponType.minimumRange = 5;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 2;
        weaponType.bv = 127.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 175000.0;
        return weaponType;
    }

    private static WeaponType createISThunderbolt15() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Thunderbolt 15";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Thunderbolt-15");
        weaponType.addLookupName("ISThunderbolt15");
        weaponType.addLookupName("ISTBolt15");
        weaponType.addLookupName("IS Thunderbolt 15");
        weaponType.heat = 7;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 41;
        weaponType.minimumRange = 5;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.tonnage = 11.0f;
        weaponType.criticals = 3;
        weaponType.bv = 229.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 325000.0;
        return weaponType;
    }

    private static WeaponType createISThunderbolt20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Thunderbolt 20";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Thunderbolt-20");
        weaponType.addLookupName("ISThunderbolt20");
        weaponType.addLookupName("ISTBolt20");
        weaponType.addLookupName("IS Thunderbolt 20");
        weaponType.heat = 8;
        weaponType.damage = -2;
        weaponType.rackSize = 1;
        weaponType.ammoType = 42;
        weaponType.minimumRange = 5;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.tonnage = 15.0f;
        weaponType.criticals = 5;
        weaponType.bv = 305.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 450000.0;
        return weaponType;
    }

    private static WeaponType createISHERPPC() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Kinslaughter H ERPPC";
        weaponType.setInternalName("ISHERPPC");
        weaponType.addLookupName("IS Kinslaughter H ERPPC");
        weaponType.heat = 13;
        weaponType.damage = 10;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 23;
        weaponType.extremeRange = 28;
        weaponType.waterShortRange = 4;
        weaponType.waterMediumRange = 10;
        weaponType.waterLongRange = 16;
        weaponType.waterExtremeRange = 20;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.flags |= 0x80040009L;
        weaponType.bv = 228.0;
        weaponType.cost = 450000.0;
        weaponType.setModes(new String[]{"Field Inhibitor ON", "Field Inhibitor OFF"});
        return weaponType;
    }

    private static WeaponType createISSNPPC() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Snub-Nose PPC";
        weaponType.setInternalName("ISSNPPC");
        weaponType.addLookupName("ISSnubNosedPPC");
        weaponType.heat = 10;
        weaponType.damage = -3;
        weaponType.rackSize = 10;
        weaponType.ammoType = -1;
        weaponType.shortRange = 9;
        weaponType.mediumRange = 13;
        weaponType.longRange = 15;
        weaponType.extremeRange = 26;
        weaponType.waterShortRange = 6;
        weaponType.waterMediumRange = 8;
        weaponType.waterLongRange = 9;
        weaponType.waterExtremeRange = 16;
        weaponType.tonnage = 6.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 0x80040009L;
        weaponType.bv = 165.0;
        weaponType.cost = 0.0;
        weaponType.setModes(new String[]{"Field Inhibitor ON", "Field Inhibitor OFF"});
        return weaponType;
    }

    private static WeaponType createISRailGun() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Rail Gun";
        weaponType.setInternalName("ISRailGun");
        weaponType.addLookupName("IS Rail Gun");
        weaponType.heat = 1;
        weaponType.damage = 22;
        weaponType.ammoType = 43;
        weaponType.minimumRange = 1;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 13;
        weaponType.longRange = 19;
        weaponType.extremeRange = 26;
        weaponType.tonnage = 18.0f;
        weaponType.criticals = 9;
        weaponType.flags |= 0x80020021L;
        weaponType.explosive = true;
        weaponType.bv = 411.0;
        weaponType.cost = 0.0;
        return weaponType;
    }

    private static WeaponType createFireExtinguisher() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Fire Extinguisher";
        weaponType.setInternalName(weaponType.name);
        weaponType.heat = 0;
        weaponType.damage = 0;
        weaponType.ammoType = -1;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 1;
        weaponType.longRange = 1;
        weaponType.extremeRange = 1;
        weaponType.tonnage = 0.0f;
        weaponType.criticals = 0;
        weaponType.flags |= 0x400000A0L;
        weaponType.bv = 0.0;
        weaponType.cost = 0.0;
        return weaponType;
    }

    private static WeaponType createISHeavyPPC() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Heavy PPC";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("ISHeavyPPC");
        weaponType.addLookupName("ISHPPC");
        weaponType.heat = 15;
        weaponType.damage = 15;
        weaponType.ammoType = -1;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.waterShortRange = 4;
        weaponType.waterMediumRange = 7;
        weaponType.waterLongRange = 10;
        weaponType.waterExtremeRange = 14;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 4;
        weaponType.flags |= 0x80040009L;
        weaponType.bv = 317.0;
        weaponType.setModes(new String[]{"Field Inhibitor ON", "Field Inhibitor OFF"});
        weaponType.cost = 0.0;
        return weaponType;
    }

    private static WeaponType createISLightPPC() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Light PPC";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("ISLightPPC");
        weaponType.addLookupName("ISLPPC");
        weaponType.heat = 5;
        weaponType.damage = 5;
        weaponType.ammoType = -1;
        weaponType.minimumRange = 3;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.waterShortRange = 4;
        weaponType.waterMediumRange = 7;
        weaponType.waterLongRange = 10;
        weaponType.waterExtremeRange = 14;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 0x80040009L;
        weaponType.bv = 88.0;
        weaponType.setModes(new String[]{"Field Inhibitor ON", "Field Inhibitor OFF"});
        weaponType.cost = 0.0;
        return weaponType;
    }

    private static WeaponType createISRAC10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Rotary AC/10";
        weaponType.setInternalName("ISRotaryAC10");
        weaponType.addLookupName("IS Rotary AC/10");
        weaponType.heat = 3;
        weaponType.damage = 10;
        weaponType.rackSize = 10;
        weaponType.ammoType = 23;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 16.0f;
        weaponType.criticals = 12;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 296.0;
        String[] stringArray = new String[]{"Single", "2-shot", "3-shot", "4-shot", "5-shot", "6-shot"};
        weaponType.setModes(stringArray);
        weaponType.explosive = true;
        weaponType.cost = 450000.0;
        return weaponType;
    }

    private static WeaponType createISRAC20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Rotary AC/20";
        weaponType.setInternalName("ISRotaryAC20");
        weaponType.addLookupName("IS Rotary AC/20");
        weaponType.heat = 7;
        weaponType.damage = 20;
        weaponType.rackSize = 20;
        weaponType.ammoType = 23;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 18.0f;
        weaponType.criticals = 14;
        weaponType.flags |= 0x20101L;
        weaponType.bv = 474.0;
        String[] stringArray = new String[]{"Single", "2-shot", "3-shot", "4-shot", "5-shot", "6-shot"};
        weaponType.setModes(stringArray);
        weaponType.explosive = true;
        weaponType.cost = 800000.0;
        return weaponType;
    }

    private static WeaponType createISLAC10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Light Auto Cannon/10";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Light AutoCannon/10");
        weaponType.addLookupName("ISLAC10");
        weaponType.addLookupName("IS Light Autocannon/10");
        weaponType.addLookupName("Light AC/10");
        weaponType.heat = 3;
        weaponType.damage = 10;
        weaponType.rackSize = 10;
        weaponType.ammoType = 35;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 6;
        weaponType.longRange = 9;
        weaponType.extremeRange = 12;
        weaponType.tonnage = 8.0f;
        weaponType.criticals = 4;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 74.0;
        weaponType.cost = 225000.0;
        weaponType.explosive = true;
        return weaponType;
    }

    private static WeaponType createISLAC20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Light Auto Cannon/20";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("IS Light Auto Cannon/20");
        weaponType.addLookupName("ISLAC20");
        weaponType.addLookupName("IS Light Autocannon/20");
        weaponType.addLookupName("Light AC/20");
        weaponType.heat = 7;
        weaponType.damage = 20;
        weaponType.rackSize = 20;
        weaponType.ammoType = 35;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 9.0f;
        weaponType.criticals = 6;
        weaponType.flags |= 0x20001L;
        weaponType.bv = 118.0;
        weaponType.cost = 325000.0;
        weaponType.explosive = true;
        return weaponType;
    }

    private static WeaponType createISStreakMRM10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Streak MRM 10";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("StreakMRM-10");
        weaponType.addLookupName("ISStreakMRM10");
        weaponType.addLookupName("IS Streak MRM 10");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 10;
        weaponType.ammoType = 47;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 4.5f;
        weaponType.criticals = 2;
        weaponType.bv = 88.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 100000.0;
        return weaponType;
    }

    private static WeaponType createISStreakMRM20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Streak MRM 20";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("StreakMRM-20");
        weaponType.addLookupName("ISStreakMRM20");
        weaponType.addLookupName("IS Streak MRM 20");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 20;
        weaponType.ammoType = 47;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 10.5f;
        weaponType.criticals = 3;
        weaponType.bv = 177.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 250000.0;
        return weaponType;
    }

    private static WeaponType createISStreakMRM30() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Streak MRM 30";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("StreakMRM-30");
        weaponType.addLookupName("ISStreakMRM30");
        weaponType.addLookupName("IS Streak MRM 30");
        weaponType.heat = 10;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 30;
        weaponType.ammoType = 47;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 15.0f;
        weaponType.criticals = 6;
        weaponType.bv = 265.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 450000.0;
        return weaponType;
    }

    private static WeaponType createISStreakMRM40() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Streak MRM 40";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("StreakMRM-40");
        weaponType.addLookupName("ISStreakMRM40");
        weaponType.addLookupName("IS Streak MRM 40");
        weaponType.heat = 12;
        weaponType.damage = -2;
        weaponType.toHitModifier = 1;
        weaponType.rackSize = 40;
        weaponType.ammoType = 47;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 3;
        weaponType.mediumRange = 8;
        weaponType.longRange = 15;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 18.0f;
        weaponType.criticals = 8;
        weaponType.bv = 353.0;
        weaponType.flags |= 0x80000L;
        weaponType.cost = 700000.0;
        return weaponType;
    }

    private static WeaponType createISHawkSRM2() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Hawk SRM 2";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("ISHawkSRM2");
        weaponType.addLookupName("IS Hawk SRM 2");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 46;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80020L;
        weaponType.bv = 28.0;
        weaponType.cost = 20000.0;
        return weaponType;
    }

    private static WeaponType createISHawkSRM4() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Hawk SRM 4";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("ISHawkSRM4");
        weaponType.addLookupName("IS Hawk SRM 4");
        weaponType.heat = 3;
        weaponType.damage = -2;
        weaponType.rackSize = 4;
        weaponType.ammoType = 46;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x80020L;
        weaponType.bv = 52.0;
        weaponType.cost = 120000.0;
        return weaponType;
    }

    private static WeaponType createISHawkSRM6() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Hawk SRM 6";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("ISHawkSRM6");
        weaponType.addLookupName("IS Hawk SRM 6");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.rackSize = 6;
        weaponType.ammoType = 46;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 4;
        weaponType.mediumRange = 8;
        weaponType.longRange = 12;
        weaponType.extremeRange = 16;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 0x80020L;
        weaponType.bv = 79.0;
        weaponType.cost = 160000.0;
        return weaponType;
    }

    private static WeaponType createISPXLRM5() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Phoenix LRM 5";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("ISPhoenixLRM5");
        weaponType.addLookupName("IS Phoenix LRM 5");
        weaponType.heat = 2;
        weaponType.damage = -2;
        weaponType.toHitModifier = -1;
        weaponType.rackSize = 5;
        weaponType.ammoType = 45;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 2.0f;
        weaponType.criticals = 1;
        weaponType.bv = 56.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 60000.0;
        return weaponType;
    }

    private static WeaponType createISPXLRM10() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Phoenix LRM 10";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("ISPhoenixLRM10");
        weaponType.addLookupName("IS Phoenix LRM 10");
        weaponType.heat = 4;
        weaponType.damage = -2;
        weaponType.toHitModifier = -1;
        weaponType.rackSize = 10;
        weaponType.ammoType = 45;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 5.0f;
        weaponType.criticals = 2;
        weaponType.bv = 111.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 200000.0;
        return weaponType;
    }

    private static WeaponType createISPXLRM15() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Phoenix LRM 15";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("ISPhoenixLRM15");
        weaponType.addLookupName("IS Phoenix LRM 15");
        weaponType.heat = 5;
        weaponType.damage = -2;
        weaponType.toHitModifier = -1;
        weaponType.rackSize = 15;
        weaponType.ammoType = 45;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 7.0f;
        weaponType.criticals = 3;
        weaponType.bv = 167.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 350000.0;
        return weaponType;
    }

    private static WeaponType createISPXLRM20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Phoenix LRM 20";
        weaponType.setInternalName(weaponType.name);
        weaponType.addLookupName("ISPhoenixLRM20");
        weaponType.addLookupName("IS Phoenix LRM 20");
        weaponType.heat = 6;
        weaponType.damage = -2;
        weaponType.toHitModifier = -1;
        weaponType.rackSize = 20;
        weaponType.ammoType = 45;
        weaponType.minimumRange = 6;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 14;
        weaponType.longRange = 21;
        weaponType.extremeRange = 28;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 5;
        weaponType.bv = 223.0;
        weaponType.setModes(new String[]{"", "Indirect"});
        weaponType.flags |= 0x80000L;
        weaponType.cost = 500000.0;
        return weaponType;
    }

    private static WeaponType createISMPod() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "M-Pod";
        weaponType.setInternalName("ISMPod");
        weaponType.addLookupName("ISMPod");
        weaponType.addLookupName("ISM-Pod");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 15;
        weaponType.ammoType = 48;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x28001L;
        weaponType.bv = 5.0;
        weaponType.cost = 6000.0;
        return weaponType;
    }

    private static WeaponType createCLMPod() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 6;
        weaponType.name = "M-Pod";
        weaponType.setInternalName("CLMPod");
        weaponType.addLookupName("CLMPod");
        weaponType.addLookupName("CLM-Pod");
        weaponType.heat = 0;
        weaponType.damage = -3;
        weaponType.rackSize = 15;
        weaponType.ammoType = 48;
        weaponType.minimumRange = 0;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 1.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x28001L;
        weaponType.bv = 5.0;
        weaponType.cost = 6000.0;
        return weaponType;
    }

    private static WeaponType createISSBGaussRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 5;
        weaponType.name = "Silver Bullet Gauss Rifle";
        weaponType.setInternalName("ISSBGaussRifle");
        weaponType.addLookupName("ISSBGaussRifle");
        weaponType.heat = 1;
        weaponType.rackSize = 15;
        weaponType.ammoType = 52;
        weaponType.minimumRange = 2;
        weaponType.shortRange = 7;
        weaponType.mediumRange = 15;
        weaponType.longRange = 22;
        weaponType.extremeRange = 30;
        weaponType.tonnage = 15.0f;
        weaponType.criticals = 7;
        weaponType.flags |= 0x24021L;
        weaponType.explosive = true;
        weaponType.bv = 169.0;
        weaponType.cost = 350000.0;
        return weaponType;
    }

    private static WeaponType createCLHAG20() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "HAG/20";
        weaponType.setInternalName("CLHAG20");
        weaponType.addLookupName("Clan HAG/20");
        weaponType.heat = 4;
        weaponType.damage = -3;
        weaponType.rackSize = 20;
        weaponType.ammoType = 49;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 8;
        weaponType.mediumRange = 16;
        weaponType.longRange = 24;
        weaponType.extremeRange = 32;
        weaponType.tonnage = 10.0f;
        weaponType.criticals = 6;
        weaponType.flags |= 0x800024001L;
        weaponType.bv = 267.0;
        weaponType.cost = 480000.0;
        weaponType.explosive = true;
        return weaponType;
    }

    private static WeaponType createCLHAG30() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "HAG/30";
        weaponType.setInternalName("CLHAG30");
        weaponType.addLookupName("Clan HAG/30");
        weaponType.heat = 4;
        weaponType.damage = -3;
        weaponType.rackSize = 30;
        weaponType.ammoType = 49;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 8;
        weaponType.mediumRange = 16;
        weaponType.longRange = 24;
        weaponType.extremeRange = 32;
        weaponType.tonnage = 13.0f;
        weaponType.criticals = 8;
        weaponType.flags |= 0x800024001L;
        weaponType.bv = 401.0;
        weaponType.cost = 480000.0;
        weaponType.explosive = true;
        return weaponType;
    }

    private static WeaponType createCLHAG40() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "HAG/40";
        weaponType.setInternalName("CLHAG40");
        weaponType.addLookupName("Clan HAG/40");
        weaponType.heat = 4;
        weaponType.damage = -3;
        weaponType.rackSize = 40;
        weaponType.ammoType = 49;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 8;
        weaponType.mediumRange = 16;
        weaponType.longRange = 24;
        weaponType.extremeRange = 32;
        weaponType.tonnage = 16.0f;
        weaponType.criticals = 10;
        weaponType.flags |= 0x800024101L;
        weaponType.bv = 535.0;
        weaponType.cost = 480000.0;
        weaponType.explosive = true;
        return weaponType;
    }

    private static WeaponType createCLPlasmaCannon() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Plasma Cannon";
        weaponType.setInternalName("CLPlasmaCannon");
        weaponType.heat = 7;
        weaponType.damage = -3;
        weaponType.rackSize = 2;
        weaponType.ammoType = 51;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 6;
        weaponType.mediumRange = 12;
        weaponType.longRange = 18;
        weaponType.extremeRange = 24;
        weaponType.tonnage = 3.0f;
        weaponType.criticals = 1;
        weaponType.flags |= 0x200040001L;
        weaponType.bv = 170.0;
        weaponType.cost = 480000.0;
        return weaponType;
    }

    private static WeaponType createISPlasmaRifle() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 1;
        weaponType.name = "Plasma Rifle";
        weaponType.setInternalName("ISPlasmaRifle");
        weaponType.heat = 10;
        weaponType.damage = -3;
        weaponType.rackSize = 1;
        weaponType.ammoType = 51;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 5;
        weaponType.mediumRange = 10;
        weaponType.longRange = 15;
        weaponType.extremeRange = 20;
        weaponType.tonnage = 6.0f;
        weaponType.criticals = 2;
        weaponType.flags |= 0x200040001L;
        weaponType.bv = 210.0;
        weaponType.cost = 480000.0;
        return weaponType;
    }

    private static WeaponType createCLMGA() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Machine Gun Array";
        weaponType.setInternalName("CLMGA");
        weaponType.addLookupName("Clan Machine Gun Array");
        weaponType.heat = 0;
        weaponType.damage = 2;
        weaponType.rackSize = 2;
        weaponType.ammoType = 3;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 3;
        weaponType.extremeRange = 4;
        weaponType.tonnage = 0.25f;
        weaponType.criticals = 1;
        weaponType.bv = 0.0;
        weaponType.flags |= 0x600020000L;
        weaponType.cost = 5000.0;
        String[] stringArray = new String[]{"Linked", "Off"};
        weaponType.setModes(stringArray);
        weaponType.instantModeSwitch = false;
        return weaponType;
    }

    private static WeaponType createCLLMGA() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Light Machine Gun Array";
        weaponType.setInternalName("CLLMGA");
        weaponType.addLookupName("Clan Light Machine Gun Array");
        weaponType.heat = 0;
        weaponType.damage = 1;
        weaponType.rackSize = 2;
        weaponType.ammoType = 5;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 2;
        weaponType.mediumRange = 4;
        weaponType.longRange = 6;
        weaponType.extremeRange = 8;
        weaponType.tonnage = 0.25f;
        weaponType.criticals = 1;
        weaponType.bv = 0.0;
        weaponType.flags |= 0x600020000L;
        weaponType.cost = 5000.0;
        String[] stringArray = new String[]{"Linked", "Off"};
        weaponType.setModes(stringArray);
        weaponType.instantModeSwitch = false;
        return weaponType;
    }

    private static WeaponType createCLHMGA() {
        WeaponType weaponType = new WeaponType();
        weaponType.techLevel = 2;
        weaponType.name = "Heavy Machine Gun Array";
        weaponType.setInternalName("CLHMGA");
        weaponType.addLookupName("Clan Heavy Machine Gun Array");
        weaponType.heat = 0;
        weaponType.damage = 3;
        weaponType.rackSize = 2;
        weaponType.ammoType = 4;
        weaponType.minimumRange = Integer.MIN_VALUE;
        weaponType.shortRange = 1;
        weaponType.mediumRange = 2;
        weaponType.longRange = 2;
        weaponType.extremeRange = 2;
        weaponType.tonnage = 0.25f;
        weaponType.criticals = 1;
        weaponType.bv = 0.0;
        weaponType.flags |= 0x600020000L;
        weaponType.cost = 5000.0;
        String[] stringArray = new String[]{"Linked", "Off"};
        weaponType.setModes(stringArray);
        weaponType.instantModeSwitch = false;
        return weaponType;
    }

    public String toString() {
        return "WeaponType: " + this.name;
    }
}

