/*
 * Decompiled with CFR 0.152.
 */
package megamek.common;

import gd.xml.ParseException;
import gd.xml.XMLParser;
import gd.xml.XMLResponder;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import megamek.common.AmmoType;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.Mech;
import megamek.common.MechFileParser;
import megamek.common.MechSummary;
import megamek.common.MechSummaryCache;
import megamek.common.Mounted;
import megamek.common.Pilot;
import megamek.common.Protomech;
import megamek.common.Tank;
import megamek.common.loaders.EntityLoadingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLStreamParser
implements XMLResponder {
    private StringBuffer warning = new StringBuffer();
    private Vector<Entity> entities = new Vector();
    private XMLParser parser = new XMLParser();
    private InputStream inStream = null;
    private Entity entity = null;
    private int loc = -1;
    private boolean locDestroyed = false;
    private int locAmmoCount = 0;
    public static final String UNIT = "unit";
    public static final String TEMPLATE = "template";
    public static final String ENTITY = "entity";
    public static final String FLUFF = "fluff";
    public static final String PILOT = "pilot";
    public static final String LOCATION = "location";
    public static final String ARMOR = "armor";
    public static final String SLOT = "slot";
    public static final String MOVEMENT = "movement";
    public static final String TURRETLOCK = "turretlock";
    public static final String CHASSIS = "chassis";
    public static final String MODEL = "model";
    public static final String NAME = "name";
    public static final String GUNNERY = "gunnery";
    public static final String PILOTING = "piloting";
    public static final String HITS = "hits";
    public static final String ADVS = "advantages";
    public static final String AUTOEJECT = "autoeject";
    public static final String INDEX = "index";
    public static final String IS_DESTROYED = "isDestroyed";
    public static final String POINTS = "points";
    public static final String TYPE = "type";
    public static final String IS_REAR = "isRear";
    public static final String SHOTS = "shots";
    public static final String IS_HIT = "isHit";
    public static final String MUNITION = "munition";
    public static final String SPEED = "speed";
    public static final String DIRECTION = "direction";
    public static final String DEAD = "Dead";
    public static final String NA = "N/A";
    public static final String DESTROYED = "Destroyed";
    public static final String FRONT = "Front";
    public static final String REAR = "Rear";
    public static final String INTERNAL = "Internal";
    public static final String EMPTY = "Empty";
    public static final String SYSTEM = "System";

    private void destroyLocation(Entity entity, int n) {
        entity.setArmor(-3, n, false);
        entity.setInternal(-3, n);
        if (entity.hasRearArmor(n)) {
            entity.setArmor(-3, n, true);
        }
        for (Mounted serializable : entity.getEquipment()) {
            if (serializable.getLocation() != n) continue;
            serializable.setDestroyed(true);
        }
        for (int i = 0; i < entity.getNumberOfCriticals(n); ++i) {
            CriticalSlot criticalSlot = entity.getCritical(n, i);
            if (criticalSlot == null) continue;
            criticalSlot.setDestroyed(true);
        }
        if (entity.getDependentLocation(n) != -1) {
            this.destroyLocation(entity, entity.getDependentLocation(n));
        }
    }

    public XMLStreamParser() {
    }

    public void parse(InputStream inputStream) throws ParseException {
        this.warning = new StringBuffer();
        this.entities.removeAllElements();
        this.inStream = inputStream;
        this.parser.parseXML((XMLResponder)this);
    }

    public XMLStreamParser(InputStream inputStream) throws ParseException {
        this.parse(inputStream);
    }

    public boolean hasWarningMessage() {
        return this.warning.length() > 0;
    }

    public String getWarningMessage() {
        if (this.warning.length() > 0) {
            return this.warning.toString();
        }
        return null;
    }

    public Vector<Entity> getEntities() {
        return this.entities;
    }

    public void recordNotationDeclaration(String string, String string2, String string3) throws ParseException {
    }

    public void recordEntityDeclaration(String string, String string2, String string3, String string4, String string5) throws ParseException {
    }

    public void recordElementDeclaration(String string, String string2) throws ParseException {
    }

    public void recordAttlistDeclaration(String string, String string2, boolean bl, String string3, String string4, String string5) throws ParseException {
    }

    public void recordDoctypeDeclaration(String string, String string2, String string3) throws ParseException {
    }

    public void recordDocStart() {
    }

    public void recordDocEnd() {
    }

    public void recordElementStart(String string, Hashtable hashtable) throws ParseException {
        if (string.equals(UNIT)) {
            if (this.entity != null) {
                this.warning.append("Found a unit while parsing an Entity.\n");
            } else if (!this.entities.isEmpty()) {
                this.warning.append("Found a second unit.  Clearing first unit.\n");
                this.entities.removeAllElements();
            }
        } else if (!string.equals(TEMPLATE)) {
            if (string.equals(ENTITY)) {
                if (this.entity != null) {
                    this.warning.append("Found another Entity while parsing an Entity.\n");
                } else if (this.loc != -1) {
                    this.warning.append("Found another Entity while parsing a location.\n");
                } else {
                    String string2 = (String)hashtable.get(CHASSIS);
                    String string3 = (String)hashtable.get(MODEL);
                    if (string2 == null || string2.length() == 0) {
                        this.warning.append("Could not find chassis for Entity.\n");
                    } else {
                        MechSummary mechSummary = null;
                        StringBuffer stringBuffer = new StringBuffer(string2);
                        mechSummary = MechSummaryCache.getInstance().getMech(stringBuffer.toString());
                        if (string3 != null && string3.length() > 0) {
                            stringBuffer.append(" ").append(string3);
                            mechSummary = MechSummaryCache.getInstance().getMech(stringBuffer.toString());
                            if (mechSummary == null) {
                                stringBuffer = new StringBuffer(string3);
                                stringBuffer.append(" ").append(string2);
                                mechSummary = MechSummaryCache.getInstance().getMech(stringBuffer.toString());
                            }
                        }
                        if (mechSummary == null) {
                            this.warning.append("Could not find Entity with chassis: ");
                            this.warning.append(string2);
                            if (string3 != null && string3.length() > 0) {
                                this.warning.append(", and model: ");
                                this.warning.append(string3);
                            }
                            this.warning.append(".\n");
                        } else {
                            try {
                                this.entity = new MechFileParser(mechSummary.getSourceFile(), mechSummary.getEntryName()).getEntity();
                            }
                            catch (EntityLoadingException entityLoadingException) {
                                entityLoadingException.printStackTrace(System.err);
                                this.warning.append("Unable to load mech: ").append(mechSummary.getSourceFile()).append(": ").append(mechSummary.getEntryName()).append(": ").append(entityLoadingException.getMessage());
                            }
                        }
                    }
                }
            } else if (!string.equals(FLUFF)) {
                if (string.equals(PILOT)) {
                    if (this.entity == null) {
                        this.warning.append("Found a pilot outside of an Entity.\n");
                    } else if (this.loc != -1) {
                        this.warning.append("Found a pilot while parsing a location.\n");
                    } else {
                        String string4 = (String)hashtable.get(NAME);
                        String string5 = (String)hashtable.get(GUNNERY);
                        String string6 = (String)hashtable.get(PILOTING);
                        String string7 = (String)hashtable.get(HITS);
                        String string8 = (String)hashtable.get(ADVS);
                        String string9 = (String)hashtable.get(AUTOEJECT);
                        if (string5 == null || string5.length() == 0) {
                            this.warning.append("Could not find gunnery for pilot.\n");
                        } else if (string6 == null || string6.length() == 0) {
                            this.warning.append("Could not find piloting for pilot.\n");
                        } else {
                            int n = -1;
                            try {
                                n = Integer.parseInt(string5);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n < 0 || n > 7) {
                                this.warning.append("Found invalid gunnery value: ").append(string5).append(".\n");
                                return;
                            }
                            int n2 = -1;
                            try {
                                n2 = Integer.parseInt(string6);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n2 < 0 || n2 > 7) {
                                this.warning.append("Found invalid piloting value: ").append(string6).append(".\n");
                                return;
                            }
                            Pilot pilot = this.entity.getCrew();
                            if (null == string4 || string4.length() == 0) {
                                string4 = pilot.getName();
                            }
                            pilot = new Pilot(string4, n, n2);
                            if (null != string8 && string8.trim().length() > 0) {
                                StringTokenizer stringTokenizer = new StringTokenizer(string8, "::");
                                while (stringTokenizer.hasMoreTokens()) {
                                    String string10 = stringTokenizer.nextToken();
                                    String string11 = Pilot.parseAdvantageName(string10);
                                    Object object = Pilot.parseAdvantageValue(string10);
                                    try {
                                        pilot.getOptions().getOption(string11).setValue(object);
                                    }
                                    catch (Exception exception) {
                                        this.warning.append("Error restoring advantage: ").append(string10).append(".\n");
                                    }
                                }
                            }
                            if (string7 != null) {
                                int n3 = -1;
                                try {
                                    n3 = Integer.parseInt(string7);
                                }
                                catch (NumberFormatException numberFormatException) {
                                    // empty catch block
                                }
                                if (string7.equals(DEAD)) {
                                    pilot.setDead(true);
                                    this.warning.append("The pilot, ").append(string4).append(", is dead.\n");
                                } else if (n3 < 0 || n3 > 5) {
                                    this.warning.append("Found invalid hits value: ").append(string7).append(".\n");
                                } else {
                                    pilot.setHits(n3);
                                }
                            }
                            this.entity.setCrew(pilot);
                            if (string9 != null) {
                                if (string9.equals("true")) {
                                    ((Mech)this.entity).setAutoEject(true);
                                } else {
                                    ((Mech)this.entity).setAutoEject(false);
                                }
                            }
                        }
                    }
                } else if (string.equals(LOCATION)) {
                    if (this.entity == null) {
                        this.warning.append("Found a location outside of an Entity.\n");
                    } else if (this.loc != -1) {
                        this.warning.append("Found a location while parsing a location.\n");
                    } else {
                        String string12 = (String)hashtable.get(INDEX);
                        String string13 = (String)hashtable.get(IS_DESTROYED);
                        if (string12 == null || string12.length() == 0) {
                            this.warning.append("Could not find index for location.\n");
                        } else {
                            int n = -1;
                            try {
                                n = Integer.parseInt(string12);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (n < 0 || n > 7) {
                                this.warning.append("Found invalid index value for location: ").append(string12).append(".\n");
                                return;
                            }
                            if (n >= this.entity.locations()) {
                                this.warning.append("The entity, ").append(this.entity.getShortName()).append(" does not have a location at index: ").append(n).append(".\n");
                                return;
                            }
                            this.loc = n;
                            this.locAmmoCount = 0;
                            this.locDestroyed = false;
                            try {
                                if (string13 != null) {
                                    this.locDestroyed = string13.equals("true");
                                }
                            }
                            catch (Throwable throwable) {
                                this.warning.append("Found invalid isDestroyed value: ").append(string13).append(".\n");
                            }
                        }
                    }
                } else if (string.equals(TURRETLOCK)) {
                    if (this.entity == null) {
                        this.warning.append("Found turret lock outside of an Entity.\n");
                    } else if (!(this.entity instanceof Tank)) {
                        this.warning.append("Turret crit record found outside a Tank.\n");
                    }
                    String string14 = (String)hashtable.get(DIRECTION);
                    try {
                        int n = Integer.parseInt(string14);
                        ((Tank)this.entity).setSecondaryFacing(n);
                        ((Tank)this.entity).lockTurret();
                    }
                    catch (Exception exception) {
                        System.err.println(exception);
                        exception.printStackTrace();
                        this.warning.append("Invalid turret lock direction value in movement tag.\n");
                    }
                } else if (string.equals(MOVEMENT)) {
                    if (this.entity == null) {
                        this.warning.append("Found movement crit outside of an Entity.\n");
                    } else if (!(this.entity instanceof Tank)) {
                        this.warning.append("Movement crit record found outside a Tank.\n");
                    }
                    String string15 = (String)hashtable.get(SPEED);
                    if (string15.equals("immobile")) {
                        ((Tank)this.entity).immobilize();
                    } else {
                        try {
                            int n = Integer.parseInt(string15);
                            this.entity.setOriginalWalkMP(n);
                        }
                        catch (Exception exception) {
                            this.warning.append("Invalid speed value in movement tag.\n");
                        }
                    }
                } else if (string.equals(ARMOR)) {
                    if (this.entity == null) {
                        this.warning.append("Found armor outside of an Entity.\n");
                    } else if (this.loc == -1) {
                        this.warning.append("Found armor while outside of a location.\n");
                    } else {
                        String string16 = (String)hashtable.get(POINTS);
                        String string17 = (String)hashtable.get(TYPE);
                        if (string16 == null || string16.length() == 0) {
                            this.warning.append("Could not find points for armor.\n");
                        } else {
                            int n = -1;
                            try {
                                n = Integer.parseInt(string16);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (string16.equals(NA)) {
                                n = -1;
                            } else if (string16.equals(DESTROYED)) {
                                n = -3;
                            } else if (n < 0 || n > 100) {
                                this.warning.append("Found invalid points value: ").append(string16).append(".\n");
                                return;
                            }
                            if (string17 == null || string17.equals(FRONT)) {
                                if (this.entity.getOArmor(this.loc) < n) {
                                    this.warning.append("The entity, ").append(this.entity.getShortName()).append(" does not start with ").append(n).append(" points of armor for location: ").append(this.loc).append(".\n");
                                } else {
                                    this.entity.setArmor(n, this.loc);
                                }
                            } else if (string17.equals(INTERNAL)) {
                                if (this.entity.getOInternal(this.loc) < n) {
                                    this.warning.append("The entity, ").append(this.entity.getShortName()).append(" does not start with ").append(n).append(" points of internal structure for location: ").append(this.loc).append(".\n");
                                } else {
                                    this.entity.setInternal(n, this.loc);
                                }
                            } else if (string17.equals(REAR)) {
                                if (!this.entity.hasRearArmor(this.loc)) {
                                    this.warning.append("The entity, ").append(this.entity.getShortName()).append(" has no rear armor for location: ").append(this.loc).append(".\n");
                                } else if (this.entity.getOArmor(this.loc, true) < n) {
                                    this.warning.append("The entity, ").append(this.entity.getShortName()).append(" does not start with ").append(n).append(" points of rear armor for location: ").append(this.loc).append(".\n");
                                } else {
                                    this.entity.setArmor(n, this.loc, true);
                                }
                            }
                        }
                    }
                } else if (string.equals(SLOT)) {
                    if (this.entity == null) {
                        this.warning.append("Found a slot outside of an Entity.\n");
                    } else if (this.loc == -1) {
                        this.warning.append("Found a slot while outside of a location.\n");
                    } else {
                        String string18 = (String)hashtable.get(INDEX);
                        String string19 = (String)hashtable.get(TYPE);
                        String string20 = (String)hashtable.get(SHOTS);
                        String string21 = (String)hashtable.get(IS_HIT);
                        String string22 = (String)hashtable.get(IS_DESTROYED);
                        String string23 = (String)hashtable.get(MUNITION);
                        if (string18 == null || string18.length() == 0) {
                            this.warning.append("Could not find index for slot.\n");
                        } else if (string19 == null || string19.length() == 0) {
                            this.warning.append("Could not find type for slot.\n");
                        } else {
                            int n = -1;
                            try {
                                n = Integer.parseInt(string18);
                                --n;
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            if (string18.equals(NA)) {
                                n = -1;
                                if (this.entity instanceof Tank || this.entity instanceof Protomech) {
                                    EquipmentType equipmentType = EquipmentType.get(string19);
                                    if (equipmentType instanceof AmmoType) {
                                        int n4 = -1;
                                        Iterator<Mounted> iterator = this.entity.getAmmo().iterator();
                                        while (iterator.hasNext() && n4 < this.locAmmoCount) {
                                            Mounted mounted = iterator.next();
                                            if (mounted.getLocation() != this.loc || ++n4 != this.locAmmoCount) continue;
                                            ++this.locAmmoCount;
                                            mounted.restore();
                                            int n5 = -1;
                                            try {
                                                n5 = Integer.parseInt(string20);
                                            }
                                            catch (NumberFormatException numberFormatException) {
                                                // empty catch block
                                            }
                                            if (string20.equals(NA)) {
                                                n5 = -1;
                                                this.warning.append("Expected to find number of shots for ").append(string19).append(", but found ").append(string20).append(" instead.\n");
                                            } else if (n5 < 0 || n5 > 200) {
                                                this.warning.append("Found invalid shots value for slot: ").append(string20).append(".\n");
                                            } else {
                                                mounted.changeAmmoType((AmmoType)equipmentType);
                                                mounted.setShotsLeft(n5);
                                            }
                                            break;
                                        }
                                    } else {
                                        this.warning.append("XML file lists ").append(string19).append(" equipment at location ").append(this.loc).append(".  XML parser expected ammo.\n");
                                    }
                                }
                                return;
                            }
                            if (n < 0 || n > 12) {
                                this.warning.append("Found invalid index value for slot: ").append(string18).append(".\n");
                                return;
                            }
                            if (n > this.entity.getNumberOfCriticals(this.loc)) {
                                this.warning.append("The entity, ").append(this.entity.getShortName()).append(" does not have ").append(string18).append(" slots in location ").append(this.loc).append(".\n");
                                return;
                            }
                            boolean bl = false;
                            try {
                                if (string21 != null) {
                                    bl = string21.equals("true");
                                }
                            }
                            catch (Throwable throwable) {
                                this.warning.append("Found invalid isHit value: ").append(string21).append(".\n");
                            }
                            boolean bl2 = false;
                            try {
                                if (string22 != null) {
                                    bl2 = string22.equals("true");
                                }
                            }
                            catch (Throwable throwable) {
                                this.warning.append("Found invalid isDestroyed value: ").append(string22).append(".\n");
                            }
                            CriticalSlot criticalSlot = this.entity.getCritical(this.loc, n);
                            if (criticalSlot == null) {
                                if (!string19.equals(EMPTY)) {
                                    this.warning.append("Could not find the ").append(string19).append(" equipment that was expected at index ").append(n).append(" of location ").append(this.loc).append(".\n");
                                }
                                return;
                            }
                            if (criticalSlot.getType() == 0) {
                                if (!string19.equals(SYSTEM)) {
                                    this.warning.append("XML file expects to find ").append(string19).append(" equipment at index ").append(n).append(" of location ").append(this.loc).append(", but Entity has a system.\n");
                                }
                            } else {
                                EquipmentType equipmentType;
                                Mounted mounted = this.entity.getEquipment(criticalSlot.getIndex());
                                mounted.restore();
                                mounted.setDestroyed(bl || bl2);
                                if (mounted.getType() instanceof AmmoType) {
                                    equipmentType = EquipmentType.get(string19);
                                    if (equipmentType instanceof AmmoType) {
                                        int n6 = -1;
                                        try {
                                            n6 = Integer.parseInt(string20);
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            // empty catch block
                                        }
                                        if (string20.equals(NA)) {
                                            n6 = -1;
                                            this.warning.append("Expected to find number of shots for ").append(string19).append(", but found ").append(string20).append(" instead.\n");
                                        } else if (n6 < 0 || n6 > 200) {
                                            this.warning.append("Found invalid shots value for slot: ").append(string20).append(".\n");
                                        } else {
                                            mounted.changeAmmoType((AmmoType)equipmentType);
                                            mounted.setShotsLeft(n6);
                                        }
                                    } else {
                                        this.warning.append("XML file expects ").append(string19).append(" equipment at index ").append(n).append(" of location ").append(this.loc).append(", but Entity has ").append(mounted.getType().getInternalName()).append("there .\n");
                                    }
                                } else if (!mounted.getType().getInternalName().equals(string19)) {
                                    this.warning.append("XML file expects ").append(string19).append(" equipment at index ").append(n).append(" of location ").append(this.loc).append(", but Entity has ").append(mounted.getType().getInternalName()).append("there .\n");
                                }
                                if (string23 != null) {
                                    equipmentType = EquipmentType.get(string23);
                                    if (equipmentType instanceof AmmoType) {
                                        mounted.getLinked().changeAmmoType((AmmoType)equipmentType);
                                    } else {
                                        this.warning.append("XML file expects ").append(" ammo for munition argument of ").append(" slot tag.\n");
                                    }
                                }
                            }
                            criticalSlot.setHit(bl);
                            criticalSlot.setDestroyed(bl2);
                        }
                    }
                }
            }
        }
    }

    public void recordElementEnd(String string) throws ParseException {
        if (string.equals(UNIT)) {
            if (this.entity != null) {
                this.warning.append("End of unit while parsing an Entity.\n");
                if (this.loc != -1) {
                    this.warning.append("Found end of unit while parsing a location.\n");
                    if (this.locDestroyed) {
                        this.destroyLocation(this.entity, this.loc);
                    }
                    this.loc = -1;
                }
                this.entities.addElement(this.entity);
                this.entity = null;
            } else if (this.entities.isEmpty()) {
                this.warning.append("Found an empty unit.\n");
            }
        } else if (!string.equals(TEMPLATE)) {
            if (string.equals(ENTITY)) {
                if (this.entity == null) {
                    this.warning.append("Found end of Entity, but not parsing an Entity.\n");
                } else {
                    if (this.loc != -1) {
                        this.warning.append("Found end of Entity while parsing a location.\n");
                        if (this.locDestroyed) {
                            this.destroyLocation(this.entity, this.loc);
                        }
                        this.loc = -1;
                    }
                    this.entities.addElement(this.entity);
                    this.entity = null;
                }
            } else if (!string.equals(FLUFF) && !string.equals(PILOT)) {
                if (string.equals(LOCATION)) {
                    if (this.entity == null) {
                        this.warning.append("Found end of location, but not parsing an Entity.\n");
                    } else if (this.loc == -1) {
                        this.warning.append("Found end of location, but not parsing a location.\n");
                    } else {
                        if (this.locDestroyed) {
                            this.destroyLocation(this.entity, this.loc);
                        }
                        this.loc = -1;
                    }
                } else if (string.equals(ARMOR) || string.equals(SLOT)) {
                    // empty if block
                }
            }
        }
    }

    public void recordPI(String string, String string2) {
    }

    public void recordCharData(String string) {
    }

    public void recordComment(String string) {
    }

    public InputStream getDocumentStream() throws ParseException {
        if (this.inStream == null) {
            throw new ParseException("Input document stream not defined.");
        }
        return this.inStream;
    }

    public InputStream resolveExternalEntity(String string, String string2, String string3) throws ParseException {
        return null;
    }

    public InputStream resolveDTDEntity(String string, String string2, String string3) throws ParseException {
        return null;
    }
}

