/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.loaders;

import gd.xml.ParseException;
import gd.xml.tiny.ParsedXML;
import gd.xml.tiny.TinyParser;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import megamek.common.BipedMech;
import megamek.common.CriticalSlot;
import megamek.common.Engine;
import megamek.common.Entity;
import megamek.common.EquipmentType;
import megamek.common.LocationFullException;
import megamek.common.Mech;
import megamek.common.Mounted;
import megamek.common.QuadMech;
import megamek.common.WeaponType;
import megamek.common.loaders.EntityLoadingException;
import megamek.common.loaders.IMechLoader;

public class TdbFile
implements IMechLoader {
    private ParsedXML root = null;
    private static final String CREATOR_SECTION = "creator";
    private static final String BASICS_SECTION = "basics";
    private static final String ITEM_DEFS_SECTION = "itemdefs";
    private static final String MOUNTED_ITEMS_SECTION = "mounteditems";
    private static final String CRIT_DEFS_SECTION = "critdefs";
    private static final String NAME = "name";
    private static final String VERSION = "version";
    private static final String MODEL = "model";
    private static final String VARIANT = "variant";
    private static final String TECHNOLOGY = "technology";
    private static final String MOVEMECHMOD = "movemechmod";
    private static final String TONNAGE = "tonnage";
    private static final String TYPE = "type";
    private static final String OMNI = "isomni";
    private static final String WALK = "walk";
    private static final String JUMP = "jump";
    private static final String HEAT_SINKS = "heatsinks";
    private static final String ARMOR = "armor";
    private static final String ENGINE = "engine";
    private static final String GYRO = "gyro";
    private static final String COCKPIT = "cockpit";
    private static final String STRUCTURE = "internal";
    private static final String MOUNTED_ITEM = "mounteditem";
    private static final String LOCATION = "location";
    private static final String TARGSYS = "targsys";
    private static final String LEVEL = "level";
    private static final String COUNT = "count";
    private static final String POINTS = "points";
    private static final String REAR_MOUNTED = "rearmounted";
    private static final String IS_SPREAD = "isspread";
    private static final String ITEM_INDEX = "itemindex";
    private static final String REAR_ARMOR = "reararmor";
    private static final String RATING = "rating";
    private static final String TRUE = "True";
    private static final String FALSE = "False";
    private static final String DOUBLE = "Double";
    private static final String LASER = "Laser";
    private static final String COMPACT = "Compact (2)";
    private static final String TRUE_LOWER = "true";
    private String creatorName = "Unknown";
    private String creatorVersion = "Unknown";
    private String name;
    private boolean isOmni = false;
    private String model;
    private String variant;
    private String chassisConfig;
    private String techBase;
    private static final String techYear = "3068";
    private String rulesLevel;
    private String LAMTonnage;
    private String tonnage;
    private String heatSinks;
    private boolean dblSinks;
    private String walkMP;
    private String jumpMP;
    private int larmArmor;
    private int rarmArmor;
    private int ltArmor;
    private int rtArmor;
    private int ctArmor;
    private int headArmor;
    private int llegArmor;
    private int rlegArmor;
    private int ltrArmor;
    private int rtrArmor;
    private int ctrArmor;
    private String[][][] critData;
    private boolean[] isRearMounted;
    private boolean[] isSplit;
    private String armorType;
    private String engineType;
    private int engineRating;
    private String structureType;
    private String targSysStr;
    private String gyroType = "Standard";
    private String cockpitType = "Standard";
    private boolean clanTC = false;
    private Hashtable<EquipmentType, Mounted> hSharedEquip = new Hashtable();
    private Vector<Mounted> vSplitWeapons = new Vector();

    public TdbFile(InputStream inputStream) throws EntityLoadingException {
        try {
            this.root = TinyParser.parseXML((InputStream)inputStream);
        }
        catch (ParseException parseException) {
            throw new EntityLoadingException("   Failure to parse XML (" + parseException.getLocalizedMessage() + ")");
        }
        this.isRearMounted = new boolean[256];
        this.isSplit = new boolean[256];
        this.critData = new String[8][12][2];
        this.parseNode((ParsedXML)this.root.elements().nextElement());
    }

    private void parseNode(ParsedXML parsedXML) throws EntityLoadingException {
        if (!parsedXML.getTypeName().equals("tag")) {
            return;
        }
        Enumeration enumeration = parsedXML.elements();
        if (parsedXML.getName().equals(CREATOR_SECTION)) {
            this.parseCreatorNode(parsedXML);
        } else if (parsedXML.getName().equals(BASICS_SECTION)) {
            this.parseBasicsNode(parsedXML);
        } else {
            if (parsedXML.getName().equals(ITEM_DEFS_SECTION)) {
                return;
            }
            if (parsedXML.getName().equals(MOUNTED_ITEMS_SECTION)) {
                this.parseMountedNode(parsedXML);
            } else if (parsedXML.getName().equals(CRIT_DEFS_SECTION)) {
                this.parseCritNode(parsedXML);
            } else if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    this.parseNode((ParsedXML)enumeration.nextElement());
                }
            }
        }
    }

    private void parseCreatorNode(ParsedXML parsedXML) throws EntityLoadingException {
        if (!parsedXML.getTypeName().equals("tag")) {
            return;
        }
        Enumeration enumeration = parsedXML.elements();
        if (parsedXML.getName().equals(NAME)) {
            this.creatorName = ((ParsedXML)enumeration.nextElement()).getContent();
        } else if (parsedXML.getName().equals(VERSION)) {
            this.creatorVersion = ((ParsedXML)enumeration.nextElement()).getContent();
        } else if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                this.parseCreatorNode((ParsedXML)enumeration.nextElement());
            }
        }
    }

    private void parseBasicsNode(ParsedXML parsedXML) throws EntityLoadingException {
        if (!parsedXML.getTypeName().equals("tag")) {
            return;
        }
        Enumeration enumeration = parsedXML.elements();
        if (parsedXML.getName().equals(NAME)) {
            this.name = ((ParsedXML)enumeration.nextElement()).getContent();
        } else if (parsedXML.getName().equals(MODEL)) {
            this.model = ((ParsedXML)enumeration.nextElement()).getContent();
        } else if (parsedXML.getName().equals(OMNI)) {
            this.isOmni = ((ParsedXML)enumeration.nextElement()).getContent().equals(TRUE_LOWER);
        } else if (parsedXML.getName().equals(VARIANT)) {
            this.variant = ((ParsedXML)enumeration.nextElement()).getContent();
        } else if (parsedXML.getName().equals(TECHNOLOGY)) {
            this.techBase = ((ParsedXML)enumeration.nextElement()).getContent();
            this.rulesLevel = parsedXML.getAttribute(LEVEL);
        } else if (parsedXML.getName().equals(TONNAGE)) {
            this.tonnage = ((ParsedXML)enumeration.nextElement()).getContent();
        } else if (parsedXML.getName().equals(TYPE)) {
            this.chassisConfig = ((ParsedXML)enumeration.nextElement()).getContent();
        } else if (parsedXML.getName().equals(MOVEMECHMOD)) {
            this.LAMTonnage = parsedXML.getAttribute(TONNAGE);
        } else if (parsedXML.getName().equals(WALK)) {
            this.walkMP = ((ParsedXML)enumeration.nextElement()).getContent();
        } else if (parsedXML.getName().equals(JUMP)) {
            this.jumpMP = ((ParsedXML)enumeration.nextElement()).getContent();
        } else if (parsedXML.getName().equals(HEAT_SINKS)) {
            this.dblSinks = ((ParsedXML)enumeration.nextElement()).getContent().indexOf(DOUBLE) != -1;
            this.heatSinks = parsedXML.getAttribute(COUNT);
        } else if (parsedXML.getName().equals(ARMOR)) {
            this.armorType = ((ParsedXML)enumeration.nextElement()).getContent();
        } else if (parsedXML.getName().equals(ENGINE)) {
            this.engineType = ((ParsedXML)enumeration.nextElement()).getContent();
            this.engineRating = Integer.parseInt(parsedXML.getAttribute(RATING));
        } else if (parsedXML.getName().equals(STRUCTURE)) {
            this.structureType = ((ParsedXML)enumeration.nextElement()).getContent();
        } else if (parsedXML.getName().equals(GYRO)) {
            this.gyroType = ((ParsedXML)enumeration.nextElement()).getContent();
        } else if (parsedXML.getName().equals(COCKPIT)) {
            this.cockpitType = ((ParsedXML)enumeration.nextElement()).getContent();
        } else if (parsedXML.getName().equals(TARGSYS)) {
            this.targSysStr = ((ParsedXML)enumeration.nextElement()).getContent().trim();
            if (this.targSysStr.length() >= 3 && this.targSysStr.substring(0, 3).equals("(C)")) {
                this.clanTC = true;
            }
        } else if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                this.parseBasicsNode((ParsedXML)enumeration.nextElement());
            }
        }
    }

    private void parseMountedNode(ParsedXML parsedXML) throws EntityLoadingException {
        if (!parsedXML.getTypeName().equals("tag")) {
            return;
        }
        Enumeration enumeration = parsedXML.elements();
        if (parsedXML.getName().equals(MOUNTED_ITEM)) {
            this.isRearMounted[Integer.parseInt((String)parsedXML.getAttribute((String)ITEM_INDEX))] = parsedXML.getAttribute(REAR_MOUNTED).equals(TRUE);
            this.isSplit[Integer.parseInt((String)parsedXML.getAttribute((String)ITEM_INDEX))] = parsedXML.getAttribute(IS_SPREAD).equals(TRUE);
        } else if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                this.parseMountedNode((ParsedXML)enumeration.nextElement());
            }
        }
    }

    private void parseCritNode(ParsedXML parsedXML) throws EntityLoadingException {
        block23: {
            Enumeration enumeration;
            block22: {
                if (!parsedXML.getTypeName().equals("tag")) {
                    return;
                }
                enumeration = parsedXML.elements();
                if (!parsedXML.getName().equals(LOCATION)) break block22;
                int n = -1;
                int n2 = 0;
                int n3 = -1;
                int n4 = -1;
                if (parsedXML.getAttribute(ARMOR) != null) {
                    n3 = Integer.parseInt(parsedXML.getAttribute(ARMOR));
                }
                if (parsedXML.getAttribute(REAR_ARMOR) != null) {
                    n4 = Integer.parseInt(parsedXML.getAttribute(REAR_ARMOR));
                }
                if (parsedXML.getAttribute(NAME).equals("LA") || parsedXML.getAttribute(NAME).equals("FLL")) {
                    n = 5;
                    this.larmArmor = n3;
                } else if (parsedXML.getAttribute(NAME).equals("RA") || parsedXML.getAttribute(NAME).equals("FRL")) {
                    n = 4;
                    this.rarmArmor = n3;
                } else if (parsedXML.getAttribute(NAME).equals("LT")) {
                    n = 3;
                    this.ltArmor = n3;
                    this.ltrArmor = n4;
                } else if (parsedXML.getAttribute(NAME).equals("RT")) {
                    n = 2;
                    this.rtArmor = n3;
                    this.rtrArmor = n4;
                } else if (parsedXML.getAttribute(NAME).equals("CT")) {
                    n = 1;
                    this.ctArmor = n3;
                    this.ctrArmor = n4;
                } else if (parsedXML.getAttribute(NAME).equals("H")) {
                    n = 0;
                    this.headArmor = n3;
                } else if (parsedXML.getAttribute(NAME).equals("LL") || parsedXML.getAttribute(NAME).equals("RLL")) {
                    n = 7;
                    this.llegArmor = n3;
                } else if (parsedXML.getAttribute(NAME).equals("RL") || parsedXML.getAttribute(NAME).equals("RRL")) {
                    n = 6;
                    this.rlegArmor = n3;
                }
                if (n == -1) {
                    throw new EntityLoadingException("   Bad Mech location: " + parsedXML.getAttribute(NAME));
                }
                while (enumeration.hasMoreElements()) {
                    ParsedXML parsedXML2 = (ParsedXML)enumeration.nextElement();
                    this.critData[n][n2][0] = ((ParsedXML)parsedXML2.elements().nextElement()).getContent();
                    if (this.clanTC && this.critData[n][n2][0].equals("Targeting Computer")) {
                        this.critData[n][n2][0] = "(C) " + this.critData[n][n2][0];
                    }
                    this.critData[n][n2++][1] = parsedXML2.getAttribute(ITEM_INDEX);
                }
                break block23;
            }
            if (enumeration == null) break block23;
            while (enumeration.hasMoreElements()) {
                this.parseCritNode((ParsedXML)enumeration.nextElement());
            }
        }
    }

    public Entity getEntity() throws EntityLoadingException {
        try {
            Mech mech;
            block49: {
                block50: {
                    block48: {
                        if (this.creatorName == "Unknown" || !this.creatorName.equals("The Drawing Board") || Integer.parseInt(this.creatorVersion) != 2) {
                            throw new EntityLoadingException("This xml file is not a valid Drawing Board mech.  Make sure you are using version 2.0.23 or later of The Drawing Board.");
                        }
                        if (this.gyroType.equals("Extra-Light")) {
                            this.gyroType = "XL";
                        } else if (this.gyroType.equals("Heavy-Duty")) {
                            this.gyroType = "Heavy Duty";
                        }
                        if (this.cockpitType.equals("Torso-Mounted")) {
                            this.cockpitType = "Torso Mounted";
                        }
                        mech = this.chassisConfig.equals("Quad") ? new QuadMech(this.gyroType, this.cockpitType) : new BipedMech(this.gyroType, this.cockpitType);
                        int n = this.name.indexOf("(");
                        if (n == -1) {
                            mech.setChassis(this.name);
                        } else {
                            mech.setChassis(this.name.substring(0, n - 1));
                        }
                        if (this.variant != null) {
                            mech.setModel(this.variant);
                        } else if (this.model != null) {
                            mech.setModel(this.model);
                        } else {
                            mech.setModel("");
                        }
                        mech.setYear(Integer.parseInt(techYear));
                        mech.setOmni(this.isOmni);
                        if (this.structureType.substring(0, 3).equals("(C)")) {
                            this.structureType = this.structureType.substring(4);
                        }
                        mech.setStructureType(this.structureType);
                        if (this.armorType.substring(0, 3).equals("(C)")) {
                            this.armorType = this.armorType.substring(4);
                        }
                        mech.setArmorType(this.armorType);
                        if (this.LAMTonnage != null) {
                            throw new EntityLoadingException("Unsupported tech: LAM?");
                        }
                        if (!this.techBase.equals("Inner Sphere")) break block48;
                        switch (Integer.parseInt(this.rulesLevel)) {
                            case 1: {
                                mech.setTechLevel(0);
                                break block49;
                            }
                            case 2: {
                                mech.setTechLevel(1);
                                break block49;
                            }
                            case 3: {
                                mech.setTechLevel(5);
                                break block49;
                            }
                            default: {
                                throw new EntityLoadingException("Unsupported tech level: " + this.rulesLevel);
                            }
                        }
                    }
                    if (!this.techBase.equals("Clan")) break block50;
                    switch (Integer.parseInt(this.rulesLevel)) {
                        case 2: {
                            mech.setTechLevel(2);
                            break block49;
                        }
                        case 3: {
                            mech.setTechLevel(6);
                            break block49;
                        }
                        default: {
                            throw new EntityLoadingException("Unsupported tech level: " + this.rulesLevel);
                        }
                    }
                }
                if (this.techBase.equals("Mixed (IS Chassis)") || this.techBase.equals("Inner Sphere 'C'")) {
                    mech.setTechLevel(5);
                    mech.setMixedTech(true);
                } else if (this.techBase.equals("Mixed (Clan Chassis)")) {
                    mech.setTechLevel(6);
                    mech.setMixedTech(true);
                } else {
                    throw new EntityLoadingException("Unsupported tech base: " + this.techBase);
                }
            }
            mech.setWeight(Integer.parseInt(this.tonnage));
            if (this.jumpMP != null) {
                mech.setOriginalJumpMP(Integer.parseInt(this.jumpMP));
            }
            int n = 0;
            if (mech.isClan() && !mech.isMixedTech() || mech.isMixedTech() && mech.isClan() && !mech.itemOppositeTech(this.engineType)) {
                n = 1;
            }
            mech.setEngine(new Engine(this.engineRating, Engine.getEngineTypeByString(this.engineType), n));
            int n2 = Integer.parseInt(this.heatSinks);
            mech.autoSetInternal();
            mech.initializeArmor(this.larmArmor, 5);
            mech.initializeArmor(this.rarmArmor, 4);
            mech.initializeArmor(this.ltArmor, 3);
            mech.initializeArmor(this.rtArmor, 2);
            mech.initializeArmor(this.ctArmor, 1);
            mech.initializeArmor(this.headArmor, 0);
            mech.initializeArmor(this.llegArmor, 7);
            mech.initializeArmor(this.rlegArmor, 6);
            mech.initializeRearArmor(this.ltrArmor, 3);
            mech.initializeRearArmor(this.rtrArmor, 2);
            mech.initializeRearArmor(this.ctrArmor, 1);
            this.compactCriticals(mech);
            for (int i = mech.locations() - 1; i >= 0; --i) {
                this.parseCrits(mech, i);
            }
            if (mech.isClan()) {
                mech.addClanCase();
            }
            mech.addEngineSinks(n2 - mech.heatSinks(), this.dblSinks);
            if (this.targSysStr.startsWith("Long-Range")) {
                mech.setTargSysType(2);
            } else if (this.targSysStr.startsWith("Short-Range")) {
                mech.setTargSysType(3);
            } else if (this.targSysStr.startsWith("Variable-Range")) {
                mech.setTargSysType(4);
            } else if (this.targSysStr.startsWith("Anti-Aircraft")) {
                mech.setTargSysType(5);
            } else if (this.targSysStr.startsWith("Multi-Trac")) {
                mech.setTargSysType(6);
            } else if (this.targSysStr.startsWith("Multi-Trac II")) {
                mech.setTargSysType(7);
            } else if (this.targSysStr.startsWith("Targeting Computer")) {
                mech.setTargSysType(1);
            }
            return mech;
        }
        catch (NumberFormatException numberFormatException) {
            throw new EntityLoadingException("NumberFormatException parsing file");
        }
        catch (NullPointerException nullPointerException) {
            throw new EntityLoadingException("NullPointerException parsing file");
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new EntityLoadingException("StringIndexOutOfBoundsException parsing file");
        }
    }

    private void parseCrits(Mech mech, int n) throws EntityLoadingException {
        if (!(mech instanceof QuadMech || n != 5 && n != 4)) {
            if (!this.critData[n][3][0].equals("Hand Actuator")) {
                mech.setCritical(n, 3, null);
            }
            if (!this.critData[n][2][0].equals("Lower Arm Actuator")) {
                mech.setCritical(n, 2, null);
            }
        }
        for (int i = 0; i < mech.getNumberOfCriticals(n); ++i) {
            if (mech.getCritical(n, i) != null) continue;
            String string = this.critData[n][i][0];
            boolean bl = true;
            if (this.critData[n][i][1] == null || !this.isRearMounted[Integer.parseInt(this.critData[n][i][1])]) {
                bl = false;
            }
            boolean bl2 = true;
            if (this.critData[n][i][1] == null || !this.isSplit[Integer.parseInt(this.critData[n][i][1])]) {
                bl2 = false;
            }
            if (string.equalsIgnoreCase("Armored Cowl")) {
                mech.setCowl(5);
            }
            if (string.indexOf("Engine") != -1) {
                mech.setCritical(n, i, new CriticalSlot(0, 3));
                continue;
            }
            if (string.indexOf("Gyro") != -1) {
                mech.setCritical(n, i, new CriticalSlot(0, 4));
                continue;
            }
            if (string.indexOf("Life Support") != -1) {
                mech.setCritical(n, i, new CriticalSlot(0, 0));
                continue;
            }
            if (string.indexOf("Sensors") != -1) {
                mech.setCritical(n, i, new CriticalSlot(0, 1));
                continue;
            }
            if (string.indexOf("Cockpit") != -1) {
                mech.setCritical(n, i, new CriticalSlot(0, 2));
                continue;
            }
            if (string.endsWith("[LRM]") || string.endsWith("[SRM]")) {
                string = string.substring(0, 14);
            }
            if (string.endsWith("- Artemis IV")) {
                string = string.substring(0, string.indexOf(" - Artemis IV"));
            }
            if (string.endsWith("- Narc")) {
                string = string.substring(0, string.indexOf(" - Narc"));
            }
            if (string.equals("(C) Endosteel")) {
                string = string.substring(4);
            }
            if (string.equals("(C) Ferro-Fibrous Armor")) {
                string = string.substring(4);
            }
            try {
                String string2;
                if (string.startsWith("(C)")) {
                    string2 = "Clan ";
                    string = string.substring(4);
                } else if (string.startsWith("(IS)")) {
                    string2 = "IS ";
                    string = string.substring(5);
                } else {
                    string2 = mech.isClan() ? "Clan " : "IS ";
                }
                EquipmentType equipmentType = EquipmentType.get(string2 + string);
                if (equipmentType == null) {
                    equipmentType = EquipmentType.get(string);
                }
                if (equipmentType != null) {
                    Mounted mounted;
                    if (equipmentType.isSpreadable()) {
                        mounted = this.hSharedEquip.get(equipmentType);
                        if (mounted != null) {
                            mech.addCritical(n, new CriticalSlot(1, mech.getEquipmentNum(mounted), equipmentType.isHittable()));
                            continue;
                        }
                        mounted = mech.addEquipment(equipmentType, n, bl);
                        this.hSharedEquip.put(equipmentType, mounted);
                        continue;
                    }
                    if (equipmentType instanceof WeaponType && equipmentType.hasFlag(256L)) {
                        int n2;
                        mounted = null;
                        boolean bl3 = false;
                        int n3 = this.vSplitWeapons.size();
                        for (n2 = 0; n2 < n3; ++n2) {
                            mounted = this.vSplitWeapons.elementAt(n2);
                            int n4 = mounted.getLocation();
                            if (n4 != n && n != Mech.getInnerLocation(n4) || mounted.getType() != equipmentType) continue;
                            bl3 = true;
                            break;
                        }
                        if (bl3) {
                            mounted.setFoundCrits(mounted.getFoundCrits() + 1);
                            if (mounted.getFoundCrits() >= equipmentType.getCriticals(mech)) {
                                this.vSplitWeapons.removeElement(mounted);
                            }
                            if (n != mounted.getLocation()) {
                                mounted.setSplit(true);
                            }
                            n2 = mounted.getLocation();
                            mounted.setLocation(Mech.mostRestrictiveLoc(n, n2));
                            if (n != n2) {
                                mounted.setSecondLocation(Mech.leastRestrictiveLoc(n, n2));
                            }
                        } else {
                            mounted = new Mounted(mech, equipmentType);
                            mounted.setFoundCrits(1);
                            this.vSplitWeapons.addElement(mounted);
                        }
                        mech.addEquipment(mounted, n, bl);
                        continue;
                    }
                    mech.addEquipment(equipmentType, n, bl);
                    continue;
                }
                if (string.equals("Empty")) continue;
                mech.addFailedEquipment(string);
                this.critData[n][i][0] = "Empty";
                this.critData[n][i][1] = null;
                this.compactCriticals(mech, n);
                --i;
                continue;
            }
            catch (LocationFullException locationFullException) {
                throw new EntityLoadingException(locationFullException.getMessage());
            }
        }
    }

    private void compactCriticals(Mech mech) {
        for (int i = 0; i < mech.locations(); ++i) {
            this.compactCriticals(mech, i);
        }
    }

    private void compactCriticals(Mech mech, int n) {
        if (n == 0) {
            return;
        }
        int n2 = -1;
        for (int i = 0; i < mech.getNumberOfCriticals(n); ++i) {
            if (n2 == -1 && this.critData[n][i][0].equals("Empty")) {
                n2 = i;
            }
            if (n2 == -1 || this.critData[n][i][0].equals("Empty")) continue;
            this.critData[n][n2][0] = this.critData[n][i][0];
            this.critData[n][n2][1] = this.critData[n][i][1];
            this.critData[n][i][0] = "Empty";
            this.critData[n][i][1] = null;
            i = n2;
            n2 = -1;
        }
    }
}

