/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.util;

import java.io.File;
import java.util.Enumeration;
import java.util.TreeMap;
import java.util.Vector;
import megamek.common.util.Categorized;
import megamek.common.util.Collections;
import megamek.common.util.ItemFile;
import megamek.common.util.ItemFileFactory;
import megamek.common.util.StringUtil;
import megamek.common.util.ZippedItems;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryItems
implements Categorized {
    private String rootName;
    private TreeMap<String, Categorized> categories = new TreeMap(StringUtil.stringComparator());
    private TreeMap<String, ItemFile> items = new TreeMap(StringUtil.stringComparator());
    private ItemFileFactory factory = null;

    private void addCategory(Categorized categorized) {
        Enumeration<String> enumeration = categorized.getCategoryNames();
        while (enumeration.hasMoreElements()) {
            this.categories.put(enumeration.nextElement(), categorized);
        }
    }

    public DirectoryItems(File file, String string, ItemFileFactory itemFileFactory) throws IllegalArgumentException {
        if (null == file) {
            throw new IllegalArgumentException("A null root directory was passed.");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("The passed file is not a directory.");
        }
        if (null == itemFileFactory) {
            throw new IllegalArgumentException("A null item factory was passed.");
        }
        this.rootName = string;
        this.factory = itemFileFactory;
        if (null == this.rootName) {
            this.rootName = "";
        }
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            StringBuffer stringBuffer;
            File file2 = new File(file, stringArray[i]);
            if (file2.isDirectory()) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.rootName).append(stringArray[i]).append("/");
                this.addCategory(new DirectoryItems(file2, stringBuffer.toString(), this.factory));
                continue;
            }
            if (ZippedItems.isZipName(stringArray[i])) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.rootName).append(stringArray[i]);
                try {
                    this.addCategory(new ZippedItems(file2, stringBuffer.toString(), this.factory));
                }
                catch (Exception exception) {
                    System.err.print("Could not parse ");
                    System.err.println(stringArray[i]);
                    exception.printStackTrace();
                }
                continue;
            }
            if (!this.factory.accept(file, stringArray[i])) continue;
            this.items.put(stringArray[i], this.factory.getItemFile(file2));
        }
        if (!this.items.isEmpty()) {
            this.categories.put(this.rootName, this);
        }
    }

    @Override
    public Enumeration<String> getCategoryNames() {
        return Collections.elements(this.categories.keySet());
    }

    @Override
    public Enumeration<String> getItemNames(String string) {
        Categorized categorized = this.categories.get(string);
        if (null == categorized) {
            return new Vector().elements();
        }
        if (this != categorized) {
            return categorized.getItemNames(string);
        }
        return Collections.elements(this.items.keySet());
    }

    @Override
    public Object getItem(String string, String string2) throws Exception {
        if (null == string) {
            throw new IllegalArgumentException("A null category name was passed.");
        }
        if (null == string2) {
            throw new IllegalArgumentException("A null item name was passed.");
        }
        if (!this.categories.containsKey(string)) {
            return null;
        }
        Categorized categorized = this.categories.get(string);
        if (this != categorized) {
            return categorized.getItem(string, string2);
        }
        if (!this.items.containsKey(string2)) {
            return null;
        }
        ItemFile itemFile = this.items.get(string2);
        return itemFile.getItem();
    }
}

