/*
 * Decompiled with CFR 0.152.
 */
package megamek.common.xml;

import gd.xml.tiny.ParsedXML;
import java.io.IOException;
import java.io.Writer;
import java.util.Enumeration;
import megamek.common.Coords;
import megamek.common.Entity;
import megamek.common.GameTurn;
import megamek.common.IGame;
import megamek.common.Minefield;
import megamek.common.PilotingRollData;
import megamek.common.Player;
import megamek.common.Team;
import megamek.common.actions.EntityAction;
import megamek.common.xml.BoardEncoder;
import megamek.common.xml.EntityActionEncoder;
import megamek.common.xml.EntityEncoder;
import megamek.common.xml.GameOptionsEncoder;
import megamek.common.xml.GameTurnEncoder;
import megamek.common.xml.MinefieldEncoder;
import megamek.common.xml.PilotingRollDataEncoder;
import megamek.common.xml.PlayerEncoder;
import megamek.common.xml.TeamEncoder;

public class GameEncoder {
    public static void encode(IGame iGame, Writer writer) throws IOException {
        Enumeration<Object> enumeration;
        if (null == iGame) {
            throw new IllegalArgumentException("The game is null.");
        }
        if (null == writer) {
            throw new IllegalArgumentException("The writer is null.");
        }
        writer.write("<game version=\"1.0\">");
        if (null != iGame.getOptions()) {
            GameOptionsEncoder.encode(iGame.getOptions(), writer);
        }
        if (null != iGame.getBoard()) {
            BoardEncoder.encode(iGame.getBoard(), writer);
        }
        if ((enumeration = iGame.getMinedCoords()).hasMoreElements()) {
            writer.write("<minefields>");
            while (enumeration.hasMoreElements()) {
                Coords coords = (Coords)enumeration.nextElement();
                Enumeration<Minefield> enumeration2 = iGame.getMinefields(coords).elements();
                while (enumeration2.hasMoreElements()) {
                    MinefieldEncoder.encode(enumeration2.nextElement(), writer);
                }
            }
            writer.write("</minefields>");
        }
        if ((enumeration = iGame.getPlayers()).hasMoreElements()) {
            writer.write("<players>");
            while (enumeration.hasMoreElements()) {
                PlayerEncoder.encode((Player)enumeration.nextElement(), writer);
            }
            writer.write("</players>");
        }
        if ((enumeration = iGame.getTeams()).hasMoreElements()) {
            writer.write("<teams>");
            while (enumeration.hasMoreElements()) {
                TeamEncoder.encode((Team)enumeration.nextElement(), writer);
            }
            writer.write("</teams>");
        }
        if ((enumeration = iGame.getEntities()).hasMoreElements()) {
            writer.write("<entities set=\"IN-GAME\">");
            while (enumeration.hasMoreElements()) {
                EntityEncoder.encode((Entity)enumeration.nextElement(), writer);
            }
            writer.write("</entities>");
        }
        if ((enumeration = iGame.getOutOfGameEntitiesVector().elements()).hasMoreElements()) {
            writer.write("<entities set=\"OUT-GAME\">");
            while (enumeration.hasMoreElements()) {
                EntityEncoder.encode((Entity)enumeration.nextElement(), writer);
            }
            writer.write("</entities>");
        }
        if ((enumeration = iGame.getTurns()).hasMoreElements()) {
            writer.write("<turns>");
            while (enumeration.hasMoreElements()) {
                GameTurnEncoder.encode((GameTurn)enumeration.nextElement(), writer);
            }
            writer.write("</turns>");
        }
        if ((enumeration = iGame.getActions()).hasMoreElements()) {
            writer.write("<actions>");
            while (enumeration.hasMoreElements()) {
                EntityActionEncoder.encode((EntityAction)enumeration.nextElement(), writer);
            }
            writer.write("</actions>");
        }
        if ((enumeration = iGame.getPSRs()).hasMoreElements()) {
            writer.write("<PSRs>");
            while (enumeration.hasMoreElements()) {
                PilotingRollDataEncoder.encode((PilotingRollData)enumeration.nextElement(), writer);
            }
            writer.write("</PSRs>");
        }
        writer.write("<gameData ");
        writer.write("windDirection=\"");
        writer.write(iGame.getWindDirection());
        writer.write("\" roundCount=\"");
        writer.write(iGame.getRoundCount());
        writer.write("\" phase=\"");
        writer.write(iGame.getPhase());
        writer.write("\" lastPhase=\"");
        writer.write(iGame.getLastPhase());
        writer.write("\" forceVictory=\"");
        writer.write(iGame.isForceVictory() ? "true" : "false");
        writer.write("\" victoryPlayerId=\"");
        writer.write(iGame.getVictoryPlayerId());
        writer.write("\" victoryTeam=\"");
        writer.write(iGame.getVictoryTeam());
        writer.write("\" />");
        writer.write("</game>");
    }

    public static IGame decode(ParsedXML parsedXML) {
        return null;
    }
}

