/*
 * Decompiled with CFR 0.152.
 */
package megamek.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import megamek.MegaMek;
import megamek.common.AmmoType;
import megamek.common.BattleArmor;
import megamek.common.BipedMech;
import megamek.common.Board;
import megamek.common.Building;
import megamek.common.BuildingTarget;
import megamek.common.Compute;
import megamek.common.Coords;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.EntitySelector;
import megamek.common.EquipmentMode;
import megamek.common.EquipmentType;
import megamek.common.Flare;
import megamek.common.FuelTank;
import megamek.common.Game;
import megamek.common.GameTurn;
import megamek.common.GunEmplacement;
import megamek.common.HexTarget;
import megamek.common.HitData;
import megamek.common.IBoard;
import megamek.common.IGame;
import megamek.common.IHex;
import megamek.common.INarcPod;
import megamek.common.ITerrain;
import megamek.common.Infantry;
import megamek.common.InfernoTracker;
import megamek.common.LocationFullException;
import megamek.common.LosEffects;
import megamek.common.MapSettings;
import megamek.common.Mech;
import megamek.common.MechWarrior;
import megamek.common.Minefield;
import megamek.common.MiscType;
import megamek.common.Mounted;
import megamek.common.MovePath;
import megamek.common.MoveStep;
import megamek.common.NarcPod;
import megamek.common.PhysicalResult;
import megamek.common.Pilot;
import megamek.common.PilotingRollData;
import megamek.common.Player;
import megamek.common.Protomech;
import megamek.common.QuadMech;
import megamek.common.Report;
import megamek.common.RoundUpdated;
import megamek.common.TagInfo;
import megamek.common.Tank;
import megamek.common.TargetRoll;
import megamek.common.Targetable;
import megamek.common.Team;
import megamek.common.Terrain;
import megamek.common.Terrains;
import megamek.common.ToHitData;
import megamek.common.TurnOrdered;
import megamek.common.TurnVectors;
import megamek.common.UnitLocation;
import megamek.common.VTOL;
import megamek.common.WeaponResult;
import megamek.common.WeaponType;
import megamek.common.actions.AbstractAttackAction;
import megamek.common.actions.AbstractEntityAction;
import megamek.common.actions.ArtilleryAttackAction;
import megamek.common.actions.AttackAction;
import megamek.common.actions.BreakGrappleAttackAction;
import megamek.common.actions.BrushOffAttackAction;
import megamek.common.actions.ChargeAttackAction;
import megamek.common.actions.ClearMinefieldAction;
import megamek.common.actions.ClubAttackAction;
import megamek.common.actions.DfaAttackAction;
import megamek.common.actions.DisplacementAttackAction;
import megamek.common.actions.DodgeAction;
import megamek.common.actions.EntityAction;
import megamek.common.actions.FindClubAction;
import megamek.common.actions.FlipArmsAction;
import megamek.common.actions.GrappleAttackAction;
import megamek.common.actions.JumpJetAttackAction;
import megamek.common.actions.KickAttackAction;
import megamek.common.actions.LayExplosivesAttackAction;
import megamek.common.actions.LayMinefieldAction;
import megamek.common.actions.NukeAttackAction;
import megamek.common.actions.ProtomechPhysicalAttackAction;
import megamek.common.actions.PunchAttackAction;
import megamek.common.actions.PushAttackAction;
import megamek.common.actions.SearchlightAttackAction;
import megamek.common.actions.SpotAction;
import megamek.common.actions.ThrashAttackAction;
import megamek.common.actions.TorsoTwistAction;
import megamek.common.actions.TriggerAPPodAction;
import megamek.common.actions.TripAttackAction;
import megamek.common.actions.UnjamAction;
import megamek.common.actions.UnloadStrandedAction;
import megamek.common.actions.WeaponAttackAction;
import megamek.common.net.Connection;
import megamek.common.net.ConnectionFactory;
import megamek.common.net.ConnectionListenerAdapter;
import megamek.common.net.DisconnectedEvent;
import megamek.common.net.Packet;
import megamek.common.net.PacketReceivedEvent;
import megamek.common.options.IBasicOption;
import megamek.common.options.IOption;
import megamek.common.preference.PreferenceManager;
import megamek.common.util.BoardUtilities;
import megamek.common.util.StringUtil;
import megamek.common.verifier.EntityVerifier;
import megamek.common.verifier.TestEntity;
import megamek.common.verifier.TestMech;
import megamek.common.verifier.TestTank;
import megamek.server.DynamicTerrainProcessor;
import megamek.server.ElevatorProcessor;
import megamek.server.FireProcessor;
import megamek.server.GeyserProcessor;
import megamek.server.UnitStatusFormatter;
import megamek.server.commands.DefeatCommand;
import megamek.server.commands.ExportListCommand;
import megamek.server.commands.FixElevationCommand;
import megamek.server.commands.HelpCommand;
import megamek.server.commands.KickCommand;
import megamek.server.commands.LocalSaveGameCommand;
import megamek.server.commands.NukeCommand;
import megamek.server.commands.ResetCommand;
import megamek.server.commands.RollCommand;
import megamek.server.commands.SaveGameCommand;
import megamek.server.commands.SeeAllCommand;
import megamek.server.commands.ServerCommand;
import megamek.server.commands.SkipCommand;
import megamek.server.commands.TeamCommand;
import megamek.server.commands.VictoryCommand;
import megamek.server.commands.WhoCommand;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Server
implements Runnable {
    public static final String DEFAULT_BOARD = "[SURPRISE]";
    private static final String VERIFIER_CONFIG_FILENAME = "data/mechfiles/UnitVerifierOptions.xml";
    private String password;
    private ServerSocket serverSocket;
    private String motd;
    private Vector<Connection> connections = new Vector(4);
    private Vector<Connection> connectionsPending = new Vector(4);
    private Hashtable<Integer, Connection> connectionIds = new Hashtable();
    private int connectionCounter;
    private IGame game = new Game();
    private Vector<Report> vPhaseReport = new Vector();
    private MapSettings mapSettings = new MapSettings();
    private Hashtable<String, ServerCommand> commandsHash = new Hashtable();
    private Thread connector;
    private Hashtable<Building, Boolean> affectedBldgs = new Hashtable();
    private Vector<PhysicalResult> physicalResults = new Vector();
    private Vector<DynamicTerrainProcessor> terrainProcessors = new Vector();
    private Timer timer = new Timer();
    private static EntityVerifier entityVerifier;
    private ConnectionListenerAdapter connectionListener = new ConnectionListenerAdapter(){

        public void disconnected(DisconnectedEvent disconnectedEvent) {
            Connection connection = disconnectedEvent.getConnection();
            System.out.println("s: connection " + connection.getId() + " disconnected");
            Server.this.connections.removeElement(connection);
            Server.this.connectionsPending.removeElement(connection);
            Server.this.connectionIds.remove(new Integer(connection.getId()));
            Player player = Server.this.getPlayer(connection.getId());
            if (null != player) {
                Server.this.disconnected(player);
            }
        }

        public void packetReceived(PacketReceivedEvent packetReceivedEvent) {
            Server.this.handle(packetReceivedEvent.getConnection().getId(), packetReceivedEvent.getPacket());
        }
    };
    private static final String DUNE_CALL = "They tried and failed?";
    private static final String DUNE_RESPONSE = "They tried and died!";
    private static final String STAR_WARS_CALL = "I'd just as soon kiss a Wookiee.";
    private static final String STAR_WARS_RESPONSE = "I can arrange that!";

    public Server(String string, int n) throws IOException {
        this.password = string.length() > 0 ? string : null;
        this.serverSocket = new ServerSocket(n);
        this.motd = this.createMotd();
        this.game.getOptions().initialize();
        this.game.getOptions().loadOptions();
        this.changePhase(1);
        System.out.println("s: starting a new server...");
        try {
            String string2 = InetAddress.getLocalHost().getHostName();
            System.out.print("s: hostname = '");
            System.out.print(string2);
            System.out.print("' port = ");
            System.out.println(this.serverSocket.getLocalPort());
            InetAddress[] inetAddressArray = InetAddress.getAllByName(string2);
            for (int i = 0; i < inetAddressArray.length; ++i) {
                System.out.println("s: hosting on address = " + inetAddressArray[i].getHostAddress());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        System.out.println("s: password = " + this.password);
        this.registerCommand(new DefeatCommand(this));
        this.registerCommand(new ExportListCommand(this));
        this.registerCommand(new FixElevationCommand(this));
        this.registerCommand(new HelpCommand(this));
        this.registerCommand(new KickCommand(this));
        this.registerCommand(new LocalSaveGameCommand(this));
        this.registerCommand(new NukeCommand(this));
        this.registerCommand(new ResetCommand(this));
        this.registerCommand(new RollCommand(this));
        this.registerCommand(new SaveGameCommand(this));
        this.registerCommand(new SeeAllCommand(this));
        this.registerCommand(new SkipCommand(this));
        this.registerCommand(new VictoryCommand(this));
        this.registerCommand(new WhoCommand(this));
        this.registerCommand(new TeamCommand(this));
        this.terrainProcessors.add(new FireProcessor(this));
        this.terrainProcessors.add(new GeyserProcessor(this));
        this.terrainProcessors.add(new ElevatorProcessor(this));
        this.connector = new Thread((Runnable)this, "Connection Listener");
        this.connector.start();
    }

    public void setGame(IGame iGame) {
        TurnOrdered turnOrdered;
        this.game = iGame;
        Enumeration<TurnOrdered> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            turnOrdered = enumeration.nextElement();
            ((Entity)turnOrdered).setGame(this.game);
        }
        this.game.setOutOfGameEntitiesVector(this.game.getOutOfGameEntitiesVector());
        enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            turnOrdered = (Player)enumeration.nextElement();
            ((Player)turnOrdered).setGame(this.game);
            ((Player)turnOrdered).setGhost(true);
        }
    }

    public IGame getGame() {
        return this.game;
    }

    private String createMotd() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Welcome to MegaMek.  Server is running version ");
        stringBuffer.append(MegaMek.VERSION);
        stringBuffer.append(", build date ");
        if (MegaMek.TIMESTAMP > 0L) {
            stringBuffer.append(new Date(MegaMek.TIMESTAMP).toString());
        } else {
            stringBuffer.append("unknown");
        }
        stringBuffer.append('.');
        return stringBuffer.toString();
    }

    public boolean isPassworded() {
        return this.password != null;
    }

    public boolean isPassword(Object object) {
        return this.password.equals(object);
    }

    private void registerCommand(ServerCommand serverCommand) {
        this.commandsHash.put(serverCommand.getName(), serverCommand);
    }

    public ServerCommand getCommand(String string) {
        return this.commandsHash.get(string);
    }

    public void die() {
        Connection connection;
        this.timer.cancel();
        this.connector = null;
        try {
            this.serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Enumeration<Connection> enumeration = this.connectionsPending.elements();
        while (enumeration.hasMoreElements()) {
            connection = enumeration.nextElement();
            connection.close();
        }
        this.connectionsPending.removeAllElements();
        enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            connection = enumeration.nextElement();
            this.send(connection.getId(), new Packet(0));
        }
        enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            connection = enumeration.nextElement();
            connection.close();
        }
        this.connections.removeAllElements();
        this.connectionIds.clear();
        System.out.flush();
    }

    public Enumeration<String> getAllCommandNames() {
        return this.commandsHash.keys();
    }

    private void greeting(int n) {
        this.sendToPending(n, new Packet(10));
    }

    public int getFreeConnectionId() {
        while (this.getPendingConnection(this.connectionCounter) != null || this.getConnection(this.connectionCounter) != null || this.getPlayer(this.connectionCounter) != null) {
            ++this.connectionCounter;
        }
        return this.connectionCounter;
    }

    public int getFreeEntityId() {
        return this.game.getNextEntityId();
    }

    private void receivePlayerInfo(Packet packet, int n) {
        Player player = (Player)packet.getObject(0);
        Player player2 = this.game.getPlayer(n);
        if (null != player2) {
            player2.setColorIndex(player.getColorIndex());
            player2.setStartingPos(player.getStartingPos());
            player2.setTeam(player.getTeam());
            player2.setCamoCategory(player.getCamoCategory());
            player2.setCamoFileName(player.getCamoFileName());
            player2.setNbrMFConventional(player.getNbrMFConventional());
            player2.setNbrMFCommand(player.getNbrMFCommand());
            player2.setNbrMFVibra(player.getNbrMFVibra());
        }
    }

    private String correctDupeName(String string) {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            if (!player.getName().equals(string)) continue;
            String string2 = string;
            int n = 2;
            try {
                n = Integer.parseInt(string.substring(string.lastIndexOf(".") + 1));
                ++n;
                string2 = string.substring(0, string.lastIndexOf("."));
            }
            catch (Exception exception) {
                n = 2;
            }
            string2 = string2.concat(".").concat(Integer.toString(n));
            return this.correctDupeName(string2);
        }
        return string;
    }

    private void receivePlayerName(Packet packet, int n) {
        Object object;
        Connection connection = this.getPendingConnection(n);
        String string = (String)packet.getObject(0);
        boolean bl = false;
        if (connection == null) {
            System.out.println("server: got a client name from a non-pending connection");
            return;
        }
        Object object2 = this.game.getPlayers();
        while (object2.hasMoreElements()) {
            object = object2.nextElement();
            if (!((Player)object).getName().equals(string) || !((Player)object).isGhost()) continue;
            bl = true;
            ((Player)object).setGhost(false);
            n = ((Player)object).getId();
            connection.setId(n);
        }
        if (!bl) {
            string = this.correctDupeName(string);
            this.send(n, new Packet(480, string));
        }
        this.connectionsPending.removeElement(connection);
        this.connections.addElement(connection);
        this.connectionIds.put(new Integer(connection.getId()), connection);
        if (!bl) {
            this.game.addPlayer(n, new Player(n, string));
            this.validatePlayerInfo(n);
        }
        object2 = this.getPlayer(n);
        if (this.game.getPhase() != 1 && null != object2 && this.game.getEntitiesOwnedBy((Player)object2) < 1) {
            ((Player)object2).setObserver(true);
        }
        this.sendServerChat(n, this.motd);
        this.send(this.createPlayerConnectPacket(n));
        this.send(n, new Packet(30, new Integer(n)));
        this.sendCurrentInfo(n);
        try {
            object = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            for (int i = 0; i < ((InetAddress[])object).length; ++i) {
                this.sendServerChat(n, "Machine IP is " + object[i].getHostAddress());
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.sendServerChat(n, "Listening on port " + this.serverSocket.getLocalPort());
        object2 = this.getPlayer(n);
        if (null != object2) {
            object = new StringBuffer();
            ((StringBuffer)object).append(((Player)object2).getName()).append(" connected from ").append(this.getClient(n).getInetAddress());
            String string2 = ((StringBuffer)object).toString();
            System.out.print("s: player #");
            System.out.print(n);
            System.out.print(", ");
            System.out.println(string2);
            this.sendServerChat(string2);
        }
    }

    private void sendCurrentInfo(int n) {
        this.transmitAllPlayerConnects(n);
        this.send(n, this.createGameSettingsPacket());
        Player player = this.game.getPlayer(n);
        if (null != player) {
            this.send(n, new Packet(420, player.getMinefields()));
            switch (this.game.getPhase()) {
                case 1: {
                    this.send(n, this.createMapSettingsPacket());
                    this.send(n, new Packet(240, new Integer(this.game.getPhase())));
                    if (this.doBlind()) {
                        this.send(n, this.createFilteredFullEntitiesPacket(player));
                        break;
                    }
                    this.send(n, this.createFullEntitiesPacket());
                    break;
                }
                default: {
                    this.send(n, new Packet(260, new Integer(this.game.getRoundCount())));
                    this.send(n, this.createAllReportsPacket(player));
                    if (this.doBlind()) {
                        this.send(n, this.createFilteredFullEntitiesPacket(player));
                    } else {
                        this.send(n, this.createFullEntitiesPacket());
                    }
                    player.setDone(this.game.getEntitiesOwnedBy(player) <= 0);
                    this.send(n, this.createBoardPacket());
                    this.send(n, new Packet(240, new Integer(this.game.getPhase())));
                }
            }
            if (this.game.getPhase() == 12 || this.game.getPhase() == 7 || this.game.getPhase() == 10 || this.game.getPhase() == 14) {
                this.send(n, this.createAttackPacket(this.game.getActionsVector(), 0));
                this.send(n, this.createAttackPacket(this.game.getChargesVector(), 1));
                this.send(n, this.createAttackPacket(this.game.getLayMinefieldActionsVector(), 2));
            }
            if (this.game.phaseHasTurns(this.game.getPhase())) {
                this.send(n, this.createTurnVectorPacket());
                this.send(n, this.createTurnIndexPacket());
            }
            this.send(n, this.createArtilleryPacket(player));
            this.send(n, this.createFlarePacket());
        }
    }

    public void sendEntities(int n) {
        if (this.doBlind()) {
            this.send(n, this.createFilteredEntitiesPacket(this.getPlayer(n)));
        } else {
            this.send(n, this.createEntitiesPacket());
        }
    }

    public void validatePlayerInfo(int n) {
        Player player = this.getPlayer(n);
        boolean[] blArray = new boolean[Player.colorNames.length];
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player2 = enumeration.nextElement();
            if (player2.getId() == n) continue;
            blArray[player2.getColorIndex()] = true;
        }
        if (null != player && blArray[player.getColorIndex()]) {
            for (int i = 0; i < blArray.length; ++i) {
                if (blArray[i]) continue;
                player.setColorIndex(i);
                break;
            }
        }
    }

    void disconnected(Player player) {
        int n = this.game.getPhase();
        if (n == 1) {
            this.removeAllEntitesOwnedBy(player);
        }
        if (this.game.getEntitiesOwnedBy(player) > 0 && n != 18) {
            player.setGhost(true);
            player.setDone(true);
            this.send(this.createPlayerUpdatePacket(player.getId()));
        } else {
            this.game.removePlayer(player.getId());
            this.send(new Packet(50, new Integer(player.getId())));
        }
        if (this.game.phaseHasTurns(this.game.getPhase()) && null != this.game.getTurn()) {
            if (this.game.getTurn().isValid(player.getId(), this.game)) {
                this.sendGhostSkipMessage(player);
            }
        } else {
            this.checkReady();
        }
        this.sendServerChat(player.getName() + " disconnected.");
        System.out.println("s: removed player " + player.getName());
        if (0 == this.game.getNoOfPlayers()) {
            this.resetGame();
        }
    }

    public void checkForObservers() {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player;
            player.setObserver(this.game.getEntitiesOwnedBy(player = enumeration.nextElement()) < 1 && this.game.getPhase() != 1);
        }
    }

    public void resetGame() {
        this.game.reset();
        this.send(this.createEntitiesPacket());
        this.send(new Packet(420, new Vector()));
        ArrayList<Player> arrayList = new ArrayList<Player>();
        Object object = this.game.getPlayers();
        while (object.hasMoreElements()) {
            Player player = object.nextElement();
            if (!player.isGhost()) continue;
            arrayList.add(player);
        }
        for (Player player : arrayList) {
            this.game.removePlayer(player.getId());
            this.send(new Packet(50, new Integer(player.getId())));
        }
        this.resetPlayersDone();
        this.transmitAllPlayerDones();
        object = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
        System.out.print(((DateFormat)object).format(new Date()));
        System.out.println(" END OF GAME");
        this.changePhase(1);
    }

    public void autoSave() {
        String string = "autosave";
        if (PreferenceManager.getClientPreferences().stampFilenames()) {
            string = StringUtil.addDateTimeStamp(string);
        }
        this.saveGame(string, this.game.getOptions().booleanOption("autosave_msg"));
    }

    public void sendSaveGame(int n, String string) {
        this.saveGame(string, false);
        String string2 = string;
        if (!string2.endsWith(".sav")) {
            string2 = string + ".sav";
        }
        String string3 = "savegames" + File.separator + string2;
        File file = new File(string3);
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.send(n, new Packet(490, new Object[]{string2, objectInputStream.readObject()}));
            this.sendChat(n, "***Server", "Savegame has been sent to you.");
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Unable to load file: " + file);
            exception.printStackTrace();
        }
    }

    public void saveGame(String string, boolean bl) {
        String string2 = string;
        if (!string2.endsWith(".sav")) {
            string2 = string + ".sav";
        }
        try {
            File file = new File("savegames");
            if (!file.exists()) {
                file.mkdir();
            }
            string2 = file + File.separator + string2;
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(new FileOutputStream(string2));
            objectOutputStream.writeObject(this.game);
            objectOutputStream.flush();
            objectOutputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Unable to save file: " + string2);
            exception.printStackTrace();
        }
        if (bl) {
            this.sendChat("MegaMek", "Game saved to " + string2);
        }
    }

    public void saveGame(String string) {
        this.saveGame(string, true);
    }

    public boolean loadGame(File file) {
        System.out.println("s: loading saved game file '" + file + '\'');
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new FileInputStream(file));
            this.game = (IGame)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.err.println("Unable to load file: " + file);
            exception.printStackTrace();
            return false;
        }
        this.setGame(this.game);
        return true;
    }

    public Player getPlayer(int n) {
        return this.game.getPlayer(n);
    }

    private void removeAllEntitesOwnedBy(Player player) {
        Entity entity;
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity = enumeration.nextElement();
            if (!entity.getOwner().equals(player)) continue;
            vector.addElement(entity);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entity = enumeration.nextElement();
            int n = entity.getId();
            this.game.removeEntity(n, 2048);
            this.send(this.createRemoveEntityPacket(n, 2048));
        }
    }

    private Connection getClient(int n) {
        return this.getConnection(n);
    }

    public Enumeration<Connection> getConnections() {
        return this.connections.elements();
    }

    public Connection getConnection(int n) {
        return this.connectionIds.get(new Integer(n));
    }

    private Connection getPendingConnection(int n) {
        Enumeration<Connection> enumeration = this.connectionsPending.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = enumeration.nextElement();
            if (connection.getId() != n) continue;
            return connection;
        }
        return null;
    }

    private void resetEntityRound() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            entity.newRound(this.game.getRoundCount());
        }
    }

    private void resetEntityPhase(int n) {
        int n2;
        Entity entity;
        Vector<Entity> vector = new Vector<Entity>(0, 10);
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity = enumeration.nextElement();
            if (entity.crew.isDoomed()) {
                entity.crew.setDoomed(false);
                entity.crew.setDead(true);
                if (entity instanceof Tank) {
                    entity.setCarcass(true);
                    ((Tank)entity).immobilize();
                } else {
                    entity.setDestroyed(true);
                }
            }
            if (entity.isDoomed()) {
                entity.setDestroyed(true);
                n2 = entity.getSwarmTargetId();
                if (-1 != n2) {
                    Entity entity2 = this.game.getEntity(n2);
                    entity2.setSwarmAttackerId(-1);
                    entity.setSwarmTargetId(-1);
                    Report report = new Report(5165);
                    report.subject = n2;
                    report.addDesc(entity2);
                    this.addReport(report);
                    this.entityUpdate(n2);
                }
            }
            if (!entity.isDestroyed()) continue;
            vector.addElement(entity);
        }
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            entity = enumeration.nextElement();
            n2 = 512;
            if (!entity.isSalvage()) {
                n2 = 1024;
            }
            if (entity.getRemovalCondition() == 4096) {
                n2 = 4096;
            }
            this.entityUpdate(entity.getId());
            this.game.removeEntity(entity.getId(), n2);
            this.send(this.createRemoveEntityPacket(entity.getId(), n2));
        }
        enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity = enumeration.nextElement();
            entity.applyDamage();
            entity.reloadEmptyWeapons();
            entity.damageThisPhase = 0;
            entity.engineHitsThisRound = 0;
            entity.rolledForEngineExplosion = false;
            entity.dodging = false;
            if (n == 4) {
                entity.setDone(!entity.shouldDeploy(this.game.getRoundCount()));
            } else {
                entity.setDone(false);
            }
            entity.setIlluminated(false);
            entity.setUsedSearchlight(false);
        }
    }

    private boolean isReportingPhase() {
        return this.game.getPhase() == 13 || this.game.getPhase() == 6 || this.game.getPhase() == 9 || this.game.getPhase() == 11 || this.game.getPhase() == 15;
    }

    private void resetPlayersDone() {
        if (this.isReportingPhase()) {
            return;
        }
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            player.setDone(false);
        }
        this.transmitAllPlayerDones();
    }

    private void resetActivePlayersDone() {
        if (this.isReportingPhase()) {
            return;
        }
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player;
            player.setDone(this.game.getEntitiesOwnedBy(player = enumeration.nextElement()) <= 0);
        }
        this.transmitAllPlayerDones();
    }

    private void prepareVictoryReport() {
        Object object;
        Enumeration<Entity> enumeration;
        Object object2;
        Object object3;
        Object object4;
        Vector<Entity> vector = new Vector<Entity>();
        for (Entity enumeration22 : this.game.getEntitiesVector()) {
            if (!enumeration22.isCarcass() || enumeration22.isDestroyed()) continue;
            vector.add(enumeration22);
        }
        for (Entity entity : vector) {
            this.destroyEntity(entity, "crew death", false, true);
            this.game.removeEntity(entity.getId(), 512);
            entity.setDestroyed(true);
        }
        this.addReport(new Report(7000, 0));
        Report report = new Report(1210);
        report.type = 0;
        if (this.game.getVictoryTeam() == 0) {
            object4 = this.getPlayer(this.game.getVictoryPlayerId());
            if (null == object4) {
                report.messageId = 7005;
            } else {
                report.messageId = 7010;
                report.add(((Player)object4).getName());
            }
        } else {
            report.messageId = 7015;
            report.add(this.game.getVictoryTeam());
        }
        this.addReport(report);
        object4 = this.game.getPlayers();
        while (object4.hasMoreElements()) {
            Player player = object4.nextElement();
            report = new Report();
            report.type = 0;
            report.messageId = 7016;
            report.add(player.getName());
            report.add(player.getBV());
            report.add(player.getInitialBV());
            this.addReport(report);
        }
        Enumeration<Entity> enumeration2 = this.game.getEntities();
        if (enumeration2.hasMoreElements()) {
            this.addReport(new Report(7020, 0));
            while (enumeration2.hasMoreElements()) {
                object3 = enumeration2.nextElement();
                if (!((Entity)object3).isDeployed()) continue;
                this.addReport(((Entity)object3).victoryReport());
            }
        }
        if ((object3 = this.game.getEntities()).hasMoreElements()) {
            boolean bl = false;
            while (object3.hasMoreElements()) {
                object2 = object3.nextElement();
                if (((Entity)object2).isDeployed()) continue;
                if (!bl) {
                    this.addReport(new Report(7075, 0));
                    bl = true;
                }
                this.addReport(((Entity)object2).victoryReport());
            }
        }
        if ((enumeration = this.game.getRetreatedEntities()).hasMoreElements()) {
            this.addReport(new Report(7080, 0));
            while (enumeration.hasMoreElements()) {
                object2 = enumeration.nextElement();
                this.addReport(((Entity)object2).victoryReport());
            }
        }
        if ((object2 = this.game.getGraveyardEntities()).hasMoreElements()) {
            this.addReport(new Report(7085, 0));
            while (object2.hasMoreElements()) {
                object = (Entity)object2.nextElement();
                this.addReport(((Entity)object).victoryReport());
            }
        }
        if ((object = this.game.getDevastatedEntities()).hasMoreElements()) {
            this.addReport(new Report(7090, 0));
            while (object.hasMoreElements()) {
                Entity entity = (Entity)object.nextElement();
                this.addReport(entity.victoryReport());
            }
        }
        this.addReport(new Report(7095, 0));
    }

    private String getDetailedVictoryReport() {
        StringBuffer stringBuffer = new StringBuffer();
        Vector<Entity> vector = new Vector<Entity>();
        Enumeration<TurnOrdered> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.game.getRetreatedEntities();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.game.getGraveyardEntities();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement());
        }
        enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Entity entity;
            Player player = (Player)enumeration.nextElement();
            stringBuffer.append("++++++++++ ").append(player.getName()).append(" ++++++++++");
            stringBuffer.append("\r\n");
            for (int i = 0; i < vector.size(); ++i) {
                entity = (Entity)vector.elementAt(i);
                if (entity.getOwner() != player) continue;
                stringBuffer.append(UnitStatusFormatter.format(entity));
            }
            Enumeration<Entity> enumeration2 = this.game.getDevastatedEntities();
            if (!enumeration2.hasMoreElements()) continue;
            stringBuffer.append("=============================================================");
            stringBuffer.append("\r\n");
            stringBuffer.append("The following utterly destroyed units are not available for salvage:");
            stringBuffer.append("\r\n");
            while (enumeration2.hasMoreElements()) {
                entity = enumeration2.nextElement();
                if (entity.getOwner() != player) continue;
                stringBuffer.append(entity.getShortName()).append(", Pilot: ").append(entity.getCrew().getName()).append(" (").append(entity.getCrew().getGunnery()).append('/').append(entity.getCrew().getPiloting()).append(')');
                stringBuffer.append("\r\n");
            }
            stringBuffer.append("=============================================================");
            stringBuffer.append("\r\n");
        }
        return stringBuffer.toString();
    }

    public void forceVictory(Player player) {
        this.game.setForceVictory(true);
        if (player.getTeam() == 0) {
            this.game.setVictoryPlayerId(player.getId());
            this.game.setVictoryTeam(0);
        } else {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(player.getTeam());
        }
        Vector<Player> vector = this.game.getPlayersVector();
        for (int i = 0; i < vector.size(); ++i) {
            Player player2 = vector.elementAt(i);
            player2.setAdmitsDefeat(false);
        }
    }

    public void cancelVictory() {
        this.game.setForceVictory(false);
        this.game.setVictoryPlayerId(-1);
        this.game.setVictoryTeam(0);
    }

    private void checkReady() {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            if (player.isGhost() || player.isObserver() || player.isDone()) continue;
            return;
        }
        if (this.game.getNoOfInitiativeRerollRequests() > 0) {
            this.resetActivePlayersDone();
            this.game.rollInitAndResolveTies();
            this.determineTurnOrder(5);
            this.clearReports();
            this.writeInitiativeReport(true);
            this.sendReport(true);
            return;
        }
        if (!(this.game.phaseHasTurns(this.game.getPhase()) || this.game.getPhase() == 1 && this.game.getNoOfEntities() <= 0)) {
            this.endCurrentPhase();
        }
    }

    private void endCurrentTurn(Entity entity) {
        boolean bl;
        boolean bl2 = false;
        GameTurn gameTurn = this.game.getTurn();
        final int n = null == entity ? -1 : entity.getOwnerId();
        boolean bl3 = entity instanceof Infantry;
        boolean bl4 = this.game.getOptions().booleanOption("inf_move_multi") && (this.game.getPhase() == 8 || this.game.getPhase() == 5);
        boolean bl5 = entity instanceof Protomech;
        boolean bl6 = this.game.getOptions().booleanOption("protos_move_multi");
        int n2 = 0;
        if (bl4) {
            ++n2;
        }
        if (bl6) {
            n2 += 2;
        } else if (bl5 && this.game.getPhase() == 12) {
            n2 = 0;
        }
        boolean bl7 = bl = !(gameTurn instanceof GameTurn.SpecificEntityTurn) && !(gameTurn instanceof GameTurn.UnitNumberTurn) && !(gameTurn instanceof GameTurn.UnloadStrandedTurn) && (!(gameTurn instanceof GameTurn.EntityClassTurn) || gameTurn instanceof GameTurn.EntityClassTurn && ((GameTurn.EntityClassTurn)gameTurn).isValidClass(~n2));
        if (bl5 && !bl6 && bl) {
            final char c = entity.getUnitNumber();
            final int n3 = entity.getId();
            int n4 = this.game.getSelectedEntityCount(new EntitySelector(){
                private final int ownerId;
                private final int entityId;
                private final char unitNum;
                {
                    this.ownerId = n;
                    this.entityId = n3;
                    this.unitNum = c;
                }

                public boolean accept(Entity entity) {
                    return entity instanceof Protomech && entity.isSelectableThisTurn() && this.ownerId == entity.getOwnerId() && this.entityId != entity.getId() && this.unitNum == entity.getUnitNumber();
                }
            });
            for (int i = 0; i < n4; ++i) {
                GameTurn.UnitNumberTurn unitNumberTurn = new GameTurn.UnitNumberTurn(n, c);
                this.game.insertNextTurn(unitNumberTurn);
                bl2 = true;
            }
        } else if ((bl3 && bl4 || bl5 && bl6) && bl) {
            int n5 = 0;
            if (bl4) {
                n5 += this.game.getInfantryLeft(n);
            }
            if (bl6) {
                n5 += this.game.getProtomechsLeft(n);
            }
            int n6 = Math.min(this.game.getOptions().intOption("inf_proto_move_multi") - 1, n5);
            for (int i = 0; i < n6; ++i) {
                GameTurn.EntityClassTurn entityClassTurn = new GameTurn.EntityClassTurn(n, n2);
                this.game.insertNextTurn(entityClassTurn);
                bl2 = true;
            }
        }
        if (bl2) {
            this.send(this.createTurnVectorPacket());
        }
        this.changeToNextTurn();
    }

    private void changePhase(int n) {
        this.game.setLastPhase(this.game.getPhase());
        this.game.setPhase(n);
        this.prepareForPhase(n);
        if (this.isPhasePlayable(n)) {
            this.send(new Packet(240, new Integer(n)));
            this.executePhase(n);
        } else {
            this.endCurrentPhase();
        }
    }

    private void prepareForPhase(int n) {
        switch (n) {
            case 1: {
                this.clearReports();
                this.mapSettings.setBoardsAvailableVector(this.scanForBoards(this.mapSettings.getBoardWidth(), this.mapSettings.getBoardHeight()));
                this.mapSettings.setNullBoards(DEFAULT_BOARD);
                this.send(this.createMapSettingsPacket());
                break;
            }
            case 5: {
                this.game.resetActions();
                this.game.resetTagInfo();
                this.clearReports();
                this.resetEntityRound();
                this.resetEntityPhase(n);
                this.checkForObservers();
                this.resetActivePlayersDone();
                this.rollInitiative();
                if (!this.game.shouldDeployThisRound()) {
                    this.incrementAndSendGameRound();
                }
                this.determineTurnOrder(n);
                this.writeInitiativeReport(false);
                System.out.println("Round " + this.game.getRoundCount() + " memory usage: " + MegaMek.getMemoryUsed());
                break;
            }
            case 20: {
                this.checkForObservers();
                this.resetActivePlayersDone();
                this.setIneligible(n);
                Enumeration<Player> enumeration = this.game.getPlayers();
                Vector<GameTurn> vector = new Vector<GameTurn>();
                while (enumeration.hasMoreElements()) {
                    Player player = enumeration.nextElement();
                    if (!player.hasMinefields()) continue;
                    GameTurn gameTurn = new GameTurn(player.getId());
                    vector.addElement(gameTurn);
                }
                this.game.setTurnVector(vector);
                this.game.resetTurnIndex();
                this.send(this.createTurnVectorPacket());
                break;
            }
            case 22: {
                Object object;
                Enumeration<Entity> enumeration = this.game.getEntities();
                while (enumeration.hasMoreElements()) {
                    object = enumeration.nextElement();
                    ((Entity)object).deployOffBoard();
                }
                this.checkForObservers();
                this.resetActivePlayersDone();
                this.setIneligible(n);
                object = this.game.getPlayers();
                Vector<GameTurn> vector = new Vector<GameTurn>();
                while (object.hasMoreElements()) {
                    final Player player = (Player)object.nextElement();
                    EntitySelector entitySelector = new EntitySelector(){
                        private Player owner;
                        {
                            this.owner = player;
                        }

                        public boolean accept(Entity entity) {
                            return this.owner.equals(entity.getOwner()) && entity.isEligibleForTargetingPhase();
                        }
                    };
                    if (!this.game.getSelectedEntities(entitySelector).hasMoreElements()) continue;
                    GameTurn gameTurn = new GameTurn(player.getId());
                    vector.addElement(gameTurn);
                }
                this.game.setTurnVector(vector);
                this.game.resetTurnIndex();
                this.send(this.createTurnVectorPacket());
                break;
            }
            case 4: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                this.resetEntityPhase(n);
                this.checkForObservers();
                this.setIneligible(n);
                this.determineTurnOrder(n);
                this.resetActivePlayersDone();
                this.entityAllUpdate();
                this.clearReports();
                this.doTryUnstuck();
                break;
            }
            case 16: {
                this.resetEntityPhase(n);
                this.clearReports();
                this.resolveHeat();
                this.addReport(new Report(5005, 0));
                this.checkForSuffocation();
                if (this.game.getOptions().booleanOption("vacuum")) {
                    this.checkForVacuumDeath();
                }
                Enumeration<DynamicTerrainProcessor> enumeration = this.terrainProcessors.elements();
                while (enumeration.hasMoreElements()) {
                    DynamicTerrainProcessor dynamicTerrainProcessor = enumeration.nextElement();
                    dynamicTerrainProcessor.DoEndPhaseChanges(this.vPhaseReport);
                }
                this.addReport(this.game.ageFlares());
                this.send(this.createFlarePacket());
                this.resolveExtremeTempInfantryDeath();
                this.resolveAmmoDumps();
                this.resolveCrewDamage();
                this.resolveCrewWakeUp();
                this.resolveMechWarriorPickUp();
                this.resolveVeeINarcPodRemoval();
                this.resolveFortify();
                this.checkForObservers();
                this.entityAllUpdate();
                break;
            }
            case 6: {
                this.autoSave();
                Enumeration<Player> enumeration = this.game.getPlayers();
                while (enumeration.hasMoreElements()) {
                    Player player = enumeration.nextElement();
                    Report report = new Report();
                    report.type = 0;
                    report.messageId = 7016;
                    report.add(player.getName());
                    report.add(player.getBV());
                    report.add(player.getInitialBV());
                    this.addReport(report);
                }
            }
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: {
                this.resetActivePlayersDone();
                this.sendReport();
                if (!this.game.getOptions().booleanOption("paranoid_autosave")) break;
                this.autoSave();
                break;
            }
            case 18: {
                this.resetPlayersDone();
                this.clearReports();
                this.prepareVictoryReport();
                this.game.addReports(this.vPhaseReport);
                this.send(this.createFullEntitiesPacket());
                this.send(this.createReportPacket(null));
                this.send(this.createEndOfGamePacket());
            }
        }
    }

    private boolean isPhasePlayable(int n) {
        switch (n) {
            case 5: 
            case 16: {
                return false;
            }
            case 4: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 20: 
            case 22: {
                return this.game.hasMoreTurns();
            }
            case 10: {
                return this.isOffboardPlayable();
            }
        }
        return true;
    }

    private boolean isOffboardPlayable() {
        if (!this.game.hasMoreTurns()) {
            return false;
        }
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            for (Mounted mounted : entity.getAmmo()) {
                AmmoType ammoType = (AmmoType)mounted.getType();
                if ((ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 50) && ammoType.getMunitionType() == 16384L) {
                    return true;
                }
                if (ammoType.getAmmoType() != 15 && ammoType.getAmmoType() != 16 && ammoType.getAmmoType() != 17 || ammoType.getMunitionType() != 0x20000000L) continue;
                return true;
            }
        }
        return false;
    }

    private void executePhase(int n) {
        switch (n) {
            case 3: {
                this.resetPlayersDone();
                this.calculatePlayerBVs();
                this.game.setupTeams();
                this.applyBoardSettings();
                this.game.setupRoundDeployment();
                this.game.determineWind();
                if (this.game.checkForMagneticClamp()) {
                    this.entityAllUpdate();
                }
                this.send(this.createBoardPacket());
                break;
            }
            case 8: {
                this.addReport(new Report(2000, 0));
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: 
            case 14: 
            case 20: 
            case 22: {
                this.changeToNextTurn();
                if (!this.game.getOptions().booleanOption("paranoid_autosave")) break;
                this.autoSave();
            }
        }
    }

    public void calculatePlayerBVs() {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            enumeration.nextElement().setInitialBV();
        }
    }

    private void endCurrentPhase() {
        switch (this.game.getPhase()) {
            case 1: {
                this.changePhase(3);
                break;
            }
            case 3: {
                this.changePhase(22);
                break;
            }
            case 21: {
                this.changePhase(22);
                break;
            }
            case 22: {
                Enumeration<Player> enumeration = this.game.getPlayers();
                boolean bl = false;
                while (enumeration.hasMoreElements()) {
                    Player player = enumeration.nextElement();
                    if (!player.hasMinefields()) continue;
                    bl = true;
                }
                if (bl) {
                    this.changePhase(20);
                    break;
                }
                this.changePhase(5);
                break;
            }
            case 20: {
                this.changePhase(5);
                break;
            }
            case 4: {
                this.game.clearDeploymentThisRound();
                this.game.checkForCompleteDeployment();
                Enumeration<Player> enumeration = this.game.getPlayers();
                while (enumeration.hasMoreElements()) {
                    Player player = enumeration.nextElement();
                    player.adjustStartingPosForReinforcements();
                }
                if (this.game.getRoundCount() < 1) {
                    this.changePhase(5);
                    break;
                }
                this.changePhase(7);
                break;
            }
            case 5: {
                this.game.addReports(this.vPhaseReport);
                this.changePhase(6);
                break;
            }
            case 6: {
                if (this.game.shouldDeployThisRound()) {
                    this.changePhase(4);
                    break;
                }
                this.changePhase(7);
                break;
            }
            case 8: {
                this.doAllAssaultDrops();
                this.addMovementHeat();
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.resolveCrewDamage();
                this.resolvePilotingRolls();
                this.resolveCrewDamage();
                this.checkForFlamingDeath();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(9);
                    break;
                }
                this.addReport(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                this.changePhase(10);
                break;
            }
            case 9: {
                this.changePhase(10);
                break;
            }
            case 12: {
                this.resolveAllButWeaponAttacks();
                this.resolveOnlyWeaponAttacks();
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.resolveCrewDamage();
                this.resolvePilotingRolls();
                this.resolveCrewDamage();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(13);
                    break;
                }
                this.addReport(new Report(1205, 0));
                this.sendReport();
                this.game.addReports(this.vPhaseReport);
                this.changePhase(14);
                break;
            }
            case 13: {
                this.changePhase(14);
                break;
            }
            case 14: {
                this.resolvePhysicalAttacks();
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.resolveCrewDamage();
                this.resolvePilotingRolls();
                this.resolveCrewDamage();
                this.resolveSinkVees();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(15);
                    break;
                }
                this.addReport(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                this.changePhase(16);
                break;
            }
            case 15: {
                this.changePhase(16);
                break;
            }
            case 7: {
                this.enqueueIndirectArtilleryAttacks();
                this.changePhase(8);
                break;
            }
            case 10: {
                this.addReport(new Report(1100, 0));
                this.resolveAllButWeaponAttacks();
                this.resolveOnlyWeaponAttacks();
                this.resolveIndirectArtilleryAttacks();
                this.applyBuildingDamage();
                this.checkFor20Damage();
                this.resolveCrewDamage();
                this.resolvePilotingRolls();
                this.resolveCrewDamage();
                if (this.vPhaseReport.size() > 1) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(11);
                    break;
                }
                this.addReport(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                this.changePhase(12);
                break;
            }
            case 11: {
                this.changePhase(12);
                break;
            }
            case 16: {
                this.resetEntityPhase(16);
                boolean bl = this.victory();
                if (this.vPhaseReport.size() > 3 || this.vPhaseReport.elementAt((int)1).messageId != 1205) {
                    this.game.addReports(this.vPhaseReport);
                    this.changePhase(17);
                    break;
                }
                this.addReport(new Report(1205, 0));
                this.game.addReports(this.vPhaseReport);
                this.sendReport();
                if (bl) {
                    this.changePhase(18);
                    break;
                }
                this.changePhase(5);
                break;
            }
            case 17: {
                if (this.victory()) {
                    this.changePhase(18);
                    break;
                }
                this.changePhase(5);
                break;
            }
            case 18: {
                this.resetGame();
            }
        }
    }

    private void incrementAndSendGameRound() {
        this.game.incrementRoundCount();
        this.send(new Packet(260, new Integer(this.game.getRoundCount())));
    }

    private void changeToNextTurn() {
        if (!this.game.hasMoreTurns()) {
            this.endCurrentPhase();
            return;
        }
        GameTurn gameTurn = this.game.changeToNextTurn();
        Player player = this.getPlayer(gameTurn.getPlayerNum());
        if (player == null || this.game.getEntitiesOwnedBy(player) == 0) {
            this.endCurrentTurn(null);
            return;
        }
        this.send(this.createTurnIndexPacket());
        if (null != player && player.isGhost()) {
            this.sendGhostSkipMessage(player);
        } else if (null == this.game.getFirstEntity() && null != player && this.game.getPhase() != 20 && this.game.getPhase() != 22) {
            this.sendTurnErrorSkipMessage(player);
        }
    }

    private void sendGhostSkipMessage(Player player) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Player '").append(player.getName()).append("' is disconnected.  You may skip his/her current turn with the /skip command.");
        this.sendServerChat(stringBuffer.toString());
    }

    private void sendTurnErrorSkipMessage(Player player) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Player '").append(player.getName()).append("' has no units to move.  You should skip his/her/your current turn with the /skip command. You may want to report this error.  See the MegaMek homepage (http://megamek.sf.net/) for details.");
        this.sendServerChat(stringBuffer.toString());
    }

    public void skipCurrentTurn() {
        Entity entity = this.game.getFirstEntity();
        switch (this.game.getPhase()) {
            case 4: {
                this.endCurrentTurn(null);
                break;
            }
            case 8: {
                if (entity != null) {
                    this.processMovement(entity, new MovePath(this.game, entity));
                }
                this.endCurrentTurn(entity);
                break;
            }
            case 7: 
            case 10: 
            case 12: 
            case 14: {
                if (entity != null) {
                    this.processAttack(entity, new Vector(0));
                }
                this.endCurrentTurn(entity);
                break;
            }
        }
    }

    public boolean isTurnSkippable() {
        GameTurn gameTurn = this.game.getTurn();
        if (null == gameTurn) {
            return false;
        }
        Player player = this.getPlayer(gameTurn.getPlayerNum());
        return null == player || player.isGhost() || this.game.getFirstEntity() == null;
    }

    public boolean victory() {
        Serializable serializable;
        Serializable serializable2;
        int n;
        int n2;
        int n3;
        if (this.game.isForceVictory()) {
            n3 = this.game.getVictoryPlayerId();
            int n4 = this.game.getVictoryTeam();
            Vector<Player> vector = this.game.getPlayersVector();
            n2 = 1;
            if (n3 != -1) {
                for (n = 0; n < vector.size(); ++n) {
                    serializable2 = vector.elementAt(n);
                    if (((Player)serializable2).getId() == n3 || ((Player)serializable2).isObserver() || ((Player)serializable2).admitsDefeat()) continue;
                    n2 = 0;
                    break;
                }
            }
            if (n4 != 0) {
                for (n = 0; n < vector.size(); ++n) {
                    serializable2 = vector.elementAt(n);
                    if (((Player)serializable2).getTeam() == n4 || ((Player)serializable2).isObserver() || ((Player)serializable2).admitsDefeat()) continue;
                    n2 = 0;
                    break;
                }
            }
            if (n2 != 0) {
                return true;
            }
            for (n = 0; n < vector.size(); ++n) {
                serializable2 = vector.elementAt(n);
                ((Player)serializable2).setAdmitsDefeat(false);
            }
            this.cancelVictory();
        }
        if (!this.game.gameTimerIsExpired() && !this.game.getOptions().booleanOption("check_victory")) {
            return false;
        }
        n3 = 0;
        Player player = null;
        boolean bl = false;
        n2 = 0;
        n = 0;
        serializable2 = this.game.getPlayers();
        while (serializable2.hasMoreElements()) {
            serializable = serializable2.nextElement();
            int n5 = ((Player)serializable).getTeam();
            if (this.game.getLiveDeployedEntitiesOwnedBy((Player)serializable) <= 0) continue;
            ++n3;
            player = serializable;
            if (n5 == 0) {
                n = 1;
                continue;
            }
            if (n2 == 0) {
                bl = true;
                n2 = n5;
                continue;
            }
            if (n5 == n2) continue;
            bl = false;
            n2 = n5;
        }
        if (n3 < 1) {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(0);
            return true;
        }
        if (n3 == 1 && player.getTeam() == 0) {
            this.game.setVictoryPlayerId(player.getId());
            this.game.setVictoryTeam(0);
            return true;
        }
        if (bl && n == 0) {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(n2);
            return true;
        }
        serializable2 = new Hashtable<Integer, Integer>();
        serializable = new Hashtable();
        if (this.game.getOptions().booleanOption("use_bv_destroyed") || this.game.getOptions().booleanOption("use_bv_ratio")) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            Enumeration<Player> enumeration = this.game.getPlayers();
            while (enumeration.hasMoreElements()) {
                Serializable serializable3;
                Player player2 = enumeration.nextElement();
                if (player2.isObserver()) continue;
                int n6 = 0;
                int n7 = 0;
                int n8 = 0;
                int n9 = player2.getTeam();
                if (n9 != 0) {
                    if (hashSet.contains(n9)) continue;
                    hashSet.add(n9);
                }
                Object object = this.game.getPlayers();
                while (object.hasMoreElements()) {
                    serializable3 = object.nextElement();
                    if (((Player)serializable3).isObserver()) continue;
                    if (((Player)serializable3).isEnemyOf(player2)) {
                        n7 += ((Player)serializable3).getBV();
                        n8 += ((Player)serializable3).getInitialBV();
                        continue;
                    }
                    n6 += ((Player)serializable3).getBV();
                }
                if (this.game.getOptions().booleanOption("use_bv_ratio") && (n7 == 0 || 100 * n6 / n7 >= this.game.getOptions().intOption("bv_ratio_percent"))) {
                    object = new Report(7100, 0);
                    if (n9 == 0) {
                        ((Report)object).add(player2.getName());
                        serializable3 = (Integer)serializable2.get(player2.getId());
                        if (serializable3 == null) {
                            serializable3 = new Integer(0);
                        }
                        serializable2.put(player2.getId(), (Integer)serializable3 + 1);
                    } else {
                        ((Report)object).add("Team " + n9);
                        serializable3 = (Integer)((Hashtable)serializable).get(n9);
                        if (serializable3 == null) {
                            serializable3 = new Integer(0);
                        }
                        ((Hashtable)serializable).put(n9, (Integer)serializable3 + 1);
                    }
                    ((Report)object).add(n7 == 0 ? 9999 : 100 * n6 / n7);
                    this.addReport((Report)object);
                }
                if (!this.game.getOptions().booleanOption("use_bv_destroyed") || n7 * 100 / n8 > 100 - this.game.getOptions().intOption("bv_destroyed_percent")) continue;
                object = new Report(7105, 0);
                if (n9 == 0) {
                    ((Report)object).add(player2.getName());
                    serializable3 = (Integer)serializable2.get(player2.getId());
                    if (serializable3 == null) {
                        serializable3 = new Integer(0);
                    }
                    serializable2.put(player2.getId(), (Integer)serializable3 + 1);
                } else {
                    ((Report)object).add("Team " + n9);
                    serializable3 = (Integer)((Hashtable)serializable).get(n9);
                    if (serializable3 == null) {
                        serializable3 = new Integer(0);
                    }
                    ((Hashtable)serializable).put(n9, (Integer)serializable3 + 1);
                }
                ((Report)object).add(100 - n7 * 100 / n8);
                this.addReport((Report)object);
            }
        }
        int n10 = -1;
        int n11 = 0;
        boolean bl2 = false;
        for (Map.Entry entry : serializable2.entrySet()) {
            if ((Integer)entry.getValue() < this.game.getOptions().intOption("achieve_conditions")) continue;
            if (n10 != -1) {
                bl2 = true;
            }
            n10 = (Integer)entry.getKey();
            Report report = new Report(7200, 0);
            report.add(this.game.getPlayer(n10).getName());
            this.addReport(report);
        }
        for (Map.Entry entry : ((Hashtable)serializable).entrySet()) {
            if ((Integer)entry.getValue() < this.game.getOptions().intOption("achieve_conditions")) continue;
            if (n11 != 0 || n10 != -1) {
                bl2 = true;
            }
            n11 = (Integer)entry.getKey();
            Report report = new Report(7200, 0);
            report.add("Team " + n11);
            this.addReport(report);
        }
        if (bl2) {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(0);
            return true;
        }
        if (n10 != -1) {
            this.game.setVictoryPlayerId(n10);
            this.game.setVictoryTeam(0);
            return true;
        }
        if (n11 != 0) {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(n11);
            return true;
        }
        if (this.game.gameTimerIsExpired()) {
            this.game.setVictoryPlayerId(-1);
            this.game.setVictoryTeam(0);
            return true;
        }
        return false;
    }

    public void applyBoardSettings() {
        this.mapSettings.replaceBoardWithRandom("[RANDOM]");
        this.mapSettings.replaceBoardWithRandom(DEFAULT_BOARD);
        IBoard[] iBoardArray = new IBoard[this.mapSettings.getMapWidth() * this.mapSettings.getMapHeight()];
        for (int i = 0; i < this.mapSettings.getMapWidth() * this.mapSettings.getMapHeight(); ++i) {
            iBoardArray[i] = new Board();
            String string = (String)this.mapSettings.getBoardsSelectedVector().elementAt(i);
            boolean bl = false;
            if (string.startsWith("rotate:")) {
                bl = true;
                string = string.substring("rotate:".length());
            }
            if (string.startsWith("[GENERATED]")) {
                iBoardArray[i] = BoardUtilities.generateRandom(this.mapSettings);
                continue;
            }
            iBoardArray[i].load(string + ".board");
            BoardUtilities.flip(iBoardArray[i], bl, bl);
        }
        IBoard iBoard = BoardUtilities.combine(this.mapSettings.getBoardWidth(), this.mapSettings.getBoardHeight(), this.mapSettings.getMapWidth(), this.mapSettings.getMapHeight(), iBoardArray);
        if (this.game.getOptions().getOption("bridgeCF").intValue() > 0) {
            iBoard.setBridgeCF(this.game.getOptions().getOption("bridgeCF").intValue());
        }
        this.game.setBoard(iBoard);
    }

    private void rollInitiative() {
        if (this.game.getOptions().booleanOption("individual_initiative")) {
            TurnOrdered.rollInitiative(this.game.getEntitiesVector());
        } else {
            TurnOrdered.rollInitiative(this.game.getTeamsVector());
        }
        this.transmitAllPlayerUpdates();
    }

    private void determineTurnOrderIUI(int n) {
        Vector<GameTurn> vector;
        Enumeration<Entity> enumeration;
        TurnVectors turnVectors = this.game.getEntities();
        while (turnVectors.hasMoreElements()) {
            enumeration = turnVectors.nextElement();
            ((TurnOrdered)((Object)enumeration)).resetOtherTurns();
            if (!((Entity)((Object)enumeration)).isSelectableThisTurn()) continue;
            ((TurnOrdered)((Object)enumeration)).incrementOtherTurns();
        }
        turnVectors = TurnOrdered.generateTurnOrder(this.game.getEntitiesVector(), this.game);
        enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return Server.this.game.isEntityStranded(entity);
            }
        });
        if (enumeration.hasMoreElements() && this.game.getPhase() == 8) {
            vector = new Vector(turnVectors.getNormalTurns() + turnVectors.getEvenTurns() + 1);
            vector.addElement(new GameTurn.UnloadStrandedTurn(enumeration));
        } else {
            vector = new Vector<GameTurn>(turnVectors.getNormalTurns() + turnVectors.getEvenTurns());
        }
        while (turnVectors.hasMoreElements()) {
            Entity entity = (Entity)turnVectors.nextElement();
            if (!entity.isSelectableThisTurn()) continue;
            vector.addElement(new GameTurn.SpecificEntityTurn(entity.getOwnerId(), entity.getId()));
        }
        this.game.setTurnVector(vector);
        this.game.resetTurnIndex();
        this.send(this.createTurnVectorPacket());
    }

    private void determineTurnOrder(int n) {
        Vector<GameTurn> vector;
        Hashtable<Team, int[]> hashtable;
        Serializable serializable;
        if (this.game.getOptions().booleanOption("individual_initiative")) {
            this.determineTurnOrderIUI(n);
            return;
        }
        boolean bl = this.game.getOptions().booleanOption("inf_move_even") && (this.game.getPhase() == 5 || this.game.getPhase() == 8) || this.game.getOptions().booleanOption("inf_deploy_even") && this.game.getPhase() == 4;
        boolean bl2 = this.game.getOptions().booleanOption("inf_move_multi") && (this.game.getPhase() == 5 || this.game.getPhase() == 8);
        boolean bl3 = this.game.getOptions().booleanOption("protos_move_even") && (this.game.getPhase() == 5 || this.game.getPhase() == 8) || this.game.getOptions().booleanOption("protos_deploy_even") && this.game.getPhase() == 4;
        boolean bl4 = this.game.getOptions().booleanOption("protos_move_multi");
        boolean bl5 = !bl4;
        int n2 = 0;
        if (bl) {
            ++n2;
        }
        if (bl3) {
            n2 += 2;
        }
        Enumeration<TurnOrdered> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            ((TurnOrdered)serializable).resetEvenTurns();
            ((TurnOrdered)serializable).resetMultiTurns();
            ((TurnOrdered)serializable).resetOtherTurns();
            if (!bl5) continue;
            hashtable = this.game.getSelectedEntities(new EntitySelector((Player)serializable){
                private final int ownerId;
                final /* synthetic */ Player val$player;
                {
                    this.val$player = player;
                    this.ownerId = this.val$player.getId();
                }

                public boolean accept(Entity entity) {
                    return entity instanceof Protomech && this.ownerId == entity.getOwnerId() && entity.isSelectableThisTurn();
                }
            });
            HashSet<Integer> hashSet = new HashSet<Integer>();
            int n3 = 0;
            while (hashtable.hasMoreElements()) {
                Entity entity = (Entity)hashtable.nextElement();
                ++n3;
                hashSet.add(new Integer(entity.getUnitNumber()));
            }
            int n4 = (int)Math.ceil((double)n3 / 5.0);
            if (!bl3) {
                n4 = hashSet.size();
            }
            for (int i = 0; i < n4; ++i) {
                if (bl3) {
                    ((TurnOrdered)serializable).incrementEvenTurns();
                    continue;
                }
                ((TurnOrdered)serializable).incrementOtherTurns();
            }
        }
        enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            serializable = (Entity)enumeration.nextElement();
            if (!((Entity)serializable).isSelectableThisTurn()) continue;
            hashtable = ((Entity)serializable).getOwner();
            if (serializable instanceof Infantry) {
                if (bl) {
                    ((TurnOrdered)((Object)hashtable)).incrementEvenTurns();
                    continue;
                }
                if (bl2) {
                    ((TurnOrdered)((Object)hashtable)).incrementMultiTurns();
                    continue;
                }
                ((TurnOrdered)((Object)hashtable)).incrementOtherTurns();
                continue;
            }
            if (serializable instanceof Protomech) {
                if (bl5) continue;
                if (bl3) {
                    ((TurnOrdered)((Object)hashtable)).incrementEvenTurns();
                    continue;
                }
                if (bl4) {
                    ((TurnOrdered)((Object)hashtable)).incrementMultiTurns();
                    continue;
                }
                ((TurnOrdered)((Object)hashtable)).incrementOtherTurns();
                continue;
            }
            ((TurnOrdered)((Object)hashtable)).incrementOtherTurns();
        }
        int n5 = this.game.getNoOfTeams();
        serializable = new Hashtable(n5);
        hashtable = new Hashtable<Team, int[]>(n5);
        int n6 = 0;
        Enumeration enumeration2 = this.game.getTeams();
        while (enumeration2.hasMoreElements()) {
            Team team = (Team)enumeration2.nextElement();
            ((Hashtable)serializable).put(team, team.determineTeamOrder(this.game));
            int[] nArray = new int[]{0, 0};
            hashtable.put(team, nArray);
            if (team.getNormalTurns(this.game) <= 0) continue;
            ++n6;
        }
        enumeration2 = TurnOrdered.generateTurnOrder(this.game.getTeamsVector(), this.game);
        Enumeration<Entity> enumeration3 = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return Server.this.game.isEntityStranded(entity);
            }
        });
        if (enumeration3.hasMoreElements() && this.game.getPhase() == 8) {
            vector = new Vector(((TurnVectors)enumeration2).getNormalTurns() + ((TurnVectors)enumeration2).getEvenTurns() + 1);
            vector.addElement(new GameTurn.UnloadStrandedTurn(enumeration3));
        } else {
            vector = new Vector<GameTurn>(((TurnVectors)enumeration2).getNormalTurns() + ((TurnVectors)enumeration2).getEvenTurns());
        }
        Team team = null;
        int n7 = ((TurnVectors)enumeration2).getMin();
        int n8 = 0;
        while (((TurnVectors)enumeration2).hasMoreElements()) {
            Player player;
            Team team2 = (Team)((TurnVectors)enumeration2).nextElement();
            TurnVectors turnVectors = (TurnVectors)((Hashtable)serializable).get(team2);
            int[] nArray = (int[])hashtable.get(team2);
            float f = team2.getEvenTurns();
            int n9 = 0;
            if (1 == n6) {
                n9 = (int)((float)n9 + f);
            } else if (team == null) {
                nArray[0] = nArray[0] + 1;
                n9 = (int)((float)n9 + f / (float)n7);
            } else if (!team2.equals(team)) {
                nArray[0] = nArray[0] + 1;
                n9 = (int)((double)n9 + (Math.ceil((double)((float)nArray[0] * (f % (float)n7) / (float)n7) - 0.5) - (double)nArray[1]));
                nArray[1] = nArray[1] + n9;
                n9 = (int)((float)n9 + f / (float)n7);
            }
            team = team2;
            if (turnVectors.hasMoreElements()) {
                player = (Player)turnVectors.nextElement();
                GameTurn gameTurn = null;
                gameTurn = n8 >= ((TurnVectors)enumeration2).getNormalTurns() ? new GameTurn.EntityClassTurn(player.getId(), n2) : (bl || bl3 ? new GameTurn.EntityClassTurn(player.getId(), ~n2) : new GameTurn(player.getId()));
                vector.addElement(gameTurn);
            }
            while (n9 > 0 && turnVectors.hasMoreEvenElements()) {
                player = (Player)turnVectors.nextEvenElement();
                vector.addElement(new GameTurn.EntityClassTurn(player.getId(), n2));
                --n9;
            }
            ++n8;
        }
        this.game.setTurnVector(vector);
        this.game.resetTurnIndex();
        this.send(this.createTurnVectorPacket());
    }

    private void writeInitiativeReport(boolean bl) {
        Object object;
        Report report;
        boolean bl2 = false;
        if (!bl) {
            report = new Report(1210);
            report.type = 0;
            if (this.game.getLastPhase() == 4 || this.game.isDeploymentComplete() || !this.game.shouldDeployThisRound()) {
                report.messageId = 1000;
                report.add(this.game.getRoundCount());
            } else {
                bl2 = true;
                if (this.game.getRoundCount() == 0) {
                    report.messageId = 1005;
                } else {
                    report.messageId = 1010;
                    report.add(this.game.getRoundCount());
                }
            }
            this.addReport(report);
            this.addReport(new Report(1200, 0));
        } else {
            this.addReport(new Report(1210, 0));
        }
        if (this.game.getOptions().booleanOption("individual_initiative")) {
            report = new Report(1040, 0);
            this.addReport(report);
            object = this.game.getTurns();
            while (object.hasMoreElements()) {
                TurnOrdered turnOrdered;
                GameTurn gameTurn = object.nextElement();
                if (gameTurn instanceof GameTurn.SpecificEntityTurn) {
                    turnOrdered = this.game.getEntity(((GameTurn.SpecificEntityTurn)gameTurn).getEntityNum());
                    report = new Report(1045);
                    report.subject = ((Entity)turnOrdered).getId();
                    report.addDesc((Entity)turnOrdered);
                    report.add(turnOrdered.getInitiative().toString());
                    this.addReport(report);
                    continue;
                }
                turnOrdered = this.getPlayer(gameTurn.getPlayerNum());
                if (null == turnOrdered) continue;
                report = new Report(1050, 0);
                report.add(((Player)turnOrdered).getName());
                this.addReport(report);
            }
        } else {
            Serializable serializable;
            Object object2;
            Enumeration enumeration = this.game.getTeams();
            while (enumeration.hasMoreElements()) {
                Team team = (Team)enumeration.nextElement();
                if (team.getSize() == 1) {
                    object2 = (Player)team.getPlayers().nextElement();
                    report = new Report(1015, 0);
                    report.add(((Player)object2).getName());
                    report.add(team.getInitiative().toString());
                    this.addReport(report);
                    continue;
                }
                report = new Report(1015, 0);
                report.add(Player.teamNames[team.getId()]);
                report.add(team.getInitiative().toString());
                this.addReport(report);
                object2 = team.getPlayers();
                while (object2.hasMoreElements()) {
                    serializable = (Player)object2.nextElement();
                    report = new Report(1015, 0);
                    report.indent();
                    report.add(((Player)serializable).getName());
                    report.add(((TurnOrdered)serializable).getInitiative().toString());
                    this.addReport(report);
                }
            }
            report = new Report(1020, 0);
            boolean bl3 = true;
            boolean bl4 = false;
            object2 = this.game.getTurns();
            while (object2.hasMoreElements()) {
                serializable = (GameTurn)object2.nextElement();
                Player player = this.getPlayer(((GameTurn)serializable).getPlayerNum());
                if (null == player) continue;
                report.add(player.getName());
                bl3 = false;
                if (player.getEvenTurns() <= 0) continue;
                bl4 = true;
            }
            report.newlines = 2;
            this.addReport(report);
            if (bl4) {
                report = new Report(1021, 0);
                if ((this.game.getOptions().booleanOption("inf_deploy_even") || this.game.getOptions().booleanOption("protos_deploy_even")) && this.game.getLastPhase() != 17) {
                    report.choose(true);
                } else {
                    report.choose(false);
                }
                report.indent();
                report.newlines = 2;
                this.addReport(report);
            }
        }
        if (!bl) {
            report = new Report(1025, 0);
            report.add(this.game.getStringWindDirection());
            if (this.game.getWindStrength() != -1) {
                object = new Report(1030, 0);
                ((Report)object).add(this.game.getStringWindStrength());
                report.newlines = 0;
                this.addReport(report);
                this.addReport((Report)object);
            } else {
                this.addReport(report);
            }
            if (bl2) {
                this.addNewLines();
            }
        }
    }

    private void setIneligible(int n) {
        Vector<Entity> vector = new Vector<Entity>();
        boolean bl = false;
        Entity entity = null;
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            entity = enumeration.nextElement();
            if (!entity.isEligibleFor(n)) {
                vector.addElement(entity);
                continue;
            }
            bl = true;
        }
        for (int i = 0; i < vector.size(); ++i) {
            entity = (Entity)vector.elementAt(i);
            if (bl && entity.canAssist(n)) continue;
            entity.setDone(true);
        }
    }

    private void loadUnit(Entity entity, Entity entity2) {
        if (!entity2.isDone()) {
            this.game.removeTurnFor(entity2);
            this.send(this.createTurnVectorPacket());
        }
        entity.load(entity2);
        entity2.setTransportId(entity.getId());
        entity2.setPosition(null);
        this.entityUpdate(entity2.getId());
    }

    private boolean unloadUnit(Entity entity, Targetable targetable, Coords coords, int n, int n2) {
        Entity entity2 = null;
        if (!(targetable instanceof Entity)) {
            return false;
        }
        entity2 = (Entity)targetable;
        if (!entity.unload(entity2)) {
            return false;
        }
        entity2.setTransportId(-1);
        entity2.setPosition(coords);
        if (coords != null) {
            entity2.setDeployed(true);
        }
        entity2.setFacing(n);
        entity2.setSecondaryFacing(n);
        IHex iHex = this.game.getBoard().getHex(coords);
        boolean bl = iHex.containsTerrain(5);
        if (entity.getMovementMode() == 6) {
            if (entity2.getMovementMode() == 6) {
                entity2.setElevation(n2);
            } else if (this.game.getBoard().getBuildingAt(coords) != null) {
                entity2.setElevation(iHex.terrainLevel(12));
            } else {
                while (n2 >= -iHex.depth()) {
                    if (entity2.isElevationValid(n2, iHex)) {
                        entity2.setElevation(n2);
                        break;
                    }
                    --n2;
                    entity2.moved = 3;
                }
                if (!entity2.isElevationValid(n2, iHex)) {
                    return false;
                }
            }
        } else if (this.game.getBoard().getBuildingAt(coords) != null) {
            entity2.setElevation(n2);
        } else if (iHex.terrainLevel(4) > 0) {
            if (entity2.getMovementMode() == 5 || entity2.getMovementMode() == 8 || entity2.getMovementMode() == 7 || entity2.getMovementMode() == 9 || entity2.getMovementMode() == 18 || iHex.containsTerrain(20) || bl) {
                entity2.setElevation(0);
            }
        } else {
            entity2.setElevation(iHex.floor() - iHex.surface());
        }
        this.doSetLocationsExposure(entity2, iHex, false, entity2.getElevation());
        this.entityUpdate(entity2.getId());
        return true;
    }

    private void addAffectedBldg(Building building, boolean bl) {
        if (bl) {
            System.err.print("Removing building from a list of " + this.affectedBldgs.size() + '\n');
            this.affectedBldgs.remove(building);
            System.err.print("... now list of " + this.affectedBldgs.size() + '\n');
        } else {
            this.affectedBldgs.put(building, Boolean.FALSE);
        }
    }

    private void applyAffectedBldgs() {
        Vector<Building> vector = new Vector<Building>();
        boolean bl = false;
        Enumeration<Building> enumeration = this.affectedBldgs.keys();
        while (enumeration.hasMoreElements()) {
            Building building = enumeration.nextElement();
            Enumeration<Coords> enumeration2 = building.getCoords();
            while (enumeration2.hasMoreElements()) {
                Coords coords = enumeration2.nextElement();
                Enumeration<Entity> enumeration3 = this.game.getEntities(coords);
                while (enumeration3.hasMoreElements()) {
                    Entity entity = enumeration3.nextElement();
                    if (!(entity instanceof Infantry)) continue;
                    if (entity.isDoomed() || entity.isDestroyed()) {
                        if (!entity.isDone()) {
                            this.game.removeTurnFor(entity);
                            bl = true;
                        }
                        entity.setDestroyed(true);
                        this.game.moveToGraveyard(entity.getId());
                        this.send(this.createRemoveEntityPacket(entity.getId()));
                        continue;
                    }
                    this.entityUpdate(entity.getId());
                }
            }
            vector.addElement(building);
        }
        if (bl) {
            this.send(this.createTurnVectorPacket());
        }
        if (!vector.isEmpty()) {
            this.sendChangedCFBuildings(vector);
            this.affectedBldgs.clear();
        }
    }

    private void receiveMovement(Packet packet, int n) {
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        MovePath movePath = (MovePath)packet.getObject(1);
        if (this.game.getPhase() != 8) {
            System.err.println("error: server got movement packet in wrong phase");
            return;
        }
        if (!this.game.getTurn().isValid(n, entity, this.game)) {
            System.err.println("error: server got invalid movement packet");
            return;
        }
        this.processMovement(entity, movePath);
        this.applyAffectedBldgs();
        if (this.doBlind()) {
            this.updateVisibilityIndicator();
        }
        this.endCurrentTurn(entity);
    }

    private boolean processSkid(Entity entity, Coords coords, int n, int n2, int n3, MoveStep moveStep) {
        int n4;
        int n5;
        Object object;
        Report report;
        Coords coords2;
        Coords coords3 = coords2 = coords;
        Object object2 = this.game.getBoard().getHex(coords);
        int n6 = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        while (!entity.isDoomed() && n3 > 0) {
            Object object3;
            int n7;
            int n8;
            Building building;
            boolean bl;
            int n9;
            coords2 = coords3.translated(n2);
            if (!this.game.getBoard().contains(coords2)) {
                if (this.game.getOptions().booleanOption("push_off_board")) {
                    this.game.removeEntity(entity.getId(), 272);
                    this.send(this.createRemoveEntityPacket(entity.getId(), 272));
                    report = new Report(2030, 0);
                    report.addDesc(entity);
                    this.addReport(report);
                    for (Entity entity2 : entity.getLoadedUnits()) {
                        this.game.removeEntity(entity2.getId(), 272);
                        this.send(this.createRemoveEntityPacket(entity2.getId(), 272));
                    }
                    object = this.game.getEntity(entity.getSwarmAttackerId());
                    if (object != null) {
                        if (!((Entity)object).isDone()) {
                            ((Entity)object).setDone(true);
                            this.game.removeTurnFor((Entity)object);
                            this.send(this.createTurnVectorPacket());
                        }
                        this.game.removeEntity(((Entity)object).getId(), 272);
                        this.send(this.createRemoveEntityPacket(((Entity)object).getId(), 272));
                    }
                    return true;
                }
                report = new Report(2035);
                report.subject = entity.getId();
                report.indent();
                this.addReport(report);
                break;
            }
            object = this.game.getBoard().getHex(coords2);
            n3 -= object.movementCost(entity.getMovementMode()) + 1;
            n5 = entity.getElevation() + object2.getElevation();
            n4 = object.floor();
            if (entity.getMovementMode() == 6) {
                n4 = Math.max(n4, n5);
            } else {
                if (object.containsTerrain(12)) {
                    n4 = Math.min(n5, object.getElevation() + object.terrainLevel(12));
                }
                if (object.containsTerrain(14)) {
                    n9 = (n2 + 3) % 6;
                    n9 = 1 << n9;
                    if ((object.getTerrain(14).getExits() & n9) == n9) {
                        n4 = Math.min(n5, Math.max(n4, object.getElevation() + object.terrainLevel(16)));
                    }
                }
                if (n4 <= object.surface() && n5 >= object2.surface()) {
                    if (entity instanceof Tank && entity.getMovementMode() == 5) {
                        if (object.containsTerrain(4)) {
                            n4 = object.surface();
                        }
                    } else if (object.containsTerrain(20)) {
                        n4 = object.surface();
                    }
                }
            }
            n9 = n4 - object.surface();
            boolean bl2 = bl = n5 < n4;
            if (entity.getMovementMode() == 6 && (n9 == 0 || n9 == 1 && (object.containsTerrain(1) || object.containsTerrain(23)))) {
                bl = true;
            }
            if (object.containsTerrain(12) && (building = this.game.getBoard().getBuildingAt(coords2)).getType() == 5) {
                bl = true;
            }
            if (entity.getMovementMode() == 15) {
                if (n9 == 0 && !object.containsTerrain(1) && !object.containsTerrain(23)) {
                    n9 = 1;
                    bl = false;
                } else if (n9 == 1 && (object.containsTerrain(1) || object.containsTerrain(23))) {
                    n9 = 2;
                    bl = false;
                }
            }
            if (bl) {
                report = object.containsTerrain(12) ? ((building = this.game.getBoard().getBuildingAt(coords2)).getType() == 5 ? new Report(2047) : new Report(2045)) : new Report(2045);
                report.subject = entity.getId();
                report.indent();
                report.add(coords2.getBoardNum(), true);
                this.addReport(report);
                if (entity.getMovementMode() == 15 || entity.getMovementMode() == 6) {
                    int n10 = moveStep.getFacing() - n2 + 6;
                    n8 = 0;
                    switch (n10 %= 6) {
                        case 0: {
                            n8 = 0;
                            break;
                        }
                        case 1: 
                        case 2: {
                            n8 = 2;
                            break;
                        }
                        case 3: {
                            n8 = 1;
                            break;
                        }
                        case 4: 
                        case 5: {
                            n8 = 3;
                        }
                    }
                    n = n9;
                    this.addReport(this.crashVTOL((VTOL)entity, true, n3, coords3, n, n8));
                    if (object.containsTerrain(4) && !object.containsTerrain(20) || object.containsTerrain(1) || object.containsTerrain(23)) {
                        this.addReport(this.destroyEntity(entity, "could not land in crash site"));
                    } else if (n < object.terrainLevel(12)) {
                        Building building2 = this.game.getBoard().getBuildingAt(coords2);
                        if (building2.getType() == 5) {
                            this.addReport(this.destroyEntity(entity, "crashed into a wall"));
                            break;
                        }
                        this.addReport(this.destroyEntity(entity, "crashed into building"));
                    } else {
                        entity.setPosition(coords2);
                        entity.setElevation(0);
                        this.doEntityDisplacementMinefieldCheck(entity, coords3, coords2);
                    }
                    coords3 = coords2;
                    break;
                }
                for (int i = ((int)entity.getWeight() + 19) / 20; i > 0; i -= 5) {
                    this.addReport(this.damageEntity(entity, entity.rollHitLocation(0, 0), Math.min(5, i)));
                }
                break;
            }
            if (n5 > n4 + entity.getMaxElevationChange()) {
                if (entity.getMovementMode() == 15 && entity.getRunMP() - 2 >= entity.mpUsed) {
                    entity.mpUsed += 2;
                    n4 = n5;
                } else {
                    this.doEntityFallsInto(entity, coords3, coords2, entity.getBasePilotingRoll());
                    this.doEntityDisplacementMinefieldCheck(entity, coords3, coords2);
                    break;
                }
            }
            building = null;
            if (n9 < object.terrainLevel(12)) {
                building = this.game.getBoard().getBuildingAt(coords2);
            }
            n8 = 0;
            boolean bl3 = false;
            Enumeration<Entity> enumeration = this.game.getEntities(coords2);
            if (enumeration.hasMoreElements()) {
                Object object4;
                n7 = 0;
                while (enumeration.hasMoreElements()) {
                    object3 = enumeration.nextElement();
                    if (((Entity)object3).getElevation() > n9 + entity.getHeight() || ((Entity)object3).absHeight() < n9) continue;
                    if (!((Entity)object3).isDone()) {
                        if (object3 instanceof Infantry) {
                            report = new Report(2420);
                            report.subject = ((Entity)object3).getId();
                            report.addDesc((Entity)object3);
                            this.addReport(report);
                            continue;
                        }
                        if (object3 instanceof Protomech) {
                            if (object3 != Compute.stackingViolation(this.game, entity, coords2, null)) {
                                report = new Report(2420);
                                report.subject = ((Entity)object3).getId();
                                report.addDesc((Entity)object3);
                                this.addReport(report);
                                continue;
                            }
                        } else {
                            object4 = ((Entity)object3).getBasePilotingRoll();
                            ((TargetRoll)object4).addModifier(0, "avoiding collision");
                            int n11 = Compute.d6(2);
                            report = new Report(2425);
                            report.subject = ((Entity)object3).getId();
                            report.addDesc((Entity)object3);
                            report.add(((TargetRoll)object4).getValue());
                            report.add(((TargetRoll)object4).getDesc());
                            report.add(n11);
                            this.addReport(report);
                            if (n11 >= ((TargetRoll)object4).getValue()) {
                                this.game.removeTurnFor((Entity)object3);
                                arrayList.add(object3);
                                continue;
                            }
                        }
                    }
                    if (object3 instanceof Mech || object3 instanceof Tank) {
                        object4 = new ChargeAttackAction(entity.getId(), ((Entity)object3).getTargetType(), ((Entity)object3).getTargetId(), ((Entity)object3).getPosition());
                        ToHitData toHitData = ((ChargeAttackAction)object4).toHit(this.game, true);
                        int n12 = Compute.d6(2);
                        report = new Report(2050);
                        report.subject = entity.getId();
                        report.indent();
                        report.add(((Entity)object3).getShortName(), true);
                        report.add(coords2.getBoardNum(), true);
                        report.newlines = 0;
                        this.addReport(report);
                        if (toHitData.getValue() == Integer.MAX_VALUE) {
                            n12 = -12;
                            report = new Report(2055);
                            report.subject = entity.getId();
                            report.add(toHitData.getDesc());
                            report.newlines = 0;
                            this.addReport(report);
                        } else if (toHitData.getValue() == Integer.MIN_VALUE) {
                            report = new Report(2060);
                            report.subject = entity.getId();
                            report.add(toHitData.getDesc());
                            report.newlines = 0;
                            this.addReport(report);
                            n12 = Integer.MAX_VALUE;
                        } else {
                            report = new Report(2065);
                            report.subject = entity.getId();
                            report.add(toHitData.getValue());
                            report.add(n12);
                            report.newlines = 0;
                            this.addReport(report);
                        }
                        if (n12 < toHitData.getValue()) {
                            report = new Report(2070);
                            report.subject = entity.getId();
                            this.addReport(report);
                        } else {
                            this.resolveChargeDamage(entity, (Entity)object3, toHitData, n2);
                            if (enumeration.hasMoreElements()) {
                                entity.setPosition(coords3);
                            }
                            n8 = 1;
                            n7 = 1;
                            if (!(((Entity)object3).isDoomed() || ((Entity)object3).isDestroyed() || this.game.isOutOfGame((Entity)object3))) {
                                bl3 = true;
                            }
                        }
                        if (!((Entity)object3).isDone()) {
                            this.resolvePilotingRolls((Entity)object3);
                            this.game.resetPSRs((Entity)object3);
                            ((Entity)object3).applyDamage();
                            this.addNewLines();
                        }
                    } else if (object3 instanceof Infantry && building != null) {
                        report = new Report(2075);
                        report.subject = entity.getId();
                        report.indent();
                        report.add(((Entity)object3).getShortName(), true);
                        report.add(coords2.getBoardNum(), true);
                        report.newlines = 0;
                        this.addReport(report);
                        object4 = ((Entity)object3).rollHitLocation(0, Compute.targetSideTable(entity, (Targetable)object3));
                        this.addReport(this.damageEntity((Entity)object3, (HitData)object4, Math.round(entity.getWeight() / 5.0f)));
                        this.addNewLines();
                    }
                    if (((Entity)object3).isDoomed()) {
                        if (!((Entity)object3).isDone()) {
                            this.game.removeTurnFor((Entity)object3);
                            this.send(this.createTurnVectorPacket());
                        }
                        ((Entity)object3).setDestroyed(true);
                        this.game.moveToGraveyard(((Entity)object3).getId());
                        this.send(this.createRemoveEntityPacket(((Entity)object3).getId()));
                    }
                    if (this.game.isOutOfGame((Entity)object3)) continue;
                    this.entityUpdate(((Entity)object3).getId());
                }
                if (n7 != 0) {
                    entity.setPosition(coords2);
                }
                object3 = arrayList.iterator();
                while (object3.hasNext()) {
                    object4 = (Entity)object3.next();
                    GameTurn.SpecificEntityTurn specificEntityTurn = new GameTurn.SpecificEntityTurn(((Entity)object4).getOwner().getId(), ((Entity)object4).getId());
                    this.game.insertNextTurn(specificEntityTurn);
                    this.send(this.createTurnVectorPacket());
                }
            }
            if (building != null) {
                report = new Report(2080);
                report.subject = entity.getId();
                report.indent();
                report.add(building.getName());
                report.add(coords2.getBoardNum(), true);
                this.addReport(report);
                n7 = ChargeAttackAction.getDamageFor(entity);
                if (n8 == 0) {
                    object3 = this.damageBuilding(building, n7);
                    if (object3 != null) {
                        ((Report)object3).indent(2);
                        ((Report)object3).subject = entity.getId();
                        this.addReport((Report)object3);
                    }
                    int n13 = ChargeAttackAction.getDamageTakenBy(entity, building);
                    HitData hitData = entity.rollHitLocation(0, entity.sideTable(coords2));
                    this.addReport(this.damageEntity(entity, hitData, n13));
                    this.addNewLines();
                    entity.setPosition(coords2);
                    entity.setElevation(n9);
                    this.doEntityDisplacementMinefieldCheck(entity, coords3, coords2);
                    coords3 = coords2;
                }
                this.damageInfantryIn(building, n7);
                if (building.getCurrentCF() > 0) {
                    bl3 = true;
                    this.addAffectedBldg(building, false);
                } else {
                    this.checkForCollapse(building, this.game.getPositionMap());
                }
            }
            if (bl3) break;
            entity.setPosition(coords2);
            entity.setElevation(n9);
            this.doEntityDisplacementMinefieldCheck(entity, coords3, coords2);
            ++n6;
            Building building3 = this.game.getBoard().getBuildingAt(coords2);
            if (building3 != null && this.checkForCollapse(building3, this.game.getPositionMap())) break;
            if ((entity.isHexProhibited((IHex)object2) || entity.isHexProhibited((IHex)object)) && !Compute.canMoveOnPavement(this.game, coords3, coords2)) {
                report = new Report(2040);
                report.subject = entity.getId();
                report.indent();
                report.add(coords2.getBoardNum(), true);
                this.addReport(report);
                if (object.terrainLevel(4) > 0 && entity instanceof Tank && entity.getMovementMode() != 5 && entity.getMovementMode() != 15) {
                    this.addReport(this.destroyEntity(entity, "skidded into a watery grave", false, true));
                }
                for (int i = ((int)entity.getWeight() + 4) / 5; i > 0; i -= 5) {
                    this.addReport(this.damageEntity(entity, entity.rollHitLocation(0, 0), Math.min(5, i)));
                }
                if (!(entity instanceof Tank)) break;
                ((Tank)entity).immobilize();
                break;
            }
            if (object.terrainLevel(4) > 0 && entity.getMovementMode() != 5 && entity.getMovementMode() != 15) break;
            if (object.terrainLevel(24) == 1 && n9 == 0) {
                int n14 = Compute.d6(1);
                report = new Report(2395);
                report.addDesc(entity);
                report.add(n14);
                report.subject = entity.getId();
                this.addReport(report);
                if (n14 == 6) {
                    object.removeTerrain(24);
                    object.addTerrain(Terrains.getTerrainFactory().createTerrain(24, 2));
                    this.sendChangedHex(coords3);
                    Enumeration<Entity> enumeration2 = this.game.getEntities(coords3);
                    while (enumeration2.hasMoreElements()) {
                        Entity entity3 = enumeration2.nextElement();
                        if (entity3 == entity) continue;
                        this.doMagmaDamage(entity3, false);
                    }
                }
            }
            if (object.terrainLevel(24) == 2 && n9 == 0) {
                this.doMagmaDamage(entity, false);
            }
            if (((TargetRoll)(object3 = entity.checkSwampMove(moveStep, (IHex)object, coords3, coords2, Compute.canMoveOnPavement(this.game, coords3, coords2)))).getValue() != -2147483647 && 0 < this.doSkillCheckWhileMoving(entity, coords3, coords2, (PilotingRollData)object3, false)) {
                entity.setStuck(true);
                report = new Report(2081);
                report.subject = entity.getId();
                report.add(entity.getDisplayName(), true);
                Entity entity4 = Compute.stackingViolation(this.game, entity.getId(), coords3);
                if (entity4 == null) break;
                Coords coords4 = Compute.getValidDisplacement(this.game, entity.getId(), coords3, n2);
                this.doEntityDisplacement(entity4, coords3, coords4, new PilotingRollData(entity4.getId(), 0, "domino effect"));
                this.entityUpdate(entity4.getId());
                break;
            }
            coords3 = coords2;
            object2 = object;
            report = new Report(2085);
            report.subject = entity.getId();
            report.indent();
            report.add(coords3.getBoardNum(), true);
            this.addReport(report);
        }
        coords3 = entity.getPosition();
        object = Compute.stackingViolation(this.game, entity.getId(), coords3);
        while (object != null) {
            coords2 = Compute.getValidDisplacement(this.game, ((Entity)object).getId(), ((Entity)object).getPosition(), n2);
            if (null == coords2) {
                System.err.println("The skid of " + entity.getShortName() + " should displace " + ((Entity)object).getShortName() + " in hex " + coords3.getBoardNum() + " but there is nowhere to go.");
                break;
            }
            report = new Report(1210, 0);
            report.indent();
            report.newlines = 0;
            this.addReport(report);
            this.doEntityDisplacement((Entity)object, coords3, coords2, null);
            this.doEntityDisplacementMinefieldCheck(entity, coords3, coords2);
            object = Compute.stackingViolation(this.game, entity.getId(), coords3);
        }
        if (entity instanceof Mech) {
            report = new Report(2090);
            report.subject = entity.getId();
            report.indent();
            report.addDesc(entity);
            report.add(n5);
            this.addReport(report);
            for (n5 = n6 * (int)Math.ceil((double)Math.round((double)entity.getWeight() / 10.0) / 2.0); n5 > 0; n5 -= n4) {
                n4 = Math.min(5, n5);
                HitData hitData = entity.rollHitLocation(0, 0);
                this.addReport(this.damageEntity(entity, hitData, n4));
            }
            this.addNewLines();
        }
        if (entity.isDoomed()) {
            entity.setDestroyed(true);
            this.game.moveToGraveyard(entity.getId());
            this.send(this.createRemoveEntityPacket(entity.getId()));
            return true;
        }
        report = new Report(2095);
        report.subject = entity.getId();
        report.indent();
        this.addReport(report);
        return false;
    }

    private void processMovement(Entity entity, MovePath movePath) {
        int n;
        Report report;
        PilotingRollData pilotingRollData;
        Object object;
        int building;
        Object object2;
        Object object3;
        boolean bl2 = false;
        if (movePath.contains(10)) {
            Entity entity2;
            Serializable serializable;
            Enumeration<Entity> enumeration;
            Report report2 = new Report(2005, 0);
            report2.addDesc(entity);
            this.addReport(report2);
            Coords coords = entity.getPosition();
            int n3 = coords.x == 0 ? 3 : (coords.y == 0 ? 1 : (coords.x == this.game.getBoard().getWidth() ? 2 : 0));
            Vector<Entity> vector = entity.getLoadedUnits();
            if (!vector.isEmpty()) {
                enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    serializable = enumeration.nextElement();
                    report2 = new Report(2010, 0);
                    report2.indent();
                    report2.addDesc((Entity)serializable);
                    this.addReport(report2);
                    ((Entity)serializable).setRetreatedDirection(n3);
                    this.game.removeEntity(((Entity)serializable).getId(), 256);
                    this.send(this.createRemoveEntityPacket(((Entity)serializable).getId(), 256));
                }
            }
            enumeration = entity.getPickedUpMechWarriors().elements();
            while (enumeration.hasMoreElements()) {
                serializable = (Integer)((Object)enumeration.nextElement());
                entity2 = this.game.getEntity((Integer)serializable);
                int n4 = 256;
                report2 = new Report(2010);
                if (entity2.isCaptured()) {
                    report2 = new Report(2015);
                    n4 = 288;
                } else {
                    entity2.setRetreatedDirection(n3);
                }
                this.game.removeEntity(entity2.getId(), n4);
                this.send(this.createRemoveEntityPacket(entity2.getId(), n4));
                report2.addDesc(entity2);
                report2.indent();
                this.addReport(report2);
            }
            int n5 = entity.getSwarmAttackerId();
            if (-1 != n5) {
                entity2 = this.game.getEntity(n5);
                if (!entity2.isDone()) {
                    this.game.removeTurnFor(entity2);
                    this.send(this.createTurnVectorPacket());
                }
                entity2.setSwarmTargetId(-1);
                entity.setSwarmAttackerId(-1);
                report2 = new Report(2015, 0);
                report2.indent();
                report2.addDesc(entity2);
                this.addReport(report2);
                this.game.removeEntity(n5, 288);
                this.send(this.createRemoveEntityPacket(n5, 288));
            }
            entity.setRetreatedDirection(n3);
            this.game.removeEntity(entity.getId(), 256);
            this.send(this.createRemoveEntityPacket(entity.getId(), 256));
            return;
        }
        if (movePath.contains(18)) {
            if (entity instanceof Mech) {
                Report report3 = new Report(2020);
                report3.subject = entity.getId();
                report3.add(entity.getCrew().getName());
                report3.addDesc(entity);
                this.addReport(report3);
            } else if (entity instanceof Tank) {
                Report report4 = new Report(2025);
                report4.subject = entity.getId();
                report4.addDesc(entity);
                this.addReport(report4);
            }
            this.addReport(this.ejectEntity(entity, false));
            return;
        }
        Coords coords = entity.getPosition();
        Coords coords2 = entity.getPosition();
        int n6 = entity.getFacing();
        int n7 = entity.getElevation();
        int n8 = entity.delta_distance;
        int n9 = entity.mpUsed;
        int n10 = entity.moved;
        int n11 = entity.moved;
        boolean bl3 = false;
        int n12 = n6;
        Object object4 = null;
        boolean bl4 = entity instanceof Infantry;
        Enumeration<Entity> enumeration = null;
        int n13 = -1;
        movePath.compile(this.game, entity);
        if (movePath.contains(19)) {
            object3 = new ClearMinefieldAction(entity.getId());
            entity.setClearingMinefield(true);
            this.game.addAction((EntityAction)object3);
        }
        n11 = movePath.getLastStepMovementType();
        if (this.game.getBoard().getHex(entity.getPosition()).terrainLevel(24) == 2 && entity.getElevation() == 0) {
            this.doMagmaDamage(entity, false);
        }
        boolean bl5 = true;
        boolean bl6 = false;
        object3 = null;
        Vector<UnitLocation> vector = new Vector<UnitLocation>();
        Enumeration enumeration2 = movePath.getSteps();
        while (enumeration2.hasMoreElements()) {
            int n24;
            int entity4;
            Object entity7;
            Object n19;
            object2 = (MoveStep)enumeration2.nextElement();
            boolean bl7 = entity.isProne();
            boolean bl = ((MoveStep)object2).isPavementStep();
            building = 0;
            if (((MoveStep)object2).getMovementType() == -1 || entity.isDestroyed() || entity.isDoomed()) break;
            if (bl5 && entity instanceof Mech && ((Mech)entity).checkForMASCFailure(movePath, (Vector<Report>)(object = new Vector<Report>()), (Vector)(n19 = new Vector()))) {
                this.addReport((Vector<Report>)object);
                entity7 = null;
                int n14 = -1;
                Enumeration n22 = ((Vector)n19).elements();
                while (n22.hasMoreElements()) {
                    Object minefield = n22.nextElement();
                    if (minefield instanceof Integer) {
                        n14 = (Integer)minefield;
                        continue;
                    }
                    if (!(minefield instanceof CriticalSlot)) continue;
                    entity7 = (CriticalSlot)minefield;
                    this.addReport(this.applyCriticalHit(entity, n14, (CriticalSlot)entity7, true));
                }
                this.resolvePilotingRolls(entity);
                this.game.resetPSRs(entity);
                movePath.clear();
                bl3 = true;
                break;
            }
            pilotingRollData = entity.checkGetUp((MoveStep)object2);
            if (pilotingRollData.getValue() != -2147483647) {
                ++entity.heatBuildup;
                entity.setProne(false);
                entity.setHullDown(false);
                bl7 = false;
                this.game.resetPSRs(entity);
                int n2 = building = !this.doSkillCheckInPlace(entity, pilotingRollData) ? 1 : 0;
            }
            if (building != 0) {
                n10 = ((MoveStep)object2).getMovementType();
                n6 = entity.getFacing();
                coords2 = entity.getPosition();
                n9 = ((MoveStep)object2).getMpUsed();
                bl3 = true;
                break;
            }
            if (((MoveStep)object2).getType() == 15) {
                entity.setUnjammingRAC(true);
                this.game.addAction(new UnjamAction(entity.getId()));
                break;
            }
            if (((MoveStep)object2).getType() == 23) {
                n19 = new LayMinefieldAction(entity.getId(), ((MoveStep)object2).getMineToLay());
                this.game.addLayMinefieldAction((LayMinefieldAction)n19);
                entity.setLayingMines(true);
                break;
            }
            if (((MoveStep)object2).getType() == 22 && entity.hasSpotlight()) {
                boolean mounted = !entity.isUsingSpotlight();
                entity.setSpotlightState(mounted);
                this.sendServerChat(entity.getDisplayName() + " switched searchlight " + (mounted ? "on" : "off") + '.');
            }
            n10 = ((MoveStep)object2).getMovementType();
            n8 = ((MoveStep)object2).getDistance();
            n9 = ((MoveStep)object2).getMpUsed();
            if (n13 < 0) {
                int n3 = n13 = 3 == n10 ? entity.getOriginalJumpMP() : entity.getRunMP(false);
            }
            if (((MoveStep)object2).getType() == 8) {
                if (entity.canCharge()) {
                    this.checkExtremeGravityMovement(entity, (MoveStep)object2, coords2, n13);
                    n19 = ((MoveStep)object2).getTarget(this.game);
                    object = new ChargeAttackAction(entity.getId(), n19.getTargetType(), n19.getTargetId(), n19.getPosition());
                    entity.setDisplacementAttack((DisplacementAttackAction)object);
                    this.game.addCharge((AttackAction)object);
                    enumeration = object;
                    break;
                }
                this.sendServerChat("Illegal charge!! I don't think " + entity.getDisplayName() + " should be allowed to charge," + " but the client of " + entity.getOwner().getName() + " disagrees.");
                this.sendServerChat("Please make sure " + entity.getOwner().getName() + " is running MegaMek " + MegaMek.VERSION + ", or if that is already the case, submit a bug report at http://megamek.sf.net/");
                return;
            }
            if (((MoveStep)object2).getType() == 9) {
                if (entity.canDFA()) {
                    this.checkExtremeGravityMovement(entity, (MoveStep)object2, coords2, n13);
                    n19 = ((MoveStep)object2).getTarget(this.game);
                    object = new DfaAttackAction(entity.getId(), n19.getTargetType(), n19.getTargetId(), n19.getPosition());
                    entity.setDisplacementAttack((DisplacementAttackAction)object);
                    this.game.addCharge((AttackAction)object);
                    enumeration = object;
                    break;
                }
                this.sendServerChat("Illegal DFA!! I don't think " + entity.getDisplayName() + " should be allowed to DFA," + " but the client of " + entity.getOwner().getName() + " disagrees.");
                this.sendServerChat("Please make sure " + entity.getOwner().getName() + " is running MegaMek " + MegaMek.VERSION + ", or if that is already the case, submit a bug report at http://megamek.sf.net/");
                return;
            }
            if (entity instanceof Infantry) {
                n19 = (Infantry)entity;
                if (((MoveStep)object2).getType() == 28) {
                    ((Infantry)n19).setDugIn(1);
                    continue;
                }
                if (((MoveStep)object2).getType() == 29) {
                    if (!entity.hasWorkingMisc(0x100000L, 1)) {
                        this.sendServerChat(entity.getDisplayName() + " failed to fortify because it is missing suitable equipment");
                    }
                    ((Infantry)n19).setDugIn(3);
                    continue;
                }
                if (((MoveStep)object2).getType() != 3 && ((MoveStep)object2).getType() != 4) {
                    ((Infantry)n19).setDugIn(0);
                }
            }
            coords2 = ((MoveStep)object2).getPosition();
            if (n10 != 3 || entity.getJumpType() != 3) {
                n6 = ((MoveStep)object2).getFacing();
            }
            int iHex = entity.checkMovementInBuilding((MoveStep)object2, (MoveStep)object3, coords2, coords);
            n7 = ((MoveStep)object2).getElevation();
            entity.setElevation(((MoveStep)object2).getElevation());
            object = this.game.getBoard().getHex(coords2);
            if (entity.canUnstickByJumping() && entity.isStuck() && n10 == 3) {
                entity.setStuck(false);
                entity.setCanUnstickByJumping(false);
            }
            if ((pilotingRollData = entity.checkSkid(n10, (IHex)object4, n11, (MoveStep)object3, n12, n6, coords, coords2, bl4, n8)).getValue() != -2147483647) {
                boolean n15 = true;
                if (entity instanceof Mech) {
                    n15 = 0 < this.doSkillCheckWhileMoving(entity, coords, coords, pilotingRollData, true);
                } else {
                    boolean bl8 = n15 = 0 < this.doSkillCheckWhileMoving(entity, coords, coords, pilotingRollData, false);
                }
                if (n15) {
                    if (entity instanceof Tank) {
                        this.addReport(this.vehicleMotiveDamage((Tank)entity, 0));
                    }
                    coords2 = coords;
                    int enumeration4 = (n8 + 1) / 2;
                    int entity3 = n12;
                    entity.delta_distance = n8 - 1;
                    n10 = -2;
                    if (((MoveStep)object2).isThisStepBackwards()) {
                        entity3 = (entity3 + 3) % 6;
                    }
                    if (this.processSkid(entity, coords2, ((MoveStep)object2).getElevation(), entity3, enumeration4, (MoveStep)object2)) {
                        return;
                    }
                    n6 = entity.getFacing();
                    coords2 = entity.getPosition();
                    entity.setSecondaryFacing(n6);
                    n9 = movePath.hasActiveMASC() ? entity.getRunMP() : entity.getRunMPwithoutMASC();
                    entity.moved = n10;
                    bl3 = true;
                    bl6 = true;
                    n8 = entity.delta_distance;
                    break;
                }
            }
            if ((entity instanceof VTOL || entity.getMovementMode() == 5 || entity.getMovementMode() == 15) && (pilotingRollData = entity.checkSideSlip(n10, (IHex)object4, n11, (MoveStep)object3, n12, n6, coords, coords2, n8)).getValue() != -2147483647 && (entity4 = this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, false)) > 0 && (n24 = Math.min(entity4, n8 - 1)) > 0) {
                int coords3 = n12;
                bl2 = true;
                report = new Report(2100);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n24);
                this.addReport(report);
                if (this.processSkid(entity, coords, ((MoveStep)object2).getElevation(), coords3, n24, (MoveStep)object2)) {
                    return;
                }
                if (!entity.isDestroyed() && !entity.isDoomed()) {
                    bl3 = true;
                }
                if (entity.getElevation() == 0 && (entity.getMovementMode() == 6 || entity.getMovementMode() == 15)) {
                    bl6 = true;
                }
                n6 = entity.getFacing();
                coords2 = entity.getPosition();
                entity.setSecondaryFacing(n6);
                break;
            }
            pilotingRollData = entity.checkRubbleMove((MoveStep)object2, (IHex)object, coords, coords2);
            if (pilotingRollData.getValue() != -2147483647) {
                this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, true);
            }
            if (object.terrainLevel(24) == 1 && ((MoveStep)object2).getElevation() == 0 && ((MoveStep)object2).getMovementType() != 3) {
                int n30 = Compute.d6(1);
                report = new Report(2395);
                report.addDesc(entity);
                report.add(n30);
                report.subject = entity.getId();
                this.addReport(report);
                if (n30 == 6) {
                    object.removeTerrain(24);
                    object.addTerrain(Terrains.getTerrainFactory().createTerrain(24, 2));
                    this.sendChangedHex(coords2);
                    Enumeration<Entity> n25 = this.game.getEntities(coords2);
                    while (n25.hasMoreElements()) {
                        Entity minefield = n25.nextElement();
                        if (minefield == entity) continue;
                        this.doMagmaDamage(minefield, false);
                    }
                }
            }
            if (object.terrainLevel(24) == 2 && ((MoveStep)object2).getElevation() == 0 && ((MoveStep)object2).getMovementType() != 3) {
                this.doMagmaDamage(entity, false);
            }
            if ((pilotingRollData = entity.checkSwampMove((MoveStep)object2, (IHex)object, coords, coords2, bl)).getValue() != -2147483647 && 0 < this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, false)) {
                entity.setStuck(true);
                entity.setCanUnstickByJumping(true);
                report = new Report(2081);
                report.add(entity.getDisplayName());
                report.subject = entity.getId();
                this.addReport(report);
                Entity entity2 = Compute.stackingViolation(this.game, entity.getId(), coords2);
                if (entity2 == null) break;
                int enumeration5 = coords.direction(coords2);
                Coords enumeration6 = Compute.getValidDisplacement(this.game, entity.getId(), coords2, enumeration5);
                this.doEntityDisplacement(entity2, coords2, enumeration6, new PilotingRollData(entity2.getId(), 0, "domino effect"));
                this.entityUpdate(entity2.getId());
                break;
            }
            entity7 = this.game.getBoard().getHex(coords);
            if (entity instanceof Mech && !coords.equals(coords2) && object3 != null && (entity7.containsTerrain(7) && ((MoveStep)object3).getElevation() <= 1 || entity7.containsTerrain(24) && ((MoveStep)object3).getElevation() == 0) && (((MoveStep)object2).getMovementType() != 3 || 0 == ((MoveStep)object2).getMpUsed() - ((MoveStep)object2).getMp())) {
                int player = 0;
                if (entity7.containsTerrain(7)) {
                    player += 2;
                }
                if (entity7.terrainLevel(24) == 1) {
                    player += 2;
                } else if (entity7.terrainLevel(24) == 2) {
                    player += 5;
                }
                entity.heatFromExternal += player;
                report = new Report(2115);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(player);
                this.addReport(report);
            }
            if (!(entity instanceof Mech) && this.game.getBoard().getHex(coords2).containsTerrain(7) && !coords.equals(coords2) && ((MoveStep)object2).getMovementType() != 3 && ((MoveStep)object2).getElevation() <= 1) {
                if (this.game.getOptions().booleanOption("vehicle_fires") && entity instanceof Tank) {
                    this.checkForVehicleFire((Tank)entity, false);
                } else {
                    this.doFlamingDeath(entity);
                }
            }
            if (!enumeration2.hasMoreElements() && !bl5) {
                this.checkExtremeGravityMovement(entity, (MoveStep)object2, coords2, n13);
            }
            if (!coords.equals(coords2) && ((MoveStep)object2).getMovementType() != 3 || n11 == 3 && !enumeration2.hasMoreElements()) {
                this.checkVibrabombs(entity, coords2, false, coords, coords2);
                if (this.game.containsMinefield(coords2)) {
                    Enumeration<Minefield> n26 = this.game.getMinefields(coords2).elements();
                    while (n26.hasMoreElements()) {
                        Minefield bl13 = n26.nextElement();
                        boolean entity5 = !enumeration2.hasMoreElements();
                        entity5 |= ((MoveStep)object2).getMovementType() != 3;
                        boolean bl9 = ((MoveStep)object2).getElevation() == 0;
                        entity.setPosition(coords2);
                        if (entity5 &= bl9) {
                            this.enterMinefield(entity, bl13, coords2, coords2, true);
                        } else if (bl13.getType() == 5) {
                            this.enterMinefield(entity, bl13, coords2, coords2, true, 2);
                        }
                        entity.setPosition(coords);
                    }
                }
            }
            if (!coords.equals(coords2) && !enumeration2.hasMoreElements() && bl4 && this.game.containsMinefield(coords2)) {
                Player n27 = entity.getOwner();
                Enumeration<Minefield> enumeration7 = this.game.getMinefields(coords2).elements();
                while (enumeration7.hasMoreElements()) {
                    Minefield building3 = enumeration7.nextElement();
                    if (n27.containsMinefield(building3)) continue;
                    report = new Report(2120);
                    report.subject = entity.getId();
                    report.add(entity.getShortName(), true);
                    this.addReport(report);
                    this.revealMinefield(n27, building3);
                }
            }
            if ((pilotingRollData = entity.checkWaterMove((MoveStep)object2, (IHex)object, coords, coords2, bl)).getValue() != -2147483647) {
                int entity6 = entity.getSwarmAttackerId();
                boolean n28 = true;
                Entity entity3 = null;
                if (-1 != entity6) {
                    entity3 = this.game.getEntity(entity6);
                    n28 = entity3.isDone();
                }
                this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, true);
                if (object.terrainLevel(4) > 1) {
                    this.drownSwarmer(entity, coords2);
                }
                if (!n28 && (entity3.isDoomed() || entity3.isDestroyed())) {
                    entity3.setDone(false);
                    entity3.setUnloaded(false);
                    this.game.removeTurnFor(entity3);
                    this.send(this.createTurnVectorPacket());
                    entity3.setDone(true);
                    entity3.setUnloaded(true);
                }
                this.checkForWashedInfernos(entity, coords2);
            }
            this.doSetLocationsExposure(entity, (IHex)object, ((MoveStep)object2).getMovementType() == 3, ((MoveStep)object2).getElevation());
            if (object4 != null && object3 != null && ((MoveStep)object3).getElevation() < 0 && ((MoveStep)object2).getElevation() == 0 && object4.containsTerrain(20) && object4.containsTerrain(4) && ((MoveStep)object2).getMovementType() != 3 && !coords.equals(coords2)) {
                report = new Report(2410);
                report.addDesc(entity);
                this.addReport(report);
                this.resolveIceBroken(coords);
            }
            if (object.containsTerrain(20) && object.containsTerrain(4) && ((MoveStep)object2).getMovementType() != 3 && !coords.equals(coords2)) {
                if (((MoveStep)object2).getElevation() == 0) {
                    int targetable = Compute.d6(1);
                    report = new Report(2118);
                    report.addDesc(entity);
                    report.add(targetable);
                    report.subject = entity.getId();
                    this.addReport(report);
                    if (targetable == 6) {
                        this.resolveIceBroken(coords2);
                        this.doEntityFallsInto(entity, coords, coords2, entity.getBasePilotingRoll(), false);
                    }
                } else if (((MoveStep)object2).getElevation() + entity.height() == 0) {
                    report = new Report(2410);
                    report.addDesc(entity);
                    this.addReport(report);
                    this.resolveIceBroken(coords2);
                }
            }
            if (((MoveStep)object2).getType() == 16) {
                Entity pilotingRollData2 = null;
                Enumeration<Entity> building2 = this.game.getEntities(coords2);
                while (building2.hasMoreElements()) {
                    pilotingRollData2 = building2.nextElement();
                    if (!entity.isEnemyOf(pilotingRollData2) && !entity.equals(pilotingRollData2)) {
                        if (!entity.canLoad(pilotingRollData2) || !pilotingRollData2.isLoadableThisTurn()) {
                            System.err.println(entity.getShortName() + " can not load " + pilotingRollData2.getShortName());
                            pilotingRollData2 = null;
                            continue;
                        }
                        this.loadUnit(entity, pilotingRollData2);
                        break;
                    }
                    pilotingRollData2 = null;
                }
                if (pilotingRollData2 == null) {
                    System.err.println("Could not find unit for " + entity.getShortName() + " to load in " + coords2);
                }
            }
            if (((MoveStep)object2).getType() == 17 && !this.unloadUnit(entity, building = ((MoveStep)object2).getTarget(this.game), coords2, n6, ((MoveStep)object2).getElevation())) {
                System.err.println("Error! Server was told to unload " + building.getDisplayName() + " from " + entity.getDisplayName() + " into " + coords2.getBoardNum());
            }
            if (!(((MoveStep)object2).getType() != 2 && ((MoveStep)object2).getType() != 13 && ((MoveStep)object2).getType() != 14 || this.game.getBoard().getHex(coords).getElevation() == object.getElevation() || entity instanceof VTOL)) {
                PilotingRollData mounted = entity.getBasePilotingRoll();
                int equipmentType = Compute.d6(2);
                report = entity instanceof Tank ? new Report(2435) : new Report(2430);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(mounted.getValue());
                report.add(equipmentType);
                this.addReport(report);
                if (equipmentType < mounted.getValue()) {
                    if (entity instanceof Mech) {
                        if (object.getElevation() < this.game.getBoard().getHex(coords).getElevation()) {
                            this.doEntityFallsInto(entity, coords, coords2, entity.getBasePilotingRoll(), false);
                        } else {
                            this.doEntityFallsInto(entity, coords2, coords, entity.getBasePilotingRoll(), false);
                        }
                    } else if (entity instanceof Tank) {
                        coords2 = coords;
                    }
                }
            }
            if (iHex > 0) {
                Building building2 = null;
                if ((iHex & 1) == 1) {
                    building2 = this.game.getBoard().getBuildingAt(coords);
                }
                Building building3 = null;
                if ((iHex & 2) == 2) {
                    building3 = this.game.getBoard().getBuildingAt(coords2);
                }
                Building building4 = null;
                if ((iHex & 4) == 4) {
                    building4 = this.game.getBoard().getBuildingAt(coords2);
                }
                boolean bl10 = false;
                if (building3 != null || building2 != null) {
                    if (building2 == null) {
                        bl10 = this.passBuildingWall(entity, building3, coords, coords2, n8, "entering", ((MoveStep)object2).isThisStepBackwards());
                        this.addAffectedBldg(building3, bl10);
                    } else if (building2.equals(building3)) {
                        bl10 = this.passBuildingWall(entity, building3, coords, coords2, n8, "moving in", ((MoveStep)object2).isThisStepBackwards());
                        this.addAffectedBldg(building3, bl10);
                    } else if (building2 != null && building3 != null) {
                        bl10 = this.passBuildingWall(entity, building2, coords, coords2, n8, "exiting", ((MoveStep)object2).isThisStepBackwards());
                        this.addAffectedBldg(building2, bl10);
                        bl10 = this.passBuildingWall(entity, building3, coords, coords2, n8, "entering", ((MoveStep)object2).isThisStepBackwards());
                        this.addAffectedBldg(building3, bl10);
                    } else if (building2 != null) {
                        bl10 = this.passBuildingWall(entity, building2, coords, coords2, n8, "exiting", ((MoveStep)object2).isThisStepBackwards());
                        this.addAffectedBldg(building2, bl10);
                    }
                }
                if (building4 != null) {
                    bl10 = this.checkBuildingCollapseWhileMoving(building4, entity, coords2);
                    this.addAffectedBldg(building4, bl10);
                }
                if (entity.isDoomed()) {
                    entity.setDestroyed(true);
                    this.game.moveToGraveyard(entity.getId());
                    this.send(this.createRemoveEntityPacket(entity.getId()));
                    return;
                }
            }
            if (!bl7 && entity.isProne()) {
                n6 = entity.getFacing();
                coords2 = entity.getPosition();
                n9 = ((MoveStep)object2).getMpUsed();
                bl3 = true;
                break;
            }
            if (((MoveStep)object2).getType() == 6) {
                n9 = ((MoveStep)object2).getMpUsed();
                pilotingRollData = entity.checkDislodgeSwarmers((MoveStep)object2);
                if (pilotingRollData.getValue() == -2147483647) {
                    entity.setProne(true);
                    this.checkForWashedInfernos(entity, coords2);
                } else {
                    entity.setPosition(coords2);
                    if (this.doDislodgeSwarmerSkillCheck(entity, pilotingRollData, coords2)) {
                        n6 = entity.getFacing();
                        coords2 = entity.getPosition();
                        bl3 = true;
                        break;
                    }
                    entity.setProne(true);
                    this.checkForWashedInfernos(entity, coords2);
                    break;
                }
            }
            if (((MoveStep)object2).getType() == 24) {
                n9 = ((MoveStep)object2).getMpUsed();
                entity.setHullDown(true);
            }
            vector.addElement(new UnitLocation(entity.getId(), coords2, n6));
            coords = new Coords(coords2);
            object3 = object2;
            if (!object.equals(object4)) {
                n12 = n6;
            }
            object4 = object;
            bl5 = false;
        }
        entity.setPosition(coords2);
        entity.setFacing(n6);
        entity.setSecondaryFacing(n6);
        entity.delta_distance = n8;
        entity.moved = n10;
        entity.mpUsed = n9;
        if (!bl2 && !bl3) {
            entity.setElevation(n7);
        }
        entity.setClimbMode(movePath.getFinalClimbMode());
        pilotingRollData = entity.checkRunningWithDamage(n11);
        if (pilotingRollData.getValue() != -2147483647) {
            this.doSkillCheckInPlace(entity, pilotingRollData);
        }
        if (-1 != (n = entity.getSwarmAttackerId()) && movePath.contains(30)) {
            object2 = this.game.getEntity(n);
            PilotingRollData pilotingRollData3 = entity.getBasePilotingRoll();
            entity.addPilotingModifierForTerrain(pilotingRollData3);
            if (movePath.getLastStepMovementType() == 5) {
                pilotingRollData3.addModifier(2, "dislodge swarming infantry with VTOL movement");
            } else {
                pilotingRollData3.addModifier(4, "dislodge swarming infantry");
            }
            for (Mounted n29 : ((Entity)object2).getMisc()) {
                object = n29.getType();
                if ("BA-Assault Claws".equals(((EquipmentType)object).getInternalName())) {
                    pilotingRollData3.addModifier(1, "swarmer has assault claws");
                    break;
                }
                if (!((EquipmentType)object).hasFlag(0x200000L)) continue;
                pilotingRollData3.addModifier(1, "swarmer has magnetic claw");
                break;
            }
            report = new Report(2125);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
            building = Compute.d6(2);
            report = new Report(2130);
            report.subject = entity.getId();
            report.add(pilotingRollData3.getValueAsString());
            report.add(pilotingRollData3.getDesc());
            report.add(building);
            if (building < pilotingRollData3.getValue()) {
                report.choose(false);
                this.addReport(report);
            } else {
                this.game.removeTurnFor((Entity)object2);
                this.send(this.createTurnVectorPacket());
                report.choose(true);
                this.addReport(report);
                entity.setSwarmAttackerId(-1);
                ((Entity)object2).setSwarmTargetId(-1);
                IHex pilotingRollData4 = this.game.getBoard().getHex(coords2);
                if (pilotingRollData4.terrainLevel(4) > 0) {
                    ((Entity)object2).setPosition(coords2);
                    report = new Report(2135);
                    report.subject = entity.getId();
                    report.indent();
                    report.addDesc((Entity)object2);
                    this.addReport(report);
                    this.addReport(this.destroyEntity((Entity)object2, "a watery grave", false));
                } else {
                    report = new Report(2140);
                    report.subject = entity.getId();
                    report.indent();
                    report.addDesc((Entity)object2);
                    report.add("3d6");
                    this.addReport(report);
                    this.addReport(this.damageEntity((Entity)object2, ((Entity)object2).rollHitLocation(0, 0), Compute.d6(3)));
                    this.addNewLines();
                    ((Entity)object2).setPosition(coords2);
                }
                this.entityUpdate(n);
            }
        }
        if (n11 == 3 && !entity.isMakingDfa()) {
            Building building5;
            boolean bl;
            object2 = this.game.getBoard().getHex(coords2);
            pilotingRollData = entity.checkLandingWithDamage();
            if (pilotingRollData.getValue() != -2147483647) {
                this.doSkillCheckInPlace(entity, pilotingRollData);
            }
            int n4 = object2.terrainLevel(4);
            if (object2.containsTerrain(20) && n4 > 0) {
                bl = false;
                building = Compute.d6(1);
                report = new Report(2122);
                report.add(entity.getDisplayName(), true);
                report.add(building);
                report.subject = entity.getId();
                this.addReport(report);
                if (building >= 4) {
                    this.resolveIceBroken(coords2);
                    this.doEntityFallsInto(entity, coords, coords2, entity.getBasePilotingRoll(), false);
                }
            }
            if ((pilotingRollData = entity.checkWaterMove(bl ? 1 : 0)).getValue() != -2147483647) {
                this.doSkillCheckInPlace(entity, pilotingRollData);
            }
            if (bl > true) {
                this.drownSwarmer(entity, coords2);
            }
            if ((building5 = this.game.getBoard().getBuildingAt(coords2)) != null) {
                this.checkForCollapse(building5, this.game.getPositionMap());
            }
            if (object2.terrainLevel(24) == 1) {
                int entity8 = Compute.d6(1);
                report = new Report(2395);
                report.addDesc(entity);
                report.add(entity8);
                report.subject = entity.getId();
                this.addReport(report);
                if (entity8 == 6) {
                    object2.removeTerrain(24);
                    object2.addTerrain(Terrains.getTerrainFactory().createTerrain(24, 2));
                    this.sendChangedHex(coords2);
                    object = this.game.getEntities(coords2);
                    while (object.hasMoreElements()) {
                        Entity n23 = object.nextElement();
                        if (n23 == entity) continue;
                        this.doMagmaDamage(n23, false);
                    }
                }
            }
            if (object2.terrainLevel(24) == 2) {
                this.doMagmaDamage(entity, false);
            }
            if (object2.containsTerrain(9) || object2.containsTerrain(24) || object2.containsTerrain(28) || object2.containsTerrain(25) || object2.containsTerrain(29)) {
                if (entity instanceof Mech) {
                    entity.setStuck(true);
                    report = new Report(2121);
                    report.add(entity.getDisplayName(), true);
                    report.subject = entity.getId();
                    this.addReport(report);
                } else if (entity instanceof Infantry) {
                    PilotingRollData pilotingRollData2 = entity.getBasePilotingRoll();
                    pilotingRollData2.addModifier(5, "infantry jumping into swamp");
                    if (0 < this.doSkillCheckWhileMoving(entity, coords2, coords2, pilotingRollData2, false)) {
                        entity.setStuck(true);
                        report = new Report(2081);
                        report.add(entity.getDisplayName());
                        report.subject = entity.getId();
                        this.addReport(report);
                    }
                }
            }
            if (-1 != n) {
                Entity entity4 = this.game.getEntity(n);
                object = entity.getBasePilotingRoll();
                entity.addPilotingModifierForTerrain((PilotingRollData)object);
                ((TargetRoll)object).addModifier(4, "dislodge swarming infantry");
                for (Mounted mounted : entity4.getMisc()) {
                    EquipmentType equipmentType = mounted.getType();
                    if ("BA-Assault Claws".equals(equipmentType.getInternalName())) {
                        ((TargetRoll)object).addModifier(1, "swarmer has assault claws");
                        break;
                    }
                    if (!equipmentType.hasFlag(0x200000L)) continue;
                    ((TargetRoll)object).addModifier(1, "swarmer has magnetic claw");
                    break;
                }
                report = new Report(2125);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
                int n5 = Compute.d6(2);
                report = new Report(2130);
                report.subject = entity.getId();
                report.add(((TargetRoll)object).getValueAsString());
                report.add(((TargetRoll)object).getDesc());
                report.add(n5);
                if (n5 < ((TargetRoll)object).getValue()) {
                    report.choose(false);
                    this.addReport(report);
                } else {
                    this.game.removeTurnFor(entity4);
                    this.send(this.createTurnVectorPacket());
                    report.choose(true);
                    this.addReport(report);
                    entity.setSwarmAttackerId(-1);
                    entity4.setSwarmTargetId(-1);
                    if (object2.terrainLevel(4) > 0) {
                        entity4.setPosition(coords2);
                        report = new Report(2135);
                        report.subject = entity.getId();
                        report.indent();
                        report.addDesc(entity4);
                        this.addReport(report);
                        this.addReport(this.destroyEntity(entity4, "a watery grave", false));
                    } else {
                        report = new Report(2140);
                        report.subject = entity.getId();
                        report.indent();
                        report.addDesc(entity4);
                        report.add("3d6");
                        this.addReport(report);
                        this.addReport(this.damageEntity(entity4, entity4.rollHitLocation(0, 0), Compute.d6(3)));
                        this.addNewLines();
                        entity4.setPosition(coords2);
                    }
                    this.entityUpdate(n);
                }
            }
            this.checkForWashedInfernos(entity, coords2);
        }
        this.doSetLocationsExposure(entity, this.game.getBoard().getHex(coords2), false, entity.getElevation());
        if (!this.game.getOptions().booleanOption("falls_end_movement") && bl3 && !bl6 && entity.mpUsed < entity.getRunMP() && entity.isSelectableThisTurn() && !entity.isDoomed()) {
            entity.applyDamage();
            entity.setDone(false);
            object2 = new GameTurn.SpecificEntityTurn(entity.getOwner().getId(), entity.getId());
            this.game.insertNextTurn((GameTurn)object2);
            this.send(this.createTurnVectorPacket());
            this.send(entity.getOwner().getId(), this.createSpecialReportPacket());
        } else {
            entity.setDone(true);
        }
        if (-1 != n) {
            object2 = this.game.getEntity(n);
            ((Entity)object2).setPosition(coords2);
            if (!(object2 instanceof BattleArmor) && this.game.getBoard().getHex(coords2).containsTerrain(7)) {
                ((Entity)object2).setSwarmTargetId(-1);
                entity.setSwarmAttackerId(-1);
                report = new Report(2145);
                report.subject = entity.getId();
                report.indent();
                report.add(((Entity)object2).getShortName(), true);
                this.addReport(report);
            }
            this.entityUpdate(n);
        }
        if (!this.game.isOutOfGame(entity)) {
            this.entityUpdate(entity.getId(), vector);
            if (entity.isDoomed()) {
                this.send(this.createRemoveEntityPacket(entity.getId(), entity.getRemovalCondition()));
            }
        }
        if (this.doBlind()) {
            this.send(entity.getOwner().getId(), this.createFilteredEntitiesPacket(entity.getOwner()));
        }
        if (enumeration != null) {
            this.send(this.createAttackPacket((EntityAction)((Object)enumeration), 1));
        }
    }

    private void deliverThunderAugMinefield(Coords coords, int n, int n2) {
        Coords coords2 = null;
        for (int i = 0; i < 7; ++i) {
            switch (i) {
                case 6: {
                    coords2 = new Coords(coords);
                    break;
                }
                default: {
                    coords2 = coords.translated(i);
                }
            }
            if (!this.game.getBoard().contains(coords2)) continue;
            Minefield minefield = null;
            Enumeration<Minefield> enumeration = this.game.getMinefields(coords2).elements();
            while (enumeration.hasMoreElements()) {
                Minefield minefield2 = enumeration.nextElement();
                if (minefield2.getType() != 3) continue;
                minefield = minefield2;
                break;
            }
            if (minefield == null) {
                minefield = Minefield.createThunderMF(coords2, n, n2 / 2 + n2 % 2);
                this.game.addMinefield(minefield);
                this.revealMinefield(minefield);
                continue;
            }
            if (minefield.getDamage() >= 20) continue;
            this.removeMinefield(minefield);
            int n3 = n2 / 2 + n2 % 2;
            if ((n3 += minefield.getDamage()) > 20) {
                n3 = 20;
            }
            minefield.setDamage(n3);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverThunderMinefield(Coords coords, int n, int n2) {
        Minefield minefield = null;
        Enumeration<Minefield> enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = enumeration.nextElement();
            if (minefield2.getType() != 3) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderMF(coords, n, n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n3 = minefield.getDamage();
            n2 = (n2 += n3) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverThunderInfernoMinefield(Coords coords, int n, int n2) {
        Minefield minefield = null;
        Enumeration<Minefield> enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = enumeration.nextElement();
            if (minefield2.getType() != 4) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderInfernoMF(coords, n, n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n3 = minefield.getDamage();
            n2 = (n2 += n3) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverFASCAMMinefield(Coords coords, int n) {
        if (this.game.getBoard().contains(coords)) {
            Minefield minefield = null;
            Enumeration<Minefield> enumeration = this.game.getMinefields(coords).elements();
            while (enumeration.hasMoreElements()) {
                Minefield minefield2 = enumeration.nextElement();
                if (minefield2.getType() != 3) continue;
                minefield = minefield2;
                break;
            }
            if (minefield == null) {
                minefield = Minefield.createThunderMF(coords, n, 30);
            }
            this.removeMinefield(minefield);
            minefield.setDamage(30);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverThunderActiveMinefield(Coords coords, int n, int n2) {
        Minefield minefield = null;
        Enumeration<Minefield> enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = enumeration.nextElement();
            if (minefield2.getType() != 5) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderActiveMF(coords, n, n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n3 = minefield.getDamage();
            n2 = (n2 += n3) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addMinefield(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverThunderVibraMinefield(Coords coords, int n, int n2, int n3) {
        Minefield minefield = null;
        Enumeration<Minefield> enumeration = this.game.getMinefields(coords).elements();
        while (enumeration.hasMoreElements()) {
            Minefield minefield2 = enumeration.nextElement();
            if (minefield2.getType() != 6) continue;
            minefield = minefield2;
            break;
        }
        if (minefield == null) {
            minefield = Minefield.createThunderVibrabombMF(coords, n, n2, n3);
            this.game.addVibrabomb(minefield);
            this.revealMinefield(minefield);
        } else if (minefield.getDamage() < 20) {
            this.removeMinefield(minefield);
            int n4 = minefield.getDamage();
            n2 = (n2 += n4) > 20 ? 20 : n2;
            minefield.setDamage(n2);
            this.game.addVibrabomb(minefield);
            this.revealMinefield(minefield);
        }
    }

    private void deliverFlare(Coords coords, int n) {
        Flare flare = new Flare(coords, Math.max(1, n / 5), 3, 0);
        this.game.addFlare(flare);
    }

    private void deliverArtilleryFlare(Coords coords, int n) {
        Flare flare = new Flare(coords, 12, n, Flare.F_DRIFTING);
        this.game.addFlare(flare);
    }

    private void deliverArtillerySmoke(Coords coords) {
        IHex iHex;
        if (this.game.getOptions().booleanOption("maxtech_fire") && (iHex = this.game.getBoard().getHex(coords)).terrainLevel(8) < 2) {
            Report report = new Report(5185, 0);
            report.indent(2);
            report.add(coords.getBoardNum());
            this.addReport(report);
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 2));
            this.sendChangedHex(coords);
        }
    }

    private void deliverArtilleryInferno(Coords coords, int n) {
        Serializable serializable;
        Report report;
        IHex iHex = this.game.getBoard().getHex(coords);
        if (!iHex.containsTerrain(7) && this.game.getOptions().booleanOption("fire")) {
            report = new Report(3005);
            report.subject = n;
            report.indent(2);
            report.add(coords.getBoardNum());
            this.addReport(report);
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
        }
        this.game.getBoard().addInfernoTo(coords, InfernoTracker.INFERNO_IV_ROUND, 1);
        this.sendChangedHex(coords);
        Enumeration<Entity> enumeration = this.game.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            ((Entity)serializable).infernos.add(InfernoTracker.INFERNO_IV_ROUND, 1);
            report = new Report(3205);
            report.indent(2);
            report.subject = ((Entity)serializable).getId();
            report.addDesc((Entity)serializable);
            report.add(((Entity)serializable).infernos.getTurnsLeftToBurn());
            this.addReport(report);
        }
        for (int i = 0; i <= 5; ++i) {
            serializable = coords.translated(i);
            if (!this.game.getBoard().contains((Coords)serializable) || coords.equals(serializable)) continue;
            iHex = this.game.getBoard().getHex((Coords)serializable);
            if (!iHex.containsTerrain(7) && this.game.getOptions().booleanOption("fire")) {
                report = new Report(3005);
                report.subject = n;
                report.indent(2);
                report.add(((Coords)serializable).getBoardNum());
                this.addReport(report);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
            }
            this.game.getBoard().addInfernoTo((Coords)serializable, InfernoTracker.INFERNO_IV_ROUND, 1);
            this.sendChangedHex((Coords)serializable);
            Enumeration<Entity> enumeration2 = this.game.getEntities((Coords)serializable);
            while (enumeration2.hasMoreElements()) {
                Entity entity = enumeration2.nextElement();
                entity.infernos.add(InfernoTracker.INFERNO_IV_ROUND, 1);
                report = new Report(3205);
                report.indent(2);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(entity.infernos.getTurnsLeftToBurn());
                this.addReport(report);
            }
        }
    }

    private void deliverInfernoMissiles(Entity entity, Targetable targetable, int n) {
        IHex iHex = this.game.getBoard().getHex(targetable.getPosition());
        Report report = new Report(3370);
        report.subject = entity.getId();
        report.add(n);
        this.addReport(report);
        switch (targetable.getTargetType()) {
            case 7: {
                Enumeration<Entity> enumeration = this.game.getEntities(targetable.getPosition());
                while (enumeration.hasMoreElements()) {
                    Entity entity2 = enumeration.nextElement();
                    if (entity2.getElevation() > iHex.terrainLevel(12)) {
                        report = new Report(6685);
                        report.subject = entity2.getId();
                        report.addDesc(entity2);
                        this.addReport(report);
                        this.deliverInfernoMissiles(entity, entity2, n);
                        continue;
                    }
                    int n2 = Compute.d6();
                    report = new Report(3570);
                    report.subject = entity2.getId();
                    report.addDesc(entity2);
                    report.add(n2);
                    this.addReport(report);
                    if (n2 < 5) continue;
                    this.deliverInfernoMissiles(entity, entity2, n);
                }
                if (this.game.getBoard().getBuildingAt(targetable.getPosition()) != null) {
                    this.addReport(this.damageBuilding(this.game.getBoard().getBuildingAt(targetable.getPosition()), 2 * n));
                }
            }
            case 1: 
            case 2: {
                this.tryClearHex(targetable.getPosition(), n * 4, entity.getId());
                this.tryIgniteHex(targetable.getPosition(), entity.getId(), true, 0);
                break;
            }
            case 3: 
            case 4: {
                Enumeration<Entity> enumeration = this.game.getEntities(targetable.getPosition());
                while (enumeration.hasMoreElements()) {
                    Entity entity3 = enumeration.nextElement();
                    if (entity3.getElevation() > iHex.terrainLevel(12)) continue;
                    int n3 = Compute.d6();
                    report = new Report(3560);
                    report.subject = entity3.getId();
                    report.addDesc(entity3);
                    report.add(n3);
                    this.addReport(report);
                    if (n3 < 5) continue;
                    this.deliverInfernoMissiles(entity, entity3, n);
                }
                this.addReport(this.damageBuilding(this.game.getBoard().getBuildingAt(targetable.getPosition()), 2 * n));
                break;
            }
            case 0: {
                Entity entity4 = (Entity)targetable;
                if (entity4 instanceof Mech) {
                    int n4 = n;
                    for (int i = 0; i < n4; ++i) {
                        LosEffects losEffects;
                        int n5 = Compute.d6(2);
                        if (!entity4.removePartialCoverHits(n5, (losEffects = LosEffects.calculateLos(this.game, entity.getId(), targetable)).getTargetCover(), Compute.targetSideTable(entity, targetable))) continue;
                        --n;
                    }
                    if (n != n4) {
                        report = new Report(3403);
                        report.add(n4 - n);
                        this.addReport(report);
                    }
                    report = new Report(3400);
                    report.add(2 * n);
                    report.subject = entity4.getId();
                    report.choose(true);
                    this.addReport(report);
                    entity4.heatFromExternal += 2 * n;
                    break;
                }
                if (entity4 instanceof Tank) {
                    if (this.game.getOptions().booleanOption("vehicle_fires") && entity4 instanceof Tank) {
                        this.checkForVehicleFire((Tank)entity4, true);
                    }
                    int n6 = Compute.targetSideTable(entity, (Targetable)entity4);
                    while (n-- > 0) {
                        HitData hitData = entity4.rollHitLocation(0, n6);
                        if (entity4 instanceof Protomech && hitData.getLocation() == 6) {
                            report = new Report(6035);
                            report.subject = entity4.getId();
                            this.addReport(report);
                            continue;
                        }
                        this.addReport(this.criticalEntity(entity4, hitData.getLocation(), -2));
                    }
                } else if (entity4 instanceof Protomech) {
                    entity4.heatFromExternal += n;
                    while (entity4.heatFromExternal >= 3) {
                        entity4.heatFromExternal -= 3;
                        HitData hitData = entity4.rollHitLocation(0, 0);
                        if (hitData.getLocation() == 6) {
                            report = new Report(6035);
                            report.subject = entity4.getId();
                            report.newlines = 0;
                            this.addReport(report);
                            continue;
                        }
                        report = new Report(6690);
                        report.subject = entity4.getId();
                        report.newlines = 0;
                        report.add(entity4.getLocationName(hitData));
                        this.addReport(report);
                        entity4.destroyLocation(hitData.getLocation());
                        int n7 = Protomech.POSSIBLE_PILOT_DAMAGE[hitData.getLocation()] - ((Protomech)entity4).getPilotDamageTaken(hitData.getLocation());
                        if (n7 > 0) {
                            this.addReport(this.damageCrew(entity4, n7));
                            ((Protomech)entity4).setPilotDamageTaken(hitData.getLocation(), Protomech.POSSIBLE_PILOT_DAMAGE[hitData.getLocation()]);
                        }
                        if (entity4.getTransferLocation(hitData).getLocation() != -2) continue;
                        this.addReport(this.destroyEntity(entity4, "flaming inferno death", false, true));
                    }
                } else if (entity4 instanceof BattleArmor) {
                    for (Mounted mounted : entity4.getMisc()) {
                        if (!"BA-Fire Resistant Armor".equals(mounted.getType().getInternalName())) continue;
                        report = new Report(3395);
                        report.indent(2);
                        report.subject = entity4.getId();
                        report.addDesc(entity4);
                        this.addReport(report);
                        return;
                    }
                    entity4.heatFromExternal += n;
                    while (entity4.heatFromExternal >= 3) {
                        entity4.heatFromExternal -= 3;
                        HitData hitData = entity4.rollHitLocation(0, 0);
                        hitData.setEffect(1);
                        this.addReport(this.damageEntity(entity4, hitData, 1));
                    }
                } else {
                    if (entity4 instanceof Infantry) {
                        HitData hitData = new HitData(0);
                        this.addReport(this.damageEntity(entity4, hitData, 3 * n));
                        break;
                    }
                    int n8 = Compute.targetSideTable(entity, (Targetable)entity4);
                    while (n-- > 0) {
                        HitData hitData = entity4.rollHitLocation(0, n8);
                        this.addReport(this.damageEntity(entity4, hitData, 2));
                    }
                }
                break;
            }
        }
    }

    private void enterMinefield(Entity entity, Minefield minefield, Coords coords, Coords coords2, boolean bl) {
        this.enterMinefield(entity, minefield, coords, coords2, bl, 0);
    }

    private void enterMinefield(Entity entity, Minefield minefield, Coords coords, Coords coords2, boolean bl, int n) {
        if (!this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(4) || this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(5) || this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(20)) {
            switch (minefield.getType()) {
                case 0: 
                case 3: 
                case 5: {
                    if (minefield.getTrigger() != 0 && Compute.d6(2) < minefield.getTrigger() + n) {
                        return;
                    }
                    Report report = new Report(2150);
                    report.subject = entity.getId();
                    report.add(entity.getShortName(), true);
                    report.add(minefield.getCoords().getBoardNum(), true);
                    this.addReport(report);
                    HitData hitData = entity.rollHitLocation(2, 0);
                    this.addReport(this.damageEntity(entity, hitData, minefield.getDamage()));
                    this.addNewLines();
                    if (bl) {
                        this.resolvePilotingRolls(entity, true, coords, coords2);
                    }
                    if (!minefield.isOneUse()) {
                        this.revealMinefield(minefield);
                        break;
                    }
                    this.removeMinefield(minefield);
                    break;
                }
                case 4: {
                    if (minefield.getTrigger() != 0 && Compute.d6(2) < minefield.getTrigger() + n) {
                        return;
                    }
                    Report report = new Report(2155);
                    report.subject = entity.getId();
                    report.add(entity.getShortName(), true);
                    report.add(minefield.getCoords().getBoardNum(), true);
                    this.addReport(report);
                    this.deliverInfernoMissiles(entity, entity, minefield.getDamage());
                    if (!this.game.getOptions().booleanOption("fire")) break;
                    IHex iHex = this.game.getBoard().getHex(coords2);
                    if (!iHex.containsTerrain(7)) {
                        report = new Report(3005);
                        report.subject = entity.getId();
                        report.add(coords2.getBoardNum(), true);
                        this.addReport(report);
                        iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                    }
                    this.game.getBoard().addInfernoTo(coords2, InfernoTracker.STANDARD_ROUND, 1);
                    this.sendChangedHex(coords2);
                }
            }
        }
    }

    private void checkVibrabombs(Entity entity, Coords coords, boolean bl) {
        this.checkVibrabombs(entity, coords, bl, null, null);
    }

    private void checkVibrabombs(Entity entity, Coords coords, boolean bl, Coords coords2, Coords coords3) {
        if (!(entity instanceof Mech)) {
            return;
        }
        int n = (int)entity.getWeight();
        Enumeration<Minefield> enumeration = this.game.getVibrabombs().elements();
        while (enumeration.hasMoreElements()) {
            Report report;
            Minefield minefield = enumeration.nextElement();
            if (this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(4) && !this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(5) && !this.game.getBoard().getHex(minefield.getCoords()).containsTerrain(20) || n <= minefield.getSetting() - 10) continue;
            int n2 = (n - minefield.getSetting()) / 10;
            int n3 = coords.distance(minefield.getCoords());
            if (n3 <= n2) {
                report = new Report(2156);
                report.subject = entity.getId();
                report.add(entity.getShortName(), true);
                report.add(minefield.getCoords().getBoardNum(), true);
                this.addReport(report);
                this.explodeVibrabomb(minefield);
            }
            if (bl || n3 != 0) continue;
            report = new Report(2160);
            report.subject = entity.getId();
            report.add(entity.getShortName(), true);
            this.addReport(report);
            HitData hitData = entity.rollHitLocation(2, 0);
            this.addReport(this.damageEntity(entity, hitData, minefield.getDamage()));
            this.addNewLines();
            this.resolvePilotingRolls(entity, true, coords2, coords3);
            entity.applyDamage();
        }
    }

    private void removeMinefieldsFrom(Coords coords) {
        Vector<Minefield> vector = this.game.getMinefields(coords);
        while (vector.elements().hasMoreElements()) {
            Minefield minefield = vector.elements().nextElement();
            this.removeMinefield(minefield);
        }
    }

    private void removeMinefield(Minefield minefield) {
        if (this.game.containsVibrabomb(minefield)) {
            this.game.removeVibrabomb(minefield);
        }
        this.game.removeMinefield(minefield);
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            this.removeMinefield(player, minefield);
        }
    }

    private void removeMinefield(Player player, Minefield minefield) {
        if (player.containsMinefield(minefield)) {
            player.removeMinefield(minefield);
            this.send(player.getId(), new Packet(410, minefield));
        }
    }

    private void revealMinefield(Minefield minefield) {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            this.revealMinefield(player, minefield);
        }
    }

    private void revealMinefield(Player player, Minefield minefield) {
        if (!player.containsMinefield(minefield)) {
            player.addMinefield(minefield);
            this.send(player.getId(), new Packet(400, minefield));
        }
    }

    private void explodeVibrabomb(Minefield minefield) {
        Enumeration<Entity> enumeration = this.game.getEntities(minefield.getCoords());
        while (enumeration.hasMoreElements()) {
            Report report;
            Entity entity = enumeration.nextElement();
            if (!entity.isDone() && this.game.getOptions().booleanOption("no_premove_vibra")) {
                report = new Report(2157);
                report.subject = entity.getId();
                report.add(entity.getShortName(), true);
                this.addReport(report);
                continue;
            }
            report = new Report(2160);
            report.subject = entity.getId();
            report.add(entity.getShortName(), true);
            this.addReport(report);
            if (minefield.getType() == 2) {
                HitData hitData = entity.rollHitLocation(2, 0);
                this.addReport(this.damageEntity(entity, hitData, minefield.getDamage()));
                this.addNewLines();
            } else if (minefield.getType() == 6) {
                int n = minefield.getDamage();
                HitData hitData = entity.rollHitLocation(2, 0);
                this.addReport(this.damageEntity(entity, hitData, n));
            }
            this.resolvePilotingRolls(entity, true, entity.getPosition(), entity.getPosition());
            this.game.resetPSRs(entity);
            entity.applyDamage();
            this.addNewLines();
            this.entityUpdate(entity.getId());
        }
        if (!minefield.isOneUse()) {
            this.revealMinefield(minefield);
        } else {
            this.removeMinefield(minefield);
        }
    }

    private void drownSwarmer(Entity entity, Coords coords) {
        Entity entity2;
        int n = entity.getSwarmAttackerId();
        if (-1 != n && !((entity2 = this.game.getEntity(n)) instanceof BattleArmor)) {
            entity2.setSwarmTargetId(-1);
            entity.setSwarmAttackerId(-1);
            entity2.setPosition(coords);
            Report report = new Report(2165);
            report.subject = entity.getId();
            report.indent();
            report.add(entity.getShortName(), true);
            this.addReport(report);
            this.addReport(this.destroyEntity(entity2, "a watery grave", false));
            this.entityUpdate(n);
        }
    }

    void checkForWashedInfernos(Entity entity, Coords coords) {
        IHex iHex = this.game.getBoard().getHex(coords);
        int n = iHex.terrainLevel(4);
        if (!(entity instanceof Mech) || !entity.infernos.isStillBurning()) {
            return;
        }
        if (n > 0 && entity.absHeight() < 0) {
            this.washInferno(entity, coords);
        }
    }

    void washInferno(Entity entity, Coords coords) {
        this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, 1);
        entity.infernos.clear();
        IHex iHex = this.game.getBoard().getHex(coords);
        Report report = new Report(2170);
        report.subject = entity.getId();
        report.addDesc(entity);
        if (!iHex.containsTerrain(7) && this.game.getOptions().booleanOption("fire")) {
            report.messageId = 2175;
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
        }
        this.addReport(report);
        this.sendChangedHex(coords);
    }

    public void addMovementHeat() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (entity.getMovementMode() == 13 || entity.getMovementMode() == 14) {
                return;
            }
            if (entity.moved == 0) {
                entity.heatBuildup += entity.getStandingHeat();
                continue;
            }
            if (entity.moved == 1 || entity.moved == 4) {
                entity.heatBuildup += entity.getWalkHeat();
                continue;
            }
            if (entity.moved == 2 || entity.moved == 5 || entity.moved == -2) {
                entity.heatBuildup += entity.getRunHeat();
                continue;
            }
            if (entity.moved != 3) continue;
            entity.heatBuildup += entity.getJumpHeat(entity.delta_distance);
        }
    }

    public void doSetLocationsExposure(Entity entity, IHex iHex, boolean bl, int n) {
        block7: {
            block5: {
                block6: {
                    if (iHex.terrainLevel(4) <= 0 || bl || n >= 0) break block5;
                    if (!(entity instanceof Mech) || entity.isProne() || iHex.terrainLevel(4) != 1) break block6;
                    for (int i = 0; i < entity.locations(); ++i) {
                        if (this.game.getOptions().booleanOption("vacuum")) {
                            entity.setLocationStatus(i, 1);
                            continue;
                        }
                        entity.setLocationStatus(i, 0);
                    }
                    entity.setLocationStatus(6, 2);
                    entity.setLocationStatus(7, 2);
                    this.addReport(this.breachCheck(entity, 6, iHex));
                    this.addReport(this.breachCheck(entity, 7, iHex));
                    if (!(entity instanceof QuadMech)) break block7;
                    entity.setLocationStatus(4, 2);
                    entity.setLocationStatus(5, 2);
                    this.addReport(this.breachCheck(entity, 4, iHex));
                    this.addReport(this.breachCheck(entity, 5, iHex));
                    break block7;
                }
                for (int i = 0; i < entity.locations(); ++i) {
                    entity.setLocationStatus(i, 2);
                    this.addReport(this.breachCheck(entity, i, iHex));
                }
                break block7;
            }
            for (int i = 0; i < entity.locations(); ++i) {
                if (this.game.getOptions().booleanOption("vacuum")) {
                    entity.setLocationStatus(i, 1);
                    continue;
                }
                entity.setLocationStatus(i, 0);
            }
        }
    }

    private boolean doSkillCheckInPlace(Entity entity, PilotingRollData pilotingRollData) {
        boolean bl;
        if (pilotingRollData.getValue() == Integer.MIN_VALUE) {
            return true;
        }
        if (entity.isProne()) {
            return true;
        }
        Report report = new Report(2180);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(pilotingRollData.getLastPlainDesc(), true);
        this.addReport(report);
        int n = Compute.d6(2);
        report = new Report(2185);
        report.subject = entity.getId();
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n);
        if (n < pilotingRollData.getValue()) {
            report.choose(false);
            this.addReport(report);
            this.doEntityFall(entity, pilotingRollData);
            bl = false;
        } else {
            report.choose(true);
            this.addReport(report);
            bl = true;
        }
        return bl;
    }

    private boolean doDislodgeSwarmerSkillCheck(Entity entity, PilotingRollData pilotingRollData, Coords coords) {
        Report report = new Report(2180);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(pilotingRollData.getLastPlainDesc(), true);
        this.addReport(report);
        int n = Compute.d6(2);
        report = new Report(2190);
        report.subject = entity.getId();
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n);
        if (n < pilotingRollData.getValue()) {
            report.choose(false);
            this.addReport(report);
            return false;
        }
        int n2 = entity.getSwarmAttackerId();
        Entity entity2 = this.game.getEntity(n2);
        if (!entity2.isDone()) {
            entity2.setDone(true);
            this.game.removeTurnFor(entity2);
            this.send(this.createTurnVectorPacket());
        }
        report.choose(true);
        this.addReport(report);
        entity.setPosition(coords);
        this.doEntityFallsInto(entity, coords, coords, pilotingRollData, false);
        return true;
    }

    private int doSkillCheckWhileMoving(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData, boolean bl) {
        boolean bl2;
        Report report = new Report(1210);
        report.subject = entity.getId();
        report.addDesc(entity);
        if (coords.equals(coords2)) {
            bl2 = true;
            report.messageId = 2195;
            report.add(coords.getBoardNum(), true);
        } else {
            bl2 = false;
            report.messageId = 2200;
            report.add(coords.getBoardNum(), true);
            report.add(coords2.getBoardNum(), true);
        }
        report.add(pilotingRollData.getLastPlainDesc(), true);
        this.addReport(report);
        int n = Compute.d6(2);
        report = new Report(2185);
        report.subject = entity.getId();
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n);
        if (n < pilotingRollData.getValue()) {
            if (bl) {
                report.choose(false);
                this.addReport(report);
                this.doEntityFallsInto(entity, bl2 ? coords2 : coords, bl2 ? coords : coords2, pilotingRollData);
            } else {
                report.messageId = 2190;
                report.choose(false);
                this.addReport(report);
                entity.setPosition(bl2 ? coords : coords2);
            }
            return pilotingRollData.getValue() - n;
        }
        report.choose(true);
        this.addReport(report);
        return 0;
    }

    private void doEntityFallsInto(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData) {
        this.doEntityFallsInto(entity, coords, coords2, pilotingRollData, true);
    }

    private void doEntityFallsInto(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData, boolean bl) {
        IHex iHex = this.game.getBoard().getHex(coords);
        IHex iHex2 = this.game.getBoard().getHex(coords2);
        int n = entity.getElevation() + iHex.depth();
        int n2 = Math.max(0, iHex.floor() + n - iHex2.floor());
        int n3 = coords.equals(coords2) ? Compute.d6() - 1 : coords.direction(coords2);
        Entity entity2 = this.game.getAffaTarget(coords2, entity);
        Report report = new Report(2205);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(n2);
        report.add(coords2.getBoardNum(), true);
        report.newlines = 0;
        this.addReport(report);
        if (entity2 == null) {
            this.doEntityFall(entity, coords2, n2, pilotingRollData);
            return;
        }
        if (n2 >= 2 && bl && entity2 != null) {
            report = new Report(2210);
            report.subject = entity.getId();
            report.addDesc(entity2);
            this.addReport(report);
            ToHitData toHitData = new ToHitData(7, "base");
            if (entity2 instanceof Tank) {
                toHitData = new ToHitData(Integer.MIN_VALUE, "Target is a Tank");
            } else {
                toHitData.append(Compute.getTargetMovementModifier(this.game, entity2.getId()));
                toHitData.append(Compute.getTargetTerrainModifier(this.game, entity2));
            }
            if (toHitData.getValue() != 0x7FFFFFFE) {
                int n4 = Compute.d6(2);
                if (toHitData.getValue() == Integer.MIN_VALUE) {
                    report = new Report(2212);
                    report.add(toHitData.getValue());
                    report.indent();
                } else {
                    report = new Report(2215);
                    report.subject = entity.getId();
                    report.add(toHitData.getValue());
                    report.add(n4);
                    report.newlines = 0;
                    report.indent();
                }
                this.addReport(report);
                if (n4 >= toHitData.getValue()) {
                    Object object;
                    int n5;
                    int n6;
                    report = new Report(2220);
                    report.subject = entity2.getId();
                    report.addDesc(entity2);
                    report.add(n6);
                    this.addReport(report);
                    for (n6 = Compute.getAffaDamageFor(entity); n6 > 0; n6 -= n5) {
                        n5 = Math.min(5, n6);
                        object = entity2.rollHitLocation(1, 0);
                        this.addReport(this.damageEntity(entity2, (HitData)object, n5));
                    }
                    this.addNewLines();
                    PilotingRollData pilotingRollData2 = entity.getBasePilotingRoll();
                    pilotingRollData2.append(pilotingRollData);
                    entity.addPilotingModifierForTerrain(pilotingRollData2, coords2);
                    this.doEntityFall(entity, coords2, n2, 3, pilotingRollData2);
                    this.doEntityDisplacementMinefieldCheck(entity, coords, coords2);
                    object = Compute.stackingViolation(this.game, entity.getId(), coords2);
                    if (object != null) {
                        Coords coords3 = Compute.getValidDisplacement(this.game, ((Entity)object).getId(), coords2, n3);
                        if (coords3 != null) {
                            this.doEntityDisplacement(entity2, coords2, coords3, new PilotingRollData(((Entity)object).getId(), 2, "fallen on"));
                            this.entityUpdate(entity2.getId());
                        } else {
                            this.addReport(this.destroyEntity(entity2, "impossible displacement", object instanceof Mech, object instanceof Mech));
                        }
                    }
                    return;
                }
            } else {
                report = new Report(2213);
                report.add(toHitData.getDesc());
                this.addReport(report);
            }
            Coords coords4 = Compute.getValidDisplacement(this.game, entity.getId(), coords2, n3);
            if (coords4 != null) {
                this.doEntityFallsInto(entity, coords, coords4, new PilotingRollData(entity.getId(), Integer.MAX_VALUE, "pushed off a cliff"), false);
                this.entityUpdate(entity.getId());
            } else {
                this.addReport(this.destroyEntity(entity, "impossible displacement", entity instanceof Mech, entity instanceof Mech));
            }
        } else {
            this.doEntityFall(entity, coords2, n2, pilotingRollData);
            Entity entity3 = Compute.stackingViolation(this.game, entity.getId(), coords2);
            if (entity3 != null) {
                Coords coords5 = Compute.getValidDisplacement(this.game, entity.getId(), coords2, n3);
                this.doEntityDisplacement(entity3, coords2, coords5, new PilotingRollData(entity3.getId(), 0, "domino effect"));
                this.entityUpdate(entity3.getId());
            }
        }
    }

    private void doEntityDisplacement(Entity entity, Coords coords, Coords coords2, PilotingRollData pilotingRollData) {
        if (!this.game.getBoard().contains(coords2)) {
            entity.setPosition(coords2);
            if (!entity.isDoomed()) {
                this.game.removeEntity(entity.getId(), 272);
                this.send(this.createRemoveEntityPacket(entity.getId(), 272));
                Report report = new Report(2230);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
            }
            return;
        }
        IHex iHex = this.game.getBoard().getHex(coords);
        IHex iHex2 = this.game.getBoard().getHex(coords2);
        int n = coords.direction(coords2);
        if (iHex == null || iHex2 == null) {
            System.err.println("Can not displace " + entity.getShortName() + " from " + coords + " to " + coords2 + '.');
            return;
        }
        int n2 = entity.elevationOccupied(iHex) - entity.elevationOccupied(iHex2);
        if (n2 > 1) {
            if (pilotingRollData == null) {
                pilotingRollData = entity.getBasePilotingRoll();
            }
            this.doEntityFallsInto(entity, coords, coords2, pilotingRollData);
            return;
        }
        entity.setStuck(false);
        entity.setPosition(coords2);
        entity.setElevation(entity.elevationOccupied(iHex2) - iHex2.surface());
        Entity entity2 = Compute.stackingViolation(this.game, entity.getId(), coords2);
        if (entity2 == null) {
            Report report = new Report(2235);
            report.indent();
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(coords2.getBoardNum(), true);
            this.addReport(report);
        } else {
            Report report = new Report(2240);
            report.indent();
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(coords2.getBoardNum(), true);
            report.addDesc(entity2);
            this.addReport(report);
        }
        this.doEntityDisplacementMinefieldCheck(entity, coords, coords2);
        this.doSetLocationsExposure(entity, iHex2, false, entity.getElevation());
        if (pilotingRollData != null) {
            this.game.addPSR(pilotingRollData);
        }
        this.entityUpdate(entity.getId());
        if (entity2 != null) {
            this.doEntityDisplacement(entity2, coords2, coords2.translated(n), new PilotingRollData(entity2.getId(), 0, "domino effect"));
            if (!this.game.isOutOfGame(entity2)) {
                this.entityUpdate(entity2.getId());
            }
        }
    }

    private void doEntityDisplacementMinefieldCheck(Entity entity, Coords coords, Coords coords2) {
        if (this.game.containsMinefield(coords2)) {
            Enumeration<Minefield> enumeration = this.game.getMinefields(coords2).elements();
            while (enumeration.hasMoreElements()) {
                Minefield minefield = enumeration.nextElement();
                this.enterMinefield(entity, minefield, coords, coords2, false);
            }
        }
        this.checkVibrabombs(entity, coords2, true);
    }

    private void receiveDeployment(Packet packet, int n) {
        int n2;
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        Coords coords = (Coords)packet.getObject(1);
        int n3 = packet.getIntValue(2);
        int n4 = packet.getIntValue(3);
        Vector<Entity> vector = new Vector<Entity>();
        for (n2 = 0; n2 < n4; ++n2) {
            int n5 = packet.getIntValue(5 + n2);
            vector.addElement(this.game.getEntity(n5));
        }
        if (this.game.getPhase() != 4) {
            System.err.println("error: server got deployment packet in wrong phase");
            return;
        }
        n2 = packet.getBooleanValue(4) ? 1 : 0;
        if (!(this.game.getTurn().isValid(n, entity, this.game) && (this.game.getBoard().isLegalDeployment(coords, entity.getOwner()) || n2 != 0 && this.game.getOptions().booleanOption("assault_drop") && entity.canAssaultDrop()))) {
            System.err.println("error: server got invalid deployment packet");
            return;
        }
        this.processDeployment(entity, coords, n3, vector, n2 != 0);
        if (this.doBlind()) {
            this.updateVisibilityIndicator();
        }
        this.endCurrentTurn(entity);
    }

    private void processDeployment(Entity entity, Coords coords, int n, Vector<Entity> vector, boolean bl) {
        Serializable serializable;
        Object object = vector.elements();
        while (object.hasMoreElements()) {
            serializable = object.nextElement();
            if (serializable == null || ((Entity)serializable).getPosition() != null || ((Entity)serializable).getTransportId() != -1) {
                System.err.println("error: " + entity + " can not load entity #" + serializable);
                break;
            }
            this.loadUnit(entity, (Entity)serializable);
        }
        entity.setPosition(coords);
        entity.setFacing(n);
        entity.setSecondaryFacing(n);
        object = this.game.getBoard().getHex(coords);
        if (bl) {
            entity.setElevation(object.ceiling() - object.surface() + 100);
            entity.setAssaultDropInProgress(true);
        } else if (entity instanceof VTOL) {
            entity.setElevation(object.ceiling() - object.surface() + 1);
            while (Compute.stackingViolation(this.game, entity, coords, null) != null && entity.getElevation() <= 50) {
                entity.setElevation(entity.getElevation() + 1);
            }
            if (entity.getElevation() > 50) {
                throw new IllegalStateException("Entity #" + entity.getId() + " appears to be in an infinite loop trying to get a legal elevation.");
            }
        } else if (entity.getMovementMode() == 9) {
            entity.setElevation(0);
        } else if (entity.getMovementMode() == 5 || entity.getMovementMode() == 7 || entity.getMovementMode() == 8) {
            entity.setElevation(0);
        } else if (object.containsTerrain(20) || object.containsTerrain(14)) {
            entity.setElevation(0);
        } else {
            serializable = this.game.getBoard().getBuildingAt(entity.getPosition());
            if (serializable != null && ((Building)serializable).getType() == 5) {
                entity.setElevation(object.terrainLevel(12));
            } else {
                entity.setElevation(object.floor() - object.surface());
            }
        }
        entity.setDone(true);
        entity.setDeployed(true);
        this.entityUpdate(entity.getId());
    }

    private void receiveArtyAutoHitHexes(Packet packet, int n) {
        Vector vector = (Vector)packet.getObject(0);
        Integer n2 = (Integer)vector.firstElement();
        vector.removeElementAt(0);
        if (this.game.getPhase() != 22) {
            System.err.println("error: server got set artyautohithexespacket in wrong phase");
            return;
        }
        this.game.getPlayer(n2).setArtyAutoHitHexes(vector);
        this.endCurrentTurn(null);
    }

    private void receiveDeployMinefields(Packet packet, int n) {
        Vector vector = (Vector)packet.getObject(0);
        if (this.game.getPhase() != 20) {
            System.err.println("error: server got deploy minefields packet in wrong phase");
            return;
        }
        this.processDeployMinefields(vector);
        this.endCurrentTurn(null);
    }

    private void processDeployMinefields(Vector<Minefield> vector) {
        int n = -1;
        for (int i = 0; i < vector.size(); ++i) {
            Minefield minefield = vector.elementAt(i);
            n = minefield.getPlayerId();
            this.game.addMinefield(minefield);
            if (minefield.getType() != 2) continue;
            this.game.addVibrabomb(minefield);
        }
        Player player = this.game.getPlayer(n);
        if (null != player) {
            int n2 = player.getTeam();
            if (n2 != 0) {
                Enumeration enumeration = this.game.getTeams();
                while (enumeration.hasMoreElements()) {
                    Team team = (Team)enumeration.nextElement();
                    if (team.getId() != n2) continue;
                    Enumeration enumeration2 = team.getPlayers();
                    while (enumeration2.hasMoreElements()) {
                        Player player2 = (Player)enumeration2.nextElement();
                        if (player2.getId() != player.getId()) {
                            this.send(player2.getId(), new Packet(390, vector));
                        }
                        player2.addMinefields(vector);
                    }
                    break;
                }
            } else {
                player.addMinefields(vector);
            }
        }
    }

    private void receiveAttack(Packet packet, int n) {
        Entity entity = this.game.getEntity(packet.getIntValue(0));
        Vector vector = (Vector)packet.getObject(1);
        if (this.game.getPhase() != 12 && this.game.getPhase() != 14 && this.game.getPhase() != 7 && this.game.getPhase() != 10) {
            System.err.println("error: server got attack packet in wrong phase");
            return;
        }
        if (!this.game.getTurn().isValid(n, entity, this.game)) {
            System.err.println("error: server got invalid attack packet");
            return;
        }
        this.processAttack(entity, vector);
        if (this.doBlind()) {
            this.updateVisibilityIndicator();
        }
        this.endCurrentTurn(entity);
    }

    private void processAttack(Entity entity, Vector vector) {
        boolean bl = !(this.game.getTurn() instanceof GameTurn.TriggerAPPodTurn);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Entity entity2;
            AbstractEntityAction abstractEntityAction;
            Object object;
            EntityAction entityAction = (EntityAction)enumeration.nextElement();
            if (entityAction.getEntityId() != entity.getId()) {
                System.err.println("error: attack packet has wrong attacker");
                continue;
            }
            if (entityAction instanceof WeaponAttackAction && ("SwarmMek".equals(object = entity.getEquipment(((WeaponAttackAction)(abstractEntityAction = (WeaponAttackAction)entityAction)).getWeaponId()).getType().getInternalName()) || "LegAttack".equals(object))) {
                entity2 = this.game.getEntity(((AbstractAttackAction)abstractEntityAction).getTargetId());
                for (Mounted mounted : entity2.getMisc()) {
                    if (!mounted.getType().hasFlag(0x2000000L) || !mounted.canFire()) continue;
                    this.game.insertNextTurn(new GameTurn.TriggerAPPodTurn(entity2.getOwnerId(), entity2.getId()));
                    this.send(this.createTurnVectorPacket());
                    break;
                }
            }
            if (entityAction instanceof BreakGrappleAttackAction && ((Mech)(object = (Mech)this.game.getEntity((abstractEntityAction = (BreakGrappleAttackAction)entityAction).getEntityId()))).isGrappleAttacker()) {
                entity2 = (Mech)this.game.getEntity(((AbstractAttackAction)abstractEntityAction).getTargetId());
                if (entity2.isDone()) {
                    this.game.removeActionsFor(entity2.getId());
                } else {
                    this.game.removeTurnFor(entity2);
                    entity2.setDone(true);
                }
                this.game.insertNextTurn(new GameTurn.CounterGrappleTurn(entity2.getOwnerId(), entity2.getId()));
                this.send(this.createTurnVectorPacket());
            }
            if (entityAction instanceof ClubAttackAction) {
                abstractEntityAction = (ClubAttackAction)entityAction;
                object = ((ClubAttackAction)abstractEntityAction).getClub();
                ((Mounted)object).restore();
            }
            if (entityAction instanceof PushAttackAction) {
                abstractEntityAction = (PushAttackAction)entityAction;
                entity.setDisplacementAttack((DisplacementAttackAction)abstractEntityAction);
                this.game.addCharge((AttackAction)((Object)abstractEntityAction));
            } else if (entityAction instanceof DodgeAction) {
                entity.dodging = true;
            } else if (entityAction instanceof SpotAction) {
                entity.setSpotting(true);
                entity.setSpotTargetId(((SpotAction)entityAction).getTargetId());
            } else {
                this.game.addAction(entityAction);
            }
            if (!(entityAction instanceof TriggerAPPodAction)) continue;
            abstractEntityAction = (TriggerAPPodAction)entityAction;
            object = entity.getEquipment(((TriggerAPPodAction)abstractEntityAction).getPodId());
            ((Mounted)object).setUsedThisRound(true);
        }
        if (bl) {
            entity.setDone(true);
        }
        this.entityUpdate(entity.getId());
        this.send(this.createAttackPacket(vector, 0));
    }

    private void assignAMS(Vector<WeaponResult> vector) {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        Hashtable<WeaponResult, Vector<WeaponResult>> hashtable = new Hashtable<WeaponResult, Vector<WeaponResult>>();
        for (WeaponResult serializable3 : vector) {
            serializable2 = serializable3.waa;
            object = this.game.getEntity(((AbstractEntityAction)serializable2).getEntityId()).getEquipment(((WeaponAttackAction)serializable2).getWeaponId());
            if (0 != ((AbstractAttackAction)serializable2).getTargetType() || serializable3.roll < serializable3.toHit.getValue() || ((WeaponType)((Mounted)object).getType()).getDamage() != -2) continue;
            serializable = this.game.getEntity(((AbstractAttackAction)serializable2).getTargetId());
            Vector<WeaponResult> vector2 = (Vector<WeaponResult>)hashtable.get(serializable);
            if (vector2 == null) {
                vector2 = new Vector<WeaponResult>();
                hashtable.put((WeaponResult)serializable, vector2);
            }
            vector2.addElement(serializable3);
        }
        for (Entity entity : hashtable.keySet()) {
            serializable2 = (Vector)hashtable.get(entity);
            entity.assignAMS((Vector<WeaponResult>)serializable2);
            object = ((Vector)serializable2).iterator();
            while (object.hasNext()) {
                serializable = (WeaponResult)object.next();
                serializable = this.resolveAmsFor(serializable.waa, (WeaponResult)serializable);
            }
        }
    }

    private void resolveAllButWeaponAttacks() {
        Serializable serializable;
        RoundUpdated roundUpdated;
        Object object;
        Object object2;
        Object object3;
        if (this.game.getPhase() == 12) {
            this.addReport(new Report(3000, 0));
            object3 = this.game.getLayMinefieldActions();
            while (object3.hasMoreElements()) {
                object2 = (LayMinefieldAction)object3.nextElement();
                object = this.game.getEntity(((AbstractEntityAction)object2).getEntityId());
                roundUpdated = ((Entity)object).getEquipment(((LayMinefieldAction)object2).getMineId());
                if (((Mounted)roundUpdated).isMissing()) continue;
                switch (((Mounted)roundUpdated).getMineType()) {
                    case 0: {
                        this.deliverThunderMinefield(((Entity)object).getPosition(), ((Entity)object).getOwnerId(), 10);
                        ((Mounted)roundUpdated).setMissing(true);
                        serializable = new Report(3500);
                        ((Report)serializable).subject = ((Entity)object).getId();
                        ((Report)serializable).addDesc((Entity)object);
                        ((Report)serializable).add(((Entity)object).getPosition().getBoardNum());
                        this.addReport((Report)serializable);
                        break;
                    }
                    case 1: {
                        this.deliverThunderVibraMinefield(((Entity)object).getPosition(), ((Entity)object).getOwnerId(), 10, ((Mounted)roundUpdated).getVibraSetting());
                        ((Mounted)roundUpdated).setMissing(true);
                        serializable = new Report(3505);
                        ((Report)serializable).subject = ((Entity)object).getId();
                        ((Report)serializable).addDesc((Entity)object);
                        ((Report)serializable).add(((Entity)object).getPosition().getBoardNum());
                        this.addReport((Report)serializable);
                    }
                }
            }
            this.game.resetLayMinefieldActions();
        }
        serializable = new Vector<Entity>();
        object3 = new Vector();
        object2 = this.game.getActions();
        while (object2.hasMoreElements()) {
            AbstractEntityAction abstractEntityAction;
            object = object2.nextElement();
            roundUpdated = this.game.getEntity(object.getEntityId());
            if (object instanceof TorsoTwistAction) {
                abstractEntityAction = (TorsoTwistAction)object;
                if (!((Entity)roundUpdated).canChangeSecondaryFacing()) continue;
                ((Entity)roundUpdated).setSecondaryFacing(((TorsoTwistAction)abstractEntityAction).getFacing());
                continue;
            }
            if (object instanceof FlipArmsAction) {
                abstractEntityAction = (FlipArmsAction)object;
                ((Entity)roundUpdated).setArmsFlipped(((FlipArmsAction)abstractEntityAction).getIsFlipped());
                continue;
            }
            if (object instanceof FindClubAction) {
                this.resolveFindClub((Entity)roundUpdated);
                continue;
            }
            if (object instanceof UnjamAction) {
                this.resolveUnjam((Entity)roundUpdated);
                continue;
            }
            if (object instanceof ClearMinefieldAction) {
                ((Vector)serializable).addElement((Entity)roundUpdated);
                continue;
            }
            if (object instanceof TriggerAPPodAction) {
                abstractEntityAction = (TriggerAPPodAction)object;
                if (!((Vector)object3).contains(abstractEntityAction)) {
                    this.triggerAPPod((Entity)roundUpdated, ((TriggerAPPodAction)abstractEntityAction).getPodId());
                    ((Vector)object3).addElement(abstractEntityAction);
                    continue;
                }
                System.err.print("AP Pod #");
                System.err.print(((TriggerAPPodAction)abstractEntityAction).getPodId());
                System.err.print(" on ");
                System.err.print(((Entity)roundUpdated).getDisplayName());
                System.err.println(" was already triggered this round!!");
                continue;
            }
            if (!(object instanceof SearchlightAttackAction)) continue;
            abstractEntityAction = (SearchlightAttackAction)object;
            this.addReport(((SearchlightAttackAction)abstractEntityAction).resolveAction(this.game));
        }
        this.resolveClearMinefieldAttempts((Vector<Entity>)serializable);
    }

    private void resolveClearMinefieldAttempts(Vector<Entity> vector) {
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            int n;
            Serializable serializable;
            int n2;
            Vector<Entity> vector2 = new Vector<Entity>();
            Entity entity = vector.elementAt(i);
            Coords coords = entity.getPosition();
            vector2.addElement(entity);
            for (n2 = i + 1; n2 < vector.size(); ++n2) {
                Entity entity2 = vector.elementAt(n2);
                if (!entity2.getPosition().equals(coords)) continue;
                vector2.addElement(entity2);
                vector.removeElement(entity2);
            }
            n2 = 0;
            boolean bl = false;
            for (int j = 0; j < vector2.size(); ++j) {
                serializable = (Entity)vector2.elementAt(j);
                n = Compute.d6(2);
                int n3 = 10;
                int n4 = 5;
                for (Mounted mounted : ((Entity)serializable).getMisc()) {
                    if (!mounted.getType().hasFlag(0x100000L) || !mounted.getType().hasSubType(8)) continue;
                    int n5 = mounted.getType().getToHitModifier();
                    n3 = Minefield.CLEAR_NUMBER_SWEEPER[n5];
                    n4 = Minefield.CLEAR_NUMBER_SWEEPER_ACCIDENT[n5];
                    break;
                }
                object = new Report(2245);
                ((Report)object).subject = ((Entity)serializable).getId();
                ((Report)object).add(((Entity)serializable).getShortName(), true);
                ((Report)object).add(coords.getBoardNum(), true);
                ((Report)object).add(n3);
                ((Report)object).add(n);
                ((Report)object).newlines = 0;
                this.addReport((Report)object);
                if (n >= n3) {
                    object = new Report(2250);
                    ((Report)object).subject = ((Entity)serializable).getId();
                    this.addReport((Report)object);
                    bl = true;
                    continue;
                }
                if (n <= n4) {
                    object = new Report(2255);
                    ((Report)object).subject = ((Entity)serializable).getId();
                    this.addReport((Report)object);
                    n2 = 1;
                    continue;
                }
                object = new Report(2260);
                ((Report)object).subject = ((Entity)serializable).getId();
                this.addReport((Report)object);
            }
            if (n2 != 0) {
                Enumeration<Minefield> enumeration = this.game.getMinefields(coords).elements();
                block8: while (enumeration.hasMoreElements()) {
                    serializable = enumeration.nextElement();
                    switch (((Minefield)serializable).getType()) {
                        case 0: 
                        case 3: {
                            for (n = 0; n < vector2.size(); ++n) {
                                Entity entity3 = (Entity)vector2.elementAt(n);
                                Report report = new Report(2265);
                                report.subject = entity3.getId();
                                report.add(entity3.getShortName(), true);
                                this.addReport(report);
                                object = entity3.rollHitLocation(2, 0);
                                this.addReport(this.damageEntity(entity3, (HitData)object, ((Minefield)serializable).getDamage()));
                                this.addNewLines();
                            }
                            continue block8;
                        }
                        case 2: {
                            this.explodeVibrabomb((Minefield)serializable);
                        }
                    }
                }
            }
            if (!bl) continue;
            this.removeMinefieldsFrom(coords);
        }
    }

    private void resolveOnlyWeaponAttacks() {
        Serializable serializable;
        Object object;
        Vector<WeaponResult> vector = new Vector<WeaponResult>(this.game.actionsSize());
        Enumeration<EntityAction> enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!(object instanceof WeaponAttackAction)) continue;
            serializable = (WeaponAttackAction)object;
            vector.addElement(this.preTreatWeaponAttack((WeaponAttackAction)serializable));
        }
        this.assignAMS(vector);
        int n = -1;
        object = vector.elements();
        while (object.hasMoreElements()) {
            serializable = (WeaponResult)object.nextElement();
            this.resolveWeaponAttack((WeaponResult)serializable, n);
            n = ((WeaponResult)serializable).waa.getEntityId();
        }
        this.game.resetActions();
    }

    private void triggerAPPod(Entity entity, int n) {
        Mounted mounted = entity.getEquipment(n);
        if (null == mounted) {
            System.err.print("Expecting to find an AP Pod at ");
            System.err.print(n);
            System.err.print(" on the unit, ");
            System.err.print(entity.getDisplayName());
            System.err.println(" but found NO equipment at all!!!");
            return;
        }
        EquipmentType equipmentType = mounted.getType();
        if (!(equipmentType instanceof MiscType) || !equipmentType.hasFlag(0x2000000L)) {
            System.err.print("Expecting to find an AP Pod at ");
            System.err.print(n);
            System.err.print(" on the unit, ");
            System.err.print(entity.getDisplayName());
            System.err.print(" but found ");
            System.err.print(equipmentType.getName());
            System.err.println(" instead!!!");
            return;
        }
        boolean bl = mounted.isUsedThisRound();
        mounted.setUsedThisRound(false);
        boolean bl2 = mounted.canFire();
        mounted.setUsedThisRound(bl);
        if (!bl2) {
            System.err.print("Can not trigger the AP Pod at ");
            System.err.print(n);
            System.err.print(" on the unit, ");
            System.err.print(entity.getDisplayName());
            System.err.println("!!!");
            return;
        }
        mounted.setFired(true);
        Report report = new Report(3010);
        report.newlines = 0;
        report.subject = entity.getId();
        report.addDesc(entity);
        this.addReport(report);
        Enumeration<Entity> enumeration = this.game.getEntities(entity.getPosition());
        while (enumeration.hasMoreElements()) {
            Entity entity2 = enumeration.nextElement();
            if (entity2 instanceof Infantry && !(entity2 instanceof BattleArmor)) {
                int n2 = Math.min(1, Compute.d6() - 1);
                this.addReport(this.damageEntity(entity2, new HitData(0), n2));
                entity2.applyDamage();
                continue;
            }
            if (entity.equals(entity2)) continue;
            report = new Report(3020);
            report.indent(2);
            report.subject = entity2.getId();
            report.addDesc(entity2);
            this.addReport(report);
        }
    }

    private void resolveUnjam(Entity entity) {
        int n = entity.getCrew().getGunnery() + 3;
        Report report = new Report(3025);
        report.subject = entity.getId();
        report.addDesc(entity);
        this.addReport(report);
        for (Mounted mounted : entity.getWeaponList()) {
            WeaponType weaponType;
            if (!mounted.isJammed() || (weaponType = (WeaponType)mounted.getType()).getAmmoType() != 23) continue;
            int n2 = Compute.d6(2);
            report = new Report(3030);
            report.indent();
            report.subject = entity.getId();
            report.add(weaponType.getName());
            report.add(n);
            report.add(n2);
            if (n2 >= n) {
                report.choose(true);
                mounted.setJammed(false);
            } else {
                report.choose(false);
            }
            this.addReport(report);
        }
    }

    private void resolveFindClub(Entity entity) {
        Report report;
        EquipmentType equipmentType = null;
        entity.setFindingClub(true);
        Coords coords = entity.getPosition();
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex.terrainLevel(18) > 0) {
            equipmentType = EquipmentType.get("Limb Club");
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(18, iHex.terrainLevel(18) - 1));
            this.sendChangedHex(entity.getPosition());
            report = new Report(3035);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        } else if (iHex.terrainLevel(19) > 0) {
            equipmentType = EquipmentType.get("Limb Club");
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(19, iHex.terrainLevel(19) - 1));
            this.sendChangedHex(entity.getPosition());
            report = new Report(3040);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        } else if (1 < iHex.terrainLevel(3)) {
            boolean bl = false;
            int n = Compute.d6(2);
            switch (iHex.terrainLevel(3)) {
                case 2: {
                    if (n < 7) break;
                    bl = true;
                    break;
                }
                case 3: {
                    if (n < 6) break;
                    bl = true;
                    break;
                }
                case 4: {
                    if (n < 5) break;
                    bl = true;
                    break;
                }
                case 5: {
                    if (n < 13) break;
                    bl = true;
                }
            }
            if (bl) {
                equipmentType = EquipmentType.get("Girder Club");
                report = new Report(3045);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
            } else {
                equipmentType = null;
                report = new Report(3050);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
            }
        } else if (iHex.containsTerrain(1) || iHex.containsTerrain(23)) {
            equipmentType = EquipmentType.get("Tree Club");
            report = new Report(3055);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        try {
            if (equipmentType != null) {
                entity.addEquipment(equipmentType, -1);
            }
        }
        catch (LocationFullException locationFullException) {
            report = new Report(3060);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
    }

    private WeaponResult preTreatWeaponAttack(WeaponAttackAction weaponAttackAction) {
        boolean bl;
        Entity entity = this.game.getEntity(weaponAttackAction.getEntityId());
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        WeaponType weaponType = (WeaponType)mounted.getType();
        boolean bl2 = weaponType.getAmmoType() != -1 && weaponType.getAmmoType() != -2 && weaponType.getAmmoType() != -3 && !weaponType.hasFlag(2048L);
        Mounted mounted2 = null;
        if (bl2) {
            if (weaponAttackAction.getAmmoId() > -1) {
                mounted2 = entity.getEquipment(weaponAttackAction.getAmmoId());
                mounted.setLinked(mounted2);
            } else {
                mounted2 = mounted.getLinked();
            }
        }
        WeaponResult weaponResult = new WeaponResult();
        weaponResult.waa = weaponAttackAction;
        if (!weaponAttackAction.isNemesisConfused() && !weaponAttackAction.isSwarmingMissiles()) {
            if (mounted.isUsedThisRound()) {
                weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "Weapon has already been used this round");
                return weaponResult;
            }
            if (mounted.isDestroyed()) {
                weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "Weapon was destroyed in a previous round");
                return weaponResult;
            }
            if (mounted.isJammed()) {
                weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "Weapon is jammed");
                return weaponResult;
            }
            if (bl2 && (mounted2 == null || mounted2.getShotsLeft() == 0 || mounted2.isDumping())) {
                entity.loadWeaponWithSameAmmo(mounted);
                mounted2 = mounted.getLinked();
            }
            weaponAttackAction.setAmmoId(entity.getEquipmentNum(mounted2));
        }
        weaponResult.toHit = weaponAttackAction.toHit(this.game);
        if (weaponAttackAction.isNemesisConfused()) {
            weaponResult.toHit.addModifier(1, "iNarc Nemesis pod");
        }
        weaponResult.roll = Compute.d6(2);
        boolean bl3 = bl = (weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 47 || weaponType.getAmmoType() == 32) && weaponResult.roll < weaponResult.toHit.getValue();
        if (!(weaponResult.toHit.getValue() == Integer.MAX_VALUE || bl && !Compute.isAffectedByAngelECM(entity, entity.getPosition(), weaponAttackAction.getTarget(this.game).getPosition()) || weaponAttackAction.isNemesisConfused() || weaponAttackAction.isSwarmingMissiles())) {
            weaponResult = this.addHeatUseAmmoFor(weaponAttackAction, weaponResult);
        }
        mounted.setUsedThisRound(true);
        return weaponResult;
    }

    private WeaponResult addHeatUseAmmoFor(WeaponAttackAction weaponAttackAction, WeaponResult weaponResult) {
        int n;
        if (weaponAttackAction.isSwarmingMissiles()) {
            return weaponResult;
        }
        Entity entity = this.game.getEntity(weaponAttackAction.getEntityId());
        Mounted mounted = entity.getEquipment(weaponAttackAction.getWeaponId());
        WeaponType weaponType = (WeaponType)mounted.getType();
        boolean bl = weaponType.getAmmoType() != -1 && weaponType.getAmmoType() != -2 && weaponType.getAmmoType() != -3 && !weaponType.hasFlag(2048L);
        Mounted mounted2 = mounted.getLinked();
        int n2 = mounted.howManyShots();
        if (bl && n2 > 1 && (n = entity.getTotalAmmoOfType(mounted2.getType())) < n2) {
            weaponResult.revertsToSingleShot = true;
            n2 = 1;
        }
        if (bl) {
            for (n = 0; n < n2; ++n) {
                if (mounted2.getShotsLeft() <= 0) {
                    entity.loadWeaponWithSameAmmo(mounted);
                    mounted2 = mounted.getLinked();
                }
                mounted2.setShotsLeft(mounted2.getShotsLeft() - 1);
            }
        }
        entity.heatBuildup += weaponType.getHeat() * n2;
        return weaponResult;
    }

    private WeaponResult resolveAmsFor(WeaponAttackAction weaponAttackAction, WeaponResult weaponResult) {
        Entity entity = this.game.getEntity(weaponAttackAction.getTargetId());
        ArrayList<Mounted> arrayList = weaponAttackAction.getCounterEquipment();
        if (null != arrayList) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Mounted mounted = arrayList.get(i);
                if (!mounted.getType().hasFlag(0x1000000L) || weaponResult.amsEngaged) continue;
                Mounted mounted2 = mounted.getLinked();
                Entity entity2 = weaponAttackAction.getEntity(this.game);
                if (!(mounted.getType() instanceof WeaponType) || !mounted.getType().hasFlag(0x1000000L) || !mounted.isReady() || mounted.isMissing() || entity2.hasShield() && entity2.hasActiveShield(mounted.getLocation(), false) || !Compute.isInArc(this.game, entity.getId(), entity.getEquipmentNum(mounted), entity2)) continue;
                entity.heatBuildup = mounted.getType().hasFlag(0x800000L) ? (entity.heatBuildup += Compute.d6(((WeaponType)mounted.getType()).getHeat())) : (entity.heatBuildup += ((WeaponType)mounted.getType()).getHeat());
                if (mounted2 != null) {
                    mounted2.setShotsLeft(Math.max(0, mounted2.getShotsLeft() - 1));
                }
                mounted.setUsedThisRound(true);
                weaponResult.amsEngaged = true;
            }
        }
        return weaponResult;
    }

    private boolean tryIgniteHex(Coords coords, int n, boolean bl, int n2, boolean bl2) {
        IHex iHex = this.game.getBoard().getHex(coords);
        boolean bl3 = false;
        if (iHex == null) {
            return false;
        }
        if (!this.game.getOptions().booleanOption("fire")) {
            return false;
        }
        if (bl) {
            this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, 1);
            n2 = 0;
            bl3 = true;
        }
        if (iHex.containsTerrain(7)) {
            if (bl2) {
                Report report = new Report(3065);
                report.indent(3);
                report.subject = n;
                this.addReport(report);
            }
            return true;
        }
        if (this.ignite(iHex, n2, bl3, n)) {
            Report report = new Report(3070);
            report.indent(3);
            report.subject = n;
            this.addReport(report);
            this.sendChangedHex(coords);
            return true;
        }
        return false;
    }

    private boolean tryIgniteHex(Coords coords, int n, boolean bl, int n2) {
        return this.tryIgniteHex(coords, n, bl, n2, false);
    }

    public void tryClearHex(Coords coords, int n, int n2) {
        Report report;
        int n3;
        int n4;
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex == null) {
            return;
        }
        ITerrain iTerrain = iHex.getTerrain(1);
        ITerrain iTerrain2 = iHex.getTerrain(23);
        ITerrain iTerrain3 = iHex.getTerrain(20);
        if (iTerrain != null) {
            n4 = iTerrain.getTerrainFactor() - n;
            n3 = iTerrain.getLevel();
            if (n4 <= 0) {
                iHex.removeTerrain(1);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(2, 1));
                report = new Report(3090);
                report.subject = n2;
                this.addReport(report);
            } else if (n4 <= 50 && n3 > 1) {
                iHex.removeTerrain(1);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(1, 1));
                report = new Report(3085);
                report.subject = n2;
                this.addReport(report);
            } else if (n4 <= 90 && n3 > 2) {
                iHex.removeTerrain(1);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(1, 2));
                report = new Report(3082);
                report.subject = n2;
                this.addReport(report);
            } else {
                iTerrain.setTerrainFactor(n4);
            }
        }
        if (iTerrain2 != null) {
            n4 = iTerrain2.getTerrainFactor() - n;
            n3 = iTerrain2.getLevel();
            if (n4 < 0) {
                iHex.removeTerrain(23);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(2, 1));
                report = new Report(3091);
                report.subject = n2;
                this.addReport(report);
            } else if (n4 <= 50 && n3 > 1) {
                iHex.removeTerrain(23);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(23, 1));
                report = new Report(3086);
                report.subject = n2;
                this.addReport(report);
            } else if (n4 <= 90 && n3 > 2) {
                iHex.removeTerrain(23);
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(23, 2));
                report = new Report(3083);
                report.subject = n2;
                this.addReport(report);
            } else {
                iTerrain2.setTerrainFactor(n4);
            }
        }
        if (iTerrain3 != null) {
            n4 = iTerrain3.getTerrainFactor() - n;
            if (n4 < 0) {
                iHex.removeTerrain(20);
                report = new Report(3092);
                report.subject = n2;
                this.addReport(report);
            } else {
                iTerrain3.setTerrainFactor(n4);
            }
        }
        this.sendChangedHex(coords);
    }

    private void resolveWeaponAttack(WeaponResult weaponResult, int n) {
        this.resolveWeaponAttack(weaponResult, n, false);
    }

    private boolean resolveWeaponAttack(WeaponResult weaponResult, int n, boolean bl) {
        return this.resolveWeaponAttack(weaponResult, n, bl, 0);
    }

    private boolean resolveWeaponAttack(WeaponResult weaponResult, int n, boolean bl, int n2) {
        int n3;
        int n4;
        boolean bl2;
        boolean bl3;
        Serializable serializable;
        Object object2;
        Serializable serializable2;
        Object object3;
        Serializable serializable3;
        Report report;
        Targetable targetable;
        Entity entity = this.game.getEntity(weaponResult.waa.getEntityId());
        if (entity == null) {
            entity = this.game.getOutOfGameEntity(weaponResult.waa.getEntityId());
        }
        boolean bl4 = (targetable = this.game.getTarget(weaponResult.waa.getTargetType(), weaponResult.waa.getTargetId())) instanceof Mech ? Compute.isThroughFrontHex(this.game, weaponResult.waa.getEntityId(), (Entity)targetable) : true;
        int n5 = -1;
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
            n5 = entity2.getId();
        } else {
            n5 = entity.getId();
        }
        Mounted mounted = entity.getEquipment(weaponResult.waa.getWeaponId());
        WeaponType weaponType = (WeaponType)mounted.getType();
        boolean bl5 = weaponType.hasFlag(2048L);
        boolean bl6 = weaponType.getAmmoType() != -1 && weaponType.getAmmoType() != -2 && weaponType.getAmmoType() != -3 && !bl5;
        Mounted mounted2 = bl6 ? entity.getEquipment(weaponResult.waa.getAmmoId()) : null;
        AmmoType ammoType = mounted2 == null ? null : (AmmoType)mounted2.getType();
        Infantry infantry = null;
        boolean bl7 = weaponType.hasFlag(4096L);
        ToHitData toHitData = weaponResult.toHit;
        boolean bl8 = bl6 && (ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 50) && ammoType.getMunitionType() == 0x1000000000L;
        boolean bl9 = bl6 && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 50) && ammoType.getMunitionType() == 0x8000000000L;
        boolean bl10 = bl6 && (ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 50) && ammoType.getMunitionType() == 0x4000000000L;
        boolean bl11 = bl6 && (ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 50 || ammoType.getAmmoType() == 25) && ammoType.getMunitionType() == 0x400000L;
        boolean bl12 = bl6 && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 50 || ammoType.getAmmoType() == 9) && ammoType.getMunitionType() == 128L;
        boolean bl13 = bl6 && (ammoType.getAmmoType() == 9 || ammoType.getAmmoType() == 50) && ammoType.getMunitionType() == 0x800000L;
        boolean bl14 = bl6 && (ammoType.getAmmoType() == 1 || ammoType.getAmmoType() == 35) && ammoType.getMunitionType() == 4L;
        boolean bl15 = targetable.getTargetType() == 7;
        boolean bl16 = targetable.getTargetType() == 0 && weaponType.hasFlag(65536L) && bl6 && ammoType.getMunitionType() == 0L && entity2.getMovementMode() == 6 && entity2.getElevation() > 0;
        boolean bl17 = bl6 && (ammoType.getAmmoType() == 1 || ammoType.getAmmoType() == 35) && ammoType.getMunitionType() == 8L;
        boolean bl18 = bl6 && (ammoType.getAmmoType() == 1 || ammoType.getAmmoType() == 35) && ammoType.getMunitionType() == 0x400000000L;
        boolean bl19 = bl6 && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 50 || ammoType.getAmmoType() == 9) && ammoType.getMunitionType() == 512L;
        boolean bl20 = bl6 && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 50) && ammoType.getMunitionType() == 32768L;
        boolean bl21 = bl6 && (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 50) && ammoType.getMunitionType() == 65536L;
        boolean bl22 = Compute.isAffectedByAngelECM(entity, entity.getPosition(), targetable.getPosition());
        boolean bl23 = false;
        int n6 = 0;
        int n7 = 1;
        int n8 = 0;
        if (!bl11) {
            bl11 = bl5 && weaponType.hasFlag(1024L);
        }
        boolean bl24 = Compute.isInBuilding(this.game, entity2);
        if ((bl15 || bl16) && this.game.getPhase() == 12) {
            weaponResult.artyAttackerCoords = entity.getPosition();
        }
        if ((bl20 || bl21) && entity2 != null) {
            entity2.addTargetedBySwarm(entity.getId(), weaponResult.waa.getWeaponId());
        }
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        boolean bl25 = false;
        Mounted mounted3 = mounted.getLinkedBy();
        if (weaponType.getAmmoType() == 29 || mounted3 != null && mounted3.getType() instanceof MiscType && !mounted3.isDestroyed() && !mounted3.isMissing() && !mounted3.isBreached() && mounted3.getType().hasFlag(512L)) {
            if (!(mounted.getType().hasModes() && mounted.curMode().equals("Indirect") || (ammoType.getAmmoType() != 29 || ammoType.getMunitionType() != 0L && ammoType.getMunitionType() != 32L && ammoType.getMunitionType() != 64L) && (ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 9 && ammoType.getAmmoType() != 50 || ammoType.getMunitionType() != 2048L))) {
                bl25 = true;
            }
        } else if ((weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 9 || weaponType.getAmmoType() == 50) && bl6 && ammoType.getMunitionType() == 1024L) {
            bl25 = true;
        }
        if (entity2 != null) {
            entity.setLastTarget(entity2.getId());
        }
        if (n != entity.getId()) {
            report = new Report(3100);
            report.subject = n5;
            report.addDesc(entity);
            this.addReport(report);
        }
        if ("StopSwarm".equals(weaponType.getInternalName())) {
            if (toHitData.getValue() == Integer.MAX_VALUE) {
                report = new Report(3105);
                report.subject = n5;
                report.add(toHitData.getDesc());
                this.addReport(report);
                return true;
            }
            if (entity.getSwarmTargetId() == -1) {
                return true;
            }
            report = new Report(3110);
            report.subject = n5;
            this.addReport(report);
            if (entity.getSwarmTargetId() != targetable.getTargetId()) {
                Entity entity3 = this.game.getEntity(entity.getSwarmTargetId());
                if (entity3 != null) {
                    entity3.setSwarmAttackerId(-1);
                }
            } else {
                entity2.setSwarmAttackerId(-1);
            }
            entity.setSwarmTargetId(-1);
            return true;
        }
        report = new Report(3115);
        report.indent();
        report.newlines = 0;
        report.subject = n5;
        report.add(weaponType.getName());
        if (entity2 != null) {
            report.addDesc(entity2);
        } else {
            report.messageId = 3120;
            report.add(targetable.getDisplayName(), true);
        }
        this.addReport(report);
        boolean bl26 = false;
        if (bl25 && !bl) {
            Enumeration<Entity> enumeration = this.game.getNemesisTargets(entity, targetable.getPosition());
            while (enumeration.hasMoreElements()) {
                serializable3 = enumeration.nextElement();
                report = new Report(3125);
                report.subject = n5;
                this.addReport(report);
                mounted.setUsedThisRound(false);
                WeaponAttackAction weaponAttackAction = new WeaponAttackAction(entity.getId(), ((Entity)serializable3).getTargetId(), weaponResult.waa.getWeaponId());
                weaponAttackAction.setNemesisConfused(true);
                weaponAttackAction.setAmmoId(weaponResult.waa.getAmmoId());
                WeaponResult weaponResult2 = this.preTreatWeaponAttack(weaponAttackAction);
                if (this.resolveWeaponAttack(weaponResult2, entity.getId(), true)) {
                    return true;
                }
                bl26 = true;
            }
        }
        if (bl26) {
            report = new Report(3130);
            report.subject = n5;
            report.newlines = 0;
            this.addReport(report);
        }
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(3135);
            report.subject = n5;
            report.add(toHitData.getDesc());
            this.addReport(report);
            return false;
        }
        if (toHitData.getValue() == 0x7FFFFFFE) {
            report = new Report(3140);
            report.newlines = 0;
            report.subject = n5;
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(3145);
            report.newlines = 0;
            report.subject = n5;
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else {
            report = new Report(3150);
            report.newlines = 0;
            report.subject = n5;
            report.add(toHitData.getValue());
            this.addReport(report);
        }
        if (weaponType.getAmmoType() == 22 && entity.mpUsed > 0) {
            int n9;
            switch (entity.getWeightClass()) {
                case 0: {
                    n9 = 2;
                    break;
                }
                case 1: {
                    n9 = 1;
                    break;
                }
                case 2: {
                    n9 = 0;
                    break;
                }
                default: {
                    n9 = -1;
                }
            }
            serializable3 = new PilotingRollData(entity.getId(), n9, "fired HeavyGauss unbraced");
            ((PilotingRollData)serializable3).setCumulative(false);
            this.game.addPSR((PilotingRollData)serializable3);
        }
        report = new Report(3155);
        report.newlines = 0;
        report.subject = n5;
        report.add(weaponResult.roll);
        this.addReport(report);
        int n10 = mounted.howManyShots();
        if (n10 > 1 || weaponType.hasFlag(0x400000L) && weaponType.getAmmoType() != -1) {
            int n11 = 0;
            if ((weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34) && mounted.curMode().equals("Ultra") || weaponType.hasFlag(0x400000L)) {
                n11 = 2;
                if (mounted.getType().hasModes() && mounted.curMode().equals("Ultra") && weaponType.hasFlag(0x400000L)) {
                    n11 = 4;
                }
            } else if (weaponType.getAmmoType() == 1 || weaponType.getAmmoType() == 35) {
                if (n10 == 2) {
                    n11 = 4;
                }
            } else if (weaponType.getAmmoType() == 23) {
                n11 = n10 / 2 + 1;
            }
            if (n11 > 0 && weaponResult.roll <= n11) {
                if (weaponType.getAmmoType() == 20 || weaponType.getAmmoType() == 34) {
                    report = new Report(3160);
                    report.subject = n5;
                    report.newlines = 0;
                    this.addReport(report);
                    mounted.setJammed(true);
                    mounted.setHit(true);
                } else if (weaponType.getAmmoType() == 1 || weaponType.getAmmoType() == 35) {
                    if (weaponResult.roll > 2) {
                        report = new Report(3161);
                        report.subject = n5;
                        report.newlines = 0;
                        this.addReport(report);
                        mounted.setJammed(true);
                        mounted.setHit(true);
                    } else {
                        report = new Report(3162);
                        report.subject = n5;
                        mounted.setJammed(true);
                        mounted.setHit(true);
                        int n12 = mounted.getLocation();
                        mounted.setDestroyed(true);
                        for (int i = 0; i < entity.getNumberOfCriticals(n12); ++i) {
                            object3 = entity.getCritical(n12, i);
                            if (object3 == null || ((CriticalSlot)object3).getType() != 0 || !(serializable2 = entity.getEquipment(((CriticalSlot)object3).getIndex())).equals(mounted)) continue;
                            entity.hitAllCriticals(n12, i);
                            break;
                        }
                        report.choose(false);
                        this.addReport(report);
                        this.addReport(this.damageEntity(entity, new HitData(n12), weaponType.getDamage(), false, 0, true));
                    }
                } else if (weaponType.hasFlag(0x400000L)) {
                    report = new Report(3165);
                    report.subject = n5;
                    report.newlines = 0;
                    this.addReport(report);
                    mounted.setJammed(true);
                    mounted.setHit(true);
                } else {
                    report = new Report(3170);
                    report.subject = n5;
                    report.newlines = 0;
                    this.addReport(report);
                    mounted.setJammed(true);
                }
            }
        }
        if (this.game.getOptions().booleanOption("maxtech_ppc_inhibitors") && weaponType.hasFlag(8L) && mounted.curMode().equals("Field Inhibitor OFF")) {
            int n13 = 0;
            int n14 = Compute.d6(2);
            int n15 = Compute.effectiveDistance(this.game, entity, targetable);
            if (n15 >= 3) {
                n13 = 3;
            } else if (n15 == 2) {
                n13 = 6;
            } else if (n15 == 1) {
                n13 = 10;
            }
            report = new Report(3175);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            report = new Report(3180);
            report.subject = entity.getId();
            report.indent();
            report.add(n13);
            report.add(n14);
            if (n14 < n13) {
                int n16 = mounted.getLocation();
                mounted.setDestroyed(true);
                for (int i = 0; i < entity.getNumberOfCriticals(n16); ++i) {
                    object2 = entity.getCritical(n16, i);
                    if (object2 == null || ((CriticalSlot)object2).getType() != 0 || !(serializable = entity.getEquipment(((CriticalSlot)object2).getIndex())).equals(mounted)) continue;
                    entity.hitAllCriticals(n16, i);
                }
                report.choose(false);
                this.addReport(report);
                this.addReport(this.damageEntity(entity, new HitData(n16), 10, false, 0, true));
                report = new Report(3185);
                report.subject = entity.getId();
                this.addReport(report);
            } else {
                report.choose(true);
                this.addReport(report);
            }
        }
        boolean bl27 = bl3 = weaponResult.roll < toHitData.getValue();
        if (bl3 && targetable instanceof Mech && ((Mech)targetable).getGrappled() != -1) {
            int n17 = ((Mech)targetable).getGrappled();
            Entity entity4 = this.game.getEntity(n17);
            toHitData.addModifier(-1, "friendly fire");
            report = new Report(3555);
            report.subject = n17;
            report.addDesc(entity4);
            report.newlines = 0;
            this.addReport(report);
            weaponResult.roll = Compute.d6(2);
            report = new Report(3150);
            report.subject = n17;
            report.add(toHitData.getValueAsString());
            report.newlines = 0;
            this.addReport(report);
            report = new Report(3155);
            report.subject = n17;
            report.add(weaponResult.roll);
            report.newlines = 0;
            this.addReport(report);
            if (weaponResult.roll >= toHitData.getValue()) {
                targetable = entity4;
                entity2 = entity4;
                n5 = n17;
                bl3 = false;
            }
        }
        if (this.game.getOptions().booleanOption("maxtech_glancing_blows")) {
            if (weaponResult.roll == toHitData.getValue()) {
                bl23 = true;
                n8 = -4;
                report = new Report(3186);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            } else {
                bl23 = false;
                n8 = 0;
            }
        } else {
            bl23 = false;
            n8 = 0;
        }
        if (weaponType.hasFlag(0x8000000L)) {
            if (entity2 == null) {
                report = new Report(3187);
                report.subject = entity.getId();
                this.addReport(report);
            } else {
                int n18 = 1;
                EquipmentMode equipmentMode = mounted.curMode();
                if (equipmentMode != null) {
                    if (equipmentMode.getName() == "1-shot") {
                        n18 = 1;
                    } else if (equipmentMode.getName() == "2-shot") {
                        n18 = 2;
                    } else if (equipmentMode.getName() == "3-shot") {
                        n18 = 3;
                    } else if (equipmentMode.getName() == "4-shot") {
                        n18 = 4;
                    }
                }
                if (n18 < 1) {
                    n18 = 1;
                }
                object3 = new TagInfo(entity.getId(), entity2.getId(), n18, bl3);
                this.game.addTagInfo((TagInfo)object3);
                if (!bl3) {
                    entity2.setTaggedBy(entity.getId());
                    report = new Report(3188);
                    report.subject = entity.getId();
                    this.addReport(report);
                } else {
                    report = new Report(3220);
                    report.subject = entity.getId();
                    this.addReport(report);
                }
            }
            return !bl3;
        }
        if (bl16) {
            Coords coords = targetable.getPosition();
            int n19 = targetable.getElevation();
            int n20 = n19 + this.game.getBoard().getHex(coords).surface();
            if (!bl3) {
                report = new Report(3191);
                report.subject = n5;
                report.add(coords.getBoardNum());
                this.addReport(report);
            } else {
                coords = Compute.scatter(coords, this.game.getOptions().booleanOption("margin_scatter_distance") ? toHitData.getValue() - weaponResult.roll : -1);
                if (this.game.getBoard().contains(coords)) {
                    report = new Report(3192);
                    report.subject = n5;
                    report.add(coords.getBoardNum());
                    this.addReport(report);
                } else {
                    report = new Report(3193);
                    report.subject = n5;
                    this.addReport(report);
                    return !bl3;
                }
            }
            this.artilleryDamageArea(coords, weaponResult.artyAttackerCoords, ammoType, n5, entity, true, n20);
            return !bl3;
        }
        if (targetable.getTargetType() == 14) {
            Coords coords = targetable.getPosition();
            if (!bl3) {
                report = new Report(3190);
                report.subject = n5;
                report.add(coords.getBoardNum());
                this.addReport(report);
            } else {
                coords = Compute.scatter(coords, 1);
                if (this.game.getBoard().contains(coords)) {
                    report = new Report(3195);
                    report.subject = n5;
                    report.add(coords.getBoardNum());
                    this.addReport(report);
                } else {
                    report = new Report(3200);
                    report.subject = n5;
                    this.addReport(report);
                    return !bl3;
                }
            }
            Infantry infantry2 = (Infantry)entity;
            int n21 = infantry2.getShootingStrength();
            this.artilleryDamageArea(coords, weaponResult.artyAttackerCoords, ammoType, n5, entity, n21 * 2, n21, false, 0);
            return !bl3;
        }
        if (targetable.getTargetType() == 6 || targetable.getTargetType() == 13) {
            Coords coords = targetable.getPosition();
            if (!bl3) {
                report = new Report(3190);
                report.subject = n5;
                report.add(coords.getBoardNum());
                this.addReport(report);
            } else {
                coords = Compute.scatter(coords, this.game.getOptions().booleanOption("margin_scatter_distance") ? toHitData.getValue() - weaponResult.roll : -1);
                if (this.game.getBoard().contains(coords)) {
                    report = new Report(3195);
                    report.subject = n5;
                    report.add(coords.getBoardNum());
                    this.addReport(report);
                } else {
                    report = new Report(3200);
                    report.subject = n5;
                    this.addReport(report);
                    return !bl3;
                }
            }
            if (ammoType.getAmmoType() == 7 || ammoType.getAmmoType() == 50) {
                if (ammoType.getMunitionType() == 262144L) {
                    this.deliverThunderAugMinefield(coords, entity.getOwner().getId(), ammoType.getRackSize());
                } else if (ammoType.getMunitionType() == 131072L) {
                    this.deliverThunderMinefield(coords, entity.getOwner().getId(), ammoType.getRackSize());
                } else if (ammoType.getMunitionType() == 524288L) {
                    this.deliverThunderInfernoMinefield(coords, entity.getOwner().getId(), ammoType.getRackSize());
                } else if (ammoType.getMunitionType() == 0x100000L) {
                    this.deliverThunderVibraMinefield(coords, entity.getOwner().getId(), ammoType.getRackSize(), weaponResult.waa.getOtherAttackInfo());
                } else if (ammoType.getMunitionType() == 0x200000L) {
                    this.deliverThunderActiveMinefield(coords, entity.getOwner().getId(), ammoType.getRackSize());
                } else if (ammoType.getMunitionType() == 8192L) {
                    this.deliverFlare(coords, ammoType.getRackSize());
                }
            }
            return !bl3;
        }
        if (!(targetable.getTargetType() != 7 || bl6 && ammoType.getMunitionType() == 0x20000000L)) {
            Coords coords = targetable.getPosition();
            if (!bl3) {
                report = new Report(3190);
                report.subject = n5;
                report.add(coords.getBoardNum());
                this.addReport(report);
            } else {
                coords = Compute.scatter(coords, this.game.getOptions().booleanOption("margin_scatter_distance") ? toHitData.getValue() - weaponResult.roll : -1);
                if (this.game.getBoard().contains(coords)) {
                    report = new Report(3195);
                    report.subject = n5;
                    report.add(coords.getBoardNum());
                    this.addReport(report);
                } else {
                    report = new Report(3200);
                    report.subject = n5;
                    this.addReport(report);
                    return !bl3;
                }
            }
            if (bl6) {
                if (ammoType.getMunitionType() == 8192L) {
                    int n22 = ammoType.getAmmoType() == 15 ? 4 : (ammoType.getAmmoType() == 16 ? 3 : Math.max(1, ammoType.getRackSize() / 5));
                    this.deliverArtilleryFlare(coords, n22);
                    return !bl3;
                }
                if (ammoType.getMunitionType() == 0x80000000L) {
                    this.deliverArtilleryInferno(coords, n5);
                    return !bl3;
                }
                if (ammoType.getMunitionType() == 0x40000000L) {
                    this.deliverFASCAMMinefield(coords, entity.getOwner().getId());
                    return !bl3;
                }
                if (ammoType.getMunitionType() == 0x100000000L) {
                    this.deliverThunderVibraMinefield(coords, entity.getOwner().getId(), 20, weaponResult.waa.getOtherAttackInfo());
                    return !bl3;
                }
                if (ammoType.getMunitionType() == 0x200000000L) {
                    this.deliverArtillerySmoke(coords);
                    return !bl3;
                }
                if (ammoType.getMunitionType() == 0x800000000L) {
                    Vector<Report> vector = new Vector<Report>();
                    this.doNuclearExplosion(coords, 1, vector);
                    this.addReport(vector);
                    return !bl3;
                }
            }
            this.artilleryDamageArea(coords, weaponResult.artyAttackerCoords, ammoType, n5, entity, false, 0);
            return !bl3;
        }
        if (bl3 && bl6 && ammoType.getMunitionType() == 0x20000000L) {
            this.artilleryDamageHex(targetable.getPosition(), weaponResult.artyAttackerCoords, 5, ammoType, n5, entity, null, false, 0);
        }
        int n23 = 0;
        int n24 = weaponType.getDamage();
        if (bl3) {
            if (mounted.isRapidfire() && (!(targetable instanceof Infantry) || targetable instanceof BattleArmor)) {
                n24 = Compute.d6();
                n23 = 3 * n24;
                if (entity.getTotalAmmoOfType(mounted2.getType()) > 0) {
                    for (int i = 0; i < n23; ++i) {
                        if (mounted2.getShotsLeft() <= 0) {
                            entity.loadWeapon(mounted);
                            mounted2 = mounted.getLinked();
                        }
                        mounted2.setShotsLeft(mounted2.getShotsLeft() - 1);
                    }
                    if (entity instanceof Mech) {
                        entity.heatBuildup += n24;
                    }
                } else {
                    n7 = 0;
                }
            }
            if (!(weaponType.getAmmoType() != 11 && weaponType.getAmmoType() != 47 && weaponType.getAmmoType() != 32 || bl22)) {
                report = new Report(3215);
                report.subject = n5;
                this.addReport(report);
            } else {
                report = new Report(3220);
                report.subject = n5;
                if (mounted.isRapidfire() && (!(targetable instanceof Infantry) || targetable instanceof BattleArmor)) {
                    report.messageId = 3225;
                    report.add(n23);
                }
                this.addReport(report);
            }
            if (weaponResult.amsEngaged) {
                report = new Report(3230);
                report.indent();
                report.subject = n5;
                this.addReport(report);
            }
            int n25 = 0;
            if (bl6) {
                n25 = weaponType.getRackSize();
                if (weaponType.hasFlag(8192L)) {
                    n25 *= 2;
                }
                if (entity instanceof BattleArmor) {
                    infantry = (Infantry)entity;
                    n25 *= infantry.getShootingStrength();
                }
            }
            if (bl20 || bl21) {
                n6 = n2 > 0 ? n2 : n25;
                int n9 = n25 = n2 > 0 ? n2 : n25;
            }
            if (bl6 && (toHitData.getValue() == 0x7FFFFFFE || (weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 47 || weaponType.getAmmoType() == 32) && !bl22)) {
                return !bl3;
            }
            if ((bl20 || bl21) && entity2 != null) {
                serializable2 = Compute.getSwarmTarget(this.game, entity.getId(), entity2, weaponResult.waa.getWeaponId());
                if (serializable2 != null) {
                    report = new Report(3420);
                    report.subject = entity.getId();
                    report.indent();
                    report.add(n6);
                    this.addReport(report);
                    mounted.setUsedThisRound(false);
                    object2 = new WeaponAttackAction(entity.getId(), ((Entity)serializable2).getTargetId(), weaponResult.waa.getWeaponId());
                    ((WeaponAttackAction)object2).setSwarmingMissiles(true);
                    ((WeaponAttackAction)object2).setOldTargetId(targetable.getTargetId());
                    ((WeaponAttackAction)object2).setAmmoId(weaponResult.waa.getAmmoId());
                    serializable = this.preTreatWeaponAttack((WeaponAttackAction)object2);
                    this.resolveWeaponAttack((WeaponResult)serializable, entity.getId(), false, n6);
                } else {
                    report = new Report(3425);
                    report.subject = entity.getId();
                    report.indent();
                    this.addReport(report);
                }
            }
            if (entity2 != null && (bl11 || building == null && weaponType.getFireTN() != Integer.MAX_VALUE)) {
                this.tryIgniteHex(targetable.getPosition(), entity.getId(), bl11, 11);
            }
            if (!bl24) {
                return !bl3;
            }
        }
        if (!bl3 && weaponType.getAmmoType() == 13 && ammoType.getMunitionType() != 0x10000000L) {
            if (weaponResult.amsEngaged) {
                report = new Report(3235);
                report.subject = n5;
                this.addReport(report);
                report = new Report(3230);
                report.indent(1);
                report.subject = n5;
                this.addReport(report);
                int n27 = Compute.d6();
                if (n27 <= 3) {
                    report = new Report(3240);
                    report.subject = n5;
                    report.add(n27);
                    this.addReport(report);
                    return !bl3;
                }
                report = new Report(3241);
                report.add(n27);
                report.subject = n5;
                this.addReport(report);
            }
            if (entity2 == null) {
                report = new Report(3245);
                report.subject = n5;
                this.addReport(report);
            } else {
                object3 = entity2.rollHitLocation(weaponResult.toHit.getHitTable(), weaponResult.toHit.getSideTable());
                if (toHitData.getHitTable() == 6 && entity2.removePartialCoverHits(((HitData)object3).getLocation(), toHitData.getCover(), toHitData.getSideTable())) {
                    report = new Report(3249);
                    report.subject = n5;
                    report.add(entity2.getLocationAbbr((HitData)object3));
                    this.addReport(report);
                } else {
                    entity2.attachNarcPod(new NarcPod(entity.getOwner().getTeam(), ((HitData)object3).getLocation()));
                    report = new Report(3250);
                    report.subject = n5;
                    report.add(entity2.getLocationAbbr((HitData)object3));
                    this.addReport(report);
                }
            }
            return !bl3;
        }
        if (!bl3 && weaponType.getAmmoType() == 31 && ammoType.getMunitionType() != 0x1000000L) {
            if (weaponResult.amsEngaged) {
                report = new Report(3235);
                report.subject = n5;
                this.addReport(report);
                report = new Report(3230);
                report.indent(1);
                report.subject = n5;
                this.addReport(report);
                int n28 = Compute.d6();
                if (n28 <= 3) {
                    report = new Report(3240);
                    report.subject = n5;
                    report.add(n28);
                    this.addReport(report);
                    return !bl3;
                }
                report = new Report(3241);
                report.add(n28);
                report.subject = n5;
                this.addReport(report);
            }
            if (entity2 == null) {
                report = new Report(3245);
                report.subject = n5;
                this.addReport(report);
            } else {
                object3 = entity2.rollHitLocation(weaponResult.toHit.getHitTable(), weaponResult.toHit.getSideTable());
                if (toHitData.getHitTable() == 6 && entity2.removePartialCoverHits(((HitData)object3).getLocation(), toHitData.getCover(), toHitData.getSideTable())) {
                    report = new Report(3249);
                    report.subject = n5;
                    report.add(entity2.getLocationAbbr((HitData)object3));
                    this.addReport(report);
                } else {
                    serializable2 = null;
                    if (ammoType.getMunitionType() == 0x2000000L) {
                        serializable2 = new INarcPod(entity.getOwner().getTeam(), 2, ((HitData)object3).getLocation());
                        report = new Report(3251);
                        report.subject = n5;
                        report.add(entity2.getLocationAbbr((HitData)object3));
                        this.addReport(report);
                    } else if (ammoType.getMunitionType() == 0x4000000L) {
                        serializable2 = new INarcPod(entity.getOwner().getTeam(), 4, ((HitData)object3).getLocation());
                        report = new Report(3252);
                        report.subject = n5;
                        report.add(entity2.getLocationAbbr((HitData)object3));
                        this.addReport(report);
                    } else if (ammoType.getMunitionType() == 0x8000000L) {
                        serializable2 = new INarcPod(entity.getOwner().getTeam(), 8, ((HitData)object3).getLocation());
                        report = new Report(3253);
                        report.subject = n5;
                        report.add(entity2.getLocationAbbr((HitData)object3));
                        this.addReport(report);
                    } else {
                        serializable2 = new INarcPod(entity.getOwner().getTeam(), 1, ((HitData)object3).getLocation());
                        report = new Report(3254);
                        report.subject = n5;
                        report.add(entity2.getLocationAbbr((HitData)object3));
                        this.addReport(report);
                    }
                    entity2.attachINarcPod((INarcPod)serializable2);
                }
            }
            return !bl3;
        }
        if (!bl3 && targetable.getTargetType() == 5) {
            int n29 = Compute.d6(2);
            if (n29 >= 5) {
                report = new Report(3255);
                report.indent(1);
                report.subject = n5;
                this.addReport(report);
                serializable2 = targetable.getPosition();
                object2 = this.game.getMinefields((Coords)serializable2).elements();
                while (object2.hasMoreElements()) {
                    serializable = (Minefield)object2.nextElement();
                    this.removeMinefield((Minefield)serializable);
                }
            } else {
                report = new Report(3260);
                report.indent(1);
                report.subject = n5;
                this.addReport(report);
            }
            return !bl3;
        }
        boolean bl28 = bl2 = weaponType.hasFlag(2L) && weaponType.hasModes() && mounted.curMode().equals("Cool");
        if (weaponType.hasFlag(0x40000000L) || bl2) {
            if (!bl3) {
                report = new Report(2270);
                report.subject = n5;
                report.newlines = 0;
                this.addReport(report);
                if (8 == targetable.getTargetType()) {
                    report = new Report(3540);
                    report.subject = n5;
                    report.add(targetable.getPosition().getBoardNum());
                    report.indent(3);
                    this.addReport(report);
                    this.game.getBoard().getHex(targetable.getPosition()).removeTerrain(7);
                    this.sendChangedHex(targetable.getPosition());
                    this.game.getBoard().removeInfernoFrom(targetable.getPosition());
                } else if (targetable instanceof Entity) {
                    if (entity2.infernos.isStillBurning() || targetable instanceof Tank && ((Tank)targetable).isOnFire()) {
                        report = new Report(3550);
                        report.subject = n5;
                        report.addDesc(entity2);
                        report.newlines = 0;
                        report.indent(3);
                        this.addReport(report);
                    }
                    entity2.infernos.clear();
                    if (targetable instanceof Tank) {
                        for (int i = 0; i < entity2.locations(); ++i) {
                            ((Tank)targetable).extinguishAll();
                        }
                    }
                    if (targetable instanceof Mech && bl2) {
                        int n30 = n24 * n7;
                        report = new Report(3400);
                        report.subject = n5;
                        report.indent(2);
                        report.add(n30);
                        report.choose(false);
                        this.addReport(report);
                        entity2.heatFromExternal -= n30;
                        n7 = 0;
                    }
                }
            }
            return !bl3;
        }
        int n31 = 1;
        int n32 = 0;
        boolean bl29 = false;
        boolean bl30 = false;
        boolean bl31 = false;
        boolean bl32 = false;
        String string = " shot(s) ";
        boolean bl33 = false;
        int n33 = entity.getPosition().distance(targetable.getPosition());
        int n34 = 0;
        boolean bl34 = this.game.getOptions().booleanOption("maxtech_mslhitpen");
        if (bl34) {
            n34 = n33 <= 1 ? 1 : (n33 <= weaponType.getShortRange() ? 0 : (n33 <= weaponType.getMediumRange() ? -1 : -2));
        }
        if ((weaponType.getAmmoType() == 11 || weaponType.getAmmoType() == 47 || weaponType.getAmmoType() == 32) && !bl22 || weaponType.getAmmoType() == 13 || entity.getSwarmTargetId() == weaponResult.waa.getTargetId() || (targetable.getTargetType() == 4 || targetable.getTargetType() == 16 || targetable.getTargetType() == 15 || targetable.getTargetType() == 3) && entity.getPosition().distance(targetable.getPosition()) <= 1 || targetable.getTargetType() == 1 || targetable instanceof Infantry && !(targetable instanceof BattleArmor)) {
            bl33 = true;
        }
        if (!bl3 && "SwarmMek".equals(weaponType.getInternalName())) {
            if (-1 != entity2.getSwarmAttackerId()) {
                report = new Report(3265);
                report.subject = n5;
                this.addReport(report);
            } else if (entity2.isDoomed() || entity2.isDestroyed() || entity2.getCrew().isDead()) {
                report = new Report(3270);
                report.subject = n5;
                this.addReport(report);
            } else {
                report = new Report(3275);
                report.subject = n5;
                this.addReport(report);
                entity.setSwarmTargetId(weaponResult.waa.getTargetId());
                entity2.setSwarmAttackerId(weaponResult.waa.getEntityId());
            }
            return !bl3;
        }
        if (weaponType.getInternalName().equals("BAMineLauncher")) {
            n7 = n10;
            if (!bl33) {
                n7 = Compute.missilesHit(n7);
            }
            bl29 = true;
            string = " mine(s) ";
        } else if (bl7) {
            bl29 = true;
            infantry = (Infantry)entity;
            n31 = 1;
            if (bl6) {
                n24 = ammoType.getDamagePerShot();
            }
            n24 = weaponType.getRackSize();
            n7 = infantry.getShootingStrength();
            if (!bl33) {
                n7 = Compute.missilesHit(n7);
            }
            if (bl11) {
                n31 = n7;
                n24 = 0;
                string = " Inferno missle(s) ";
                bl29 = false;
            }
            if (entity.getSwarmTargetId() == weaponResult.waa.getTargetId()) {
                n24 += ((BattleArmor)entity).getVibroClawDamage();
            }
        } else if (bl5) {
            bl29 = true;
            infantry = (Infantry)entity;
            n31 = 2;
            n24 = 1;
            n7 = infantry.getDamage(Compute.missilesHit(infantry.getShootingStrength()));
            if (weaponType.hasFlag(512L) && targetable instanceof Infantry && !(targetable instanceof BattleArmor)) {
                n7 += Compute.d6();
            }
            string = " damage are inflicted by the shots that ";
            if (bl11) {
                n31 = n7;
                n24 = 0;
                string = " Inferno missile(s) ";
                bl29 = false;
            }
        } else if (weaponType.getDamage() == -2 || weaponType.hasFlag(16384L)) {
            bl29 = true;
            if (weaponType.getAmmoType() == -2 || weaponType.getAmmoType() == -3) {
                n24 = Math.abs(weaponType.getAmmoType());
            } else {
                string = " missile(s) ";
                n24 = ammoType.getDamagePerShot();
                if (!(weaponType.getAmmoType() != 39 && weaponType.getAmmoType() != 40 && weaponType.getAmmoType() != 41 && weaponType.getAmmoType() != 42 || n33 > weaponType.getMinimumRange() || mounted.isHotLoaded())) {
                    n24 /= 2;
                }
            }
            if (weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 32 || weaponType.getAmmoType() == 8 || weaponType.getAmmoType() == 12 || weaponType.getAmmoType() == 47 || weaponType.getAmmoType() == 29 || weaponType.getAmmoType() == 38 || weaponType.getAmmoType() == 45 || weaponType.getAmmoType() == 49 || weaponType.getAmmoType() == 52 || weaponType.getAmmoType() == 30) {
                n31 = 5;
            }
            if (ammoType != null && ammoType.getAmmoType() == 50) {
                n31 = ammoType.hasFlag(32L) ? 5 : 1;
            }
            if (weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 9 || weaponType.getAmmoType() == 29 || weaponType.getAmmoType() == 50) {
                mounted3 = mounted.getLinkedBy();
                if (weaponType.getAmmoType() == 29 || mounted3 != null && mounted3.getType() instanceof MiscType && !mounted3.isDestroyed() && !mounted3.isMissing() && !mounted3.isBreached() && mounted3.getType().hasFlag(512L) && ammoType.getMunitionType() == 2048L) {
                    if (!bl30) {
                        if (entity instanceof Mech) {
                            bl32 = entity.isStealthActive();
                        }
                        bl31 = Compute.isAffectedByECM(entity, entity.getPosition(), targetable.getPosition()) || Compute.isAffectedByAngelECM(entity, entity.getPosition(), targetable.getPosition()) ? true : targetable.getTargetType() == 0 && (Compute.isProtectedByECM((Entity)targetable, targetable.getPosition(), entity.getPosition()) || Compute.isProtectedByAngelECM((Entity)targetable, targetable.getPosition(), entity.getPosition()));
                        bl30 = true;
                    }
                    if (!(bl31 || bl32 || mounted.getType().hasModes() && mounted.curMode().equals("Indirect") || (ammoType.getAmmoType() != 29 || ammoType.getMunitionType() != 0L && ammoType.getMunitionType() != 32L && ammoType.getMunitionType() != 64L) && (ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 9 && ammoType.getAmmoType() != 50 || ammoType.getMunitionType() != 2048L))) {
                        n32 += 2;
                    }
                } else if (entity2 != null && (entity2.isNarcedBy(entity.getOwner().getTeam()) || entity2.isINarcedBy(entity.getOwner().getTeam()))) {
                    if (!bl30) {
                        if (entity instanceof Mech) {
                            bl32 = entity.isStealthActive();
                        }
                        bl31 = Compute.isAffectedByECM(entity, entity.getPosition(), targetable.getPosition()) || Compute.isAffectedByAngelECM(entity, entity.getPosition(), targetable.getPosition()) ? true : targetable.getTargetType() == 0 && (Compute.isProtectedByECM((Entity)targetable, targetable.getPosition(), entity.getPosition()) || Compute.isProtectedByAngelECM((Entity)targetable, targetable.getPosition(), entity.getPosition()));
                        bl30 = true;
                    }
                    if (!(bl31 || bl32 || ammoType.getAmmoType() != 7 && ammoType.getAmmoType() != 50 && ammoType.getAmmoType() != 9 || ammoType.getMunitionType() != 1024L)) {
                        n32 += 2;
                    }
                }
            }
            if (bl6 && ammoType.getAmmoType() == 24) {
                ++n32;
            }
            if (bl6 && ammoType.getAmmoType() == 49) {
                if (n33 <= weaponType.getShortRange()) {
                    n32 += 2;
                } else if (n33 > weaponType.getMediumRange()) {
                    n32 -= 2;
                }
                string = " fragments ";
            }
            if (bl11) {
                n24 = 0;
                n32 = 0;
                string = " inferno missile(s) ";
                bl29 = false;
            }
            if (bl20) {
                string = " swarm missile(s) ";
            }
            if (bl21) {
                string = " swarm-I missile(s) ";
            }
            if (bl19) {
                string = " anti-TSM missile(s) ";
            }
            if (bl12) {
                string = " fragmentation missile(s) ";
            }
            if (bl13) {
                n24 = 1;
                n32 = -2;
                string = " acid-head missile(s) ";
            }
            if (bl8) {
                ++n24;
                n31 = 1;
            }
            if (bl9) {
                n31 = weaponType.getRackSize();
            }
            if (bl10) {
                n24 = 1;
            }
            if (entity.isSufferingEMI()) {
                n32 -= 2;
            }
            if (weaponResult.amsEngaged) {
                report = new Report(3230);
                report.newlines = 0;
                report.subject = n5;
                this.addReport(report);
                n32 -= 4;
            }
            if (entity instanceof BattleArmor) {
                infantry = (Infantry)entity;
                if (bl33) {
                    n7 = n4;
                } else {
                    n7 = 0;
                    for (n4 = weaponType.getRackSize() * infantry.getShootingStrength(); n4 > 30; n4 -= 30) {
                        n7 += Compute.missilesHit(30, n34 + n8 + (entity.isSufferingEMI() ? -2 : 0), bl34 | bl23);
                    }
                    n7 += Compute.missilesHit(n4, n34 + n8 + (entity.isSufferingEMI() ? -2 : 0), bl34 | bl23);
                }
            } else if (bl33) {
                n7 = weaponResult.amsEngaged ? Compute.missilesHit(weaponType.getRackSize(), n32 + n34 + n8, bl34 | bl23, mounted.isHotLoaded(), true) : weaponType.getRackSize();
            } else {
                n7 = Compute.missilesHit(weaponType.getRackSize(), n32 + n34 + n8, bl34 | bl23, mounted.isHotLoaded());
                if ((bl20 || bl21) && n2 == 0) {
                    n6 = weaponType.getRackSize() - n7;
                }
            }
            if (bl19) {
                n7 = (int)Math.ceil((double)n7 / 2.0);
            }
            if ((bl20 || bl21) && n2 > 0) {
                n4 = 5;
                if (n2 > 5 && n2 <= 10) {
                    n4 = 10;
                } else if (n2 > 10 && n2 <= 15) {
                    n4 = 15;
                } else if (n2 > 15 && n2 <= 20) {
                    n4 = 20;
                }
                n7 = Compute.missilesHit(n4, n32 + n34 + n8, bl34 | bl23);
                if (n7 > n2) {
                    n7 = n2;
                }
                n6 = n2 - n7;
            }
        } else if (bl6 && (ammoType.getAmmoType() == 19 || ammoType.getAmmoType() == 33 || ammoType.getAmmoType() == 48) && ammoType.getMunitionType() == 1L) {
            bl29 = true;
            n7 = weaponType.getRackSize();
            if (weaponType.getAmmoType() == 48) {
                if (n33 == 1) {
                    n7 = 15;
                } else if (n33 == 2) {
                    n7 = 10;
                } else if (n33 == 3) {
                    n7 = 5;
                } else if (n33 == 4) {
                    n7 = 2;
                }
            } else {
                n7 = weaponType.getRackSize();
            }
            int n11 = n4 = weaponType.hasFlag(0x400000L) ? 0 : -1;
            if (!bl33) {
                n7 = !bl23 ? Compute.missilesHit(n7, n4 + (entity.isSufferingEMI() ? -2 : 0)) : Compute.missilesHit(n7, n4 + (entity.isSufferingEMI() ? -2 : 0)) / 2;
            }
            n24 = 1;
        } else if (n10 > 1) {
            bl29 = true;
            n7 = n10;
            if (!bl33) {
                n7 = Compute.missilesHit(n7, entity.isSufferingEMI() ? -2 : 0);
            }
        } else if (weaponType.getAmmoType() == 22) {
            n24 = n33 <= weaponType.getShortRange() ? 25 : (n33 <= weaponType.getMediumRange() ? 20 : 10);
        } else if (weaponType.hasFlag(262144L)) {
            n24 = weaponType.getDamage();
            if (n24 == -3) {
                n24 = weaponType.getRackSize();
                if (weaponType.hasFlag(8L)) {
                    if (n33 > weaponType.getMediumRange()) {
                        n24 /= 2;
                    } else if (n33 > weaponType.getShortRange()) {
                        n24 = (n24 * 3 + 3) / 4;
                    }
                }
            }
            if (this.game.getOptions().booleanOption("maxtech_altdmg")) {
                if (n33 <= 1) {
                    ++n24;
                } else if (n33 > weaponType.getMediumRange()) {
                    if (n33 <= weaponType.getLongRange()) {
                        --n24;
                    } else if (n33 <= weaponType.getExtremeRange()) {
                        n24 = (int)Math.floor((double)n24 / 2.0);
                    }
                }
            }
        } else if (mounted.isRapidfire() && (!(targetable instanceof Infantry) || targetable instanceof BattleArmor)) {
            n24 = Compute.d6();
            n23 = 3 * n24;
            if (entity.getTotalAmmoOfType(mounted2.getType()) > 0) {
                for (n4 = 0; n4 < n23; ++n4) {
                    if (mounted2.getShotsLeft() <= 0) {
                        entity.loadWeapon(mounted);
                        mounted2 = mounted.getLinked();
                    }
                    mounted2.setShotsLeft(mounted2.getShotsLeft() - 1);
                }
                if (entity instanceof Mech) {
                    entity.heatBuildup += n24;
                }
            } else {
                n7 = 0;
            }
        }
        if (weaponType.hasFlag(4L) && weaponType.hasFlag(0x400000L)) {
            entity.heatBuildup += Compute.d6();
        }
        if (bl18) {
            --n24;
        }
        if (bl23 && !weaponType.hasFlag(524288L) && !weaponType.hasFlag(16384L) && (!bl6 || ammoType.getAmmoType() != 19 && ammoType.getAmmoType() != 33 && ammoType.getAmmoType() != 48 || ammoType.getMunitionType() != 1L)) {
            n24 = (int)Math.floor((double)n24 / 2.0);
        }
        if (weaponType.hasFlag(8192L)) {
            n7 *= 2;
        }
        if (bl6 && ammoType.getMunitionType() == 0x20000000L) {
            n24 = weaponType.getRackSize();
            if (entity2 != null && entity2.getTaggedBy() != -1) {
                if (weaponResult.artyAttackerCoords != null) {
                    toHitData.setSideTable(entity2.sideTable(weaponResult.artyAttackerCoords));
                } else {
                    Entity entity5 = this.game.getEntity(entity2.getTaggedBy());
                    if (entity5 != null) {
                        toHitData.setSideTable(Compute.targetSideTable(entity5, (Targetable)entity2));
                    }
                }
            }
        }
        if (bl3) {
            if (bl24 && building != null && !bl20 && !bl21) {
                if (bl11 && n7 > 0) {
                    this.deliverInfernoMissiles(entity, new BuildingTarget(targetable.getPosition(), this.game.getBoard(), false), n7);
                } else {
                    Report report2;
                    int n36 = n7 * n24;
                    if (bl12) {
                        n36 = 0;
                    }
                    if (n36 > 0 && (report2 = this.damageBuilding(building, n36)) != null) {
                        report2.indent(2);
                        report2.newlines = 1;
                        report2.subject = n5;
                        this.addReport(report2);
                    }
                }
            }
            return !bl3;
        }
        int n37 = 0;
        if (bl24 && building != null) {
            n37 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
        }
        if (!bl5 && entity.getSwarmTargetId() == weaponResult.waa.getTargetId()) {
            n31 = n7;
        }
        if (weaponType.getAmmoType() == -2 && targetable instanceof Infantry && !(targetable instanceof BattleArmor)) {
            if (n37 > 0) {
                int n38 = n24 * n7;
                report = new Report(3295);
                report.newlines = 0;
                report.subject = n5;
                report.add(n7);
                report.add(string);
                this.addReport(report);
                Report report3 = this.damageBuilding(building, Math.min(n38, n37), " absorbs the shots, taking ");
                if (report3 != null) {
                    report3.newlines = 1;
                    report3.subject = n5;
                    this.addReport(report3);
                }
                return !bl3;
            }
            n24 = Compute.d6(n7);
            report = new Report(3300);
            report.newlines = 0;
            report.subject = n5;
            report.add(n24);
            report.add(string);
            this.addReport(report);
            n7 = 1;
        } else if (weaponType.hasFlag(0x200000000L) && !bl5 && targetable instanceof Infantry && !(targetable instanceof BattleArmor) && !mounted.isRapidfire()) {
            n3 = weaponType.getDamage();
            if (weaponType.hasFlag(2L)) {
                n3 *= 2;
            } else if (weaponType.hasFlag(4L) || weaponType.getAmmoType() == 44) {
                n3 = 2;
            }
            if (n24 <= n37) {
                int n39 = n24 * n7;
                int n40 = building.getCurrentCF();
                n40 = Math.min(n40, n39);
                building.setCurrentCF(n40);
                if (bl29) {
                    report = new Report(3305);
                    report.subject = n5;
                    report.add(n7);
                    report.add(string);
                    this.addReport(report);
                } else {
                    report = new Report(3310);
                    report.subject = n5;
                    this.addReport(report);
                }
                report = new Report(3315);
                report.indent(2);
                report.subject = n5;
                this.addReport(report);
                Report report4 = this.damageBuilding(building, Math.min(n39, n37), " absorbs the shots, taking ");
                if (report4 != null) {
                    report4.newlines = 1;
                    report4.subject = n5;
                    this.addReport(report4);
                }
                return !bl3;
            }
            if (n37 > 0) {
                n3 -= n37;
            }
            n24 = Compute.d6(n3);
            report = new Report(3320);
            report.subject = n5;
            report.add(n24);
            report.add(string);
            this.addReport(report);
            bl29 = true;
            if (n37 > 0) {
                Report report5 = this.damageBuilding(building, n37);
                if (report5 != null) {
                    report5.indent(2);
                    report5.subject = n5;
                    this.addReport(report5);
                }
                n37 = 0;
            }
        } else if (bl29 && !bl11) {
            report = new Report(3325);
            report.subject = n5;
            report.add(n7);
            report.add(string);
            report.add(toHitData.getTableDesc());
            report.newlines = 0;
            this.addReport(report);
            if (bl31) {
                report = new Report(3330);
                report.subject = n5;
                report.newlines = 0;
                this.addReport(report);
            } else if (bl32) {
                report = new Report(3335);
                report.subject = n5;
                report.newlines = 0;
                this.addReport(report);
            }
            if (n32 > 0) {
                report = new Report(3340);
                report.subject = n5;
                report.add(n32);
                report.newlines = 0;
                this.addReport(report);
            }
            report = new Report(3345);
            report.subject = n5;
            report.newlines = 0;
            this.addReport(report);
        }
        if (weaponType.getAmmoType() == 29) {
            n7 = n24 * n7;
            n24 = 1;
        }
        if (weaponType.getAmmoType() == 51) {
            if (entity2 instanceof Mech) {
                n3 = Compute.d6(weaponType.getRackSize());
                n24 = ammoType.getDamagePerShot();
                if (!bl29) {
                    report = new Report(3390);
                    report.subject = n5;
                    report.newlines = 0;
                    this.addReport(report);
                }
                report = new Report(3400);
                report.subject = n5;
                report.indent(2);
                report.add(n3);
                report.choose(true);
                report.newlines = 0;
                this.addReport(report);
                entity2.heatFromExternal += n3;
            } else {
                n3 = Compute.d6(weaponType.getRackSize() + 1);
                n24 = 1;
                n7 = ammoType.getDamagePerShot() + n3;
                bl29 = true;
                n31 = 5;
                report = new Report(3575);
                report.subject = n5;
                report.newlines = 0;
                report.add(n7);
                this.addReport(report);
                for (Mounted mounted4 : entity2.getMisc()) {
                    EquipmentType object4 = mounted4.getType();
                    if (!"BA-Fire Resistant Armor".equals(object4.getInternalName())) continue;
                    n7 /= 2;
                }
            }
        } else if (!(entity instanceof Infantry) && targetable instanceof Infantry && !(targetable instanceof BattleArmor) && !weaponType.hasFlag(0x200000000L)) {
            if (bl29) {
                if (bl6 && (weaponType.getAmmoType() == 7 || weaponType.getAmmoType() == 9 || weaponType.getAmmoType() == 50) && ammoType.getMunitionType() == 128L) {
                    n24 = weaponType.getRackSize() * n24;
                    n7 = 1;
                } else if (weaponType.hasFlag(131072L)) {
                    n24 = (weaponType.getRackSize() * n24 + 9) / 10 + 1;
                    n7 = 1;
                } else {
                    n24 = (weaponType.getRackSize() * n24 + 4) / 5;
                    n7 = 1;
                }
            } else if (weaponType.hasFlag(0x100000000L)) {
                n24 = (n24 + 9) / 10 + 2;
            } else if (!bl6 || weaponType.getAmmoType() != 1 && weaponType.getAmmoType() != 35 || ammoType.getMunitionType() != 4L) {
                n24 = (n24 + 9) / 10;
            }
            if (entity2.getMovementMode() != 12 && entity2.getMovementMode() != 10 && entity2.getMovementMode() != 11 && entity2.getMovementMode() != 18 || entity2.getArmor(0) > 0) {
                n24 *= 2;
            }
            if (bl23) {
                n24 /= 2;
            }
        }
        if (n7 == 0) {
            report = new Report(3365);
            report.subject = n5;
            this.addReport(report);
        }
        HitData hitData = null;
        while (n7 > 0) {
            if (bl11) {
                this.deliverInfernoMissiles(entity, targetable, n7);
                return !bl3;
            }
            if (targetable.getTargetType() == 2 || targetable.getTargetType() == 4) {
                if (!bl29) {
                    report = new Report(2270);
                    report.subject = n5;
                    report.newlines = 0;
                    this.addReport(report);
                }
                int n41 = weaponType.getFireTN();
                if (bl17) {
                    n41 = 5;
                }
                if (n41 != Integer.MAX_VALUE) {
                    if (building != null) {
                        n41 += building.getType() - 1;
                    }
                    this.addNewLines();
                    this.tryIgniteHex(targetable.getPosition(), entity.getId(), bl11, n41, true);
                }
                return !bl3;
            }
            if (targetable.getTargetType() == 1) {
                int n42 = n24 * n7;
                if (!bl29) {
                    report = new Report(2270);
                    report.subject = n5;
                    report.newlines = 0;
                    this.addReport(report);
                }
                if (entity instanceof Infantry) {
                    report = new Report(3380);
                    report.indent();
                    report.subject = n5;
                    this.addReport(report);
                    return !bl3;
                }
                if (bl12 || bl14) {
                    n42 *= 2;
                }
                report = new Report(3385);
                report.indent();
                report.subject = n5;
                report.add(n42);
                this.addReport(report);
                IHex iHex = this.game.getBoard().getHex(targetable.getPosition());
                if (iHex.containsTerrain(1) || iHex.containsTerrain(23) || iHex.containsTerrain(20)) {
                    this.tryClearHex(targetable.getPosition(), n42, entity.getId());
                } else {
                    report = new Report(3075);
                    report.indent(3);
                    report.subject = entity.getId();
                    this.addReport(report);
                }
                return !bl3;
            }
            if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
                Report report6;
                int n43 = n24 * n7;
                if (!bl29) {
                    report = new Report(3390);
                    report.subject = n5;
                    this.addReport(report);
                }
                this.addNewLines();
                if (bl12) {
                    n43 = 0;
                    this.addReport(new Report(3565));
                }
                if ((report6 = this.damageBuilding(building, n43)) != null) {
                    report6.indent(2);
                    report6.newlines = 1;
                    report6.subject = n5;
                    this.addReport(report6);
                }
                this.damageInfantryIn(building, n43);
                return !bl3;
            }
            if (weaponType.hasFlag(2L) && targetable instanceof BattleArmor) {
                for (Mounted mounted4 : entity2.getMisc()) {
                    int n12;
                    Report report2;
                    EquipmentType equipmentType = mounted4.getType();
                    if (!"BA-Fire Resistant Armor".equals(equipmentType.getInternalName())) continue;
                    if (!bl29) {
                        report = new Report(3390);
                        report.subject = n5;
                        this.addReport(report);
                    }
                    report = new Report(3395);
                    report.indent(2);
                    report.subject = n5;
                    report.addDesc(entity2);
                    this.addReport(report);
                    if (n37 > 0 && (report2 = this.damageBuilding(building, n12 = n24 * Math.min(n37, n7))) != null) {
                        report2.indent(2);
                        report2.newlines = 1;
                        report2.subject = n5;
                        this.addReport(report2);
                    }
                    return !bl3;
                }
            }
            if (entity2 != null && entity2 instanceof Mech && weaponType.hasFlag(2L) && this.game.getOptions().booleanOption("flamer_heat") && weaponType.hasModes() && mounted.curMode().equals("Heat")) {
                int n45 = n24 * n7;
                if (!bl29) {
                    report = new Report(3390);
                    report.subject = n5;
                    this.addReport(report);
                }
                report = new Report(3400);
                report.subject = n5;
                report.indent(2);
                report.add(n45);
                report.choose(true);
                report.newlines = 0;
                this.addReport(report);
                entity2.heatFromExternal += n45;
                n7 = 0;
                continue;
            }
            if (entity2 != null) {
                if (!weaponType.hasFlag(0x400000000L) || hitData == null) {
                    hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable(), weaponResult.waa.getAimedLocation(), weaponResult.waa.getAimingMode());
                }
                if (weaponType.hasFlag(0x20000000L) && entity2 instanceof Mech) {
                    int n46 = n24 * n7;
                    if (!bl29) {
                        report = new Report(3390);
                        report.subject = n5;
                        this.addReport(report);
                    }
                    report = new Report(3400);
                    report.subject = n5;
                    report.indent(2);
                    report.add(5);
                    report.choose(true);
                    report.newlines = 0;
                    this.addReport(report);
                    entity2.heatFromExternal += 5;
                }
                if (weaponType.getInternalName().equals("LegAttack") && entity2.getInternal(hitData) <= 0) {
                    hitData = hitData.getLocation() == 6 ? new HitData(7) : new HitData(6);
                }
                if (weaponType.getInternalName().equals("BAMineLauncher")) {
                    hitData = targetable instanceof Mech ? new HitData(1) : new HitData(1);
                }
                if (!bl29) {
                    report = new Report(3405);
                    report.subject = n5;
                    report.add(toHitData.getTableDesc());
                    report.add(entity2.getLocationAbbr(hitData));
                    report.newlines = 0;
                    this.addReport(report);
                    if (hitData.hitAimedLocation()) {
                        report = new Report(3410);
                        report.subject = n5;
                        report.newlines = 0;
                        this.addReport(report);
                    }
                }
                if (n24 == -4) {
                    hitData.setEffect(1 | hitData.getEffect());
                    int n47 = 4;
                    if (entity instanceof BattleArmor) {
                        n47 += ((BattleArmor)entity).getVibroClawDamage();
                    }
                    this.addReport(this.damageEntity(entity2, hitData, n47, false, 0, false, false, bl4));
                } else if (toHitData.getHitTable() == 6 && entity2.removePartialCoverHits(hitData.getLocation(), toHitData.getCover(), toHitData.getSideTable())) {
                    report = new Report(3460);
                    report.subject = entity2.getId();
                    report.indent(2);
                    report.add(entity2.getDisplayName());
                    report.add(entity2.getLocationAbbr(hitData));
                    report.newlines = 0;
                    this.addReport(report);
                } else {
                    int n48 = n24 * Math.min(n31, n7);
                    if (n37 > 0) {
                        int n49 = Math.min(n37, n48);
                        n48 -= n49;
                        this.addNewLines();
                        Report report3 = this.damageBuilding(building, n49);
                        if (report3 != null) {
                            report3.indent(2);
                            report3.subject = n5;
                            this.addReport(report3);
                        }
                    }
                    if (n48 == 0) {
                        report = new Report(3415);
                        report.subject = n5;
                        report.indent(2);
                        report.addDesc(entity2);
                        report.newlines = 0;
                        this.addReport(report);
                    } else if (entity.getSwarmTargetId() == entity2.getId()) {
                        this.addReport(this.damageEntity(entity2, hitData, n48, false, 7, false, false, false));
                    } else if (bl12) {
                        if (bl23) {
                            hitData.makeGlancingBlow();
                        }
                        this.addReport(this.damageEntity(entity2, hitData, n48, false, 1, false, false, bl4));
                    } else if (bl14) {
                        if (bl23) {
                            hitData.makeGlancingBlow();
                        }
                        this.addReport(this.damageEntity(entity2, hitData, n48, false, 2, false, false, bl4));
                    } else if (bl13) {
                        if (bl23) {
                            hitData.makeGlancingBlow();
                        }
                        this.addReport(this.damageEntity(entity2, hitData, n48, false, 3, false, false, bl4));
                    } else if (bl17) {
                        if (bl23) {
                            hitData.makeGlancingBlow();
                        }
                        this.addReport(this.damageEntity(entity2, hitData, n48, false, 4, false, false, bl4));
                    } else if (weaponType.hasFlag(0x200000L)) {
                        if (bl23) {
                            hitData.makeGlancingBlow();
                        }
                        this.addReport(this.damageEntity(entity2, hitData, n48, false, 5, false, false, bl4));
                    } else if (weaponType.hasFlag(0x80000000L) && this.game.getOptions().booleanOption("maxtech_infantry_damage")) {
                        if (bl23) {
                            hitData.makeGlancingBlow();
                        }
                        this.addReport(this.damageEntity(entity2, hitData, n48, false, 6, false, false, bl4));
                    } else if (bl10) {
                        if (entity2.hasActiveShield(hitData.getLocation(), hitData.isRear()) || entity2.hasPassiveShield(hitData.getLocation(), hitData.isRear()) || entity2.hasNoDefenseShield(hitData.getLocation())) {
                            this.addReport(this.damageEntity(entity2, hitData, n48, false, 0, false, false, bl4));
                            hitData = hitData.getLocation() == 4 || hitData.getLocation() == 6 || hitData.getLocation() == 2 ? new HitData(4) : (hitData.getLocation() == 5 || hitData.getLocation() == 7 || hitData.getLocation() == 3 ? new HitData(5) : (entity2.hasActiveShield(5) || entity2.hasPassiveShield(5) || entity2.hasNoDefenseShield(5) ? new HitData(5) : new HitData(4)));
                            hitData.setEffect(32);
                            this.addReport(this.damageEntity(entity2, hitData, n48, false, 0, false, false, bl4));
                        } else if (entity2.getArmor(hitData.getLocation(), hitData.isRear()) > 0) {
                            this.addReport(this.damageEntity(entity2, hitData, n48, false, 0, false, false, bl4));
                            hitData.setEffect(32);
                            this.addNewLines();
                            this.addReport(this.damageEntity(entity2, hitData, n48, false, 0, true, false, bl4));
                        } else {
                            this.addReport(this.damageEntity(entity2, hitData, n48, false, 0, true, false, bl4));
                        }
                    } else {
                        if (bl6 && (ammoType.getAmmoType() == 1 || ammoType.getAmmoType() == 35) && ammoType.getMunitionType() == 2L && entity2.getArmorType() != 4) {
                            hitData.makeArmorPiercing(ammoType);
                        }
                        if (bl23) {
                            hitData.makeGlancingBlow();
                        }
                        if (bl19) {
                            entity2.hitThisRoundByAntiTSM = true;
                        }
                        this.addReport(this.damageEntity(entity2, hitData, n48, false, 0, false, false, bl4));
                    }
                }
                n7 -= n31;
                continue;
            }
            System.err.println("Unable to resolve hit against " + targetable.getDisplayName());
            if (entity2 == null) {
                System.err.println("   entityTarget is null");
            }
            n7 = 0;
        }
        if (ammoType != null && ammoType.getMunitionType() == 0x20000000L) {
            this.artilleryDamageHex(targetable.getPosition(), weaponResult.artyAttackerCoords, 5, ammoType, n5, entity, entity2, false, 0);
        }
        this.addNewLines();
        if (weaponType.hasFlag(0x200000L)) {
            this.tryIgniteHex(entity2.getPosition(), entity.getId(), false, weaponType.getFireTN(), true);
        }
        if (n6 > 0 && entity2 != null) {
            Entity entity6 = Compute.getSwarmTarget(this.game, entity.getId(), entity2, weaponResult.waa.getWeaponId());
            if (entity6 != null) {
                report = new Report(3420);
                report.subject = entity6.getId();
                report.indent();
                report.add(n6);
                this.addReport(report);
                mounted.setUsedThisRound(false);
                WeaponAttackAction weaponAttackAction = new WeaponAttackAction(entity.getId(), entity6.getTargetId(), weaponResult.waa.getWeaponId());
                weaponAttackAction.setSwarmingMissiles(true);
                weaponAttackAction.setOldTargetId(targetable.getTargetId());
                weaponAttackAction.setAmmoId(weaponResult.waa.getAmmoId());
                WeaponResult weaponResult2 = this.preTreatWeaponAttack(weaponAttackAction);
                this.resolveWeaponAttack(weaponResult2, entity.getId(), false, n6);
            } else {
                report = new Report(3425);
                report.subject = entity.getId();
                report.indent();
                this.addReport(report);
            }
        }
        this.creditKill(entity2, entity);
        return !bl3;
    }

    private void resolvePhysicalAttacks() {
        Object object;
        Object object2;
        this.addReport(new Report(4000, 0));
        Enumeration<EntityAction> enumeration = this.game.getCharges();
        while (enumeration.hasMoreElements()) {
            this.game.addAction(enumeration.nextElement());
        }
        this.game.resetCharges();
        this.cleanupPhysicalAttacks();
        enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            object2 = enumeration.nextElement();
            object = (AttackAction)object2;
            if (!this.game.getEntity(object.getEntityId()).isActive() && !(object2 instanceof DfaAttackAction)) continue;
            AbstractAttackAction abstractAttackAction = (AbstractAttackAction)object2;
            if (abstractAttackAction instanceof SearchlightAttackAction) {
                SearchlightAttackAction searchlightAttackAction = (SearchlightAttackAction)abstractAttackAction;
                this.addReport(searchlightAttackAction.resolveAction(this.game));
                continue;
            }
            this.physicalResults.addElement(this.preTreatPhysicalAttack(abstractAttackAction));
        }
        int n = -1;
        object2 = this.physicalResults.elements();
        while (object2.hasMoreElements()) {
            object = (PhysicalResult)object2.nextElement();
            this.resolvePhysicalAttack((PhysicalResult)object, n);
            n = ((PhysicalResult)object).aaa.getEntityId();
        }
        this.physicalResults.removeAllElements();
    }

    private void cleanupPhysicalAttacks() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            this.removeDuplicateAttacks(entity.getId());
        }
        this.removeDeadAttacks();
    }

    private void removeDuplicateAttacks(int n) {
        boolean bl = false;
        Vector<EntityAction> vector = new Vector<EntityAction>();
        Enumeration<EntityAction> enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            EntityAction entityAction = enumeration.nextElement();
            if (entityAction.getEntityId() != n) {
                vector.addElement(entityAction);
                continue;
            }
            if (!bl) {
                vector.addElement(entityAction);
                if (entityAction instanceof SearchlightAttackAction) continue;
                bl = true;
                continue;
            }
            System.err.println("server: removing duplicate phys attack for id#" + n);
            System.err.println("        action was " + entityAction.toString());
        }
        this.game.resetActions();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.game.addAction(enumeration.nextElement());
        }
    }

    private void removeDeadAttacks() {
        Vector<EntityAction> vector = new Vector<EntityAction>(this.game.actionsSize());
        Enumeration<EntityAction> enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            EntityAction entityAction = enumeration.nextElement();
            Entity entity = this.game.getEntity(entityAction.getEntityId());
            if (entity == null || entity.isDestroyed() || !entity.isActive() && !(entityAction instanceof DfaAttackAction)) continue;
            vector.addElement(entityAction);
        }
        this.game.resetActions();
        enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.game.addAction(enumeration.nextElement());
        }
    }

    private void resolvePunchAttack(PhysicalResult physicalResult, int n) {
        int n2;
        Report report;
        PunchAttackAction punchAttackAction = (PunchAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(punchAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(punchAttackAction.getTargetType(), punchAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, punchAttackAction.getEntityId(), entity2);
        }
        String string = punchAttackAction.getArm() == 1 ? "Left Arm" : "Right Arm";
        int n3 = punchAttackAction.getArm() == 1 ? physicalResult.damage : physicalResult.damageRight;
        ToHitData toHitData = punchAttackAction.getArm() == 1 ? physicalResult.toHit : physicalResult.toHitRight;
        int n4 = punchAttackAction.getArm() == 1 ? physicalResult.roll : physicalResult.rollRight;
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n4 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        if (n != punchAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4010);
        report.subject = entity.getId();
        report.indent();
        report.add(string);
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4015);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4020);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.addReport(report);
            n4 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n4);
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n4 < toHitData.getValue()) {
            Report report2;
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            if (bl2 && building != null && n3 > 0 && (report2 = this.damageBuilding(building, n3)) != null) {
                report2.indent();
                report2.subject = entity.getId();
                this.addReport(report2);
            }
            return;
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Report report3 = this.damageBuilding(building, n3);
            if (report3 != null) {
                report3.indent();
                report3.newlines = 1;
                report3.subject = entity.getId();
                this.addReport(report3);
            }
            this.damageInfantryIn(building, n3);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.addReport(report);
        if (bl2 && building != null) {
            n2 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n2, n3);
            n3 -= n5;
            this.addNewLines();
            Report report4 = this.damageBuilding(building, n5);
            if (report4 != null) {
                report4.indent();
                report4.subject = entity.getId();
                this.addReport(report4);
            }
        }
        if (n3 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.addReport(report);
        } else {
            if (bl3) {
                n3 = (int)Math.floor((double)n3 / 2.0);
            }
            if (n3 >= 1 && entity2.hasWorkingMisc(0x400000000L, -1, hitData.getLocation())) {
                report = new Report(4330);
                report.indent(2);
                report.newlines = 0;
                report.subject = entity.getId();
                this.addReport(report);
                this.checkBreakSpikes(entity2, hitData.getLocation());
                n3 = Math.max(1, n3 - 4);
                HitData hitData2 = punchAttackAction.getArm() == 1 ? new HitData(5) : new HitData(4);
                this.addReport(this.damageEntity(entity, hitData2, 2, false, 0, false, false, false));
            }
            n2 = 0;
            if (this.game.getOptions().booleanOption("maxtech_infantry_damage")) {
                n2 = 6;
            }
            this.addReport(this.damageEntity(entity2, hitData, n3, false, n2, false, false, bl));
        }
        this.addNewLines();
    }

    private void resolveKickAttack(PhysicalResult physicalResult, int n) {
        int n2;
        Report report;
        String string;
        KickAttackAction kickAttackAction = (KickAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(kickAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(kickAttackAction.getTargetType(), kickAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, kickAttackAction.getEntityId(), entity2);
        }
        String string2 = string = kickAttackAction.getLeg() == 1 || kickAttackAction.getLeg() == 3 ? "Left " : "Right ";
        if (kickAttackAction.getLeg() == 3 || kickAttackAction.getLeg() == 4) {
            string.concat(" rear ");
        } else {
            string.concat(" front ");
        }
        string.concat("leg");
        int n3 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n4 = physicalResult.roll;
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n4 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        if (n != entity.getId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4055);
        report.subject = entity.getId();
        report.indent();
        report.add(string);
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4060);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a kick"));
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4065);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.addReport(report);
            n4 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n4);
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n4 < toHitData.getValue()) {
            Report report2;
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a kick"));
            if (bl2 && building != null && n3 > 0 && (report2 = this.damageBuilding(building, n3)) != null) {
                report2.indent();
                report2.subject = entity.getId();
                this.addReport(report2);
            }
            return;
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Report report3 = this.damageBuilding(building, n3);
            if (report3 != null) {
                report3.indent();
                report3.subject = entity.getId();
                this.addReport(report3);
            }
            this.damageInfantryIn(building, n3);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.addReport(report);
        if (bl2 && building != null) {
            n2 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n2, n3);
            n3 -= n5;
            this.addNewLines();
            Report report4 = this.damageBuilding(building, n5);
            if (report4 != null) {
                report4.indent();
                report4.subject = entity.getId();
                this.addReport(report4);
            }
        }
        if (n3 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.addReport(report);
        } else {
            if (bl3) {
                n3 = (int)Math.floor((double)n3 / 2.0);
            }
            if (n3 >= 1 && entity2.hasWorkingMisc(0x400000000L, -1, hitData.getLocation())) {
                HitData hitData2;
                report = new Report(4330);
                report.indent(2);
                report.newlines = 0;
                report.subject = entity.getId();
                this.addReport(report);
                this.checkBreakSpikes(entity2, hitData.getLocation());
                n3 = Math.max(1, n3 - 4);
                switch (kickAttackAction.getLeg()) {
                    case 1: {
                        if (entity instanceof QuadMech) {
                            hitData2 = new HitData(5);
                            break;
                        }
                        hitData2 = new HitData(7);
                        break;
                    }
                    case 2: {
                        if (entity instanceof QuadMech) {
                            hitData2 = new HitData(4);
                            break;
                        }
                        hitData2 = new HitData(6);
                        break;
                    }
                    case 3: {
                        hitData2 = new HitData(7);
                        break;
                    }
                    default: {
                        hitData2 = new HitData(6);
                    }
                }
                this.addReport(this.damageEntity(entity, hitData2, 2, false, 0, false, false, false));
            }
            n2 = 0;
            if (this.game.getOptions().booleanOption("maxtech_infantry_damage")) {
                n2 = 6;
            }
            this.addReport(this.damageEntity(entity2, hitData, n3, false, n2, false, false, bl));
        }
        if (entity2.getMovementMode() == 1 || entity2.getMovementMode() == 2) {
            PilotingRollData pilotingRollData = new PilotingRollData(entity2.getId(), this.getKickPushPSRMod(entity, entity2, 0), "was kicked");
            pilotingRollData.setCumulative(false);
            this.game.addPSR(pilotingRollData);
        }
        this.addNewLines();
    }

    private void resolveJumpJetAttack(PhysicalResult physicalResult, int n) {
        Report report;
        JumpJetAttackAction jumpJetAttackAction = (JumpJetAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(jumpJetAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(jumpJetAttackAction.getTargetType(), jumpJetAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, jumpJetAttackAction.getEntityId(), entity2);
        }
        String string = null;
        switch (jumpJetAttackAction.getLeg()) {
            case 1: {
                string = "Left leg";
                break;
            }
            case 2: {
                string = "Right leg";
                break;
            }
            default: {
                string = "Both legs";
            }
        }
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        if (n != entity.getId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4290);
        report.subject = entity.getId();
        report.indent();
        report.add(string);
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4075);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4080);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.addReport(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            Report report2;
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            if (bl2 && building != null && (n2 += physicalResult.damageRight) > 0 && (report2 = this.damageBuilding(building, n2)) != null) {
                report2.indent();
                report2.subject = entity.getId();
                this.addReport(report2);
            }
            return;
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Report report3 = this.damageBuilding(building, n2 += physicalResult.damageRight);
            if (report3 != null) {
                report3.indent();
                report3.subject = entity.getId();
                this.addReport(report3);
            }
            this.damageInfantryIn(building, n2);
            return;
        }
        report = new Report(4040);
        report.subject = entity.getId();
        report.newlines = 0;
        this.addReport(report);
        for (int i = 0; i < 2 && (i != 1 || (n2 = physicalResult.damageRight) != 0); ++i) {
            HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            if (bl2 && building != null) {
                int n4 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
                int n5 = Math.min(n4, n2);
                n2 -= n5;
                this.addNewLines();
                Report report4 = this.damageBuilding(building, n5);
                if (report4 != null) {
                    report4.indent();
                    report4.subject = entity.getId();
                    this.addReport(report4);
                }
            }
            if (n2 == 0) {
                report = new Report(4050);
                report.subject = entity.getId();
                report.add(entity2.getShortName());
                report.add(entity2.getOwner().getName());
                report.newlines = 0;
                this.addReport(report);
                continue;
            }
            if (bl3) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            this.addReport(this.damageEntity(entity2, hitData, n2, false, 0, false, false, bl));
        }
        this.addNewLines();
    }

    private void resolveProtoAttack(PhysicalResult physicalResult, int n) {
        Report report;
        ProtomechPhysicalAttackAction protomechPhysicalAttackAction = (ProtomechPhysicalAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(protomechPhysicalAttackAction.getEntityId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        Targetable targetable = this.game.getTarget(protomechPhysicalAttackAction.getTargetType(), protomechPhysicalAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, protomechPhysicalAttackAction.getEntityId(), entity2);
        }
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        if (n != entity.getId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4070);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4075);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4080);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.addReport(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            Report report2;
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            if (bl2 && building != null && n2 > 0 && (report2 = this.damageBuilding(building, n2)) != null) {
                report2.indent();
                report2.subject = entity.getId();
                this.addReport(report2);
            }
            return;
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Report report3 = this.damageBuilding(building, n2);
            if (report3 != null) {
                report3.indent();
                report3.subject = entity.getId();
                this.addReport(report3);
            }
            this.damageInfantryIn(building, n2);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.addReport(report);
        if (bl2 && building != null) {
            int n4 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n4, n2);
            n2 -= n5;
            this.addNewLines();
            Report report4 = this.damageBuilding(building, n5);
            if (report4 != null) {
                report4.indent();
                report4.subject = entity.getId();
                this.addReport(report4);
            }
        }
        if (n2 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.addReport(report);
        } else {
            if (bl3) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            this.addReport(this.damageEntity(entity2, hitData, n2, false, 0, false, false, bl));
        }
        this.addNewLines();
    }

    private void resolveBrushOffAttack(PhysicalResult physicalResult, int n) {
        Report report;
        int n2;
        String string;
        BrushOffAttackAction brushOffAttackAction = (BrushOffAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(brushOffAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(brushOffAttackAction.getTargetType(), brushOffAttackAction.getTargetId());
        Entity entity2 = null;
        String string2 = string = brushOffAttackAction.getArm() == 1 ? "Left Arm" : "Right Arm";
        if (targetable.getTargetType() == 0) {
            entity2 = this.game.getEntity(brushOffAttackAction.getTargetId());
        }
        int n3 = brushOffAttackAction.getArm() == 1 ? physicalResult.damage : physicalResult.damageRight;
        ToHitData toHitData = brushOffAttackAction.getArm() == 1 ? physicalResult.toHit : physicalResult.toHitRight;
        int n4 = n2 = brushOffAttackAction.getArm() == 1 ? physicalResult.roll : physicalResult.rollRight;
        if (n != brushOffAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4085);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.add(string);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4090);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        report = new Report(4025);
        report.subject = entity.getId();
        report.add(toHitData.getValue());
        report.add(n2);
        report.newlines = 0;
        this.addReport(report);
        if (n2 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            toHitData.setHitTable(1);
            toHitData.setSideTable(0);
            HitData hitData = entity.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            report = new Report(4095);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.getLocationAbbr(hitData));
            report.newlines = 0;
            this.addReport(report);
            this.addReport(this.damageEntity(entity, hitData, n3));
            this.addNewLines();
            return;
        }
        switch (targetable.getTargetType()) {
            case 0: {
                HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
                report = new Report(4045);
                report.subject = entity.getId();
                report.add(toHitData.getTableDesc());
                report.add(entity2.getLocationAbbr(hitData));
                report.newlines = 0;
                this.addReport(report);
                this.addReport(this.damageEntity(entity2, hitData, n3));
                this.addNewLines();
                entity.setSwarmAttackerId(-1);
                entity2.setSwarmTargetId(-1);
                report = new Report(4100);
                report.subject = entity.getId();
                report.add(entity2.getDisplayName());
                this.addReport(report);
                break;
            }
            case 11: {
                entity.removeINarcPod((INarcPod)targetable);
                report = new Report(4105);
                report.subject = entity.getId();
                report.add(targetable.getDisplayName());
                this.addReport(report);
            }
        }
    }

    private void resolveThrashAttack(PhysicalResult physicalResult, int n) {
        Report report;
        ThrashAttackAction thrashAttackAction = (ThrashAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(thrashAttackAction.getEntityId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        boolean bl = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Entity entity2 = this.game.getEntity(thrashAttackAction.getTargetId());
        if (n != thrashAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4110);
        report.subject = entity.getId();
        report.indent();
        report.addDesc(entity2);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4115);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4120);
            report.subject = entity.getId();
            report.newlines = 0;
            this.addReport(report);
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (n3 < toHitData.getValue()) {
                report = new Report(4035);
                report.subject = entity.getId();
                this.addReport(report);
                return;
            }
            report = new Report(4125);
            report.subject = entity.getId();
            report.newlines = 0;
            this.addReport(report);
        }
        if (bl) {
            n2 = (int)Math.floor((double)n2 / 2.0);
        }
        report = new Report(4130);
        report.subject = entity.getId();
        report.add(n2);
        report.newlines = 0;
        this.addReport(report);
        if (bl) {
            report = new Report(4030);
            report.subject = entity.getId();
            report.newlines = 0;
            this.addReport(report);
        }
        while (n2 > 0) {
            int n4 = Math.min(5, n2);
            n2 -= n4;
            HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            report = new Report(4135);
            report.subject = entity.getId();
            report.add(entity2.getLocationAbbr(hitData));
            report.newlines = 0;
            this.addReport(report);
            this.addReport(this.damageEntity(entity2, hitData, n4));
        }
        this.addNewLines();
        PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
        entity.addPilotingModifierForTerrain(pilotingRollData);
        pilotingRollData.addModifier(0, "thrashing at infantry");
        report = new Report(4140);
        report.subject = entity.getId();
        report.addDesc(entity);
        this.addReport(report);
        int n5 = Compute.d6(2);
        report = new Report(2190);
        report.subject = entity.getId();
        report.add(pilotingRollData.getValueAsString());
        report.add(pilotingRollData.getDesc());
        report.add(n5);
        if (n5 < pilotingRollData.getValue()) {
            report.choose(false);
            this.addReport(report);
            this.doEntityFall(entity, pilotingRollData);
        } else {
            report.choose(true);
            this.addReport(report);
        }
    }

    private void resolveClubAttack(PhysicalResult physicalResult, int n) {
        int n2;
        Report report;
        ClubAttackAction clubAttackAction = (ClubAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(clubAttackAction.getEntityId());
        int n3 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n4 = physicalResult.roll;
        Targetable targetable = this.game.getTarget(clubAttackAction.getTargetType(), clubAttackAction.getTargetId());
        Entity entity2 = null;
        if (targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, clubAttackAction.getEntityId(), entity2);
        }
        boolean bl2 = Compute.isInBuilding(this.game, entity2);
        boolean bl3 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n4 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(targetable.getPosition());
        clubAttackAction.getClub().restore();
        if (((MiscType)clubAttackAction.getClub().getType()).isShield()) {
            ((Mech)entity).shieldAbsorptionDamage(1, clubAttackAction.getClub().getLocation(), false);
        }
        if (n != clubAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4145);
        report.subject = entity.getId();
        report.indent();
        report.add(clubAttackAction.getClub().getName());
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if ((((MiscType)clubAttackAction.getClub().getType()).hasSubType(256) || ((MiscType)clubAttackAction.getClub().getType()).hasSubType(131072)) && n4 == 2) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            ToHitData toHitData2 = new ToHitData(Integer.MIN_VALUE, "hit with own flail/wrecking ball");
            physicalResult.damage /= 2;
            toHitData2.setHitTable(0);
            toHitData2.setSideTable(0);
            physicalResult.toHit = toHitData2;
            physicalResult.aaa.setTargetId(entity.getId());
            physicalResult.aaa.setTargetType(0);
            physicalResult.roll = Integer.MAX_VALUE;
            this.resolveClubAttack(physicalResult, entity.getId());
            this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a flail/wrecking ball attack"));
            return;
        }
        if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(0x400000)) {
            n3 = Compute.d6(2);
            entity.heatBuildup += 3;
            if (n4 == 2) {
                Mounted mounted = clubAttackAction.getClub();
                for (Mounted mounted2 : entity.getWeaponList()) {
                    if (mounted2.getLocation() != mounted.getLocation() || !(mounted2.getType() instanceof MiscType) || !((MiscType)mounted2.getType()).hasFlag(0x8000000L) || !((MiscType)mounted2.getType()).hasSubType(0x400000)) continue;
                    mounted2.setDestroyed(true);
                    break;
                }
                report = new Report(4037);
                report.subject = entity.getId();
                this.addReport(report);
                n3 = 0;
                return;
            }
        }
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4075);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(16)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a mace attack"));
            }
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(64)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 2, "missed a mace attack"));
            }
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4080);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            report.newlines = 0;
            this.addReport(report);
            n4 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n4);
            report.newlines = 0;
            this.addReport(report);
            if (bl3) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n4 < toHitData.getValue()) {
            Report report2;
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(16)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 0, "missed a mace attack"));
            }
            if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(64)) {
                this.game.addPSR(new PilotingRollData(entity.getId(), 2, "missed a mace attack"));
            }
            if (bl2 && building != null && n3 > 0 && (report2 = this.damageBuilding(building, n3)) != null) {
                report2.indent();
                report2.subject = entity.getId();
                this.addReport(report2);
            }
            return;
        }
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Report report3 = this.damageBuilding(building, n3);
            if (report3 != null) {
                report3.indent();
                report3.subject = entity.getId();
                this.addReport(report3);
            }
            this.damageInfantryIn(building, n3);
            return;
        }
        HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
        report = new Report(4045);
        report.subject = entity.getId();
        report.add(toHitData.getTableDesc());
        report.add(entity2.getLocationAbbr(hitData));
        report.newlines = 0;
        this.addReport(report);
        if (bl2 && building != null) {
            n2 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
            int n5 = Math.min(n2, n3);
            n3 -= n5;
            this.addNewLines();
            Report report4 = this.damageBuilding(building, n5);
            if (report4 != null) {
                report4.indent();
                report4.subject = entity.getId();
                this.addReport(report4);
            }
        }
        if (n3 == 0) {
            report = new Report(4050);
            report.subject = entity.getId();
            report.add(entity2.getShortName());
            report.add(entity2.getOwner().getName());
            report.newlines = 0;
            this.addReport(report);
        } else {
            if (bl3) {
                n3 = (int)Math.floor((double)n3 / 2.0);
            }
            if (n3 >= 1 && entity2.hasWorkingMisc(0x400000000L, -1, hitData.getLocation())) {
                report = new Report(4330);
                report.indent(2);
                report.newlines = 0;
                report.subject = entity.getId();
                this.addReport(report);
                this.checkBreakSpikes(entity2, hitData.getLocation());
                n3 = Math.max(1, n3 - 4);
                n2 = clubAttackAction.getClub().getLocation();
                if (n2 == -1) {
                    this.addReport(this.damageEntity(entity, new HitData(5), 1, false, 0, false, false, false));
                    this.addReport(this.damageEntity(entity, new HitData(4), 1, false, 0, false, false, false));
                } else {
                    this.addReport(this.damageEntity(entity, new HitData(n2), 2, false, 0, false, false, false));
                }
            }
            n2 = 0;
            if (this.game.getOptions().booleanOption("maxtech_infantry_damage")) {
                n2 = 6;
            }
            this.addReport(this.damageEntity(entity2, hitData, n3, false, n2, false, false, bl));
        }
        if (entity2 != null && ((MiscType)clubAttackAction.getClub().getType()).hasSubType(8192) && entity2.getArmor(hitData) > 0 && entity2.getArmorType() != 4) {
            n4 = Compute.d6(2);
            report = new Report(4021);
            report.indent(2);
            report.subject = entity.getId();
            report.add(entity2.getLocationAbbr(hitData));
            report.add(n4);
            report.newlines = 1;
            this.addReport(report);
            if (n4 >= 10) {
                hitData.makeGlancingBlow();
                this.addReport(this.damageEntity(entity2, hitData, 1, false, 0, true, false, bl));
            }
        }
        this.addNewLines();
        if (((MiscType)clubAttackAction.getClub().getType()).hasSubType(2)) {
            report = new Report(4150);
            report.subject = entity.getId();
            report.add(clubAttackAction.getClub().getName());
            this.addReport(report);
            entity.removeMisc(clubAttackAction.getClub().getName());
        }
    }

    private void resolvePushAttack(PhysicalResult physicalResult, int n) {
        Serializable serializable;
        Report report;
        PushAttackAction pushAttackAction = (PushAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(pushAttackAction.getEntityId());
        Entity entity2 = this.game.getEntity(pushAttackAction.getTargetId());
        int n2 = physicalResult.roll;
        ToHitData toHitData = physicalResult.toHit;
        if (physicalResult.pushBackResolved) {
            return;
        }
        physicalResult.pushBackResolved = true;
        if (n != pushAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4155);
        report.subject = entity.getId();
        report.indent();
        report.addDesc(entity2);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4160);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        report = new Report(4025);
        report.subject = entity.getId();
        report.add(toHitData.getValue());
        report.add(n2);
        report.newlines = 0;
        this.addReport(report);
        Serializable serializable2 = null;
        Object object = this.physicalResults.elements();
        while (object.hasMoreElements()) {
            serializable = object.nextElement();
            if (((PhysicalResult)serializable).aaa.getEntityId() != entity2.getId() || !(((PhysicalResult)serializable).aaa instanceof PushAttackAction) || ((PhysicalResult)serializable).aaa.getTargetId() != entity.getId()) continue;
            serializable2 = serializable;
        }
        if (serializable2 != null && !((PhysicalResult)serializable2).pushBackResolved && n2 >= toHitData.getValue()) {
            ((PhysicalResult)serializable2).pushBackResolved = true;
            if (((PhysicalResult)serializable2).roll >= ((PhysicalResult)serializable2).toHit.getValue()) {
                report = new Report(4165);
                report.subject = entity.getId();
                report.addDesc(entity2);
                report.addDesc(entity2);
                report.addDesc(entity);
                report.add(((PhysicalResult)serializable2).toHit.getValue());
                report.add(((PhysicalResult)serializable2).roll);
                report.addDesc(entity);
                this.addReport(report);
                object = new PilotingRollData(entity2.getId(), this.getKickPushPSRMod(entity, entity2, 0), "was pushed");
                ((PilotingRollData)object).setCumulative(false);
                serializable = new PilotingRollData(entity.getId(), this.getKickPushPSRMod(entity, entity2, 0), "was pushed");
                ((PilotingRollData)serializable).setCumulative(false);
                this.game.addPSR((PilotingRollData)serializable);
                this.game.addPSR((PilotingRollData)object);
                return;
            }
            report = new Report(4166);
            report.subject = entity.getId();
            report.addDesc(entity2);
            report.addDesc(entity);
            report.add(((PhysicalResult)serializable2).toHit.getValue());
            report.add(((PhysicalResult)serializable2).roll);
            this.addReport(report);
        }
        if (n2 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            return;
        }
        int n3 = entity.getFacing();
        serializable = entity2.getPosition();
        Coords coords = ((Coords)serializable).translated(n3);
        PilotingRollData pilotingRollData = new PilotingRollData(entity2.getId(), this.getKickPushPSRMod(entity, entity2, 0), "was pushed");
        pilotingRollData.setCumulative(false);
        if (Compute.isValidDisplacement(this.game, entity2.getId(), entity2.getPosition(), n3)) {
            report = new Report(4170);
            report.subject = entity.getId();
            report.newlines = 0;
            this.addReport(report);
            if (this.game.getBoard().contains(coords)) {
                report = new Report(4175);
                report.subject = entity.getId();
                report.add(coords.getBoardNum(), true);
                this.addReport(report);
            } else {
                report = new Report(4180);
                report.subject = entity.getId();
                this.addReport(report);
            }
            this.doEntityDisplacement(entity2, (Coords)serializable, coords, pilotingRollData);
            if (!entity2.getPosition().equals(serializable)) {
                entity.setPosition((Coords)serializable);
            }
        } else {
            report = new Report(4185);
            report.subject = entity.getId();
            this.addReport(report);
            this.game.addPSR(pilotingRollData);
        }
        this.addNewLines();
    }

    private void resolveTripAttack(PhysicalResult physicalResult, int n) {
        Report report;
        TripAttackAction tripAttackAction = (TripAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(tripAttackAction.getEntityId());
        Entity entity2 = this.game.getEntity(tripAttackAction.getTargetId());
        int n2 = physicalResult.roll;
        ToHitData toHitData = physicalResult.toHit;
        if (n != tripAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        report = new Report(4280);
        report.subject = entity.getId();
        report.indent();
        report.addDesc(entity2);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4285);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        report = new Report(4025);
        report.subject = entity.getId();
        report.add(toHitData.getValue());
        report.add(n2);
        report.newlines = 0;
        this.addReport(report);
        if (n2 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            return;
        }
        PilotingRollData pilotingRollData = new PilotingRollData(entity2.getId(), this.getKickPushPSRMod(entity, entity2, 0), "was tripped");
        pilotingRollData.setCumulative(false);
        this.game.addPSR(pilotingRollData);
        report = new Report(4040);
        report.subject = entity.getId();
        this.addReport(report);
        this.addNewLines();
    }

    private void resolveGrappleAttack(PhysicalResult physicalResult, int n) {
        Report report;
        GrappleAttackAction grappleAttackAction = (GrappleAttackAction)physicalResult.aaa;
        Mech mech = (Mech)this.game.getEntity(grappleAttackAction.getEntityId());
        Mech mech2 = (Mech)this.game.getEntity(grappleAttackAction.getTargetId());
        int n2 = physicalResult.roll;
        ToHitData toHitData = physicalResult.toHit;
        if (physicalResult.pushBackResolved) {
            return;
        }
        if (mech2.getGrappled() != -1 || mech.getGrappled() != -1) {
            toHitData.addModifier(Integer.MAX_VALUE, "Already Grappled");
        }
        if (n != grappleAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = mech.getId();
            report.addDesc(mech);
            this.addReport(report);
        }
        report = new Report(4295);
        report.subject = mech.getId();
        report.indent();
        report.addDesc(mech2);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4300);
            report.subject = mech.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        report = new Report(4025);
        report.subject = mech.getId();
        report.add(toHitData.getValue());
        report.add(n2);
        report.newlines = 0;
        this.addReport(report);
        if (n2 < toHitData.getValue()) {
            report = new Report(4035);
            report.subject = mech.getId();
            this.addReport(report);
            return;
        }
        mech.setGrappled(mech2.getId(), true);
        mech2.setGrappled(mech.getId(), false);
        Coords coords = mech2.getPosition();
        mech.setPosition(coords);
        mech.setElevation(mech2.getElevation());
        mech2.setFacing((mech.getFacing() + 3) % 6);
        this.doSetLocationsExposure(mech, this.game.getBoard().getHex(coords), false, mech.getElevation());
        report = new Report(4040);
        report.subject = mech.getId();
        this.addReport(report);
        this.addNewLines();
    }

    private void resolveBreakGrappleAttack(PhysicalResult physicalResult, int n) {
        Object object;
        Object object2;
        Report report;
        BreakGrappleAttackAction breakGrappleAttackAction = (BreakGrappleAttackAction)physicalResult.aaa;
        Mech mech = (Mech)this.game.getEntity(breakGrappleAttackAction.getEntityId());
        Mech mech2 = (Mech)this.game.getEntity(breakGrappleAttackAction.getTargetId());
        int n2 = physicalResult.roll;
        ToHitData toHitData = physicalResult.toHit;
        if (n != breakGrappleAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = mech.getId();
            report.addDesc(mech);
            this.addReport(report);
        }
        report = new Report(4305);
        report.subject = mech.getId();
        report.indent();
        report.addDesc(mech2);
        report.newlines = 0;
        this.addReport(report);
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            report = new Report(4310);
            report.subject = mech.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            return;
        }
        if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4320);
            report.subject = mech.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else {
            report = new Report(4025);
            report.subject = mech.getId();
            report.add(toHitData.getValue());
            report.add(n2);
            report.newlines = 0;
            this.addReport(report);
            if (n2 < toHitData.getValue()) {
                report = new Report(4035);
                report.subject = mech.getId();
                this.addReport(report);
                return;
            }
            report = new Report(4040);
            report.subject = mech.getId();
            this.addReport(report);
        }
        Object object3 = null;
        Coords[] coordsArray = this.physicalResults.elements();
        while (coordsArray.hasMoreElements()) {
            object2 = coordsArray.nextElement();
            if (((PhysicalResult)object2).aaa.getEntityId() != mech2.getId() || !(((PhysicalResult)object2).aaa instanceof GrappleAttackAction) || ((PhysicalResult)object2).aaa.getTargetId() != mech.getId()) continue;
            object3 = object2;
            break;
        }
        if (object3 != null) {
            ((PhysicalResult)object3).pushBackResolved = true;
            report = new Report(4315);
            report.subject = mech2.getId();
            report.newlines = 0;
            report.addDesc(mech2);
            this.addReport(report);
            report = new Report(4025);
            report.subject = mech2.getId();
            report.add(((PhysicalResult)object3).toHit.getValue());
            report.add(((PhysicalResult)object3).roll);
            report.newlines = 0;
            this.addReport(report);
            if (n2 < toHitData.getValue()) {
                report = new Report(4035);
                report.subject = mech.getId();
                this.addReport(report);
            } else {
                report = new Report(4040);
                report.subject = mech.getId();
                this.addReport(report);
                mech.setGrappled(mech2.getId(), false);
                mech2.setGrappled(mech.getId(), true);
                return;
            }
        }
        coordsArray = new Coords[6];
        object2 = new int[6];
        IHex iHex = this.game.getBoard().getHex(mech.getPosition());
        for (object = 0; object < 6; ++object) {
            coordsArray[object] = mech.getPosition().translated((int)object);
            object2[object] = false;
            IHex iHex2 = this.game.getBoard().getHex(coordsArray[object]);
            if (iHex2.containsTerrain(24)) {
                Object object4 = object2;
                Object object5 = object;
                object4[object5] = object4[object5] + 10;
            }
            if (iHex2.containsTerrain(4)) {
                Object object6 = object2;
                Object object7 = object;
                object6[object7] = object6[object7] + iHex2.terrainLevel(4);
            }
            if (iHex.surface() - iHex2.surface() < 2) continue;
            Object object8 = object2;
            Object object9 = object;
            object8[object9] = object8[object9] + 2 * (iHex.surface() - iHex2.surface());
        }
        object = 99999;
        int n3 = 0;
        Object object10 = -99999;
        int n4 = 0;
        for (int i = 0; i < 6; ++i) {
            if (object > object2[i]) {
                n3 = i;
                object = object2[i];
            }
            if (object10 >= object2[i]) continue;
            n4 = i;
            object10 = object2[i];
        }
        if (mech.isGrappleAttacker()) {
            PilotingRollData pilotingRollData = mech.getBasePilotingRoll();
            pilotingRollData.addModifier(Integer.MIN_VALUE, "break grapple");
            this.doEntityDisplacement(mech, mech.getPosition(), coordsArray[n3], pilotingRollData);
            mech.setFacing(coordsArray[n3].direction(mech2.getPosition()));
        } else {
            PilotingRollData pilotingRollData = mech2.getBasePilotingRoll();
            pilotingRollData.addModifier(Integer.MIN_VALUE, "break grapple");
            this.doEntityDisplacement(mech2, mech2.getPosition(), coordsArray[n4], pilotingRollData);
            mech2.setFacing(coordsArray[n4].direction(mech.getPosition()));
        }
        mech.setGrappled(-1, false);
        mech2.setGrappled(-1, false);
        this.addNewLines();
    }

    private void resolveChargeAttack(PhysicalResult physicalResult, int n) {
        Report report;
        ChargeAttackAction chargeAttackAction = (ChargeAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(chargeAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(chargeAttackAction.getTargetType(), chargeAttackAction.getTargetId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        Entity entity2 = null;
        if (targetable != null && targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, chargeAttackAction.getEntityId(), entity2);
        }
        boolean bl2 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(chargeAttackAction.getTargetPos());
        if (entity == null) {
            return;
        }
        int n4 = entity.getFacing();
        entity.setDisplacementAttack(null);
        if (n != chargeAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        if (targetable == null || targetable.getTargetType() == 0 && (entity2.isDestroyed() || entity2.isDoomed() || entity2.crew.isDead())) {
            report = new Report(4190);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            return;
        }
        if (entity.isProne()) {
            report = new Report(4195);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            return;
        }
        if (entity.isImmobile()) {
            report = new Report(4200);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            return;
        }
        if (entity2 != null && entity2.isProne() && entity instanceof Mech) {
            report = new Report(4205);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            return;
        }
        report = new Report(4210);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (!targetable.getPosition().equals(chargeAttackAction.getTargetPos())) {
            report = new Report(4215);
            report.subject = entity.getId();
            this.addReport(report);
            this.doEntityDisplacement(entity, entity.getPosition(), chargeAttackAction.getTargetPos(), null);
            return;
        }
        if (toHitData.getValue() == Integer.MAX_VALUE) {
            n3 = -12;
            report = new Report(4220);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else if (toHitData.getValue() == Integer.MIN_VALUE) {
            n3 = Integer.MAX_VALUE;
            report = new Report(4225);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (bl2) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            Coords coords = entity.getPosition();
            Coords coords2 = Compute.getMissedChargeDisplacement(this.game, entity.getId(), coords, n4);
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            this.doEntityDisplacement(entity, coords, coords2, null);
        } else if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            report = new Report(4040);
            report.subject = entity.getId();
            this.addReport(report);
            Report report2 = this.damageBuilding(building, n2);
            if (report2 != null) {
                report2.indent();
                report2.subject = entity.getId();
                this.addReport(report2);
            }
            this.damageInfantryIn(building, n2);
            int n5 = ChargeAttackAction.getDamageTakenBy(entity, building);
            HitData hitData = entity.rollHitLocation(0, entity.sideTable(targetable.getPosition()));
            this.addReport(this.damageEntity(entity, hitData, n5, false, 0, false, false, bl));
            this.addNewLines();
            this.entityUpdate(entity.getId());
        } else {
            this.resolveChargeDamage(entity, entity2, toHitData, n4, bl2, bl);
        }
    }

    private void resolveChargeDamage(Entity entity, Entity entity2, ToHitData toHitData, int n) {
        this.resolveChargeDamage(entity, entity2, toHitData, n, false, true);
    }

    private void resolveChargeDamage(Entity entity, Entity entity2, ToHitData toHitData, int n, boolean bl, boolean bl2) {
        int n2 = ChargeAttackAction.getDamageFor(entity);
        int n3 = ChargeAttackAction.getDamageTakenBy(entity, entity2, this.game.getOptions().booleanOption("maxtech_charge_damage"));
        PilotingRollData pilotingRollData = null;
        if (bl) {
            n2 = (int)Math.floor((double)n2 / 2.0);
            n3 = (int)Math.floor((double)n3 / 2.0);
        }
        boolean bl3 = Compute.isInBuilding(this.game, entity2);
        Building building = this.game.getBoard().getBuildingAt(entity2.getPosition());
        int n4 = 0;
        if (bl3 && building != null) {
            n4 = (int)Math.ceil((double)building.getPhaseCF() / 10.0);
        }
        if (!entity.isProne()) {
            pilotingRollData = new PilotingRollData(entity.getId(), 2, "charging");
        }
        Report report = new Report(4240);
        report.subject = entity.getId();
        report.add(n3);
        report.newlines = 0;
        this.addReport(report);
        int[] nArray = new int[entity.locations()];
        for (int i = 0; i < entity.locations(); ++i) {
            nArray[i] = 0;
        }
        for (Mounted mounted : entity.getMisc()) {
            if (mounted.getLocation() == -1 || !mounted.getType().hasFlag(0x400000000L)) continue;
            nArray[mounted.getLocation()] = 1;
        }
        int n5 = 0;
        while (n3 > 0) {
            int n6 = Math.min(5, n3);
            HitData object = entity.rollHitLocation(toHitData.getHitTable(), entity.sideTable(entity2.getPosition()));
            if (nArray[object.getLocation()] == 1) {
                report = new Report(4335);
                report.indent(2);
                report.newlines = 0;
                report.subject = entity.getId();
                this.addReport(report);
                nArray[object.getLocation()] = 0;
                this.checkBreakSpikes(entity, object.getLocation());
                n5 += 2;
            }
            this.addReport(this.damageEntity(entity, object, n6, false, 0, false, false, bl2));
            n3 -= n6;
        }
        report = new Report(4230);
        report.subject = entity.getId();
        report.add(n2 += n5);
        report.add(toHitData.getTableDesc());
        report.newlines = 0;
        this.addReport(report);
        nArray = new int[entity2.locations()];
        for (int i = 0; i < entity2.locations(); ++i) {
            nArray[i] = 0;
        }
        for (Mounted hitData : entity2.getMisc()) {
            if (hitData.getLocation() == -1 || !hitData.getType().hasFlag(0x400000000L)) continue;
            nArray[hitData.getLocation()] = 1;
        }
        n5 = 0;
        while (n2 > 0) {
            int n7 = Math.min(5, n2);
            n2 -= n7;
            if (n4 > 0) {
                int coords2 = Math.min(n4, n7);
                n7 -= coords2;
                this.addNewLines();
                Report report2 = this.damageBuilding(building, coords2);
                if (report2 != null) {
                    report2.indent();
                    report2.subject = entity.getId();
                    this.addReport(report2);
                }
            }
            if (n7 == 0) {
                report = new Report(4235);
                report.subject = entity.getId();
                report.addDesc(entity2);
                report.newlines = 0;
                this.addReport(report);
                continue;
            }
            HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
            if (nArray[hitData.getLocation()] == 1) {
                report = new Report(4330);
                report.indent(2);
                report.newlines = 0;
                report.subject = entity.getId();
                this.addReport(report);
                nArray[hitData.getLocation()] = 0;
                this.checkBreakSpikes(entity2, hitData.getLocation());
                n7 = 1;
                n5 += 2;
            }
            this.addReport(this.damageEntity(entity2, hitData, n7, false, 0, false, false, bl2));
        }
        if (entity instanceof Mech) {
            this.addReport(this.damageEntity(entity, new HitData(1), n5, false, 0, false, false, bl2));
        } else if (entity instanceof Tank) {
            this.addReport(this.damageEntity(entity, new HitData(1), n5, false, 0, false, false, bl2));
        }
        Coords coords = entity2.getPosition();
        Coords coords2 = coords.translated(n);
        if (Compute.isValidDisplacement(this.game, entity2.getId(), entity2.getPosition(), n)) {
            this.addNewLines();
            this.doEntityDisplacement(entity2, coords, coords2, new PilotingRollData(entity2.getId(), 2, "was charged"));
            this.doEntityDisplacement(entity, entity.getPosition(), coords, pilotingRollData);
        }
        this.addNewLines();
    }

    private void resolveLayExplosivesAttack(PhysicalResult physicalResult, int n) {
        LayExplosivesAttackAction layExplosivesAttackAction = (LayExplosivesAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(layExplosivesAttackAction.getEntityId());
        if (entity instanceof Infantry) {
            Infantry infantry = (Infantry)entity;
            if (infantry.turnsLayingExplosives < 0) {
                infantry.turnsLayingExplosives = 0;
                Report report = new Report(4270);
                report.subject = infantry.getId();
                report.addDesc(infantry);
                this.addReport(report);
            } else {
                Building building = this.game.getBoard().getBuildingAt(entity.getPosition());
                if (building != null) {
                    building.addDemolitionCharge(entity.getOwner().getId(), physicalResult.damage);
                    Report report = new Report(4275);
                    report.subject = infantry.getId();
                    report.addDesc(infantry);
                    report.add(physicalResult.damage);
                    this.addReport(report);
                }
                infantry.turnsLayingExplosives = -1;
            }
        }
    }

    private void resolveDfaAttack(PhysicalResult physicalResult, int n) {
        Object object;
        Report report;
        DfaAttackAction dfaAttackAction = (DfaAttackAction)physicalResult.aaa;
        Entity entity = this.game.getEntity(dfaAttackAction.getEntityId());
        Targetable targetable = this.game.getTarget(dfaAttackAction.getTargetType(), dfaAttackAction.getTargetId());
        int n2 = physicalResult.damage;
        ToHitData toHitData = physicalResult.toHit;
        int n3 = physicalResult.roll;
        Entity entity2 = null;
        if (targetable != null && targetable.getTargetType() == 0) {
            entity2 = (Entity)targetable;
            IHex iHex = this.game.getBoard().getHex(entity2.getPosition());
            if (iHex.containsTerrain(4) && entity2.absHeight() < iHex.getElevation()) {
                n2 = (int)Math.ceil((float)n2 * 0.5f);
            }
        }
        boolean bl = true;
        if (entity2 != null) {
            bl = Compute.isThroughFrontHex(this.game, dfaAttackAction.getEntityId(), entity2);
        }
        boolean bl2 = this.game.getOptions().booleanOption("maxtech_glancing_blows") && n3 == toHitData.getValue();
        Building building = this.game.getBoard().getBuildingAt(dfaAttackAction.getTargetPos());
        if (entity == null) {
            return;
        }
        int n4 = entity.getFacing();
        if (n != dfaAttackAction.getEntityId()) {
            report = new Report(4005);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
        }
        entity.setDisplacementAttack(null);
        if (targetable == null || targetable.getTargetType() == 0 && (entity2.isDestroyed() || entity2.isDoomed() || entity2.crew.isDead())) {
            report = new Report(4245);
            report.subject = entity.getId();
            report.indent();
            this.addReport(report);
            if (entity.isProne()) {
                this.doEntityFall(entity, dfaAttackAction.getTargetPos(), 2, 3, entity.getBasePilotingRoll());
            } else {
                this.doEntityDisplacement(entity, entity.getPosition(), dfaAttackAction.getTargetPos(), new PilotingRollData(entity.getId(), 4, "executed death from above"));
            }
            return;
        }
        report = new Report(4246);
        report.subject = entity.getId();
        report.indent();
        report.add(targetable.getDisplayName());
        report.newlines = 0;
        this.addReport(report);
        if (!targetable.getPosition().equals(dfaAttackAction.getTargetPos())) {
            report = new Report(4215);
            report.subject = entity.getId();
            this.addReport(report);
            this.doEntityFallsInto(entity, entity.getPosition(), dfaAttackAction.getTargetPos(), entity.getBasePilotingRoll());
            return;
        }
        if (entity.isProne() || !entity.isActive()) {
            n3 = -12;
            report = new Report(4250);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else if (toHitData.getValue() == Integer.MAX_VALUE) {
            n3 = -12;
            report = new Report(4255);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
        } else if (toHitData.getValue() == Integer.MIN_VALUE) {
            report = new Report(4260);
            report.subject = entity.getId();
            report.add(toHitData.getDesc());
            this.addReport(report);
            n3 = Integer.MAX_VALUE;
        } else {
            report = new Report(4025);
            report.subject = entity.getId();
            report.add(toHitData.getValue());
            report.add(n3);
            report.newlines = 0;
            this.addReport(report);
            if (bl2) {
                report = new Report(4030);
                report.subject = entity.getId();
                report.newlines = 0;
                this.addReport(report);
            }
        }
        if (n3 < toHitData.getValue()) {
            Coords coords = entity2.getPosition();
            Coords coords2 = Compute.getPreferredDisplacement(this.game, entity2.getId(), coords, n4);
            report = new Report(4035);
            report.subject = entity.getId();
            this.addReport(report);
            if (coords2 != null) {
                report = new Report(4265);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(coords.getBoardNum(), true);
                this.addReport(report);
                this.doEntityFall(entity, coords, 2, 3, entity.getBasePilotingRoll());
                this.doEntityDisplacement(entity2, coords, coords2, null);
            } else {
                this.addReport(this.destroyEntity(entity, "impossible displacement", entity instanceof Mech, entity instanceof Mech));
            }
            return;
        }
        int n5 = DfaAttackAction.getDamageTakenBy(entity);
        report = new Report(4040);
        report.subject = entity.getId();
        this.addReport(report);
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            object = this.damageBuilding(building, n2);
            if (object != null) {
                ((Report)object).indent();
                ((Report)object).subject = entity.getId();
                this.addReport((Report)object);
            }
            this.damageInfantryIn(building, n2);
        } else {
            if (bl2) {
                n2 = (int)Math.floor((double)n2 / 2.0);
            }
            report = new Report(4230);
            report.subject = entity.getId();
            report.add(n2);
            report.add(toHitData.getTableDesc());
            report.newlines = 0;
            this.addReport(report);
            object = new int[entity2.locations()];
            for (int i = 0; i < entity2.locations(); ++i) {
                object[i] = false;
            }
            for (Mounted mounted : entity2.getMisc()) {
                if (mounted.getLocation() == -1 || !mounted.getType().hasFlag(0x400000000L)) continue;
                object[mounted.getLocation()] = true;
            }
            int n6 = 0;
            while (n2 > 0) {
                int n7 = Math.min(5, n2);
                HitData hitData = entity2.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
                if (object[hitData.getLocation()] == true) {
                    report = new Report(4330);
                    report.indent(2);
                    report.newlines = 0;
                    report.subject = entity.getId();
                    this.addReport(report);
                    n7 = 1;
                    object[hitData.getLocation()] = false;
                    this.checkBreakSpikes(entity2, hitData.getLocation());
                    n6 += 2;
                }
                this.addReport(this.damageEntity(entity2, hitData, n7, false, 0, false, false, bl));
                n2 -= 5;
            }
            if (n6 > 0) {
                if (entity instanceof QuadMech) {
                    this.addReport(this.damageEntity(entity, new HitData(5), (n6 + 2) / 4, false, 0, false, false, false));
                    this.addReport(this.damageEntity(entity, new HitData(4), (n6 + 2) / 4, false, 0, false, false, false));
                    if (n6 > 2) {
                        this.addReport(this.damageEntity(entity, new HitData(7), n6 / 4, false, 0, false, false, false));
                        this.addReport(this.damageEntity(entity, new HitData(6), n6 / 4, false, 0, false, false, false));
                    }
                } else {
                    this.addReport(this.damageEntity(entity, new HitData(7), n6 / 2, false, 0, false, false, false));
                    this.addReport(this.damageEntity(entity, new HitData(6), n6 / 2, false, 0, false, false, false));
                }
            }
        }
        if (bl2) {
            n5 = (int)Math.floor((double)n5 / 2.0);
        }
        report = new Report(4240);
        report.subject = entity.getId();
        report.add(n5);
        report.newlines = 0;
        this.addReport(report);
        while (n5 > 0) {
            int n8 = Math.min(5, n5);
            HitData hitData = entity.rollHitLocation(2, 0);
            this.addReport(this.damageEntity(entity, hitData, n8));
            n5 -= n8;
        }
        this.addNewLines();
        if (targetable.getTargetType() == 3 || targetable.getTargetType() == 15) {
            return;
        }
        Coords coords = entity2.getPosition();
        Coords coords3 = Compute.getValidDisplacement(this.game, entity2.getId(), coords, n4);
        if (coords3 != null) {
            this.doEntityDisplacement(entity2, coords, coords3, new PilotingRollData(entity2.getId(), 2, "hit by death from above"));
        } else {
            this.addReport(this.destroyEntity(entity2, "impossible displacement", entity2 instanceof Mech, entity2 instanceof Mech));
        }
        this.doEntityDisplacement(entity, coords, coords, new PilotingRollData(entity.getId(), 4, "executed death from above"));
    }

    private int getKickPushPSRMod(Entity entity, Entity entity2, int n) {
        int n2 = n;
        if (this.game.getOptions().booleanOption("maxtech_physical_psr")) {
            int n3 = 0;
            int n4 = 0;
            switch (entity.getWeightClass()) {
                case 0: {
                    n3 = 1;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
                case 2: {
                    n3 = 3;
                    break;
                }
                case 3: {
                    n3 = 4;
                }
            }
            switch (entity2.getWeightClass()) {
                case 0: {
                    n4 = 1;
                    break;
                }
                case 1: {
                    n4 = 2;
                    break;
                }
                case 2: {
                    n4 = 3;
                    break;
                }
                case 3: {
                    n4 = 4;
                }
            }
            n2 = n3 - n4;
        }
        return n2;
    }

    private void resolveHeat() {
        this.addReport(new Report(5000, 0));
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            int n;
            int n2;
            boolean bl;
            boolean bl2;
            int n3;
            Report report;
            int n4;
            Entity entity = enumeration.nextElement();
            if (null == entity.getPosition()) continue;
            IHex iHex = this.game.getBoard().getHex(entity.getPosition());
            if (!(entity instanceof Mech)) {
                entity.heatBuildup = 0;
                entity.heatFromExternal = 0;
                if (this.game.getOptions().booleanOption("vehicle_fires") && entity instanceof Tank) {
                    this.resolveVehicleFire((Tank)entity, true);
                    continue;
                }
                if (!entity.infernos.isStillBurning()) continue;
                this.doFlamingDeath(entity);
                continue;
            }
            if (entity.infernos.isStillBurning()) {
                n4 = entity.infernos.getHeat();
                entity.heatFromExternal += n4;
                report = new Report(5010);
                report.subject = entity.getId();
                report.add(n4);
                this.addReport(report);
            }
            if (entity.isDestroyed() || entity.isDoomed() || entity.crew.isDoomed() || entity.crew.isDead()) continue;
            entity.heatBuildup += entity.getEngineCritHeat();
            if (entity instanceof Mech && entity.isStealthActive()) {
                entity.heatBuildup += 10;
                report = new Report(5015);
                report.subject = entity.getId();
                this.addReport(report);
            }
            if (entity instanceof Mech && this.game.getTemperatureDifference() != 0 && !((Mech)entity).hasLaserHeatSinks()) {
                if (this.game.getOptions().intOption("temperature") > 50) {
                    entity.heatFromExternal += this.game.getTemperatureDifference();
                    report = new Report(5020);
                    report.subject = entity.getId();
                    report.add(this.game.getTemperatureDifference());
                    this.addReport(report);
                } else {
                    entity.heatFromExternal -= this.game.getTemperatureDifference();
                    report = new Report(5025);
                    report.subject = entity.getId();
                    report.add(this.game.getTemperatureDifference());
                    this.addReport(report);
                }
            }
            if (iHex != null) {
                if (iHex.terrainLevel(7) == 2 && entity.getElevation() <= 1) {
                    entity.heatFromExternal += 5;
                    report = new Report(5030);
                    report.subject = entity.getId();
                    this.addReport(report);
                }
                if ((n4 = iHex.terrainLevel(24)) > 0 && entity.getElevation() == 0) {
                    entity.heatFromExternal += 5 * n4;
                    report = new Report(5032);
                    report.subject = entity.getId();
                    report.add(5 * n4);
                    this.addReport(report);
                }
            }
            if (entity.hasVibroblades()) {
                n4 = 0;
                n4 = entity.getActiveVibrobladeHeat(4);
                if ((n4 += entity.getActiveVibrobladeHeat(5)) > 0) {
                    report = new Report(5017);
                    report.subject = entity.getId();
                    report.add(n4);
                    this.addReport(report);
                    entity.heatBuildup += n4;
                }
            }
            entity.heatBuildup += Math.min(15, entity.heatFromExternal);
            entity.heatFromExternal = 0;
            if (entity.heatBuildup < 0) {
                entity.heatBuildup = 0;
            }
            entity.heat += entity.heatBuildup;
            n4 = entity.getHeatCapacityWithWater();
            int n5 = entity.hasInfernoAmmo() ? 9 : 13;
            int n6 = ((Mech)entity).getNumberOfSinks();
            for (Mounted mounted : entity.getEquipment()) {
                AmmoType ammoType;
                if (!(mounted.getType() instanceof AmmoType) || (ammoType = (AmmoType)mounted.getType()).getAmmoType() != 37 || !mounted.isAmmoUsable()) continue;
                EquipmentMode equipmentMode = mounted.curMode();
                if (equipmentMode.equals("dump")) {
                    report = new Report(5260);
                    report.subject = entity.getId();
                    this.addReport(report);
                    mounted.setShotsLeft(0);
                    n4 += n6;
                    break;
                }
                if (equipmentMode.equals("safe") && entity.heat - n4 > n5) {
                    report = new Report(5265);
                    report.subject = entity.getId();
                    this.addReport(report);
                    mounted.setShotsLeft(0);
                    n4 += n6;
                    break;
                }
                if (!equipmentMode.equals("efficient") || entity.heat - n4 < n6) continue;
                report = new Report(5270);
                report.subject = entity.getId();
                this.addReport(report);
                mounted.setShotsLeft(0);
                n4 += n6;
                break;
            }
            n4 = Math.min(n4, entity.heat);
            entity.heat -= n4;
            report = new Report(5035);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.heatBuildup);
            report.add(n4);
            report.add(entity.heat);
            this.addReport(report);
            entity.heatBuildup = 0;
            if (entity.hasInfernoAmmo() && entity.heat >= 10) {
                int n7 = 4 + (entity.heat >= 14 ? 2 : 0) + (entity.heat >= 19 ? 2 : 0) + (entity.heat >= 23 ? 2 : 0) + (entity.heat >= 28 ? 2 : 0);
                int n8 = Compute.d6(2);
                report = new Report(5040);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n7);
                report.add(n8);
                if (n8 >= n7) {
                    report.choose(true);
                    this.addReport(report);
                } else {
                    report.choose(false);
                    this.addReport(report);
                    this.addReport(this.explodeInfernoAmmoFromHeat(entity));
                }
            }
            if (this.game.getOptions().booleanOption("maxtech_heat")) {
                n3 = 50;
                bl2 = true;
            } else {
                n3 = 30;
                bl2 = false;
            }
            if (entity.heat < n3 && entity.isShutDown()) {
                if (entity.heat < 14) {
                    entity.setShutDown(false);
                    report = new Report(5045);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    this.addReport(report);
                } else {
                    int n9 = 4 + (entity.heat - 14) / 4 * 2;
                    if (bl2) {
                        n9 = entity.crew.getPiloting() + n9 - 8;
                    }
                    int n10 = Compute.d6(2);
                    report = new Report(5050);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    report.add(n9);
                    report.add(n10);
                    if (n10 >= n9) {
                        entity.setShutDown(false);
                        report.choose(true);
                    } else {
                        report.choose(false);
                    }
                    this.addReport(report);
                }
            } else if (entity.heat >= 14 && !entity.isShutDown()) {
                if (entity.heat >= n3) {
                    report = new Report(5055);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    this.addReport(report);
                    this.game.addPSR(new PilotingRollData(entity.getId(), 3, "reactor shutdown"));
                    this.resolvePilotingRolls();
                    entity.setShutDown(true);
                } else if (entity.heat >= 14) {
                    int n11 = 4 + (entity.heat - 14) / 4 * 2;
                    if (bl2) {
                        n11 = entity.crew.getPiloting() + n11 - 8;
                    }
                    int n12 = Compute.d6(2);
                    report = new Report(5060);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    report.add(n11);
                    report.add(n12);
                    if (n12 >= n11) {
                        report.choose(true);
                        this.addReport(report);
                    } else {
                        report.choose(false);
                        this.addReport(report);
                        this.game.addPSR(new PilotingRollData(entity.getId(), 3, "reactor shutdown"));
                        this.resolvePilotingRolls();
                        entity.setShutDown(true);
                    }
                }
            }
            if (entity.heat >= 19) {
                int n13 = 4 + (entity.heat >= 23 ? 2 : 0) + (entity.heat >= 28 ? 2 : 0);
                if (bl2) {
                    n13 += (entity.heat >= 35 ? 2 : 0) + (entity.heat >= 40 ? 2 : 0) + (entity.heat >= 45 ? 2 : 0);
                }
                if (entity instanceof Mech && ((Mech)entity).hasLaserHeatSinks()) {
                    --n13;
                }
                int n14 = Compute.d6(2);
                report = new Report(5065);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n13);
                report.add(n14);
                if (n14 >= n13) {
                    report.choose(true);
                    this.addReport(report);
                } else {
                    report.choose(false);
                    this.addReport(report);
                    this.addReport(this.explodeAmmoFromHeat(entity));
                }
            }
            int n15 = 0;
            boolean bl3 = bl = ((Mech)entity).getCockpitType() == 1;
            if (entity instanceof Mech && bl) {
                n15 = entity.getHitCriticals(0, 0, 2);
                n15 += entity.getHitCriticals(0, 0, 3);
            } else {
                n15 = entity.getHitCriticals(0, 0, 0);
            }
            if (n15 > 0 && (entity.heat >= 15 || bl && entity.heat >= 0) && !entity.crew.isDead() && !entity.crew.isDoomed() && !entity.crew.isEjected()) {
                n2 = 1;
                n = 0;
                if (entity.heat >= 47 && bl2) {
                    n2 = 47;
                    n = 5;
                } else if (entity.heat >= 39 && bl2) {
                    n2 = 39;
                    n = 4;
                } else if (entity.heat >= 32 && bl2) {
                    n2 = 32;
                    n = 3;
                } else if (entity.heat >= 25) {
                    n2 = 25;
                    n = 2;
                } else if (entity.heat >= 15) {
                    n2 = 15;
                    n = 1;
                }
                if (entity.heat > 0 && entity instanceof Mech && ((Mech)entity).getCockpitType() == 1) {
                    ++n;
                }
                report = new Report(5070);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n2);
                report.add(n);
                this.addReport(report);
                this.damageCrew(entity, n);
            } else if (bl2 && entity.heat >= 32 && !entity.crew.isDead() && !entity.crew.isDoomed()) {
                n2 = Compute.d6(2);
                n = -1;
                if (entity.heat >= 47) {
                    n = 12;
                } else if (entity.heat >= 39) {
                    n = 10;
                } else if (entity.heat >= 32) {
                    n = 8;
                }
                report = new Report(5075);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(n);
                report.add(n2);
                if (n2 >= n) {
                    report.choose(true);
                } else {
                    this.damageCrew(entity, 1);
                    report.choose(false);
                }
                this.addReport(report);
            }
            if ((entity.crew.isDead() || entity.crew.isDoomed()) && !entity.crew.isEjected()) {
                report = new Report(5080);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
                this.addReport(this.destroyEntity(entity, "crew death", true));
            }
            if (!bl2 || entity.heat < 36) continue;
            n2 = Compute.d6(2);
            n = -1;
            if (entity.heat >= 44) {
                n = 10;
            } else if (entity.heat >= 36) {
                n = 8;
            }
            report = new Report(5085);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(n);
            report.add(n2);
            report.newlines = 0;
            if (n2 >= n) {
                report.choose(true);
                this.addReport(report);
                continue;
            }
            report.choose(false);
            this.addReport(report);
            this.addReport(this.oneCriticalEntity(entity, Compute.randomInt(8)));
            report = new Report(1210);
            this.addReport(report);
        }
        if (this.vPhaseReport.size() == 1) {
            this.addReport(new Report(1205, 0));
        }
    }

    private void resolveExtremeTempInfantryDeath() {
        int n = this.game.getTemperatureDifference();
        if (n > 0) {
            Enumeration<Entity> enumeration = this.game.getEntities();
            while (enumeration.hasMoreElements()) {
                Report report;
                Entity entity = enumeration.nextElement();
                if (null == entity.getPosition()) continue;
                IHex iHex = this.game.getBoard().getHex(entity.getPosition());
                if (!(entity instanceof Infantry) || entity instanceof BattleArmor || iHex.containsTerrain(10) || entity.getTransportId() != -1) continue;
                if (this.game.getOptions().booleanOption("extreme_temperature_survival")) {
                    report = new Report(5310);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    report.add(n);
                    int n2 = Compute.d6();
                    report.add(n2);
                    this.addReport(report);
                    if (n2 > n) continue;
                    if (entity instanceof MechWarrior) {
                        this.addReport(this.damageCrew(entity, 1));
                    } else {
                        this.addReport(this.damageEntity(entity, entity.rollHitLocation(0, 0), Compute.d6() + n));
                    }
                    report = new Report(1210, 0);
                    this.addReport(report);
                    continue;
                }
                report = new Report(5090);
                report.subject = entity.getId();
                report.addDesc(entity);
                this.addReport(report);
                this.addReport(this.destroyEntity(entity, "heat/cold", false, false));
            }
        }
    }

    private void doFlamingDeath(Entity entity) {
        int n = Compute.d6(2);
        if (-1 != entity.getSwarmTargetId()) {
            return;
        }
        if (entity.getMovementMode() == 6 && !entity.infernos.isStillBurning() && entity.getElevation() > 1) {
            return;
        }
        for (Mounted mounted : entity.getMisc()) {
            EquipmentType equipmentType = mounted.getType();
            if (!"BA-Fire Resistant Armor".equals(equipmentType.getInternalName())) continue;
            Report report = new Report(5095);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
            return;
        }
        Report report = new Report(5100);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(n);
        if (n >= 8) {
            report.choose(true);
            this.addReport(report);
        } else {
            report.choose(false);
            this.addReport(report);
            this.addReport(this.destroyEntity(entity, "fire", false, false));
        }
    }

    private void checkFor20Damage() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!(entity instanceof Mech) || entity.damageThisPhase < 20) continue;
            if (this.game.getOptions().booleanOption("maxtech_round_damage")) {
                int n = entity.damageThisPhase / 20;
                int n2 = 0;
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(entity.damageThisPhase).append(" damage +").append(n);
                switch (entity.getWeightClass()) {
                    case 0: {
                        n2 = 1;
                        break;
                    }
                    case 1: {
                        n2 = 0;
                        break;
                    }
                    case 2: {
                        n2 = -1;
                        break;
                    }
                    case 3: {
                        n2 = -2;
                    }
                }
                if (n2 > 0) {
                    stringBuffer.append(", weight class modifier +").append(n2);
                } else {
                    stringBuffer.append(", weight class modifier ").append(n2);
                }
                PilotingRollData pilotingRollData = new PilotingRollData(entity.getId(), n + n2, stringBuffer.toString());
                pilotingRollData.setCumulative(false);
                this.game.addPSR(pilotingRollData);
                continue;
            }
            this.game.addPSR(new PilotingRollData(entity.getId(), 1, "20+ damage"));
        }
    }

    public void checkForFlamingDeath() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            IHex iHex;
            Entity entity = enumeration.nextElement();
            if (null == entity.getPosition() || entity instanceof Mech || entity.isDoomed() || entity.isDestroyed() || entity.isOffBoard() || !(iHex = this.game.getBoard().getHex(entity.getPosition())).containsTerrain(7) || entity.getElevation() > 1) continue;
            if (this.game.getOptions().booleanOption("vehicle_fires") && entity instanceof Tank) {
                this.checkForVehicleFire((Tank)entity, false);
                continue;
            }
            this.doFlamingDeath(entity);
        }
    }

    private void checkForVacuumDeath() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (null == entity.getPosition() || entity.isOffBoard() || !entity.doomedInVacuum()) continue;
            Report report = new Report(6015);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
            this.addReport(this.destroyEntity(entity, "being in a vacuum where it can't survive", true, true));
        }
    }

    private void checkForSuffocation() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (null == entity.getPosition() || entity.isOffBoard()) continue;
            IHex iHex = this.game.getBoard().getHex(entity.getPosition());
            if (entity.getElevation() >= 0 || iHex.terrainLevel(4) <= 1 && (iHex.terrainLevel(4) != 1 || !entity.isProne()) || entity.getHitCriticals(0, 0, 0) <= 0) continue;
            Report report = new Report(6020);
            report.subject = entity.getId();
            report.addDesc(entity);
            this.addReport(report);
            this.addReport(this.damageCrew(entity, 1));
        }
    }

    private void resolvePilotingRolls() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            this.resolvePilotingRolls(enumeration.nextElement());
        }
        this.game.resetPSRs();
    }

    void resolvePilotingRolls(Entity entity) {
        this.resolvePilotingRolls(entity, false, entity.getPosition(), entity.getPosition());
    }

    void resolvePilotingRolls(Entity entity, boolean bl, Coords coords, Coords coords2) {
        PilotingRollData pilotingRollData;
        int n;
        Report report;
        if (entity.isDoomed() || entity.isDestroyed() || entity.isOffBoard() || !entity.isDeployed()) {
            return;
        }
        TargetRoll targetRoll = null;
        Object object = this.game.getExtremeGravityPSRs();
        while (object.hasMoreElements()) {
            PilotingRollData pilotingRollData2 = object.nextElement();
            if (pilotingRollData2.getEntityId() != entity.getId()) continue;
            targetRoll = pilotingRollData2;
            this.game.resetExtremeGravityPSRs(entity);
        }
        if (targetRoll != null && targetRoll.getValue() != -2147483647) {
            report = new Report(2180);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(targetRoll.getLastPlainDesc());
            this.addReport(report);
            int n2 = Compute.d6(2);
            report = new Report(2190);
            report.subject = entity.getId();
            report.add(targetRoll.getValueAsString());
            report.add(targetRoll.getDesc());
            report.add(n2);
            if (n2 < targetRoll.getValue()) {
                int n3;
                report.choose(false);
                this.addReport(report);
                if (entity.moved == 1 || entity.moved == 4 || entity.moved == 2 || entity.moved == 5) {
                    if (entity instanceof Mech) {
                        int n4 = entity.mpUsed;
                        n3 = 0;
                        while (n4 > entity.getRunMP(false)) {
                            --n4;
                            ++n3;
                        }
                        this.doExtremeGravityDamage(entity, n3);
                    } else if (entity instanceof Tank) {
                        int n5;
                        int n6 = n5 = entity.gotPavementBonus ? 1 : 0;
                        if (!entity.gotPavementBonus) {
                            n3 = entity.mpUsed;
                            int n7 = 0;
                            while (n3 > entity.getRunMP(false) + n5) {
                                --n3;
                                ++n7;
                            }
                            this.doExtremeGravityDamage(entity, n7);
                        }
                    }
                }
                if (entity.moved == 3 && entity instanceof Mech) {
                    if (this.game.getOptions().floatOption("gravity") < 1.0f) {
                        int n8 = entity.mpUsed;
                        n3 = 0;
                        while (n8 > entity.getOriginalJumpMP()) {
                            --n8;
                            ++n3;
                        }
                        this.doExtremeGravityDamage(entity, n3);
                    } else if (this.game.getOptions().floatOption("gravity") > 1.0f) {
                        int n9 = entity.getWalkMP(false) - entity.getWalkMP();
                        this.doExtremeGravityDamage(entity, n9);
                    }
                }
            } else {
                report.choose(true);
                this.addReport(report);
            }
        }
        if (!(entity instanceof Mech) || entity.isProne()) {
            return;
        }
        if (entity instanceof Mech && (n = (object = this.game.getBoard().getHex(coords2)).terrainLevel(4)) > 0 && entity.getElevation() != -object.depth() && (entity.getElevation() < 0 || entity.getElevation() == 0 && object.terrainLevel(16) != 0 && !object.containsTerrain(20))) {
            if (entity.hasUMU()) {
                return;
            }
            this.game.addPSR(new PilotingRollData(entity.getId(), 0x7FFFFFFE, "lost bouyancy"));
        }
        object = new Vector();
        StringBuffer stringBuffer = new StringBuffer();
        PilotingRollData pilotingRollData3 = entity.getBasePilotingRoll();
        entity.addPilotingModifierForTerrain(pilotingRollData3);
        Enumeration<PilotingRollData> enumeration = this.game.getPSRs();
        while (enumeration.hasMoreElements()) {
            pilotingRollData = enumeration.nextElement();
            if (pilotingRollData.getEntityId() != entity.getId()) continue;
            ((Vector)object).addElement(pilotingRollData);
            if (stringBuffer.length() > 0) {
                stringBuffer.append("; ");
            }
            stringBuffer.append(pilotingRollData.getPlainDesc());
            if (!pilotingRollData.isCumulative()) continue;
            pilotingRollData3.append(pilotingRollData);
        }
        if (((Vector)object).size() == 0) {
            return;
        }
        if (pilotingRollData3.getValue() == 0x7FFFFFFE || pilotingRollData3.getValue() == Integer.MAX_VALUE) {
            report = new Report(2275);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(((Vector)object).size());
            report.add(stringBuffer.toString());
            report.add(pilotingRollData3.getDesc());
            this.addReport(report);
            if (bl) {
                this.doEntityFallsInto(entity, coords, coords2, pilotingRollData3);
            } else {
                this.doEntityFall(entity, pilotingRollData3);
            }
            return;
        }
        report = new Report(2280);
        report.subject = entity.getId();
        report.addDesc(entity);
        report.add(((Vector)object).size());
        report.add(stringBuffer.toString());
        this.addReport(report);
        report = new Report(2285);
        report.subject = entity.getId();
        report.add(pilotingRollData3.getValueAsString());
        report.add(pilotingRollData3.getDesc());
        this.addReport(report);
        for (int i = 0; i < ((Vector)object).size(); ++i) {
            pilotingRollData = (PilotingRollData)((Vector)object).elementAt(i);
            PilotingRollData pilotingRollData4 = pilotingRollData3;
            report = new Report(2290);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.add(i + 1);
            report.add(pilotingRollData.getPlainDesc());
            this.addReport(report);
            if (!pilotingRollData.isCumulative()) {
                report = new Report(2295);
                report.subject = entity.getId();
                report.newlines = 0;
                report.add(pilotingRollData.getValueAsString());
                pilotingRollData4 = new PilotingRollData(entity.getId());
                pilotingRollData4.append(pilotingRollData3);
                pilotingRollData4.append(pilotingRollData);
            }
            int n10 = Compute.d6(2);
            report = new Report(2300);
            report.subject = entity.getId();
            report.add(pilotingRollData4.getValueAsString());
            report.add(n10);
            if (n10 < pilotingRollData4.getValue()) {
                report.choose(false);
                this.addReport(report);
                if (bl) {
                    this.doEntityFallsInto(entity, coords, coords2, pilotingRollData3);
                } else {
                    this.doEntityFall(entity, pilotingRollData3);
                }
                return;
            }
            report.choose(true);
            this.addReport(report);
        }
    }

    private Vector<Report> damageCrew(Entity entity, int n) {
        Vector<Report> vector = new Vector<Report>();
        Pilot pilot = entity.getCrew();
        if (!(pilot.isDead() || pilot.isEjected() || pilot.isDoomed())) {
            pilot.setHits(pilot.getHits() + n);
            Report report = new Report(6025);
            report.subject = entity.getId();
            report.indent(2);
            report.addDesc(entity);
            report.add(pilot.getName());
            report.add(n);
            report.newlines = 0;
            vector.addElement(report);
            if (6 > pilot.getHits()) {
                pilot.setRollsNeeded(pilot.getRollsNeeded() + n);
            } else if (!pilot.isDoomed()) {
                pilot.setDoomed(true);
                vector.addAll(this.destroyEntity(entity, "pilot death", true));
            }
        }
        return vector;
    }

    private void resolveCrewDamage() {
        boolean bl = false;
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!this.resolveCrewDamage(entity, bl)) continue;
            bl = true;
        }
        if (bl) {
            this.addNewLines();
        }
    }

    private boolean resolveCrewDamage(Entity entity, boolean bl) {
        int n = entity.getCrew().getHits();
        int n2 = entity.getCrew().getRollsNeeded();
        entity.crew.setRollsNeeded(0);
        if (!entity.isTargetable() || !entity.getCrew().isActive() || n2 == 0) {
            return false;
        }
        for (int i = n - n2 + 1; i <= n; ++i) {
            int n3 = Compute.getConsciousnessNumber(i);
            boolean bl2 = false;
            do {
                if (bl2) {
                    entity.crew.decreaseEdge();
                }
                int n4 = Compute.d6(2);
                if (entity.getCrew().getOptions().booleanOption("pain_resistance")) {
                    n4 = Math.min(12, n4 + 1);
                }
                Report report = new Report(6030);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(entity.getCrew().getName());
                report.add(n3);
                report.add(n4);
                if (n4 >= n3) {
                    entity.crew.setKoThisRound(false);
                    report.choose(true);
                } else {
                    entity.crew.setKoThisRound(true);
                    report.choose(false);
                    if (entity.crew.hasEdgeRemaining() && entity.crew.getOptions().booleanOption("edge_when_ko")) {
                        bl2 = true;
                        this.vPhaseReport.addElement(report);
                        report = new Report(6520);
                        report.subject = entity.getId();
                        report.addDesc(entity);
                        report.add(entity.getCrew().getName());
                        report.add(entity.crew.getOptions().intOption("edge"));
                    }
                }
                this.addReport(report);
            } while (entity.crew.hasEdgeRemaining() && entity.crew.isKoThisRound() && entity.crew.getOptions().booleanOption("edge_when_ko"));
            if (!entity.crew.isKoThisRound()) continue;
            entity.crew.setUnconscious(true);
            return true;
        }
        return true;
    }

    private void resolveCrewWakeUp() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!entity.isTargetable() || !entity.crew.isUnconscious() || entity.crew.isKoThisRound() || !(entity instanceof Mech) && !(entity instanceof Protomech) && !(entity instanceof MechWarrior)) continue;
            int n = Compute.d6(2);
            if (entity.getCrew().getOptions().booleanOption("pain_resistance")) {
                n = Math.min(12, n + 1);
            }
            int n2 = Compute.getConsciousnessNumber(entity.crew.getHits());
            Report report = new Report(6029);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.getCrew().getName());
            report.add(n2);
            report.add(n);
            if (n >= n2) {
                report.choose(true);
                entity.crew.setUnconscious(false);
            } else {
                report.choose(false);
            }
            this.addReport(report);
        }
    }

    private Vector<Report> damageEntity(Entity entity, HitData hitData, int n, boolean bl) {
        return this.damageEntity(entity, hitData, n, bl, 0, false, false);
    }

    public Vector<Report> damageEntity(Entity entity, HitData hitData, int n) {
        return this.damageEntity(entity, hitData, n, false, 0, false, false);
    }

    private Vector<Report> damageEntity(Entity entity, HitData hitData, int n, boolean bl, int n2, boolean bl2) {
        return this.damageEntity(entity, hitData, n, bl, n2, bl2, false);
    }

    private Vector<Report> damageEntity(Entity entity, HitData hitData, int n, boolean bl, int n2, boolean bl2, boolean bl3) {
        return this.damageEntity(entity, hitData, n, bl, n2, bl2, bl3, true);
    }

    /*
     * WARNING - void declaration
     */
    private Vector<Report> damageEntity(Entity entity, HitData hitData, int n, boolean bl, int n2, boolean bl2, boolean bl3, boolean bl4) {
        int n3;
        boolean bl5;
        Mech mech;
        Report report;
        Vector<Report> vector = new Vector<Report>();
        int n4 = entity.getId();
        boolean bl6 = entity instanceof Mech && ((Mech)entity).getCockpitType() != 1 && hitData.getLocation() == 0 && (hitData.getEffect() & 0x20) != 32;
        for (HitData hitData2 = hitData.getUndoneLocation(); hitData2 != null; hitData2 = hitData2.getUndoneLocation()) {
            report = new Report(6500);
            report.subject = n4;
            report.indent(2);
            report.newlines = 0;
            report.addDesc(entity);
            report.add(entity.getLocationAbbr(hitData2));
            vector.addElement(report);
        }
        if (hitData.getUndoneLocation() != null) {
            report = new Report(6510);
            report.subject = n4;
            report.indent(2);
            report.newlines = 0;
            report.addDesc(entity);
            report.add(entity.crew.getOptions().intOption("edge"));
            vector.addElement(report);
        }
        boolean bl7 = false;
        if (bl && entity instanceof Mech && (mech = (Mech)entity).isAutoEject()) {
            bl7 = true;
            vector.addAll(this.ejectEntity(entity, true));
        }
        boolean bl8 = !(bl5 = entity instanceof BattleArmor) && entity instanceof Infantry;
        boolean bl9 = false;
        boolean bl10 = false;
        boolean bl11 = bl2;
        IHex iHex = null;
        boolean bl12 = false;
        if (entity instanceof Mech && entity.getArmorType() == 4) {
            bl12 = true;
        }
        int n5 = (hitData.getEffect() & 1) == 1 && !bl12 ? 1 : 0;
        int n6 = (hitData.getEffect() & 1) == 1 && bl12 ? 1 : 0;
        HitData hitData3 = null;
        if (entity instanceof Protomech && hitData.getLocation() == 6) {
            report = new Report(6035);
            report.subject = n4;
            report.indent(2);
            report.newlines = 0;
            vector.addElement(report);
            return vector;
        }
        if (n5 > 0 && entity instanceof BattleArmor) {
            if (hitData.getLocation() >= entity.locations() || entity.getInternal(hitData.getLocation()) <= 0) {
                report = new Report(6037);
                report.add(hitData.getLocation());
                report.subject = n4;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                return vector;
            }
            report = new Report(6225);
            report.add(entity.getLocationAbbr(hitData));
            report.subject = n4;
            report.indent(2);
            report.newlines = 0;
            vector.addElement(report);
            n5 = 0;
            n = Math.max(entity.getInternal(hitData.getLocation()) + entity.getArmor(hitData.getLocation()), n);
        }
        if (entity != null && entity.getArmor(hitData) > 0 && (entity.getArmorType() == 1 || entity.getArmorType() == 5 || entity.getArmorType() == 6)) {
            bl9 = true;
        }
        if (!(!bl8 || entity.isDestroyed() || entity.isDoomed() || ((Infantry)entity).getDugIn() == 2 || (iHex = this.game.getBoard().getHex(entity.getPosition())) == null || n2 == 6 || iHex.containsTerrain(1) || iHex.containsTerrain(23) || iHex.containsTerrain(2) || iHex.containsTerrain(3) || iHex.containsTerrain(9) || iHex.containsTerrain(10) || iHex.containsTerrain(32) || iHex.containsTerrain(21) || bl)) {
            n *= 2;
            report = new Report(6040);
            report.subject = n4;
            report.indent(2);
            report.newlines = 0;
            vector.addElement(report);
        }
        if ((bl8 || bl5) && !entity.isDestroyed() && !entity.isDoomed() && this.game.getOptions().booleanOption("vacuum")) {
            n *= 2;
            report = new Report(6041);
            report.subject = n4;
            report.indent(2);
            report.newlines = 0;
            vector.addElement(report);
        }
        switch (n2) {
            case 1: {
                if (bl8 || entity == null) break;
                n = 0;
                report = new Report(6050);
                report.subject = n4;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                break;
            }
            case 2: {
                if (bl8 || entity == null || bl5) break;
                n /= 2;
                report = new Report(6060);
                report.subject = n4;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                break;
            }
            case 3: {
                if (bl9) {
                    n = entity.getArmor(hitData) >= 3 ? 3 : entity.getArmor(hitData);
                    report = new Report(6061);
                    report.subject = n4;
                    report.indent(2);
                    report.newlines = 0;
                    report.add(n);
                    vector.addElement(report);
                    break;
                }
                if (entity == null) break;
                report = new Report(6062);
                report.subject = n4;
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
                break;
            }
            case 4: {
                if (!bl8) break;
                n += 2;
                break;
            }
            case 5: {
                if (!bl8) {
                    n = 0;
                    report = new Report(6540);
                    report.subject = n4;
                    report.indent(2);
                    report.newlines = 0;
                    vector.addElement(report);
                }
            }
            case 6: {
                if (!bl8) break;
                n = n >= 10 ? 2 : 1;
                if (entity.getArmor(hitData) <= 0) break;
                n *= 2;
            }
        }
        if (entity instanceof VTOL && hitData.getLocation() == 5) {
            n = (n + 9) / 10;
        }
        boolean bl13 = entity.hasActiveEiCockpit();
        if (!(entity instanceof Mech) && !(entity instanceof Protomech) && bl13) {
            ++n;
        }
        while (n > 0) {
            int n7;
            Mech mech2;
            int n8;
            report = new Report(6065);
            report.subject = n4;
            report.indent(2);
            report.newlines = 0;
            report.addDesc(entity);
            report.add(n);
            if (bl2) {
                report.messageId = 6070;
            }
            report.add(entity.getLocationAbbr(hitData));
            vector.addElement(report);
            if (entity.getInternal(hitData) == -2) {
                n5 = 0;
            }
            if (!bl && !hitData.isFallDamage() && !bl2 && entity.hasShield() && (hitData.getEffect() & 0x20) != 32 && (n8 = (mech2 = (Mech)entity).shieldAbsorptionDamage(n, hitData.getLocation(), hitData.isRear())) != n) {
                n7 = n - n8;
                entity.damageThisPhase += n7;
                n = n8;
                report = new Report(3530);
                report.subject = n4;
                report.indent(3);
                report.newlines = 0;
                report.add(n7);
                vector.addElement(report);
                if (n <= 0) {
                    n5 = 0;
                    n6 = 0;
                    bl6 = false;
                }
            }
            if (entity instanceof Mech && (mech2 = (Mech)entity).hasCowl() && hitData.getLocation() == 0 && !bl4) {
                n8 = mech2.damageCowl(n);
                n7 = n - n8;
                mech2.damageThisPhase += n7;
                n = n8;
                report = new Report(3520);
                report.subject = n4;
                report.indent(3);
                report.newlines = 0;
                report.add(n7);
                vector.addElement(report);
            }
            n3 = 0;
            if (entity.hasSpotlight()) {
                n3 = 1;
                n8 = hitData.getLocation();
                if (entity instanceof Mech) {
                    if (n8 != 1 && n8 != 3 && n8 != 2) {
                        n3 = 0;
                    }
                } else if (entity instanceof Tank && n8 != 1 && n8 != 2 && n8 != 3) {
                    n3 = 0;
                }
                if (n3 != 0) {
                    n7 = Compute.d6(2);
                    report = new Report(6072);
                    report.indent(2);
                    report.subject = n4;
                    report.add(n7);
                    vector.addElement(report);
                    if (n7 >= 7) {
                        report = new Report(6071);
                        report.subject = n4;
                        report.indent(2);
                        vector.addElement(report);
                        entity.setSpotlightState(false);
                        entity.setSpotlight(false);
                    }
                }
            }
            if (!bl2) {
                int n9;
                n8 = hitData.getLocation();
                Entity entity2 = entity.getExteriorUnitAt(n8, hitData.isRear());
                if (!bl && null != entity2 && Compute.d6() >= 5 && !entity2.isDoomed() && n2 != 7) {
                    HitData hitData2;
                    report = new Report(6075);
                    report.subject = entity2.getId();
                    report.indent(3);
                    report.addDesc(entity2);
                    vector.addElement(report);
                    HitData hitData4 = entity2.getTrooperAtLocation(hitData, entity);
                    n9 = 0;
                    HitData hitData5 = hitData4;
                    do {
                        void var31_60;
                        if (0 < entity2.getArmor((HitData)var31_60)) {
                            n9 += entity2.getArmor((HitData)var31_60);
                        }
                        if (0 < entity2.getInternal((HitData)var31_60)) {
                            n9 += entity2.getInternal((HitData)var31_60);
                        }
                        hitData2 = entity2.getTransferLocation((HitData)var31_60);
                    } while (n > n9 && hitData2.getLocation() >= 0);
                    vector.addAll(this.damageEntity(entity2, hitData4, n));
                    if (n > n9) {
                        report = new Report(6080);
                        report.subject = n4;
                        report.indent(1);
                        report.add(n -= n9);
                        report.addDesc(entity);
                        vector.addElement(report);
                    } else {
                        return vector;
                    }
                }
                boolean bl14 = n8 == 1 || n8 == 2 || n8 == 3;
                n9 = entity.getSwarmAttackerId();
                if ((!(entity instanceof Mech) || bl14) && n9 != -1 && (hitData.getEffect() & 1) == 0 && Compute.d6() >= 5 && n2 != 7) {
                    Entity entity3 = this.game.getEntity(n9);
                    report = new Report(6076);
                    report.subject = n9;
                    report.indent(3);
                    report.addDesc(entity3);
                    vector.addElement(report);
                    HitData hitData6 = entity3.rollHitLocation(0, 0);
                    int n10 = 0;
                    HitData hitData7 = hitData6;
                    do {
                        if (0 < entity3.getArmor(hitData7)) {
                            n10 += entity3.getArmor(hitData7);
                        }
                        if (0 < entity3.getInternal(hitData7)) {
                            n10 += entity3.getInternal(hitData7);
                        }
                        hitData7 = entity3.getTransferLocation(hitData7);
                    } while (n > n10 && hitData7.getLocation() >= 0);
                    vector.addAll(this.damageEntity(entity3, hitData6, n));
                    if (n > n10) {
                        report = new Report(6080);
                        report.subject = n4;
                        report.indent(1);
                        report.add(n -= n10);
                        report.addDesc(entity);
                        vector.addElement(report);
                    } else {
                        return vector;
                    }
                }
                if (entity instanceof Mech && hitData.isRear() && bl14 || entity instanceof Tank && hitData.getLocation() == 4) {
                    for (Mounted mounted : entity.getAmmo()) {
                        if (!mounted.isDumping() || mounted.isDestroyed() || mounted.isHit()) continue;
                        vector.addAll(this.explodeEquipment(entity, mounted.getLocation(), mounted));
                        mounted.setHit(true);
                    }
                }
            }
            if (!bl && entity.getArmor(hitData) > 0 && !bl2) {
                n8 = -1;
                if (bl12) {
                    n8 = n;
                    n /= 2;
                    n += n8 % 2;
                } else if (bl8) {
                    int n11 = entity.getArmor(hitData);
                    int n12 = entity.getInternal(hitData);
                    n8 = n % 2;
                    n /= 2;
                    n8 = n8 == 1 && n11 >= n12 ? n++ : (n8 += n);
                }
                if (entity.getArmor(hitData) > n) {
                    entity.setArmor(entity.getArmor(hitData) - n, hitData);
                    entity.damageThisPhase = n8 >= 0 ? (entity.damageThisPhase += n8) : (entity.damageThisPhase += n);
                    n = 0;
                    report = new Report(6085);
                    report.subject = n4;
                    report.newlines = 0;
                    if (n3 != 0) {
                        report.indent(3);
                    }
                    report.add(entity.getArmor(hitData));
                    vector.addElement(report);
                } else {
                    int n13 = Math.max(entity.getArmor(hitData), 0);
                    entity.setArmor(-3, hitData);
                    entity.damageThisPhase = n8 >= 0 ? (entity.damageThisPhase += 2 * n13) : (entity.damageThisPhase += n13);
                    n -= n13;
                    report = new Report(6090);
                    report.subject = n4;
                    report.newlines = 0;
                    if (n3 != 0) {
                        report.indent(3);
                    }
                    vector.addElement(report);
                    if (entity instanceof GunEmplacement) {
                        entity.destroyLocation(hitData.getLocation());
                        report = new Report(6115);
                        report.subject = n4;
                        report.newlines = 0;
                        vector.addElement(report);
                        if (entity.getTransferLocation(hitData).getLocation() == -2) {
                            vector.addAll(this.destroyEntity(entity, "damage", false));
                        }
                    }
                }
                if (n8 > 0) {
                    if (bl12) {
                        n *= 2;
                        n -= n8 % 2;
                    } else if (bl8) {
                        n = n8;
                    }
                }
            }
            if (n > 0) {
                bl11 = true;
                if (entity.getInternal(hitData) > 0) {
                    if (!bl8 && !bl5) {
                        ++n5;
                    }
                    n8 = -1;
                    if (entity instanceof Mech && ((Mech)entity).hasCompositeStructure()) {
                        n8 = n;
                        n *= 2;
                    }
                    if (entity instanceof Mech && ((Mech)entity).hasReinforcedStructure()) {
                        n8 = n;
                        n /= 2;
                        n += n8 % 2;
                    }
                    if (entity.getInternal(hitData) > n) {
                        entity.setInternal(entity.getInternal(hitData) - n, hitData);
                        entity.damageThisPhase += n;
                        n = 0;
                        report = new Report(1210);
                        report.subject = n4;
                        report.newlines = 0;
                        report.messageId = bl8 ? 6095 : 6100;
                        report.add(entity.getInternal(hitData));
                        vector.addElement(report);
                    } else {
                        Entity entity3;
                        int n14;
                        int n15 = Math.max(entity.getInternal(hitData), 0);
                        if (entity instanceof Protomech && (n14 = Protomech.POSSIBLE_PILOT_DAMAGE[hitData.getLocation()] - ((Protomech)entity).getPilotDamageTaken(hitData.getLocation())) > 0) {
                            vector.addAll(this.damageCrew(entity, n14));
                            ((Protomech)entity).setPilotDamageTaken(hitData.getLocation(), Protomech.POSSIBLE_PILOT_DAMAGE[hitData.getLocation()]);
                        }
                        report = new Report(1210);
                        report.subject = n4;
                        report.newlines = 0;
                        report.messageId = bl8 ? 6105 : (bl5 ? 6110 : 6115);
                        vector.addElement(report);
                        if (entity instanceof Mech && (hitData.getLocation() == 2 && entity.getInternal(4) > 0 || hitData.getLocation() == 3 && entity.getInternal(5) > 0)) {
                            int n16 = -1;
                            n16 = hitData.getLocation() == 2 ? 4 : 5;
                            report = new Report(6120);
                            report.subject = n4;
                            report.add(entity.getLocationName(n16));
                            report.newlines = 0;
                            vector.addElement(report);
                            IHex iHex2 = this.game.getBoard().getHex(entity.getPosition());
                            if (entity instanceof BipedMech) {
                                if (!iHex2.containsTerrain(18)) {
                                    iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(18, 1));
                                } else {
                                    iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(18, iHex2.terrainLevel(18) + 1));
                                }
                            } else if (!iHex2.containsTerrain(19)) {
                                iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(19, 1));
                            } else {
                                iHex2.addTerrain(Terrains.getTerrainFactory().createTerrain(19, iHex2.terrainLevel(19) + 1));
                            }
                            this.sendChangedHex(entity.getPosition());
                        }
                        if ((entity instanceof Mech || entity instanceof Tank) && null != (entity3 = entity.getExteriorUnitAt(hitData.getLocation(), hitData.isRear())) && !entity3.isDoomed()) {
                            HitData hitData5 = entity3.getTrooperAtLocation(hitData, entity);
                            hitData5.setEffect(1);
                            if (entity3.getInternal(hitData5) > 0) {
                                vector.addAll(this.damageEntity(entity3, hitData5, n));
                            }
                            hitData5 = new HitData(hitData.getLocation(), !hitData.isRear());
                            hitData5 = entity3.getTrooperAtLocation(hitData5, entity);
                            hitData5.setEffect(1);
                            if (entity3.getInternal(hitData5) > 0) {
                                vector.addAll(this.damageEntity(entity3, hitData5, n));
                            }
                        }
                        if (entity instanceof BattleArmor) {
                            int n17 = 0;
                            for (Mounted mounted : entity.getEquipment()) {
                                if (mounted.getType() instanceof AmmoType) {
                                    AmmoType ammoType = (AmmoType)mounted.getType();
                                    if (ammoType.getAmmoType() != 9 && ammoType.getAmmoType() != 50 || ammoType.getMunitionType() != 0x400000L) continue;
                                    n17 += ammoType.getRackSize() * mounted.getShotsLeft();
                                    continue;
                                }
                                if (!"BA-Fire Resistant Armor".equals(mounted.getType().getInternalName())) continue;
                                n17 = 0;
                                break;
                            }
                            if (n17 > 0) {
                                int n18 = Compute.d6(2);
                                report = new Report(6680);
                                report.add(n18);
                                vector.add(report);
                                if (n18 >= 8) {
                                    void var31_67;
                                    Coords coords = entity.getPosition();
                                    if (coords == null) {
                                        Entity entity4 = this.game.getEntity(entity.getTransportId());
                                        if (entity4 != null) {
                                            Coords coords2 = entity4.getPosition();
                                        }
                                        this.deliverInfernoMissiles(entity, entity, n17);
                                    }
                                    if (var31_67 != null) {
                                        this.deliverInfernoMissiles(entity, new HexTarget((Coords)var31_67, this.game.getBoard(), 7), n17);
                                    }
                                }
                            }
                        }
                        entity.destroyLocation(hitData.getLocation());
                        entity.damageThisPhase += n15;
                        n -= n15;
                        if (n8 > 0) {
                            if (((Mech)entity).hasCompositeStructure()) {
                                n /= 2;
                            } else if (((Mech)entity).hasReinforcedStructure()) {
                                n *= 2;
                                n -= n8 % 2;
                            }
                        }
                        if (entity instanceof Mech && (hitData.getLocation() == 2 || hitData.getLocation() == 3)) {
                            boolean bl15 = false;
                            int n19 = 0;
                            n19 += entity.getHitCriticals(0, 3, 1);
                            n19 += entity.getHitCriticals(0, 3, 2);
                            bl15 = this.checkEngineExplosion(entity, vector, n19 += entity.getHitCriticals(0, 3, 3));
                            if (!bl15 && n19 > 2) {
                                vector.addAll(this.destroyEntity(entity, "engine destruction"));
                                if (this.game.getOptions().booleanOption("auto_abandon_unit")) {
                                    vector.addAll(this.abandonEntity(entity));
                                }
                            }
                        }
                        if (entity instanceof VTOL && hitData.getLocation() == 5) {
                            entity.setOriginalWalkMP(0);
                            vector.addAll(this.crashVTOL((VTOL)entity));
                        }
                    }
                }
                if (entity.getInternal(hitData) <= 0) {
                    hitData3 = entity.getTransferLocation(hitData);
                    if (hitData3.getLocation() == -2) {
                        if (entity instanceof Mech) {
                            entity.engineHitsThisRound += entity.getGoodCriticals(0, 3, hitData.getLocation());
                            entity.engineHitsThisRound -= entity.getHitCriticals(0, 3, hitData.getLocation());
                        }
                        n8 = 0;
                        n8 = this.checkEngineExplosion(entity, vector, entity.engineHitsThisRound) ? 1 : 0;
                        if (!(n8 != 0 || entity instanceof VTOL && hitData.getLocation() == 5)) {
                            vector.addAll(this.destroyEntity(entity, "damage", !bl, !bl && !bl3 || hitData.getLocation() != 1));
                            if (hitData.getLocation() == 0 || hitData.getLocation() == 1 && (bl && !bl7 || bl3)) {
                                entity.getCrew().setDoomed(true);
                            }
                            if (this.game.getOptions().booleanOption("auto_abandon_unit")) {
                                vector.addAll(this.abandonEntity(entity));
                            }
                        }
                        n = 0;
                    } else if (hitData3.getLocation() == -1) {
                        n = 0;
                    } else if (bl && entity.locationHasCase(hitData.getLocation())) {
                        report = new Report(6125);
                        report.subject = n4;
                        report.add(n);
                        report.indent(3);
                        report.newlines = 0;
                        vector.addElement(report);
                        entity.damageThisPhase += n;
                        n = 0;
                    } else if (n > 0) {
                        report = new Report(6130);
                        report.subject = n4;
                        report.indent(2);
                        report.newlines = 0;
                        report.add(n);
                        report.add(entity.getLocationAbbr(hitData3));
                        vector.addElement(report);
                        for (Mounted mounted : entity.getWeaponList()) {
                            if (!mounted.isSplit() || mounted.getLocation() != hitData.getLocation() && mounted.getLocation() != hitData3.getLocation()) continue;
                            entity.setWeaponDestroyed(mounted);
                        }
                    }
                }
            } else if (hitData.getSpecCritMod() < 0) {
                ++n6;
            }
            vector.addAll(this.breachCheck(entity, hitData.getLocation(), null));
            if ((hitData.getEffect() & 2) == 2) {
                vector.addAll(this.vehicleMotiveDamage((Tank)entity, hitData.getMotiveMod()));
            } else if ((hitData.getEffect() & 4) == 4) {
                report = new Report(6146);
                report.subject = n4;
                report.indent(3);
                vector.addElement(report);
                for (Mounted mounted : entity.getWeaponList()) {
                    mounted.setDestroyed(true);
                }
            } else if ((hitData.getEffect() & 8) == 8) {
                report = new Report(6145);
                report.subject = n4;
                report.indent(3);
                vector.addElement(report);
                ((GunEmplacement)entity).setTurretLocked(true);
            } else if ((hitData.getEffect() & 0x10) == 16) {
                report = new Report(6148);
                report.subject = n4;
                report.indent(3);
                vector.addElement(report);
                ((GunEmplacement)entity).getCrew().setDoomed(true);
            }
            if (entity.getInternal(hitData) != -3 && (hitData.getEffect() & 0x20) != 32) {
                int n20;
                for (n20 = 0; n20 < n5; ++n20) {
                    ++vector.elementAt((int)(vector.size() - 1)).newlines;
                    vector.addAll(this.criticalEntity(entity, hitData.getLocation(), hitData.glancingMod()));
                }
                n5 = 0;
                for (n20 = 0; n20 < n6; ++n20) {
                    ++vector.elementAt((int)(vector.size() - 1)).newlines;
                    vector.addAll(this.criticalEntity(entity, hitData.getLocation(), (bl12 ? -2 : hitData.getSpecCritMod()) + hitData.glancingMod()));
                }
                n6 = 0;
            }
            if (bl6) {
                Report.addNewline(vector);
                vector.addAll(this.damageCrew(entity, 1));
            }
            hitData = hitData3;
            if (!bl2) continue;
            bl10 = true;
            bl2 = false;
        }
        if (bl11 && (entity instanceof Mech || entity instanceof Protomech) && entity.hasActiveEiCockpit()) {
            Report.addNewline(vector);
            n3 = Compute.d6(2);
            report = new Report(5075);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(7);
            report.add(n3);
            report.choose(n3 >= 7);
            report.indent(2);
            vector.add(report);
            if (n3 < 7) {
                vector.addAll(this.damageCrew(entity, 1));
            }
        }
        if (bl8) {
            float f = 0.0f;
            for (Mounted mounted : entity.getWeaponList()) {
                WeaponType weaponType = (WeaponType)mounted.getType();
                if (weaponType.hasFlag(2048L) || !((f += weaponType.getTonnage(entity)) > (float)entity.getInternal(0))) continue;
                mounted.setDestroyed(true);
            }
        }
        if (bl10) {
            Report.addNewline(vector);
        }
        return vector;
    }

    private boolean checkEngineExplosion(Entity entity, Vector<Report> vector, int n) {
        int n2;
        if (!(entity instanceof Mech || entity instanceof QuadMech || entity instanceof BipedMech)) {
            return false;
        }
        if (entity.isDestroyed()) {
            return false;
        }
        Mech mech = (Mech)entity;
        if (entity.rolledForEngineExplosion) {
            return false;
        }
        if (mech.getEngine().isFusion() && (!this.game.getOptions().booleanOption("engine_explosions") || entity.engineHitsThisRound < 2)) {
            return false;
        }
        int n3 = 12;
        if (!mech.getEngine().isFusion()) {
            switch (n) {
                case 0: {
                    return false;
                }
                case 1: {
                    n3 = 10;
                    break;
                }
                case 2: {
                    n3 = 7;
                    break;
                }
                default: {
                    n3 = 4;
                }
            }
        }
        boolean bl = (n2 = Compute.d6(2)) >= n3;
        Report report = new Report(6150);
        report.subject = entity.getId();
        report.indent(2);
        report.addDesc(entity);
        report.add(entity.engineHitsThisRound);
        vector.addElement(report);
        report = new Report(6155);
        report.subject = entity.getId();
        report.indent(2);
        report.add(n3);
        report.add(n2);
        vector.addElement(report);
        if (!bl) {
            if (mech.getEngine().isFusion()) {
                entity.rolledForEngineExplosion = true;
            }
            report = new Report(6160);
            report.subject = entity.getId();
            report.indent(2);
            vector.addElement(report);
        } else {
            IHex iHex;
            entity.rolledForEngineExplosion = true;
            report = new Report(6165, 0);
            report.subject = entity.getId();
            report.indent(2);
            vector.addElement(report);
            vector.addAll(this.destroyEntity(entity, "engine explosion", false, false, true));
            entity.getCrew().setDoomed(true);
            if (entity instanceof Mech) {
                entity.destroyLocation(1);
            }
            if (this.game.getOptions().booleanOption("fire") && null != (iHex = this.game.getBoard().getHex(entity.getPosition())) && !iHex.containsTerrain(7) && (iHex.containsTerrain(1) || iHex.containsTerrain(23))) {
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                report = new Report(6170, 0);
                report.subject = entity.getId();
                report.indent(2);
                report.add(entity.getPosition().getBoardNum());
                vector.addElement(report);
                this.sendChangedHex(entity.getPosition());
            }
            if (mech.getEngine().isFusion()) {
                int n4 = entity.getEngine().getRating();
                this.doFusionEngineExplosion(n4, entity.getPosition(), vector, null);
            }
        }
        return bl;
    }

    public void doFusionEngineExplosion(int n, Coords coords, Vector<Report> vector, Vector<Integer> vector2) {
        int[] nArray = new int[]{n, n / 10, n / 20, n / 40};
        this.doExplosion(nArray, true, coords, false, vector, vector2);
    }

    public void doExplosion(int n, int n2, boolean bl, Coords coords, boolean bl2, Vector<Report> vector, Vector<Integer> vector2) {
        int[] nArray = new int[n / n2];
        nArray[0] = n;
        for (int i = 1; i < nArray.length; ++i) {
            nArray[i] = nArray[i - 1] - n2;
        }
        this.doExplosion(nArray, bl, coords, bl2, vector, vector2);
    }

    public void doExplosion(int[] nArray, boolean bl, Coords coords, boolean bl2, Vector<Report> vector, Vector<Integer> vector2) {
        int n;
        Report report;
        int n2;
        Serializable serializable;
        Entity entity;
        Serializable serializable2;
        Object object;
        Serializable serializable3;
        if (vector == null) {
            vector = new Vector();
        }
        if (vector2 == null) {
            vector2 = new Vector();
        }
        HashSet<Entity> hashSet = new HashSet<Entity>();
        Enumeration<Building> enumeration = this.game.getBoard().getBuildings();
        while (enumeration.hasMoreElements()) {
            Coords coords2;
            serializable3 = enumeration.nextElement();
            object = ((Building)serializable3).getCoords();
            try {
                coords2 = object.nextElement();
            }
            catch (Exception exception) {
                continue;
            }
            int n3 = coords.distance(coords2);
            while (object.hasMoreElements()) {
                serializable2 = (Coords)object.nextElement();
                if (coords.distance(coords2) >= n3) continue;
                n3 = coords.distance(coords2);
                coords2 = serializable2;
            }
            if (n3 >= nArray.length || (serializable2 = this.damageBuilding((Building)serializable3, nArray[n3])) == null) continue;
            ((Report)serializable2).type = 0;
            vector.addElement((Report)serializable2);
        }
        this.applyBuildingDamage();
        serializable3 = this.game.getEntitiesVector();
        object = new ArrayList();
        for (int i = 0; i < ((Vector)serializable3).size(); ++i) {
            entity = (Entity)((Vector)serializable3).elementAt(i);
            if (hashSet.contains(entity) || entity.isDestroyed() || !entity.isDeployed()) continue;
            serializable2 = entity.getPosition();
            if (serializable2 == null) {
                serializable = this.game.getEntity(entity.getTransportId());
                if (serializable == null) continue;
                ((ArrayList)object).add(entity);
                continue;
            }
            int n4 = coords.distance((Coords)serializable2);
            if (n4 >= nArray.length) continue;
            if (n4 == 0 && bl) {
                vector.addAll(this.destroyEntity(entity, "explosion proximity", false, false));
                vector2.add(entity.getId());
                entity.getCrew().setDoomed(true);
                hashSet.add(entity);
                continue;
            }
            n2 = nArray[n4];
            if (bl2 && this.canShelter((Coords)serializable2, coords, entity.absHeight())) {
                if (this.isSheltered()) {
                    report = new Report(6545);
                    report.addDesc(entity);
                    report.subject = entity.getId();
                    vector.addElement(report);
                    continue;
                }
                report = new Report(6546);
                report.subject = entity.getId();
                report.addDesc(entity);
                vector.addElement(report);
            }
            vector2.add(entity.getId());
            report = new Report(6175);
            report.subject = entity.getId();
            report.indent(2);
            report.addDesc(entity);
            report.add(n2);
            report.newlines = 0;
            vector.addElement(report);
            while (n2 > 0) {
                n = Math.min(5, n2);
                HitData hitData = entity.rollHitLocation(0, Compute.targetSideTable(coords, (Targetable)entity));
                vector.addAll(this.damageEntity(entity, hitData, n, false, 7, false, true));
                n2 -= n;
            }
            Report.addNewline(vector);
        }
        Iterator iterator = ((ArrayList)object).iterator();
        while (iterator.hasNext()) {
            int n5;
            entity = (Entity)iterator.next();
            serializable2 = this.game.getEntity(entity.getTransportId());
            if (serializable2 != null && !((ArrayList)((Entity)serializable2).getExternalUnits()).contains(entity) || (n2 = coords.distance((Coords)(serializable = serializable2 == null ? entity.getPosition() : ((Entity)serializable2).getPosition()))) >= nArray.length) continue;
            n = nArray[n2];
            if (bl2) {
                int n6 = n5 = serializable2 == null ? entity.absHeight() : ((Entity)serializable2).absHeight();
                if (serializable != null && this.canShelter((Coords)serializable, coords, n5)) {
                    if (this.isSheltered()) {
                        report = new Report(6545);
                        report.addDesc(entity);
                        report.subject = entity.getId();
                        vector.addElement(report);
                        continue;
                    }
                    report = new Report(6546);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    vector.addElement(report);
                }
            }
            vector2.add(entity.getId());
            report = new Report(6175);
            report.subject = entity.getId();
            report.indent(2);
            report.addDesc(entity);
            report.add(n);
            report.newlines = 0;
            vector.addElement(report);
            while (n > 0) {
                n5 = Math.min(5, n);
                HitData hitData = entity.rollHitLocation(0, 0);
                vector.addAll(this.damageEntity(entity, hitData, n5, false, 7, false, true));
                n -= n5;
            }
            Report.addNewline(vector);
        }
    }

    public boolean canShelter(Coords coords, Coords coords2, int n) {
        Coords coords3 = Coords.nextHex(coords, coords2);
        IHex iHex = this.game.getBoard().getHex(coords3);
        if (iHex == null) {
            return false;
        }
        int n2 = iHex.floor();
        if (iHex.containsTerrain(10)) {
            n2 = iHex.ceiling();
        }
        return (n += this.game.getBoard().getHex(coords).surface()) < n2;
    }

    private boolean isSheltered() {
        return Compute.d6(2) >= 9;
    }

    public void doNuclearExplosion(Coords coords, int n, Vector<Report> vector) {
        switch (n) {
            case 0: 
            case 1: {
                this.doNuclearExplosion(coords, 100, 5, 40, 0, vector);
                break;
            }
            case 2: {
                this.doNuclearExplosion(coords, 1000, 23, 86, 1, vector);
                break;
            }
            case 3: {
                this.doNuclearExplosion(coords, 10000, 109, 184, 3, vector);
                break;
            }
            case 4: {
                this.doNuclearExplosion(coords, 100000, 505, 396, 5, vector);
                break;
            }
            default: {
                return;
            }
        }
    }

    public void doNuclearExplosion(Coords coords, int n, int n2, int n3, int n4, Vector<Report> vector) {
        Object object;
        Object object2;
        Cloneable cloneable;
        Serializable serializable;
        Enumeration<Serializable> enumeration;
        if (vector == null) {
            vector = new Vector();
        }
        Report report = new Report(1215, 0);
        report.indent();
        report.add(coords.getBoardNum(), true);
        this.addReport(report);
        int n5 = this.game.getBoard().getHex(coords).floor() - n4;
        int n6 = 0;
        while (n6 < 2 * n4) {
            enumeration = this.game.getBoard().getHexesAtDistance(coords, n6);
            while (enumeration.hasMoreElements()) {
                serializable = (Coords)enumeration.nextElement();
                cloneable = this.game.getBoard().getHex((Coords)serializable);
                cloneable.setElevation(cloneable.getElevation() - n4 + n6 / 2);
                if (cloneable.containsTerrain(4)) {
                    cloneable.setElevation(cloneable.floor());
                }
                cloneable.removeAllTerrains();
                cloneable.clearExits();
                this.sendChangedHex((Coords)serializable);
            }
            if (++n6 <= 0 || n6 % 2 != 0) continue;
            ++n5;
        }
        enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            serializable = (Entity)enumeration.nextElement();
            if (((Entity)serializable).getTransportId() != -1 || coords.distance(((Entity)serializable).getPosition()) >= n6 || ((Entity)serializable).isDestroyed()) continue;
            vector.addAll(this.destroyEntity((Entity)serializable, "nuclear explosion proximity", false, false, true));
            ((Entity)serializable).getCrew().setDoomed(true);
        }
        enumeration = null;
        serializable = new Vector();
        cloneable = new Vector();
        this.doExplosion(n, n2, false, coords, true, (Vector<Report>)serializable, (Vector<Integer>)cloneable);
        Report.indentAll((Vector)serializable, 2);
        vector.addAll((Collection<Report>)((Object)serializable));
        Object object3 = ((Vector)cloneable).iterator();
        while (object3.hasNext()) {
            Entity entity;
            object2 = (Integer)object3.next();
            Entity entity2 = this.game.getEntity((Integer)object2);
            if (entity2 instanceof Mech) {
                entity = (Mech)entity2;
                if (entity.isProne()) continue;
                this.game.addPSR(new PilotingRollData(entity.getId(), 6, "hit by nuclear blast"));
                continue;
            }
            if (entity2 instanceof VTOL) {
                entity = (VTOL)entity2;
                if (entity.getElevation() <= 0) continue;
                this.game.addPSR(new PilotingRollData(entity.getId(), 6, "hit by nuclear blast"));
                continue;
            }
            if (!(entity2 instanceof Tank)) continue;
        }
        serializable = null;
        object3 = this.game.getBoard().getBuildingAt(coords);
        if (object3 != null) {
            report = new Report(2415);
            report.add(((Building)object3).getName());
            this.addReport(report);
            this.collapseBuilding((Building)object3, this.game.getPositionMap());
        }
        if ((object2 = this.game.getBoard().getHex(coords)).containsTerrain(4)) {
            object2.setElevation(object2.floor());
        }
        object2.removeAllTerrains();
        boolean bl = true;
        int n7 = n - n2 * n6;
        if (n7 > 0) {
            int n8 = n6;
            while (bl) {
                object = this.game.getBoard().getHexesAtDistance(coords, n8);
                while (object.hasMoreElements()) {
                    int n9;
                    int n10;
                    Coords coords2 = (Coords)object.nextElement();
                    IHex iHex = this.game.getBoard().getHex(coords2);
                    if (n7 >= 3000 && iHex.containsTerrain(4)) {
                        n10 = n7 / 3000;
                        n9 = iHex.terrainLevel(4);
                        iHex.removeTerrain(4);
                        if (n9 > n10) {
                            iHex.addTerrain(new Terrain(4, n9 - n10));
                        }
                    }
                    if (n7 >= 200 && !iHex.containsTerrain(4)) {
                        iHex.removeAllTerrains();
                        iHex.clearExits();
                        iHex.addTerrain(new Terrain(2, 1));
                    } else if (n7 >= 20 && (iHex.containsTerrain(1) || iHex.containsTerrain(23))) {
                        n10 = n7 / 20;
                        n9 = iHex.containsTerrain(1) ? 1 : 23;
                        int n11 = iHex.terrainLevel(n9);
                        iHex.removeTerrain(n9);
                        if (n11 > n10) {
                            iHex.addTerrain(new Terrain(n9, n11 - n10));
                        }
                    }
                    this.sendChangedHex(coords2);
                }
                n7 = n - (n2 * n8 + 1);
                if (n7 < 20) {
                    bl = false;
                }
                ++n8;
            }
        }
        Enumeration<Entity> enumeration2 = this.game.getEntities();
        while (enumeration2.hasMoreElements()) {
            object = enumeration2.nextElement();
            if (coords.distance(((Entity)object).getPosition()) > n3 || ((Entity)object).isDoomed() || ((Entity)object).isDestroyed()) continue;
            this.applySecondaryNuclearEffects((Entity)object, coords, vector);
        }
        report = new Report(1216, 0);
        report.indent();
        report.newlines = 2;
        vector.add(report);
    }

    public void applySecondaryNuclearEffects(Entity entity, Coords coords, Vector<Report> vector) {
        if (entity.isDestroyed()) {
            return;
        }
        boolean bl = Compute.isInBuilding(this.game, entity) && this.game.getBoard().getHex(entity.getPosition()).terrainLevel(10) == 4;
        int n = Compute.d6(2);
        Report report = new Report(6555);
        report.subject = entity.getId();
        report.add(entity.getDisplayName());
        report.add(n);
        if (bl) {
            n += 2;
            report.add(" + 2 (unit is in hardened building)");
        } else {
            report.add("");
        }
        if (entity.isNuclearHardened()) {
            n += 2;
            report.add(" + 2 (unit is hardened against EMI)");
        } else {
            report.add("");
        }
        report.indent(2);
        vector.add(report);
        if (n <= 4) {
            vector.addAll(this.destroyEntity(entity, "nuclear explosion secondary effects", false, false, true));
            entity.getCrew().setDoomed(true);
        } else if (n <= 6) {
            if (entity instanceof BattleArmor) {
                BattleArmor battleArmor = (BattleArmor)entity;
                int n2 = (int)(Math.ceil(battleArmor.getNumberActiverTroopers()) / 2.0);
                for (int i = 0; i < n2; ++i) {
                    vector.addAll(this.applyCriticalHit(entity, 0, null, false));
                }
            } else if (entity instanceof Infantry) {
                if (this.game.getBoard().getHex(entity.getPosition()).containsTerrain(10)) {
                    int n3 = (int)Math.ceil((double)((Infantry)entity).getInternal(0) / 2.0);
                    vector.addAll(this.damageEntity(entity, new HitData(0), n3, true));
                } else {
                    vector.addAll(this.destroyEntity(entity, "nuclear explosion secondary effects", false, false));
                    entity.getCrew().setDoomed(true);
                }
            } else if (entity instanceof Tank) {
                HitData hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                vector.addAll(this.applyCriticalHit(entity, 0, new CriticalSlot(0, 6), false));
            } else if (entity instanceof Mech || entity instanceof Protomech) {
                HitData hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                vector.addAll(this.damageCrew(entity, 4));
            }
        } else if (n <= 10) {
            if (entity instanceof BattleArmor) {
                BattleArmor battleArmor = (BattleArmor)entity;
                int n4 = (int)Math.ceil((double)battleArmor.getNumberActiverTroopers() / 4.0);
                for (int i = 0; i < n4; ++i) {
                    vector.addAll(this.applyCriticalHit(entity, 0, null, false));
                }
            } else if (entity instanceof Infantry) {
                if (this.game.getBoard().getHex(entity.getPosition()).containsTerrain(10)) {
                    int n5 = (int)Math.ceil((double)((Infantry)entity).getInternal(0) / 4.0);
                    vector.addAll(this.damageEntity(entity, new HitData(0), n5, true));
                } else {
                    int n6 = (int)Math.ceil((double)((Infantry)entity).getInternal(0) / 2.0);
                    vector.addAll(this.damageEntity(entity, new HitData(0), n6, true));
                }
            } else if (entity instanceof Tank) {
                HitData hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                vector.addAll(this.applyCriticalHit(entity, 0, new CriticalSlot(0, 7), false));
            } else if (entity instanceof Mech || entity instanceof Protomech) {
                HitData hitData = entity.rollHitLocation(0, entity.sideTable(coords));
                vector.addAll(this.oneCriticalEntity(entity, hitData.getLocation()));
                vector.addAll(this.damageCrew(entity, 2));
            }
        }
        entity.setEMI(true);
    }

    public Vector<Report> applyCriticalHit(Entity entity, int n, CriticalSlot criticalSlot, boolean bl) {
        Report report;
        Vector<Report> vector;
        block75: {
            block74: {
                vector = new Vector<Report>();
                if (!(entity instanceof Tank)) break block74;
                Tank tank = (Tank)entity;
                switch (criticalSlot.getIndex()) {
                    case -1: {
                        report = new Report(6005);
                        report.subject = tank.getId();
                        vector.add(report);
                        break;
                    }
                    case 11: {
                        report = new Report(6610);
                        report.subject = tank.getId();
                        vector.add(report);
                        int n2 = 0;
                        for (Mounted mounted : tank.getAmmo()) {
                            mounted.setHit(true);
                            if (!mounted.getType().isExplosive()) continue;
                            int n3 = mounted.getShotsLeft() * ((AmmoType)mounted.getType()).getDamagePerShot() * ((AmmoType)mounted.getType()).getRackSize();
                            n2 += n3;
                            report = new Report(6390);
                            report.subject = tank.getId();
                            report.add(mounted.getName());
                            report.add(n3);
                            report.newlines = 0;
                            vector.add(report);
                        }
                        HitData hitData = new HitData(n);
                        vector.addAll(this.damageEntity(tank, hitData, n2, true));
                        break;
                    }
                    case 8: {
                        report = new Report(6615);
                        report.subject = tank.getId();
                        vector.add(report);
                        Vector<Entity> vector2 = tank.getLoadedUnits();
                        Entity entity2 = vector2.get(Compute.randomInt(vector2.size()));
                        HitData hitData = entity2.rollHitLocation(0, 0);
                        vector.addAll(this.damageEntity(entity2, hitData, 5));
                        break;
                    }
                    case 5: {
                        report = new Report(6600);
                        report.subject = tank.getId();
                        vector.add(report);
                        tank.setCommanderHit(true);
                        break;
                    }
                    case 0: {
                        report = new Report(6605);
                        report.subject = tank.getId();
                        vector.add(report);
                        tank.setCommanderHit(true);
                        break;
                    }
                    case 6: {
                        report = new Report(6190);
                        report.subject = tank.getId();
                        vector.add(report);
                        tank.getCrew().setDoomed(true);
                        break;
                    }
                    case 7: {
                        tank.stunCrew();
                        report = new Report(6185);
                        report.add(tank.getStunnedTurns() - 1);
                        report.subject = tank.getId();
                        vector.add(report);
                        break;
                    }
                    case 9: {
                        report = new Report(6210);
                        report.subject = tank.getId();
                        vector.add(report);
                        tank.immobilize();
                        tank.lockTurret();
                        for (Mounted object2 : tank.getWeaponList()) {
                            WeaponType weaponType = (WeaponType)object2.getType();
                            if (!weaponType.hasFlag(262144L)) continue;
                            object2.setBreached(true);
                        }
                        if (!(tank instanceof VTOL)) break;
                        PilotingRollData pilotingRollData = tank.getBasePilotingRoll();
                        IHex mounted = this.game.getBoard().getHex(tank.getPosition());
                        pilotingRollData.addModifier(4, "forced landing");
                        int n2 = Math.max(mounted.terrainLevel(12), mounted.terrainLevel(16));
                        n2 = Math.max(n2, 0);
                        n2 = Math.min(n2, tank.getElevation());
                        if (tank.getElevation() > n2) {
                            if (!(mounted.containsTerrain(32) || mounted.containsTerrain(23) || mounted.containsTerrain(24) || mounted.containsTerrain(25) || mounted.containsTerrain(3) || mounted.containsTerrain(4) || mounted.containsTerrain(1))) {
                                report = new Report(2180);
                                report.subject = tank.getId();
                                report.addDesc(tank);
                                report.add(pilotingRollData.getLastPlainDesc(), true);
                                vector.add(report);
                                int n3 = Compute.d6(2);
                                report = new Report(2185);
                                report.subject = tank.getId();
                                report.add(pilotingRollData.getValueAsString());
                                report.add(pilotingRollData.getDesc());
                                report.add(n3);
                                if (n3 < pilotingRollData.getValue()) {
                                    report.choose(false);
                                    vector.add(report);
                                    vector.addAll(this.crashVTOL((VTOL)tank));
                                    break;
                                }
                                report.choose(true);
                                vector.add(report);
                                tank.setElevation(n2);
                                break;
                            }
                            vector.addAll(this.crashVTOL((VTOL)tank));
                            break;
                        }
                        break block75;
                    }
                    case 10: {
                        report = new Report(6215);
                        report.subject = tank.getId();
                        vector.add(report);
                        vector.addAll(this.destroyEntity(tank, "fuel explosion", false, false));
                        break;
                    }
                    case 4: {
                        report = new Report(6620);
                        report.subject = tank.getId();
                        vector.add(report);
                        tank.setSensorHits(tank.getSensorHits() + 1);
                        break;
                    }
                    case 3: {
                        report = new Report(6625);
                        report.subject = tank.getId();
                        vector.add(report);
                        tank.setStabiliserHit(n);
                        break;
                    }
                    case 14: {
                        report = new Report(6630);
                        report.subject = tank.getId();
                        vector.add(report);
                        tank.destroyLocation(5);
                        vector.addAll(this.destroyEntity(tank, "turret blown off", true, true));
                        break;
                    }
                    case 12: {
                        report = new Report(6635);
                        report.subject = tank.getId();
                        vector.add(report);
                        tank.lockTurret();
                        break;
                    }
                    case 13: {
                        report = new Report(6640);
                        report.subject = tank.getId();
                        vector.add(report);
                        tank.lockTurret();
                        break;
                    }
                    case 2: {
                        report = new Report(6305);
                        report.subject = tank.getId();
                        ArrayList<Mounted> arrayList = new ArrayList<Mounted>();
                        for (Mounted mounted : tank.getWeaponList()) {
                            if (mounted.getLocation() != n) continue;
                            arrayList.add(mounted);
                        }
                        Mounted bl2 = (Mounted)arrayList.get(Compute.randomInt(arrayList.size()));
                        bl2.setHit(true);
                        report.add(bl2.getName());
                        vector.add(report);
                        vector.addAll(this.explodeEquipment((Entity)tank, n, bl2));
                        bl2.setDestroyed(true);
                        break;
                    }
                    case 1: {
                        report = new Report(6645);
                        report.subject = tank.getId();
                        ArrayList<Mounted> arrayList = new ArrayList<Mounted>();
                        for (Mounted mounted : tank.getWeaponList()) {
                            if (mounted.getLocation() != n) continue;
                            arrayList.add(mounted);
                        }
                        Mounted mounted = (Mounted)arrayList.get(Compute.randomInt(arrayList.size()));
                        mounted.setJammed(true);
                        report.add(mounted.getName());
                        vector.add(report);
                        break;
                    }
                    case 16: {
                        boolean bl2;
                        report = new Report(6650);
                        report.subject = tank.getId();
                        vector.add(report);
                        tank.setDriverHit(true);
                        PilotingRollData pilotingRollData = tank.getBasePilotingRoll();
                        pilotingRollData.addModifier(0, "pilot injury");
                        if (this.doSkillCheckInPlace(tank, pilotingRollData)) break;
                        report = new Report(6675);
                        report.subject = tank.getId();
                        report.addDesc(tank);
                        vector.add(report);
                        boolean bl3 = true;
                        if (tank.canGoDown()) {
                            tank.setElevation(tank.getElevation() - 1);
                            boolean bl4 = bl2 = !tank.canGoDown();
                        }
                        if (bl2) {
                            vector.addAll(this.crashVTOL((VTOL)tank));
                            break;
                        }
                        break block75;
                    }
                    case 15: {
                        report = new Report(6655);
                        report.subject = tank.getId();
                        vector.add(report);
                        tank.setCommanderHit(true);
                        break;
                    }
                    case 17: {
                        report = new Report(6660);
                        report.subject = tank.getId();
                        vector.add(report);
                        int n4 = tank.getOriginalWalkMP();
                        if (n4 > 1) {
                            tank.setOriginalWalkMP(n4 - 1);
                            break;
                        }
                        if (n4 != 1) break;
                        tank.setOriginalWalkMP(0);
                        vector.addAll(this.crashVTOL((VTOL)tank));
                        break;
                    }
                    case 18: {
                        report = new Report(6670);
                        report.subject = tank.getId();
                        vector.add(report);
                        tank.immobilize();
                        tank.destroyLocation(5);
                        vector.addAll(this.crashVTOL((VTOL)tank));
                        break;
                    }
                    case 19: {
                        report = new Report(6665);
                        report.subject = tank.getId();
                        vector.add(report);
                        tank.setStabiliserHit(5);
                    }
                }
                break block75;
            }
            if (entity instanceof BattleArmor) {
                BattleArmor battleArmor = (BattleArmor)entity;
                report = new Report(6111);
                int n7 = battleArmor.getRandomTrooper();
                battleArmor.destroyLocation(n7);
                report.add(n7);
                report.newlines = 1;
                vector.add(report);
            } else if (0 == criticalSlot.getType()) {
                criticalSlot.setHit(true);
                if (entity instanceof Protomech) {
                    int n8;
                    int n9 = ((Protomech)entity).getCritsHit(n);
                    if (criticalSlot.getIndex() != 4 && criticalSlot.getIndex() != 5) {
                        report = new Report(6225);
                        report.subject = entity.getId();
                        report.indent(3);
                        report.newlines = 0;
                        report.add(Protomech.systemNames[criticalSlot.getIndex()]);
                        vector.addElement(report);
                    }
                    block23 : switch (criticalSlot.getIndex()) {
                        case 2: {
                            if (2 != n9) break;
                            report = new Report(6230);
                            report.subject = entity.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                            entity.destroyLocation(n);
                            break;
                        }
                        case 0: {
                            if (2 != n9) break;
                            report = new Report(6235);
                            report.subject = entity.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                            entity.destroyLocation(n);
                            break;
                        }
                        case 1: {
                            if (3 != n9) break;
                            report = new Report(6240);
                            report.subject = entity.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                            entity.destroyLocation(n);
                            break;
                        }
                        case 3: {
                            if (3 == n9) {
                                vector.addAll(this.destroyEntity(entity, "torso destruction"));
                                break;
                            }
                            if (!bl) break;
                            int n10 = Compute.d6(1);
                            CriticalSlot criticalSlot2 = null;
                            switch (n10) {
                                case 1: 
                                case 2: {
                                    criticalSlot2 = new CriticalSlot(0, 4);
                                    vector.addAll(this.applyCriticalHit(entity, -1, criticalSlot2, bl));
                                    break block23;
                                }
                                case 3: 
                                case 4: {
                                    criticalSlot2 = new CriticalSlot(0, 5);
                                    vector.addAll(this.applyCriticalHit(entity, -1, criticalSlot2, bl));
                                    break block23;
                                }
                            }
                            break;
                        }
                        case 4: {
                            Mounted mounted = ((Protomech)entity).getTorsoWeapon(true);
                            if (null == mounted) break;
                            mounted.setHit(true);
                            report = new Report(6245);
                            report.subject = entity.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                            break;
                        }
                        case 5: {
                            Mounted mounted = ((Protomech)entity).getTorsoWeapon(false);
                            if (null == mounted) break;
                            mounted.setHit(true);
                            report = new Report(6250);
                            report.subject = entity.getId();
                            report.newlines = 0;
                            vector.addElement(report);
                        }
                    }
                    if (((Protomech)entity).shaded(n, n9) && Math.min(1, n8 = Protomech.POSSIBLE_PILOT_DAMAGE[n] - ((Protomech)entity).getPilotDamageTaken(n)) > 0) {
                        Report.addNewline(vector);
                        vector.addAll(this.damageCrew(entity, 1));
                        n8 = 1 + ((Protomech)entity).getPilotDamageTaken(n);
                        ((Protomech)entity).setPilotDamageTaken(n, n8);
                    }
                } else {
                    report = new Report(6225);
                    report.subject = entity.getId();
                    report.indent(3);
                    report.add(((Mech)entity).getSystemName(criticalSlot.getIndex()));
                    report.newlines = 0;
                    vector.addElement(report);
                    switch (criticalSlot.getIndex()) {
                        case 2: {
                            if (6 <= entity.getCrew().getHits()) break;
                            entity.getCrew().setDoomed(true);
                            Report.addNewline(vector);
                            vector.addAll(this.destroyEntity(entity, "pilot death", true));
                            break;
                        }
                        case 3: {
                            ++entity.engineHitsThisRound;
                            boolean bl4 = false;
                            int n11 = 0;
                            n11 += entity.getHitCriticals(0, 3, 1);
                            n11 += entity.getHitCriticals(0, 3, 2);
                            bl4 = this.checkEngineExplosion(entity, vector, n11 += entity.getHitCriticals(0, 3, 3));
                            if (bl4 || n11 <= 2) break;
                            vector.addAll(this.destroyEntity(entity, "engine destruction"));
                            if (!this.game.getOptions().booleanOption("auto_abandon_unit")) break;
                            vector.addAll(this.abandonEntity(entity));
                            break;
                        }
                        case 4: {
                            if (entity.getGyroType() != 3) {
                                if (entity.getHitCriticals(0, 4, n) > 1) {
                                    this.game.addPSR(new PilotingRollData(entity.getId(), 0x7FFFFFFE, 3, "gyro destroyed"));
                                    break;
                                }
                                this.game.addPSR(new PilotingRollData(entity.getId(), 3, "gyro hit"));
                                break;
                            }
                            int n12 = entity.getHitCriticals(0, 4, n);
                            if (n12 > 2) {
                                this.game.addPSR(new PilotingRollData(entity.getId(), 0x7FFFFFFE, 3, "gyro destroyed"));
                                break;
                            }
                            if (n12 == 1) {
                                this.game.addPSR(new PilotingRollData(entity.getId(), 2, "gyro hit"));
                                break;
                            }
                            this.game.addPSR(new PilotingRollData(entity.getId(), 3, "gyro hit"));
                            break;
                        }
                        case 12: 
                        case 13: 
                        case 14: {
                            this.game.addPSR(new PilotingRollData(entity.getId(), 1, "leg/foot actuator hit"));
                            break;
                        }
                        case 11: {
                            this.game.addPSR(new PilotingRollData(entity.getId(), 2, "hip actuator hit"));
                        }
                    }
                }
            } else if (1 == criticalSlot.getType()) {
                criticalSlot.setHit(true);
                Mounted mounted = entity.getEquipment(criticalSlot.getIndex());
                EquipmentType equipmentType = mounted.getType();
                boolean bl5 = mounted.isHit();
                report = new Report(6225);
                report.subject = entity.getId();
                report.indent(3);
                report.add(mounted.getDesc());
                report.newlines = 0;
                vector.addElement(report);
                if (equipmentType instanceof MiscType && ((MiscType)equipmentType).isShield()) {
                    mounted.setHit(false);
                } else {
                    mounted.setHit(true);
                }
                if (equipmentType instanceof MiscType && equipmentType.hasFlag(0x80000000L)) {
                    report = new Report(6254);
                    report.subject = entity.getId();
                    report.indent(2);
                    this.breachLocation(entity, n, null, true);
                }
                if (!bl5 && equipmentType instanceof MiscType && equipmentType.hasFlag(1024L) && mounted.getLinkedBy() != null) {
                    Mounted mounted2 = mounted.getLinkedBy();
                    report = new Report(6255);
                    report.subject = entity.getId();
                    report.indent(2);
                    report.add(mounted2.getType().getName());
                    report.newlines = 0;
                    vector.addElement(report);
                    mounted2.setMode("Off");
                }
                if ((bl && equipmentType.isExplosive() || mounted.isHotLoaded()) && !bl5) {
                    vector.addAll(this.explodeEquipment(entity, n, mounted));
                }
                if (mounted.getShotsLeft() > 0) {
                    mounted.setShotsLeft(0);
                }
            }
        }
        if (entity instanceof Mech && entity.hitThisRoundByAntiTSM) {
            Mech mech = (Mech)entity;
            if (mech.hasTSM()) {
                report = new Report(6430);
                report.subject = entity.getId();
                report.indent(2);
                report.addDesc(entity);
                report.newlines = 0;
                vector.addElement(report);
                vector.addAll(this.oneCriticalEntity(entity, Compute.d6(2)));
            }
            entity.hitThisRoundByAntiTSM = false;
        }
        return vector;
    }

    private Vector<Report> criticalEntity(Entity entity, int n, int n2) {
        return this.criticalEntity(entity, n, n2, true);
    }

    private Vector<Report> oneCriticalEntity(Entity entity, int n) {
        return this.criticalEntity(entity, n, 0, false);
    }

    private Vector<Report> crashVTOL(VTOL vTOL) {
        return this.crashVTOL(vTOL, false, 0, vTOL.getPosition(), vTOL.getElevation(), 0);
    }

    private Vector<Report> crashVTOL(VTOL vTOL, boolean bl, int n, Coords coords, int n2, int n3) {
        Vector<Report> vector = new Vector<Report>();
        if (!bl) {
            int n4;
            int n5;
            int n6;
            int n7;
            String string;
            Report report = new Report(6260);
            report.subject = vTOL.getId();
            report.newlines = 0;
            report.addDesc(vTOL);
            vector.addElement(report);
            int n8 = 0;
            IHex iHex = this.game.getBoard().getHex(coords);
            if (iHex.containsTerrain(12)) {
                n8 = iHex.terrainLevel(12);
            } else if (iHex.containsTerrain(16) && (n8 = iHex.terrainLevel(16)) > n2) {
                n8 = 0;
            }
            int n9 = n2 - n8;
            if (n9 == 0) {
                report = new Report(6265);
                report.subject = vTOL.getId();
                vector.addElement(report);
                return new Vector<Report>();
            }
            vTOL.setElevation(n8);
            report = new Report(6270);
            report.subject = vTOL.getId();
            report.add(n9);
            vector.addElement(report);
            int n10 = Compute.d6();
            switch (n10) {
                case 1: 
                case 2: {
                    string = "right side";
                    n7 = 3;
                    break;
                }
                case 3: {
                    string = "rear";
                    n7 = 1;
                    break;
                }
                case 4: 
                case 5: {
                    string = "left side";
                    n7 = 2;
                    break;
                }
                default: {
                    string = "front";
                    n7 = 0;
                }
            }
            if (n8 <= 0) {
                n6 = iHex.containsTerrain(4);
                if (n6 != 0 && iHex.containsTerrain(20)) {
                    n5 = Compute.d6(1);
                    report = new Report(2118);
                    report.subject = vTOL.getId();
                    report.add(vTOL.getDisplayName(), true);
                    report.add(n5);
                    report.subject = vTOL.getId();
                    this.addReport(report);
                    if (n5 == 6) {
                        this.resolveIceBroken(coords);
                    } else {
                        n6 = 0;
                    }
                }
                if (n6 != 0) {
                    report = new Report(6275);
                    report.subject = vTOL.getId();
                    vector.addElement(report);
                    vTOL.destroy("Fell into water", false, false);
                }
            }
            n6 = (int)Math.round((double)vTOL.getWeight() / 10.0) * (n9 + 1);
            report = new Report(6280);
            report.subject = vTOL.getId();
            report.indent();
            report.addDesc(vTOL);
            report.add(string);
            report.add(n6);
            report.newlines = 0;
            vector.addElement(report);
            vTOL.setFacing((vTOL.getFacing() + (n10 - 1)) % 6);
            n5 = 0;
            for (n6 = Math.round((float)n6 * this.game.getOptions().floatOption("gravity")); n6 > 0; n6 -= n4) {
                n4 = Math.min(5, n6);
                HitData hitData = vTOL.rollHitLocation(0, n7);
                int[] nArray = new int[]{vTOL.getInternal(1), vTOL.getInternal(2), vTOL.getInternal(3), vTOL.getInternal(4)};
                vector.addAll(this.damageEntity(vTOL, hitData, n4));
                int[] nArray2 = new int[]{vTOL.getInternal(1), vTOL.getInternal(2), vTOL.getInternal(3), vTOL.getInternal(4)};
                for (int i = 0; i <= 3; ++i) {
                    if (nArray[i] == nArray2[i]) continue;
                    n5 = 1;
                }
            }
            if (n5 != 0) {
                report = new Report(6285);
                report.subject = vTOL.getId();
                report.addDesc(vTOL);
                vector.addElement(report);
                vector.addAll(this.explodeVTOL(vTOL));
            }
            this.doSetLocationsExposure(vTOL, iHex, false, n8);
        } else {
            int n11;
            vTOL.setElevation(0);
            Report report = new Report(6290);
            report.subject = vTOL.getId();
            report.addDesc(vTOL);
            vector.addElement(report);
            boolean bl2 = false;
            for (int i = (int)Math.round((double)vTOL.getWeight() / 10.0) * (n + 1); i > 0; i -= n11) {
                n11 = Math.min(5, i);
                HitData hitData = vTOL.rollHitLocation(0, n3);
                int[] nArray = new int[]{vTOL.getInternal(1), vTOL.getInternal(2), vTOL.getInternal(3), vTOL.getInternal(4)};
                vector.addAll(this.damageEntity(vTOL, hitData, n11));
                int[] nArray3 = new int[]{vTOL.getInternal(1), vTOL.getInternal(2), vTOL.getInternal(3), vTOL.getInternal(4)};
                for (int j = 0; j <= 3; ++j) {
                    if (nArray[j] == nArray3[j]) continue;
                    bl2 = true;
                }
            }
            if (bl2) {
                report = new Report(6295);
                report.subject = vTOL.getId();
                report.addDesc(vTOL);
                vector.addElement(report);
                vector.addAll(this.explodeVTOL(vTOL));
            }
        }
        return vector;
    }

    private Vector<Report> explodeVTOL(VTOL vTOL) {
        Vector<Report> vector = new Vector<Report>();
        if (vTOL.getEngine().isFusion()) {
            Report report = new Report(6300);
            report.subject = vTOL.getId();
            vector.addElement(report);
        } else {
            Coords coords = vTOL.getPosition();
            if (this.game.getOptions().booleanOption("fire")) {
                IHex iHex = this.game.getBoard().getHex(coords);
                if (iHex.containsTerrain(1) || iHex.containsTerrain(23)) {
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                } else {
                    this.game.getBoard().addInfernoTo(coords, InfernoTracker.STANDARD_ROUND, 1);
                    this.game.getBoard().getInfernos().get(coords).setTurnsLeftToBurn(this.game.getBoard().getInfernoBurnTurns(coords) - 2);
                    iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
                    this.sendChangedHex(coords);
                }
            }
            this.destroyEntity(vTOL, "crashed and burned", false, false);
        }
        return vector;
    }

    private Vector<Report> criticalTank(Tank tank, int n, int n2) {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(6305);
        report.subject = tank.getId();
        report.indent(2);
        report.add(tank.getLocationAbbr(n));
        report.newlines = 0;
        vector.add(report);
        int n3 = Compute.d6(2);
        report = new Report(6310);
        report.subject = tank.getId();
        String string = "";
        if (n2 != 0) {
            string = "(" + n3;
            if (n2 > 0) {
                string = string + "+";
            }
            string = string + n2 + ") = ";
            n3 += n2;
        }
        string = string + n3;
        report.add(string);
        report.newlines = 0;
        vector.add(report);
        int n4 = tank.getCriticalEffect(n3, n);
        vector.addAll(this.applyCriticalHit(tank, n, new CriticalSlot(0, n4), true));
        return vector;
    }

    private Vector<Report> criticalEntity(Entity entity, int n, int n2, boolean bl) {
        int n3;
        int n4;
        Report report;
        if (entity instanceof Tank) {
            return this.criticalTank((Tank)entity, n, n2);
        }
        CriticalSlot criticalSlot = null;
        Vector<Report> vector = new Vector<Report>();
        Coords coords = entity.getPosition();
        IHex iHex = null;
        if (bl) {
            if (null != coords) {
                iHex = this.game.getBoard().getHex(coords);
            }
            report = new Report(6305);
            report.subject = entity.getId();
            report.indent(2);
            report.add(entity.getLocationAbbr(n));
            report.newlines = 0;
            vector.addElement(report);
            n4 = 0;
            n3 = Compute.d6(2);
            report = new Report(6310);
            report.subject = entity.getId();
            String string = "";
            if (n2 != 0) {
                string = "(" + n3;
                if (n2 > 0) {
                    string = string + "+";
                }
                string = string + n2 + ") = ";
                n3 += n2;
            }
            string = string + n3;
            report.add(string);
            report.newlines = 0;
            vector.addElement(report);
            if (n3 <= 7) {
                report = new Report(6005);
                report.subject = entity.getId();
                report.newlines = 0;
                vector.addElement(report);
                return vector;
            }
            if (n3 >= 8 && n3 <= 9) {
                n4 = 1;
                report = new Report(6315);
                report.subject = entity.getId();
                report.newlines = 0;
                vector.addElement(report);
            } else if (n3 >= 10 && n3 <= 11) {
                n4 = 2;
                report = new Report(6320);
                report.subject = entity.getId();
                report.newlines = 0;
                vector.addElement(report);
            } else if (n3 == 12) {
                if (entity instanceof Protomech) {
                    n4 = 3;
                    report = new Report(6325);
                    report.subject = entity.getId();
                    report.newlines = 0;
                    vector.addElement(report);
                } else {
                    if (entity.locationIsLeg(n)) {
                        report = new Report(6120);
                        report.subject = entity.getId();
                        report.add(entity.getLocationName(n));
                        report.newlines = 0;
                        vector.addElement(report);
                        if (entity.getInternal(n) > 0) {
                            entity.destroyLocation(n);
                        }
                        if (null != iHex) {
                            if (!iHex.containsTerrain(19)) {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(19, 1));
                            } else {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(19, iHex.terrainLevel(19) + 1));
                            }
                        }
                        this.sendChangedHex(entity.getPosition());
                        return vector;
                    }
                    if (n == 4 || n == 5) {
                        report = new Report(6120);
                        report.subject = entity.getId();
                        report.add(entity.getLocationName(n));
                        report.newlines = 0;
                        vector.addElement(report);
                        entity.destroyLocation(n);
                        if (null != iHex) {
                            if (!iHex.containsTerrain(18)) {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(18, 1));
                            } else {
                                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(18, iHex.terrainLevel(18) + 1));
                            }
                        }
                        this.sendChangedHex(entity.getPosition());
                        return vector;
                    }
                    if (n == 0) {
                        report = new Report(6330);
                        report.subject = entity.getId();
                        report.add(entity.getLocationName(n));
                        report.newlines = 0;
                        vector.addElement(report);
                        entity.destroyLocation(n);
                        if (((Mech)entity).getCockpitType() != 1 && 6 > entity.getCrew().getHits()) {
                            entity.crew.setDoomed(true);
                            Report.addNewline(vector);
                            vector.addAll(this.destroyEntity(entity, "pilot death", true));
                        }
                        return vector;
                    }
                    n4 = 3;
                    report = new Report(6325);
                    report.subject = entity.getId();
                    report.newlines = 0;
                    vector.addElement(report);
                }
            }
        } else {
            n4 = 1;
        }
        while (n4 > 0 && entity.canTransferCriticals(n) && entity.getTransferLocation(n) != -2 && entity.getTransferLocation(n) != -1) {
            n = entity.getTransferLocation(n);
            report = new Report(6335);
            report.subject = entity.getId();
            report.indent(3);
            report.add(entity.getLocationAbbr(n));
            report.newlines = 0;
            vector.addElement(report);
        }
        while (n4 > 0) {
            if (entity.getHittableCriticals(n) <= 0) {
                report = new Report(6340);
                report.subject = entity.getId();
                report.indent(3);
                report.newlines = 0;
                vector.addElement(report);
                break;
            }
            n3 = Compute.randomInt(entity.getNumberOfCriticals(n));
            criticalSlot = entity.getCritical(n, n3);
            if (criticalSlot == null || !criticalSlot.isHittable()) continue;
            if (entity instanceof Mech && entity.crew.hasEdgeRemaining() && entity.crew.getOptions().booleanOption("edge_when_explosion") && criticalSlot.getType() == 1 && entity.getEquipment(criticalSlot.getIndex()).getType().isExplosive()) {
                entity.crew.decreaseEdge();
                report = new Report(6530);
                report.subject = entity.getId();
                report.indent(3);
                report.newlines = 0;
                report.add(entity.crew.getOptions().intOption("edge"));
                vector.addElement(report);
                continue;
            }
            vector.addAll(this.applyCriticalHit(entity, n, criticalSlot, true));
            --n4;
        }
        return vector;
    }

    private Vector<Report> breachCheck(Entity entity, int n, IHex iHex) {
        Vector<Report> vector = new Vector<Report>();
        if (entity instanceof Infantry) {
            return vector;
        }
        if (entity instanceof VTOL) {
            return vector;
        }
        boolean bl = false;
        for (Mounted mounted : entity.getAmmo()) {
            if (!mounted.isDumping()) continue;
            bl = true;
            break;
        }
        if (entity.getLocationStatus(n) > 0) {
            Report report;
            int n2 = 0;
            if (!(entity.getArmor(n) <= 0 || entity instanceof Mech && entity.getArmor(n, true) <= 0 || null != iHex)) {
                if (entity instanceof Mech && ((Mech)entity).hasHarJelIn(n)) {
                    Report report2 = new Report(6342);
                    report2.subject = entity.getId();
                    report2.indent(3);
                    vector.addElement(report2);
                    return vector;
                }
                n2 = Compute.d6(2);
                report = new Report(6345);
                report.subject = entity.getId();
                report.indent(3);
                report.add(entity.getLocationAbbr(n));
                report.add(n2);
                report.newlines = 0;
                vector.addElement(report);
            }
            if (n2 >= 10 || entity.getArmor(n) <= 0 || bl && (!(entity instanceof Mech) || n == 1 || n == 2 || n == 3) || entity instanceof Mech && entity.getArmor(n, true) <= 0) {
                if (entity instanceof Mech && ((Mech)entity).hasHarJelIn(n)) {
                    report = new Report(6342);
                    report.subject = entity.getId();
                    report.indent(3);
                    vector.addElement(report);
                    return vector;
                }
                vector.addAll(this.breachLocation(entity, n, iHex, false));
            }
        }
        return vector;
    }

    private Vector<Report> breachLocation(Entity entity, int n, IHex iHex, boolean bl) {
        Vector<Report> vector = new Vector<Report>();
        if (entity.getInternal(n) < 0 || entity.getLocationStatus(n) < 0) {
            return vector;
        }
        Report report = new Report(6350);
        if (bl) {
            report.messageId = 6351;
        }
        report.subject = entity.getId();
        report.add(entity.getShortName());
        report.add(entity.getLocationAbbr(n));
        report.newlines = 0;
        vector.addElement(report);
        if (entity instanceof Tank) {
            vector.addAll(this.destroyEntity(entity, "hull breach", true, true));
            return vector;
        }
        for (Mounted serializable : entity.getEquipment()) {
            if (serializable.getLocation() != n) continue;
            serializable.setBreached(true);
        }
        for (int i = 0; i < entity.getNumberOfCriticals(n); ++i) {
            CriticalSlot criticalSlot = entity.getCritical(n, i);
            if (criticalSlot == null) continue;
            if (entity.locationIsLeg(n) && criticalSlot.isHittable()) {
                switch (criticalSlot.getIndex()) {
                    case 12: 
                    case 13: 
                    case 14: {
                        this.game.addPSR(new PilotingRollData(entity.getId(), 1, "leg/foot actuator hit"));
                        break;
                    }
                    case 11: {
                        this.game.addPSR(new PilotingRollData(entity.getId(), 0, "hip actuator hit"));
                    }
                }
            }
            criticalSlot.setBreached(true);
        }
        if (n == 1) {
            vector.addAll(this.destroyEntity(entity, "hull breach"));
            if (this.game.getOptions().booleanOption("auto_abandon_unit")) {
                vector.addAll(this.abandonEntity(entity));
            }
        }
        if (n == 0) {
            entity.crew.setDoomed(true);
            vector.addAll(this.destroyEntity(entity, "hull breach"));
            if (entity.getLocationStatus(n) == 2) {
                report = new Report(6355);
                report.subject = entity.getId();
                report.addDesc(entity);
                vector.addElement(report);
            } else {
                report = new Report(6360);
                report.subject = entity.getId();
                report.addDesc(entity);
                vector.addElement(report);
            }
        }
        entity.setLocationStatus(n, -1);
        if (entity.getHitCriticals(0, 3, 3) + entity.getHitCriticals(0, 3, 1) + entity.getHitCriticals(0, 3, 2) >= 3) {
            vector.addAll(this.destroyEntity(entity, "engine destruction"));
            if (this.game.getOptions().booleanOption("auto_abandon_unit")) {
                vector.addAll(this.abandonEntity(entity));
            }
        }
        return vector;
    }

    private Vector<Report> destroyEntity(Entity entity, String string) {
        return this.destroyEntity(entity, string, true);
    }

    private Vector<Report> destroyEntity(Entity entity, String string, boolean bl) {
        return this.destroyEntity(entity, string, bl, true);
    }

    private Vector<Report> destroyEntity(Entity entity, String string, boolean bl, boolean bl2) {
        return this.destroyEntity(entity, string, bl, bl2, false);
    }

    private Vector<Report> destroyEntity(Entity entity, String string, boolean bl, boolean bl2, boolean bl3) {
        Vector<Report> vector = new Vector<Report>();
        int n = 512;
        if (!bl2) {
            entity.setSalvage(bl2);
            n = 1024;
        }
        if (bl3) {
            n = 4096;
        }
        if (!entity.isDoomed() && !entity.isDestroyed()) {
            int n2;
            int n3;
            int n4;
            Object object;
            Serializable serializable;
            Entity entity2;
            Object object2;
            Report report = new Report(6365);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(string);
            report.newlines = 0;
            vector.addElement(report);
            entity.setDoomed(true);
            Enumeration<Object> enumeration = entity.getPickedUpMechWarriors().elements();
            while (enumeration.hasMoreElements()) {
                object2 = (Integer)enumeration.nextElement();
                entity2 = this.game.getEntity((Integer)object2);
                entity2.setDestroyed(true);
                this.game.removeEntity(entity2.getId(), n);
                this.entityUpdate(entity2.getId());
                this.send(this.createRemoveEntityPacket(entity2.getId(), n));
                report = new Report(6370);
                report.subject = entity2.getId();
                report.addDesc(entity2);
                vector.addElement(report);
            }
            object2 = entity.getExternalUnits();
            enumeration = entity.getLoadedUnits().elements();
            if (enumeration.hasMoreElements()) {
                entity2 = null;
                serializable = entity.getPosition();
                object = this.game.getBoard().getHex((Coords)serializable);
                n4 = entity.getFacing();
                while (enumeration.hasMoreElements()) {
                    entity2 = (Entity)enumeration.nextElement();
                    if (!bl || ((ArrayList)object2).contains(entity2) && Compute.d6() >= 3) {
                        entity2.setDestroyed(true);
                        this.game.moveToGraveyard(entity2.getId());
                        this.entityUpdate(entity2.getId());
                        this.send(this.createRemoveEntityPacket(entity2.getId(), n));
                        report = new Report(6370);
                        report.subject = entity2.getId();
                        report.addDesc(entity2);
                        vector.addElement(report);
                        continue;
                    }
                    if (null != Compute.stackingViolation(this.game, entity2.getId(), (Coords)serializable) || entity2.isHexProhibited((IHex)object)) {
                        entity2.setDestroyed(true);
                        this.game.moveToGraveyard(entity2.getId());
                        this.entityUpdate(entity2.getId());
                        this.send(this.createRemoveEntityPacket(entity2.getId(), n));
                        report = new Report(6375);
                        report.subject = entity2.getId();
                        report.addDesc(entity2);
                        vector.addElement(report);
                        continue;
                    }
                    this.unloadUnit(entity, entity2, (Coords)serializable, n4, entity.getElevation());
                }
            }
            if (-1 != entity.getTransportId()) {
                entity2 = this.game.getEntity(entity.getTransportId());
                serializable = entity2.getPosition();
                int n5 = entity2.getFacing();
                this.unloadUnit(entity2, entity, (Coords)serializable, n5, entity2.getElevation());
                this.entityUpdate(entity2.getId());
            }
            if (-1 != (n3 = entity.getSwarmAttackerId())) {
                serializable = this.game.getEntity(n3);
                this.game.removeTurnFor((Entity)serializable);
                this.send(this.createTurnVectorPacket());
                ((Entity)serializable).setSwarmTargetId(-1);
                entity.setSwarmAttackerId(-1);
                report = new Report(6380);
                report.subject = n3;
                report.addDesc((Entity)serializable);
                vector.addElement(report);
                this.entityUpdate(n3);
            }
            if (-1 != (n2 = entity.getSwarmTargetId())) {
                object = this.game.getEntity(n2);
                ((Entity)object).setSwarmAttackerId(-1);
                entity.setSwarmTargetId(-1);
                report = new Report(6385);
                report.subject = ((Entity)object).getId();
                report.addDesc((Entity)object);
                vector.addElement(report);
                this.entityUpdate(n2);
            }
            if (entity instanceof Mech && (n4 = ((Mech)(object = (Mech)entity)).getGrappled()) != -1) {
                ((Mech)object).setGrappled(-1, false);
                Entity entity3 = this.game.getEntity(n4);
                if (entity3 != null && entity3 instanceof Mech) {
                    ((Mech)entity3).setGrappled(-1, false);
                }
                this.entityUpdate(n4);
            }
        }
        this.entityUpdate(entity.getId());
        return vector;
    }

    private Vector<Report> explodeEquipment(Entity entity, int n, int n2) {
        return this.explodeEquipment(entity, n, entity.getEquipment(entity.getCritical(n, n2).getIndex()));
    }

    private Vector<Report> explodeEquipment(Entity entity, int n, Mounted mounted) {
        int n2;
        int n3;
        Object object;
        Vector<Report> vector = new Vector<Report>();
        if (mounted.isDestroyed()) {
            System.err.println("server: explodeEquipment called on destroyed equipment (" + mounted.getName() + ')');
            return vector;
        }
        if (mounted.getType() instanceof WeaponType && ((WeaponType)mounted.getType()).getAmmoType() == 23 && !mounted.isJammed()) {
            return vector;
        }
        if (mounted.getType() instanceof WeaponType && (((WeaponType)mounted.getType()).getAmmoType() == 1 || ((WeaponType)mounted.getType()).getAmmoType() == 35)) {
            if (!mounted.isUsedThisRound()) {
                return vector;
            }
            Mounted mounted2 = mounted.getLinked();
            if (mounted2 == null || !(mounted2.getType() instanceof AmmoType) || ((AmmoType)mounted2.getType()).getMunitionType() != 8L) {
                return vector;
            }
            object = (WeaponType)mounted.getType();
            if (((WeaponType)object).getAmmoType() == 7 || ((WeaponType)object).getAmmoType() == 32 || ((WeaponType)object).getAmmoType() == 8 || ((WeaponType)object).getAmmoType() == 27) {
                return vector;
            }
        }
        if (mounted.getType() instanceof AmmoType && (((AmmoType)mounted.getType()).getAmmoType() == 9 || ((AmmoType)mounted.getType()).getAmmoType() == 25 || ((AmmoType)mounted.getType()).getAmmoType() == 50) && ((AmmoType)mounted.getType()).getMunitionType() == 0x400000L && mounted.getShotsLeft() > 0) {
            entity.heatBuildup += Math.min(mounted.getExplosionDamage(), 30);
        }
        if ((n3 = mounted.getExplosionDamage()) <= 0) {
            return vector;
        }
        object = new Report(6390);
        ((Report)object).subject = entity.getId();
        ((Report)object).add(mounted.getName());
        ((Report)object).add(n3);
        ((Report)object).indent(3);
        ((Report)object).newlines = 0;
        vector.addElement((Report)object);
        if (mounted.getType() instanceof WeaponType && mounted.isHotLoaded()) {
            n2 = Compute.d6(2);
            int n4 = 0;
            object = new Report(6077);
            ((Report)object).subject = entity.getId();
            ((Report)object).add(n2);
            ((Report)object).indent(2);
            vector.addElement((Report)object);
            if (n2 < 6) {
                for (Mounted mounted3 : entity.getAmmo()) {
                    if (mounted3.getLocation() != n || mounted3.getExplosionDamage() <= 0 || ((AmmoType)mounted3.getType()).getMunitionType() == 0x1000000000L) continue;
                    ++n4;
                    vector.addAll(this.explodeEquipment(entity, n, mounted3));
                }
                if (n4 == 0) {
                    object = new Report(6078);
                    ((Report)object).subject = entity.getId();
                    ((Report)object).indent(2);
                    vector.addElement((Report)object);
                }
            } else {
                object = new Report(6079);
                ((Report)object).subject = entity.getId();
                ((Report)object).indent(2);
                vector.addElement((Report)object);
            }
        }
        mounted.setShotsLeft(0);
        vector.addAll(this.damageEntity(entity, new HitData(n), n3, true));
        Report.addNewline(vector);
        n2 = 2;
        if (entity.getCrew().getOptions().booleanOption("pain_resistance")) {
            n2 = 1;
        }
        if (entity.getCrew().getOptions().booleanOption("iron_man")) {
            n2 = 1;
        }
        vector.addAll(this.damageCrew(entity, n2));
        if (entity.crew.isDoomed() || entity.crew.isDead()) {
            vector.addAll(this.destroyEntity(entity, "crew death", true));
        } else {
            Report.addNewline(vector);
        }
        return vector;
    }

    private Vector<Report> explodeAmmoFromHeat(Entity entity) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        Vector<Report> vector = new Vector<Report>();
        for (int i = 0; i < entity.locations(); ++i) {
            for (int j = 0; j < entity.getNumberOfCriticals(i); ++j) {
                AmmoType ammoType;
                Mounted mounted;
                CriticalSlot criticalSlot = entity.getCritical(i, j);
                if (criticalSlot == null || criticalSlot.isDestroyed() || criticalSlot.isHit() || criticalSlot.getType() != 1 || !((mounted = entity.getEquipment(entity.getCritical(i, j).getIndex())).getType() instanceof AmmoType) || !(ammoType = (AmmoType)mounted.getType()).isExplosive() || mounted.getShotsLeft() == 0) continue;
                int n5 = ammoType.getDamagePerShot() * ammoType.getRackSize();
                int n6 = mounted.getExplosionDamage();
                if (mounted.isHit() || n2 >= n5 && (n2 != n5 || n >= n6)) continue;
                n2 = n5;
                n = n6;
                n3 = i;
                n4 = j;
            }
        }
        if (n3 != -1 && n4 != -1) {
            CriticalSlot criticalSlot = entity.getCritical(n3, n4);
            criticalSlot.setHit(true);
            entity.getEquipment(criticalSlot.getIndex()).setHit(true);
            vector = this.explodeEquipment(entity, n3, n4);
        } else {
            Report report = new Report(5105);
            report.subject = entity.getId();
            report.indent();
            vector.addElement(report);
        }
        return vector;
    }

    private void doEntityFall(Entity entity, Coords coords, int n, int n2, PilotingRollData pilotingRollData) {
        int n3;
        Report report;
        int n4;
        int n5;
        String string;
        IHex iHex = this.game.getBoard().getHex(coords);
        if (entity.isMakingDfa()) {
            Report report2 = new Report(2305);
            report2.subject = entity.getId();
            this.addReport(report2);
            entity.setProne(true);
            return;
        }
        switch (n2) {
            case 1: 
            case 2: {
                string = "right side";
                n5 = 3;
                break;
            }
            case 3: {
                string = "rear";
                n5 = 1;
                break;
            }
            case 4: 
            case 5: {
                string = "left side";
                n5 = 2;
                break;
            }
            default: {
                string = "front";
                n5 = 0;
            }
        }
        int n6 = iHex.terrainLevel(4);
        int n7 = iHex.terrainLevel(14) + iHex.depth();
        int n8 = n;
        if (n >= n7 && n7 >= 0) {
            n8 -= n7;
            n6 = 0;
            n4 = iHex.terrainLevel(14);
        } else if (iHex.containsTerrain(20) && n >= iHex.depth()) {
            n8 -= iHex.depth();
            n6 = 0;
            n4 = 0;
        } else if (n6 > 0) {
            n8 = n - n6;
            n4 = -n6;
        } else if (iHex.containsTerrain(12)) {
            Building building = this.game.getBoard().getBuildingAt(coords);
            n4 = building.getType() == 5 ? Math.max(iHex.getElevation(), iHex.terrainLevel(12)) : 0;
            n6 = 0;
        } else {
            n6 = 0;
            n4 = 0;
        }
        if (n6 > 0 && !(entity instanceof Mech) && !(entity instanceof Protomech) && entity.getRunMP() > 0 && entity.getMovementMode() != 5 && entity.getMovementMode() != 8 && entity.getMovementMode() != 7 && entity.getMovementMode() != 9 && entity.getMovementMode() != 18) {
            this.addReport(this.destroyEntity(entity, "a watery grave", false));
            return;
        }
        int n9 = (int)Math.round((double)entity.getWeight() / 10.0) * (n8 + 1);
        int n10 = 0;
        if (n6 > 0) {
            n9 /= 2;
            n10 = (int)Math.round((double)entity.getWeight() / 10.0) * (n6 + 1) / 2;
        }
        if (n6 > n) {
            n9 = 0;
            n10 = (int)Math.round((double)entity.getWeight() / 10.0) * (n + 1) / 2;
        }
        n9 = Math.round((float)n9 * this.game.getOptions().floatOption("gravity"));
        if ((n10 = Math.round((float)n10 * this.game.getOptions().floatOption("gravity"))) == 0) {
            report = new Report(2310);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.addDesc(entity);
            report.add(string);
            report.add(n9);
        } else if (n9 > 0) {
            report = new Report(2315);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.addDesc(entity);
            report.add(string);
            report.add(n9);
            report.add(n10);
        } else {
            report = new Report(2310);
            report.subject = entity.getId();
            report.indent();
            report.newlines = 0;
            report.addDesc(entity);
            report.add(string);
            report.add(n10);
        }
        this.addReport(report);
        n9 += n10;
        int n11 = entity.getSwarmAttackerId();
        if (entity instanceof Mech) {
            entity.setProne(true);
        }
        entity.setPosition(coords);
        entity.setFacing((entity.getFacing() + (n2 - 1)) % 6);
        entity.setSecondaryFacing(entity.getFacing());
        entity.setElevation(n4);
        if (n6 > 0) {
            for (n3 = 0; n3 < entity.locations(); ++n3) {
                entity.setLocationStatus(n3, 2);
            }
        }
        while (n9 > 0) {
            n3 = Math.min(5, n9);
            HitData hitData = entity.rollHitLocation(0, n5);
            hitData.makeFallDamage(true);
            this.addReport(this.damageEntity(entity, hitData, n3));
            n9 -= n3;
        }
        this.doSetLocationsExposure(entity, iHex, false, -n6);
        pilotingRollData.removeAutos();
        if (n > 0) {
            pilotingRollData.addModifier(n, "height of fall");
        }
        entity.addPilotingModifierForTerrain(pilotingRollData, coords);
        if (pilotingRollData.getValue() == Integer.MAX_VALUE) {
            report = new Report(2320);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.crew.getName());
            report.indent();
            this.addReport(report);
            this.addReport(this.damageCrew(entity, 1));
            ++this.vPhaseReport.elementAt((int)(this.vPhaseReport.size() - 1)).newlines;
        } else {
            n3 = Compute.d6(2);
            report = new Report(2325);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(entity.crew.getName());
            report.add(pilotingRollData.getValueAsString());
            report.add(n3);
            if (n3 >= pilotingRollData.getValue()) {
                report.choose(true);
                this.addReport(report);
            } else {
                report.choose(false);
                this.addReport(report);
                this.addReport(this.damageCrew(entity, 1));
                ++this.vPhaseReport.elementAt((int)(this.vPhaseReport.size() - 1)).newlines;
            }
        }
        if (-1 != n11) {
            Entity entity2 = this.game.getEntity(n11);
            entity.setSwarmAttackerId(-1);
            entity2.setSwarmTargetId(-1);
            if (n6 > 0 && entity2.getMovementMode() != 18) {
                entity2.setPosition(coords);
                report = new Report(2330);
                report.newlines = 0;
                report.subject = entity2.getId();
                report.addDesc(entity2);
                this.addReport(report);
                this.addReport(this.destroyEntity(entity2, "a watery grave", false));
            } else {
                report = new Report(2335);
                report.newlines = 0;
                report.subject = entity2.getId();
                report.addDesc(entity2);
                this.addReport(report);
                this.addReport(this.damageEntity(entity2, entity2.rollHitLocation(0, 0), Compute.d6(2)));
                ++this.vPhaseReport.elementAt((int)(this.vPhaseReport.size() - 1)).newlines;
            }
            entity2.setPosition(coords);
            this.entityUpdate(n11);
            if (!entity2.isDone()) {
                entity2.setDone(true);
                this.game.removeTurnFor(entity2);
                this.send(this.createTurnVectorPacket());
            }
        }
        this.game.resetPSRs(entity);
    }

    private void doEntityFall(Entity entity, Coords coords, int n, PilotingRollData pilotingRollData) {
        this.doEntityFall(entity, coords, n, Compute.d6(1), pilotingRollData);
    }

    private void doEntityFall(Entity entity, PilotingRollData pilotingRollData) {
        this.doEntityFall(entity, entity.getPosition(), entity.getElevation() + this.game.getBoard().getHex(entity.getPosition()).depth(), pilotingRollData);
    }

    private void resolveAmmoDumps() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            for (Mounted mounted : entity.getAmmo()) {
                Report report;
                if (mounted.isPendingDump()) {
                    report = new Report(5110);
                    report.subject = entity.getId();
                    report.addDesc(entity);
                    report.add(mounted.getName());
                    this.addReport(report);
                    mounted.setPendingDump(false);
                    mounted.setDumping(true);
                    continue;
                }
                if (!mounted.isDumping()) continue;
                report = new Report(5115);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.add(mounted.getName());
                this.addReport(report);
                mounted.setDumping(false);
                mounted.setShotsLeft(0);
            }
            entity.reloadEmptyWeapons();
        }
    }

    public boolean ignite(IHex iHex, int n, boolean bl, int n2) {
        if (!this.game.getOptions().booleanOption("fire") || null == iHex) {
            return false;
        }
        if (iHex.containsTerrain(7)) {
            return true;
        }
        if (!(bl || iHex.containsTerrain(1) || iHex.containsTerrain(23) || iHex.containsTerrain(32) || iHex.containsTerrain(10))) {
            return false;
        }
        int n3 = Compute.d6(2);
        if (n2 != -1) {
            Report report = new Report(3430);
            report.indent(3);
            report.subject = n2;
            report.add(n);
            report.add(n3);
            this.addReport(report);
        }
        if (n3 >= n) {
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(7, 1));
            return true;
        }
        return false;
    }

    public boolean ignite(IHex iHex, int n, boolean bl) {
        return this.ignite(iHex, n, bl, -1);
    }

    public boolean ignite(IHex iHex, int n) {
        return this.ignite(iHex, n, false, -1);
    }

    public void removeFire(int n, int n2, IHex iHex) {
        Coords coords = new Coords(n, n2);
        iHex.removeTerrain(7);
        this.sendChangedHex(coords);
        if (!this.game.getOptions().booleanOption("maxtech_fire")) {
            int n3 = this.game.getWindDirection();
            this.removeSmoke(n, n2, n3);
            this.removeSmoke(n, n2, (n3 + 1) % 6);
            this.removeSmoke(n, n2, (n3 + 5) % 6);
        }
        Report report = new Report(5170, 0);
        report.add(coords.getBoardNum());
        this.addReport(report);
    }

    public void addSmoke(int n, int n2, int n3) {
        Coords coords = new Coords(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex != null && !iHex.containsTerrain(8)) {
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 1));
            this.sendChangedHex(coords);
            Report report = new Report(5175, 0);
            report.add(coords.getBoardNum());
            this.addReport(report);
        }
    }

    public void addL3Smoke(int n, int n2) {
        IBoard iBoard = this.game.getBoard();
        Coords coords = new Coords(n, n2);
        IHex iHex = this.game.getBoard().getHex(coords);
        boolean bl = iBoard.isInfernoBurning(coords);
        if (iHex == null) {
            return;
        }
        if (bl || 2 < iHex.terrainLevel(32) || 2 < iHex.terrainLevel(10)) {
            if (iHex.terrainLevel(8) == 2) {
                Report report = new Report(5180, 0);
                report.add(coords.getBoardNum());
                this.addReport(report);
            } else {
                if (iHex.terrainLevel(8) == 1) {
                    iHex.removeTerrain(8);
                }
                iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 2));
                this.sendChangedHex(coords);
                Report report = new Report(5185, 0);
                report.add(coords.getBoardNum());
                this.addReport(report);
            }
        } else if (iHex.terrainLevel(8) == 2) {
            Report report = new Report(5190, 0);
            report.add(coords.getBoardNum());
            this.addReport(report);
        } else if (iHex.terrainLevel(8) == 1) {
            Report report = new Report(5195, 0);
            report.add(coords.getBoardNum());
            this.addReport(report);
        } else {
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(8, 1));
            this.sendChangedHex(coords);
            Report report = new Report(5200, 0);
            report.add(coords.getBoardNum());
            this.addReport(report);
        }
    }

    public void removeSmoke(int n, int n2, int n3) {
        Coords coords = new Coords(Coords.xInDir(n, n2, n3), Coords.yInDir(n, n2, n3));
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex != null && iHex.containsTerrain(8)) {
            iHex.removeTerrain(8);
            this.sendChangedHex(coords);
            Report report = new Report(5205, 0);
            report.add(coords.getBoardNum());
            this.addReport(report);
        }
    }

    private Vector<String> scanForBoardsInDir(File file, String string, int n, int n2) {
        String[] stringArray = file.list();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].indexOf(".board") == -1 || !Board.boardIsSize(string.concat("/").concat(stringArray[i]), n, n2)) continue;
            vector.addElement(string.concat("/").concat(stringArray[i].substring(0, stringArray[i].lastIndexOf(".board"))));
        }
        return vector;
    }

    private Vector<String> scanForBoards(int n, int n2) {
        return this.scanForBoards(n, n2, this.game.getOptions().booleanOption("maps_include_subdir"));
    }

    private Vector<String> scanForBoards(int n, int n2, boolean bl) {
        int n3;
        Vector<String> vector = new Vector<String>();
        File file = new File("data/boards");
        vector.addElement("[GENERATED]");
        if (!file.isDirectory()) {
            return vector;
        }
        String[] stringArray = file.list();
        Vector<String> vector2 = new Vector<String>();
        Comparator<String> comparator = StringUtil.stringComparator();
        for (n3 = 0; n3 < stringArray.length; ++n3) {
            File file2 = new File("data/boards/".concat(stringArray[n3]));
            if (file2.isDirectory() && bl) {
                vector2.addAll(this.scanForBoardsInDir(file2, stringArray[n3], n, n2));
                continue;
            }
            if (stringArray[n3].indexOf(".board") == -1 || !Board.boardIsSize(stringArray[n3], n, n2)) continue;
            vector2.addElement(stringArray[n3].substring(0, stringArray[n3].lastIndexOf(".board")));
        }
        if (vector2.size() > 0) {
            vector.addElement("[RANDOM]");
            vector.addElement(DEFAULT_BOARD);
            Collections.sort(vector2, comparator);
            for (n3 = 0; n3 < vector2.size(); ++n3) {
                vector.addElement((String)vector2.elementAt(n3));
            }
        }
        return vector;
    }

    private boolean doBlind() {
        return this.game.getOptions().booleanOption("double_blind") && this.game.getPhase() >= 4;
    }

    private void entityUpdate(int n) {
        this.entityUpdate(n, new Vector<UnitLocation>());
    }

    private void entityUpdate(int n, Vector<UnitLocation> vector) {
        Entity entity = this.game.getEntity(n);
        if (entity == null) {
            if (this.game.getOutOfGameEntity(n) != null) {
                System.err.print("S: attempted to send entity update for out of game entity, id was ");
                System.err.println(n);
            } else {
                System.err.print("S: attempted to send entity update for null entity, id was ");
                System.err.println(n);
            }
            return;
        }
        if (this.doBlind()) {
            Player player;
            int n2;
            Vector<Player> vector2 = this.game.getPlayersVector();
            Vector<Player> vector3 = this.whoCanSee(entity);
            Packet packet = this.createEntityPacket(n, vector);
            for (n2 = 0; n2 < vector3.size(); ++n2) {
                player = vector3.elementAt(n2);
                this.send(player.getId(), packet);
            }
            packet = this.createRemoveEntityPacket(n, entity.getRemovalCondition());
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                if (vector3.contains(vector2.elementAt(n2))) continue;
                player = vector2.elementAt(n2);
                this.send(player.getId(), packet);
            }
        } else {
            this.send(this.createEntityPacket(n, vector));
        }
    }

    private Vector<Player> whoCanSee(Entity entity) {
        TurnOrdered turnOrdered;
        if (entity == null) {
            return new Vector<Player>();
        }
        boolean bl = this.game.getOptions().booleanOption("team_vision");
        Vector<Entity> vector = this.game.getEntitiesVector();
        Vector<Player> vector2 = new Vector<Player>();
        vector2.addElement(entity.getOwner());
        if (bl) {
            this.addTeammates(vector2, entity.getOwner());
        }
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            turnOrdered = enumeration.nextElement();
            if (!((Player)turnOrdered).canSeeAll() || vector2.contains(enumeration)) continue;
            vector2.addElement((Player)turnOrdered);
        }
        if (!entity.isHidden()) {
            for (int i = 0; i < vector.size(); ++i) {
                turnOrdered = vector.elementAt(i);
                if (vector2.contains(((Entity)turnOrdered).getOwner()) || !((Entity)turnOrdered).isActive() || ((Entity)turnOrdered).isOffBoard() || !Compute.canSee(this.game, (Entity)turnOrdered, entity)) continue;
                vector2.addElement(((Entity)turnOrdered).getOwner());
                if (bl) {
                    this.addTeammates(vector2, ((Entity)turnOrdered).getOwner());
                }
                this.addObservers(vector2);
            }
        }
        return vector2;
    }

    private boolean canSee(Player player, Entity entity) {
        if (entity.getOwner().getId() == player.getId()) {
            return true;
        }
        Vector<Player> vector = this.whoCanSee(entity);
        for (int i = 0; i < vector.size(); ++i) {
            Player player2 = vector.elementAt(i);
            if (!player2.equals(player)) continue;
            return true;
        }
        return false;
    }

    private void addTeammates(Vector<Player> vector, Player player) {
        Vector<Player> vector2 = this.game.getPlayersVector();
        for (int i = 0; i < vector2.size(); ++i) {
            Player player2 = vector2.elementAt(i);
            if (player.isEnemyOf(player2) || vector.contains(player2)) continue;
            vector.addElement(player2);
        }
    }

    private void addObservers(Vector<Player> vector) {
        Vector<Player> vector2 = this.game.getPlayersVector();
        for (int i = 0; i < vector2.size(); ++i) {
            Player player = vector2.elementAt(i);
            if (!player.isObserver() || vector.contains(player)) continue;
            vector.addElement(player);
        }
    }

    private void entityAllUpdate() {
        if (this.doBlind()) {
            Vector<Player> vector = this.game.getPlayersVector();
            for (int i = 0; i < vector.size(); ++i) {
                Player player = vector.elementAt(i);
                this.send(player.getId(), this.createFilteredEntitiesPacket(player));
            }
            return;
        }
        this.send(this.createEntitiesPacket());
    }

    private Vector<Entity> filterEntities(Player player, Vector<Entity> vector) {
        Entity entity;
        int n;
        Vector<Entity> vector2 = new Vector<Entity>();
        Vector<Entity> vector3 = new Vector<Entity>();
        Vector<Entity> vector4 = this.game.getEntitiesVector();
        boolean bl = this.game.getOptions().booleanOption("team_vision");
        if (player.canSeeAll()) {
            return vector;
        }
        if (player.isObserver()) {
            vector3.addAll(vector4);
            block0: for (Entity entity2 : vector3) {
                for (Entity entity3 : vector3) {
                    if (!entity2.isEnemyOf(entity3) || !Compute.canSee(this.game, entity3, entity2)) continue;
                    vector2.add(entity2);
                    continue block0;
                }
            }
            return vector2;
        }
        for (n = 0; n < vector4.size(); ++n) {
            entity = vector4.elementAt(n);
            if (entity.getOwner() != player && (!bl || entity.getOwner().isEnemyOf(player))) continue;
            vector3.addElement(entity);
        }
        block3: for (n = 0; n < vector.size(); ++n) {
            entity = vector.elementAt(n);
            if (vector3.contains(entity)) {
                vector2.addElement(entity);
                continue;
            }
            if (entity.isHidden()) continue;
            for (int i = 0; i < vector3.size(); ++i) {
                Entity entity4 = (Entity)vector3.elementAt(i);
                if (entity4.isOffBoard() || !Compute.canSee(this.game, entity4, entity)) continue;
                vector2.addElement(entity);
                continue block3;
            }
        }
        return vector2;
    }

    private Vector<Report> filterReportVector(Vector<Report> vector, Player player) {
        if (!this.doBlind()) {
            return (Vector)vector.clone();
        }
        Vector<Report> vector2 = new Vector<Report>();
        for (int i = 0; i < vector.size(); ++i) {
            Report report = vector.elementAt(i);
            vector2.addElement(this.filterReport(report, player, false));
        }
        return vector2;
    }

    private Report filterReport(Report report, Player player, boolean bl) {
        if (report.subject == -1 && report.type != 0) {
            System.err.println("Error: Attempting to filter a Report object that is not public yet has no subject.\n\t\tmessageId: " + report.messageId);
            return report;
        }
        if (report.type == 0 || player == null && !bl) {
            return report;
        }
        Entity entity = this.game.getEntity(report.subject);
        Player player2 = null;
        if (entity != null) {
            player2 = entity.getOwner();
            if (entity.isOffBoard()) {
                return report;
            }
        }
        if (!(bl || entity != null && player2 != null)) {
            System.err.println("Error: Attempting to filter a Report object that is not public but has a subject (" + entity + ") with owner (" + player2 + ").\n\tmessageId: " + report.messageId);
            return report;
        }
        Report report2 = new Report(report);
        for (int i = 0; i < report2.dataCount(); ++i) {
            if (!bl && this.canSee(player, entity) || !report.isValueObscured(i)) continue;
            report2.hideData(i);
            if (player == null) continue;
            report.addObscuredRecipient(player.getName());
        }
        return report2;
    }

    private Vector<Vector<Report>> filterPastReports(Vector<Vector<Report>> vector, Player player) {
        System.err.println("filterPastReports() begin");
        System.err.println("  player is " + player.getName());
        if (this.doBlind()) {
            Vector<Vector<Report>> vector2 = new Vector<Vector<Report>>();
            Vector<Object> vector3 = new Vector();
            for (int i = 0; i < vector.size(); ++i) {
                Vector<Report> vector4 = new Vector<Report>();
                vector3 = vector.elementAt(i);
                for (int j = 0; j < vector3.size(); ++j) {
                    Report report = (Report)vector3.elementAt(j);
                    if (report.isObscuredRecipient(player.getName())) {
                        vector4.addElement(this.filterReport(report, null, true));
                        continue;
                    }
                    vector4.addElement(report);
                }
                vector2.addElement(vector4);
            }
            System.err.println("filterPastReports() end");
            return vector2;
        }
        System.err.println("filterPastReports() end");
        return vector;
    }

    private void updateVisibilityIndicator() {
        Vector<Entity> vector = this.game.getEntitiesVector();
        for (int i = 0; i < vector.size(); ++i) {
            Entity entity = vector.elementAt(i);
            boolean bl = entity.isVisibleToEnemy();
            boolean bl2 = entity.isSeenByEnemy();
            entity.setVisibleToEnemy(false);
            Vector<Player> vector2 = this.whoCanSee(entity);
            for (int j = 0; j < vector2.size(); ++j) {
                Player player = vector2.elementAt(j);
                if (!entity.getOwner().isEnemyOf(player) || player.isObserver()) continue;
                entity.setVisibleToEnemy(true);
                entity.setSeenByEnemy(true);
            }
            if (bl == entity.isVisibleToEnemy() && bl2 == entity.isSeenByEnemy()) continue;
            this.sendVisibilityIndicator(entity);
        }
    }

    private void receiveEntityAdd(Packet packet, int n) {
        final Entity entity = (Entity)packet.getObject(0);
        if (entityVerifier == null) {
            entityVerifier = new EntityVerifier(new File(VERIFIER_CONFIG_FILENAME));
        }
        if (entity instanceof Mech || entity instanceof Tank) {
            StringBuffer stringBuffer;
            TestEntity testEntity = null;
            entity.restore();
            if (entity instanceof Mech) {
                testEntity = new TestMech((Mech)entity, Server.entityVerifier.mechOption, null);
            }
            if (entity instanceof VTOL) {
                testEntity = new TestTank((Tank)entity, Server.entityVerifier.tankOption, null);
            }
            if (entity instanceof Tank) {
                testEntity = new TestTank((Tank)entity, Server.entityVerifier.tankOption, null);
            }
            if (((TestEntity)testEntity).correctEntity(stringBuffer = new StringBuffer(), !this.game.getOptions().booleanOption("is_eq_limits"))) {
                entity.setDesignValid(true);
            } else {
                System.err.println(stringBuffer);
                if (this.game.getOptions().booleanOption("allow_illegal_units")) {
                    entity.setDesignValid(false);
                } else {
                    Player player = this.game.getPlayer(n);
                    this.sendServerChat("Player " + player.getName() + " attempted to add an illegal unit design (" + entity.getShortNameRaw() + "), the unit was rejected.");
                    return;
                }
            }
        }
        if (entity instanceof Protomech) {
            int n2 = this.game.getSelectedEntityCount(new EntitySelector(){
                private final int ownerId;
                {
                    this.ownerId = entity.getOwnerId();
                }

                public boolean accept(Entity entity2) {
                    return entity2 instanceof Protomech && this.ownerId == entity2.getOwnerId();
                }
            });
            entity.setUnitNumber((char)(n2 / 5));
        }
        if (-1 == entity.getId()) {
            entity.setId(this.getFreeEntityId());
        }
        this.game.addEntity(entity.getId(), entity);
        this.send(this.createAddEntityPacket(entity.getId()));
    }

    private void receiveEntityUpdate(Packet packet, int n) {
        Entity entity = (Entity)packet.getObject(0);
        Entity entity2 = this.game.getEntity(entity.getId());
        if (entity2 != null && entity2.getOwner() == this.getPlayer(n)) {
            this.game.setEntity(entity.getId(), entity);
            this.entityUpdate(entity.getId());
            if (this.game.getPhase() == 1) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("Unit ");
                if (this.game.getOptions().booleanOption("blind_drop") || this.game.getOptions().booleanOption("real_blind_drop")) {
                    if (-1 != entity.getExternalId()) {
                        stringBuffer.append('[').append(entity.getExternalId()).append("] ");
                    }
                    stringBuffer.append(entity.getId()).append('(').append(entity.getOwner().getName()).append(')');
                } else {
                    stringBuffer.append(entity.getDisplayName());
                }
                stringBuffer.append(" has been customized.");
                this.sendServerChat(stringBuffer.toString());
            }
        }
    }

    private void receiveEntityModeChange(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        int n3 = packet.getIntValue(1);
        int n4 = packet.getIntValue(2);
        Entity entity = this.game.getEntity(n2);
        if (entity.getOwner() != this.getPlayer(n)) {
            return;
        }
        Mounted mounted = entity.getEquipment(n3);
        if (mounted.getType() instanceof AmmoType && !mounted.getType().hasInstantModeSwitch() && n4 <= 0) {
            mounted.setPendingDump(n4 == -1);
        } else {
            mounted.setMode(n4);
        }
    }

    private void receiveEntitySystemModeChange(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        int n3 = packet.getIntValue(1);
        int n4 = packet.getIntValue(2);
        Entity entity = this.game.getEntity(n2);
        if (entity.getOwner() != this.getPlayer(n)) {
            return;
        }
        if (entity instanceof Mech && n3 == 2) {
            ((Mech)entity).setCockpitStatus(n4);
        }
    }

    private void receiveEntityAmmoChange(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        int n3 = packet.getIntValue(1);
        int n4 = packet.getIntValue(2);
        Entity entity = this.game.getEntity(n2);
        if (null == entity) {
            System.err.print("Server.receiveEntityAmmoChange: could not find entity #");
            System.err.println(n2);
            return;
        }
        Player player = this.getPlayer(n);
        if (null != player && entity.getOwner() != player) {
            System.err.print("Server.receiveEntityAmmoChange: player ");
            System.err.print(player.getName());
            System.err.print(" does not own the entity ");
            System.err.println(entity.getDisplayName());
            return;
        }
        Mounted mounted = entity.getEquipment(n3);
        Mounted mounted2 = entity.getEquipment(n4);
        if (null == mounted2) {
            System.err.print("Server.receiveEntityAmmoChange: entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" does not have ammo #");
            System.err.println(n4);
            return;
        }
        if (!(mounted2.getType() instanceof AmmoType)) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n4);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted2.getName());
            System.err.println(" and not ammo.");
            return;
        }
        if (null == mounted) {
            System.err.print("Server.receiveEntityAmmoChange: entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" does not have weapon #");
            System.err.println(n3);
            return;
        }
        if (!(mounted.getType() instanceof WeaponType)) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n3);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted.getName());
            System.err.println(" and not a weapon.");
            return;
        }
        if (((WeaponType)mounted.getType()).getAmmoType() == -1) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n3);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted.getName());
            System.err.println(" and does not use ammo.");
            return;
        }
        if (((WeaponType)mounted.getType()).hasFlag(32768L)) {
            System.err.print("Server.receiveEntityAmmoChange: item # ");
            System.err.print(n3);
            System.err.print(" of entity ");
            System.err.print(entity.getDisplayName());
            System.err.print(" is a ");
            System.err.print(mounted.getName());
            System.err.println(" and cannot use external ammo.");
            return;
        }
        entity.loadWeapon(mounted, mounted2);
    }

    private void receiveEntityDelete(Packet packet, int n) {
        int n2 = packet.getIntValue(0);
        final Entity entity = this.game.getEntity(n2);
        if (entity != null && entity.getOwner() == this.getPlayer(n)) {
            if (entity instanceof Protomech) {
                int n3 = this.game.getSelectedEntityCount(new EntitySelector(){
                    private final int ownerId;
                    {
                        this.ownerId = entity.getOwnerId();
                    }

                    public boolean accept(Entity entity2) {
                        return entity2 instanceof Protomech && this.ownerId == entity2.getOwnerId();
                    }
                });
                final char c = (char)(Math.ceil((double)n3 / 5.0) - 1.0);
                char c2 = (char)(Math.ceil((double)(n3 - 1) / 5.0) - 1.0);
                char c3 = entity.getUnitNumber();
                if (c != c3 && c != c2) {
                    Enumeration<Entity> enumeration = this.game.getSelectedEntities(new EntitySelector(){
                        private final int ownerId;
                        private final char lastUnitNum;
                        {
                            this.ownerId = entity.getOwnerId();
                            this.lastUnitNum = c;
                        }

                        public boolean accept(Entity entity2) {
                            return entity2 instanceof Protomech && this.ownerId == entity2.getOwnerId() && this.lastUnitNum == entity2.getUnitNumber();
                        }
                    });
                    Entity entity2 = enumeration.nextElement();
                    entity2.setUnitNumber(c3);
                    this.entityUpdate(entity2.getId());
                }
            }
            this.game.removeEntity(n2, 2048);
            this.send(this.createRemoveEntityPacket(n2, 2048));
        }
    }

    private void receivePlayerDone(Packet packet, int n) {
        boolean bl = packet.getBooleanValue(0);
        Player player = this.getPlayer(n);
        if (null != player) {
            player.setDone(bl);
        }
    }

    private void receiveInitiativeRerollRequest(Packet packet, int n) {
        Player player = this.getPlayer(n);
        if (6 != this.game.getPhase()) {
            StringBuffer stringBuffer = new StringBuffer();
            if (null == player) {
                stringBuffer.append("Player #").append(n);
            } else {
                stringBuffer.append(player.getName());
            }
            stringBuffer.append(" is not allowed to ask for a reroll at this time.");
            System.err.println(stringBuffer.toString());
            this.sendServerChat(stringBuffer.toString());
            return;
        }
        if (this.game.hasTacticalGenius(player)) {
            this.game.addInitiativeRerollRequest(this.game.getTeamForPlayer(player));
        }
        if (null != player) {
            player.setDone(true);
        }
        this.checkReady();
    }

    private boolean receiveGameOptions(Packet packet, int n) {
        Player player = this.game.getPlayer(n);
        if (null == player) {
            System.err.print("Server does not recognize player at connection ");
            System.err.println(n);
            return false;
        }
        if (this.password != null && this.password.length() > 0 && !this.password.equals(packet.getObject(0))) {
            this.sendServerChat(n, "The password you specified to change game options is incorrect.");
            return false;
        }
        int n2 = 0;
        Enumeration enumeration = ((Vector)packet.getObject(1)).elements();
        while (enumeration.hasMoreElements()) {
            IBasicOption iBasicOption = (IBasicOption)enumeration.nextElement();
            IOption iOption = this.game.getOptions().getOption(iBasicOption.getName());
            if (iOption == null) continue;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Player ").append(player.getName()).append(" changed option \"").append(iOption.getDisplayableName()).append("\" to ").append(iBasicOption.getValue().toString()).append('.');
            this.sendServerChat(stringBuffer.toString());
            iOption.setValue(iBasicOption.getValue());
            ++n2;
        }
        Compute.setRNG(this.game.getOptions().intOption("rng_type"));
        return n2 > 0;
    }

    private void receiveGameOptionsAux(Packet packet, int n) {
        Enumeration enumeration = ((Vector)packet.getObject(1)).elements();
        while (enumeration.hasMoreElements()) {
            IBasicOption iBasicOption = (IBasicOption)enumeration.nextElement();
            IOption iOption = this.game.getOptions().getOption(iBasicOption.getName());
            if (iOption == null || !"maps_include_subdir".equals(iOption.getName())) continue;
            this.mapSettings.setBoardsAvailableVector(this.scanForBoards(this.mapSettings.getBoardWidth(), this.mapSettings.getBoardHeight()));
            this.mapSettings.removeUnavailable();
            this.mapSettings.setNullBoards(DEFAULT_BOARD);
            this.send(this.createMapSettingsPacket());
        }
    }

    private void transmitAllPlayerConnects(int n) {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            this.send(n, this.createPlayerConnectPacket(player.getId()));
        }
    }

    private Packet createPlayerConnectPacket(int n) {
        Object[] objectArray = new Object[]{new Integer(n), this.getPlayer(n)};
        return new Packet(40, objectArray);
    }

    private Packet createPlayerUpdatePacket(int n) {
        Object[] objectArray = new Object[]{new Integer(n), this.getPlayer(n)};
        return new Packet(60, objectArray);
    }

    private void transmitAllPlayerUpdates() {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            if (null == player) continue;
            this.send(this.createPlayerUpdatePacket(player.getId()));
        }
    }

    private void transmitAllPlayerDones() {
        Enumeration<Player> enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            Player player = enumeration.nextElement();
            this.send(this.createPlayerDonePacket(player.getId()));
        }
    }

    private Packet createPlayerDonePacket(int n) {
        Object[] objectArray = new Object[]{new Integer(n), this.getPlayer(n).isDone()};
        return new Packet(70, objectArray);
    }

    private Packet createTurnVectorPacket() {
        return new Packet(300, this.game.getTurnVector());
    }

    private Packet createTurnIndexPacket() {
        return new Packet(250, new Integer(this.game.getTurnIndex()));
    }

    private Packet createMapSettingsPacket() {
        return new Packet(360, this.mapSettings);
    }

    private Packet createMapQueryPacket(MapSettings mapSettings) {
        return new Packet(370, mapSettings);
    }

    private Packet createGameSettingsPacket() {
        return new Packet(350, this.game.getOptions());
    }

    private Packet createBoardPacket() {
        return new Packet(270, this.game.getBoard());
    }

    private Packet createEntityPacket(int n, Vector<UnitLocation> vector) {
        Entity entity = this.game.getEntity(n);
        Object[] objectArray = new Object[]{new Integer(n), entity, vector};
        return new Packet(140, objectArray);
    }

    private Packet createReportPacket(Player player) {
        if (player == null || !this.doBlind()) {
            return new Packet(310, this.filterReportVector(this.vPhaseReport, player));
        }
        return new Packet(310, player.getTurnReport());
    }

    private Packet createSpecialReportPacket() {
        return new Packet(320, this.vPhaseReport.clone());
    }

    private Packet createTacticalGeniusReportPacket() {
        return new Packet(330, this.vPhaseReport.clone());
    }

    private Packet createAllReportsPacket(Player player) {
        return new Packet(340, this.filterPastReports(this.game.getAllReports(), player));
    }

    private Packet createEntitiesPacket() {
        return new Packet(280, this.game.getEntitiesVector());
    }

    private Packet createFullEntitiesPacket() {
        Object[] objectArray = new Object[]{this.game.getEntitiesVector(), this.game.getOutOfGameEntitiesVector()};
        return new Packet(280, objectArray);
    }

    private Packet createFilteredEntitiesPacket(Player player) {
        return new Packet(280, this.filterEntities(player, this.game.getEntitiesVector()));
    }

    private Packet createFilteredFullEntitiesPacket(Player player) {
        Object[] objectArray = new Object[]{this.filterEntities(player, this.game.getEntitiesVector()), this.game.getOutOfGameEntitiesVector()};
        return new Packet(280, objectArray);
    }

    private Packet createAddEntityPacket(int n) {
        Entity entity = this.game.getEntity(n);
        Object[] objectArray = new Object[]{new Integer(n), entity};
        return new Packet(90, objectArray);
    }

    private Packet createRemoveEntityPacket(int n) {
        return this.createRemoveEntityPacket(n, 512);
    }

    private Packet createRemoveEntityPacket(int n, int n2) {
        if (n2 != 0 && n2 != 256 && n2 != 272 && n2 != 512 && n2 != 528 && n2 != 288 && n2 != 1024 && n2 != 4096 && n2 != 2048) {
            throw new IllegalArgumentException("Unknown unit condition: " + n2);
        }
        Object[] objectArray = new Object[]{new Integer(n), new Integer(n2)};
        return new Packet(100, objectArray);
    }

    private Packet createEndOfGamePacket() {
        Object[] objectArray = new Object[]{this.getDetailedVictoryReport(), new Integer(this.game.getVictoryPlayerId()), new Integer(this.game.getVictoryTeam())};
        return new Packet(380, objectArray);
    }

    public void sendChat(int n, String string, String string2) {
        this.send(n, new Packet(80, string + ": " + string2));
    }

    private void sendChat(String string, String string2) {
        String string3 = string + ": " + string2;
        this.send(new Packet(80, string3));
    }

    public void sendServerChat(int n, String string) {
        this.sendChat(n, "***Server", string);
    }

    public void sendServerChat(String string) {
        this.sendChat("***Server", string);
    }

    private Packet createHexChangePacket(Coords coords, IHex iHex) {
        Object[] objectArray = new Object[]{coords, iHex};
        return new Packet(190, objectArray);
    }

    public void sendChangedHex(Coords coords) {
        this.send(this.createHexChangePacket(coords, this.game.getBoard().getHex(coords)));
    }

    public void sendVisibilityIndicator(Entity entity) {
        Object[] objectArray = new Object[]{new Integer(entity.getId()), entity.isSeenByEnemy(), entity.isVisibleToEnemy()};
        this.send(new Packet(180, objectArray));
    }

    private Packet createAttackPacket(Vector vector, int n) {
        Object[] objectArray = new Object[]{vector, new Integer(n)};
        return new Packet(130, objectArray);
    }

    private Packet createAttackPacket(EntityAction entityAction, int n) {
        Vector<EntityAction> vector = new Vector<EntityAction>(1);
        vector.addElement(entityAction);
        Object[] objectArray = new Object[]{vector, new Integer(n)};
        return new Packet(130, objectArray);
    }

    private Packet createArtilleryPacket(Player player) {
        if (player.getSeeAll()) {
            return new Packet(460, this.game.getArtilleryVector());
        }
        Vector<ArtilleryAttackAction> vector = new Vector<ArtilleryAttackAction>();
        int n = player.getTeam();
        Enumeration enumeration = this.game.getArtilleryAttacks();
        while (enumeration.hasMoreElements()) {
            ArtilleryAttackAction artilleryAttackAction = (ArtilleryAttackAction)enumeration.nextElement();
            if (artilleryAttackAction.getPlayerId() != player.getId() && (n == 0 || n != this.game.getPlayer(artilleryAttackAction.getPlayerId()).getTeam())) continue;
            vector.addElement(artilleryAttackAction);
        }
        return new Packet(460, vector);
    }

    private Packet createFlarePacket() {
        return new Packet(470, this.game.getFlares());
    }

    private void send(Packet packet) {
        if (this.connections == null) {
            return;
        }
        Enumeration<Connection> enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = enumeration.nextElement();
            connection.send(packet);
        }
    }

    private void sendReport() {
        this.sendReport(false);
    }

    private void sendReport(boolean bl) {
        if (this.connections == null) {
            return;
        }
        Enumeration<Connection> enumeration = this.connections.elements();
        while (enumeration.hasMoreElements()) {
            Connection connection = enumeration.nextElement();
            Player player = this.game.getPlayer(connection.getId());
            Packet packet = bl ? this.createTacticalGeniusReportPacket() : this.createReportPacket(player);
            connection.send(packet);
        }
    }

    private void send(int n, Packet packet) {
        if (this.getClient(n) != null) {
            this.getClient(n).send(packet);
        }
    }

    private void sendToPending(int n, Packet packet) {
        if (this.getPendingConnection(n) != null) {
            this.getPendingConnection(n).send(packet);
        }
    }

    private void processCommand(int n, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        String[] stringArray = new String[stringTokenizer.countTokens()];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = stringTokenizer.nextToken();
        }
        String string2 = stringArray[0].substring(1);
        ServerCommand serverCommand = this.getCommand(string2);
        if (serverCommand != null) {
            serverCommand.run(n, stringArray);
        } else {
            this.sendServerChat(n, "Command not recognized.  Type /help for a list of commands.");
        }
    }

    protected synchronized void handle(int n, Packet packet) {
        Player player = this.game.getPlayer(n);
        if (null == player && null == this.getPendingConnection(n)) {
            System.err.print("Server does not recognize player at connection ");
            System.err.println(n);
            return;
        }
        if (packet == null) {
            System.out.println("server.connection.handle: got null packet");
            return;
        }
        switch (packet.getCommand()) {
            case 0: {
                Connection connection = this.getConnection(n);
                if (connection == null) break;
                connection.close();
                break;
            }
            case 20: {
                this.receivePlayerName(packet, n);
                break;
            }
            case 60: {
                this.receivePlayerInfo(packet, n);
                this.validatePlayerInfo(n);
                this.send(this.createPlayerUpdatePacket(n));
                break;
            }
            case 70: {
                this.receivePlayerDone(packet, n);
                this.send(this.createPlayerDonePacket(n));
                this.checkReady();
                break;
            }
            case 430: {
                this.receiveInitiativeRerollRequest(packet, n);
                this.send(this.createPlayerDonePacket(n));
                break;
            }
            case 80: {
                String string = (String)packet.getObject(0);
                if (string.startsWith("/")) {
                    this.processCommand(n, string);
                } else {
                    this.sendChat(player.getName(), string);
                }
                if (DUNE_CALL.equals(string)) {
                    this.sendServerChat(DUNE_RESPONSE);
                    break;
                }
                if (!STAR_WARS_CALL.equals(string)) break;
                this.sendServerChat(STAR_WARS_RESPONSE);
                break;
            }
            case 110: {
                this.receiveMovement(packet, n);
                break;
            }
            case 120: {
                this.receiveDeployment(packet, n);
                break;
            }
            case 390: {
                this.receiveDeployMinefields(packet, n);
                break;
            }
            case 130: {
                this.receiveAttack(packet, n);
                break;
            }
            case 90: {
                this.receiveEntityAdd(packet, n);
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                break;
            }
            case 140: {
                this.receiveEntityUpdate(packet, n);
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                break;
            }
            case 150: {
                this.receiveEntityModeChange(packet, n);
                break;
            }
            case 170: {
                this.receiveEntitySystemModeChange(packet, n);
                break;
            }
            case 160: {
                this.receiveEntityAmmoChange(packet, n);
                break;
            }
            case 100: {
                this.receiveEntityDelete(packet, n);
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                break;
            }
            case 350: {
                if (!this.receiveGameOptions(packet, n)) break;
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                this.send(this.createGameSettingsPacket());
                this.receiveGameOptionsAux(packet, n);
                break;
            }
            case 360: {
                MapSettings mapSettings = (MapSettings)packet.getObject(0);
                if (!this.mapSettings.equalMapGenParameters(mapSettings)) {
                    this.sendServerChat("Player " + player.getName() + " changed mapsettings");
                }
                this.mapSettings = mapSettings;
                mapSettings = null;
                this.mapSettings.replaceBoardWithRandom("[RANDOM]");
                this.resetPlayersDone();
                this.transmitAllPlayerDones();
                this.send(this.createMapSettingsPacket());
                break;
            }
            case 370: {
                MapSettings mapSettings = (MapSettings)packet.getObject(0);
                mapSettings.setBoardsAvailableVector(this.scanForBoards(mapSettings.getBoardWidth(), mapSettings.getBoardHeight()));
                mapSettings.removeUnavailable();
                mapSettings.setNullBoards(DEFAULT_BOARD);
                mapSettings.replaceBoardWithRandom("[RANDOM]");
                mapSettings.removeUnavailable();
                this.send(n, this.createMapQueryPacket(mapSettings));
                break;
            }
            case 440: {
                this.receiveUnloadStranded(packet, n);
                break;
            }
            case 450: {
                this.receiveArtyAutoHitHexes(packet, n);
            }
        }
    }

    @Override
    public void run() {
        Thread thread = Thread.currentThread();
        System.out.println("s: listening for clients...");
        while (this.connector == thread) {
            try {
                Socket socket = this.serverSocket.accept();
                int n = this.getFreeConnectionId();
                System.out.println("s: accepting player connection #" + n + " ...");
                Connection connection = ConnectionFactory.getInstance().createServerConnection(socket, n);
                connection.addConnectionListener(this.connectionListener);
                connection.open();
                this.connectionsPending.addElement(connection);
                this.greeting(n);
                ConnectionWatchdog connectionWatchdog = new ConnectionWatchdog(this, n);
                this.timer.schedule((TimerTask)connectionWatchdog, 1000L, 500L);
            }
            catch (IOException iOException) {}
        }
    }

    private Vector<Report> explodeInfernoAmmoFromHeat(Entity entity) {
        int n = 0;
        int n2 = 0;
        int n3 = -1;
        int n4 = -1;
        Vector<Report> vector = new Vector<Report>();
        for (int i = 0; i < entity.locations(); ++i) {
            for (int j = 0; j < entity.getNumberOfCriticals(i); ++j) {
                AmmoType ammoType;
                Mounted mounted;
                CriticalSlot criticalSlot = entity.getCritical(i, j);
                if (criticalSlot == null || criticalSlot.isDestroyed() || criticalSlot.isHit() || criticalSlot.getType() != 1 || !((mounted = entity.getEquipment(entity.getCritical(i, j).getIndex())).getType() instanceof AmmoType) || !(ammoType = (AmmoType)mounted.getType()).isExplosive() || ammoType.getMunitionType() != 0x400000L) continue;
                int n5 = ammoType.getDamagePerShot() * ammoType.getRackSize();
                int n6 = mounted.getExplosionDamage();
                if (mounted.isHit() || n2 >= n5 && (n2 != n5 || n >= n6)) continue;
                n2 = n5;
                n = n6;
                n3 = i;
                n4 = j;
            }
        }
        if (n3 != -1 && n4 != -1) {
            CriticalSlot criticalSlot = entity.getCritical(n3, n4);
            criticalSlot.setHit(true);
            Mounted mounted = entity.getEquipment(criticalSlot.getIndex());
            mounted.setHit(true);
            entity.heat += Math.min(mounted.getExplosionDamage(), 30);
            vector.addAll(this.explodeEquipment(entity, n3, n4));
            Report report = new Report(5155);
            report.indent();
            report.subject = entity.getId();
            report.add(entity.heat);
            vector.addElement(report);
            entity.heatBuildup = 0;
        } else {
            Report report = new Report(5160);
            report.indent();
            report.subject = entity.getId();
            vector.addElement(report);
        }
        return vector;
    }

    private boolean passBuildingWall(Entity entity, Building building, Coords coords, Coords coords2, int n, String string, boolean bl) {
        int n2;
        int n3;
        PilotingRollData pilotingRollData = entity.rollMovementInBuilding(building, n, string);
        if (0 < this.doSkillCheckWhileMoving(entity, coords, coords2, pilotingRollData, false)) {
            n3 = (int)Math.ceil((double)building.getCurrentCF() / 10.0);
            if (n3 == 0) {
                Report report = new Report(6440);
                report.add(entity.getDisplayName());
                report.subject = entity.getId();
                report.indent(2);
                this.addReport(report);
            } else {
                n2 = 0;
                if (bl) {
                    n2 = 1;
                }
                HitData hitData = entity.rollHitLocation(0, n2);
                this.addReport(this.damageEntity(entity, hitData, n3));
            }
        }
        n3 = (int)Math.ceil((double)entity.getWeight() / 10.0);
        n2 = building.getCurrentCF();
        n2 -= Math.min(n2, n3);
        building.setCurrentCF(n2);
        this.damageInfantryIn(building, n3);
        return this.checkBuildingCollapseWhileMoving(building, entity, coords2);
    }

    private boolean checkBuildingCollapseWhileMoving(Building building, Entity entity, Coords coords) {
        Coords coords2 = entity.getPosition();
        entity.setPosition(coords);
        Hashtable<Coords, Vector<Entity>> hashtable = this.game.getPositionMap();
        boolean bl = this.checkForCollapse(building, hashtable);
        if (coords.equals(entity.getPosition()) && !entity.isProne()) {
            entity.setPosition(coords2);
        }
        return bl;
    }

    private void damageInfantryIn(Building building, int n) {
        float f = 0.0f;
        switch (building.getType()) {
            case 1: {
                f = 0.75f;
                break;
            }
            case 2: {
                f = 0.5f;
                break;
            }
            case 3: {
                f = 0.25f;
            }
        }
        int n2 = Math.round((float)n * f);
        boolean bl = false;
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Report report;
            Entity entity = enumeration.nextElement();
            Coords coords = entity.getPosition();
            if (!(entity instanceof Infantry) || !building.isIn(coords) || !Compute.isInBuilding(this.game, entity, coords)) continue;
            if (n2 == 0) {
                report = new Report(6445);
                this.addReport(report);
                continue;
            }
            report = new Report(6450);
            report.indent(2);
            report.subject = entity.getId();
            report.add(entity.getDisplayName());
            report.add(n2);
            this.addReport(report);
            int n3 = n2;
            int n4 = n2;
            if (entity instanceof BattleArmor) {
                n4 = 5;
            }
            while (n3 > 0) {
                int n5 = Math.min(n4, n3);
                HitData hitData = entity.rollHitLocation(0, 0);
                this.addReport(this.damageEntity(entity, hitData, n5));
                n3 -= n5;
            }
            this.addReport(new Report(1210));
        }
        if (bl) {
            this.addReport(new Report(1210));
        }
    }

    public boolean checkForCollapse(Building building, Hashtable hashtable) {
        Serializable serializable;
        if (building == null || hashtable == null || hashtable.isEmpty()) {
            return false;
        }
        int n = building.getCurrentCF();
        Hashtable hashtable2 = new Hashtable();
        Enumeration<Coords> enumeration = building.getCoords();
        boolean bl = false;
        while (!bl && enumeration.hasMoreElements()) {
            serializable = enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(serializable);
            if (vector == null) continue;
            IHex iHex = this.game.getBoard().getHex((Coords)serializable);
            int n2 = Math.max(0, iHex.terrainLevel(12));
            int n3 = iHex.terrainLevel(16);
            int n4 = n2;
            if (n3 != Integer.MIN_VALUE) {
                ++n4;
            }
            if (n4 < 1) {
                System.err.println("Check for collapse: hex " + ((Coords)serializable).toString() + " has no bridge or building");
                continue;
            }
            int[] nArray = new int[n4];
            Vector<Entity> vector2 = new Vector<Entity>();
            for (int i = 0; i < n4; ++i) {
                nArray[i] = 0;
            }
            Enumeration enumeration2 = vector.elements();
            while (!bl && enumeration2.hasMoreElements()) {
                Entity entity = (Entity)enumeration2.nextElement();
                int n5 = entity.getElevation();
                if (n5 != n3 && n5 > n2 || entity.getMovementMode() == 8 || entity.getMovementMode() == 7 || entity.getMovementMode() == 9 || entity.getMovementMode() == 18 || !(entity instanceof Mech) && !(entity instanceof Tank)) continue;
                int n6 = (int)entity.getWeight();
                int n7 = n5;
                if (n7 == n3) {
                    n7 = n4;
                }
                if (n2 > 0 && n7 == 0 && n6 > n) {
                    vector2.addElement(entity);
                    continue;
                }
                if (n7 <= 0) continue;
                int n8 = --n7;
                nArray[n8] = nArray[n8] + n6;
                if (nArray[n7] <= n) continue;
                bl = true;
            }
            if (vector2.isEmpty()) continue;
            hashtable2.put(serializable, vector2);
        }
        if (bl) {
            serializable = new Report(2375);
            ((Report)serializable).add(building.getName());
            this.addReport((Report)serializable);
            this.collapseBuilding(building, hashtable);
        } else if (!hashtable2.isEmpty()) {
            // empty if block
        }
        return bl;
    }

    public void collapseBuilding(Building building, Hashtable hashtable) {
        int n = building.getPhaseCF();
        Enumeration<Coords> enumeration = building.getCoords();
        while (enumeration.hasMoreElements()) {
            Coords coords = enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(coords);
            if (vector == null) continue;
            IHex iHex = this.game.getBoard().getHex(coords);
            int n2 = iHex.terrainLevel(16);
            int n3 = Math.max(n2, iHex.terrainLevel(12));
            this.game.getBoard().collapseBuilding(coords);
            Collections.sort(vector, new Comparator<Entity>(){

                @Override
                public int compare(Entity entity, Entity entity2) {
                    if (entity.getElevation() > entity2.getElevation()) {
                        return -1;
                    }
                    if (entity.getElevation() > entity2.getElevation()) {
                        return 1;
                    }
                    return 0;
                }
            });
            Enumeration enumeration2 = vector.elements();
            while (enumeration2.hasMoreElements()) {
                Entity entity = (Entity)enumeration2.nextElement();
                int n4 = entity.getElevation();
                if (n4 > n3) continue;
                if (n4 == n3) {
                    --n4;
                }
                int n5 = (int)Math.ceil((double)(n * (n3 - n4)) / 10.0);
                if (entity instanceof Infantry) {
                    n5 *= 3;
                }
                Report report = new Report(6455);
                report.indent();
                report.subject = entity.getId();
                report.add(entity.getDisplayName());
                report.add(n5);
                this.addReport(report);
                int n6 = n5;
                int n7 = n5;
                if (entity instanceof BattleArmor || entity instanceof Mech || entity instanceof Tank) {
                    n7 = 5;
                }
                while (n6 > 0) {
                    int n8 = Math.min(n7, n6);
                    HitData hitData = entity.rollHitLocation(0, 0);
                    this.addReport(this.damageEntity(entity, hitData, n8));
                    n6 -= n8;
                }
                this.addReport(new Report(1210));
                n4 = entity.getElevation();
                if (n4 > 0 || n4 == n2) {
                    PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
                    entity.addPilotingModifierForTerrain(pilotingRollData, coords);
                    if (n5 >= 20) {
                        pilotingRollData.addModifier(1, "20+ damage");
                    }
                    this.doEntityFallsInto(entity, coords, coords, pilotingRollData);
                }
                this.entityUpdate(entity.getId());
            }
        }
        building.setCurrentCF(0);
        building.setPhaseCF(0);
        this.send(this.createCollapseBuildingPacket(building));
        this.game.getBoard().collapseBuilding(building);
    }

    private Packet createCollapseBuildingPacket(Building building) {
        Vector<Building> vector = new Vector<Building>();
        vector.addElement(building);
        return this.createCollapseBuildingPacket(vector);
    }

    private Packet createCollapseBuildingPacket(Vector<Building> vector) {
        return new Packet(230, vector);
    }

    private Packet createUpdateBuildingCFPacket(Vector<Building> vector) {
        return new Packet(220, vector);
    }

    private void applyBuildingDamage() {
        Serializable serializable;
        Object object;
        Serializable serializable2;
        Vector<Serializable> vector = new Vector<Serializable>();
        Vector<Building> vector2 = new Vector<Building>();
        Enumeration<Building> enumeration = this.game.getBoard().getBuildings();
        while (enumeration.hasMoreElements()) {
            serializable2 = enumeration.nextElement();
            if (((Building)serializable2).getCurrentCF() == 0) {
                vector.addElement(serializable2);
                continue;
            }
            if (((Building)serializable2).getPhaseCF() == ((Building)serializable2).getCurrentCF()) continue;
            ((Building)serializable2).setPhaseCF(((Building)serializable2).getCurrentCF());
            vector2.addElement((Building)serializable2);
        }
        if (!vector.isEmpty()) {
            serializable2 = this.game.getPositionMap();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                serializable = new Report(6460, 0);
                ((Report)serializable).add(((Building)object).getName());
                this.addReport((Report)serializable);
                this.collapseBuilding((Building)object, (Hashtable)serializable2);
            }
        }
        if (!vector2.isEmpty()) {
            serializable2 = this.game.getPositionMap();
            object = vector2.iterator();
            while (object.hasNext()) {
                serializable = (Building)object.next();
                if (!this.checkForCollapse((Building)serializable, (Hashtable)serializable2)) continue;
                object.remove();
            }
        }
        if (!vector2.isEmpty()) {
            this.sendChangedCFBuildings(vector2);
        }
    }

    private Report damageBuilding(Building building, int n) {
        return this.damageBuilding(building, n, " absorbs ");
    }

    private Report damageBuilding(Building building, int n, String string) {
        Report report = new Report(1210);
        report.newlines = 0;
        if (building != null && n > 0) {
            int n2;
            int n3 = n2 = building.getCurrentCF();
            n2 -= Math.min(n2, n);
            building.setCurrentCF(n2);
            report.messageId = 3435;
            report.add(building.getName());
            report.add(string);
            report.add(n);
            report.newlines = 1;
            if (n2 == 0 && n3 != 0) {
                if (building instanceof FuelTank) {
                    report.messageId = 3441;
                    report.type = 0;
                    this.addReport(report);
                    report = new Report(3560);
                    report.type = 0;
                    report.newlines = 1;
                    this.addReport(report);
                    Vector<Report> vector = new Vector<Report>();
                    this.doExplosion(((FuelTank)building).getMagnitude(), 10, false, building.getCoords().nextElement(), true, vector, null);
                    Report.indentAll(vector, 2);
                    this.addReport(vector);
                    return null;
                }
                report.messageId = building.getType() == 5 ? 3442 : 3440;
            }
        }
        return report;
    }

    public void sendChangedCFBuildings(Vector<Building> vector) {
        this.send(this.createUpdateBuildingCFPacket(vector));
    }

    private void receiveUnloadStranded(Packet packet, int n) {
        int n2;
        GameTurn.UnloadStrandedTurn unloadStrandedTurn = null;
        Player player = this.game.getPlayer(n);
        int[] nArray = (int[])packet.getObject(0);
        Vector<Player> vector = null;
        Player player2 = null;
        Enumeration<EntityAction> enumeration = null;
        UnloadStrandedAction unloadStrandedAction = null;
        Entity entity = null;
        if (this.game.getPhase() != 8) {
            System.err.println("error: server got unload stranded packet in wrong phase");
            return;
        }
        if (!(this.game.getTurn() instanceof GameTurn.UnloadStrandedTurn)) {
            System.err.println("error: server got unload stranded packet out of sequence");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(player.getName()).append(" should not be sending 'unload stranded entity' packets at this time.");
            this.sendServerChat(stringBuffer.toString());
            return;
        }
        unloadStrandedTurn = (GameTurn.UnloadStrandedTurn)this.game.getTurn();
        if (!unloadStrandedTurn.isValid(n, this.game)) {
            System.err.println("error: server got unload stranded packet from invalid player");
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(player.getName()).append(" should not be sending 'unload stranded entity' packets.");
            this.sendServerChat(stringBuffer.toString());
            return;
        }
        vector = new Vector<Player>();
        enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            unloadStrandedAction = (UnloadStrandedAction)enumeration.nextElement();
            if (unloadStrandedAction.getPlayerId() == n) {
                System.err.println("error: server got multiple unload stranded packets from player");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(player.getName()).append(" should not send multiple 'unload stranded entity' packets.");
                this.sendServerChat(stringBuffer.toString());
                return;
            }
            player2 = this.game.getPlayer(unloadStrandedAction.getPlayerId());
            if (vector.contains(player2)) continue;
            vector.addElement(player2);
        }
        boolean bl = false;
        for (n2 = 0; null != nArray && n2 < nArray.length; ++n2) {
            entity = this.game.getEntity(nArray[n2]);
            if (!this.game.getTurn().isValid(n, entity, this.game)) {
                System.err.println("error: server got unload stranded packet for invalid entity");
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(player.getName()).append(" can not unload stranded entity ");
                if (null == entity) {
                    stringBuffer.append('#').append(nArray[n2]);
                } else {
                    stringBuffer.append(entity.getDisplayName());
                }
                stringBuffer.append(" at this time.");
                this.sendServerChat(stringBuffer.toString());
                continue;
            }
            bl = true;
            this.game.addAction(new UnloadStrandedAction(n, nArray[n2]));
        }
        if (!bl) {
            this.game.addAction(new UnloadStrandedAction(n, -1));
        }
        vector.addElement(player);
        nArray = unloadStrandedTurn.getEntityIds();
        for (n2 = 0; n2 < nArray.length; ++n2) {
            entity = this.game.getEntity(nArray[n2]);
            player2 = entity.getOwner();
            if (vector.contains(player2)) continue;
            return;
        }
        enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            unloadStrandedAction = (UnloadStrandedAction)enumeration.nextElement();
            if (-1 == unloadStrandedAction.getEntityId()) continue;
            entity = this.game.getEntity(unloadStrandedAction.getEntityId());
            if (null == entity) {
                System.err.print("error: server could not find stranded entity #");
                System.err.print(unloadStrandedAction.getEntityId());
                System.err.println(" to unload!!!");
                continue;
            }
            Entity entity2 = this.game.getEntity(entity.getTransportId());
            this.unloadUnit(entity2, entity, entity2.getPosition(), entity2.getFacing(), entity2.getElevation());
        }
        this.game.resetActions();
        this.changeToNextTurn();
    }

    private void clearArtillerySpotters(int n, int n2) {
        Enumeration enumeration = this.game.getArtilleryAttacks();
        while (enumeration.hasMoreElements()) {
            ArtilleryAttackAction artilleryAttackAction = (ArtilleryAttackAction)enumeration.nextElement();
            if (artilleryAttackAction.getWR().waa.getEntityId() != n || artilleryAttackAction.getWR().waa.getWeaponId() != n2) continue;
            artilleryAttackAction.setSpotterIds(null);
        }
    }

    private WeaponResult convertHomingShotToEntityTarget(ArtilleryAttackAction artilleryAttackAction, Entity entity) {
        WeaponResult weaponResult = artilleryAttackAction.getWR();
        Targetable targetable = weaponResult.waa.getTarget(this.game);
        Coords coords = targetable.getPosition();
        Entity entity2 = null;
        TagInfo tagInfo = null;
        Entity entity3 = null;
        for (int i = 0; i < 2; ++i) {
            int n = Integer.MAX_VALUE;
            int n2 = -1;
            Vector<TagInfo> vector = this.game.getTagInfo();
            for (int j = 0; j < vector.size(); ++j) {
                tagInfo = vector.elementAt(j);
                entity3 = this.game.getEntity(tagInfo.attackerId);
                if (tagInfo.shots >= tagInfo.priority || entity.isEnemyOf(entity3)) continue;
                System.err.println("Checking TAG " + j + " with priority " + tagInfo.priority);
                entity2 = this.game.getEntity(tagInfo.targetId);
                if (entity2 == null || !entity2.isOnSameSheet(coords) || coords.distance(entity2.getPosition()) >= n) continue;
                n2 = j;
                n = coords.distance(entity2.getPosition());
                if (!this.game.getOptions().booleanOption("a4homing_target_area")) break;
            }
            if (n2 != -1) {
                tagInfo = vector.elementAt(n2);
                entity2 = this.game.getEntity(tagInfo.targetId);
                entity3 = this.game.getEntity(tagInfo.attackerId);
                System.err.println("attacker: " + entity.getDisplayName());
                System.err.println("   " + entity3.getDisplayName() + " selected to TAG");
                System.err.println("   " + entity2.getDisplayName() + " selected as target");
                ++tagInfo.shots;
                this.game.updateTagInfo(tagInfo, n2);
                break;
            }
            entity2 = null;
            System.err.println("nothing on 1st pass");
            this.game.clearTagInfoShots(entity, coords);
        }
        if (entity2 == null || tagInfo == null) {
            weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "no targets tagged on map sheet");
        } else if (tagInfo.missed) {
            weaponResult.waa.setTargetId(entity2.getId());
            weaponResult.waa.setTargetType(0);
            weaponResult.toHit = new ToHitData(Integer.MAX_VALUE, "tag missed the target");
        } else {
            weaponResult.artyAttackerCoords = entity3.getPosition();
            weaponResult.waa.setTargetId(entity2.getId());
            weaponResult.waa.setTargetType(0);
        }
        return weaponResult;
    }

    private void resolveIndirectArtilleryAttacks() {
        Serializable serializable;
        Object object;
        Object object2;
        Vector<Object> vector = new Vector<Object>(this.game.getArtillerySize());
        Vector<Object> vector2 = new Vector<Object>(this.game.getArtillerySize());
        Vector<Object> vector3 = new Vector<Object>(this.game.getArtillerySize());
        Object object3 = this.game.getArtilleryAttacks();
        while (object3.hasMoreElements()) {
            object2 = (ArtilleryAttackAction)object3.nextElement();
            if (object2 instanceof NukeAttackAction && ((ArtilleryAttackAction)object2).turnsTilHit <= 0) {
                vector3.addElement(object2);
            } else if (((ArtilleryAttackAction)object2).turnsTilHit <= 0) {
                Mounted mounted;
                AmmoType ammoType;
                object = ((ArtilleryAttackAction)object2).getWR();
                ((WeaponResult)object).artyAttackerCoords = ((ArtilleryAttackAction)object2).getCoords();
                serializable = ((ArtilleryAttackAction)object2).getSpotterIds();
                final Targetable targetable = ((WeaponResult)object).waa.getTarget(this.game);
                Coords coords = targetable.getPosition();
                final int n = ((ArtilleryAttackAction)object2).getPlayerId();
                RoundUpdated roundUpdated = null;
                Entity entity = this.game.getEntity(((WeaponResult)object).waa.getEntityId());
                if (entity == null) {
                    entity = this.game.getOutOfGameEntity(((WeaponResult)object).waa.getEntityId());
                }
                AmmoType ammoType2 = ammoType = (mounted = entity.getEquipment(((WeaponResult)object).waa.getAmmoId())) == null ? null : (AmmoType)mounted.getType();
                if (ammoType != null && ammoType.getMunitionType() == 0x20000000L) {
                    object = this.convertHomingShotToEntityTarget((ArtilleryAttackAction)object2, entity);
                } else {
                    RoundUpdated roundUpdated2;
                    Object object4;
                    if (null != serializable) {
                        object4 = this.game.getSelectedEntities(new EntitySelector((Vector)serializable){
                            public int player;
                            public Targetable targ;
                            final /* synthetic */ Vector val$spottersBefore;
                            {
                                this.val$spottersBefore = vector;
                                this.player = n;
                                this.targ = targetable;
                            }

                            public boolean accept(Entity entity) {
                                Integer n2 = new Integer(entity.getId());
                                return this.player == entity.getOwnerId() && this.val$spottersBefore.contains(n2) && !LosEffects.calculateLos(Server.this.game, entity.getId(), this.targ).isBlocked() && entity.isActive() && !entity.isINarcedWith(4L);
                            }
                        });
                        while (object4.hasMoreElements()) {
                            roundUpdated2 = (Entity)object4.nextElement();
                            if (roundUpdated != null && roundUpdated2.crew.getGunnery() >= roundUpdated.crew.getGunnery()) continue;
                            roundUpdated = roundUpdated2;
                        }
                    }
                    if (null != roundUpdated) {
                        int n2 = (roundUpdated.crew.getGunnery() - 4) / 2;
                        ((WeaponResult)object).toHit.addModifier(n2, "Spotting modifier");
                    }
                    if (null != (object4 = ((WeaponResult)object).waa.getEntity(this.game))) {
                        int n3;
                        roundUpdated2 = ((Entity)object4).getEquipment(((WeaponResult)object).waa.getWeaponId());
                        if (((WeaponResult)object).roll >= ((WeaponResult)object).toHit.getValue()) {
                            ((Entity)object4).aTracker.setModifier((Mounted)roundUpdated2, Integer.MIN_VALUE, coords);
                        } else if (null != roundUpdated && (n3 = ((Entity)object4).aTracker.getModifier((Mounted)roundUpdated2, coords)) != Integer.MIN_VALUE) {
                            ((Entity)object4).aTracker.setModifier((Mounted)roundUpdated2, n3 - 1, coords);
                        }
                    }
                }
                vector.addElement(object);
                vector2.addElement(object2);
            }
            --((ArtilleryAttackAction)object2).turnsTilHit;
        }
        object3 = new Vector();
        object2 = vector3.elements();
        while (object2.hasMoreElements()) {
            object = (NukeAttackAction)object2.nextElement();
            if (((NukeAttackAction)object).attackType == NukeAttackAction.TYPE_GENERIC) {
                this.doNuclearExplosion(((NukeAttackAction)object).target, ((NukeAttackAction)object).damage, ((NukeAttackAction)object).degeneration, ((NukeAttackAction)object).secondaryRadius, ((NukeAttackAction)object).craterDepth, (Vector<Report>)object3);
            } else {
                this.doNuclearExplosion(((NukeAttackAction)object).target, ((NukeAttackAction)object).nukeClass, (Vector<Report>)object3);
            }
            this.game.removeArtilleryAttack((ArtilleryAttackAction)object);
        }
        this.addReport((Vector<Report>)object3);
        int n = -1;
        object = vector.elements();
        while (object.hasMoreElements()) {
            serializable = (WeaponResult)object.nextElement();
            this.resolveWeaponAttack((WeaponResult)serializable, n);
            n = ((WeaponResult)serializable).waa.getEntityId();
        }
        object = vector2.elements();
        while (object.hasMoreElements()) {
            this.game.removeArtilleryAttack((ArtilleryAttackAction)object.nextElement());
        }
        object = this.game.getPlayers();
        while (object.hasMoreElements()) {
            serializable = (Player)object.nextElement();
            int n4 = ((Player)serializable).getId();
            this.send(n4, this.createArtilleryPacket((Player)serializable));
        }
    }

    private void enqueueIndirectArtilleryAttacks() {
        Object object;
        this.resolveAllButWeaponAttacks();
        Enumeration<Object> enumeration = this.game.getActions();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            object = enumeration.nextElement();
            final Entity entity = this.game.getEntity(object.getEntityId());
            if (!(object instanceof WeaponAttackAction)) continue;
            final WeaponAttackAction weaponAttackAction = (WeaponAttackAction)object;
            WeaponResult weaponResult = this.preTreatWeaponAttack(weaponAttackAction);
            boolean bl = false;
            Enumeration<Entity> enumeration2 = this.game.getArtilleryAttacks();
            while (!bl && enumeration2.hasMoreElements()) {
                serializable = (ArtilleryAttackAction)enumeration2.nextElement();
                if (((ArtilleryAttackAction)serializable).getWR().waa.getEntityId() != weaponResult.waa.getEntityId() || ((ArtilleryAttackAction)serializable).getWR().waa.getTarget(this.game).getPosition().equals(weaponResult.waa.getTarget(this.game).getPosition())) continue;
                bl = true;
            }
            if (bl) {
                this.clearArtillerySpotters(entity.getId(), weaponAttackAction.getWeaponId());
            }
            enumeration2 = this.game.getSelectedEntities(new EntitySelector(){
                public int player;
                public Targetable target;
                {
                    this.player = entity.getOwnerId();
                    this.target = weaponAttackAction.getTarget(Server.this.game);
                }

                public boolean accept(Entity entity2) {
                    return this.player == entity2.getOwnerId() && !LosEffects.calculateLos(Server.this.game, entity2.getId(), this.target).isBlocked() && entity2.isActive();
                }
            });
            serializable = new Vector();
            while (enumeration2.hasMoreElements()) {
                Integer n = new Integer(enumeration2.nextElement().getId());
                ((Vector)serializable).addElement(n);
            }
            ArtilleryAttackAction artilleryAttackAction = new ArtilleryAttackAction(weaponResult, this.game, entity.getOwnerId(), (Vector)serializable, entity.getPosition());
            this.game.addArtilleryAttack(artilleryAttackAction);
        }
        this.game.resetActions();
        enumeration = this.game.getPlayers();
        while (enumeration.hasMoreElements()) {
            object = (Player)enumeration.nextElement();
            int n = ((Player)object).getId();
            this.send(n, this.createArtilleryPacket((Player)object));
        }
    }

    private void creditKill(Entity entity, Entity entity2) {
        if ((entity.isDoomed() || entity.getCrew().isDoomed()) && !entity.getGaveKillCredit()) {
            entity2.addKill(entity);
        }
    }

    private PhysicalResult preTreatPhysicalAttack(AbstractAttackAction abstractAttackAction) {
        Entity entity = this.game.getEntity(abstractAttackAction.getEntityId());
        int n = 0;
        PhysicalResult physicalResult = new PhysicalResult();
        ToHitData toHitData = new ToHitData();
        physicalResult.roll = Compute.d6(2);
        physicalResult.aaa = abstractAttackAction;
        if (abstractAttackAction instanceof BrushOffAttackAction) {
            BrushOffAttackAction brushOffAttackAction = (BrushOffAttackAction)abstractAttackAction;
            int n2 = brushOffAttackAction.getArm();
            brushOffAttackAction.setArm(1);
            toHitData = BrushOffAttackAction.toHit(this.game, abstractAttackAction.getEntityId(), abstractAttackAction.getTarget(this.game), 1);
            brushOffAttackAction.setArm(2);
            physicalResult.toHitRight = BrushOffAttackAction.toHit(this.game, abstractAttackAction.getEntityId(), abstractAttackAction.getTarget(this.game), 2);
            n = BrushOffAttackAction.getDamageFor(entity, 1);
            physicalResult.damageRight = BrushOffAttackAction.getDamageFor(entity, 2);
            brushOffAttackAction.setArm(n2);
            physicalResult.rollRight = Compute.d6(2);
        } else if (abstractAttackAction instanceof ChargeAttackAction) {
            ChargeAttackAction chargeAttackAction = (ChargeAttackAction)abstractAttackAction;
            toHitData = chargeAttackAction.toHit(this.game);
            n = ChargeAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof ClubAttackAction) {
            ClubAttackAction clubAttackAction = (ClubAttackAction)abstractAttackAction;
            toHitData = clubAttackAction.toHit(this.game);
            n = ClubAttackAction.getDamageFor(entity, clubAttackAction.getClub());
        } else if (abstractAttackAction instanceof DfaAttackAction) {
            DfaAttackAction dfaAttackAction = (DfaAttackAction)abstractAttackAction;
            toHitData = dfaAttackAction.toHit(this.game);
            n = DfaAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof KickAttackAction) {
            KickAttackAction kickAttackAction = (KickAttackAction)abstractAttackAction;
            toHitData = kickAttackAction.toHit(this.game);
            n = KickAttackAction.getDamageFor(entity, kickAttackAction.getLeg());
        } else if (abstractAttackAction instanceof ProtomechPhysicalAttackAction) {
            ProtomechPhysicalAttackAction protomechPhysicalAttackAction = (ProtomechPhysicalAttackAction)abstractAttackAction;
            toHitData = protomechPhysicalAttackAction.toHit(this.game);
            n = ProtomechPhysicalAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof PunchAttackAction) {
            PunchAttackAction punchAttackAction = (PunchAttackAction)abstractAttackAction;
            int n3 = punchAttackAction.getArm();
            int n4 = 0;
            punchAttackAction.setArm(1);
            toHitData = punchAttackAction.toHit(this.game);
            punchAttackAction.setArm(2);
            ToHitData toHitData2 = punchAttackAction.toHit(this.game);
            n = PunchAttackAction.getDamageFor(entity, 1);
            n4 = PunchAttackAction.getDamageFor(entity, 2);
            punchAttackAction.setArm(n3);
            if (entity.isProne()) {
                double d;
                double d2 = Compute.oddsAbove(toHitData.getValue());
                if (d2 * (double)n > (d = Compute.oddsAbove(toHitData2.getValue())) * (double)n4) {
                    punchAttackAction.setArm(1);
                } else {
                    punchAttackAction.setArm(2);
                }
            }
            physicalResult.damageRight = n4;
            physicalResult.toHitRight = toHitData2;
            physicalResult.rollRight = Compute.d6(2);
        } else if (abstractAttackAction instanceof PushAttackAction) {
            PushAttackAction pushAttackAction = (PushAttackAction)abstractAttackAction;
            toHitData = pushAttackAction.toHit(this.game);
        } else if (abstractAttackAction instanceof TripAttackAction) {
            TripAttackAction tripAttackAction = (TripAttackAction)abstractAttackAction;
            toHitData = tripAttackAction.toHit(this.game);
        } else if (abstractAttackAction instanceof LayExplosivesAttackAction) {
            LayExplosivesAttackAction layExplosivesAttackAction = (LayExplosivesAttackAction)abstractAttackAction;
            toHitData = layExplosivesAttackAction.toHit(this.game);
            n = LayExplosivesAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof ThrashAttackAction) {
            ThrashAttackAction thrashAttackAction = (ThrashAttackAction)abstractAttackAction;
            toHitData = thrashAttackAction.toHit(this.game);
            n = ThrashAttackAction.getDamageFor(entity);
        } else if (abstractAttackAction instanceof JumpJetAttackAction) {
            JumpJetAttackAction jumpJetAttackAction = (JumpJetAttackAction)abstractAttackAction;
            toHitData = jumpJetAttackAction.toHit(this.game);
            if (jumpJetAttackAction.getLeg() == 0) {
                n = JumpJetAttackAction.getDamageFor(entity, 1);
                physicalResult.damageRight = JumpJetAttackAction.getDamageFor(entity, 1);
            } else {
                n = JumpJetAttackAction.getDamageFor(entity, jumpJetAttackAction.getLeg());
                physicalResult.damageRight = 0;
            }
            entity.heatBuildup += (n + physicalResult.damageRight) / 3;
        } else if (abstractAttackAction instanceof GrappleAttackAction) {
            GrappleAttackAction grappleAttackAction = (GrappleAttackAction)abstractAttackAction;
            toHitData = grappleAttackAction.toHit(this.game);
        } else if (abstractAttackAction instanceof BreakGrappleAttackAction) {
            BreakGrappleAttackAction breakGrappleAttackAction = (BreakGrappleAttackAction)abstractAttackAction;
            toHitData = breakGrappleAttackAction.toHit(this.game);
        }
        physicalResult.toHit = toHitData;
        physicalResult.damage = n;
        return physicalResult;
    }

    private void resolvePhysicalAttack(PhysicalResult physicalResult, int n) {
        Object object;
        AbstractAttackAction abstractAttackAction = physicalResult.aaa;
        if (abstractAttackAction instanceof PunchAttackAction) {
            object = (PunchAttackAction)abstractAttackAction;
            if (((PunchAttackAction)object).getArm() == 0) {
                ((PunchAttackAction)object).setArm(1);
                physicalResult.aaa = object;
                this.resolvePunchAttack(physicalResult, n);
                n = ((AbstractEntityAction)object).getEntityId();
                ((PunchAttackAction)object).setArm(2);
                physicalResult.aaa = object;
                this.resolvePunchAttack(physicalResult, n);
            } else {
                this.resolvePunchAttack(physicalResult, n);
                n = ((AbstractEntityAction)object).getEntityId();
            }
        } else if (abstractAttackAction instanceof KickAttackAction) {
            this.resolveKickAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof BrushOffAttackAction) {
            object = (BrushOffAttackAction)abstractAttackAction;
            if (((BrushOffAttackAction)object).getArm() == 0) {
                ((BrushOffAttackAction)object).setArm(1);
                physicalResult.aaa = object;
                this.resolveBrushOffAttack(physicalResult, n);
                n = ((AbstractEntityAction)object).getEntityId();
                ((BrushOffAttackAction)object).setArm(2);
                physicalResult.aaa = object;
                this.resolveBrushOffAttack(physicalResult, n);
            } else {
                this.resolveBrushOffAttack(physicalResult, n);
                n = ((AbstractEntityAction)object).getEntityId();
            }
        } else if (abstractAttackAction instanceof ThrashAttackAction) {
            this.resolveThrashAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof ProtomechPhysicalAttackAction) {
            this.resolveProtoAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof ClubAttackAction) {
            this.resolveClubAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof PushAttackAction) {
            this.resolvePushAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof ChargeAttackAction) {
            this.resolveChargeAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof DfaAttackAction) {
            this.resolveDfaAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof LayExplosivesAttackAction) {
            this.resolveLayExplosivesAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof TripAttackAction) {
            this.resolveTripAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof JumpJetAttackAction) {
            this.resolveJumpJetAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof GrappleAttackAction) {
            this.resolveGrappleAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        } else if (abstractAttackAction instanceof BreakGrappleAttackAction) {
            this.resolveBreakGrappleAttack(physicalResult, n);
            n = abstractAttackAction.getEntityId();
        }
        object = this.game.getTarget(abstractAttackAction.getTargetType(), abstractAttackAction.getTargetId());
        if (object instanceof Entity) {
            this.creditKill((Entity)object, this.game.getEntity(n));
        }
    }

    private void checkExtremeGravityMovement(Entity entity, MoveStep moveStep, Coords coords, int n) {
        if (this.game.getOptions().floatOption("gravity") != 1.0f) {
            if (entity instanceof Mech) {
                if (moveStep.getMovementType() == 1 || moveStep.getMovementType() == 4 || moveStep.getMovementType() == 2 || moveStep.getMovementType() == 5) {
                    if (moveStep.getMpUsed() > n) {
                        this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                    }
                } else if (moveStep.getMovementType() == 3) {
                    System.err.println("gravity move check jump: " + moveStep.getMpUsed() + "/" + n);
                    System.err.flush();
                    if (moveStep.getMpUsed() > n) {
                        this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                    } else if (this.game.getOptions().floatOption("gravity") > 1.0f) {
                        PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
                        entity.addPilotingModifierForTerrain(pilotingRollData, moveStep);
                        pilotingRollData.append(new PilotingRollData(entity.getId(), 0, "jumped in high gravity"));
                        this.game.addExtremeGravityPSR(pilotingRollData);
                    }
                }
            } else if (entity instanceof Tank && (moveStep.getMovementType() == 1 || moveStep.getMovementType() == 4 || moveStep.getMovementType() == 2 || moveStep.getMovementType() == 5)) {
                if (moveStep.getMpUsed() > n && !moveStep.isOnlyPavement()) {
                    this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                } else if (moveStep.getMpUsed() > n + 1) {
                    this.game.addExtremeGravityPSR(entity.checkMovedTooFast(moveStep));
                }
            }
        }
    }

    private void doExtremeGravityDamage(Entity entity, int n) {
        HitData hitData;
        int n2;
        if (entity instanceof BipedMech) {
            for (n2 = 6; n2 <= 7; ++n2) {
                hitData = new HitData(n2);
                this.addReport(this.damageEntity(entity, hitData, n, false, 0, true));
            }
        }
        if (entity instanceof QuadMech) {
            for (n2 = 4; n2 <= 7; ++n2) {
                hitData = new HitData(n2);
                this.addReport(this.damageEntity(entity, hitData, n, false, 0, true));
            }
        } else if (entity instanceof Tank) {
            hitData = new HitData(1);
            this.addReport(this.damageEntity(entity, hitData, n, false, 0, true));
        }
    }

    public Vector<Report> ejectEntity(Entity entity, boolean bl) {
        Vector<Report> vector = new Vector<Report>();
        if (entity.getCrew().isEjected()) {
            return vector;
        }
        if (entity.getCrew().isDead() || entity.getCrew().isDoomed()) {
            return vector;
        }
        if (entity instanceof Mech) {
            Report report;
            PilotingRollData pilotingRollData = new PilotingRollData(entity.getId(), entity.getCrew().getPiloting(), "ejecting");
            if (entity.isProne()) {
                pilotingRollData.addModifier(5, "Mech is prone");
            }
            if (entity.getCrew().isUnconscious()) {
                pilotingRollData.addModifier(3, "pilot unconscious");
            }
            if (bl) {
                pilotingRollData.addModifier(1, "automatic ejection");
            }
            if (entity.getInternal(0) < 3) {
                pilotingRollData.addModifier(Math.min(3 - entity.getInternal(0), 2), "Head Internal Structure Damage");
            }
            int n = entity.getFacing();
            Coords coords = entity.getPosition().translated((n + 3) % 6);
            IHex iHex = this.game.getBoard().getHex(coords);
            if (iHex != null) {
                if (iHex.terrainLevel(4) > 0 && !iHex.containsTerrain(20)) {
                    pilotingRollData.addModifier(-1, "landing in water");
                } else if (iHex.containsTerrain(2)) {
                    pilotingRollData.addModifier(0, "landing in rough");
                } else if (iHex.containsTerrain(3)) {
                    pilotingRollData.addModifier(0, "landing in rubble");
                } else if (iHex.terrainLevel(1) == 1) {
                    pilotingRollData.addModifier(2, "landing in light woods");
                } else if (iHex.terrainLevel(1) == 2) {
                    pilotingRollData.addModifier(3, "landing in heavy woods");
                } else if (iHex.terrainLevel(1) == 3) {
                    pilotingRollData.addModifier(4, "landing in ultra heavy woods");
                } else if (iHex.terrainLevel(23) == 1) {
                    pilotingRollData.addModifier(3, "landing in light jungle");
                } else if (iHex.terrainLevel(23) == 2) {
                    pilotingRollData.addModifier(5, "landing in heavy jungle");
                } else if (iHex.terrainLevel(23) == 3) {
                    pilotingRollData.addModifier(7, "landing in ultra heavy jungle");
                } else if (iHex.terrainLevel(12) > 0) {
                    pilotingRollData.addModifier(iHex.terrainLevel(12), "landing in a building");
                } else {
                    pilotingRollData.addModifier(-2, "landing in clear terrain");
                }
            } else {
                pilotingRollData.addModifier(-2, "landing off the board");
            }
            if (bl) {
                report = new Report(6395);
                report.subject = entity.getId();
                report.addDesc(entity);
                report.indent(2);
                report.newlines = 0;
                vector.addElement(report);
            }
            report = new Report(2180);
            report.subject = entity.getId();
            report.addDesc(entity);
            report.add(pilotingRollData.getLastPlainDesc(), true);
            report.indent(3);
            vector.addElement(report);
            int n2 = Compute.d6(2);
            report = new Report(2190);
            report.subject = entity.getId();
            report.add(pilotingRollData.getValueAsString());
            report.add(pilotingRollData.getDesc());
            report.add(n2);
            report.indent(4);
            report.newlines = 0;
            MechWarrior mechWarrior = new MechWarrior(entity);
            mechWarrior.setDeployed(true);
            mechWarrior.setId(this.getFreeEntityId());
            this.game.addEntity(mechWarrior.getId(), mechWarrior);
            this.send(this.createAddEntityPacket(mechWarrior.getId()));
            mechWarrior.setDone(true);
            if (n2 < pilotingRollData.getValue()) {
                report.choose(false);
                vector.addElement(report);
                Report.addNewline(vector);
                vector.addAll(this.damageCrew(mechWarrior, 1));
            } else {
                report.choose(true);
                vector.addElement(report);
            }
            if (entity.getCrew().isDoomed()) {
                vector.addAll(this.destroyEntity(mechWarrior, "deadly ejection", false, false));
            } else {
                if (this.game.getBoard().contains(coords)) {
                    mechWarrior.setPosition(coords);
                    report = new Report(6400);
                    report.subject = entity.getId();
                    report.indent(5);
                    vector.addElement(report);
                    if (this.game.getOptions().booleanOption("vacuum")) {
                        report = new Report(6405);
                        report.subject = entity.getId();
                        report.indent(3);
                        vector.addElement(report);
                        vector.addAll(this.destroyEntity(mechWarrior, "explosive decompression", false, false));
                    }
                    this.entityUpdate(mechWarrior.getId());
                    this.doEntityDisplacementMinefieldCheck(mechWarrior, entity.getPosition(), coords);
                } else {
                    report = new Report(6410);
                    report.subject = entity.getId();
                    report.indent(3);
                    vector.addElement(report);
                    if (this.game.getOptions().booleanOption("vacuum")) {
                        report = new Report(6405);
                        report.subject = entity.getId();
                        report.indent(3);
                        vector.addElement(report);
                        vector.addAll(this.destroyEntity(mechWarrior, "explosive decompression", false, false));
                    } else {
                        this.game.removeEntity(mechWarrior.getId(), 256);
                        this.send(this.createRemoveEntityPacket(mechWarrior.getId(), 256));
                    }
                }
                if (this.game.getOptions().booleanOption("ejected_pilots_flee")) {
                    this.game.removeEntity(mechWarrior.getId(), 256);
                    this.send(this.createRemoveEntityPacket(mechWarrior.getId(), 256));
                }
            }
        } else if (this.game.getBoard().contains(entity.getPosition()) && !this.game.getOptions().booleanOption("ejected_pilots_flee") && entity instanceof Tank) {
            int n = Math.max(1, (int)(14.0f + entity.getWeight()) / 15);
            MechWarrior mechWarrior = new MechWarrior(entity);
            mechWarrior.setChassis("Vehicle Crew");
            mechWarrior.setDeployed(true);
            mechWarrior.setId(this.getFreeEntityId());
            mechWarrior.initializeInternal(n, 0);
            this.game.addEntity(mechWarrior.getId(), mechWarrior);
            this.send(this.createAddEntityPacket(mechWarrior.getId()));
            mechWarrior.setDone(true);
            mechWarrior.setPosition(entity.getPosition());
            this.entityUpdate(mechWarrior.getId());
            this.doEntityDisplacementMinefieldCheck(mechWarrior, entity.getPosition(), entity.getPosition());
        }
        entity.getCrew().setEjected(true);
        if (entity instanceof VTOL) {
            vector.addAll(this.crashVTOL((VTOL)entity));
        }
        vector.addAll(this.destroyEntity(entity, "ejection", true, true));
        if (!bl) {
            this.game.removeEntity(entity.getId(), 528);
            this.send(this.createRemoveEntityPacket(entity.getId(), 528));
        }
        return vector;
    }

    public Vector<Report> abandonEntity(Entity entity) {
        Vector<Report> vector = new Vector<Report>();
        if (entity.getCrew().isEjected()) {
            return vector;
        }
        if (entity.getCrew().isDoomed()) {
            return vector;
        }
        if (this.game.getOptions().booleanOption("vacuum")) {
            return vector;
        }
        Coords coords = entity.getPosition();
        if (entity instanceof Mech) {
            Report report = new Report(2027);
            report.subject = entity.getId();
            report.add(entity.getCrew().getName());
            report.addDesc(entity);
            report.indent(3);
            vector.addElement(report);
            MechWarrior mechWarrior = new MechWarrior(entity);
            mechWarrior.getCrew().setUnconscious(entity.getCrew().isUnconscious());
            mechWarrior.setDeployed(true);
            mechWarrior.setId(this.getFreeEntityId());
            this.game.addEntity(mechWarrior.getId(), mechWarrior);
            this.send(this.createAddEntityPacket(mechWarrior.getId()));
            mechWarrior.setDone(true);
            if (this.game.getBoard().contains(coords)) {
                mechWarrior.setPosition(coords);
            }
            this.entityUpdate(mechWarrior.getId());
            this.doEntityDisplacementMinefieldCheck(mechWarrior, entity.getPosition(), coords);
            if (this.game.getOptions().booleanOption("ejected_pilots_flee")) {
                this.game.removeEntity(mechWarrior.getId(), 256);
                this.send(this.createRemoveEntityPacket(mechWarrior.getId(), 256));
            }
        } else if (this.game.getBoard().contains(entity.getPosition()) && !this.game.getOptions().booleanOption("ejected_pilots_flee") && this.game.getOptions().booleanOption("vehicles_can_eject") && entity instanceof Tank) {
            int n = Math.max(1, (int)(14.0f + entity.getWeight()) / 15);
            MechWarrior mechWarrior = new MechWarrior(entity);
            mechWarrior.setChassis("Vehicle Crew");
            mechWarrior.setDeployed(true);
            mechWarrior.setId(this.getFreeEntityId());
            mechWarrior.initializeInternal(n, 0);
            this.game.addEntity(mechWarrior.getId(), mechWarrior);
            this.send(this.createAddEntityPacket(mechWarrior.getId()));
            mechWarrior.setDone(true);
            mechWarrior.setPosition(entity.getPosition());
            this.entityUpdate(mechWarrior.getId());
            this.doEntityDisplacementMinefieldCheck(mechWarrior, entity.getPosition(), entity.getPosition());
        }
        entity.getCrew().setEjected(true);
        return vector;
    }

    private void resolveMechWarriorPickUp() {
        Enumeration<Entity> enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                MechWarrior mechWarrior;
                return entity instanceof MechWarrior && (mechWarrior = (MechWarrior)entity).getPickedUpById() == -1 && !mechWarrior.isDoomed() && mechWarrior.getTransportId() == -1;
            }
        });
        while (enumeration.hasMoreElements()) {
            Report report;
            Object object;
            boolean bl = false;
            MechWarrior mechWarrior = (MechWarrior)enumeration.nextElement();
            Enumeration<Entity> enumeration2 = this.game.getEntities(mechWarrior.getPosition());
            while (enumeration2.hasMoreElements()) {
                object = enumeration2.nextElement();
                if (((Entity)object).isDoomed() || ((Entity)object).isShutDown() || ((Entity)object).getCrew().isUnconscious() || bl || ((Entity)object).getOwnerId() != mechWarrior.getOwnerId() || ((Entity)object).getId() == mechWarrior.getId()) continue;
                if (object instanceof MechWarrior) {
                    report = new Report(6415, 0);
                    report.add(((Entity)object).getDisplayName());
                    this.addReport(report);
                    continue;
                }
                ((Entity)object).pickUp(mechWarrior);
                mechWarrior.setPickedUpById(((Entity)object).getId());
                mechWarrior.setPickedUpByExternalId(((Entity)object).getExternalId());
                bl = true;
                report = new Report(6420, 0);
                report.add(mechWarrior.getDisplayName());
                report.addDesc((Entity)object);
                this.addReport(report);
            }
            if (!bl) {
                object = this.game.getEnemyEntities(mechWarrior.getPosition(), mechWarrior);
                while (object.hasMoreElements()) {
                    Entity entity = (Entity)object.nextElement();
                    if (entity.isDoomed() || entity.isShutDown() || entity.getCrew().isUnconscious()) continue;
                    if (entity instanceof MechWarrior) {
                        report = new Report(6415, 0);
                        report.add(entity.getDisplayName());
                        this.addReport(report);
                        continue;
                    }
                    entity.pickUp(mechWarrior);
                    mechWarrior.setCaptured(true);
                    mechWarrior.setPickedUpById(entity.getId());
                    mechWarrior.setPickedUpByExternalId(entity.getExternalId());
                    bl = true;
                    report = new Report(6420, 0);
                    report.add(mechWarrior.getDisplayName());
                    report.addDesc(entity);
                    this.addReport(report);
                }
            }
            if (!bl) continue;
            mechWarrior.setPosition(null);
            this.entityUpdate(mechWarrior.getId());
        }
    }

    private void resolveSinkVees() {
        Enumeration<Entity> enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                if (entity.isOffBoard()) {
                    return false;
                }
                return entity instanceof Tank && entity.getPosition() != null && (entity.getMovementMode() == 3 || entity.getMovementMode() == 4) && Server.this.game.getBoard().getHex(entity.getPosition()).terrainLevel(4) > 0 && entity.getElevation() < 0;
            }
        });
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            this.addReport(this.destroyEntity(entity, "a watery grave", false));
        }
    }

    private void doTryUnstuck() {
        if (this.game.getPhase() != 8) {
            return;
        }
        Enumeration<Entity> enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return entity.isStuck();
            }
        });
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            PilotingRollData pilotingRollData = entity.getBasePilotingRoll();
            entity.addPilotingModifierForTerrain(pilotingRollData);
            IHex iHex = this.game.getBoard().getHex(entity.getPosition());
            if (!iHex.containsTerrain(9) && iHex.terrainLevel(24) != 2) {
                pilotingRollData.addModifier(-1, "bogged down");
            }
            Report report = new Report(2340);
            report.addDesc(entity);
            this.addReport(report);
            int n = Compute.d6(2);
            report = new Report(2190);
            report.add(pilotingRollData.getValueAsString());
            report.add(pilotingRollData.getDesc());
            report.add(n);
            if (n < pilotingRollData.getValue()) {
                report.choose(false);
            } else {
                report.choose(true);
                entity.setStuck(false);
                entity.setCanUnstickByJumping(false);
                this.entityUpdate(entity.getId());
            }
            this.addReport(report);
        }
    }

    private void resolveVeeINarcPodRemoval() {
        Enumeration<Entity> enumeration = this.game.getSelectedEntities(new EntitySelector(){

            public boolean accept(Entity entity) {
                return entity instanceof Tank && entity.mpUsed == 0;
            }
        });
        while (enumeration.hasMoreElements()) {
            boolean bl = true;
            Entity entity = enumeration.nextElement();
            for (int i = 0; i <= 5; ++i) {
                if (!entity.weaponFiredFrom(i)) continue;
                bl = false;
            }
            if (!bl || !entity.hasINarcPodsAttached() || !entity.getCrew().isActive()) continue;
            entity.removeAllINarcPods();
            Report report = new Report(2345);
            report.addDesc(entity);
            this.addReport(report);
        }
    }

    private void resolveIceBroken(Coords coords) {
        this.game.getBoard().getHex(coords).removeTerrain(20);
        this.sendChangedHex(coords);
        Enumeration<Entity> enumeration = this.game.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (entity.getElevation() != 0) continue;
            this.doEntityFall(entity, new PilotingRollData(0x7FFFFFFE));
        }
    }

    private void checkForVehicleFire(Tank tank, boolean bl) {
        int n = Compute.d6(2);
        int n2 = 0;
        switch (tank.getMovementMode()) {
            case 5: {
                n2 = 4;
                break;
            }
            case 4: 
            case 6: {
                n2 = 2;
            }
        }
        if (bl) {
            n = 12;
        }
        Report report = new Report(5250);
        report.subject = tank.getId();
        report.addDesc(tank);
        report.add(8 - n2);
        report.add(n);
        if (n + n2 < 8) {
            report.choose(true);
            this.addReport(report);
        } else {
            if (!bl) {
                report.choose(false);
                this.addReport(report);
            }
            if (n + n2 < 10) {
                this.addReport(this.vehicleMotiveDamage(tank, n2 - 1));
            } else {
                this.resolveVehicleFire(tank, false);
                if (n + n2 >= 12) {
                    report = new Report(5255);
                    report.subject = tank.getId();
                    report.indent(3);
                    this.addReport(report);
                    tank.setOnFire(bl);
                }
            }
        }
    }

    private void resolveVehicleFire(Tank tank, boolean bl) {
        if (bl && !tank.isOnFire()) {
            return;
        }
        for (int i = 0; i < tank.locations(); ++i) {
            if (i == 0 || tank instanceof VTOL && i == 5 || bl && !tank.isLocationBurning(i)) continue;
            HitData hitData = new HitData(i);
            int n = Compute.d6(1);
            this.addReport(this.damageEntity(tank, hitData, n));
            if (n != 1 || !bl) continue;
            tank.extinguishLocation(i);
        }
        this.addNewLines();
    }

    private Vector<Report> vehicleMotiveDamage(Tank tank, int n) {
        Vector<Report> vector = new Vector<Report>();
        Report report = new Report(1210, 0);
        vector.add(report);
        switch (tank.getMovementMode()) {
            case 5: 
            case 8: {
                n += 3;
                break;
            }
            case 4: {
                n += 2;
                break;
            }
            case 15: {
                n += 4;
                break;
            }
            case 6: {
                int n2 = tank.getOriginalWalkMP();
                if (n2 > 0) {
                    tank.setOriginalWalkMP(n2 - 1);
                }
                if (n2 > 1) {
                    report = new Report(6660);
                    report.subject = tank.getId();
                    vector.add(report);
                } else {
                    report = new Report(6670);
                    report.subject = tank.getId();
                    vector.add(report);
                    vector.addAll(this.crashVTOL((VTOL)tank));
                }
                return vector;
            }
        }
        int n3 = Compute.d6(2) + n;
        report = new Report(6305);
        report.subject = tank.getId();
        report.add("movement system");
        report.newlines = 0;
        report.indent(3);
        vector.add(report);
        report = new Report(6310);
        report.subject = tank.getId();
        report.add(n3);
        report.newlines = 0;
        vector.add(report);
        report = new Report(3340);
        report.add(n);
        report.subject = tank.getId();
        vector.add(report);
        if (n3 <= 5) {
            report = new Report(6005);
            report.subject = tank.getId();
            report.indent(3);
            vector.add(report);
        } else if (n3 <= 7) {
            report = new Report(6470);
            report.subject = tank.getId();
            report.indent(3);
            vector.add(report);
            tank.addMovementDamage(1);
        } else if (n3 <= 9) {
            report = new Report(6471);
            report.subject = tank.getId();
            report.indent(3);
            vector.add(report);
            tank.addMovementDamage(2);
            int n4 = tank.getOriginalWalkMP();
            if (n4 > 0) {
                tank.setOriginalWalkMP(n4 - 1);
            }
        } else if (n3 <= 11) {
            report = new Report(6472);
            report.subject = tank.getId();
            report.indent(3);
            vector.add(report);
            tank.addMovementDamage(3);
            int n5 = tank.getOriginalWalkMP();
            if (n5 > 0) {
                tank.setOriginalWalkMP(n5 / 2);
            }
        } else {
            report = new Report(6473);
            report.subject = tank.getId();
            report.indent(3);
            vector.add(report);
            tank.immobilize();
        }
        if (tank.getOriginalWalkMP() == 0 || tank.isImmobile()) {
            if (tank.getMovementMode() == 5 && this.game.getBoard().getHex(tank.getPosition()).terrainLevel(4) > 0 && !this.game.getBoard().getHex(tank.getPosition()).containsTerrain(20)) {
                vector.addAll(this.destroyEntity(tank, "a watery grave", false));
            }
            if (tank instanceof VTOL) {
                vector.addAll(this.crashVTOL((VTOL)tank));
            }
        }
        return vector;
    }

    private void addReport(Vector<Report> vector) {
        if (this.doBlind()) {
            Enumeration<Connection> enumeration = this.connections.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = enumeration.nextElement();
                Player player = this.game.getPlayer(connection.getId());
                player.getTurnReport().addAll(this.filterReportVector(vector, player));
            }
        }
        this.vPhaseReport.addAll(vector);
    }

    private void addReport(Report report) {
        if (this.doBlind()) {
            Enumeration<Connection> enumeration = this.connections.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = enumeration.nextElement();
                Player player = this.game.getPlayer(connection.getId());
                player.getTurnReport().addElement(this.filterReport(report, player, false));
            }
        }
        this.vPhaseReport.addElement(report);
    }

    private void clearReports() {
        if (this.doBlind()) {
            Enumeration<Connection> enumeration = this.connections.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = enumeration.nextElement();
                Player player = this.game.getPlayer(connection.getId());
                player.getTurnReport().removeAllElements();
            }
        }
        this.vPhaseReport.removeAllElements();
    }

    private void addNewLines() {
        if (this.doBlind()) {
            Enumeration<Connection> enumeration = this.connections.elements();
            while (enumeration.hasMoreElements()) {
                Connection connection = enumeration.nextElement();
                Player player = this.game.getPlayer(connection.getId());
                Report.addNewline(player.getTurnReport());
            }
        }
        Report.addNewline(this.vPhaseReport);
    }

    public void doAssaultDrop(Entity entity) {
        PilotingRollData pilotingRollData = entity instanceof Mech ? entity.getBasePilotingRoll() : new PilotingRollData(entity.getId(), 4, "landing assault drop");
        int n = Compute.d6(2);
        Report report = new Report(2380);
        report.subject = entity.getId();
        report.add(entity.getDisplayName(), true);
        report.add(pilotingRollData.getValueAsString());
        report.add(n);
        report.choose(n >= pilotingRollData.getValue());
        this.addReport(report);
        if (n < pilotingRollData.getValue()) {
            int n2 = pilotingRollData.getValue() - n;
            int n3 = Compute.d6(n2);
            Coords coords = Compute.scatter(entity.getPosition(), n3);
            report = new Report(2385);
            report.subject = entity.getId();
            report.add(n3);
            report.indent(3);
            report.newlines = 0;
            this.addReport(report);
            if (n2 >= 5 || !this.game.getBoard().contains(coords)) {
                report = new Report(2386);
                this.addReport(report);
                this.game.removeEntity(entity.getId(), 2048);
                return;
            }
            entity.setPosition(coords);
            if (entity instanceof Mech || entity instanceof Protomech) {
                entity.setElevation(n2);
                this.doEntityFallsInto(entity, coords, coords, pilotingRollData, true);
            } else if (entity instanceof BattleArmor) {
                for (int i = 1; i < entity.locations(); ++i) {
                    HitData hitData = new HitData(i);
                    this.addReport(this.damageEntity(entity, hitData, Compute.d6(n2)));
                    this.addNewLines();
                }
            } else if (entity instanceof Infantry) {
                HitData hitData = new HitData(0);
                this.addReport(this.damageEntity(entity, hitData, 1));
                this.addNewLines();
            }
        }
        IHex iHex = this.game.getBoard().getHex(entity.getPosition());
        entity.setElevation(entity.elevationOccupied(iHex) - iHex.floor());
        Entity entity2 = Compute.stackingViolation(this.game, entity, entity.getPosition(), null);
        if (entity2 != null) {
            entity.setElevation(entity2.getElevation() + 2);
            report = new Report(2390);
            report.subject = entity.getId();
            report.add(entity.getDisplayName(), true);
            report.add(entity2.getDisplayName(), true);
            this.addReport(report);
            this.doEntityFallsInto(entity, entity.getPosition(), entity.getPosition(), pilotingRollData);
        }
    }

    void doAllAssaultDrops() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Entity entity = enumeration.nextElement();
            if (!entity.isAssaultDropInProgress()) continue;
            this.doAssaultDrop(entity);
            entity.setLandedAssaultDrop();
        }
    }

    void doMagmaDamage(Entity entity, boolean bl) {
        if ((entity.getMovementMode() == 6 || entity.getMovementMode() == 5 && entity.getOriginalWalkMP() > 0 && !bl) && !entity.isImmobile()) {
            return;
        }
        boolean bl2 = entity instanceof Mech;
        Report report = bl2 ? new Report(2405) : new Report(2400);
        report.addDesc(entity);
        report.subject = entity.getId();
        this.addReport(report);
        if (bl2) {
            for (int i = 0; i < entity.locations(); ++i) {
                if (!bl && !entity.locationIsLeg(i) && !entity.isProne()) continue;
                HitData hitData = new HitData(i);
                this.addReport(this.damageEntity(entity, hitData, Compute.d6(2)));
            }
        } else {
            this.addReport(this.destroyEntity(entity, "fell into magma", false, false));
        }
        this.addNewLines();
    }

    void artilleryDamageHex(Coords coords, Coords coords2, int n, AmmoType ammoType, int n2, Entity entity, Entity entity2, boolean bl, int n3) {
        Report report;
        IHex iHex = this.game.getBoard().getHex(coords);
        if (iHex == null) {
            return;
        }
        int n4 = n3 - iHex.surface();
        if (!bl) {
            this.tryClearHex(coords, n * 2, n2);
        }
        Building building = this.game.getBoard().getBuildingAt(coords);
        int n5 = 0;
        if (!(building == null || bl && n4 > iHex.terrainLevel(12))) {
            n5 = building.getPhaseCF() / 10;
            if (ammoType == null || ammoType.getMunitionType() != 4L) {
                report = this.damageBuilding(building, n);
                if (report != null) {
                    report.subject = n2;
                    this.addReport(report);
                }
                this.addNewLines();
            }
        }
        if (bl && (n4 <= 0 || n4 <= iHex.terrainLevel(12) || n4 == iHex.terrainLevel(16))) {
            return;
        }
        Enumeration<Entity> enumeration = this.game.getEntities(coords);
        while (enumeration.hasMoreElements()) {
            Entity entity3 = enumeration.nextElement();
            int n6 = n;
            ToHitData toHitData = new ToHitData();
            int n7 = 5;
            if (entity3 == entity2) continue;
            if (building != null && n5 > 0 && entity3.getElevation() < iHex.terrainLevel(12)) {
                n7 -= n5;
                if (entity3 instanceof Infantry) continue;
                if (n7 <= 0) {
                    report = new Report(6426);
                    report.subject = n2;
                    report.addDesc(entity3);
                    this.addReport(report);
                    continue;
                }
                report = new Report(6425);
                report.subject = n2;
                report.add(n5);
                this.addReport(report);
            }
            if (!bl ? (entity3 instanceof VTOL || entity3.getMovementMode() == 6) && entity3.getElevation() != 0 && entity3.getElevation() != iHex.terrainLevel(12) && entity3.getElevation() != iHex.terrainLevel(16) : !(entity3 instanceof VTOL) && entity3.getMovementMode() != 6 || entity3.getElevation() != n4) continue;
            if (coords2 != null) {
                toHitData.setSideTable(entity3.sideTable(coords2));
                if (ammoType != null && entity3 instanceof Mech && ammoType.getMunitionType() == 1L && coords2.equals(coords)) {
                    toHitData.setHitTable(4);
                }
            }
            if (entity3 instanceof Infantry && !(entity3 instanceof BattleArmor)) {
                n6 *= 2;
            }
            if (ammoType != null) {
                if (ammoType.getMunitionType() == 1L) {
                    if (iHex.containsTerrain(21) && entity3 instanceof Infantry && !(entity3 instanceof BattleArmor)) {
                        n6 *= 2;
                    }
                    if (iHex.containsTerrain(1) || iHex.containsTerrain(23)) {
                        n6 = (n6 + 1) / 2;
                    }
                } else if (ammoType.getMunitionType() == 4L) {
                    if (entity3 instanceof Tank && (entity3.getMovementMode() == 4 || entity3.getMovementMode() == 5)) {
                        report = new Report(6480);
                        report.subject = entity3.getId();
                        report.addDesc(entity3);
                        report.add(toHitData.getTableDesc());
                        report.add(0);
                        this.addReport(report);
                        this.addReport(this.vehicleMotiveDamage((Tank)entity3, 0));
                        continue;
                    }
                    if (entity3 instanceof BattleArmor || !(entity3 instanceof Infantry)) continue;
                    if (iHex.containsTerrain(1) || iHex.containsTerrain(23)) {
                        n6 = (n6 + 1) / 2;
                    }
                }
            }
            this.addNewLines();
            report = new Report(6480);
            report.subject = entity3.getId();
            report.addDesc(entity3);
            report.add(toHitData.getTableDesc());
            report.add(n6);
            this.addReport(report);
            if (entity3 instanceof BattleArmor) {
                for (int i = 0; i < entity3.locations(); ++i) {
                    if (entity3.getInternal(i) <= 0) continue;
                    HitData hitData = new HitData(i);
                    this.addReport(this.damageEntity(entity3, hitData, n6, false, 0, false, true, false));
                }
            } else {
                while (n6 > 0) {
                    HitData hitData = entity3.rollHitLocation(toHitData.getHitTable(), toHitData.getSideTable());
                    this.addReport(this.damageEntity(entity3, hitData, Math.min(n7, n6), false, 0, false, true, false));
                    n6 -= Math.min(5, n6);
                }
            }
            if (entity != null) {
                this.creditKill(entity3, entity);
            }
            this.addNewLines();
        }
    }

    void artilleryDamageArea(Coords coords, Coords coords2, AmmoType ammoType, int n, Entity entity, boolean bl, int n2) {
        int n3;
        int n4 = 5;
        if (ammoType.getMunitionType() == 4L) {
            n3 = ammoType.getRackSize() + 10;
        } else if (ammoType.getMunitionType() == 1L) {
            n3 = ammoType.getAmmoType() == 17 ? 15 : ammoType.getRackSize();
            coords2 = coords;
        } else if (this.game.getOptions().booleanOption("maxtech_artillery")) {
            n3 = ammoType.getAmmoType() == 16 ? 25 : ammoType.getRackSize() + 10;
            n4 = 10;
        } else {
            n3 = ammoType.getRackSize();
            n4 = (n3 + 1) / 2;
        }
        this.artilleryDamageArea(coords, coords2, ammoType, n, entity, n3, n4, bl, n2);
    }

    void artilleryDamageArea(Coords coords, Coords coords2, AmmoType ammoType, int n, Entity entity, int n2, int n3, boolean bl, int n4) {
        int n5 = 0;
        while (n2 > 0) {
            ArrayList<Coords> arrayList = Compute.coordsAtRange(coords, n5);
            for (Coords coords3 : arrayList) {
                this.artilleryDamageHex(coords3, coords2, n2, ammoType, n, entity, null, bl, n4);
            }
            coords2 = coords;
            ++n5;
            n2 -= n3;
        }
    }

    void resolveFortify() {
        Enumeration<Entity> enumeration = this.game.getEntities();
        while (enumeration.hasMoreElements()) {
            Report report;
            Entity entity = enumeration.nextElement();
            if (!(entity instanceof Infantry)) continue;
            Infantry infantry = (Infantry)entity;
            int n = infantry.getDugIn();
            if (n == 1) {
                report = new Report(5300);
                report.addDesc(infantry);
                report.subject = infantry.getId();
                this.addReport(report);
                continue;
            }
            if (n != 4) continue;
            Coords coords = infantry.getPosition();
            report = new Report(5305);
            report.addDesc(infantry);
            report.add(coords.getBoardNum());
            report.subject = infantry.getId();
            this.addReport(report);
            IHex iHex = this.game.getBoard().getHex(coords);
            iHex.addTerrain(Terrains.getTerrainFactory().createTerrain(21, 1));
            this.sendChangedHex(coords);
            Enumeration<Entity> enumeration2 = this.game.getEntities(coords);
            while (enumeration2.hasMoreElements()) {
                Entity entity2 = enumeration2.nextElement();
                if (!(entity2 instanceof Infantry)) continue;
                Infantry infantry2 = (Infantry)entity;
                infantry2.setDugIn(0);
            }
        }
    }

    private void checkBreakSpikes(Entity entity, int n) {
        int n2 = Compute.d6(2);
        if (n2 < 9) {
            Report report = new Report(4445);
            report.newlines = 0;
            report.add(n2);
            report.subject = entity.getId();
            this.addReport(report);
            return;
        }
        Report report = new Report(4440);
        report.newlines = 0;
        report.add(n2);
        report.subject = entity.getId();
        this.addReport(report);
        for (Mounted mounted : entity.getMisc()) {
            if (!mounted.getType().hasFlag(0x400000000L) || mounted.getLocation() != n) continue;
            mounted.setHit(true);
        }
    }

    class ConnectionWatchdog
    extends TimerTask {
        private Server server;
        private int id;
        private int failCount;

        public ConnectionWatchdog(Server server2, int n) {
            this.server = server2;
            this.id = n;
            this.failCount = 0;
        }

        public void run() {
            if (this.server.getPlayer(this.id) != null) {
                this.cancel();
                return;
            }
            if (this.server.getPendingConnection(this.id) == null) {
                this.cancel();
                return;
            }
            System.err.println("Bark Bark");
            if (this.failCount > 10) {
                this.server.getPendingConnection(this.id).close();
                this.cancel();
                System.err.println("Growl");
                return;
            }
            this.server.greeting(this.id);
            ++this.failCount;
        }
    }
}

