/*
 * Decompiled with CFR 0.152.
 */
package megamek.server.commands;

import megamek.common.Coords;
import megamek.common.actions.NukeAttackAction;
import megamek.server.Server;
import megamek.server.commands.ServerCommand;

public class NukeCommand
extends ServerCommand {
    public NukeCommand(Server server) {
        super(server, "nuke", "Drops a nuke onto the board.");
    }

    public void run(int n, String[] stringArray) {
        if (!this.server.getGame().getOptions().booleanOption("really_allow_nukes") || !this.server.getGame().getOptions().booleanOption("allow_nukes")) {
            this.server.sendServerChat(n, "Command-line nukes are not enabled in this game.");
            return;
        }
        if (stringArray.length == 4) {
            try {
                int n2 = new Integer(stringArray[1]) - 1;
                int n3 = new Integer(stringArray[2]) - 1;
                int n4 = new Integer(stringArray[3]);
                this.server.getGame().addArtilleryAttack(new NukeAttackAction(new Coords(n2, n3), n4, -1));
                this.server.sendServerChat(n, "A nuke is incoming!  Take cover!");
            }
            catch (Exception exception) {
                this.server.sendServerChat(n, "Nuke command failed (1).  Proper format is \"/nuke <x> <y> <type>\" or \"/nuke <x> <y> <damage> <degredation> <secondary radius> <craterdepth>\"");
            }
        } else if (stringArray.length == 7) {
            try {
                int n5 = new Integer(stringArray[1]) - 1;
                int n6 = new Integer(stringArray[2]) - 1;
                int n7 = new Integer(stringArray[3]);
                int n8 = new Integer(stringArray[4]);
                int n9 = new Integer(stringArray[5]);
                int n10 = new Integer(stringArray[6]);
                this.server.getGame().addArtilleryAttack(new NukeAttackAction(new Coords(n5, n6), n7, n8, n9, n10, -1));
                this.server.sendServerChat(n, "A nuke is incoming!  Take cover!");
            }
            catch (Exception exception) {
                this.server.sendServerChat(n, "Nuke command failed (2).  Proper format is \"/nuke <x> <y> <type>\" or \"/nuke <x> <y> <damage> <degredation> <secondary radius> <craterdepth>\"");
            }
        } else {
            this.server.sendServerChat(n, "Nuke command failed (3).  Proper format is \"/nuke <x> <y> <type>\" or \"/nuke <x> <y> <damage> <degredation> <secondary radius> <craterdepth>\"");
        }
    }
}

