/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote;

import com.lyrisoft.chat.ICommands;
import com.lyrisoft.chat.IConnectionHandler;
import com.lyrisoft.chat.IConnectionListener;
import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.CommandMakerRemote;
import com.lyrisoft.chat.server.remote.CommandProcessorRemote;
import com.lyrisoft.chat.server.remote.ConnectionHandler;
import com.lyrisoft.chat.server.remote.ServletConnectionHandler;
import java.io.IOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ChatClient
implements IConnectionListener,
ICommands {
    protected IConnectionHandler _connectionHandler;
    protected ChatServer _server;
    protected String _userId;
    private int _accessLevel = 0;
    private long _connectionTime;
    private String _host;
    private long _idle;
    private String _clientVersion;
    private HashMap _ignored;
    private long _lastServerPing;
    private long _lastServerPong;
    private long _lastServerPingDuration;
    private long _serverPingAvg;
    private long _serverPingsTotal;
    private long _serverPingCount;
    private boolean _tunneling = false;
    private String _key = "";

    void init(ChatServer server) {
        this._server = server;
        this._lastServerPong = this._connectionTime = System.currentTimeMillis();
        this._idle = this._connectionTime;
    }

    public ChatClient(ChatServer server, ServletConnectionHandler handler) {
        this.init(server);
        this._tunneling = true;
        this._connectionHandler = handler;
        handler.setListener(this);
        this._host = String.valueOf(handler.getHost()) + " (" + Translator.getMessage("tunneling") + ")";
    }

    public ChatClient(ChatServer server, Socket s) throws IOException {
        this.init(server);
        this._host = s.getInetAddress().getHostAddress();
        this._connectionHandler = this.createConnectionHandler(s);
        ((ConnectionHandler)this._connectionHandler).setDispatcher(server.getDispatcher());
        ((ConnectionHandler)this._connectionHandler).init();
    }

    public IConnectionHandler createConnectionHandler(Socket s) throws IOException {
        return new ConnectionHandler(s, this);
    }

    public boolean getTunneling() {
        return this._tunneling;
    }

    public boolean isIgnoring(String userId) {
        return this._ignored.containsKey(ChatServer.clientKey(userId));
    }

    public void ignoreList() {
        String[] ignorees = new String[this._ignored.size()];
        int j = 0;
        Iterator i = this._ignored.values().iterator();
        while (i.hasNext()) {
            ignorees[j] = (String)i.next();
            ++j;
        }
        this._connectionHandler.queueMessage(CommandMakerRemote.constructIgnoreListMessage(ignorees));
    }

    public boolean ignore(String client) {
        String key = ChatServer.clientKey(client = this._server.getClient(client).getUserId());
        if (this._ignored.containsKey(key)) {
            this.generalMessage(Translator.getMessage("already_ignoring", client));
            return false;
        }
        if (!this._server.isExistingUser(client)) {
            this.generalMessage(Translator.getMessage("cannot_ignore", client));
            return false;
        }
        this._server.getIgnoreStore().ignore(this._userId, client);
        this._ignored.put(key, client);
        return true;
    }

    public boolean unignore(String client) {
        String key = ChatServer.clientKey(client);
        if (!this._ignored.containsKey(key)) {
            this.generalMessage(Translator.getMessage("cannot_unignore", client));
            return false;
        }
        this._server.getIgnoreStore().unignore(this._userId, (String)this._ignored.get(key));
        this._ignored.remove(key);
        return true;
    }

    public long getLastServerPong() {
        return this._lastServerPong;
    }

    public long getLastServerPing() {
        return this._lastServerPing;
    }

    public synchronized void setLastServerPing(long time) {
        this._lastServerPing = time;
    }

    public synchronized void setLastServerPong(long time) {
        long now = System.currentTimeMillis();
        this._lastServerPingDuration = now - time;
        this._lastServerPong = now;
        this._serverPingsTotal += this._lastServerPingDuration;
        ++this._serverPingCount;
        this._serverPingAvg = this._serverPingsTotal / this._serverPingCount;
    }

    public long getServerPingAvg() {
        return this._serverPingAvg;
    }

    public long getServerPingCount() {
        return this._serverPingCount;
    }

    public long getIdle() {
        return System.currentTimeMillis() - this._idle;
    }

    public long getConnectionTime() {
        return this._connectionTime;
    }

    public int getAccessLevel() {
        return this._accessLevel;
    }

    public String getClientVersion() {
        return this._clientVersion;
    }

    public void setClientVersion(String version) {
        this._clientVersion = version;
    }

    public String getHost() {
        return this._host;
    }

    public void setAccessLevel(int level) {
        this._accessLevel = level;
    }

    public String getUserId() {
        return this._userId;
    }

    public void setUserId(String userId) {
        if (this._userId == null || !this._userId.equals(userId)) {
            this._userId = userId;
            this._key = userId == null ? null : userId.toLowerCase();
            List savedIgnored = this._server.getIgnoreStore().getIgnoredByUser(this._userId);
            this._ignored = new HashMap(savedIgnored.size());
            Iterator i = savedIgnored.iterator();
            while (i.hasNext()) {
                String s = (String)i.next();
                this._ignored.put(s.toLowerCase(), s);
            }
        }
    }

    public void die() {
        this._connectionHandler.shutdown(false);
    }

    public ChatServer getServer() {
        return this._server;
    }

    public void incomingMessage(String msg) {
        boolean affectIdle = CommandProcessorRemote.process(msg, this);
        if (affectIdle) {
            this._idle = System.currentTimeMillis();
        }
    }

    public void socketClosed() {
        this._server.signOff(this);
    }

    public void ackSignon(String myName) {
        if (this._connectionHandler == null) {
            System.err.println("conn handler is null");
        }
        this._connectionHandler.queueMessage(CommandMakerRemote.constructSignonAck(myName));
    }

    public void connectionLost() {
    }

    public void ackJoinRoom(String room) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructJoinRoomAck(room));
    }

    public void ackPartRoom(String room) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructPartRoomAck(room));
    }

    public void messageFromUser(String user, String room, String msg) {
        if (!this.isIgnoring(user)) {
            this._connectionHandler.queueMessage(CommandMakerRemote.constructRoomMessage(user, room, msg));
        }
    }

    public void messageFromUserPrivate(String user, String msg) {
        if (!this.isIgnoring(user)) {
            this._connectionHandler.queueMessage(CommandMakerRemote.constructPrivateMessage(user, msg));
        } else {
            ChatClient client = this._server.getClient(user);
            if (client != null) {
                client.generalError(Translator.getMessage("is_ignoring", this._userId));
            }
        }
    }

    public void emoteFromUserPrivate(String user, String msg) {
        if (!this.isIgnoring(user)) {
            this._connectionHandler.queueMessage(CommandMakerRemote.constructPrivateEmoteMessage(user, msg));
        } else {
            ChatClient client = this._server.getClient(user);
            if (client != null) {
                client.generalError(Translator.getMessage("is_ignoring", this._userId));
            }
        }
    }

    public void roomList(String[] roomList) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructRoomListMessage(roomList));
    }

    public void globalUserList(String[] users) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructGlobalUserListMessage(users));
    }

    public void roomUserList(String room, String[] users) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructRoomUserListMessage(room, users));
    }

    public void userJoinedRoom(String user, String room) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructUserJoinedRoomMessage(user, room));
    }

    public void userPartedRoom(String user, String room, boolean signOff) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructUserPartedRoomMessage(user, room, signOff));
    }

    public void generalError(String message) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructErrorMessage(message));
    }

    public void generalMessage(String message) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructGeneralMessage(message));
    }

    public void generalRoomMessage(String room, String message) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructGeneralRoomMessage(room, message));
    }

    public void ping(String user, String arg) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructPing(user, arg));
    }

    public void pong(String user, String arg) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructPong(user, arg));
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public void roomJoinError(String error, String room) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructRoomJoinError(error, room));
    }

    public void signOnError(String error, String user) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructSignOnError(error, user));
    }

    public void error(String type, String arg) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructError(type, arg));
    }

    public void killed(String killer, String msg) {
        this._connectionHandler.sendImmediately(CommandMakerRemote.constructKilled(killer, msg));
    }

    public void ackKill(String victim) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructAckKill(victim));
    }

    public void emote(String user, String room, String message) {
        if (!this.isIgnoring(user)) {
            this._connectionHandler.queueMessage(CommandMakerRemote.constructEmote(user, room, message));
        }
    }

    public void sendRaw(String s) {
        this._connectionHandler.queueMessage(s);
    }

    public void userSignOn(String userId) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructUserSignOn(userId));
    }

    public void userSignOff(String userId) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructUserSignOff(userId));
    }

    public void roomCreated(String room) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructRoomCreated(room));
    }

    public void roomDestroyed(String room) {
        this._connectionHandler.queueMessage(CommandMakerRemote.constructRoomDestroyed(room));
    }

    public void setAttribute(String name, Object value) {
    }

    public Object getAttribute(String name) {
        return null;
    }

    public String getKey() {
        return this._key;
    }
}

