/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote;

import com.lyrisoft.chat.ICommands;
import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.server.remote.AccessDenied;
import com.lyrisoft.chat.server.remote.AccessException;
import com.lyrisoft.chat.server.remote.ChatClient;
import com.lyrisoft.chat.server.remote.CommandMakerRemote;
import com.lyrisoft.chat.server.remote.CommandProcessorRemote;
import com.lyrisoft.chat.server.remote.Dispatcher;
import com.lyrisoft.chat.server.remote.DistributedState;
import com.lyrisoft.chat.server.remote.Distributor;
import com.lyrisoft.chat.server.remote.IServerCommands;
import com.lyrisoft.chat.server.remote.RoomJoinException;
import com.lyrisoft.chat.server.remote.RoomServer;
import com.lyrisoft.chat.server.remote.TimedUserList;
import com.lyrisoft.chat.server.remote.Vulture;
import com.lyrisoft.chat.server.remote.persistence.auth.Auth;
import com.lyrisoft.chat.server.remote.persistence.auth.IAuthenticator;
import com.lyrisoft.chat.server.remote.persistence.auth.room.IRoomAuthenticator;
import com.lyrisoft.chat.server.remote.persistence.ignore.IIgnoreStorage;
import com.lyrisoft.util.io.Logger;
import com.lyrisoft.util.io.ResourceException;
import com.lyrisoft.util.io.ResourceLoader;
import com.lyrisoft.util.properties.PropertyException;
import com.lyrisoft.util.properties.PropertyTool;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.TextMessage;
import javax.servlet.ServletContext;

public class ChatServer
implements ICommands,
IServerCommands {
    public static final boolean DEBUG = ChatServer.getDebug();
    protected static Logger logger;
    protected static Logger errorLogger;
    protected int _port;
    protected ServerSocket _serverSocket;
    protected boolean _keepGoing = true;
    protected long _creationTime;
    protected IAuthenticator _authenticator;
    protected IRoomAuthenticator _roomAuthenticator;
    protected IIgnoreStorage _ignoreStore;
    protected HashMap _users;
    protected HashMap _rooms;
    protected String _motd;
    protected Vulture _vulture;
    protected Thread _vultureThread;
    protected Dispatcher _dispatcher;
    protected Thread _dispatchThread;
    protected Distributor _distributor;
    protected Thread _distributorThread;
    protected DistributedState _distributedState = new DistributedState(this);
    protected int _cumulativeLogins = 0;
    protected int _kickBanSeconds;
    protected int _killBanMinutes;
    protected TimedUserList _killedUsers;
    protected ServletContext _servletContext;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ChatServer(String conf, ServletContext context) throws Exception {
        this._servletContext = context;
        this._dispatcher = this.createDispatcher();
        this._dispatchThread = new Thread((Runnable)this._dispatcher, "Dispatcher");
        this._dispatchThread.start();
        Properties p = PropertyTool.loadProperties(conf);
        this.preProcessProperties(p);
        String logFile = null;
        String errorLogFile = null;
        logFile = p.getProperty("log.file");
        errorLogFile = p.getProperty("error.log.file");
        this.createLoggers(logFile, errorLogFile);
        String authClassName = PropertyTool.getString("auth.class", p);
        String roomAuthClassName = PropertyTool.getString("roomAuth.class", p);
        String ignoreClassName = PropertyTool.getString("ignoreStore.class", p);
        String commands = PropertyTool.getString("commands", p);
        Properties commandProps = PropertyTool.loadProperties(commands);
        this.initCommandProcessor(commandProps);
        String messages = PropertyTool.getString("messages", p);
        Properties messagesProps = PropertyTool.loadProperties(messages);
        this.initTranslator(messagesProps);
        this._port = PropertyTool.getInteger("listen.port", p);
        boolean allowGuests = PropertyTool.getBoolean("auth.allowGuests", p);
        boolean storeGuests = PropertyTool.getBoolean("auth.storeGuests", p);
        Class<?> authClass = Class.forName(authClassName);
        Class[] classArray = new Class[3];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.lyrisoft.chat.server.remote.ChatServer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        classArray[1] = Boolean.TYPE;
        classArray[2] = Boolean.TYPE;
        Class[] args = classArray;
        Constructor<?> c = authClass.getConstructor(args);
        this._authenticator = (IAuthenticator)c.newInstance(this, new Boolean(allowGuests), new Boolean(storeGuests));
        this._roomAuthenticator = (IRoomAuthenticator)Class.forName(roomAuthClassName).newInstance();
        this._ignoreStore = (IIgnoreStorage)Class.forName(ignoreClassName).newInstance();
        String sIdle = p.getProperty("idle.timeout");
        double idleTimeout = Double.valueOf(sIdle);
        this._vulture = new Vulture(this, idleTimeout);
        String sKBS = p.getProperty("kick.banseconds");
        this._kickBanSeconds = Integer.valueOf(sKBS);
        String sKBM = p.getProperty("kill.banminutes");
        this._killBanMinutes = Integer.valueOf(sKBM);
        this._killedUsers = new TimedUserList(this._killBanMinutes * 60);
        this.readMotd();
        this._creationTime = System.currentTimeMillis();
        this._users = new HashMap();
        this._rooms = new HashMap();
        if (System.getProperty("BSD_HACK") != null) {
            ChatServer.log("FreeBSD Workaround is enabled.");
        }
        boolean useJms = false;
        try {
            useJms = PropertyTool.getBoolean("jms.enabled", p);
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        if (useJms) {
            this._distributor = new Distributor(this, p);
            this._distributorThread = new Thread((Runnable)this._distributor, "Distributor");
            this._distributorThread.start();
        } else {
            ChatServer.log("Not distributing messages over JMS");
        }
        this._serverSocket = new ServerSocket(this._port);
        this._vultureThread = new Thread((Runnable)this._vulture, "Vulture");
        this._vultureThread.start();
    }

    public ChatServer(ServletContext context) throws Exception {
        this("conf/nfc.conf", context);
    }

    public ChatServer(String conf) throws Exception {
        this(conf, null);
    }

    public ChatServer() throws Exception {
        this((ServletContext)null);
    }

    public int getKickBanSeconds() {
        return this._kickBanSeconds;
    }

    public int getRoomAccessLevel(ChatClient client, RoomServer rs) {
        return this._roomAuthenticator.getAccessLevel(client, rs);
    }

    public ChatClient getRoomNextOp(RoomServer rs) {
        return this._roomAuthenticator.getNextOp(rs);
    }

    public boolean isExistingUser(String user) {
        return this._authenticator.isExistingUser(user);
    }

    public int getPort() {
        return this._port;
    }

    void setServletContext(ServletContext context) {
        this._servletContext = context;
    }

    public void preProcessProperties(Properties p) throws PropertyException {
    }

    public int getCumulativeLogins() {
        return this._cumulativeLogins;
    }

    protected Dispatcher createDispatcher() {
        return new Dispatcher();
    }

    public Dispatcher getDispatcher() {
        return this._dispatcher;
    }

    public void initTranslator(Properties p) {
        Translator.init(p);
    }

    public void initCommandProcessor(Properties p) {
        CommandProcessorRemote.init(p);
    }

    void distributorDisconnected(Distributor d) {
    }

    void distributorConnected(Distributor d) {
        this.announcePresence();
    }

    protected void readMotd() throws ResourceException, IOException {
        block4: {
            BufferedReader reader = null;
            StringBuffer sb = new StringBuffer();
            try {
                String next;
                reader = new BufferedReader(new InputStreamReader(ResourceLoader.getResource("conf/nfc.motd")));
                while ((next = reader.readLine()) != null) {
                    sb.append(next);
                    sb.append("\n");
                }
                this._motd = sb.toString();
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (reader != null) {
                    reader.close();
                }
                throw throwable;
            }
            Object var4_6 = null;
            if (reader == null) break block4;
            reader.close();
        }
    }

    public static void log(String message) {
        logger.log(message);
    }

    public static void logError(String message) {
        errorLogger.log(message);
    }

    public static void log(Exception e) {
        errorLogger.log(e);
    }

    public RoomServer getRoom(String roomName) {
        return (RoomServer)this._rooms.get(ChatServer.roomKey(roomName));
    }

    public ChatClient getClient(String clientName) {
        return (ChatClient)this._users.get(ChatServer.clientKey(clientName));
    }

    protected void validateUserId(String user) throws AccessException {
        if (this.getName().toLowerCase().equals(user.toLowerCase())) {
            throw new AccessException(Translator.getMessage("reserved_name", this.getName()));
        }
        if ("server".equalsIgnoreCase(user)) {
            throw new AccessException(Translator.getMessage("reserved_name", "server"));
        }
        char[] chars = user.toLowerCase().toCharArray();
        int i = 0;
        while (i < chars.length) {
            char ch = chars[i];
            if (!Character.isLetterOrDigit(chars[i]) && ch != '_' && ch != '-' && ch != '\\' && ch != '^' && ch != '`' && ch != '|' && ch != '[' && ch != '{' && ch != ']' && ch != '}' && ch != '(' && ch != ')' && ch != '\'') {
                throw new AccessException("/badchars");
            }
            ++i;
        }
    }

    public Map getLocalUsers() {
        return this._users;
    }

    public void serverSignOn(String server) {
        this._distributedState.addServer(server);
    }

    public void serverSignOff(String server) {
        this._distributedState.deleteServer(server);
    }

    public void setRemoteUserList(String server, String[] users) {
        Collection oldUsers = this._distributedState.getUsersOnServer(server);
        HashMap<String, String> newMap = new HashMap<String, String>();
        Iterator i = oldUsers.iterator();
        while (i.hasNext()) {
            String s = (String)i.next();
            newMap.put(ChatServer.clientKey(s), s);
        }
        int i2 = 0;
        while (i2 < users.length) {
            String key = ChatServer.clientKey(users[i2]);
            if (newMap.get(key) == null) {
                this.remoteSignOn(server, users[i2]);
            } else {
                newMap.remove(key);
            }
            ++i2;
        }
        i = oldUsers.iterator();
        while (i.hasNext()) {
            this.remoteSignOff(server, (String)i.next());
        }
    }

    public void remoteSignOn(String server, String userId) {
        this._distributedState.signon(server, userId);
    }

    public void remoteSignOff(String server, String userId) {
        HashMap hashMap = this._rooms;
        synchronized (hashMap) {
            Iterator i = this._rooms.values().iterator();
            while (i.hasNext()) {
                RoomServer room = (RoomServer)i.next();
                if (!this._distributedState.userExistsInRoom(userId, room.getName())) continue;
                this.remotePartRoom(server, userId, room.getName(), true);
            }
        }
        Collection deadRooms = this._distributedState.signoff(server, userId);
    }

    public void signOn(ChatClient client, String password) throws AccessException, AccessDenied {
        ChatServer.log(String.valueOf(client.getUserId()) + " is attempting a signon");
        String userId = client.getUserId();
        this.validateUserId(userId);
        Auth auth = this._authenticator.authenticate(userId, password);
        int access = auth.getAccess();
        if (access == 0 || this._killedUsers.contains(userId)) {
            throw new AccessException("/denied");
        }
        ChatServer.log(String.valueOf(client.getUserId()) + " is authenticated.  Access = " + access + (client.getTunneling() ? " (tunneling)" : ""));
        client.setUserId(auth.getUserId());
        HashMap hashMap = this._users;
        synchronized (hashMap) {
            ChatClient oldC = (ChatClient)this._users.get(ChatServer.clientKey(client));
            if (oldC != null) {
                oldC.killed(client.getUserId(), "Terminated by signing on elsewhere");
                this.signOff(oldC);
            }
            if (this._distributedState.userExists(ChatServer.clientKey(client))) {
                throw new AccessException("/alreadyon");
            }
            client.setAccessLevel(access);
            this._users.put(ChatServer.clientKey(client), client);
            ++this._cumulativeLogins;
        }
        client.ackSignon(auth.getUserId());
        this.sendMotd(client);
        this._distributedState.signon(this.getName(), userId);
    }

    void broadcastSignOnToUsers(String userId) {
        HashMap hashMap = this._users;
        synchronized (hashMap) {
            Iterator i = this._users.values().iterator();
            while (i.hasNext()) {
                ChatClient cc = (ChatClient)i.next();
                if (cc.getUserId().equals(cc)) continue;
                cc.userSignOn(userId);
            }
        }
    }

    void broadcastSignOffToUsers(String userId) {
        HashMap hashMap = this._users;
        synchronized (hashMap) {
            Iterator i = this._users.values().iterator();
            while (i.hasNext()) {
                ChatClient cc = (ChatClient)i.next();
                cc.userSignOff(userId);
            }
        }
    }

    public void broadcast(String s) {
        HashMap hashMap = this._users;
        synchronized (hashMap) {
            Iterator i = this._users.values().iterator();
            while (i.hasNext()) {
                ChatClient client = (ChatClient)i.next();
                client.sendRaw(s);
            }
        }
    }

    protected void sendMotd(ChatClient client) {
        StringTokenizer st = new StringTokenizer(this._motd, "\r\n");
        while (st.hasMoreTokens()) {
            client.generalMessage(st.nextToken());
        }
    }

    public void ignoreList(ChatClient client) {
        client.ignoreList();
    }

    public void kill(String victim, ChatClient killer, String message) {
        ChatClient c = this.getClient(victim);
        if (c == null) {
            killer.error("/nosuchuser", victim);
        } else if (killer.getAccessLevel() < 100) {
            killer.error("/denied", "/kill " + victim);
        } else {
            this._killedUsers.add(c.getUserId());
            c.killed(killer.getUserId(), message);
            this.signOff(c);
            killer.ackKill(victim);
        }
    }

    public void signOff(ChatClient client) {
        if (client.getAccessLevel() == 0) {
            ChatServer.log("signoff: anonymous user");
            client.die();
            this._vulture.removeClient(client);
            return;
        }
        ChatServer.log("signoff: " + client.getUserId());
        Object o = null;
        HashMap hashMap = this._users;
        synchronized (hashMap) {
            o = this._users.remove(ChatServer.clientKey(client));
            Collection deadRooms = this._distributedState.signoff(this.getName(), client.getUserId());
        }
        this._vulture.removeClient(client);
        if (o != null) {
            hashMap = this._rooms;
            synchronized (hashMap) {
                Iterator i = this._rooms.values().iterator();
                while (i.hasNext()) {
                    RoomServer room = (RoomServer)i.next();
                    room.part(client, true);
                    if (!room.isEmpty()) continue;
                    ChatServer.log("Removing empty room: " + room.getName());
                    i.remove();
                }
            }
        }
        client.die();
        this.distribute(client, "/quit");
    }

    public void partRoom(ChatClient client, String roomName) {
        String key = ChatServer.roomKey(roomName);
        boolean empty = false;
        HashMap hashMap = this._rooms;
        synchronized (hashMap) {
            RoomServer room = (RoomServer)this._rooms.get(key);
            if (room != null) {
                room.part(client, false);
                if (room.isEmpty()) {
                    empty = true;
                    ChatServer.log("Removing empty room: " + roomName);
                    this._rooms.remove(ChatServer.roomKey(room));
                    room = null;
                }
            }
        }
        this._distributedState.part(this.getName(), roomName, client.getUserId());
    }

    public void notifyClientsRoomDestroyed(String roomName) {
        HashMap hashMap = this._users;
        synchronized (hashMap) {
            Iterator i = this._users.values().iterator();
            while (i.hasNext()) {
                ChatClient cc = (ChatClient)i.next();
                cc.roomDestroyed(roomName);
            }
        }
    }

    public void remoteJoinRoom(String server, String username, String roomname, String password) {
        boolean created = this._distributedState.join(server, roomname, username);
        RoomServer room = (RoomServer)this._rooms.get(ChatServer.roomKey(roomname));
        if (room != null) {
            room.remoteJoin(username, password);
        }
    }

    public void remotePartRoom(String server, String username, String roomname, boolean isSignoff) {
        boolean destroyed = this._distributedState.part(server, roomname, username);
        RoomServer room = (RoomServer)this._rooms.get(ChatServer.roomKey(roomname));
        if (room != null) {
            room.remotePart(username, isSignoff);
        }
    }

    public void joinRoom(ChatClient client, String roomName, String password) throws RoomJoinException {
        String key = ChatServer.roomKey(roomName);
        RoomServer room = (RoomServer)this._rooms.get(key);
        HashMap hashMap = this._rooms;
        synchronized (hashMap) {
            if (room == null) {
                if (!this._roomAuthenticator.isCreateAllowed(client, roomName, password)) {
                    throw new RoomJoinException("/roomaccessdenied");
                }
                room = (RoomServer)this._rooms.get(ChatServer.roomKey(roomName));
                if (room == null) {
                    ChatServer.log(String.valueOf(client.getUserId()) + " created new room: " + roomName);
                    room = this.createRoomServer(roomName, password);
                    this._rooms.put(ChatServer.roomKey(room), room);
                }
            }
        }
        room.join(client, password);
        this._distributedState.join(this.getName(), room.getName(), client.getUserId());
    }

    public void notifyClientsRoomCreated(String roomName) {
        HashMap hashMap = this._users;
        synchronized (hashMap) {
            Iterator i = this._users.values().iterator();
            while (i.hasNext()) {
                ChatClient cc = (ChatClient)i.next();
                cc.roomCreated(roomName);
            }
        }
    }

    public RoomServer createRoomServer(String roomName, String password) {
        return new RoomServer(roomName, password, this);
    }

    public static String roomKey(String room) {
        return room.toLowerCase();
    }

    public static String roomKey(RoomServer room) {
        return ChatServer.roomKey(room.getName());
    }

    public static String clientKey(ChatClient client) {
        return client.getKey();
    }

    public static String clientKey(String client) {
        return client.toLowerCase();
    }

    protected void acceptConnections() {
        ChatServer.log("Accepting socket connections on port " + this._port);
        while (this._keepGoing) {
            try {
                Socket s = this._serverSocket.accept();
                s.setTcpNoDelay(true);
                ChatServer.log("Got a connection from " + s.getInetAddress().getHostAddress());
                ChatClient client = this.createChatClient(s);
                this._vulture.addClient(client);
            }
            catch (IOException e) {
                ChatServer.log(e);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected ChatClient createChatClient(Socket s) throws IOException {
        return new ChatClient(this, s);
    }

    public void pleaseStop() {
        this._keepGoing = false;
    }

    public String[] getRoomNames() {
        Collection c = this._distributedState.getAllRooms();
        String[] rooms = new String[c.size()];
        c.toArray(rooms);
        return rooms;
    }

    public String[] getLocalRoomNames() {
        ArrayList<String> al = new ArrayList<String>();
        HashMap hashMap = this._rooms;
        synchronized (hashMap) {
            Iterator i = this._rooms.values().iterator();
            while (i.hasNext()) {
                RoomServer room = (RoomServer)i.next();
                al.add(room.getName());
            }
        }
        String[] rooms = new String[al.size()];
        al.toArray(rooms);
        return rooms;
    }

    public String[] getServerNames() {
        Collection c = this._distributedState.getAllServers();
        String[] servers = new String[c.size()];
        c.toArray(servers);
        return servers;
    }

    public String[] getUserNames() {
        Collection c = this._distributedState.getAllUsers();
        String[] users = new String[c.size()];
        c.toArray(users);
        return users;
    }

    public String[] getLocalUserNames() {
        ArrayList<String> al = new ArrayList<String>();
        HashMap hashMap = this._users;
        synchronized (hashMap) {
            Iterator i = this._users.values().iterator();
            while (i.hasNext()) {
                ChatClient client = (ChatClient)i.next();
                al.add(client.getUserId());
            }
        }
        String[] users = new String[al.size()];
        al.toArray(users);
        return users;
    }

    public int getRoomCount() {
        return this._rooms.size();
    }

    public int getUserCount() {
        return this._users.size();
    }

    public long getUptime() {
        return System.currentTimeMillis() - this._creationTime;
    }

    public static void main(String[] args) {
        try {
            ChatServer server = null;
            if (args.length > 1 && "-f".equals(args[0])) {
                server = new ChatServer(args[1]);
            }
            if (server == null) {
                server = new ChatServer();
            }
            server.acceptConnections();
        }
        catch (Exception e) {
            System.err.println("Error creating server");
            e.printStackTrace();
        }
    }

    protected Logger createServletContextLogger(String logFile) {
        try {
            return new Logger(ResourceLoader.touch(logFile), true);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void createLoggers(String logFile, String errorLogFile) {
        if (logFile == null) {
            logger = new Logger(System.out);
        } else if (this._servletContext == null) {
            try {
                logger = new Logger(logFile, true);
            }
            catch (IOException e) {
                logger = new Logger(System.out);
            }
        } else {
            logger = this.createServletContextLogger(logFile);
            if (logger == null) {
                logger = new Logger(System.out);
            }
        }
        if (errorLogFile == null) {
            errorLogger = new Logger(System.err);
        } else if (this._servletContext == null) {
            try {
                errorLogger = new Logger(errorLogFile, true);
            }
            catch (IOException e) {
                errorLogger = new Logger(System.err);
            }
        } else {
            errorLogger = this.createServletContextLogger(errorLogFile);
            if (errorLogger == null) {
                errorLogger = new Logger(System.err);
            }
        }
    }

    protected static void showUsageAndExit() {
        System.err.println("usage: java com.lyrisoft.chat.server.remote.ChatServer port");
        System.exit(1);
    }

    public void distribute(ChatClient client, String text) {
        if (this._distributor == null || !this._distributor.isConnected()) {
            return;
        }
        try {
            TextMessage message = this._distributor.createTextMessage();
            message.setStringProperty("origin", this.getName());
            if (client != null) {
                message.setStringProperty("client", client.getUserId());
            }
            message.setText(text);
            this._distributor.push((Message)message);
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }

    public void handleIncoming(Message message) {
        try {
            String origin = message.getStringProperty("origin");
            if (this.getName().equals(origin)) {
                return;
            }
            String client = message.getStringProperty("client");
            String text = ((TextMessage)message).getText();
            CommandProcessorRemote.processDistributed(text, origin, client, this);
        }
        catch (JMSException e) {
            ChatServer.log((Exception)((Object)e));
        }
    }

    public String getName() {
        try {
            return String.valueOf(InetAddress.getLocalHost().getHostName()) + ":" + this._port;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public void announcePresence() {
        this.distribute(null, "/hello");
        this.distributeUserList();
        this.distributeRoomList();
    }

    public void distributeRoomList() {
        String[] roomNames = this.getLocalRoomNames();
        if (roomNames.length == 0) {
            return;
        }
        StringBuffer sb = new StringBuffer("/rooms");
        sb.append("\t");
        int i = 0;
        while (i < roomNames.length) {
            String roomName = roomNames[i];
            sb.append(roomNames[i]);
            sb.append("\t");
            ++i;
        }
        this.distribute(null, sb.toString());
        i = 0;
        while (i < roomNames.length) {
            this.distributeRoomState(roomNames[i]);
            ++i;
        }
    }

    public void distributeRoomState(String roomName) {
        RoomServer room = this.getRoom(roomName);
        if (room == null) {
            return;
        }
        String[] users = room.getUsers();
        String msg = CommandMakerRemote.constructRoomUserListMessage(roomName, users);
        this.distribute(null, msg);
    }

    public void distributeUserList() {
        String[] userNames = this.getLocalUserNames();
        StringBuffer sb = new StringBuffer("/users");
        sb.append("\t");
        int i = 0;
        while (i < userNames.length) {
            sb.append(userNames[i]);
            sb.append("\t");
            ++i;
        }
        this.distribute(null, sb.toString());
    }

    public int getUserCountInRoom(String roomName) {
        return this._distributedState.countUsersInRoom(roomName);
    }

    public int getUserCountOnServer(String server) {
        return this._distributedState.countUsersOnServer(server);
    }

    public String[] getUsersInRoom(String roomName) {
        Collection c = this._distributedState.getUsersInRoom(roomName);
        String[] names = new String[c.size()];
        c.toArray(names);
        return names;
    }

    public boolean userExists(String username) {
        return this._distributedState.userExists(username);
    }

    public boolean serverExists(String servername) {
        return this._distributedState.serverExists(servername);
    }

    public boolean roomExists(String roomname) {
        return this._distributedState.roomExists(roomname);
    }

    public void checkServerPings(long timeout) {
        this._distributedState.checkServerPings(timeout);
    }

    public void sendBroadcastPing() {
        this.distribute(null, "/bping");
    }

    public void sendServerPing(String server) {
        StringBuffer sb = new StringBuffer();
        sb.append("/ping");
        sb.append("\t");
        sb.append(server);
        sb.append("\t");
        sb.append(System.currentTimeMillis());
        this.distribute(null, sb.toString());
    }

    public void sendServerPong(String server, String arg) {
        StringBuffer sb = new StringBuffer();
        sb.append("/pong");
        sb.append("\t");
        sb.append(server);
        sb.append("\t");
        sb.append(arg);
        this.distribute(null, sb.toString());
    }

    public void handlePong(String server, String arg) {
        try {
            long now = System.currentTimeMillis();
            long delta = now - Long.valueOf(arg);
            ChatServer.log("Ping reply from " + server + ": " + delta + " ms.");
        }
        catch (NumberFormatException e) {
            ChatServer.log(e);
        }
    }

    public void handleBroadcastPing(String server) {
        this._distributedState.setLastBroadcastPing(server, System.currentTimeMillis());
    }

    public IIgnoreStorage getIgnoreStore() {
        return this._ignoreStore;
    }

    public static void DEBUG(String s) {
        if (DEBUG) {
            System.err.println(s);
        }
    }

    public static boolean getDebug() {
        String debug = System.getProperty("DEBUG");
        if (debug == null) {
            return false;
        }
        return new Boolean(debug);
    }
}

