/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote;

import com.lyrisoft.chat.ICommands;
import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.server.remote.ChatClient;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.command.ICommandProcessorRemote;
import com.lyrisoft.chat.server.remote.command.UnknownCommand;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;

public class CommandProcessorRemote
implements ICommands {
    private static HashMap _processors;
    private static HashSet _idleTimeImmune;
    private static UnknownCommand unknownCommandProcessor;

    static {
        unknownCommandProcessor = new UnknownCommand();
    }

    public static void init(Properties p) {
        if (_processors != null && _idleTimeImmune != null) {
            ChatServer.log("CommandProcessorRemote: Warning: init() called a second time");
        }
        _processors = new HashMap();
        _idleTimeImmune = new HashSet();
        Enumeration<?> e = p.propertyNames();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            int idx = name.indexOf(".");
            if (idx < 1) {
                ChatServer.logError("CommandProcessorRemote: unknown property: " + name);
                continue;
            }
            String command = name.substring(0, idx);
            if (name.endsWith(".class")) {
                String className = p.getProperty(name);
                ChatServer.log("CommandProcessorRemote: initting the " + command + " command processor");
                try {
                    ICommandProcessorRemote cp = (ICommandProcessorRemote)Class.forName(className).newInstance();
                    String help = p.getProperty(String.valueOf(command) + ".help");
                    cp.setHelp(help);
                    String usage = p.getProperty(String.valueOf(command) + ".usage");
                    cp.setUsage(usage);
                    int access = 0;
                    try {
                        String s = p.getProperty(String.valueOf(command) + ".access");
                        access = Integer.parseInt(s);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    cp.setAccessRequired(access);
                    CommandProcessorRemote.extendCommandSet("/" + command, cp);
                }
                catch (Exception ex) {
                    ChatServer.logError("Unable to install the " + command + " command");
                    ChatServer.log(ex);
                    ChatServer.logError("Continuing despite error(s)");
                }
                continue;
            }
            if (!name.endsWith(".idleImmune")) continue;
            _idleTimeImmune.add("/" + command);
        }
    }

    public static void extendCommandSet(String command, ICommandProcessorRemote processor) {
        _processors.put(command, processor);
    }

    public static void setIdleTimeImmune(String command) {
        _idleTimeImmune.add(command);
    }

    public static boolean process(String input, ChatClient client) {
        String[] args = CommandProcessorRemote.decompose(input);
        if (args.length == 0) {
            return true;
        }
        ICommandProcessorRemote processor = (ICommandProcessorRemote)_processors.get(args[0]);
        if (processor == null) {
            unknownCommandProcessor.process(client, args);
            return true;
        }
        if (client.getAccessLevel() < processor.accessRequired()) {
            client.generalError(Translator.getMessage("access_denied"));
            return true;
        }
        boolean distribute = processor.process(client, args);
        if (distribute) {
            client.getServer().distribute(client, input);
        }
        return !_idleTimeImmune.contains(args[0]);
    }

    public static void processDistributed(String input, String origin, String client, ChatServer server) {
        String[] args = CommandProcessorRemote.decompose(input);
        if (args.length == 0) {
            return;
        }
        ICommandProcessorRemote processor = (ICommandProcessorRemote)_processors.get(args[0]);
        if (processor == null) {
            return;
        }
        processor.processDistributed(client, origin, args, server);
    }

    public static String[] decompose(String input) {
        StringTokenizer st = new StringTokenizer(input, "\t");
        ArrayList<String> list = new ArrayList<String>(5);
        while (st.hasMoreTokens()) {
            list.add(st.nextToken());
        }
        String[] args = new String[list.size()];
        return list.toArray(args);
    }

    public static Map getCommandProcessors() {
        return _processors;
    }
}

