/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote;

import com.lyrisoft.chat.IConnectionHandler;
import com.lyrisoft.chat.IConnectionListener;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.Dispatcher;
import com.lyrisoft.chat.server.remote.Message;
import com.lyrisoft.chat.server.remote.ReaderThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.Socket;

public class ConnectionHandler
implements IConnectionHandler {
    protected PrintWriter _out;
    protected Socket _socket;
    protected ReaderThread _reader;
    protected InputStream _inputStream;
    protected IConnectionListener _connectionListener;
    protected boolean _isShutDown = false;
    protected Dispatcher _dispatcher;
    protected static final boolean DEBUG = ChatServer.getDebug();

    public void setListener(IConnectionListener listener) {
        this._connectionListener = listener;
    }

    public ConnectionHandler(Socket s, IConnectionListener listener) throws IOException {
        this._connectionListener = listener;
        this._socket = s;
        this._out = new PrintWriter(new OutputStreamWriter(s.getOutputStream()));
        this._inputStream = s.getInputStream();
    }

    void init() {
        this._reader = this.createReader();
        this._reader.start();
    }

    public ReaderThread createReader() {
        return new ReaderThread(this, this._connectionListener, this._inputStream);
    }

    public void setDispatcher(Dispatcher d) {
        this._dispatcher = d;
    }

    public void queueMessage(String message) {
        this._dispatcher.queue(new Message(this, message));
    }

    public void sendImmediately(String message) {
        ChatServer.DEBUG("< " + message);
        this._out.println(message);
        this._out.flush();
    }

    public synchronized void shutdown(boolean notify) {
        if (!this._isShutDown) {
            this._isShutDown = true;
            this._reader.pleaseStop();
            this._reader.interrupt();
            try {
                this._socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (notify) {
                ChatServer.DEBUG("Notifying socketClosed: " + this._connectionListener);
                this._connectionListener.socketClosed();
            }
        }
    }
}

