/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote;

import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.RoomTable;
import com.lyrisoft.chat.server.remote.ServerTable;
import java.io.PrintStream;
import java.util.Collection;
import java.util.Iterator;

public class DistributedState {
    private RoomTable _roomTable;
    private ServerTable _serverTable;
    private ChatServer _server;

    public DistributedState(ChatServer server) {
        this._server = server;
        this._serverTable = new ServerTable(server);
        this._roomTable = new RoomTable(server);
    }

    public Collection getUsersOnServer(String server) {
        ServerTable serverTable = this._serverTable;
        synchronized (serverTable) {
            return this._serverTable.getUsers(server);
        }
    }

    public Collection getAllUsers() {
        ServerTable serverTable = this._serverTable;
        synchronized (serverTable) {
            return this._serverTable.getAllUsers();
        }
    }

    public Collection getAllRooms() {
        RoomTable roomTable = this._roomTable;
        synchronized (roomTable) {
            return this._roomTable.getRoomNames();
        }
    }

    public Collection getUsersInRoom(String roomname) {
        RoomTable roomTable = this._roomTable;
        synchronized (roomTable) {
            return this._roomTable.getUsers(roomname);
        }
    }

    public Collection getAllServers() {
        ServerTable serverTable = this._serverTable;
        synchronized (serverTable) {
            return this._serverTable.getServerNames();
        }
    }

    public void signon(String server, String user) {
        ServerTable serverTable = this._serverTable;
        synchronized (serverTable) {
            this._serverTable.signon(server, user);
        }
    }

    public Collection signoff(String server, String user) {
        ServerTable serverTable = this._serverTable;
        synchronized (serverTable) {
            this._serverTable.signoff(server, user);
            RoomTable roomTable = this._roomTable;
            synchronized (roomTable) {
                return this._roomTable.signoff(user);
            }
        }
    }

    public boolean userExists(String username) {
        ServerTable serverTable = this._serverTable;
        synchronized (serverTable) {
            return this._serverTable.userExists(username);
        }
    }

    public boolean userExistsInRoom(String username, String roomname) {
        RoomTable roomTable = this._roomTable;
        synchronized (roomTable) {
            return this._roomTable.userExistsInRoom(username, roomname);
        }
    }

    public boolean serverExists(String servername) {
        ServerTable serverTable = this._serverTable;
        synchronized (serverTable) {
            return this._serverTable.serverExists(servername);
        }
    }

    public boolean roomExists(String roomname) {
        RoomTable roomTable = this._roomTable;
        synchronized (roomTable) {
            return this._roomTable.roomExists(roomname);
        }
    }

    public void checkServerPings(long timeout) {
        ServerTable serverTable = this._serverTable;
        synchronized (serverTable) {
            this._serverTable.checkServerPings(timeout);
        }
    }

    public boolean join(String server, String room, String user) {
        RoomTable roomTable = this._roomTable;
        synchronized (roomTable) {
            return this._roomTable.join(room, user);
        }
    }

    public boolean part(String server, String room, String user) {
        RoomTable roomTable = this._roomTable;
        synchronized (roomTable) {
            return this._roomTable.part(room, user);
        }
    }

    public void addServer(String server) {
        ServerTable serverTable = this._serverTable;
        synchronized (serverTable) {
            this._serverTable.add(server);
        }
    }

    public void deleteServer(String server) {
        ServerTable serverTable = this._serverTable;
        synchronized (serverTable) {
            Collection deadUsers = this._serverTable.getUsers(server);
            Iterator i = deadUsers.iterator();
            while (i.hasNext()) {
                String user = (String)i.next();
                this._server.remoteSignOff(server, user);
            }
            this._serverTable.delete(server);
        }
    }

    public int countUsersOnServer(String server) {
        ServerTable serverTable = this._serverTable;
        synchronized (serverTable) {
            return this._serverTable.countUsers(server);
        }
    }

    public int countUsersInRoom(String room) {
        RoomTable roomTable = this._roomTable;
        synchronized (roomTable) {
            return this._roomTable.countUsers(room);
        }
    }

    public void setLastBroadcastPing(String server, long time) {
        ServerTable serverTable = this._serverTable;
        synchronized (serverTable) {
            this._serverTable.setLastBroadcastPing(server, time);
        }
    }

    public void dumpServerTable(PrintStream out) {
        this._serverTable.dump(out);
    }

    public void dumpRoomTable(PrintStream out) {
        this._roomTable.dump(out);
    }
}

