/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote;

import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.util.properties.PropertyException;
import com.lyrisoft.util.properties.PropertyTool;
import java.util.Collections;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Distributor
implements MessageListener,
Runnable {
    protected ChatServer _server;
    protected List _queue = Collections.synchronizedList(new LinkedList());
    protected Hashtable _env;
    protected String[] _providerUrls;
    protected int _providerUrl = 0;
    protected Context _jndiContext;
    protected String _jmsUser;
    protected String _jmsPass;
    protected String _topicName;
    protected TopicPublisher _topicPublisher;
    protected TopicSession _topicSession;
    protected boolean _keepGoing = true;
    protected boolean _connected = false;
    private int _failedAttempts = 0;

    public Distributor(ChatServer server, Properties p) throws PropertyException {
        this._server = server;
        this._topicName = PropertyTool.getString("jms.topic", p);
        String jndiInitialContextFactory = PropertyTool.getString("jndi.initial", p);
        this._providerUrls = PropertyTool.getStringArray("jms.provider", p);
        this._jmsUser = p.getProperty("jms.user");
        this._jmsPass = p.getProperty("jms.pass");
        this._env = new Hashtable();
        this._env.put("java.naming.factory.initial", jndiInitialContextFactory);
    }

    synchronized void createNewJndiContext() throws NamingException {
        if (this._jndiContext != null) {
            this._jndiContext.close();
        }
        this._env.put("java.naming.provider.url", this.getProvider());
        this._jndiContext = new InitialContext(this._env);
    }

    synchronized void rotateProviders() {
        ++this._providerUrl;
        if (this._providerUrl >= this._providerUrls.length) {
            this._providerUrl = 0;
        }
    }

    synchronized String getProvider() {
        return this._providerUrls[this._providerUrl];
    }

    public Object jndiLookup(String name) throws NamingException {
        if (this._jndiContext == null) {
            this.createNewJndiContext();
        }
        if (this._failedAttempts == 0) {
            ChatServer.log("doing JNDI lookup of '" + name + "'");
        }
        Object obj = this._jndiContext.lookup(name);
        return obj;
    }

    synchronized boolean isConnected() {
        return this._connected;
    }

    synchronized void connect() throws JMSException, NamingException {
        if (this._failedAttempts == 0) {
            ChatServer.log("Attempting to connect to JMS provider " + this._providerUrls[this._providerUrl]);
        }
        TopicConnectionFactory topicConnectionFactory = (TopicConnectionFactory)this.jndiLookup("TopicConnectionFactory");
        TopicConnection topicConnection = null;
        try {
            topicConnection = this._jmsUser == null ? topicConnectionFactory.createTopicConnection() : topicConnectionFactory.createTopicConnection(this._jmsUser, this._jmsPass);
            Topic topic = (Topic)this.jndiLookup(this._topicName);
            this._topicSession = topicConnection.createTopicSession(false, 1);
            TopicSubscriber topicSubscriber = this._topicSession.createSubscriber(topic, null, true);
            topicSubscriber.setMessageListener((MessageListener)this);
            topicConnection.start();
            ChatServer.log("JMS Subscriber started.");
            this._topicPublisher = this._topicSession.createPublisher(topic);
            this._connected = true;
            ChatServer.log("JMS Publisher initialized.");
            this._server.distributorConnected(this);
        }
        catch (JMSException e) {
            topicConnection.close();
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                if (!this._keepGoing) {
                    return;
                }
                if (this._connected) {
                    if (this._queue.size() > 0) {
                        this.flushQueue();
                    }
                    Thread.sleep(25L);
                    continue;
                }
                try {
                    this.connect();
                    this._failedAttempts = 0;
                    this._jndiContext.close();
                    this._jndiContext = null;
                }
                catch (JMSException e) {
                    if (this._failedAttempts++ == 0) {
                        ChatServer.logError("Could not make JMS connection to " + this.getProvider() + " [" + e.getMessage() + "]");
                        ChatServer.logError("There will be no more JMS related log messages until I get a connection....");
                    }
                    this.rotateProviders();
                    Thread.sleep(30000L);
                }
                catch (NamingException e) {
                    block13: {
                        if (this._failedAttempts++ == 0) {
                            ChatServer.logError("JNDI lookup failed.");
                            ChatServer.logError("There will be no more JMS related log messages until I get a connection....");
                        }
                        this.rotateProviders();
                        try {
                            this.createNewJndiContext();
                        }
                        catch (NamingException ex) {
                            if (this._failedAttempts++ != 0) break block13;
                            ChatServer.logError("Could not create initial JNDI context.");
                            ChatServer.logError("There will be no more JMS related log messages until I get a connection....");
                        }
                    }
                    Thread.sleep(30000L);
                }
            }
        }
        catch (InterruptedException e) {
            ChatServer.log(e);
        }
    }

    void flushQueue() {
        while (this._queue.size() > 0) {
            Message message = (Message)this._queue.remove(0);
            try {
                if (ChatServer.DEBUG) {
                    try {
                        ChatServer.DEBUG("<< " + ((TextMessage)message).getText());
                    }
                    catch (JMSException e) {
                        e.printStackTrace();
                    }
                }
                this._topicPublisher.publish(message);
            }
            catch (JMSException e) {
                ChatServer.log((Exception)((Object)e));
                this._connected = false;
                this._server.distributorDisconnected(this);
            }
        }
    }

    TextMessage createTextMessage() throws JMSException {
        try {
            return this._topicSession.createTextMessage();
        }
        catch (JMSException e) {
            this._connected = false;
            this._server.distributorDisconnected(this);
            throw e;
        }
    }

    public void push(Message msg) {
        this._queue.add(msg);
    }

    public void onMessage(Message message) {
        if (ChatServer.DEBUG) {
            try {
                ChatServer.DEBUG(">> " + ((TextMessage)message).getText());
                ChatServer.DEBUG(">>     origin = " + message.getStringProperty("origin"));
                ChatServer.DEBUG(">>     client = " + message.getStringProperty("client"));
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
        }
        this._server.handleIncoming(message);
    }
}

