/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote;

import com.lyrisoft.chat.IConnectionListener;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.ConnectionHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketException;

public class ReaderThread
extends Thread {
    protected IConnectionListener _connectionListener;
    protected BufferedReader _in;
    protected InputStream _inputStream;
    protected boolean _keepGoing = true;
    protected ConnectionHandler _connectionHandler;

    public ReaderThread(ConnectionHandler handler, IConnectionListener listener, InputStream in) {
        super("ReaderThread");
        this._connectionHandler = handler;
        this._connectionListener = listener;
        this._inputStream = in;
        this._in = new BufferedReader(new InputStreamReader(in));
    }

    public void normalRun() {
        try {
            String newLine;
            while (this._keepGoing && (newLine = this._in.readLine()) != null) {
                this._connectionListener.incomingMessage(newLine);
                ChatServer.DEBUG("> " + newLine);
            }
        }
        catch (SocketException se) {
            this._keepGoing = false;
            ChatServer.DEBUG("Socket closed.  closing connection.");
        }
        catch (IOException e) {
            ChatServer.log(e);
        }
    }

    public void bsdHackRun() {
        try {
            while (this._keepGoing) {
                try {
                    while (this._inputStream.available() < 1) {
                        Thread.sleep(25L);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                String newLine = this._in.readLine();
                this._connectionListener.incomingMessage(newLine);
                ChatServer.DEBUG("> " + newLine);
            }
        }
        catch (IOException e) {
            ChatServer.log(e);
        }
    }

    public void run() {
        String s = System.getProperty("BSD_HACK");
        if (s == null) {
            this.normalRun();
        } else {
            this.bsdHackRun();
        }
        this._connectionHandler.shutdown(true);
    }

    void pleaseStop() {
        this._keepGoing = false;
    }
}

