/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote;

import com.lyrisoft.chat.Constants;
import com.lyrisoft.chat.server.remote.ChatClient;
import com.lyrisoft.chat.server.remote.ChatServer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class Vulture
extends Thread
implements Constants {
    private static final int SLEEP = 45000;
    private static final int CLIENT_TIMEOUT = 300000;
    private static final int SERVER_TIMEOUT = 300000;
    private static final int BROADCAST_PING_INTERVAL = 60000;
    private static final int CLIENT_PING_INTERVAL = 60000;
    private long _timeoutMillis;
    private double _timeoutMinutes;
    private HashSet _clients;
    private boolean _keepGoing = true;
    private ChatServer _server;
    private long _lastBroadcastPing;

    public Vulture(ChatServer server, double timeout) {
        this._server = server;
        this._timeoutMinutes = timeout;
        this._timeoutMillis = (long)(timeout * 60.0 * 1000.0);
        this.setDaemon(true);
        this.setPriority(1);
        this._clients = new HashSet();
    }

    public void run() {
        if (this._timeoutMinutes != 0.0) {
            ChatServer.log("Vulture: eating connections that are idle over " + this._timeoutMinutes + " minutes.");
        } else {
            ChatServer.log("Vulture: idle timeout is disabled.");
        }
        while (this._keepGoing) {
            try {
                this.doClientCleanup();
                this.doServerCleanup();
                Thread.sleep(45000L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public void pleaseStop() {
        this._keepGoing = false;
    }

    void doServerCleanup() {
        long now = System.currentTimeMillis();
        if (now - this._lastBroadcastPing > 60000L) {
            this._server.sendBroadcastPing();
            this._lastBroadcastPing = now;
        }
        this._server.checkServerPings(300000L);
    }

    void doClientCleanup() {
        LinkedList<ChatClient> deadClients = new LinkedList<ChatClient>();
        HashSet hashSet = this._clients;
        synchronized (hashSet) {
            Iterator i = this._clients.iterator();
            while (i.hasNext()) {
                long idle;
                ChatClient c = (ChatClient)i.next();
                long now = System.currentTimeMillis();
                if (c.getLastServerPing() != 0L) {
                    long delta = now - c.getLastServerPong();
                    if (delta > 300000L) {
                        deadClients.add(c);
                        ChatServer.log("ping timeout: " + c.getUserId());
                    } else if (delta > 60000L) {
                        c.ping("server", String.valueOf(now));
                        c.setLastServerPing(now);
                    }
                } else {
                    c.ping("server", String.valueOf(now));
                    c.setLastServerPing(now);
                }
                if (this._timeoutMillis <= 0L || (idle = c.getIdle()) <= this._timeoutMillis) continue;
                c.generalError("idle timeout ( " + this._timeoutMinutes + " minutes) exceeded.");
                deadClients.add(c);
            }
        }
        Iterator i = deadClients.iterator();
        while (i.hasNext()) {
            ChatClient c = (ChatClient)i.next();
            String userId = c.getUserId() == null ? "anonymous user" : c.getUserId();
            ChatServer.log("Vulture: eating " + userId);
            c.getServer().signOff(c);
        }
    }

    public void addClient(ChatClient c) {
        HashSet hashSet = this._clients;
        synchronized (hashSet) {
            this._clients.add(c);
        }
    }

    public void removeClient(ChatClient c) {
        HashSet hashSet = this._clients;
        synchronized (hashSet) {
            this._clients.remove(c);
        }
    }
}

