/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote.command;

import com.lyrisoft.chat.Constants;
import com.lyrisoft.chat.ICommands;
import com.lyrisoft.chat.server.remote.ChatClient;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.command.CommandBase;

public class Ping
extends CommandBase
implements Constants,
ICommands {
    public boolean process(ChatClient client, String[] args) {
        if (args.length < 3) {
            client.generalError(this.getUsage(args[0]));
            return false;
        }
        if (args[1].equals("server")) {
            client.pong("server", args[2]);
            return false;
        }
        ChatClient otherClient = client.getServer().getClient(args[1]);
        if (otherClient == null) {
            if (!client.getServer().userExists(args[1])) {
                client.error("/nosuchuser", args[1]);
                return false;
            }
            return true;
        }
        otherClient.ping(client.getUserId(), args[2]);
        return false;
    }

    public void processDistributed(String client, String origin, String[] args, ChatServer server) {
        if (args.length < 3) {
            System.err.println("args < 3");
            return;
        }
        if (args[1].equalsIgnoreCase(server.getName())) {
            ChatServer.log("Ping from " + origin);
            server.sendServerPong(origin, args[2]);
        } else {
            ChatClient otherClient = server.getClient(args[1]);
            if (otherClient != null) {
                otherClient.ping(client, args[2]);
            }
        }
    }
}

