/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote.command;

import com.lyrisoft.chat.Translator;
import com.lyrisoft.chat.server.remote.ChatClient;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.command.CommandBase;

public class UsersInRoom
extends CommandBase {
    public boolean process(ChatClient client, String[] args) {
        if (args.length < 2) {
            client.generalError(this.getUsage(args[0]));
        } else {
            String roomName = args[1];
            String[] users = client.getServer().getUsersInRoom(roomName);
            if (users.length == 0) {
                client.generalError(Translator.getMessage("noroom", roomName));
            } else {
                client.roomUserList(roomName, users);
            }
        }
        return false;
    }

    public void processDistributed(String client, String origin, String[] args, ChatServer server) {
        if (args.length < 3) {
            return;
        }
        String roomName = args[1];
        int i = 2;
        while (i < args.length) {
            String user = args[i];
            server.remoteJoinRoom(origin, user, roomName, null);
            ++i;
        }
    }
}

