/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote.persistence.auth;

import com.lyrisoft.chat.server.remote.AccessDenied;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.persistence.auth.Auth;
import com.lyrisoft.chat.server.remote.persistence.auth.NullAuthenticator;
import com.lyrisoft.util.properties.PropertyTool;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;

public class LdapAuthenticator
extends NullAuthenticator {
    Hashtable _env = new Hashtable();
    String _userAttr = "uid";
    String _srchBase = "";
    String _serverURL = "ldap://localhost:389";

    public LdapAuthenticator(ChatServer server, boolean allowGuests, boolean storeGuests) {
        super(server, allowGuests, storeGuests);
        this._env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        try {
            Properties p = PropertyTool.loadProperties("conf/ldapAuth.conf");
            try {
                String factory = this.stripQuotes(PropertyTool.getString("ldap.CONTEXT_FACTORY", p));
                this._env.put("java.naming.factory.initial", factory);
            }
            catch (Exception factory) {
                // empty catch block
            }
            try {
                String bindDN = this.stripQuotes(PropertyTool.getString("ldap.bindDN", p));
                String bindPW = this.stripQuotes(PropertyTool.getString("ldap.bindPW", p));
                this._env.put("java.naming.security.authentication", "simple");
                this._env.put("java.naming.security.principal", bindDN);
                this._env.put("java.naming.security.credentials", bindPW);
            }
            catch (Exception bindDN) {
                // empty catch block
            }
            try {
                String serverURL;
                this._serverURL = serverURL = this.stripQuotes(PropertyTool.getString("ldap.serverURL", p));
            }
            catch (Exception serverURL) {
                // empty catch block
            }
            try {
                String searchBase;
                this._srchBase = searchBase = this.stripQuotes(PropertyTool.getString("ldap.searchBase", p));
            }
            catch (Exception searchBase) {
                // empty catch block
            }
            try {
                String userAttr;
                this._userAttr = userAttr = this.stripQuotes(PropertyTool.getString("ldap.userAttr", p));
            }
            catch (Exception e5) {}
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private NamingEnumeration getNamingEnumeration(String userId) throws NamingException {
        InitialDirContext dir = new InitialDirContext(this._env);
        NamingEnumeration ne = this.getNamingEnumeration(userId, dir);
        dir.close();
        return ne;
    }

    private NamingEnumeration getNamingEnumeration(String userId, DirContext dir) throws NamingException {
        NamingEnumeration<SearchResult> results = null;
        SearchControls cons = new SearchControls();
        cons.setSearchScope(2);
        results = dir.search(this._srchBase, "(" + this._userAttr + "=" + userId + ")", cons);
        return results;
    }

    private boolean isStoredUser(String userId) {
        try {
            return this.getNamingEnumeration(userId).hasMore();
        }
        catch (NamingException e) {
            ChatServer.log(e);
            return false;
        }
    }

    public boolean isExistingUser(String userId) {
        return super.isExistingUser(userId) || this.isStoredUser(userId);
    }

    public Auth authenticate(String userId, String password) throws AccessDenied {
        try {
            InitialDirContext dir = new InitialDirContext(this._env);
            NamingEnumeration results = this.getNamingEnumeration(userId, dir);
            while (this.getNamingEnumeration(userId).hasMore()) {
                SearchResult sr = (SearchResult)results.next();
                String userDN = sr.getName();
                if (sr.isRelative() && !this._srchBase.equals("")) {
                    userDN = String.valueOf(userDN) + "," + this._srchBase;
                }
                Hashtable<String, String> userenv = new Hashtable<String, String>(this._env);
                userenv.put("java.naming.security.authentication", "simple");
                userenv.put("java.naming.security.principal", userDN);
                userenv.put("java.naming.security.credentials", password);
                try {
                    InitialDirContext userbind = new InitialDirContext(userenv);
                    userbind.close();
                    results.close();
                    dir.close();
                    return new Auth(userId, 1);
                }
                catch (NamingException namingException) {
                    results.close();
                    dir.close();
                }
            }
        }
        catch (NamingException e) {
            ChatServer.log(e);
        }
        if (this._allowGuests) {
            return super.authenticate(userId, password);
        }
        throw new AccessDenied(userId);
    }

    private String stripQuotes(String token) {
        if (token.startsWith("\"")) {
            token = token.substring(1);
        }
        if (token.endsWith("\"")) {
            token = token.substring(0, token.length() - 1);
        }
        return token;
    }
}

