/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote.persistence.auth;

import com.lyrisoft.chat.server.remote.AccessDenied;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.persistence.auth.PasswdRecord;
import com.lyrisoft.util.io.ResourceException;
import com.lyrisoft.util.io.ResourceLoader;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import jfd.jcrypt;

public class Passwd {
    private static Hashtable records;
    private static boolean _warned;

    static {
        block13: {
            records = null;
            _warned = false;
            records = new Hashtable();
            BufferedReader reader = null;
            int lineno = 1;
            try {
                try {
                    String s;
                    InputStream is = ResourceLoader.getResource("conf/nfc.passwd");
                    reader = new BufferedReader(new InputStreamReader(is));
                    while ((s = reader.readLine()) != null) {
                        PasswdRecord r = Passwd.parseRecord(s);
                        records.put(r.userId.toLowerCase(), r);
                    }
                    ++lineno;
                }
                catch (ResourceException e) {
                    if (!_warned) {
                        ChatServer.logError("Warning: passwd file not found.");
                        _warned = true;
                    }
                }
                catch (Exception e) {
                    ChatServer.logError("Error reading passwd file, line " + lineno);
                    ChatServer.log(e);
                }
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e) {
                        ChatServer.log(e);
                    }
                }
                throw throwable;
            }
            Object var5_9 = null;
            if (reader == null) break block13;
            try {
                reader.close();
            }
            catch (Exception e) {
                ChatServer.log(e);
            }
        }
    }

    public static boolean isExistingUser(String userId) {
        return records.containsKey(userId.toLowerCase());
    }

    public static final PasswdRecord getRecord(String userId, String password) throws IOException, AccessDenied {
        PasswdRecord r = (PasswdRecord)records.get(userId.toLowerCase());
        if (r == null) {
            return null;
        }
        if (password == null) {
            password = "";
        }
        if (password.length() < 2) {
            ChatServer.log("Access denied: " + userId);
            throw new AccessDenied(userId);
        }
        String salt = r.passwd.substring(0, 2);
        if (jcrypt.crypt(salt, password).equals(r.passwd)) {
            return r;
        }
        ChatServer.log("Access denied: " + userId);
        throw new AccessDenied(userId);
    }

    public static final void writeRecord(PasswdRecord r) throws IOException {
        records.put(r.userId.toLowerCase(), r);
        Passwd.save();
    }

    public static final void writeRecord(String userId, int access, String passwd) throws IOException {
        PasswdRecord r = new PasswdRecord(userId, access, passwd);
        String salt = String.valueOf(System.currentTimeMillis());
        int len = salt.length();
        salt = salt.substring(len - 2, len);
        r.passwd = jcrypt.crypt(salt, passwd);
        Passwd.writeRecord(r);
    }

    private static final synchronized void save() throws IOException {
        block4: {
            PrintWriter out = null;
            try {
                out = new PrintWriter(new FileWriter(Passwd.getPasswdFileName()));
                Enumeration e = records.elements();
                while (e.hasMoreElements()) {
                    Passwd.saveRecord(out, (PasswdRecord)e.nextElement());
                }
            }
            catch (Throwable throwable) {
                Object var2_3 = null;
                if (out != null) {
                    out.close();
                }
                throw throwable;
            }
            Object var2_4 = null;
            if (out == null) break block4;
            out.close();
        }
    }

    private static final PasswdRecord parseRecord(String line) throws Exception {
        StringTokenizer st = new StringTokenizer(line, ":");
        if (st.countTokens() < 3) {
            throw new Exception("Not enough tokens");
        }
        return new PasswdRecord(st.nextToken(), Integer.parseInt(st.nextToken()), st.nextToken());
    }

    private static final void saveRecord(PrintWriter writer, PasswdRecord record) throws IOException {
        writer.println(String.valueOf(record.userId) + ":" + record.access + ":" + record.passwd);
    }

    private static final String getPasswdFileName() {
        StringBuffer sb = new StringBuffer();
        String NFC_HOME = System.getProperty("NFC_HOME");
        if (NFC_HOME == null) {
            System.err.println("Passwd: Warning! Property NFC_HOME not set.");
            return "";
        }
        sb.append(NFC_HOME);
        if (NFC_HOME.charAt(NFC_HOME.length() - 1) != File.separatorChar) {
            sb.append(File.separator);
        }
        sb.append("conf");
        sb.append(File.separator);
        sb.append("nfc.passwd");
        return sb.toString();
    }

    public static void main(String[] args) {
        try {
            Passwd.writeRecord(args[0], Integer.parseInt(args[1]), args[2]);
        }
        catch (IOException e) {
            System.err.println("An I/O error occurred: " + e.getMessage());
        }
        catch (Exception e) {
            Passwd.showUsageAndExit();
        }
    }

    private static final void showUsageAndExit() {
        System.err.println("Passwd Program.  Adds new line to the passwd file, encrypting the password.");
        System.err.println("usage: java com.lyrisoft.chat.server.remote.auth.Passwd [user id] [access level] [password]");
        System.exit(1);
    }
}

