/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote.persistence.auth;

import com.lyrisoft.chat.server.remote.AccessDenied;
import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.persistence.auth.Auth;
import com.lyrisoft.chat.server.remote.persistence.auth.NullAuthenticator;
import com.lyrisoft.chat.server.remote.persistence.auth.Passwd;
import com.lyrisoft.chat.server.remote.persistence.auth.PasswdRecord;
import java.io.IOException;

public class PasswdAuthenticator
extends NullAuthenticator {
    public PasswdAuthenticator(ChatServer server, boolean allowGuests, boolean storeGuests) {
        super(server, allowGuests, storeGuests);
    }

    public Auth authenticate(String userId, String password) throws AccessDenied {
        try {
            PasswdRecord record = Passwd.getRecord(userId, password);
            if (record == null) {
                if (this._allowGuests) {
                    Auth auth = super.authenticate(userId, password);
                    if (this._storeGuests) {
                        Passwd.writeRecord(auth.getUserId(), 1, password);
                    }
                    return auth;
                }
                throw new AccessDenied(userId);
            }
            return new Auth(userId, record.access);
        }
        catch (IOException e) {
            ChatServer.log(e);
            throw new AccessDenied(userId);
        }
    }

    public boolean isExistingUser(String userId) {
        return super.isExistingUser(userId) || Passwd.isExistingUser(userId);
    }
}

