/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.chat.server.remote.persistence.ignore;

import com.lyrisoft.chat.server.remote.ChatServer;
import com.lyrisoft.chat.server.remote.persistence.Jdbc;
import com.lyrisoft.chat.server.remote.persistence.ignore.IIgnoreStorage;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;

public class JdbcIgnoreStorage
implements IIgnoreStorage {
    private PreparedStatement _ignorePS;
    private PreparedStatement _unignorePS;
    private PreparedStatement _getIgnoredPS;

    public JdbcIgnoreStorage() {
        try {
            String sql = "insert into nfc_users_ignoring_users (ignorer, ignoree) values (?, ?)";
            this._ignorePS = Jdbc.conn.prepareStatement(sql);
            sql = "delete from nfc_users_ignoring_users where ignorer = ? and ignoree = ?";
            this._unignorePS = Jdbc.conn.prepareStatement(sql);
            sql = "select ignoree from nfc_users_ignoring_users where ignorer = ?";
            this._getIgnoredPS = Jdbc.conn.prepareStatement(sql);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void ignore(String user, String userToIgnore) {
        try {
            this._ignorePS.setString(1, user);
            this._ignorePS.setString(2, userToIgnore);
            this._ignorePS.executeUpdate();
        }
        catch (Exception e) {
            ChatServer.log(e);
        }
    }

    public synchronized void unignore(String user, String userIgnored) {
        try {
            this._unignorePS.setString(1, user);
            this._unignorePS.setString(2, userIgnored);
            this._unignorePS.executeUpdate();
        }
        catch (Exception e) {
            ChatServer.log(e);
        }
    }

    public synchronized List getIgnoredByUser(String user) {
        ArrayList<String> ignored = new ArrayList<String>(0);
        try {
            this._getIgnoredPS.setString(1, user);
            ResultSet rs = this._getIgnoredPS.executeQuery();
            while (rs.next()) {
                ignored.add(rs.getString("ignoree"));
            }
        }
        catch (Exception e) {
            ChatServer.log(e);
        }
        return ignored;
    }
}

