/*
 * Decompiled with CFR 0.152.
 */
package com.lyrisoft.util.io;

import com.lyrisoft.util.io.ResourceException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletContext;

public class ResourceLoader {
    private static ServletContext servletContext;

    protected ResourceLoader() {
    }

    public static void setServletContext(ServletContext context) {
        servletContext = context;
    }

    public static InputStream getResource(String relativePath) throws ResourceException {
        if (servletContext != null) {
            return ResourceLoader.getServletResource(relativePath);
        }
        InputStream is = ClassLoader.getSystemResourceAsStream(relativePath);
        if (is == null) {
            throw new ResourceException("Could not locate resource, " + relativePath);
        }
        return is;
    }

    public static String touch(String relativePath) throws ResourceException {
        if (servletContext == null) {
            throw new ResourceException("Sorry, you can't touch a resource unless you're running as a servlet");
        }
        String workDir = servletContext.getRealPath("/");
        if (workDir == null) {
            throw new ResourceException("Could not find working directory.");
        }
        workDir = workDir.substring(0, workDir.lastIndexOf(File.separator));
        String fileName = String.valueOf(workDir) + File.separator + "WEB-INF" + File.separator + relativePath;
        File file = new File(fileName);
        File parent = new File(file.getParent());
        parent.mkdirs();
        if (!file.exists()) {
            try {
                if (!file.createNewFile()) {
                    throw new ResourceException("Couldn't create " + file);
                }
            }
            catch (IOException e) {
                throw new ResourceException("Couldn't create " + file);
            }
        }
        return fileName;
    }

    private static InputStream getServletResource(String relativePath) throws ResourceException {
        return servletContext.getResourceAsStream("/WEB-INF/" + relativePath);
    }
}

