/*
 * Decompiled with CFR 0.152.
 */
package client;

import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;

public class MMGame
extends Vector
implements Serializable {
    int port;
    int maxPlayers;
    int actPlayers;
    String ip;
    String version;
    String comment = "";
    String gameid = "default";
    String PlayerName;
    Vector currentPlayers = new Vector();
    String Status = "Open";
    String dedPrefix = " ";

    public MMGame(String PlayerName, String gip, int gport, int gmaxp, String version, String gcomment, String dedPrefix) {
        this.ip = gip;
        this.port = gport;
        this.maxPlayers = gmaxp;
        this.actPlayers = 0;
        this.version = version;
        this.comment = gcomment;
        if (this.comment.length() == 0) {
            this.comment = " ";
        }
        this.PlayerName = PlayerName;
        this.dedPrefix = dedPrefix;
        if (this.dedPrefix.length() < 1) {
            this.dedPrefix = " ";
        }
    }

    public MMGame(String s) {
        StringTokenizer ST = new StringTokenizer(s, "~");
        this.gameid = ST.nextToken();
        this.PlayerName = (String)ST.nextElement();
        this.ip = (String)ST.nextElement();
        this.port = Integer.parseInt((String)ST.nextElement());
        this.actPlayers = Integer.parseInt((String)ST.nextElement());
        this.maxPlayers = Integer.parseInt((String)ST.nextElement());
        this.version = (String)ST.nextElement();
        this.comment = (String)ST.nextElement();
        this.dedPrefix = (String)ST.nextElement();
        while (ST.hasMoreElements()) {
            this.currentPlayers.add(ST.nextElement());
        }
    }

    public String toString() {
        String result = this.gameid + "~" + this.PlayerName + "~" + this.ip + "~" + this.port + "~" + this.actPlayers + "~" + this.maxPlayers + "~" + this.version + "~" + this.comment + "~" + this.dedPrefix + "~";
        Iterator i = this.currentPlayers.iterator();
        while (i.hasNext()) {
            result = result + (String)i.next();
            if (!i.hasNext()) continue;
            result = result + "~";
        }
        return result;
    }

    public boolean equals(Object o) {
        MMGame game = (MMGame)o;
        return game.getUID().equalsIgnoreCase(this.getUID());
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public String getIp() {
        return this.ip;
    }

    public int getPort() {
        return this.port;
    }

    public String getUID() {
        return this.gameid;
    }

    public void setUID(String id) {
        this.gameid = id;
    }

    public int getActPlayers() {
        return this.actPlayers;
    }

    public void setActPlayers(int actPlayers) {
        this.actPlayers = actPlayers;
    }

    public String getPlayerName() {
        return this.PlayerName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public Vector getCurrentPlayers() {
        return this.currentPlayers;
    }

    public void setCurrentPlayers(Vector currentPlayers) {
        this.currentPlayers = currentPlayers;
    }

    public String getStatus() {
        return this.Status;
    }

    public void setStatus(String Status) {
        this.Status = Status;
    }

    public String getDedPrefix() {
        return this.dedPrefix;
    }

    public void setDedPrefix(String prefix) {
        this.dedPrefix = prefix;
    }

    public int size() {
        return 6;
    }

    public static Vector getColumnHeader() {
        Vector<String> ColumnHeader = new Vector<String>();
        ColumnHeader.add("Name");
        ColumnHeader.add("Players");
        ColumnHeader.add("Version");
        ColumnHeader.add("Comment");
        ColumnHeader.add("Player Names");
        return ColumnHeader;
    }

    public Object elementAt(int index) {
        switch (index) {
            case 0: {
                return this.getPlayerName();
            }
            case 1: {
                return this.getCurrentPlayers().size() + "/" + this.getMaxPlayers();
            }
            case 2: {
                return this.getVersion();
            }
            case 3: {
                return this.getComment();
            }
            case 4: {
                return this.getCurrentPlayers();
            }
            case 5: {
                return this.getStatus();
            }
        }
        return "";
    }

    public static class TableModel
    extends AbstractTableModel {
        public Vector data;
        public Vector columnNames;

        public TableModel(List list) {
            this.data = list;
            this.columnNames = MMGame.getColumnHeader();
        }

        public int getColumnCount() {
            return this.columnNames.size();
        }

        public int getRowCount() {
            return this.data.size();
        }

        public String getColumnName(int col) {
            return (String)this.columnNames.elementAt(col);
        }

        public Object getValueAt(int row, int col) {
            if (row < 0 || row >= this.data.size()) {
                return null;
            }
            return ((Vector)this.data.elementAt(row)).elementAt(col);
        }

        public void refreshModel() {
            this.fireTableDataChanged();
        }

        public TableCellRenderer getRenderer() {
            return new Renderer();
        }

        public class Renderer
        extends DefaultTableCellRenderer {
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (TableModel.this.data.size() <= row) {
                    return c;
                }
                if (isSelected) {
                    return c;
                }
                MMGame game = (MMGame)TableModel.this.data.elementAt(row);
                if (game.getStatus().equals("Open")) {
                    c.setBackground(Color.green);
                } else if (game.getStatus().equals("Running")) {
                    c.setBackground(Color.yellow);
                } else if (game.getStatus().equals("Closed")) {
                    c.setBackground(Color.red);
                } else {
                    c.setBackground(this.getBackground());
                }
                return c;
            }
        }
    }

    public static class List
    extends Vector {
        public MMGame getGame(String uid) {
            for (MMGame next : this) {
                if (!next.getUID().equalsIgnoreCase(uid)) continue;
                return next;
            }
            return null;
        }

        public void add(MMGame game) {
            if (this.contains(game)) {
                this.remove(game);
            }
            super.add(game);
        }
    }
}

