/*
 * Decompiled with CFR 0.152.
 */
package client.campaign;

import client.MWClient;
import client.campaign.CPlayer;
import client.campaign.CUnit;
import common.Army;
import common.Unit;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CArmy
extends Army {
    private MWClient mwclient;
    private TreeMap<String, String> legalOperations = new TreeMap();

    public void fromString(String s, CPlayer p, String delimiter, MWClient client) {
        int i;
        this.mwclient = client;
        StringTokenizer ST = new StringTokenizer(s, delimiter);
        this.setID(Integer.parseInt(ST.nextToken()));
        this.setBV(Integer.parseInt(ST.nextToken()));
        this.setLocked(Boolean.valueOf(ST.nextToken()));
        this.setName(ST.nextToken());
        this.setLowerLimiter(Integer.parseInt(ST.nextToken()));
        this.setUpperLimiter(Integer.parseInt(ST.nextToken()));
        int count = Integer.parseInt(ST.nextToken());
        for (i = 0; i < count; ++i) {
            CUnit u = p.getUnit(Integer.parseInt(ST.nextToken()));
            if (u.getId() == 0) continue;
            this.addUnit(u);
        }
        if (ST.hasMoreElements()) {
            count = Integer.parseInt(ST.nextToken());
            for (i = 0; i < count; ++i) {
                int key = Integer.parseInt(ST.nextToken());
                int unit = Integer.parseInt(ST.nextToken());
                this.getC3Network().put(new Integer(key), new Integer(unit));
            }
        }
    }

    public void addUnit(CUnit u) {
        this.getUnits().add(u);
    }

    public void addUnit(CUnit u, int position) {
        this.getUnits().add(position, u);
    }

    public boolean isEmpty() {
        return this.getUnits().size() == 0;
    }

    public boolean hasUnit(int id) {
        return this.getUnit(id) != null;
    }

    public TreeMap<String, String> getLegalOperations() {
        return this.legalOperations;
    }

    public void setLegalOperations(TreeMap<String, String> tm) {
        this.legalOperations = tm;
    }

    public int getOperationsBV() {
        boolean useingOpRules = Boolean.valueOf(this.mwclient.getserverConfigs("UseOperationsRule"));
        if (!useingOpRules) {
            return this.getBV();
        }
        double thisRawSize = this.getRawForceSize();
        double opForceRawSize = Double.parseDouble(this.mwclient.getserverConfigs("BaseForceSize"));
        if (opForceRawSize >= thisRawSize) {
            return this.getBV();
        }
        double baseForcePenalty = Double.parseDouble(this.mwclient.getserverConfigs("BaseForcePenalty"));
        double forceDifference = thisRawSize - opForceRawSize;
        double baseForceMultiplier = forceDifference * baseForcePenalty;
        double rawForceMultiplier = forceDifference / opForceRawSize;
        double finalMultiplier = 0.0;
        finalMultiplier = baseForceMultiplier < rawForceMultiplier ? baseForceMultiplier : rawForceMultiplier;
        return (int)((double)this.getBV() * (finalMultiplier += 1.0));
    }

    public double getRawForceSize() {
        double rawForceSize = 0.0;
        Enumeration<Unit> e = this.getUnits().elements();
        while (e.hasMoreElements()) {
            CUnit u = (CUnit)e.nextElement();
            if (u.getType() == 2) {
                rawForceSize += Double.parseDouble(this.mwclient.getserverConfigs("InfantryOperationsBVMod"));
                continue;
            }
            if (u.getType() == 1) {
                rawForceSize += Double.parseDouble(this.mwclient.getserverConfigs("VehicleOperationsBVMod"));
                continue;
            }
            rawForceSize += Double.parseDouble(this.mwclient.getserverConfigs("MekOperationsBVMod"));
        }
        return rawForceSize;
    }
}

