/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.gui.SplashWindow;

class AnimationThread
extends Thread {
    private SplashWindow splash;
    private int cycle;
    private int progress;
    private final String initializing = "Initializing";
    private final String constructing = "Constructing GUI";
    private final String fetching = "Downloading Data";
    private final String connecting = "Connecting to Server";

    public AnimationThread(SplashWindow s) {
        this.splash = s;
        this.progress = 0;
        this.cycle = 0;
    }

    private void setLabelText(String s) {
        switch (this.progress) {
            case 0: {
                this.splash.getImageLabel().setText("<HTML><CENTER><b>" + s + "<br>\u2022</b></CENTER></HTML>");
                break;
            }
            case 1: {
                this.splash.getImageLabel().setText("<HTML><CENTER><b>" + s + "<br>\u2022\u2022</b></CENTER></HTML>");
                break;
            }
            case 2: {
                this.splash.getImageLabel().setText("<HTML><CENTER><b>" + s + "<br>\u2022\u2022\u2022</b></CENTER></HTML>");
                break;
            }
            case 3: {
                this.splash.getImageLabel().setText("<HTML><CENTER><b>" + s + "<br>\u2022\u2022\u2022\u2022</b></CENTER></HTML>");
                break;
            }
            case 4: {
                this.splash.getImageLabel().setText("<HTML><CENTER><b>" + s + "<br>\u2022\u2022\u2022\u2022\u2022</b></CENTER></HTML>");
                break;
            }
            case 5: {
                this.splash.getImageLabel().setText("<HTML><CENTER><b>" + s + "<br>\u2022\u2022\u2022\u2022\u2022\u2022</b></CENTER></HTML>");
                break;
            }
            case 6: {
                this.splash.getImageLabel().setText("<HTML><CENTER><b>" + s + "<br>\u2022\u2022\u2022\u2022\u2022\u2022\u2022</b></CENTER></HTML>");
                break;
            }
            case 7: {
                this.splash.getImageLabel().setText("<HTML><CENTER><b>" + s + "<br>\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022</b></CENTER></HTML>");
                break;
            }
            case 8: {
                this.splash.getImageLabel().setText("<HTML><CENTER><b>" + s + "<br>\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022</b></CENTER></HTML>");
                break;
            }
            case 9: {
                this.splash.getImageLabel().setText("<HTML><CENTER><b>" + s + "<br>\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022\u2022</b></CENTER></HTML>");
            }
        }
    }

    public synchronized void run() {
        try {
            do {
                int currStatus;
                this.wait(150L);
                ++this.cycle;
                if (this.cycle == 4) {
                    this.cycle = 0;
                }
                if ((currStatus = this.splash.getStatus()) == this.splash.STATUS_DATAERROR || currStatus == this.splash.STATUS_INPUTWAIT || currStatus == this.splash.STATUS_CONNECTFAILED) {
                    --this.cycle;
                } else if (this.cycle == 0) {
                    ++this.progress;
                    if (this.progress == 10) {
                        this.progress = 0;
                    }
                }
                if (currStatus == this.splash.STATUS_INITIALIZING) {
                    this.setLabelText("Initializing");
                    continue;
                }
                if (currStatus == this.splash.STATUS_FETCHINGDATA) {
                    this.setLabelText("Downloading Data");
                    continue;
                }
                if (currStatus == this.splash.STATUS_CONSTRUCTINGGUI) {
                    this.setLabelText("Constructing GUI");
                    continue;
                }
                if (currStatus == this.splash.STATUS_CONNECTING) {
                    this.setLabelText("Connecting to Server");
                    continue;
                }
                if (currStatus == this.splash.STATUS_INPUTWAIT) {
                    this.splash.getImageLabel().setText("<HTML><CENTER><b>Connecting to Server<br>[Waiting for Input]</b></CENTER></HTML>");
                    continue;
                }
                if (currStatus == this.splash.STATUS_DATAERROR) {
                    this.splash.getImageLabel().setText("<HTML><CENTER><b>Downloading Data<br>[Data Access Error]</b></CENTER></HTML>");
                    continue;
                }
                if (currStatus != this.splash.STATUS_CONNECTFAILED) continue;
                this.splash.getImageLabel().setText("<HTML><CENTER><b>Connecting to Server<br>[Connection Failed]</b></CENTER></HTML>");
            } while (this.splash.shouldAnimate());
            return;
        }
        catch (Exception e) {
            this.splash.getImageLabel().setText("Error in animation thread!");
            return;
        }
    }
}

