/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.gui.BrowserCommandLexer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Browser {
    protected static BrowserDialog dialog;
    protected static ResourceBundle labels;
    public static String[] exec;
    private static JTextArea description;
    private static JTextArea commandLinesArea;
    private static JButton resetButton;
    private static JButton browseButton;
    private static JLabel commandLinesLabel;
    private static JFileChooser fileChooser;
    private static JPanel dialogPanel;
    private static Window dialogParent;

    public static void setLocale(Locale locale) {
        labels = ResourceBundle.getBundle("MegaMekNETClient.GUI.Browser", locale);
    }

    public static void init() {
        exec = Browser.defaultCommands();
    }

    public static String[] defaultCommands() {
        Object exec = null;
        if (System.getProperty("os.name").startsWith("Windows")) {
            exec = new String[]{"rundll32 url.dll,FileProtocolHandler {0}"};
        } else if (System.getProperty("os.name").startsWith("Mac")) {
            Vector<String> browsers = new Vector<String>();
            try {
                Process p = Runtime.getRuntime().exec("which open");
                if (p.waitFor() == 0) {
                    browsers.add("open {0}");
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            exec = browsers.size() == 0 ? null : browsers.toArray(new String[0]);
        } else {
            Process p;
            Vector<String> browsers = new Vector<String>();
            try {
                p = Runtime.getRuntime().exec("which firebird");
                if (p.waitFor() == 0) {
                    browsers.add("firebird -remote openURL({0})");
                    browsers.add("firebird {0}");
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                p = Runtime.getRuntime().exec("which mozilla");
                if (p.waitFor() == 0) {
                    browsers.add("mozilla -remote openURL({0})");
                    browsers.add("mozilla {0}");
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                p = Runtime.getRuntime().exec("which opera");
                if (p.waitFor() == 0) {
                    browsers.add("opera -remote openURL({0})");
                    browsers.add("opera {0}");
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                p = Runtime.getRuntime().exec("which galeon");
                if (p.waitFor() == 0) {
                    browsers.add("galeon {0}");
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                p = Runtime.getRuntime().exec("which konqueror");
                if (p.waitFor() == 0) {
                    browsers.add("konqueror {0}");
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                p = Runtime.getRuntime().exec("which netscape");
                if (p.waitFor() == 0) {
                    browsers.add("netscape -remote openURL({0})");
                    browsers.add("netscape {0}");
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                p = Runtime.getRuntime().exec("which xterm");
                if (p.waitFor() == 0 && (p = Runtime.getRuntime().exec("which lynx")).waitFor() == 0) {
                    browsers.add("xterm -e lynx {0}");
                }
            }
            catch (IOException e) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            exec = browsers.size() == 0 ? null : browsers.toArray(new String[0]);
        }
        return exec;
    }

    public static void save(Properties props) {
        int i;
        boolean saveBrowser = false;
        if (exec != null && exec.length > 0) {
            String[] exec = Browser.defaultCommands();
            if (exec != null && exec.length == Browser.exec.length) {
                for (i = 0; i < exec.length; ++i) {
                    if (exec[i].equals(Browser.exec[i])) continue;
                    saveBrowser = true;
                }
            } else {
                saveBrowser = true;
            }
        }
        if (saveBrowser) {
            StringBuffer sb = new StringBuffer();
            for (i = 0; exec != null && i < exec.length; ++i) {
                sb.append(exec[i]).append('\n');
            }
            props.put("MegaMekNETClient.GUI.Browser.open", sb.toString());
        } else {
            props.remove("MegaMekNETClient.GUI.Browser.open");
        }
    }

    public static void load(Properties props) {
        if (props.containsKey("MegaMekNETClient.GUI.Browser.open")) {
            StringTokenizer tok = new StringTokenizer(props.getProperty("MegaMekNETClient.GUI.Browser.open"), "\r\n", false);
            int count = tok.countTokens();
            String[] exec = new String[count];
            for (int i = 0; i < count; ++i) {
                exec[i] = tok.nextToken();
            }
            Browser.exec = exec;
        } else {
            Browser.init();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void displayURL(String url) throws IOException {
        if (exec == null || exec.length == 0) {
            if (!System.getProperty("os.name").startsWith("Mac")) throw new IOException(labels.getString("nocommand"));
            boolean success = false;
            try {
                Class<?> nSWorkspace;
                if (new File("/System/Library/Java/com/apple/cocoa/application/NSWorkspace.class").exists()) {
                    URLClassLoader classLoader = new URLClassLoader(new URL[]{new File("/System/Library/Java").toURL()});
                    nSWorkspace = Class.forName("com.apple.cocoa.application.NSWorkspace", true, classLoader);
                } else {
                    nSWorkspace = Class.forName("com.apple.cocoa.application.NSWorkspace");
                }
                Method sharedWorkspace = nSWorkspace.getMethod("sharedWorkspace", new Class[0]);
                Object workspace = sharedWorkspace.invoke(null, new Object[0]);
                Method openURL = nSWorkspace.getMethod("openURL", Class.forName("java.net.URL"));
                success = (Boolean)openURL.invoke(workspace, new URL(url));
            }
            catch (Exception x) {
                // empty catch block
            }
            if (success) return;
            try {
                Class<?> mrjFileUtils = Class.forName("com.apple.mrj.MRJFileUtils");
                Method openURL = mrjFileUtils.getMethod("openURL", Class.forName("java.lang.String"));
                openURL.invoke(null, url);
                return;
            }
            catch (Exception x) {
                MWClient.mwClientLog.clientErrLog(x.getMessage());
                throw new IOException(labels.getString("failed"));
            }
        }
        new URL(url);
        StringBuffer sb = new StringBuffer(url.length());
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '.' || c == ':' || c == '&' || c == '@' || c == '/' || c == '?' || c == '%' || c == '+' || c == '=' || c == '#' || c == '-' || c == '\\') {
                sb.append(c);
                continue;
            }
            if ((c = (char)(c & 0xFF)) < '\u0010') {
                sb.append("%0" + Integer.toHexString(c));
                continue;
            }
            sb.append("%" + Integer.toHexString(c));
        }
        Object[] messageArray = new Object[]{sb.toString()};
        String command = null;
        boolean found = false;
        try {
            for (int i = 0; i < exec.length && !found; ++i) {
                try {
                    String t;
                    command = MessageFormat.format(exec[i], messageArray);
                    Vector<String> argsVector = new Vector<String>();
                    BrowserCommandLexer lex = new BrowserCommandLexer(new StringReader(command));
                    while ((t = lex.getNextToken()) != null) {
                        argsVector.add(t);
                    }
                    String[] args = new String[argsVector.size()];
                    args = argsVector.toArray(args);
                    boolean useShortCut = false;
                    if (args[0].equals("rundll32") && args[1].equals("url.dll,FileProtocolHandler")) {
                        if (args[2].startsWith("file:/")) {
                            if (args[2].charAt(6) != '/') {
                                args[2] = "file://" + args[2].substring(6);
                            }
                            if (args[2].charAt(7) != '/') {
                                args[2] = "file:///" + args[2].substring(7);
                            }
                            useShortCut = true;
                        } else if (args[2].toLowerCase().endsWith("html") || args[2].toLowerCase().endsWith("htm")) {
                            useShortCut = true;
                        }
                    }
                    if (useShortCut) {
                        File shortcut = File.createTempFile("OpenInBrowser", ".url");
                        shortcut = shortcut.getCanonicalFile();
                        shortcut.deleteOnExit();
                        PrintWriter out = new PrintWriter(new FileWriter(shortcut));
                        out.println("[InternetShortcut]");
                        out.println("URL=" + args[2]);
                        out.close();
                        args[2] = shortcut.getCanonicalPath();
                    }
                    Process p = Runtime.getRuntime().exec(args);
                    for (int j = 0; j < 2; ++j) {
                        try {
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (InterruptedException inte) {
                            // empty catch block
                        }
                    }
                    if (p.exitValue() != 0) continue;
                    found = true;
                    continue;
                }
                catch (IOException x) {
                    MWClient.mwClientLog.clientErrLog(labels.getString("warning") + " " + x.getMessage());
                }
            }
            if (found) return;
            throw new IOException(labels.getString("failed"));
        }
        catch (IllegalThreadStateException e) {
            // empty catch block
        }
    }

    public static void displayURLs(String[] urls) throws IOException {
        int i;
        if (urls == null || urls.length == 0) {
            return;
        }
        if (urls.length == 1) {
            Browser.displayURL(urls[0]);
            return;
        }
        File shortcut = File.createTempFile("DisplayURLs", ".html");
        shortcut = shortcut.getCanonicalFile();
        shortcut.deleteOnExit();
        PrintWriter out = new PrintWriter(new FileWriter(shortcut));
        out.println("<html>");
        out.println("<head>");
        out.println("<title>" + labels.getString("html.openurls") + "</title>");
        out.println("<script language=\"javascript\" type=\"text/javascript\">");
        out.println("function displayURLs(){");
        for (i = 1; i < urls.length; ++i) {
            out.println("window.open(\"" + urls[i] + "\", \"_blank\", \"toolbar=yes,location=yes,directories=yes,status=yes,menubar=yes,scrollbars=yes,resizable=yes\");");
        }
        out.println("location.href=\"" + urls[0] + "\";");
        out.println("}");
        out.println("</script>");
        out.println("</head>");
        out.println("<body onload=\"javascript:displayURLs()\">");
        out.println("<noscript>");
        for (i = 0; i < urls.length; ++i) {
            out.println("<a target=\"_blank\" href=\"" + urls[i] + "\">" + urls[i] + "</a><br>");
        }
        out.println("</noscript>");
        out.println("</body>");
        out.println("</html>");
        out.close();
        Browser.displayURL(shortcut.toURL().toString());
    }

    public static void displayURLinNew(String url) throws IOException {
        Browser.displayURLsinNew(new String[]{url});
    }

    public static void displayURLsinNew(String[] urls) throws IOException {
        int i;
        if (urls == null || urls.length == 0) {
            return;
        }
        File shortcut = File.createTempFile("DisplayURLs", ".html");
        shortcut.deleteOnExit();
        shortcut = shortcut.getCanonicalFile();
        PrintWriter out = new PrintWriter(new FileWriter(shortcut));
        out.println("<html>");
        out.println("<head>");
        out.println("<title>" + labels.getString("html.openurls") + "</title>");
        out.println("<script language=\"javascript\" type=\"text/javascript\">");
        out.println("function displayURLs(){");
        out.println("var hlength = 0;");
        out.println("try {");
        out.println("hlength = history.length;");
        out.println("} catch (e) {}");
        out.println("if (hlength>0) {");
        out.println("window.open(\"" + urls[0] + "\", \"_blank\", \"toolbar=yes,location=yes,directories=yes,status=yes,menubar=yes,scrollbars=yes,resizable=yes\");");
        out.println("}");
        for (i = 1; i < urls.length; ++i) {
            out.println("window.open(\"" + urls[i] + "\", \"_blank\", \"toolbar=yes,location=yes,directories=yes,status=yes,menubar=yes,scrollbars=yes,resizable=yes\");");
        }
        out.println("if (hlength==0) {");
        out.println("location.href=\"" + urls[0] + "\";");
        out.println("} else {");
        out.println("history.back()");
        out.println("}");
        out.println("}");
        out.println("</script>");
        out.println("</head>");
        out.println("<body onload=\"javascript:displayURLs()\">");
        out.println("<noscript>");
        for (i = 0; i < urls.length; ++i) {
            out.println("<a target=\"_blank\" href=\"" + urls[i] + "\">" + urls[i] + "</a><br>");
        }
        out.println("</noscript>");
        out.println("</body>");
        out.println("</html>");
        out.close();
        Browser.displayURL(shortcut.toURL().toString());
    }

    public static void displayURL(String url, String namedWindow) throws IOException {
        Browser.displayURLs(new String[]{url}, new String[]{namedWindow});
    }

    public static void displayURLs(String[] urls, String[] namedWindows) throws IOException {
        int i;
        if (urls == null || urls.length == 0) {
            return;
        }
        File shortcut = File.createTempFile("DisplayURLs", ".html");
        shortcut.deleteOnExit();
        shortcut = shortcut.getCanonicalFile();
        PrintWriter out = new PrintWriter(new FileWriter(shortcut));
        out.println("<html>");
        out.println("<head>");
        out.println("<title>" + labels.getString("html.openurls") + "</title>");
        out.println("<base target=\"" + (namedWindows == null || namedWindows.length == 0 || namedWindows[0] == null ? "_blank" : namedWindows[0]) + "\">");
        out.println("<script language=\"javascript\" type=\"text/javascript\">");
        for (i = 1; i < urls.length; ++i) {
            out.println("window.open(\"" + urls[i] + "\", \"" + (namedWindows == null || namedWindows.length <= i || namedWindows[i] == null ? "_blank" : namedWindows[i]) + "\", \"toolbar=yes,location=yes,directories=yes,status=yes,menubar=yes,scrollbars=yes,resizable=yes\");");
        }
        out.println("location.href=\"" + urls[0] + "\";");
        out.println("</script>");
        out.println("</head>");
        out.println("<body onload=\"javascript:displayURLs()\">");
        out.println("<noscript>");
        for (i = 0; i < urls.length; ++i) {
            out.println("<a target=\"" + (namedWindows == null || namedWindows.length == 0 || namedWindows[0] == null ? "_blank" : namedWindows[0]) + "\" href=\"" + urls[i] + "\">" + urls[i] + "</a><br>");
        }
        out.println("</noscript>");
        out.println("</body>");
        out.println("</html>");
        out.close();
        Browser.displayURL(shortcut.toURL().toString());
    }

    public static void displayURLs(String[] urls, String namedWindow) throws IOException {
        Browser.displayURLs(urls, new String[]{namedWindow});
    }

    public static void main(String[] args) {
        try {
            Browser.init();
            if (Browser.dialogConfiguration(null)) {
                if (args.length == 0) {
                    Browser.displayURLs(new String[]{"http://www.google.com/", "http://dmoz.org/", "http://ostermiller.org"}, "fun");
                } else if (args.length == 1) {
                    Browser.displayURL(args[0], "fun");
                } else {
                    Browser.displayURLs(args, "fun");
                }
            }
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException x) {}
        }
        catch (IOException e) {
            MWClient.mwClientLog.clientErrLog(e.getMessage());
        }
        System.exit(0);
    }

    public static boolean dialogConfiguration(Frame owner) {
        Browser.dialogConfiguration(owner, null);
        return dialog.changed();
    }

    public static boolean dialogConfiguration(Frame owner, Properties props) {
        if (dialog == null) {
            dialog = new BrowserDialog(owner);
        }
        if (props != null) {
            Browser.dialog.setProps(props);
        }
        dialog.setVisible(true);
        return dialog.changed();
    }

    public static JPanel getDialogPanel(Window parent) {
        dialogParent = parent;
        if (dialogPanel == null) {
            commandLinesArea = new JTextArea("", 8, 40);
            JScrollPane scrollpane = new JScrollPane(commandLinesArea);
            resetButton = new JButton(labels.getString("dialog.reset"));
            browseButton = new JButton(labels.getString("dialog.browse"));
            commandLinesLabel = new JLabel(labels.getString("dialog.commandLines"));
            description = new JTextArea(labels.getString("dialog.description"));
            description.setEditable(false);
            description.setOpaque(false);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    Object source = e.getSource();
                    if (source == resetButton) {
                        Browser.setCommands(Browser.defaultCommands());
                    } else if (source == browseButton) {
                        if (fileChooser == null) {
                            fileChooser = new JFileChooser();
                        }
                        if (fileChooser.showOpenDialog(dialogParent) == 0) {
                            String commands;
                            String app = fileChooser.getSelectedFile().getPath();
                            StringBuffer sb = new StringBuffer(2 * app.length());
                            for (int i = 0; i < app.length(); ++i) {
                                char c = app.charAt(i);
                                if (c == '\"' || c == '\\') {
                                    sb.append('\\');
                                }
                                sb.append(c);
                            }
                            app = sb.toString();
                            if (app.indexOf(" ") != -1) {
                                app = '\"' + app + '\"';
                            }
                            if ((commands = commandLinesArea.getText()).length() != 0 && !commands.endsWith("\n") && !commands.endsWith("\r")) {
                                commands = commands + "\n";
                            }
                            commandLinesArea.setText(commands + app + " {0}");
                        }
                    }
                }
            };
            GridBagLayout gridbag = new GridBagLayout();
            GridBagConstraints c = new GridBagConstraints();
            c.insets.top = 5;
            c.insets.bottom = 5;
            dialogPanel = new JPanel(gridbag);
            dialogPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 5, 20));
            c.gridwidth = 0;
            c.anchor = 17;
            gridbag.setConstraints(description, c);
            dialogPanel.add(description);
            c.gridy = 1;
            c.gridwidth = -1;
            gridbag.setConstraints(commandLinesLabel, c);
            dialogPanel.add(commandLinesLabel);
            JPanel buttonPanel = new JPanel();
            c.anchor = 13;
            browseButton.addActionListener(actionListener);
            buttonPanel.add(browseButton);
            resetButton.addActionListener(actionListener);
            buttonPanel.add(resetButton);
            gridbag.setConstraints(buttonPanel, c);
            dialogPanel.add(buttonPanel);
            c.gridy = 2;
            c.gridwidth = 0;
            c.anchor = 17;
            gridbag.setConstraints(scrollpane, c);
            dialogPanel.add(scrollpane);
        }
        return dialogPanel;
    }

    private static void setCommands(String[] newExec) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; newExec != null && i < newExec.length; ++i) {
            sb.append(newExec[i]).append('\n');
        }
        commandLinesArea.setText(sb.toString());
    }

    public static void initPanel() {
        Browser.setCommands(exec);
    }

    public static void userOKedPanelChanges() {
        StringTokenizer tok = new StringTokenizer(commandLinesArea.getText(), "\r\n", false);
        int count = tok.countTokens();
        String[] exec = new String[count];
        for (int i = 0; i < count; ++i) {
            exec[i] = tok.nextToken();
        }
        Browser.exec = exec;
    }

    static {
        labels = ResourceBundle.getBundle("MegaMekNETClient.GUI.Browser", Locale.US);
        exec = null;
        dialogPanel = null;
        dialogParent = null;
    }

    private static class BrowserDialog
    extends JDialog {
        private JButton okButton;
        private JButton cancelButton;
        private JLabel commandLinesLabel;
        private boolean pressed_OK = false;

        private void setProps(Properties props) {
            if (props.containsKey("MegaMekNETClient.GUI.BrowserDialog.title")) {
                this.setTitle(props.getProperty("MegaMekNETClient.GUI.BrowserDialog.title"));
            }
            if (props.containsKey("MegaMekNETClient.GUI.BrowserDialog.description")) {
                description.setText(props.getProperty("MegaMekNETClient.GUI.BrowserDialog.description"));
            }
            if (props.containsKey("MegaMekNETClient.GUI.BrowserDialog.label")) {
                this.commandLinesLabel.setText(props.getProperty("MegaMekNETClient.GUI.BrowserDialog.label"));
            }
            if (props.containsKey("MegaMekNETClient.GUI.BrowserDialog.defaults")) {
                resetButton.setText(props.getProperty("MegaMekNETClient.GUI.BrowserDialog.defaults"));
            }
            if (props.containsKey("MegaMekNETClient.GUI.BrowserDialog.browse")) {
                browseButton.setText(props.getProperty("MegaMekNETClient.GUI.BrowserDialog.browse"));
            }
            if (props.containsKey("MegaMekNETClient.GUI.BrowserDialog.ok")) {
                this.okButton.setText(props.getProperty("MegaMekNETClient.GUI.BrowserDialog.ok"));
            }
            if (props.containsKey("MegaMekNETClient.GUI.BrowserDialog.cancel")) {
                this.cancelButton.setText(props.getProperty("MegaMekNETClient.GUI.BrowserDialog.cancel"));
            }
            this.pack();
        }

        public boolean changed() {
            return this.pressed_OK;
        }

        public BrowserDialog(Frame parent) {
            super(parent, labels.getString("dialog.title"), true);
            this.setLocationRelativeTo(parent);
        }

        protected void dialogInit() {
            super.dialogInit();
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add((Component)Browser.getDialogPanel(this), "Center");
            JPanel panel = new JPanel(new FlowLayout());
            this.okButton = new JButton(labels.getString("dialog.ok"));
            this.okButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BrowserDialog.this.pressed_OK = true;
                    BrowserDialog.this.setVisible(false);
                }
            });
            panel.add(this.okButton);
            this.cancelButton = new JButton(labels.getString("dialog.cancel"));
            this.cancelButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BrowserDialog.this.pressed_OK = false;
                    BrowserDialog.this.setVisible(false);
                }
            });
            panel.add(this.cancelButton);
            this.getContentPane().add((Component)panel, "South");
            this.pack();
        }

        public void setVisible(boolean show) {
            Browser.initPanel();
            super.setVisible(show);
            if (this.pressed_OK) {
                Browser.userOKedPanelChanges();
            }
        }
    }
}

