/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.CConfig;
import client.CUser;
import client.MWClient;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.TransferHandler;
import javax.swing.border.LineBorder;

public class CUserListPanel
extends JPanel
implements ActionListener {
    public static int SORTMODE_NAME = 0;
    public static int SORTMODE_HOUSE = 1;
    public static int SORTMODE_EXP = 2;
    public static int SORTMODE_RATING = 3;
    public static int SORTMODE_STATUS = 4;
    public static int SORTMODE_USERLEVEL = 5;
    public static int SORTMODE_COUNTRY = 6;
    public static int SORTORDER_ASCENDING = 1;
    public static int SORTORDER_DESCENDING = 2;
    MWClient mwclient;
    CConfig Config;
    boolean LoggedIn = false;
    boolean Dedicateds;
    JScrollPane UserListSP;
    JList UserList;
    CUserListModel Users;
    JPanel countPanel = new JPanel();
    JLabel CountLabel = new JLabel();
    JButton ActivityButton = new JButton();
    UserListPopupListener UserListPopup = new UserListPopupListener();

    public CUserListPanel(MWClient client) {
        this.mwclient = client;
        this.Dedicateds = this.mwclient.getConfig().isParam("USERLISTDEDICATEDS");
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(180, 480));
        this.setMinimumSize(new Dimension(120, 100));
        this.setMaximumSize(new Dimension(180, 2000));
        this.Users = new CUserListModel(this.mwclient);
        this.UserList = new JList(this.Users);
        this.UserList.setAlignmentX(0.0f);
        this.UserList.addMouseListener(this.UserListPopup);
        this.UserList.setCellRenderer(this.Users.getRenderer());
        this.UserList.setTransferHandler(new ListMekTransferHandler());
        this.UserListSP = new JScrollPane(this.UserList);
        this.UserListSP.setPreferredSize(new Dimension(180, 480));
        this.UserListSP.setMinimumSize(new Dimension(180, 100));
        this.UserListSP.setMaximumSize(new Dimension(180, 2000));
        this.UserListSP.setBorder(new LineBorder(Color.black));
        this.UserListSP.setViewportView(this.UserList);
        this.add((Component)this.UserListSP, "Center");
        this.CountLabel.setAlignmentX(0.5f);
        this.CountLabel.setAlignmentY(0.5f);
        this.CountLabel.setBorder(BorderFactory.createEmptyBorder(3, 2, 2, 2));
        this.CountLabel.setText("Player Count: " + this.UserList.getModel().getSize());
        if (this.mwclient.getConfig().isParam("USERLISTCOUNT")) {
            this.CountLabel.setVisible(true);
        } else {
            this.CountLabel.setVisible(false);
        }
        this.ActivityButton.setText("Waiting ...");
        this.ActivityButton.setEnabled(false);
        this.ActivityButton.setAlignmentX(0.5f);
        this.ActivityButton.setAlignmentY(0.5f);
        this.ActivityButton.addActionListener(this);
        if (this.mwclient.getConfig().isParam("USERLISTACTIVITYBTN")) {
            this.ActivityButton.setVisible(true);
        } else {
            this.ActivityButton.setVisible(false);
        }
        this.countPanel.setLayout(new BoxLayout(this.countPanel, 1));
        this.countPanel.add(this.ActivityButton);
        this.countPanel.add(this.CountLabel);
        this.countPanel.setBorder(BorderFactory.createEmptyBorder(4, 2, 3, 2));
        this.add((Component)this.countPanel, "South");
        String mode = this.mwclient.getConfig().getParam("SORTMODE");
        if (mode.equals("HOUSE")) {
            ((CUserListModel)this.UserList.getModel()).setSortMode(SORTMODE_HOUSE);
        } else if (mode.equals("EXP")) {
            ((CUserListModel)this.UserList.getModel()).setSortMode(SORTMODE_EXP);
        } else if (mode.equals("RATING")) {
            ((CUserListModel)this.UserList.getModel()).setSortMode(SORTMODE_RATING);
        } else if (mode.equals("STATUS")) {
            ((CUserListModel)this.UserList.getModel()).setSortMode(SORTMODE_STATUS);
        } else if (mode.equals("USERLEVEL")) {
            ((CUserListModel)this.UserList.getModel()).setSortMode(SORTMODE_USERLEVEL);
        } else if (mode.equals("COUNTRY")) {
            ((CUserListModel)this.UserList.getModel()).setSortMode(SORTMODE_COUNTRY);
        } else {
            ((CUserListModel)this.UserList.getModel()).setSortMode(SORTMODE_NAME);
        }
        String order = this.mwclient.getConfig().getParam("SORTORDER");
        if (order.equals("DESCENDING")) {
            ((CUserListModel)this.UserList.getModel()).setSortOrder(SORTORDER_DESCENDING);
        } else {
            ((CUserListModel)this.UserList.getModel()).setSortOrder(SORTORDER_ASCENDING);
        }
    }

    public CUserListModel getUsers() {
        return this.Users;
    }

    public JList getUserList() {
        return this.UserList;
    }

    public synchronized void refresh() {
        try {
            ((CUserListModel)this.UserList.getModel()).refreshModel();
        }
        catch (Exception ex) {
            MWClient.mwClientLog.clientErrLog(ex);
        }
        this.CountLabel.setText("Player Count: " + this.UserList.getModel().getSize());
    }

    public void setLoggedIn(boolean tloggedin) {
        this.LoggedIn = tloggedin;
        if (this.LoggedIn) {
            this.ActivityButton.setEnabled(true);
            this.ActivityButton.setText("Activate");
        } else {
            this.ActivityButton.setEnabled(true);
            this.ActivityButton.setText("Login");
        }
    }

    public void setActivateButtonText(String s) {
        this.ActivityButton.setText(s);
    }

    public void setActivityButtonEnabled(boolean b) {
        this.ActivityButton.setEnabled(b);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.ActivityButton) {
            if (this.mwclient.getMyStatus() == MWClient.STATUS_LOGGEDIN) {
                this.mwclient.sendChat("/c activate");
            } else if (this.mwclient.getMyStatus() == MWClient.STATUS_ACTIVE) {
                this.mwclient.sendChat("/c deactivate");
            } else if (this.mwclient.getMyStatus() == MWClient.STATUS_LOGGEDOUT) {
                this.mwclient.sendChat("/c login");
            }
        }
    }

    public class ListMekTransferHandler
    extends TransferHandler {
        protected Transferable createTransferable(JComponent c) {
            return null;
        }

        public int getSourceActions(JComponent c) {
            return 2;
        }

        public boolean importData(JComponent c, Transferable t) {
            JList userlist = null;
            CUserListModel userlistmodel = null;
            String data = null;
            if (this.canImport(c, t.getTransferDataFlavors())) {
                try {
                    userlist = (JList)c;
                    data = (String)t.getTransferData(DataFlavor.stringFlavor);
                }
                catch (UnsupportedFlavorException ufe) {
                    return false;
                }
                catch (IOException ioe) {
                    return false;
                }
                if (data == null || data.equals("")) {
                    return false;
                }
                userlistmodel = (CUserListModel)userlist.getModel();
                int row = userlist.getSelectedIndex();
                if (row > -1 && row < userlistmodel.getSize()) {
                    CUser user = userlistmodel.getUser(row);
                    if (data.indexOf(",") < 0) {
                        CUserListPanel.this.mwclient.processGUIInput(MWClient.GUI_PREFIX + "c transferunit#" + user.getName() + "#" + data);
                        return true;
                    }
                }
            }
            return false;
        }

        protected void exportDone(JComponent c, Transferable data, int action) {
        }

        public boolean canImport(JComponent c, DataFlavor[] flavors) {
            for (int i = 0; i < flavors.length; ++i) {
                if (!DataFlavor.stringFlavor.equals(flavors[i])) continue;
                return true;
            }
            return false;
        }
    }

    public static class CUserListModel
    extends AbstractListModel {
        SortedSet Users;
        UserListCellRenderer Renderer;
        MWClient mwclient;
        boolean Dedicateds;

        public CUserListModel(MWClient client) {
            this.mwclient = client;
            this.Dedicateds = this.mwclient.getConfig().isParam("USERLISTDEDICATEDS");
            this.Users = Collections.synchronizedSortedSet(new TreeSet(new UserComparator()));
            this.Renderer = new UserListCellRenderer(this);
        }

        public synchronized void clear() {
            this.Users.clear();
        }

        public void add(Object o) {
            this.Users.add(o);
        }

        public synchronized void remove(Object o) {
            this.Users.remove(o);
        }

        public synchronized void addAll(Collection c) {
            this.Users.addAll(c);
        }

        public synchronized int getSize() {
            return this.Users.size();
        }

        public synchronized void refreshModel() {
            Collection users = null;
            this.fireIntervalRemoved(this, 0, this.Users.size());
            this.clear();
            if (this.Dedicateds) {
                try {
                    this.addAll(this.mwclient.getUsers());
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                    this.addAll(this.mwclient.getUsers());
                }
            } else {
                try {
                    users = this.mwclient.getUsers();
                    for (CUser user : users) {
                        if (user.getName().startsWith("[Dedicated] ")) continue;
                        this.add(user);
                    }
                }
                catch (Exception ex) {
                    MWClient.mwClientLog.clientErrLog(ex);
                }
            }
            this.fireIntervalAdded(this, 0, this.Users.size());
        }

        public void setDedicateds(boolean dedicateds) {
            this.Dedicateds = dedicateds;
        }

        public void setSortMode(int tsortmode) {
            ((UserComparator)this.Users.comparator()).setMode(tsortmode);
            this.refreshModel();
        }

        public int getSortMode() {
            return ((UserComparator)this.Users.comparator()).getMode();
        }

        public void setSortOrder(int tsortorder) {
            ((UserComparator)this.Users.comparator()).setOrder(tsortorder);
            this.refreshModel();
        }

        public int getSortOrder() {
            return ((UserComparator)this.Users.comparator()).getOrder();
        }

        public synchronized Object getElementAt(int index) {
            if (index < this.Users.size()) {
                return ((CUser)this.Users.toArray()[index]).getName();
            }
            return null;
        }

        public synchronized CUser getUser(int index) {
            if (index < this.Users.size()) {
                return (CUser)this.Users.toArray()[index];
            }
            return null;
        }

        public synchronized CUser getUser(String name) {
            for (CUser user : this.Users) {
                if (!user.getName().equals(name)) continue;
                return user;
            }
            return new CUser();
        }

        public UserListCellRenderer getRenderer() {
            return this.Renderer;
        }

        public class UserComparator
        implements Comparator {
            int Mode = SORTMODE_NAME;
            int Order = SORTORDER_ASCENDING;

            public int compare(Object o1, Object o2) {
                CUser user1 = null;
                CUser user2 = null;
                int result = 0;
                if (this.Order == SORTORDER_DESCENDING) {
                    user1 = (CUser)o2;
                    user2 = (CUser)o1;
                } else {
                    user1 = (CUser)o1;
                    user2 = (CUser)o2;
                }
                if (this.Mode == SORTMODE_NAME) {
                    return user1.getName().compareToIgnoreCase(user2.getName());
                }
                if (this.Mode == SORTMODE_HOUSE) {
                    result = user1.getHouse().compareToIgnoreCase(user2.getHouse());
                }
                if (this.Mode == SORTMODE_COUNTRY) {
                    result = user1.getCountry().compareToIgnoreCase(user2.getCountry());
                }
                if (this.Mode == SORTMODE_EXP) {
                    result = new Integer(user2.getExp()).compareTo(new Integer(user1.getExp()));
                }
                if (this.Mode == SORTMODE_RATING) {
                    result = new Float(user2.getRating()).compareTo(new Float(user1.getRating()));
                }
                if (this.Mode == SORTMODE_STATUS) {
                    result = new Integer(user2.getStatus()).compareTo(new Integer(user1.getStatus()));
                }
                if (this.Mode == SORTMODE_USERLEVEL) {
                    result = new Integer(user2.getUserlevel()).compareTo(new Integer(user1.getUserlevel()));
                }
                if (result == 0) {
                    if (this.Order == SORTORDER_DESCENDING) {
                        return user2.getName().compareToIgnoreCase(user1.getName());
                    }
                    return user1.getName().compareToIgnoreCase(user2.getName());
                }
                return result;
            }

            public boolean equals(Object o1, Object o2) {
                return ((CUser)o1).getName().equals(((CUser)o2).getName());
            }

            public void setMode(int tmode) {
                if (tmode == SORTMODE_NAME || tmode == SORTMODE_HOUSE || tmode == SORTMODE_EXP || tmode == SORTMODE_RATING || tmode == SORTMODE_STATUS || tmode == SORTMODE_USERLEVEL || tmode == SORTMODE_COUNTRY) {
                    this.Mode = tmode;
                }
            }

            public int getMode() {
                return this.Mode;
            }

            public void setOrder(int torder) {
                if (torder == SORTORDER_ASCENDING || torder == SORTORDER_DESCENDING) {
                    this.Order = torder;
                }
            }

            public int getOrder() {
                return this.Order;
            }
        }

        class UserListCellRenderer
        extends JLabel
        implements ListCellRenderer {
            MWClient mwclient;
            CUserListModel Owner;
            boolean LoggedIn = false;
            boolean TextBold = true;
            boolean TextColor = true;
            boolean TextImage = true;
            ImageIcon LogoutImage;
            ImageIcon ReserveImage;
            ImageIcon ActiveImage;
            ImageIcon FightImage;

            public UserListCellRenderer(CUserListModel towner) {
                this.Owner = towner;
                this.mwclient = this.Owner.mwclient;
                this.TextBold = this.mwclient.getConfig().isParam("USERLISTBOLD");
                this.TextColor = this.mwclient.getConfig().isParam("USERLISTCOLOR");
                this.TextImage = this.mwclient.getConfig().isParam("USERLISTIMAGE");
                this.LogoutImage = this.mwclient.getConfig().getLogoutImage();
                this.ReserveImage = this.mwclient.getConfig().getReserveImage();
                this.ActiveImage = this.mwclient.getConfig().getActiveImage();
                this.FightImage = this.mwclient.getConfig().getFightImage();
                this.setOpaque(true);
            }

            public void setLoggedIn(boolean tloggedin) {
                this.LoggedIn = tloggedin;
            }

            public void refreshParams() {
                this.TextBold = this.mwclient.getConfig().isParam("USERLISTBOLD");
                this.TextColor = this.mwclient.getConfig().isParam("USERLISTCOLOR");
                this.TextImage = this.mwclient.getConfig().isParam("USERLISTIMAGE");
                this.LogoutImage = this.mwclient.getConfig().getLogoutImage();
                this.ReserveImage = this.mwclient.getConfig().getReserveImage();
                this.ActiveImage = this.mwclient.getConfig().getActiveImage();
                this.FightImage = this.mwclient.getConfig().getFightImage();
            }

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean selected, boolean focus) {
                String currString;
                int userlevel = 0;
                CUser user = this.Owner.getUser(index);
                if (user == null) {
                    return null;
                }
                userlevel = user.getUserlevel();
                if (userlevel < 30) {
                    this.setText(user.getName());
                }
                if (userlevel >= 30 && userlevel < 100) {
                    this.setText("^ " + user.getName());
                }
                if (userlevel >= 100 && userlevel < 200) {
                    this.setText("* " + user.getName());
                }
                if (userlevel >= 200) {
                    this.setText("@ " + user.getName());
                }
                boolean isOnNoPlay = false;
                if (this.mwclient.getPlayer().getAdminExcludes().contains(user.getName().toLowerCase())) {
                    isOnNoPlay = true;
                } else if (this.mwclient.getPlayer().getPlayerExcludes().contains(user.getName().toLowerCase())) {
                    isOnNoPlay = true;
                }
                String searchString = user.getName().trim();
                int isMuted = 0;
                String ignoreList = this.mwclient.getConfig().getParam("IGNOREPUBLIC");
                StringTokenizer it = new StringTokenizer(ignoreList, ",");
                while (it.hasMoreTokens()) {
                    currString = it.nextToken().trim();
                    if (!currString.equalsIgnoreCase(searchString)) continue;
                    ++isMuted;
                }
                ignoreList = this.mwclient.getConfig().getParam("IGNOREPRIVATE");
                it = new StringTokenizer(ignoreList, ",");
                while (it.hasMoreTokens()) {
                    currString = it.nextToken().trim();
                    if (!currString.equalsIgnoreCase(searchString)) continue;
                    ++isMuted;
                }
                if (user.getHouse().equals(this.mwclient.getPlayer().getHouse())) {
                    ignoreList = this.mwclient.getConfig().getParam("IGNOREHOUSE");
                    it = new StringTokenizer(ignoreList, ",");
                    while (it.hasMoreTokens()) {
                        currString = it.nextToken();
                        if (!currString.equalsIgnoreCase(searchString)) continue;
                        ++isMuted;
                    }
                }
                String muteUps = "";
                for (int i = 1; i < isMuted; ++i) {
                    muteUps = muteUps + "+";
                }
                if (isMuted > 0 && isOnNoPlay) {
                    this.setText(this.getText() + " [muted" + muteUps + ", np]");
                } else if (isMuted > 0) {
                    this.setText(this.getText() + " [muted" + muteUps + "]");
                } else if (isOnNoPlay) {
                    this.setText(this.getText() + " [np]");
                }
                if (selected) {
                    this.setForeground(list.getSelectionForeground());
                    this.setBackground(list.getSelectionBackground());
                } else {
                    this.setBackground(list.getBackground());
                    if (this.TextColor && this.LoggedIn) {
                        this.setForeground(user.getRGBColor());
                    } else {
                        this.setForeground(Color.black);
                    }
                }
                if (this.LoggedIn) {
                    int status = user.getStatus();
                    if (status == MWClient.STATUS_LOGGEDOUT) {
                        this.setFont(this.getFont().deriveFont(0));
                        if (this.TextImage) {
                            try {
                                this.setIcon(this.LogoutImage);
                            }
                            catch (Exception ex) {
                                MWClient.mwClientLog.clientErrLog(ex);
                            }
                        }
                    } else {
                        if (this.TextBold) {
                            this.setFont(this.getFont().deriveFont(1));
                        } else {
                            this.setFont(this.getFont().deriveFont(0));
                        }
                        if (this.TextImage) {
                            if (status == MWClient.STATUS_LOGGEDIN) {
                                try {
                                    this.setIcon(this.ReserveImage);
                                }
                                catch (Exception ex) {
                                    MWClient.mwClientLog.clientErrLog(ex);
                                }
                            }
                            if (status == MWClient.STATUS_ACTIVE) {
                                try {
                                    this.setIcon(this.ActiveImage);
                                }
                                catch (Exception ex) {
                                    MWClient.mwClientLog.clientErrLog(ex);
                                }
                            }
                            if (status == MWClient.STATUS_FIGHTING) {
                                try {
                                    this.setIcon(this.FightImage);
                                }
                                catch (Exception ex) {
                                    MWClient.mwClientLog.clientErrLog(ex);
                                }
                            }
                        } else {
                            this.setIcon(null);
                        }
                    }
                    this.setIconTextGap(7);
                    this.setToolTipText(user.getInfo());
                } else {
                    this.setFont(this.getFont().deriveFont(0));
                    this.setIcon(null);
                    this.setToolTipText(user.getShortInfo());
                }
                return this;
            }
        }
    }

    class UserListPopupListener
    extends MouseAdapter
    implements ActionListener {
        UserListPopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        public void mouseClicked(MouseEvent e) {
            int row;
            if (e.getClickCount() == 2 && (row = CUserListPanel.this.UserList.locationToIndex(e.getPoint())) > -1 && row < CUserListPanel.this.UserList.getModel().getSize()) {
                CUser user = ((CUserListModel)CUserListPanel.this.UserList.getModel()).getUser(row);
                String input = MWClient.GUI_PREFIX + "mail " + user.getName() + ", ";
                input = input + CUserListPanel.this.mwclient.getMainFrame().getMainPanel().getCommPanel().getInput();
                CUserListPanel.this.mwclient.getMainFrame().getMainPanel().getCommPanel().setInput(input);
                CUserListPanel.this.mwclient.getMainFrame().getMainPanel().getCommPanel().focusInputField();
            }
        }

        private void maybeShowPopup(MouseEvent e) {
            int row = -1;
            JPopupMenu popup = new JPopupMenu();
            if (e.isPopupTrigger() && (row = CUserListPanel.this.UserList.locationToIndex(e.getPoint())) > -1 && row < CUserListPanel.this.UserList.getModel().getSize()) {
                JMenuItem item;
                CUser user = ((CUserListModel)CUserListPanel.this.UserList.getModel()).getUser(row);
                if (!user.getName().equalsIgnoreCase(CUserListPanel.this.mwclient.getPlayer().getName())) {
                    String currString;
                    item = new JMenuItem("<HTML>Mail " + user.getName() + "</b></HTML>");
                    item.setActionCommand("MA|" + row);
                    item.addActionListener(this);
                    popup.add(item);
                    if (CUserListPanel.this.LoggedIn && user.getStatus() != MWClient.STATUS_LOGGEDOUT) {
                        JMenu sendMen = new JMenu("Send");
                        item = new JMenuItem("Send " + CUserListPanel.this.mwclient.moneyOrFluMessage(true, false, -2));
                        item.setActionCommand("MO|" + row);
                        item.addActionListener(this);
                        sendMen.add(item);
                        item = new JMenuItem("Send Unit");
                        item.setActionCommand("TU|" + row);
                        item.addActionListener(this);
                        sendMen.add(item);
                        if (Boolean.valueOf(CUserListPanel.this.mwclient.getserverConfigs("AllowPersonalPilotQueues")).booleanValue()) {
                            item = new JMenuItem("Send Pilot");
                            item.setActionCommand("TP|" + row);
                            item.addActionListener(this);
                            sendMen.add(item);
                        }
                        if (Boolean.valueOf(CUserListPanel.this.mwclient.getserverConfigs("UseDirectSell")).booleanValue()) {
                            item = new JMenuItem("Direct Sell Unit");
                            item.setActionCommand("DSU|" + row);
                            item.addActionListener(this);
                            sendMen.add(item);
                        }
                        popup.add(sendMen);
                    }
                    JMenu blockMen = new JMenu("Block");
                    String searchString = user.getName();
                    boolean matched = false;
                    String ignoreList = CUserListPanel.this.mwclient.getConfig().getParam("IGNOREPUBLIC");
                    StringTokenizer st = new StringTokenizer(ignoreList, ",");
                    while (st.hasMoreTokens() && !matched) {
                        currString = st.nextToken().trim();
                        if (!currString.equalsIgnoreCase(searchString)) continue;
                        matched = true;
                    }
                    if (!matched) {
                        item = new JMenuItem("Mute (Main)");
                        item.setActionCommand("MU|" + row + "|PUBLIC");
                        item.addActionListener(this);
                        blockMen.add(item);
                    } else {
                        item = new JMenuItem("Unmute (Main)");
                        item.setActionCommand("UMU|" + row + "|PUBLIC");
                        item.addActionListener(this);
                        blockMen.add(item);
                    }
                    ignoreList = CUserListPanel.this.mwclient.getConfig().getParam("IGNOREPRIVATE");
                    st = new StringTokenizer(ignoreList, ",");
                    matched = false;
                    while (st.hasMoreTokens() && !matched) {
                        currString = st.nextToken().trim();
                        if (!currString.equalsIgnoreCase(searchString)) continue;
                        matched = true;
                    }
                    if (!matched) {
                        item = new JMenuItem("Mute (Private)");
                        item.setActionCommand("MU|" + row + "|PRIVATE");
                        item.addActionListener(this);
                        blockMen.add(item);
                    } else {
                        item = new JMenuItem("Unmute (Private)");
                        item.setActionCommand("UMU|" + row + "|PRIVATE");
                        item.addActionListener(this);
                        blockMen.add(item);
                    }
                    if (user.getHouse().equals(CUserListPanel.this.mwclient.getPlayer().getHouse())) {
                        ignoreList = CUserListPanel.this.mwclient.getConfig().getParam("IGNOREHOUSE");
                        st = new StringTokenizer(ignoreList, ",");
                        matched = false;
                        while (st.hasMoreTokens() && !matched) {
                            currString = st.nextToken().trim();
                            if (!currString.equalsIgnoreCase(searchString)) continue;
                            matched = true;
                        }
                        if (!matched) {
                            item = new JMenuItem("Mute (House)");
                            item.setActionCommand("MU|" + row + "|HOUSE");
                            item.addActionListener(this);
                            blockMen.add(item);
                        } else {
                            item = new JMenuItem("Unmute (House)");
                            item.setActionCommand("UMU|" + row + "|HOUSE");
                            item.addActionListener(this);
                            blockMen.add(item);
                        }
                    }
                    if (Integer.parseInt(CUserListPanel.this.mwclient.getserverConfigs("NoPlayListSize")) >= 1) {
                        if (CUserListPanel.this.LoggedIn && user.getStatus() != MWClient.STATUS_LOGGEDOUT) {
                            boolean isOnNoPlay = false;
                            if (CUserListPanel.this.mwclient.getPlayer().getAdminExcludes().contains(user.getName().toLowerCase())) {
                                isOnNoPlay = true;
                            } else if (CUserListPanel.this.mwclient.getPlayer().getPlayerExcludes().contains(user.getName().toLowerCase())) {
                                isOnNoPlay = true;
                            }
                            if (isOnNoPlay) {
                                item = new JMenuItem("Remove from No-Play");
                                item.setActionCommand("RNP|" + row);
                                item.addActionListener(this);
                                blockMen.add(item);
                            } else {
                                item = new JMenuItem("Add to No-Play");
                                item.setActionCommand("ANP|" + row);
                                item.addActionListener(this);
                                blockMen.add(item);
                            }
                        } else {
                            item = new JMenuItem("No-Play");
                            item.setEnabled(false);
                            blockMen.add(item);
                        }
                        popup.addSeparator();
                    }
                    popup.add(blockMen);
                }
                if (CUserListPanel.this.mwclient.isMod()) {
                    Object o;
                    URLClassLoader loader;
                    File loadJar;
                    try {
                        loadJar = new File("./MekWarsAdmin.jar");
                        if (!loadJar.exists()) {
                            MWClient.mwClientLog.clientErrLog("ModeratorUserlistPopupMenu creation skipped. No MekWarsAdmin.jar present.");
                        } else {
                            loader = new URLClassLoader(new URL[]{loadJar.toURL()});
                            Class<?> c = loader.loadClass("admin.ModeratorUserlistPopupMenu");
                            o = c.newInstance();
                            c.getDeclaredMethod("createMenu", MWClient.class, CUser.class, Integer.class, JList.class).invoke(o, CUserListPanel.this.mwclient, user, new Integer(row), CUserListPanel.this.UserList);
                            popup.add((JMenu)o);
                        }
                    }
                    catch (Exception ex) {
                        MWClient.mwClientLog.clientErrLog("ModeratorUserlistPopupMenu creation FAILED!");
                        MWClient.mwClientLog.clientErrLog(ex);
                    }
                    try {
                        loadJar = new File("./MekWarsAdmin.jar");
                        if (!loadJar.exists()) {
                            MWClient.mwClientLog.clientErrLog("AdminUserlistPopupMenu creation skipped. No MekWarsAdmin.jar present.");
                        } else {
                            loader = new URLClassLoader(new URL[]{loadJar.toURL()});
                            Class<?> c = loader.loadClass("admin.AdminUserlistPopupMenu");
                            o = c.newInstance();
                            c.getDeclaredMethod("createMenu", MWClient.class, CUser.class, Integer.class, JList.class).invoke(o, CUserListPanel.this.mwclient, user, new Integer(row), CUserListPanel.this.UserList);
                            if (((JMenu)o).getItemCount() > 0) {
                                popup.add((JMenu)o);
                            }
                        }
                    }
                    catch (Exception ex) {
                        MWClient.mwClientLog.clientErrLog("AdminUserlistPopupMenu creation FAILED!");
                        MWClient.mwClientLog.clientErrLog(ex);
                    }
                    popup.addSeparator();
                }
                if (((CUserListModel)CUserListPanel.this.UserList.getModel()).getSortOrder() == SORTORDER_DESCENDING) {
                    item = new JMenuItem(CUserListPanel.this.mwclient.getConfig().getText("UL.SOA"));
                    item.setActionCommand("SO|A");
                    item.addActionListener(this);
                    popup.add(item);
                } else {
                    item = new JMenuItem(CUserListPanel.this.mwclient.getConfig().getText("UL.SOD"));
                    item.setActionCommand("SO|D");
                    item.addActionListener(this);
                    popup.add(item);
                }
                JMenu sortSub = new JMenu("Sort By");
                popup.add(sortSub);
                item = new JMenuItem(CUserListPanel.this.mwclient.getConfig().getText("UL.SMN"));
                item.setActionCommand("SM|N");
                item.addActionListener(this);
                sortSub.add(item);
                if (CUserListPanel.this.LoggedIn) {
                    item = new JMenuItem(CUserListPanel.this.mwclient.getConfig().getText("UL.SMH"));
                    item.setActionCommand("SM|H");
                    item.addActionListener(this);
                    sortSub.add(item);
                    item = new JMenuItem(CUserListPanel.this.mwclient.getConfig().getText("UL.SME"));
                    item.setActionCommand("SM|E");
                    item.addActionListener(this);
                    sortSub.add(item);
                    item = new JMenuItem(CUserListPanel.this.mwclient.getConfig().getText("UL.SMR"));
                    item.setActionCommand("SM|R");
                    item.addActionListener(this);
                    sortSub.add(item);
                    item = new JMenuItem(CUserListPanel.this.mwclient.getConfig().getText("UL.SMS"));
                    item.setActionCommand("SM|S");
                    item.addActionListener(this);
                    sortSub.add(item);
                }
                item = new JMenuItem(CUserListPanel.this.mwclient.getConfig().getText("UL.SML"));
                item.setActionCommand("SM|L");
                item.addActionListener(this);
                sortSub.add(item);
                item = new JMenuItem(CUserListPanel.this.mwclient.getConfig().getText("UL.SMC"));
                item.setActionCommand("SM|C");
                item.addActionListener(this);
                sortSub.add(item);
                popup.addSeparator();
                JMenu settingSub = new JMenu("List Settings");
                popup.add(settingSub);
                item = new JCheckBoxMenuItem("Activity Button");
                if (CUserListPanel.this.mwclient.getConfig().isParam("USERLISTACTIVITYBTN")) {
                    item.setSelected(true);
                } else {
                    item.setSelected(false);
                }
                item.setActionCommand("ULA|" + !item.isSelected());
                item.addActionListener(this);
                settingSub.add(item);
                item = new JCheckBoxMenuItem("Bold Names");
                if (CUserListPanel.this.mwclient.getConfig().isParam("USERLISTBOLD")) {
                    item.setSelected(true);
                } else {
                    item.setSelected(false);
                }
                item.setActionCommand("ULB|" + !item.isSelected());
                item.addActionListener(this);
                settingSub.add(item);
                item = new JCheckBoxMenuItem("Colored Names");
                if (CUserListPanel.this.mwclient.getConfig().isParam("USERLISTCOLOR")) {
                    item.setSelected(true);
                } else {
                    item.setSelected(false);
                }
                item.setActionCommand("ULC|" + !item.isSelected());
                item.addActionListener(this);
                settingSub.add(item);
                item = new JCheckBoxMenuItem("Dedicated Hosts");
                if (CUserListPanel.this.Dedicateds) {
                    item.setSelected(true);
                } else {
                    item.setSelected(false);
                }
                item.setActionCommand("TD");
                item.addActionListener(this);
                settingSub.add(item);
                item = new JCheckBoxMenuItem("Player Count");
                if (CUserListPanel.this.mwclient.getConfig().isParam("USERLISTCOUNT")) {
                    item.setSelected(true);
                } else {
                    item.setSelected(false);
                }
                item.setActionCommand("ULN|" + !item.isSelected());
                item.addActionListener(this);
                settingSub.add(item);
                item = new JCheckBoxMenuItem("Status Images");
                if (CUserListPanel.this.mwclient.getConfig().isParam("USERLISTIMAGE")) {
                    item.setSelected(true);
                } else {
                    item.setSelected(false);
                }
                item.setActionCommand("ULI|" + !item.isSelected());
                item.addActionListener(this);
                settingSub.add(item);
                popup.show(e.getComponent(), e.getX(), e.getY());
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CUser user;
            StringTokenizer it;
            String newList;
            String ignoreList;
            String searchString;
            CUser user2;
            String mode;
            int row;
            String s = actionEvent.getActionCommand();
            StringTokenizer st = new StringTokenizer(s, "|");
            String command = st.nextToken();
            if (command.equals("MA") && st.hasMoreElements()) {
                command = st.nextToken();
                int row2 = Integer.parseInt(command);
                if (row2 > -1 && row2 < CUserListPanel.this.UserList.getModel().getSize()) {
                    CUser user3 = ((CUserListModel)CUserListPanel.this.UserList.getModel()).getUser(row2);
                    CUserListPanel.this.mwclient.getMainFrame().jMenuFileMail_actionPerformed(null, user3.getName());
                }
                return;
            }
            if (command.equals("MO") && st.hasMoreElements()) {
                command = st.nextToken();
                int row3 = Integer.parseInt(command);
                if (row3 > -1 && row3 < CUserListPanel.this.UserList.getModel().getSize()) {
                    CUser user4 = ((CUserListModel)CUserListPanel.this.UserList.getModel()).getUser(row3);
                    CUserListPanel.this.mwclient.getMainFrame().jMenuCommanderSendMoney_actionPerformed(null, user4.getName());
                }
                return;
            }
            if (command.equals("TU") && st.hasMoreElements()) {
                command = st.nextToken();
                int row4 = Integer.parseInt(command);
                if (row4 > -1 && row4 < CUserListPanel.this.UserList.getModel().getSize()) {
                    CUser user5 = ((CUserListModel)CUserListPanel.this.UserList.getModel()).getUser(row4);
                    CUserListPanel.this.mwclient.getMainFrame().jMenuCommanderSendMek_actionPerformed(null, user5.getName(), -1);
                }
                return;
            }
            if (command.equals("TP") && st.hasMoreElements()) {
                command = st.nextToken();
                int row5 = Integer.parseInt(command);
                if (row5 > -1 && row5 < CUserListPanel.this.UserList.getModel().getSize()) {
                    CUser user6 = ((CUserListModel)CUserListPanel.this.UserList.getModel()).getUser(row5);
                    CUserListPanel.this.mwclient.getMainFrame().jMenuCommanderTransferPilot_actionPerformed(null, user6.getName());
                }
                return;
            }
            if (command.equals("DSU") && st.hasMoreElements()) {
                command = st.nextToken();
                int row6 = Integer.parseInt(command);
                if (row6 > -1 && row6 < CUserListPanel.this.UserList.getModel().getSize()) {
                    CUser user7 = ((CUserListModel)CUserListPanel.this.UserList.getModel()).getUser(row6);
                    CUserListPanel.this.mwclient.getMainFrame().jMenuCommanderDirectSell_actionPerformed(null, user7.getName(), null);
                }
                return;
            }
            if (command.equals("MU") && st.hasMoreElements()) {
                command = st.nextToken();
                row = Integer.parseInt(command);
                mode = st.nextToken();
                if (row > -1 && row < CUserListPanel.this.UserList.getModel().getSize()) {
                    user2 = ((CUserListModel)CUserListPanel.this.UserList.getModel()).getUser(row);
                    searchString = user2.getName();
                    ignoreList = CUserListPanel.this.mwclient.getConfig().getParam("IGNORE" + mode);
                    newList = "";
                    it = new StringTokenizer(ignoreList, ",");
                    boolean matched = false;
                    while (it.hasMoreTokens() && !matched) {
                        String currString = it.nextToken();
                        newList = newList + currString + ",";
                        if (!currString.equals(searchString)) continue;
                        matched = true;
                    }
                    if (!matched) {
                        newList = newList + searchString + ",";
                    }
                    CUserListPanel.this.mwclient.getConfig().setParam("IGNORE" + mode, newList);
                    CUserListPanel.this.mwclient.setIgnorePublic();
                    CUserListPanel.this.mwclient.getConfig().saveConfig();
                    String toUser = "CH|CLIENT: You muted " + searchString + " (" + mode + ").";
                    CUserListPanel.this.mwclient.doParseDataInput(toUser);
                    CUserListPanel.this.UserList.repaint();
                }
            }
            if (command.equals("UMU") && st.hasMoreElements()) {
                command = st.nextToken();
                row = Integer.parseInt(command);
                mode = st.nextToken();
                if (row > -1 && row < CUserListPanel.this.UserList.getModel().getSize()) {
                    user2 = ((CUserListModel)CUserListPanel.this.UserList.getModel()).getUser(row);
                    searchString = user2.getName();
                    ignoreList = CUserListPanel.this.mwclient.getConfig().getParam("IGNORE" + mode);
                    newList = "";
                    it = new StringTokenizer(ignoreList, ",");
                    while (it.hasMoreTokens()) {
                        String currString = it.nextToken();
                        if (currString.equals(searchString)) continue;
                        newList = newList + currString + ",";
                    }
                    CUserListPanel.this.mwclient.getConfig().setParam("IGNORE" + mode, newList);
                    CUserListPanel.this.mwclient.setIgnorePublic();
                    CUserListPanel.this.mwclient.getConfig().saveConfig();
                    String toUser = "CH|CLIENT: You unmuted " + searchString + " (" + mode + ").";
                    CUserListPanel.this.mwclient.doParseDataInput(toUser);
                    CUserListPanel.this.UserList.repaint();
                }
            }
            if (command.equals("RNP") && st.hasMoreElements() && (row = Integer.parseInt(command = st.nextToken())) > -1 && row < CUserListPanel.this.UserList.getModel().getSize()) {
                user = ((CUserListModel)CUserListPanel.this.UserList.getModel()).getUser(row);
                CUserListPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c noplay#remove#" + user.getName());
            }
            if (command.equals("ANP") && st.hasMoreElements() && (row = Integer.parseInt(command = st.nextToken())) > -1 && row < CUserListPanel.this.UserList.getModel().getSize()) {
                user = ((CUserListModel)CUserListPanel.this.UserList.getModel()).getUser(row);
                CUserListPanel.this.mwclient.sendChat(MWClient.CAMPAIGN_PREFIX + "c noplay#add#" + user.getName());
            }
            if (command.equals("SM") && st.hasMoreElements()) {
                command = st.nextToken();
                if (command.equals("N")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortMode(SORTMODE_NAME);
                } else if (command.equals("H")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortMode(SORTMODE_HOUSE);
                } else if (command.equals("E")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortMode(SORTMODE_EXP);
                } else if (command.equals("R")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortMode(SORTMODE_RATING);
                } else if (command.equals("S")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortMode(SORTMODE_STATUS);
                } else if (command.equals("L")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortMode(SORTMODE_USERLEVEL);
                } else if (command.equals("C")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortMode(SORTMODE_COUNTRY);
                }
                if (command.equals("H")) {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTMODE", "HOUSE");
                } else if (command.equals("E")) {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTMODE", "EXP");
                } else if (command.equals("R")) {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTMODE", "RATING");
                } else if (command.equals("S")) {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTMODE", "STATUS");
                } else if (command.equals("L")) {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTMODE", "USERLEVEL");
                } else if (command.equals("C")) {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTMODE", "COUNTRY");
                } else {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTMODE", "NAME");
                }
                CUserListPanel.this.mwclient.getConfig().saveConfig();
                return;
            }
            if (command.equals("SO") && st.hasMoreElements()) {
                command = st.nextToken();
                if (command.equals("A")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortOrder(SORTORDER_ASCENDING);
                }
                if (command.equals("D")) {
                    ((CUserListModel)CUserListPanel.this.UserList.getModel()).setSortOrder(SORTORDER_DESCENDING);
                }
                if (command.equals("D")) {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTORDER", "DESCENDING");
                } else {
                    CUserListPanel.this.mwclient.getConfig().setParam("SORTORDER", "ASCENDING");
                }
                CUserListPanel.this.mwclient.getConfig().saveConfig();
                return;
            }
            if (command.equals("TD")) {
                boolean bl = CUserListPanel.this.Dedicateds = !CUserListPanel.this.Dedicateds;
                if (CUserListPanel.this.Dedicateds) {
                    CUserListPanel.this.mwclient.getConfig().setParam("USERLISTDEDICATEDS", "YES");
                } else {
                    CUserListPanel.this.mwclient.getConfig().setParam("USERLISTDEDICATEDS", "NO");
                }
                ((CUserListModel)CUserListPanel.this.UserList.getModel()).setDedicateds(CUserListPanel.this.Dedicateds);
                CUserListPanel.this.refresh();
                CUserListPanel.this.mwclient.getConfig().saveConfig();
            } else if (command.equals("ULC") && st.hasMoreElements()) {
                command = st.nextToken();
                CUserListPanel.this.mwclient.getConfig().setParam("USERLISTCOLOR", command);
                CUserListPanel.this.Users.getRenderer().refreshParams();
                CUserListPanel.this.UserList.repaint();
                CUserListPanel.this.mwclient.getConfig().saveConfig();
            } else if (command.equals("ULI") && st.hasMoreElements()) {
                command = st.nextToken();
                CUserListPanel.this.mwclient.getConfig().setParam("USERLISTIMAGE", command);
                CUserListPanel.this.Users.getRenderer().refreshParams();
                CUserListPanel.this.UserList.repaint();
                CUserListPanel.this.mwclient.getConfig().saveConfig();
            } else if (command.equals("ULB") && st.hasMoreElements()) {
                command = st.nextToken();
                CUserListPanel.this.mwclient.getConfig().setParam("USERLISTBOLD", command);
                CUserListPanel.this.Users.getRenderer().refreshParams();
                CUserListPanel.this.UserList.repaint();
                CUserListPanel.this.mwclient.getConfig().saveConfig();
            } else if (command.equals("ULN") && st.hasMoreElements()) {
                command = st.nextToken();
                CUserListPanel.this.mwclient.getConfig().setParam("USERLISTCOUNT", command);
                CUserListPanel.this.CountLabel.setVisible(Boolean.valueOf(command));
                CUserListPanel.this.repaint();
                CUserListPanel.this.mwclient.getConfig().saveConfig();
            } else if (command.equals("ULA") && st.hasMoreElements()) {
                command = st.nextToken();
                CUserListPanel.this.mwclient.getConfig().setParam("USERLISTACTIVITYBTN", command);
                CUserListPanel.this.ActivityButton.setVisible(Boolean.valueOf(command));
                CUserListPanel.this.repaint();
                CUserListPanel.this.mwclient.getConfig().saveConfig();
            }
        }
    }
}

