/*
 * Decompiled with CFR 0.152.
 */
package client.gui;

import client.MWClient;
import client.gui.CMapPanel;
import common.House;
import common.Planet;
import common.util.StringConverter;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

class PlanetPanel
extends JPanel {
    private CMapPanel map;
    private MWClient mwclient;
    private Planet planet;
    private JLabel name;
    private JLabel position;
    private JLabel influence;
    private JLabel terrain;
    private JLabel unitFactories;
    private JLabel warefaction;

    PlanetPanel(CMapPanel panel, MWClient client) {
        this.mwclient = client;
        this.setForeground(Color.WHITE);
        this.map = panel;
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.name = new WhiteLabel("Name: ???");
        this.add(this.name);
        this.influence = new WhiteLabel("Owner: ???");
        this.add(this.influence);
        this.unitFactories = new WhiteLabel("Factories: ???");
        this.setOpaque(false);
        this.add(this.unitFactories);
    }

    void update(Planet planet) {
        this.planet = planet;
        this.name.setText("Name: " + planet.getName());
        StringBuffer sb = new StringBuffer("<html><body>Owner: ");
        Integer houseID = planet.getInfluence().getOwner();
        House faction = null;
        if (houseID != null) {
            faction = this.mwclient.getData().getHouse(houseID);
        }
        Color c = Color.GRAY;
        String planetOwner = "Disputed";
        if (faction == null || planet.getInfluence().getInfluence(faction.getId()) < this.mwclient.getMinPlanetOwnerShip(planet)) {
            c = StringConverter.html2Color(this.mwclient.getserverConfigs("DisputedPlanetColor"));
            planetOwner = "Disputed";
        } else {
            c = StringConverter.html2Color(faction.getHouseColor());
            planetOwner = faction.getName();
        }
        sb.append("<font color=");
        sb.append(StringConverter.color2html(this.map.getMap().adjustColor(c)) + ">");
        sb.append("<b>" + planetOwner + "</b></font></body></html>");
        this.influence.setText(sb.toString());
        this.unitFactories.setText("Factories: " + planet.getFactoryCount());
        this.map.getMapControl().setBounds(0, 0, 2000, 2000);
    }

    public Planet getPlanet() {
        return this.planet;
    }

    public void setPlanet(Planet planet) {
        this.planet = planet;
    }

    private class WhiteLabel
    extends JLabel {
        WhiteLabel(String name) {
            super(name);
            this.setOpaque(false);
            this.setForeground(Color.WHITE);
        }
    }
}

