/*
 * Decompiled with CFR 0.152.
 */
package client.gui.dialog;

import client.MWClient;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import megamek.common.CriticalSlot;
import megamek.common.Entity;
import megamek.common.Mech;
import megamek.common.Mounted;

public final class AdvanceRepairDialog
implements ActionListener,
MouseListener {
    private MWClient mwclient = null;
    private Entity unit = null;
    private static final String okayCommand = "Add";
    private static final String cancelCommand = "Close";
    private static final String removeCommand = "Remove";
    private static final String traitCommand = "BannedAmmo";
    private static final String factionCommand = "Faction";
    private String windowName = "Repair Dialog";
    private static final String delimiter = "*";
    private int critLocation = -1;
    private int critSlot = -1;
    private boolean armor = false;
    private final JButton okayButton = new JButton("Repair");
    private final JButton cancelButton = new JButton("Close");
    private JDialog dialog;
    private JOptionPane pane;
    JTabbedPane ConfigPane = new JTabbedPane(1);

    public AdvanceRepairDialog(MWClient c, Entity unit) {
        this.mwclient = c;
        this.unit = unit;
        this.windowName = unit.getShortNameRaw() + " Repair Dialog";
        this.okayButton.setActionCommand(okayCommand);
        this.cancelButton.setActionCommand(cancelCommand);
        this.okayButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.okayButton.setToolTipText("Save");
        this.cancelButton.setToolTipText("Exit without saving changes");
        this.ConfigPane = new JTabbedPane();
        this.ConfigPane.addMouseListener(this);
        this.loadPanel();
        Object[] options = new Object[]{this.okayButton, this.cancelButton};
        this.pane = new JOptionPane(this.ConfigPane, -1, -1, null, options, null);
        this.dialog = this.pane.createDialog(this.ConfigPane, this.windowName);
        this.dialog.getRootPane().setDefaultButton(this.cancelButton);
        this.dialog.setModal(true);
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (command.equals(okayCommand)) {
            if (this.critLocation < 0 || this.critSlot < 0) {
                JOptionPane.showMessageDialog(null, "Invaild location/Slot please try again");
                return;
            }
            this.mwclient.sendChat("/c repairunit#" + this.unit.getExternalId() + "#" + this.critLocation + "#" + this.critSlot + "#" + this.armor);
            this.dialog.dispose();
            return;
        }
        if (command.equals(cancelCommand)) {
            this.dialog.dispose();
        }
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent arg0) {
        this.critLocation = this.ConfigPane.getSelectedIndex();
        if (arg0.getComponent() instanceof JList) {
            JList templist = (JList)arg0.getComponent();
            this.critSlot = templist.getSelectedIndex();
            if (this.critLocation == 1 || this.critLocation == 3 || this.critLocation == 2) {
                if (this.critSlot == 0) {
                    this.armor = true;
                } else if (this.critSlot == 1) {
                    this.armor = true;
                    if (this.critLocation == 1) {
                        this.critLocation = 10;
                    } else if (this.critLocation == 3) {
                        this.critLocation = 8;
                    } else if (this.critLocation == 2) {
                        this.critLocation = 9;
                    }
                    this.critSlot = 0;
                } else if (this.critSlot == 2) {
                    this.armor = true;
                } else {
                    this.critSlot -= 3;
                }
            } else if (this.critSlot == 0) {
                this.armor = true;
            } else if (this.critSlot == 1) {
                this.armor = true;
            } else {
                this.critSlot -= 2;
            }
        }
    }

    public void mouseReleased(MouseEvent arg0) {
    }

    private void loadPanel() {
        this.ConfigPane.removeAll();
        JPanel mainPanel = new JPanel();
        mainPanel.addMouseListener(this);
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        for (int x = 0; x < this.unit.locations(); ++x) {
            JPanel locationPanel = new JPanel();
            locationPanel.addMouseListener(this);
            Vector<String> critNames = new Vector<String>();
            boolean damaged = false;
            critNames.add("Armor: " + this.unit.getArmor(x) + "/" + this.unit.getOArmor(x));
            if (this.unit.getArmor(x) != this.unit.getOArmor(x)) {
                damaged = true;
            }
            if (x == 1 || x == 3 || x == 2) {
                critNames.add("Armor(r): " + this.unit.getArmor(x, true) + "/" + this.unit.getOArmor(x, true));
                if (this.unit.getArmor(x, true) != this.unit.getOArmor(x, true)) {
                    damaged = true;
                }
            }
            critNames.add("Internal: " + this.unit.getInternal(x) + "/" + this.unit.getOInternal(x));
            if (this.unit.getInternal(x) != this.unit.getOInternal(x)) {
                damaged = true;
            }
            for (int y = 0; y < this.unit.getNumberOfCriticals(x); ++y) {
                CriticalSlot cs = this.unit.getCritical(x, y);
                if (cs == null) {
                    critNames.add("-- Empty --");
                    continue;
                }
                if (cs.getType() == 0) {
                    String result = "";
                    if (cs.isDamaged()) {
                        result = result + "* ";
                        damaged = true;
                    } else if (cs.isBreached()) {
                        result = result + "x ";
                        damaged = true;
                    } else if (cs.isRepairing()) {
                        result = result + "! ";
                    }
                    if (!(this.unit instanceof Mech)) continue;
                    critNames.add(result + ((Mech)this.unit).getSystemName(cs.getIndex()));
                    continue;
                }
                if (cs.getType() != 1) continue;
                Mounted m = this.unit.getEquipment(cs.getIndex());
                if (cs.isRepairing()) {
                    critNames.add("! " + m.getDesc());
                } else {
                    critNames.add(m.getDesc());
                }
                if (!cs.isBreached() && !cs.isDamaged()) continue;
                damaged = true;
            }
            JList CriticalSlotList = new JList(critNames);
            CriticalSlotList.addMouseListener(this);
            CriticalSlotList.setVisibleRowCount(critNames.size());
            CriticalSlotList.setSelectionMode(0);
            locationPanel.add(CriticalSlotList);
            mainPanel.add(locationPanel);
            this.ConfigPane.addTab((damaged ? delimiter : "") + this.unit.getLocationName(x), null, locationPanel, this.unit.getLocationName(x));
            if (!damaged) continue;
            this.ConfigPane.setForegroundAt(this.ConfigPane.getTabCount() - 1, Color.red);
        }
    }
}

